/*
 * Decompiled with CFR 0.152.
 */
package isc.org.apache.oro.text;

import isc.org.apache.oro.text.regex.MalformedPatternException;
import isc.org.apache.oro.text.regex.Pattern;
import isc.org.apache.oro.text.regex.PatternCompiler;
import isc.org.apache.oro.text.regex.Perl5Compiler;

public final class GlobCompiler
implements PatternCompiler {
    public static final int DEFAULT_MASK = 0;
    public static final int CASE_INSENSITIVE_MASK = 1;
    public static final int STAR_CANNOT_MATCH_NULL_MASK = 2;
    public static final int QUESTION_MATCHES_ZERO_OR_ONE_MASK = 4;
    public static final int READ_ONLY_MASK = 8;
    private Perl5Compiler __perl5Compiler = new Perl5Compiler();

    private static boolean __isPerl5MetaCharacter(char c) {
        return c == '*' || c == '?' || c == '+' || c == '[' || c == ']' || c == '(' || c == ')' || c == '|' || c == '^' || c == '$' || c == '.' || c == '{' || c == '}' || c == '\\';
    }

    private static boolean __isGlobMetaCharacter(char c) {
        return c == '*' || c == '?' || c == '[' || c == ']';
    }

    public static String globToPerl5(char[] cArray, int n) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(2 * cArray.length);
        boolean bl2 = false;
        boolean bl3 = (n & 4) != 0;
        bl = (n & 2) != 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            block0 : switch (cArray[n2]) {
                case '*': {
                    if (bl2) {
                        stringBuffer.append('*');
                        break;
                    }
                    if (bl) {
                        stringBuffer.append(".+");
                        break;
                    }
                    stringBuffer.append(".*");
                    break;
                }
                case '?': {
                    if (bl2) {
                        stringBuffer.append('?');
                        break;
                    }
                    if (bl3) {
                        stringBuffer.append(".?");
                        break;
                    }
                    stringBuffer.append('.');
                    break;
                }
                case '[': {
                    bl2 = true;
                    stringBuffer.append(cArray[n2]);
                    if (n2 + 1 >= cArray.length) break;
                    switch (cArray[n2 + 1]) {
                        case '!': 
                        case '^': {
                            stringBuffer.append('^');
                            ++n2;
                            break block0;
                        }
                        case ']': {
                            stringBuffer.append(']');
                            ++n2;
                            break block0;
                        }
                    }
                    break;
                }
                case ']': {
                    bl2 = false;
                    stringBuffer.append(cArray[n2]);
                    break;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    if (n2 == cArray.length - 1) {
                        stringBuffer.append('\\');
                        break;
                    }
                    if (GlobCompiler.__isGlobMetaCharacter(cArray[n2 + 1])) {
                        stringBuffer.append(cArray[++n2]);
                        break;
                    }
                    stringBuffer.append('\\');
                    break;
                }
                default: {
                    if (!bl2 && GlobCompiler.__isPerl5MetaCharacter(cArray[n2])) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(cArray[n2]);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public Pattern compile(char[] cArray, int n) throws MalformedPatternException {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 8) != 0) {
            n2 |= 0x8000;
        }
        return this.__perl5Compiler.compile(GlobCompiler.globToPerl5(cArray, n), n2);
    }

    public Pattern compile(char[] cArray) throws MalformedPatternException {
        return this.compile(cArray, 0);
    }

    public Pattern compile(String string) throws MalformedPatternException {
        return this.compile(string.toCharArray(), 0);
    }

    public Pattern compile(String string, int n) throws MalformedPatternException {
        return this.compile(string.toCharArray(), n);
    }
}

