/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTable;
import com.isomorphic.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class GenericSQLDriver
extends SQLDriver {
    private static Logger log = new Logger(GenericSQLDriver.class.getName());

    public GenericSQLDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
        this.init(dbName);
    }

    public GenericSQLDriver(String dbName) throws Exception {
        super(dbName, null);
        this.init(dbName);
    }

    public static SQLDriver instance(String dbName, SQLTable table) throws Exception {
        return new GenericSQLDriver(dbName, table);
    }

    public static SQLDriver instance(String dbName) throws Exception {
        return new GenericSQLDriver(dbName);
    }

    public void init(String dbName) throws Exception {
    }

    public boolean supportsNativeReplace() {
        return false;
    }

    public boolean supportsSQLLimit() {
        return false;
    }

    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        if (sequencesNotPresent.size() > 0) {
            throw new Exception("GenericSQLDriver does not support sequences");
        }
        return primaryKeysPresent;
    }

    public String formatValue(Object value) {
        return value.toString();
    }

    public String sqlInTransform(Object value, DSField field, SQLDataSource ds) {
        if (value instanceof Date && (field == null || field.get((Object)"sqlStorageStrategy") == null)) {
            boolean convertToUTC;
            long timeStamp = ((Date)value).getTime();
            String dateTime = this.formatTimestamp(timeStamp, convertToUTC = field != null && "datetime".equals(field.getType()), ds, field);
            int periodIndex = dateTime.lastIndexOf(".");
            if (periodIndex != -1) {
                dateTime = dateTime.substring(0, periodIndex);
            }
            String format = config.getString((Object)"sql.defaultDateTimeFormat");
            return "TO_DATE(" + this.escapeValue(dateTime) + ",'" + format + "')";
        }
        return super.sqlInTransform(value, field, ds);
    }

    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        String output = this.escapeColumnName(columnName);
        if (remapName != null && !columnName.equals(remapName)) {
            output = output + " AS " + this.escapeColumnName(remapName);
        }
        if (tableName != null) {
            output = tableName + "." + output;
        }
        return output;
    }

    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeValueUnquoted(value.toString(), false) + "'";
    }

    public String escapeValueForFilter(Object value, String filterStyle) {
        if (value == null) {
            return null;
        }
        String rtn = "'";
        if (!"startsWith".equals(filterStyle)) {
            rtn = rtn + "%";
        }
        return rtn + this.escapeValueUnquoted(value, true) + "%'";
    }

    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = globalPerl.substitute("s/'/''/g", value.toString());
        if (escapeForFilter) {
            escaped = globalPerl.substitute("s'\\\\'\\\\'g", escaped);
            escaped = globalPerl.substitute("s'%'\\%'g", escaped);
            escaped = globalPerl.substitute("s'_'\\_'g", escaped);
        }
        return escaped;
    }

    public String getNextSequenceValue(String columnName, SQLDataSource ds) throws Exception {
        throw new Exception("GenericSQLDriver does not support sequences");
    }

    public String getCurrentSequenceValue(String columnName) throws Exception {
        throw new Exception("GenericSQLDriver does not support sequences");
    }

    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        if (config.getBoolean((Object)("sql." + this.dbName + ".useCaseForSortBy"), false)) {
            return column;
        }
        String expr = "CASE " + column;
        for (String actualValue : valueMap.keySet()) {
            String displayValue = this.getLocalizedDisplayValue(valueMap.get(actualValue), request);
            displayValue = this.escapeValue(displayValue);
            expr = expr + " WHEN '" + actualValue + "' THEN " + displayValue;
        }
        expr = expr + " ELSE " + column + " END";
        return expr;
    }

    public InputStream handleInputStream(InputStream in) throws Exception {
        if (config.getBoolean((Object)"sql.generic.read.inputstreams.early", false)) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            IOUtil.copyStreams((InputStream)in, (OutputStream)os);
            return new ByteArrayInputStream(os.toByteArray());
        }
        return in;
    }

    public String getNaturalDatabaseObjectName(String objectName) {
        return objectName;
    }

    public String getDummyQuery() {
        return "SELECT 1 FROM dual";
    }
}

