/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.datasource.DSFileSpec;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.js.IToJSON;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.Screen;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project
implements IToJSON {
    private static Config config = Config.getGlobal();
    private static Logger log = new Logger(Project.class.getName());
    private static String storageDS = config.getString("project.vbProjectsDS");
    private static String fileType = "proj";
    private static String fileFormat = "xml";
    DataTypeMap data;
    DataTypeMap metadata;

    public Project(String xml, Map metadata) throws Exception {
        this(Project.dataFromXML(xml), metadata);
    }

    public Project(Map data, Map metadata) {
        this.data = new DataTypeMap(data);
        this.metadata = metadata == null ? new DataTypeMap() : new DataTypeMap(metadata);
    }

    private static Map dataFromXML(String xml) throws Exception {
        return (Map)XML.toDSRecords(new StringReader(xml));
    }

    public static Project load(String name) throws Exception {
        return Project.load((Object)DataTools.buildMap("fileName", name));
    }

    public static Project load(String name, String ownerId) throws Exception {
        return Project.load((Object)DataTools.buildMap("fileName", name, "ownerId", ownerId));
    }

    public static Project load(Object criteria) throws Exception {
        List<Project> resultsMatchingCriteria = Project.list(criteria);
        if (resultsMatchingCriteria.size() == 0) {
            return null;
        }
        if (resultsMatchingCriteria.size() > 1) {
            throw new Exception("Multiple Projects (" + resultsMatchingCriteria.size() + ") matched criteria for load() - expected only one.");
        }
        return resultsMatchingCriteria.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Project> list(Object criteria) throws Exception {
        if (criteria == null) {
            criteria = new HashMap();
        }
        if (criteria instanceof Map) {
            Map m = criteria;
            if (m.get("fileType") == null) {
                m.put("fileType", fileType);
            }
            if (m.get("fileFormat") == null) {
                m.put("fileFormat", fileFormat);
            }
        } else {
            AdvancedCriteria c = (AdvancedCriteria)((Object)criteria);
            if (c.getFieldValue("fileType") == null) {
                c.addCriteria("fileType", DefaultOperators.Equals, fileType);
            }
            if (c.getFieldValue("fileFormat") == null) {
                c.addCriteria("fileFormat", DefaultOperators.Equals, fileFormat);
            }
        }
        ArrayList<Project> results = new ArrayList<Project>();
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            List<Map<String, Object>> files = ds.listFiles(criteria);
            for (Map<String, Object> metadata : files) {
                String xml = ds.getFileAsString(new DSFileSpec(metadata));
                results.add(new Project(xml, metadata));
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            DataSourceManager.free(ds);
            throw throwable;
        }
        DataSourceManager.free(ds);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project persist() throws Exception {
        Project project;
        StringWriter sw = new StringWriter();
        String tagName = this.data.getString("__autoConstruct");
        if (tagName == null) {
            throw new Exception("Encountered top-level component with no _constructor: " + DataTools.prettyPrint(this));
        }
        DataSource transformDS = null;
        try {
            transformDS = DataSourceManager.get(tagName);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            DataSourceManager.free(transformDS);
            throw throwable;
        }
        DataSourceManager.free(transformDS);
        XML.recordToXML(tagName, (Map)((Object)this.data), sw, false, false, transformDS, null);
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            Map<String, Object> metadataAsSaved = ds.saveFile(new DSFileSpec((Map)((Object)this.metadata)), sw.toString());
            project = Project.load(metadataAsSaved);
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            DataSourceManager.free(ds);
            throw throwable;
        }
        DataSourceManager.free(ds);
        return project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() throws Exception {
        if (this.getName() == null) {
            throw new Exception("Cannot remove a Project that has not yet been persisted");
        }
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            ds.removeFile(new DSFileSpec((Map)((Object)this.metadata)));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            DataSourceManager.free(ds);
            throw throwable;
        }
        DataSourceManager.free(ds);
    }

    @Override
    public void toJSON(Writer out, JSTranslater jsTrans) throws UnconvertableException, IOException {
        jsTrans.toJS((Object)this.data, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project rename(String newName) throws Exception {
        Project project;
        if (this.getName() == null) {
            throw new Exception("Cannot rename a Project that has not yet been persisted");
        }
        DataSource ds = null;
        try {
            ds = DataSourceManager.get(storageDS);
            List<Map<String, Object>> renamedFiles = ds.renameFile(new DSFileSpec((Map)((Object)this.metadata)), new DSFileSpec((Map)((Object)DataTools.buildMap("fileName", newName))));
            Map<String, Object> metadataAsSaved = renamedFiles.get(0);
            project = Project.load(metadataAsSaved);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            DataSourceManager.free(ds);
            throw throwable;
        }
        DataSourceManager.free(ds);
        return project;
    }

    public String getName() {
        return this.metadata.getString("fileName");
    }

    public DataTypeMap getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map metadata) {
        this.metadata = new DataTypeMap(metadata);
    }

    public String getOwner() {
        return this.metadata.getString("ownerId");
    }

    public void setOwner(String owner) {
        this.metadata.put("ownerId", owner);
    }

    public List<String> getScreenNames() {
        return (List)this.data.xpathGetList("screens/root/children/fileName");
    }

    public List<Screen> getScreens() throws Exception {
        List<String> screenNames = this.getScreenNames();
        if (screenNames == null) {
            return null;
        }
        ArrayList<Screen> screens = new ArrayList<Screen>();
        for (String screenName : screenNames) {
            screens.add(Screen.load(screenName, this.getOwner()));
        }
        return screens;
    }

    public String getCurrentScreenName() {
        return this.data.getString("currentScreenFileName");
    }

    public void setCurrentScreenName(String currentScreenName) {
        this.data.put("currentScreenFileName", currentScreenName);
    }

    public List<String> getDataSourceNames() {
        return (List)this.data.xpathGetList("datasources/dsName");
    }
}

