/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.UpdateWithoutPKException;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.BaseRequest;
import com.isomorphic.rpc.ClientMustResubmitException;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.RestRequestParser;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.RequestTimer;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RESTHandler
extends BaseServlet {
    public static final String WRAP_JSON_RESPONSES = "wrapJSONResponses";
    public static final String JSON_PREFIX_PARAM_NAME = "jsonPrefix";
    public static final String JSON_SUFFIX_PARAM_NAME = "jsonSuffix";
    public static final String DEFAULT_DATA_FORMAT = "defaultDataFormat";
    public static final String DYNAMIC_DATA_FORMAT_PARAM_NAME = "dynamicDataFormatParamName";
    private final Logger log = new Logger(((Object)((Object)this)).getClass().getCanonicalName());
    private Boolean wrapJSONResponses;
    private String jsonPrefix;
    private String jsonSuffix;
    private String defaultDataFormat;
    private String dynamicDataFormatParamName;

    public void init() throws ServletException {
        super.init();
        this.wrapJSONResponses = Boolean.TRUE;
        String parameterWrapJSON = this.getInitParameter(WRAP_JSON_RESPONSES);
        if (parameterWrapJSON != null) {
            this.wrapJSONResponses = Boolean.valueOf(parameterWrapJSON);
        } else {
            parameterWrapJSON = this.getServletContext().getInitParameter(WRAP_JSON_RESPONSES);
            if (parameterWrapJSON != null) {
                this.wrapJSONResponses = Boolean.valueOf(parameterWrapJSON);
            }
        }
        this.log.debug("Wrapping json responses:" + this.wrapJSONResponses.toString());
        String parameterJSONPrefix = this.getInitParameter(JSON_PREFIX_PARAM_NAME);
        if (parameterJSONPrefix != null) {
            this.jsonPrefix = parameterJSONPrefix;
        } else {
            parameterJSONPrefix = this.getServletContext().getInitParameter(JSON_PREFIX_PARAM_NAME);
            if (parameterJSONPrefix != null) {
                this.jsonPrefix = parameterJSONPrefix;
            }
        }
        this.log.debug("json prefix:" + this.jsonPrefix);
        String parameterJSONSuffix = this.getInitParameter(JSON_SUFFIX_PARAM_NAME);
        if (parameterJSONSuffix != null) {
            this.jsonSuffix = parameterJSONSuffix;
        } else {
            parameterJSONSuffix = this.getServletContext().getInitParameter(JSON_SUFFIX_PARAM_NAME);
            if (parameterJSONSuffix != null) {
                this.jsonSuffix = parameterJSONSuffix;
            }
        }
        this.log.debug("json suffix:" + this.jsonSuffix);
        String parameterDefaultDataFormat = this.getInitParameter(DEFAULT_DATA_FORMAT);
        if (parameterDefaultDataFormat == null) {
            parameterDefaultDataFormat = this.getServletContext().getInitParameter(DEFAULT_DATA_FORMAT);
        }
        if (parameterDefaultDataFormat != null) {
            if ("xml".equalsIgnoreCase(parameterDefaultDataFormat) || "json".equalsIgnoreCase(parameterDefaultDataFormat)) {
                this.defaultDataFormat = parameterDefaultDataFormat.toLowerCase();
            } else {
                this.defaultDataFormat = "xml";
                this.log.warn("Specified incorrect 'defaultDataFormat':" + parameterDefaultDataFormat + ". Using default - xml");
            }
        } else {
            this.defaultDataFormat = "xml";
        }
        this.log.debug("Default response data format:" + this.defaultDataFormat);
        String dynamicDataFormatParamName = this.getInitParameter(DYNAMIC_DATA_FORMAT_PARAM_NAME);
        if (dynamicDataFormatParamName == null) {
            this.dynamicDataFormatParamName = this.getServletContext().getInitParameter(DYNAMIC_DATA_FORMAT_PARAM_NAME);
        }
        this.dynamicDataFormatParamName = dynamicDataFormatParamName != null ? dynamicDataFormatParamName : "isc_dataFormat";
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block19: {
            RPCManager rpcManager;
            String encoding = this.getServletConfig().getInitParameter("encoding");
            if (encoding == null) {
                encoding = config.getString("RPCManager.defaultCharset", "UTF-8");
            }
            if (!encoding.toLowerCase().equals("none")) {
                request.setCharacterEncoding(encoding);
                response.setContentType("application/json;charset=" + encoding);
            }
            RequestTimer requestTimer = new RequestTimer(request);
            RequestContext context = RequestContext.instance((Servlet)this, request, response);
            try {
                RestRequestParser parser = new RestRequestParser(this.defaultDataFormat, this.dynamicDataFormatParamName);
                parser.setWrapJSONResponses(this.wrapJSONResponses);
                parser.setJSONPrefix(this.jsonPrefix);
                parser.setJSONSuffix(this.jsonSuffix);
                rpcManager = new RPCManager((Servlet)this, request, response, parser);
            }
            catch (ClientMustResubmitException cmre) {
                Object var13_10 = null;
                requestTimer.stop();
                try {
                    response.flushBuffer();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            this.log.info("Performing " + rpcManager.requestCount() + " operation(s)");
            for (BaseRequest requestObject : rpcManager.getRequests()) {
                if (!(requestObject instanceof DSRequest)) continue;
                DSRequest dsRequest = (DSRequest)requestObject;
                try {
                    rpcManager.send(dsRequest, this.handleDSRequest(dsRequest, rpcManager, context));
                }
                catch (Exception e) {
                    Logger.observeThread();
                    try {
                        this.log.error((Object)("Error executing operation: " + dsRequest.getOperation()), e);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    rpcManager.sendFailure((Object)dsRequest, e);
                }
            }
            Object var13_11 = null;
            requestTimer.stop();
            try {
                response.flushBuffer();
            }
            catch (IOException iOException) {}
            break block19;
            {
                catch (Throwable e) {
                    this.handleError(response, e);
                    Object var13_12 = null;
                    requestTimer.stop();
                    try {
                        response.flushBuffer();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                requestTimer.stop();
                try {
                    response.flushBuffer();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public DSResponse handleDSRequest(DSRequest dsRequest, RPCManager rpc, RequestContext context) throws Exception {
        try {
            return dsRequest.execute();
        }
        catch (UpdateWithoutPKException updateWithoutPKException) {
            return this.generateFailureResponse(dsRequest, updateWithoutPKException, -9);
        }
        catch (Exception exception) {
            return this.generateFailureResponse(dsRequest, exception, -1);
        }
    }

    private DSResponse generateFailureResponse(DSRequest dsRequest, Exception exception, int status) throws Exception {
        RequestContext.staticLog.warn((Object)"dsRequest.execute() failed: ", exception);
        DataSource dataSource = dsRequest.getDataSource();
        DSResponse dsResponse = new DSResponse(dataSource);
        dsResponse.setData(exception.getMessage());
        dsResponse.setStatus(status);
        return dsResponse;
    }
}

