/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.base.Config;
import com.isomorphic.log.Logger;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.util.List;

public class RegexRule {
    private static Logger log = new Logger(RegexRule.class.getName());
    private static String testPath = "justTesting";
    private static List validActions = Config.getGlobal().getList("RegexRules.validActions");
    private Perl5Util regex = new Perl5Util();
    public String rule;
    public String regexRule;
    public String action;
    public String location;

    public RegexRule(String rule) throws Exception {
        this(rule, "[not specified]");
    }

    public RegexRule(String rule, String location) throws Exception {
        this.location = location;
        this.rule = rule;
        int colonIndex = rule.indexOf(":");
        if (colonIndex == -1) {
            throw new Exception("Malfromed rule: " + this.toString() + " - expected format is action:regex");
        }
        this.action = rule.substring(0, colonIndex);
        this.regexRule = rule.substring(colonIndex + 1, rule.length());
        if (validActions == null) {
            throw new Exception("Unable to initialize list of valid regex actions - please set RegexRules.validActions in server.properties to a comma-delimited list of names");
        }
        if (!validActions.contains(this.action)) {
            throw new Exception("Malformed rule: " + this.toString() + " - action: " + this.action + " is invalid - valid actions are: " + validActions.toString());
        }
        try {
            this.match(this.regexRule, testPath);
        }
        catch (Exception e) {
            log.error((Object)("Syntax error in rule: " + this.toString()), e);
        }
    }

    public boolean match(String comparePath) throws Exception {
        return this.match(this.regexRule, comparePath);
    }

    private boolean match(String regexRule, String comparePath) {
        return this.regex.match(regexRule, comparePath);
    }

    public String getRule() {
        return this.rule;
    }

    public String getAction() {
        return this.action;
    }

    public String getRegexRule() {
        return this.regexRule;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return this.rule + " located in: " + this.location;
    }
}

