/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util.date;

import com.isomorphic.log.Logger;
import com.isomorphic.util.date.Period;
import com.isomorphic.util.date.RelativeDate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DateUtil {
    private static final Logger log = new Logger(DateUtil.class);

    private DateUtil() {
        throw new UnsupportedOperationException();
    }

    public static GregorianCalendar dateAdd(GregorianCalendar date, String unit, int amount, int multiplier, boolean isLogicalDate) {
        boolean boundary;
        Period period = Period.parse(unit, Period.DAY);
        date.add(period.getCalendarField(), period.getModifier() * amount * multiplier);
        boolean bl = boundary = unit.length() < 3 && StringUtils.isAllUpperCase((String)unit);
        if (boundary) {
            if (multiplier > 0) {
                return DateUtil.getEndOf(date, period, isLogicalDate);
            }
            return DateUtil.getStartOf(date, period, isLogicalDate);
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(date.getTimeInMillis());
        return calendar;
    }

    public static GregorianCalendar getStartOf(GregorianCalendar date, Period period, boolean logicalDate) {
        return DateUtil.getStartOf(date, period, logicalDate, Calendar.getInstance().getFirstDayOfWeek());
    }

    public static GregorianCalendar getStartOf(GregorianCalendar date, Period period, boolean logicalDate, int firstDayOfWeek) {
        if (logicalDate && period.isDateTimePeriod()) {
            log.info("DateUtil.getStartOf() passed period:" + (Object)((Object)period) + " for logical date. Ignoring");
            GregorianCalendar newDate = new GregorianCalendar();
            newDate.setTime(date.getTime());
            return newDate;
        }
        int month = date.get(2);
        int dateVal = date.get(5);
        int year = date.get(1);
        int hours = date.get(11);
        int minutes = date.get(12);
        int seconds = date.get(13);
        int dayOfWeek = date.get(7);
        switch (period) {
            case SECOND: {
                return new GregorianCalendar(year, month, dateVal, hours, minutes, seconds);
            }
            case MINUTE: {
                return new GregorianCalendar(year, month, dateVal, hours, minutes, 0);
            }
            case HOUR: {
                return new GregorianCalendar(year, month, dateVal, hours, 0, 0);
            }
            case DAY: {
                if (logicalDate) {
                    return new GregorianCalendar(year, month, dateVal);
                }
                return new GregorianCalendar(year, month, dateVal, 0, 0, 0);
            }
            case WEEK: {
                if (logicalDate) {
                    return new GregorianCalendar(year, month, dateVal);
                }
                int delta = firstDayOfWeek - dayOfWeek;
                GregorianCalendar newDate = new GregorianCalendar(year, month, dateVal, 0, 0, 0);
                newDate.setTimeInMillis(newDate.getTimeInMillis() + (long)(delta * 86400000));
                return newDate;
            }
            case MONTH: {
                if (logicalDate) {
                    return new GregorianCalendar(year, month, 1);
                }
                return new GregorianCalendar(year, month, 1, 0, 0, 0);
            }
            case QUARTER: {
                int quarterStart = month - month % 3;
                if (logicalDate) {
                    return new GregorianCalendar(year, quarterStart, 1);
                }
                return new GregorianCalendar(year, quarterStart, 1, 0, 0, 0);
            }
            case YEAR: {
                if (logicalDate) {
                    return new GregorianCalendar(year, 0, 1);
                }
                return new GregorianCalendar(year, 0, 1, 0, 0, 0);
            }
            case DECADE: {
                int decade = year - year % 10;
                if (logicalDate) {
                    return new GregorianCalendar(decade, 0, 1);
                }
                return new GregorianCalendar(decade, 0, 1, 0, 0, 0);
            }
            case CENTURY: {
                int century = year - year % 100;
                if (logicalDate) {
                    return new GregorianCalendar(century, 0, 1);
                }
                return new GregorianCalendar(century, 0, 1, 0, 0, 0);
            }
        }
        GregorianCalendar theDate = new GregorianCalendar();
        theDate.setTime(date.getTime());
        return theDate;
    }

    public static GregorianCalendar getEndOf(GregorianCalendar date, Period period, boolean logicalDate) {
        return DateUtil.getEndOf(date, period, logicalDate, Calendar.getInstance().getFirstDayOfWeek());
    }

    public static GregorianCalendar getEndOf(GregorianCalendar date, Period period, boolean logicalDate, int firstDayOfWeek) {
        if (logicalDate && period.isDateTimePeriod()) {
            log.info("DateUtil.getEndOf() passed period:" + (Object)((Object)period) + " for logical date. Ignoring");
            GregorianCalendar newDate = new GregorianCalendar();
            newDate.setTime(date.getTime());
            return newDate;
        }
        int month = date.get(2);
        int dateVal = date.get(5);
        int year = date.get(1);
        int hours = date.get(11);
        int minutes = date.get(12);
        int seconds = date.get(13);
        int dayOfWeek = date.get(7);
        switch (period) {
            case SECOND: {
                GregorianCalendar calendar = new GregorianCalendar(year, month, dateVal, hours, minutes, seconds);
                calendar.set(14, 999);
                return calendar;
            }
            case MINUTE: {
                GregorianCalendar calendar = new GregorianCalendar(year, month, dateVal, hours, minutes, 59);
                calendar.set(14, 999);
                return calendar;
            }
            case HOUR: {
                GregorianCalendar calendar = new GregorianCalendar(year, month, dateVal, hours, 59, 59);
                calendar.set(14, 999);
                return calendar;
            }
            case DAY: {
                if (logicalDate) {
                    return new GregorianCalendar(year, month, dateVal);
                }
                GregorianCalendar calendar = new GregorianCalendar(year, month, dateVal, 23, 59, 59);
                calendar.set(14, 999);
                return calendar;
            }
            case WEEK: {
                int delta = 6 - (dayOfWeek - firstDayOfWeek);
                if (delta >= 7) {
                    delta -= 7;
                }
                int endDate = dateVal + delta;
                if (logicalDate) {
                    return new GregorianCalendar(year, month, endDate);
                }
                GregorianCalendar calendar = new GregorianCalendar(year, month, endDate, 23, 59, 59);
                calendar.set(14, 999);
                return calendar;
            }
            case MONTH: {
                if (logicalDate) {
                    GregorianCalendar calendar = new GregorianCalendar(year, month + 1, 1);
                    calendar.add(5, -1);
                    return calendar;
                }
                GregorianCalendar calendar = new GregorianCalendar(year, month + 1, 1, 0, 0, 0);
                calendar.add(14, -1);
                return calendar;
            }
            case QUARTER: {
                int nextQ = month + 3 - month % 3;
                if (logicalDate) {
                    GregorianCalendar calendar = new GregorianCalendar(year, nextQ, 1);
                    calendar.add(5, -1);
                    return calendar;
                }
                GregorianCalendar calendar = new GregorianCalendar(year, nextQ, 1);
                calendar.add(14, -1);
                return calendar;
            }
            case YEAR: {
                if (logicalDate) {
                    return new GregorianCalendar(year, 11, 31);
                }
                GregorianCalendar gregorianCalendar = new GregorianCalendar(year, 11, 31, 23, 59, 59);
                gregorianCalendar.set(14, 999);
                return gregorianCalendar;
            }
            case DECADE: {
                int decade = year + 10 - year % 10;
                if (logicalDate) {
                    return new GregorianCalendar(decade, 11, 31);
                }
                GregorianCalendar gregorianCalendar = new GregorianCalendar(decade, 11, 31, 23, 59, 59);
                gregorianCalendar.set(14, 999);
                return gregorianCalendar;
            }
            case CENTURY: {
                int century = year + 100 - year % 100;
                if (logicalDate) {
                    return new GregorianCalendar(century, 11, 31);
                }
                GregorianCalendar calendar = new GregorianCalendar(century, 11, 31, 23, 59, 59);
                calendar.set(14, 999);
                return calendar;
            }
        }
        GregorianCalendar theDate = new GregorianCalendar();
        theDate.setTime(date.getTime());
        return theDate;
    }

    public static GregorianCalendar getAbsoluteDate(RelativeDate relativeDate, boolean isLogicalDate) {
        return DateUtil.getAbsoluteDate(relativeDate, null, isLogicalDate);
    }

    public static GregorianCalendar getAbsoluteDate(RelativeDate relativeDate, Date baseDate, boolean isLogicalDate) {
        return relativeDate.getAbsoluteDate(baseDate, isLogicalDate);
    }

    public static boolean isRelativeDate(Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            return "RelativeDate".equals(map.get("_constructor"));
        }
        return false;
    }

    public static GregorianCalendar createLogicalDate(int year, int month, int day) {
        return DateUtil.createLogicalDate(year, month, day, Locale.getDefault());
    }

    public static GregorianCalendar createLogicalDate(int year, int month, int day, Locale locale) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
        gregorianCalendar.set(1, year);
        gregorianCalendar.set(2, month);
        gregorianCalendar.set(5, day);
        gregorianCalendar.set(11, 12);
        return gregorianCalendar;
    }

    public static GregorianCalendar createLogicalDate(long millisecondsTimeStamp) {
        return DateUtil.createLogicalDate(millisecondsTimeStamp, Locale.getDefault());
    }

    public static GregorianCalendar createLogicalDate(long millisecondsTimeStamp, Locale locale) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
        gregorianCalendar.setTimeInMillis(millisecondsTimeStamp);
        return gregorianCalendar;
    }
}

