/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.net.www.MessageHeader;
import sun.plugin.cache.Cache;
import sun.plugin.cache.CachedFile;
import sun.plugin.cache.CachedFileLoader;
import sun.plugin.util.UserProfile;

public class FileCache {
    protected static File directory;
    protected static Hashtable loadedFiles;
    protected static ReferenceQueue refQueue;
    protected static final String[] exts;
    protected static long lastCacheModifyTime;
    protected static Hashtable filesInCache;

    public static void init() {
    }

    public static CachedFile get(URL uRL) throws IOException {
        CachedFile cachedFile = null;
        if (Cache.cachingDisabled) {
            return null;
        }
        if (FileCache.isSupported(uRL)) {
            FileReference fileReference = (FileReference)loadedFiles.get(uRL);
            if (fileReference != null) {
                cachedFile = (CachedFile)fileReference.get();
            }
            if (cachedFile == null) {
                cachedFile = new CachedFileLoader(uRL).load();
                loadedFiles.put(uRL, new FileReference(cachedFile, refQueue, uRL));
                while ((fileReference = (FileReference)refQueue.poll()) != null) {
                    loadedFiles.remove(fileReference.getURL());
                }
            }
        }
        return cachedFile;
    }

    protected static final boolean isSupported(URL uRL) {
        String string;
        boolean bl = false;
        if (Cache.isSupportedProtocol(uRL) && (string = Cache.getFileExtension(uRL.toString())) != null) {
            for (int i = 0; i < exts.length; ++i) {
                if (!string.equalsIgnoreCase(exts[i])) continue;
                bl = true;
            }
        }
        return bl;
    }

    protected static final File getDataFile(File file, URL uRL) {
        String string = file.getName();
        string = string.substring(0, string.length() - ".idx".length());
        string = string + Cache.getFileExtension(uRL.toString());
        return new File(file.getParentFile(), string);
    }

    protected static final File getHostFile(File file, URL uRL) {
        String string = file.getName();
        string = string.substring(0, string.length() - ".idx".length());
        string = string + ".hst";
        return new File(file.getParentFile(), string);
    }

    protected static String generateCacheFileName(URL uRL) throws IOException {
        return Cache.generateCacheFileName(directory, uRL);
    }

    protected static Enumeration getMatchingFiles(URL uRL) {
        return Cache.getMatchingFiles(directory, uRL);
    }

    public static void clearLoadedFiles() {
        loadedFiles.clear();
        while (refQueue.poll() != null) {
        }
    }

    protected static boolean getMatchingFile(CachedFileLoader cachedFileLoader) throws IOException {
        boolean bl = false;
        String string = Cache.getKey(cachedFileLoader.getURL());
        bl = FileCache.match(cachedFileLoader, string);
        if (!bl && Cache.updateTable(directory, filesInCache, string)) {
            bl = FileCache.match(cachedFileLoader, string);
        }
        return bl;
    }

    protected static synchronized boolean match(CachedFileLoader cachedFileLoader, String string) throws IOException {
        boolean bl = false;
        ArrayList arrayList = (ArrayList)filesInCache.get(string);
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                File file = (File)arrayList.get(i);
                File file2 = FileCache.getDataFile(file, cachedFileLoader.getURL());
                if (file.exists() && file2.exists()) {
                    bl = FileCache.verifyFile(file, cachedFileLoader);
                } else {
                    arrayList.remove(i);
                    if (arrayList.size() == 0) {
                        filesInCache.remove(string);
                    }
                }
                if (!bl) continue;
                cachedFileLoader.setDataFile(file2);
                break;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean verifyFile(File file, CachedFileLoader cachedFileLoader) throws IOException {
        boolean bl = false;
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        try {
            String string;
            if (randomAccessFile.readByte() == 16 && (string = randomAccessFile.readUTF()).equals(cachedFileLoader.getURL().toString())) {
                bl = true;
                cachedFileLoader.setIndexFile(file);
                cachedFileLoader.setLastModify(randomAccessFile.readLong());
                cachedFileLoader.setExpiration(randomAccessFile.readLong());
                randomAccessFile.readInt();
                cachedFileLoader.setHeaders(FileCache.readHeaderFields(randomAccessFile, cachedFileLoader));
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                randomAccessFile.close();
                randomAccessFile = null;
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageHeader readHeaderFields(RandomAccessFile randomAccessFile, CachedFileLoader cachedFileLoader) throws IOException {
        MessageHeader messageHeader = new MessageHeader();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(randomAccessFile.getFD()));
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        for (int i = dataInputStream.readInt(); i > 0; --i) {
            String string = dataInputStream.readUTF();
            if (string.equals("plugin_resource_codebase_ip")) {
                cachedFileLoader.setCodebaseIP(dataInputStream.readUTF());
                continue;
            }
            if (string.equals("<null>")) {
                string = null;
            }
            messageHeader.add(string, dataInputStream.readUTF());
        }
        return messageHeader;
    }

    static {
        loadedFiles = new Hashtable();
        refQueue = new ReferenceQueue();
        exts = new String[]{".class", ".gif", ".jpg", ".au", ".wav"};
        lastCacheModifyTime = 0L;
        filesInCache = new Hashtable();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Cache.init();
                if (!Cache.cachingDisabled) {
                    directory = null;
                    String string = UserProfile.getFileCacheDirectory();
                    if (string != null) {
                        directory = new File(string.trim());
                    }
                    boolean bl = false;
                    if (directory != null) {
                        bl = directory.exists();
                        if (!bl) {
                            bl = directory.mkdirs();
                            if (!bl) {
                                Cache.msgPrintln("cache.create_warning", new Object[]{directory});
                                Cache.cachingDisabled = true;
                            }
                        } else if (!directory.canRead()) {
                            bl = false;
                            Cache.msgPrintln("cache.read_warning", new Object[]{directory});
                        } else if (!directory.canWrite()) {
                            bl = false;
                            Cache.msgPrintln("cache.write_warning", new Object[]{directory});
                        } else if (!directory.isDirectory()) {
                            bl = false;
                            Cache.msgPrintln("cache.directory_warning", new Object[]{directory});
                        }
                    }
                    if (bl) {
                        Cache.createTable(directory, filesInCache);
                    }
                }
                return null;
            }
        });
    }

    protected static class FileReference
    extends WeakReference {
        URL url;

        public FileReference(Object object, ReferenceQueue referenceQueue, URL uRL) {
            super(object, referenceQueue);
            this.url = uRL;
        }

        public URL getURL() {
            return this.url;
        }
    }
}

