/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.criteria;

import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.Criterion;
import com.isomorphic.criteria.DefaultOperators;
import com.isomorphic.criteria.Evaluator;
import com.isomorphic.criteria.Operator;
import com.isomorphic.criteria.OperatorBase;
import com.isomorphic.criteria.RangeOperator;
import com.isomorphic.criteria.criterion.AndCriterion;
import com.isomorphic.criteria.criterion.IsNullCriterion;
import com.isomorphic.criteria.criterion.LogicalCriterion;
import com.isomorphic.criteria.criterion.NotCriterion;
import com.isomorphic.criteria.criterion.NotNullCriterion;
import com.isomorphic.criteria.criterion.OrCriterion;
import com.isomorphic.criteria.criterion.SimpleCriterion;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleFieldCriteriaTransformer {
    private final Logger logger = new Logger(MultipleFieldCriteriaTransformer.class);
    private final BasicDataSource basicDataSource;

    public MultipleFieldCriteriaTransformer(BasicDataSource basicDataSource) {
        this.basicDataSource = basicDataSource;
    }

    public Map<String, Object> transform(Map<String, Object> criteria) {
        Criterion criterion = this.transformIntoCriterion(criteria);
        if (criterion == null) {
            return criteria;
        }
        Map<String, Object> outputCriteria = new AdvancedCriteria(criterion).getCriteriaAsMap();
        if (criteria.get("strictSQLFiltering") != null) {
            outputCriteria.put("strictSQLFiltering", criteria.get("strictSQLFiltering"));
        }
        if (outputCriteria.get("operator") == null) {
            outputCriteria.remove("_constructor");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Transformed criteria " + DataTools.prettyPrint(outputCriteria));
        }
        return outputCriteria;
    }

    private Criterion transformIntoCriterion(Map<String, Object> criteria) {
        String operator = String.valueOf(criteria.get("operator"));
        Object subCriteriaObject = criteria.get("criteria");
        LinkedList<Criterion> criterionList = new LinkedList<Criterion>();
        if (subCriteriaObject != null && subCriteriaObject instanceof List) {
            for (Map subCriteria : (List)subCriteriaObject) {
                Criterion criterion = this.transformIntoCriterion(subCriteria);
                if (criterion == null) continue;
                criterionList.add(criterion);
            }
            if (operator.equals(DefaultOperators.And.getID())) {
                return new AndCriterion(criterionList);
            }
            if (operator.equals(DefaultOperators.Or.getID())) {
                return new OrCriterion(criterionList);
            }
            if (operator.equals(DefaultOperators.Not.getID())) {
                return new NotCriterion(criterionList);
            }
            return new LogicalCriterion(operator, criterionList);
        }
        String fieldName = String.valueOf(criteria.get("fieldName"));
        DSField dsField = this.basicDataSource.getField(fieldName);
        Object value = criteria.get("value");
        if (this.isValidMultipleDSField(dsField)) {
            String multipleSeparator = this.getMultipleStorageSeparator(dsField);
            if (!this.isValidSearchValue(value, dsField)) {
                this.logger.warn("Attempt at searching on a multiple value field using a search term containing the separator \"" + multipleSeparator + "\" is not allowed. Returning criteria which will result in no records.");
                return new AndCriterion(new IsNullCriterion(dsField.getName()), new NotNullCriterion(dsField.getName()));
            }
            boolean caseSensitive = this.isCaseSensitive(operator);
            boolean negated = StringUtils.startsWith((String)operator, (String)"not");
            boolean isJson = "json".equalsIgnoreCase(dsField.getMultipleStorage());
            String startsWithPadding = "";
            String endsWithPadding = "";
            if (isJson) {
                startsWithPadding = "[";
                endsWithPadding = "]";
            }
            if (StringUtils.endsWithIgnoreCase((String)operator, (String)"equals")) {
                criterionList.addAll(this.createCriterionsForEquals(startsWithPadding, endsWithPadding, negated, caseSensitive, dsField.getName(), multipleSeparator, value, isJson));
            } else if (StringUtils.endsWithIgnoreCase((String)operator, (String)"startsWith")) {
                criterionList.add(new SimpleCriterion(dsField.getName(), MultipleFieldCriteriaTransformer.getOperatorName("startsWith", caseSensitive), (Object)(isJson ? startsWithPadding + "\"" + value : startsWithPadding + value)));
                criterionList.add(new SimpleCriterion(dsField.getName(), MultipleFieldCriteriaTransformer.getOperatorName("contains", caseSensitive), (Object)(isJson ? multipleSeparator + "\"" + value : multipleSeparator + value)));
            } else if (StringUtils.endsWithIgnoreCase((String)operator, (String)"endsWith")) {
                criterionList.add(new SimpleCriterion(dsField.getName(), MultipleFieldCriteriaTransformer.getOperatorName("contains", caseSensitive), (Object)(isJson ? value + "\"" + multipleSeparator : value + multipleSeparator)));
                criterionList.add(new SimpleCriterion(dsField.getName(), MultipleFieldCriteriaTransformer.getOperatorName("endsWith", caseSensitive), (Object)(isJson ? value + "\"" + endsWithPadding : value + endsWithPadding)));
            } else if (StringUtils.endsWithIgnoreCase((String)operator, (String)"matchesPattern")) {
                String multiCharacterWildcard = ObjectUtils.toString((Object)this.basicDataSource.getProperty("patternMultiWildcard"), (String)"*");
                criterionList.add(new SimpleCriterion(dsField.getName(), MultipleFieldCriteriaTransformer.getOperatorName("matchesPattern", caseSensitive), (Object)(isJson ? startsWithPadding + "\"" + value + "\"" + multipleSeparator + multiCharacterWildcard : startsWithPadding + value + multipleSeparator + multiCharacterWildcard)));
                criterionList.add(new SimpleCriterion(dsField.getName(), MultipleFieldCriteriaTransformer.getOperatorName("matchesPattern", caseSensitive), (Object)(isJson ? multiCharacterWildcard + multipleSeparator + "\"" + value + "\"" + multipleSeparator + multiCharacterWildcard : multiCharacterWildcard + multipleSeparator + value + multipleSeparator + multiCharacterWildcard)));
                criterionList.add(new SimpleCriterion(dsField.getName(), MultipleFieldCriteriaTransformer.getOperatorName("matchesPattern", caseSensitive), (Object)(isJson ? multiCharacterWildcard + multipleSeparator + "\"" + value + "\"" + endsWithPadding : multiCharacterWildcard + multipleSeparator + value + endsWithPadding)));
            } else if (StringUtils.endsWithIgnoreCase((String)operator, (String)"startsWithPattern")) {
                String multiCharacterWildcard = ObjectUtils.toString((Object)this.basicDataSource.getProperty("patternMultiWildcard"), (String)"*");
                criterionList.add(new SimpleCriterion(dsField.getName(), MultipleFieldCriteriaTransformer.getOperatorName("startsWithPattern", caseSensitive), (Object)(isJson ? startsWithPadding + "\"" + value + "\"" + multipleSeparator + multiCharacterWildcard : startsWithPadding + value + multipleSeparator + multiCharacterWildcard)));
                criterionList.add(new SimpleCriterion(dsField.getName(), MultipleFieldCriteriaTransformer.getOperatorName("startsWithPattern", caseSensitive), (Object)(isJson ? multiCharacterWildcard + multipleSeparator + "\"" + value + "\"" + multipleSeparator + multiCharacterWildcard : multiCharacterWildcard + multipleSeparator + value + multipleSeparator + multiCharacterWildcard)));
                criterionList.add(new SimpleCriterion(dsField.getName(), MultipleFieldCriteriaTransformer.getOperatorName("startsWithPattern", caseSensitive), (Object)(isJson ? multiCharacterWildcard + multipleSeparator + "\"" + value + "\"" + endsWithPadding : multiCharacterWildcard + multipleSeparator + value + endsWithPadding)));
            } else if (StringUtils.endsWithIgnoreCase((String)operator, (String)"endsWithPattern")) {
                String multiCharacterWildcard = ObjectUtils.toString((Object)this.basicDataSource.getProperty("patternMultiWildcard"), (String)"*");
                criterionList.add(new SimpleCriterion(dsField.getName(), MultipleFieldCriteriaTransformer.getOperatorName("endsWithPattern", caseSensitive), (Object)(isJson ? startsWithPadding + "\"" + value + "\"" + multipleSeparator + multiCharacterWildcard : startsWithPadding + value + multipleSeparator + multiCharacterWildcard)));
                criterionList.add(new SimpleCriterion(dsField.getName(), MultipleFieldCriteriaTransformer.getOperatorName("endsWithPattern", caseSensitive), (Object)(isJson ? multiCharacterWildcard + multipleSeparator + "\"" + value + "\"" + multipleSeparator + multiCharacterWildcard : multiCharacterWildcard + multipleSeparator + value + multipleSeparator + multiCharacterWildcard)));
                criterionList.add(new SimpleCriterion(dsField.getName(), MultipleFieldCriteriaTransformer.getOperatorName("endsWithPattern", caseSensitive), (Object)(isJson ? multiCharacterWildcard + multipleSeparator + "\"" + value + "\"" + endsWithPadding : multiCharacterWildcard + multipleSeparator + value + endsWithPadding)));
            } else if (StringUtils.endsWithIgnoreCase((String)operator, (String)"null")) {
                criterionList.add(negated ? new NotNullCriterion(dsField.getName()) : new IsNullCriterion(dsField.getName()));
            } else if (StringUtils.endsWithIgnoreCase((String)operator, (String)"inSet")) {
                for (Object valueObject : (List)value) {
                    List<Criterion> equalsCriterionList = this.createCriterionsForEquals(startsWithPadding, endsWithPadding, negated, caseSensitive, dsField.getName(), multipleSeparator, valueObject, isJson);
                    if (negated) {
                        criterionList.add(new AndCriterion(equalsCriterionList));
                        continue;
                    }
                    criterionList.add(new OrCriterion(equalsCriterionList));
                }
            } else {
                criterionList.add(this.createCriterion(criteria));
            }
            if (negated) {
                return new AndCriterion(criterionList);
            }
            return new OrCriterion(criterionList);
        }
        return this.createCriterion(criteria);
    }

    private Criterion createCriterion(Map<String, Object> criteria) {
        Operator operatorObject = DefaultOperators.getDefaultOperatorMap().get(String.valueOf(criteria.get("operator")));
        if (operatorObject != null && operatorObject instanceof RangeOperator) {
            return Evaluator.parseCriterion(criteria);
        }
        if (operatorObject != null && operatorObject instanceof OperatorBase) {
            return ((OperatorBase)operatorObject).parseCriterion(String.valueOf(criteria.get("fieldName")), criteria.get("value"), null);
        }
        return Evaluator.parseCriterion(criteria);
    }

    private boolean isValidSearchValue(Object valueObject, DSField dsField) {
        if (valueObject instanceof String) {
            String multipleSeparator = this.getMultipleStorageSeparator(dsField);
            String value = String.valueOf(valueObject);
            if (value.contains(multipleSeparator) || value.contains("\"") || value.contains(",")) {
                return false;
            }
        }
        return true;
    }

    private String getMultipleStorageSeparator(DSField dsField) {
        String multipleSeparator = ",";
        if (!"json".equalsIgnoreCase(dsField.getMultipleStorage()) && (multipleSeparator = dsField.getMultipleStorageSeparator()) == null) {
            multipleSeparator = dsField.getMultipleValueSeparator();
        }
        return multipleSeparator;
    }

    private List<Criterion> createCriterionsForEquals(String startsWithPadding, String endsWithPadding, boolean negated, boolean caseSensitive, String fieldName, String multipleSeparator, Object value, boolean isJson) {
        LinkedList<Criterion> criterionList = new LinkedList<Criterion>();
        criterionList.add(new SimpleCriterion(fieldName, MultipleFieldCriteriaTransformer.getOperatorName("equals", caseSensitive, negated), (Object)(isJson ? startsWithPadding + "\"" + value + "\"" + endsWithPadding : startsWithPadding + value + endsWithPadding)));
        criterionList.add(new SimpleCriterion(fieldName, MultipleFieldCriteriaTransformer.getOperatorName("startsWith", caseSensitive, negated), (Object)(isJson ? startsWithPadding + "\"" + value + "\"" + multipleSeparator : startsWithPadding + value + multipleSeparator)));
        criterionList.add(new SimpleCriterion(fieldName, MultipleFieldCriteriaTransformer.getOperatorName("contains", caseSensitive, negated), (Object)(isJson ? multipleSeparator + "\"" + value + "\"" + multipleSeparator : multipleSeparator + value + multipleSeparator)));
        criterionList.add(new SimpleCriterion(fieldName, MultipleFieldCriteriaTransformer.getOperatorName("endsWith", caseSensitive, negated), (Object)(isJson ? multipleSeparator + "\"" + value + "\"" + endsWithPadding : multipleSeparator + value + endsWithPadding)));
        return criterionList;
    }

    private boolean isCaseSensitive(String operator) {
        return !operator.startsWith("i") && !"inSet".equalsIgnoreCase(operator) && !"isNull".equalsIgnoreCase(operator);
    }

    private boolean isValidMultipleDSField(DSField dsField) {
        return dsField != null && dsField.isMultiple() && dsField.getMultipleStorage() != null && ("simpleString".equalsIgnoreCase(dsField.getMultipleStorage()) || "json".equalsIgnoreCase(dsField.getMultipleStorage()));
    }

    public static String getOperatorName(String operator, boolean caseSensitive) {
        return MultipleFieldCriteriaTransformer.getOperatorName(operator, caseSensitive, false);
    }

    public static String getOperatorName(String operator, boolean caseSensitive, boolean negated) {
        String output = operator;
        if (negated) {
            output = "not" + StringUtils.capitalize((String)output);
        }
        if (!caseSensitive) {
            output = "i" + StringUtils.capitalize((String)output);
        }
        if (StringUtils.endsWithIgnoreCase((String)output, (String)"notEquals")) {
            output = StringUtils.stripEnd((String)output, (String)"s");
        }
        return output;
    }
}

