/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.Config;
import com.isomorphic.base.Init;
import com.isomorphic.base.Reflection;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.ServletTools;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BaseServlet
extends HttpServlet {
    protected static Config config;
    protected static String webRoot;
    protected Logger log;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        Init.go(servletConfig.getServletContext(), true);
        config = Config.getGlobal();
        webRoot = config.getPath("webRoot");
        String servletName = servletConfig.getServletName();
        String className = ((Object)((Object)this)).getClass().getName();
        String logPrefix = null;
        if (!className.endsWith(servletName)) {
            logPrefix = servletName;
        }
        this.log = new Logger(className, logPrefix);
        ServletTools.applyConfigToServletOrFilter((Object)this, servletConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean ignoredThread = false;
        try {
            try {
                String rpcContext;
                if (ServletTools.ignoreLog(request) && !Logger.threadIgnored()) {
                    Logger.ignoreThread();
                    ignoredThread = true;
                }
                if ((rpcContext = ServletTools.rpcContext(request)) != null) {
                    Logger.pushUniqueContext(rpcContext);
                }
                super.service(request, response);
            }
            catch (Throwable e) {
                this.handleError(response, "BaseServlet Global Exception", e);
                Object var6_7 = null;
                Logger.removeContext();
                if (!ignoredThread) return;
                Logger.observeThread();
                return;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            Logger.removeContext();
            if (!ignoredThread) throw throwable;
            Logger.observeThread();
            throw throwable;
        }
        Logger.removeContext();
        if (!ignoredThread) return;
        Logger.observeThread();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void handleError(HttpServletResponse response, Throwable t) {
        this.handleError(response, ((Object)((Object)this)).getClass().getName() + " top-level exception", t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleError(HttpServletResponse response, String errorMessage, Throwable t) {
        block3: {
            boolean threadWasIgnored = Logger.threadIgnored();
            try {
                Logger.observeThread();
                this.log.error((Object)errorMessage, Reflection.getRealTargetException(t));
                Object var6_5 = null;
                if (!threadWasIgnored) break block3;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (threadWasIgnored) {
                    Logger.ignoreThread();
                }
                throw throwable;
            }
            Logger.ignoreThread();
        }
        ServletTools.handleServletError(response, errorMessage, t);
    }
}

