/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLConnectionManager;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Statement;

public class SQLBuild
extends Base {
    private static Logger log = new Logger(SQLBuild.class.getName());
    private static Perl5Util perl = new Perl5Util();
    private static JSTranslater jsTrans = new JSTranslater();
    static PrintStream out = System.out;
    static PrintStream err = System.err;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block29: {
            String databaseName;
            String defaultDB = config.getString((Object)"sql.defaultDatabase");
            String dbType = config.getString((Object)("sql." + defaultDB + ".driver.type"));
            if (dbType == null) {
                dbType = "mysql";
            }
            if ((databaseName = config.getString((Object)("sql." + defaultDB + ".dataSource.databaseName"))) == null) {
                databaseName = config.getString((Object)("sql." + defaultDB + ".driver.databaseName"));
            }
            String username = config.getString((Object)("sql." + defaultDB + ".dataSource.user"));
            String password = config.getString((Object)("sql." + defaultDB + ".dataSource.password"));
            String adminUsername = dbType != null && dbType.equals("oracle") ? "system" : "root";
            String adminPassword = dbType != null && dbType.equals("oracle") ? "manager" : "root";
            config.put((Object)("sql." + defaultDB + ".dataSource.user"), (Object)adminUsername);
            config.put((Object)("sql." + defaultDB + ".dataSource.password"), (Object)adminPassword);
            if (dbType != null && dbType.equals("mysql")) {
                config.put((Object)("sql." + defaultDB + ".dataSource.databaseName"), (Object)"mysql");
            }
            Connection conn = null;
            Statement s = null;
            try {
                String sql = null;
                conn = SQLConnectionManager.getConnection(defaultDB);
                s = conn.createStatement();
                if (dbType.equals("mysql")) {
                    try {
                        sql = "create database " + databaseName;
                        log.debug((Object)("going to execute: " + sql));
                        s.execute(sql);
                    }
                    catch (Exception e) {
                        if (e.toString().indexOf("exists") != -1) {
                            log.debug((Object)"database already exists - leaving it alone...");
                            System.exit(0);
                        }
                        log.error((Object)"failed to create database", (Throwable)e);
                        System.exit(1);
                    }
                    break block29;
                }
                if (dbType.equals("oracle")) {
                    String tablespace = username;
                    try {
                        sql = "create tablespace " + tablespace + " datafile '/home/oracle/oracle_home/dbs/" + tablespace + ".dbf' size 50M online";
                        log.debug((Object)("going to execute: " + sql));
                        s.execute(sql);
                    }
                    catch (Exception e) {
                        if (e.toString().indexOf("ORA-01543") != -1) {
                            log.debug((Object)"tablespace already exists - leaving it alone...");
                            System.exit(0);
                        }
                        log.error((Object)"failed to create tablespace", (Throwable)e);
                        System.exit(1);
                    }
                    String rollback = tablespace;
                    try {
                        sql = "create public rollback segment " + rollback + " tablespace " + tablespace;
                        log.debug((Object)("going to execute: " + sql));
                        s.execute(sql);
                    }
                    catch (Exception e) {
                        log.error((Object)"failed to create rollback segment", (Throwable)e);
                        System.exit(1);
                    }
                    try {
                        sql = "alter rollback segment " + rollback + " online";
                        log.debug((Object)("going to execute: " + sql));
                        s.execute(sql);
                    }
                    catch (Exception e) {
                        log.error((Object)"unable to put rollback segment online", (Throwable)e);
                        System.exit(1);
                    }
                    try {
                        sql = "create user " + username + " identified by " + password + " default tablespace " + tablespace + " temporary tablespace TEMP quota UNLIMITED on " + tablespace;
                        log.debug((Object)("going to execute: " + sql));
                        s.execute(sql);
                        sql = "grant DBA to " + username;
                        log.debug((Object)("going to execute: " + sql));
                        s.execute(sql);
                    }
                    catch (Exception e) {
                        log.error((Object)"failed to create user or grant privileges", (Throwable)e);
                    }
                    break block29;
                }
                log.error((Object)("Unsupported database type " + dbType));
                System.exit(1);
            }
            catch (Exception eg) {
                log.error((Object)"Global exception", (Throwable)eg);
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

