/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.datasource.Relation;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.util.DataTools;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLTableClause
extends Base {
    private static Logger log = new Logger(SQLTableClause.class.getName());
    private List dataSources;
    private boolean isSubSelect = false;
    private List customValueFields = null;
    private List customCriteriaFields = null;
    private DSRequest dsRequest;

    public SQLTableClause(DSRequest req, SQLDataSource ds) {
        this(req, DataTools.makeList((Object)((Object)ds)));
    }

    public SQLTableClause(DSRequest req, List dataSources) {
        this.dataSources = dataSources;
        this.dsRequest = req;
    }

    public String getSQLString() throws Exception {
        if (this.dataSources == null) {
            log.debug((Object)"No datasources, can't generate table clause");
            return "";
        }
        StringBuffer buf = new StringBuffer();
        HashMap<String, Object> allDataSources = new HashMap<String, Object>();
        for (SQLDataSource ds : this.dataSources) {
            if (!allDataSources.containsKey(ds.getName())) {
                allDataSources.put(ds.getName(), (Object)ds);
            }
            if (!DataSource.isModificationOperation((String)this.dsRequest.getOperationType())) continue;
            break;
        }
        if (!DataSource.isModificationOperation((String)this.dsRequest.getOperationType())) {
            Boolean useAnsiJoins = DataTools.asBooleanObject(this.dsRequest.getDataSource().getConfig().get("useAnsiJoins"));
            if (useAnsiJoins == null) {
                useAnsiJoins = config.getBoolean((Object)"sql.useAnsiJoins", false);
            }
            if (this.isSubSelect || useAnsiJoins == null || !useAnsiJoins.booleanValue()) {
                for (IncludeFromDefinition incFrom : this.dsRequest.getIncludeFrom()) {
                    String includeSummaryFunction;
                    if (incFrom.isInError() || !(incFrom.getDataSource() instanceof SQLDataSource)) continue;
                    String string = includeSummaryFunction = incFrom.getThisField() == null ? null : incFrom.getThisField().getProperty("includeSummaryFunction");
                    if (!this.dsRequest.isSummary() && !this.isSubSelect && incFrom.getThisField() != null && includeSummaryFunction != null && (!"CONCAT".equalsIgnoreCase(includeSummaryFunction) || !Boolean.TRUE.equals(this.dsRequest.getAttribute("_isConcatFetch")))) continue;
                    DSField thisField = incFrom.getThisField();
                    if (thisField != null && thisField.getBoolean("customSQL")) {
                        Iterator j;
                        String thisFieldName = incFrom.getThisFieldName();
                        boolean skipField = true;
                        if (this.customValueFields != null) {
                            j = this.customValueFields.iterator();
                            while (j.hasNext()) {
                                if (!j.next().equals(thisFieldName)) continue;
                                skipField = false;
                                break;
                            }
                        }
                        if (skipField && this.customCriteriaFields != null) {
                            j = this.customCriteriaFields.iterator();
                            while (j.hasNext()) {
                                if (!j.next().equals(thisFieldName)) continue;
                                skipField = false;
                                break;
                            }
                        }
                        if (skipField) continue;
                    }
                    String alias = incFrom.getAlias(false);
                    String allDSKey = incFrom.getDataSourceName();
                    if (!allDataSources.containsKey(allDSKey = allDSKey + (alias != null ? "*" + alias : ""))) {
                        HashMap<String, Object> allDSMap = new HashMap<String, Object>();
                        allDSMap.put("ds", incFrom.getDataSource());
                        allDSMap.put("alias", alias);
                        allDataSources.put(allDSKey, allDSMap);
                    }
                    this.addDataSourcesFromJoiningRelations(incFrom, allDataSources);
                    IncludeFromDefinition target = incFrom.getTargetIncludeFrom();
                    while (target != null && target.getDataSource() instanceof SQLDataSource) {
                        alias = target.getAlias(false);
                        allDSKey = target.getDataSourceName();
                        if (!allDataSources.containsKey(allDSKey = allDSKey + (alias != null ? "*" + alias : ""))) {
                            HashMap<String, Object> allDSMap = new HashMap<String, Object>();
                            allDSMap.put("ds", target.getDataSource());
                            allDSMap.put("alias", alias);
                            allDataSources.put(allDSKey, allDSMap);
                        }
                        incFrom = target;
                        this.addDataSourcesFromJoiningRelations(incFrom, allDataSources);
                        target = incFrom.getTargetIncludeFrom();
                    }
                }
            }
        }
        Iterator<Object> i = allDataSources.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object obj = allDataSources.get(key);
            SQLDataSource ds = null;
            String alias = null;
            if (obj instanceof SQLDataSource) {
                ds = (SQLDataSource)((Object)obj);
            } else {
                Map map = (Map)obj;
                ds = (SQLDataSource)((Object)map.get("ds"));
                alias = (String)map.get("alias");
            }
            String schema = (String)ds.getConfig().get("schema");
            if (schema != null) {
                buf.append(schema);
                buf.append(ds.getDriver().getQualifiedSchemaSeparator());
            }
            String tableName = ds.getTable().getNameQuotedIfNecessary(ds);
            buf.append(tableName);
            if (alias != null) {
                buf.append(" ");
                buf.append(alias);
            }
            if (!i.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    private void addDataSourcesFromJoiningRelations(IncludeFromDefinition incFrom, Map relatedDataSources) {
        for (Relation r = incFrom.getRelation(); r != null; r = r.getNextRelation()) {
            if (!r.isValid()) continue;
            String alias = r.getToAlias();
            String allDSKey = r.getToDataSource().getName();
            if (relatedDataSources.containsKey(allDSKey = allDSKey + (alias != null ? "*" + alias : ""))) continue;
            HashMap<String, Object> allDSMap = new HashMap<String, Object>();
            allDSMap.put("ds", r.getToDataSource());
            allDSMap.put("alias", alias);
            relatedDataSources.put(allDSKey, allDSMap);
        }
    }

    public void setIsSubSelect(boolean isSubSelect) {
        this.isSubSelect = isSubSelect;
    }

    public List getCustomValueFields() {
        return this.customValueFields;
    }

    public void setCustomValueFields(List fields) {
        this.customValueFields = fields;
    }

    public List getCustomCriteriaFields() {
        return this.customCriteriaFields;
    }

    public void setCustomCriteriaFields(List fields) {
        this.customCriteriaFields = fields;
    }
}

