/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class StackHashMap<K, V>
implements ConcurrentMap<K, V> {
    private final Map<K, V> map = Collections.synchronizedMap(new LinkedHashMap());
    private final LinkedList<K> list = new LinkedList();

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        Map<K, V> map = this.map;
        synchronized (map) {
            if (!this.map.containsKey(key)) {
                this.list.addLast(key);
            } else {
                value = value == null ? this.map.get(key) : value;
            }
            return this.map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        Map<K, V> map = this.map;
        synchronized (map) {
            for (Map.Entry<K, V> entry : t.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Map<K, V> map = this.map;
        synchronized (map) {
            this.list.remove(key);
            return this.map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<K, V> map = this.map;
        synchronized (map) {
            this.list.clear();
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V pop() {
        Map<K, V> map = this.map;
        synchronized (map) {
            return this.map.remove(this.list.removeFirst());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V push(K k, V v) {
        Map<K, V> map = this.map;
        synchronized (map) {
            this.list.addFirst(k);
            return this.map.put(k, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V peek() {
        Map<K, V> map = this.map;
        synchronized (map) {
            K k = this.peekKey();
            return k == null ? null : (V)this.map.get(k);
        }
    }

    public K peekKey() {
        return this.list.isEmpty() ? null : (K)this.list.getFirst();
    }

    public List<K> asStack() {
        return Collections.unmodifiableList(this.list);
    }

    public Map<K, V> asMap() {
        return Collections.unmodifiableMap(this.map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K k, V v) {
        Map<K, V> map = this.map;
        synchronized (map) {
            if (!this.containsKey(k)) {
                this.list.addFirst(k);
                return this.map.put(k, v);
            }
            this.list.remove(k);
            this.list.addFirst(k);
            return null;
        }
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V replace(K key, V value) {
        throw new UnsupportedOperationException();
    }
}

