/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.constraints.impl.scriptassert;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.validation.ConstraintDeclarationException;
import org.hibernate.validator.constraints.impl.scriptassert.ScriptEvaluator;

public class ScriptEvaluatorFactory {
    private static Reference<ScriptEvaluatorFactory> INSTANCE = new SoftReference<ScriptEvaluatorFactory>(new ScriptEvaluatorFactory());
    private ConcurrentMap<String, ScriptEvaluator> scriptExecutorCache = new ConcurrentHashMap<String, ScriptEvaluator>();

    private ScriptEvaluatorFactory() {
    }

    public static synchronized ScriptEvaluatorFactory getInstance() {
        ScriptEvaluatorFactory theValue = INSTANCE.get();
        if (theValue == null) {
            theValue = new ScriptEvaluatorFactory();
            INSTANCE = new SoftReference<ScriptEvaluatorFactory>(theValue);
        }
        return theValue;
    }

    public ScriptEvaluator getScriptEvaluatorByLanguageName(String languageName) {
        if (!this.scriptExecutorCache.containsKey(languageName)) {
            ScriptEvaluator scriptExecutor = this.createNewScriptEvaluator(languageName);
            this.scriptExecutorCache.putIfAbsent(languageName, scriptExecutor);
        }
        return (ScriptEvaluator)this.scriptExecutorCache.get(languageName);
    }

    private ScriptEvaluator createNewScriptEvaluator(String languageName) {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName(languageName);
        if (engine == null) {
            throw new ConstraintDeclarationException("No JSR 223 script engine found for language \"" + languageName + "\".");
        }
        return new ScriptEvaluator(engine);
    }
}

