<#-- @ftlvariable name="openapi" type="java.util.Map<String, Object>" -->
<#-- @ftlvariable name="info" type="java.util.Map<String, Object>"-->
<#-- @ftlvariable name="servers" type="java.util.Map<String, Object>"-->
<#-- @ftlvariable name="app" type="java.util.Map<String, Object>" -->
<#-- @ftlvariable name="ds" type="java.util.Map<String, Object>" -->

<#setting numberFormat="computer" />

<#import "lib/parameters.ftl" as p />
<#import "lib/responses.ftl" as resp />
<#import "lib/schemas.ftl" as s />
<#import "lib/simplified-rest.ftl" as sr />
<#import "lib/simplified-post.ftl" as sp />

<#assign usingDefaultCriteria = ds.allOperations?filter(op -> !op.hasCustomCriteria) />
<#assign usingCustomCriteria = ds.allOperations?filter(op -> op.hasCustomCriteria) />
<#assign usingDefaultOutput = ds.allOperations?filter(op -> !op.hasCustomOutput) />
<#assign usingCustomOutput = ds.allOperations?filter(op -> op.hasCustomOutput) />

openapi: "${openapi.version}"

info:
  version: ${info.version ! "1.0.0"}
  title: ${ds.title ! ds.id}
  description: |
  <#if ds.description??>
    <#list ds.description as line>
    ${line?trim}
    </#list>
  <#else>
    A DataSource Operation is a type of operation that acts on the set of stored objects represented by a DataSource, performing one of the basic actions that makes sense on a set of similar records:
      - fetch
      - add
      - update
      - remove
    There is also a fifth DataSource Operation, "custom", which is intended for arbitrary server operations that are more complex than a fetch of some records, or an update to a single record.
    Each DataSource operation has specific requirements around request and response data.  For example, in the "fetch" DataSource operation, the request data is expected to be search criteria,
    and the response data is expected to be a list of matching DataSource records.

    The following API documentation provides the request and response data for this DataSource's operations in the application.
  </#if>

servers:
  <#list servers.urls as url>
  - url: ${url}
  </#list>

components:
  parameters:
    <@p.hybridMode />
<#--    <@p.dataFormat defaultValue=app.defaultDataFormat!"xml" />-->
    <@p.sortBy />
    <@p.startRow />
    <@p.endRow />
    <@p.textMatchStyle defaultValue=app.defaultTextMatchStyle!"exact" />
    <@p.pathToKey />

  responses:
    <@resp.http204 />
    <@resp.http404 />
    <@resp.errorResponse />
    <@resp.default />

  schemas:
    <@s.record />
    <@s.operator />
    <@s.errorMessage />
    <@s.errorModel />
  <#if usingDefaultCriteria?hasContent>
    <@s.criteria usingDefaultCriteria?first />
    <@s.criterion usingDefaultCriteria?first />
    <@s.advancedCriteria usingDefaultCriteria?first />
  </#if>
  <#list usingCustomCriteria as op>
    <@s.criteria op, op.operationId />
    <@s.criterion op, op.operationId  />
    <@s.advancedCriteria op, op.operationId />
  </#list>

  <#if usingDefaultOutput?hasContent>
    <@s.response usingDefaultOutput?first />
  </#if>
  <#list usingCustomOutput as op>
    <@s.response op />
  </#list>

paths:
<#--
  SimplifiedPOST
  -->
<#if ds.defaultOperations.fetch??>
  /RESTDataSource/${ds.id}/fetch:
    <@sp.fetch ds.defaultOperations.fetch />
</#if>
<#if ds.defaultOperations.add??>
  /RESTDataSource/${ds.id}/add:
    <@sp.add ds.defaultOperations.add />
</#if>
<#if ds.defaultOperations.update??>
  /RESTDataSource/${ds.id}/update:
    <@sp.update ds.defaultOperations.update />
</#if>
<#if ds.defaultOperations.remove??>
  /RESTDataSource/${ds.id}/remove:
    <@sp.remove ds.defaultOperations.remove />
</#if>
<#list ds.namedOperations as named>
  <#if named.operationType == 'custom'>
    <#continue />
  </#if>
  <#if !named.operationId??>
    <#continue />
  </#if>
  /RESTDataSource/${ds.id}/${named.operationType}/${named.operationId}:
  <#switch named.operationType>
  <#case 'fetch'>
    <@sp.fetch named />
    <#break>
  <#case 'add'>
    <@sp.add named />
    <#break>
  <#case 'update'>
    <@sp.update named />
    <#break>
  <#case 'remove'>
    <@sp.remove named />
    <#break>
  </#switch>
</#list>
  /RESTDataSource/${ds.id}/batch:
    <@sp.batch ds.allOperations />
<#--
  SimplifiedREST
-->
<#if ds.defaultOperations?hasContent>
  /${ds.id}:
  <#if ds.defaultOperations.fetch??>
    <@sr.fetch ds.defaultOperations.fetch />
  </#if>
  <#if ds.defaultOperations.add??>
    <@sr.add ds.defaultOperations.add />
  </#if>
  <#if ds.defaultOperations.update??>
    <@sr.update ds.defaultOperations.update />
  </#if>
  <#if ds.defaultOperations.update??>
    <@sr.remove ds.defaultOperations.remove />
  </#if>
</#if>
<#if ds.defaultOperations?hasContent && ds.primaryKey??>
  /${ds.id}/{${ds.primaryKey}}:
  <#if ds.defaultOperations.fetch??>
    <@sr.fetchByPath ds.defaultOperations.fetch />
  </#if>
  <#if ds.defaultOperations.update??>
    <@sr.updateByPath ds.defaultOperations.update />
  </#if>
  <#if ds.defaultOperations.remove??>
    <@sr.removeByPath ds.defaultOperations.remove />
  </#if>
</#if>
<#list ds.namedOperations as named>
  <#if !named.operationId??>
    <#continue />
  </#if>
  <@sr.namedOperationBinding named />
</#list>