/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.crypto;

import com.isomorphic.base.Base;
import com.isomorphic.crypto.Asn1Object;
import com.isomorphic.crypto.DerParser;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;

public class CryptoUtil
extends Base {
    private static Logger log = new Logger(CryptoUtil.class.getName());
    static final String PEM_PKCS8_START = "-----BEGIN PRIVATE KEY-----";
    static final String PEM_PKCS8_END = "-----END PRIVATE KEY-----";
    static final String PEM_PKCS1_START = "-----BEGIN RSA PRIVATE KEY-----";
    static final String PEM_PKCS1_END = "-----END RSA PRIVATE KEY-----";

    public static PrivateKey pemToPrivateKey(String privateKeyPem) throws GeneralSecurityException, IOException {
        if (privateKeyPem.indexOf(PEM_PKCS8_START) != -1) {
            privateKeyPem = privateKeyPem.replace(PEM_PKCS8_START, "").replace(PEM_PKCS8_END, "");
            privateKeyPem = privateKeyPem.replaceAll("\\s", "");
            byte[] pkcs8EncodedKey = DataTools.base64DecodeToBytes(privateKeyPem);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return factory.generatePrivate(new PKCS8EncodedKeySpec(pkcs8EncodedKey));
        }
        if (privateKeyPem.indexOf(PEM_PKCS1_START) != -1) {
            privateKeyPem = privateKeyPem.replace(PEM_PKCS1_START, "").replace(PEM_PKCS1_END, "");
            DerParser parser = new DerParser(DataTools.base64DecodeToBytes(privateKeyPem = privateKeyPem.replaceAll("\\s", "")));
            Asn1Object sequence = parser.read();
            if (sequence.getType() != 16) {
                throw new IOException("Invalid DER: not a sequence");
            }
            parser = sequence.getParser();
            parser.read();
            BigInteger modulus = parser.read().getInteger();
            BigInteger publicExp = parser.read().getInteger();
            BigInteger privateExp = parser.read().getInteger();
            BigInteger prime1 = parser.read().getInteger();
            BigInteger prime2 = parser.read().getInteger();
            BigInteger exp1 = parser.read().getInteger();
            BigInteger exp2 = parser.read().getInteger();
            BigInteger crtCoef = parser.read().getInteger();
            RSAPrivateCrtKeySpec keySpec = new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, prime1, prime2, exp1, exp2, crtCoef);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            return factory.generatePrivate(keySpec);
        }
        throw new GeneralSecurityException("Not supported format of a private key");
    }
}

