/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.scripting;

import com.isomorphic.log.Logger;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;

public class PolyglotScriptEngine
implements ScriptEngine,
Compilable {
    private static final Logger log = new Logger(PolyglotScriptEngine.class.getName());
    private Object context;
    private static Class<?> contextClass;
    private static Class<?> contextBuilderClass;
    private static Class<?> valueClass;
    private static Class<?> sourceClass;
    private static Class<?> sourceBuilderClass;
    private ScriptEngineFactory factory;
    private ScriptContext scriptContext;
    private boolean closed = false;

    private PolyglotScriptEngine(Object context) {
        this.context = context;
        this.scriptContext = new SimpleScriptContext();
        this.scriptContext.setBindings(this.createBindings(), 100);
    }

    public static PolyglotScriptEngine create(ClassLoader classLoader) {
        if (contextClass == null) {
            log.debug("Cannot create PolyglotScriptEngine: Polyglot API not available");
            return null;
        }
        try {
            Method newBuilderMethod = contextClass.getMethod("newBuilder", String[].class);
            Object builder = newBuilderMethod.invoke(null, new Object[]{new String[]{"js"}});
            Method allowAllAccessMethod = contextBuilderClass.getMethod("allowAllAccess", Boolean.TYPE);
            builder = allowAllAccessMethod.invoke(builder, true);
            Method optionMethod = contextBuilderClass.getMethod("option", String.class, String.class);
            builder = optionMethod.invoke(builder, "js.ecmascript-version", "2022");
            builder = optionMethod.invoke(builder, "js.v8-compat", "true");
            builder = optionMethod.invoke(builder, "js.stack-trace-api", "true");
            Method buildMethod = contextBuilderClass.getMethod("build", new Class[0]);
            Object context = buildMethod.invoke(builder, new Object[0]);
            log.info("Created GraalJS Polyglot Context with full Java access enabled");
            PolyglotScriptEngine engine = new PolyglotScriptEngine(context);
            engine.initializeNashornCompatShims();
            return engine;
        }
        catch (Exception e) {
            log.warn((Object)("Failed to create GraalJS Polyglot Context: " + e.getMessage()), e);
            return null;
        }
    }

    public static boolean isAvailable() {
        return contextClass != null;
    }

    @Override
    public Object eval(String script) throws ScriptException {
        return this.eval(script, this.scriptContext);
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        if (this.closed) {
            throw new ScriptException("Engine has been closed");
        }
        try {
            Bindings bindings = context.getBindings(100);
            if (bindings != null) {
                this.setBindingsOnContext(bindings);
            }
            Method evalMethod = contextClass.getMethod("eval", String.class, CharSequence.class);
            Object value = evalMethod.invoke(this.context, "js", script);
            return this.convertValue(value);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                int lineNumber = -1;
                int columnNumber = -1;
                try {
                    Method getSourceLocationMethod;
                    Object sourceSection;
                    if (cause.getClass().getName().contains("PolyglotException") && (sourceSection = (getSourceLocationMethod = cause.getClass().getMethod("getSourceLocation", new Class[0])).invoke((Object)cause, new Object[0])) != null) {
                        Method getStartLineMethod = sourceSection.getClass().getMethod("getStartLine", new Class[0]);
                        Method getStartColumnMethod = sourceSection.getClass().getMethod("getStartColumn", new Class[0]);
                        lineNumber = (Integer)getStartLineMethod.invoke(sourceSection, new Object[0]);
                        columnNumber = (Integer)getStartColumnMethod.invoke(sourceSection, new Object[0]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new ScriptException(cause.getMessage(), null, lineNumber, columnNumber);
            }
            throw new ScriptException(e.getMessage());
        }
        catch (Exception e) {
            throw new ScriptException(e.getMessage());
        }
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        return this.eval(this.readAll(reader));
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        return this.eval(this.readAll(reader), context);
    }

    @Override
    public Object eval(String script, Bindings bindings) throws ScriptException {
        SimpleScriptContext tempContext = new SimpleScriptContext();
        tempContext.setBindings(bindings, 100);
        return this.eval(script, (ScriptContext)tempContext);
    }

    @Override
    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        return this.eval(this.readAll(reader), bindings);
    }

    private void setBindingsOnContext(Bindings bindings) throws Exception {
        Method getBindingsMethod = contextClass.getMethod("getBindings", String.class);
        Object jsBindings = getBindingsMethod.invoke(this.context, "js");
        Method putMemberMethod = valueClass.getMethod("putMember", String.class, Object.class);
        for (Map.Entry entry : bindings.entrySet()) {
            putMemberMethod.invoke(jsBindings, entry.getKey(), entry.getValue());
        }
    }

    private Object convertValue(Object value) throws Exception {
        if (value == null) {
            return null;
        }
        if (!valueClass.isInstance(value)) {
            return value;
        }
        Method isNullMethod = valueClass.getMethod("isNull", new Class[0]);
        if (((Boolean)isNullMethod.invoke(value, new Object[0])).booleanValue()) {
            return null;
        }
        Method isHostObjectMethod = valueClass.getMethod("isHostObject", new Class[0]);
        if (((Boolean)isHostObjectMethod.invoke(value, new Object[0])).booleanValue()) {
            Method asHostObjectMethod = valueClass.getMethod("asHostObject", new Class[0]);
            return asHostObjectMethod.invoke(value, new Object[0]);
        }
        Method isStringMethod = valueClass.getMethod("isString", new Class[0]);
        if (((Boolean)isStringMethod.invoke(value, new Object[0])).booleanValue()) {
            Method asStringMethod = valueClass.getMethod("asString", new Class[0]);
            return asStringMethod.invoke(value, new Object[0]);
        }
        Method isNumberMethod = valueClass.getMethod("isNumber", new Class[0]);
        if (((Boolean)isNumberMethod.invoke(value, new Object[0])).booleanValue()) {
            Method fitsInLongMethod = valueClass.getMethod("fitsInLong", new Class[0]);
            if (((Boolean)fitsInLongMethod.invoke(value, new Object[0])).booleanValue()) {
                Method asLongMethod = valueClass.getMethod("asLong", new Class[0]);
                return asLongMethod.invoke(value, new Object[0]);
            }
            Method asDoubleMethod = valueClass.getMethod("asDouble", new Class[0]);
            return asDoubleMethod.invoke(value, new Object[0]);
        }
        Method isBooleanMethod = valueClass.getMethod("isBoolean", new Class[0]);
        if (((Boolean)isBooleanMethod.invoke(value, new Object[0])).booleanValue()) {
            Method asBooleanMethod = valueClass.getMethod("asBoolean", new Class[0]);
            return asBooleanMethod.invoke(value, new Object[0]);
        }
        return value;
    }

    private String readAll(Reader reader) throws ScriptException {
        try {
            int read;
            StringBuilder sb = new StringBuilder();
            char[] buffer = new char[4096];
            while ((read = reader.read(buffer)) != -1) {
                sb.append(buffer, 0, read);
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new ScriptException(e.getMessage());
        }
    }

    @Override
    public void put(String key, Object value) {
        this.getBindings(100).put(key, value);
    }

    @Override
    public Object get(String key) {
        return this.getBindings(100).get(key);
    }

    @Override
    public Bindings getBindings(int scope) {
        return this.scriptContext.getBindings(scope);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        this.scriptContext.setBindings(bindings, scope);
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptContext getContext() {
        return this.scriptContext;
    }

    @Override
    public void setContext(ScriptContext context) {
        this.scriptContext = context;
    }

    @Override
    public ScriptEngineFactory getFactory() {
        if (this.factory == null) {
            this.factory = new PolyglotScriptEngineFactory();
        }
        return this.factory;
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return new PolyglotCompiledScript(this, script);
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        return this.compile(this.readAll(reader));
    }

    private void initializeNashornCompatShims() {
        String shimCode = "var Packages = new Proxy({}, {\n  get: function(target, prop) {\n    return new Proxy({__pkg: prop}, {\n      get: function(t, p) {\n        if (p === '__pkg') return t.__pkg;\n        var fullName = t.__pkg + '.' + p;\n        try { return Java.type(fullName); }\n        catch(e) { return new Proxy({__pkg: fullName}, this); }\n      }\n    });\n  }\n});\nvar java = Packages.java;\nvar javax = Packages.javax;\nvar jakarta = Packages.jakarta;\nvar com = Packages.com;\nvar org = Packages.org;\nfunction importClass(cls) {\n  if (typeof cls === 'string') cls = Java.type(cls);\n  var name = cls.class ? cls.class.getSimpleName() : cls.getName().split('.').pop();\n  globalThis[name] = cls;\n}\nfunction importPackage(pkg) {\n  // No-op: package imports not supported in GraalJS Polyglot mode\n  // Use Java.type('fully.qualified.ClassName') instead\n}\nfunction load(path) {\n  if (path && path.startsWith && path.startsWith('nashorn:')) {\n    // Nashorn-specific resources not available, silently ignore\n    return;\n  }\n  throw new Error('load() not supported in GraalJS Polyglot mode: ' + path);\n}\n";
        try {
            Method evalMethod = contextClass.getMethod("eval", String.class, CharSequence.class);
            evalMethod.invoke(this.context, "js", shimCode);
            log.debug("Initialized Nashorn compatibility shims for GraalJS Polyglot");
        }
        catch (Exception e) {
            log.warn("Failed to initialize Nashorn compatibility shims: " + e.getMessage());
        }
    }

    public void close() {
        if (!this.closed && this.context != null) {
            try {
                Method closeMethod = contextClass.getMethod("close", new Class[0]);
                closeMethod.invoke(this.context, new Object[0]);
                this.closed = true;
                log.debug("Closed Polyglot context");
            }
            catch (Exception e) {
                log.warn("Error closing Polyglot context: " + e.getMessage());
            }
        }
    }

    static {
        try {
            contextClass = Class.forName("org.graalvm.polyglot.Context");
            contextBuilderClass = Class.forName("org.graalvm.polyglot.Context$Builder");
            valueClass = Class.forName("org.graalvm.polyglot.Value");
            sourceClass = Class.forName("org.graalvm.polyglot.Source");
            sourceBuilderClass = Class.forName("org.graalvm.polyglot.Source$Builder");
            log.debug("GraalJS Polyglot classes loaded successfully");
        }
        catch (ClassNotFoundException e) {
            log.debug("GraalJS Polyglot API not available: " + e.getMessage());
            contextClass = null;
        }
    }

    private static class PolyglotScriptEngineFactory
    implements ScriptEngineFactory {
        private PolyglotScriptEngineFactory() {
        }

        @Override
        public String getEngineName() {
            return "GraalJS Polyglot";
        }

        @Override
        public String getEngineVersion() {
            return "24.1.1";
        }

        @Override
        public List<String> getExtensions() {
            return Arrays.asList("js", "mjs");
        }

        @Override
        public List<String> getMimeTypes() {
            return Arrays.asList("application/javascript", "text/javascript");
        }

        @Override
        public List<String> getNames() {
            return Arrays.asList("GraalJS", "graal.js", "Graal.js", "javascript", "JavaScript", "js", "JS", "ecmascript", "ECMAScript", "GraalJSPolyglot");
        }

        @Override
        public String getLanguageName() {
            return "ECMAScript";
        }

        @Override
        public String getLanguageVersion() {
            return "ECMA 262 Edition 13";
        }

        @Override
        public Object getParameter(String key) {
            switch (key) {
                case "javax.script.engine": {
                    return this.getEngineName();
                }
                case "javax.script.engine_version": {
                    return this.getEngineVersion();
                }
                case "javax.script.language": {
                    return this.getLanguageName();
                }
                case "javax.script.language_version": {
                    return this.getLanguageVersion();
                }
                case "javax.script.name": {
                    return this.getNames().get(0);
                }
            }
            return null;
        }

        @Override
        public String getMethodCallSyntax(String obj, String method, String ... args) {
            StringBuilder sb = new StringBuilder();
            sb.append(obj).append(".").append(method).append("(");
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(args[i]);
            }
            sb.append(")");
            return sb.toString();
        }

        @Override
        public String getOutputStatement(String toDisplay) {
            return "print(" + toDisplay + ")";
        }

        @Override
        public String getProgram(String ... statements) {
            StringBuilder sb = new StringBuilder();
            for (String statement : statements) {
                sb.append(statement).append(";\n");
            }
            return sb.toString();
        }

        @Override
        public ScriptEngine getScriptEngine() {
            return PolyglotScriptEngine.create(this.getClass().getClassLoader());
        }
    }

    private static class PolyglotCompiledScript
    extends CompiledScript {
        private final PolyglotScriptEngine engine;
        private final String script;
        private Object parsedSource;

        PolyglotCompiledScript(PolyglotScriptEngine engine, String script) {
            this.engine = engine;
            this.script = script;
            try {
                if (sourceClass != null) {
                    Method newBuilderMethod = sourceClass.getMethod("newBuilder", String.class, CharSequence.class, String.class);
                    Object builder = newBuilderMethod.invoke(null, "js", script, "script");
                    Method buildLiteralMethod = sourceBuilderClass.getMethod("buildLiteral", new Class[0]);
                    this.parsedSource = buildLiteralMethod.invoke(builder, new Object[0]);
                }
            }
            catch (Exception e) {
                log.debug("Could not pre-parse source: " + e.getMessage());
                this.parsedSource = null;
            }
        }

        @Override
        public Object eval(ScriptContext context) throws ScriptException {
            return this.engine.eval(this.script, context);
        }

        @Override
        public ScriptEngine getEngine() {
            return this.engine;
        }
    }
}

