/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.PlaywrightResultParser;
import com.isomorphic.autotest.ShowcaseSpecifier;
import com.isomorphic.autotest.TestRunnerConfiguration;
import com.isomorphic.autotest.TestRunnerHelper;
import com.isomorphic.autotest.TestRunnerLauncher;
import com.isomorphic.log.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class PlaywrightShowcaseRunner {
    private static Logger log = new Logger(PlaywrightShowcaseRunner.class.getName());
    private final TestRunnerConfiguration config;

    public PlaywrightShowcaseRunner(TestRunnerConfiguration config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runShowcaseTests(ShowcaseSpecifier showcase, TestRunnerHelper.TestCallback callback) throws IOException, InterruptedException {
        List<String> command = this.buildCommand(showcase);
        log.info((Object)("Starting Playwright showcase runner: " + String.join((CharSequence)" ", command)));
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectErrorStream(false);
        String qaPath = this.config.getFileRoot() + "/smartclient/QA";
        File qaDir = new File(qaPath);
        if (qaDir.exists()) {
            pb.directory(qaDir);
        }
        pb.environment().putAll(System.getenv());
        Process process = pb.start();
        BufferedReader stdout = new BufferedReader(new InputStreamReader(process.getInputStream()));
        Thread stderrThread = new Thread(() -> {
            try {
                String line;
                BufferedReader stderr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((line = stderr.readLine()) != null) {
                    if (line.startsWith("[PASS]") || line.startsWith("[SKIP]")) {
                        log.info((Object)("Playwright: " + line));
                        continue;
                    }
                    if (line.startsWith("[FAIL]")) {
                        log.warn((Object)("Playwright: " + line));
                        continue;
                    }
                    log.debug((Object)("Playwright stderr: " + line));
                }
            }
            catch (IOException e) {
                log.error((Object)"Error reading Playwright stderr", (Throwable)e);
            }
        });
        stderrThread.setDaemon(true);
        stderrThread.start();
        try {
            PlaywrightResultParser.parseAndCallback(stdout, callback);
        }
        finally {
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                log.warn((Object)("Playwright showcase runner exited with code: " + exitCode));
            }
            stderrThread.join(5000L);
        }
    }

    private List<String> buildCommand(ShowcaseSpecifier showcase) {
        int timeout;
        int port;
        ArrayList<String> command = new ArrayList<String>();
        command.add("node");
        String runnerPath = this.config.getFileRoot() + "/isomorphic/QA/pwShowcaseRunner.js";
        command.add(runnerPath);
        command.add("--java");
        String showcaseType = this.getShowcaseType(showcase);
        if (showcaseType != null) {
            command.add("--showcase");
            command.add(showcaseType);
        }
        if ((port = this.config.getHttpPort(showcase)) > 0) {
            command.add("--port");
            command.add(String.valueOf(port));
        }
        if ((timeout = this.config.getSeleniumTimeout()) > 0) {
            command.add("--timeout");
            command.add(String.valueOf(timeout * 1000));
        }
        command.add("--sample-timeout");
        command.add(String.valueOf(Math.max(30000, timeout * 1000 / 2)));
        if (this.config.hasGoogleMapsAPIKey()) {
            command.add("--google-maps-key");
            command.add(this.config.getGoogleMapsAPIKey());
        }
        if (this.config instanceof TestRunnerLauncher && !((TestRunnerLauncher)this.config).getHeadless()) {
            command.add("--no-headless");
        }
        return command;
    }

    private String getShowcaseType(ShowcaseSpecifier showcase) {
        if (showcase == null) {
            return "smartclient";
        }
        if (showcase.isSmartClient()) {
            return "smartclient";
        }
        if (showcase.isSmartReact()) {
            return "smartreact";
        }
        if (showcase.isSmartGWTEE()) {
            return "smartgwtee";
        }
        return "smartgwtlgpl";
    }
}

