/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.base.Preconditions;
import com.google.common.io.CountingOutputStream;
import com.google.common.io.FileBackedOutputStream;
import com.google.common.net.MediaType;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.InitialHandshakeResponse;
import org.openqa.selenium.remote.JsonWireProtocolResponse;
import org.openqa.selenium.remote.NewSessionPayload;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.W3CHandshakeResponse;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class ProtocolHandshake {
    private static final Logger LOG = Logger.getLogger(ProtocolHandshake.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result createSession(HttpClient client, Command command) throws IOException {
        Capabilities desired = (Capabilities)command.getParameters().get("desiredCapabilities");
        desired = desired == null ? new ImmutableCapabilities() : desired;
        int threshold = (int)Math.min(Runtime.getRuntime().freeMemory() / 10L, Integer.MAX_VALUE);
        FileBackedOutputStream os = new FileBackedOutputStream(threshold);
        try (CountingOutputStream counter = new CountingOutputStream((OutputStream)os);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)counter, StandardCharsets.UTF_8);
             NewSessionPayload payload = NewSessionPayload.create(desired);){
            payload.writeTo(writer);
            try (InputStream rawIn = os.asByteSource().openBufferedStream();
                 BufferedInputStream contentStream = new BufferedInputStream(rawIn);){
                Optional<Result> result = this.createSession(client, contentStream, counter.getCount());
                if (result.isPresent()) {
                    Result toReturn = result.get();
                    LOG.info(String.format("Detected dialect: %s", new Object[]{toReturn.dialect}));
                    Result result2 = toReturn;
                    return result2;
                }
            }
        }
        finally {
            os.reset();
        }
        throw new SessionNotCreatedException(String.format("Unable to create new remote session. desired capabilities = %s", desired));
    }

    private Optional<Result> createSession(HttpClient client, InputStream newSessionBlob, long size) throws IOException {
        Map blob;
        HttpRequest request = new HttpRequest(HttpMethod.POST, "/session");
        long start = System.currentTimeMillis();
        request.setHeader("Content-Length", String.valueOf(size));
        request.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
        request.setContent(newSessionBlob);
        HttpResponse response = client.execute(request);
        long time = System.currentTimeMillis() - start;
        try {
            blob = (Map)new Json().toType(response.getContentString(), (Type)((Object)Map.class));
        }
        catch (JsonException e) {
            throw new WebDriverException("Unable to parse remote response: " + response.getContentString(), e);
        }
        InitialHandshakeResponse initialResponse = new InitialHandshakeResponse(time, response.getStatus(), blob);
        return Stream.of(new JsonWireProtocolResponse().getResponseFunction(), new W3CHandshakeResponse().getResponseFunction()).map(func -> (Result)func.apply(initialResponse)).filter(Objects::nonNull).findFirst();
    }

    public static class Result {
        private static Function<Object, Proxy> massageProxy = obj -> {
            if (obj instanceof Proxy) {
                return (Proxy)obj;
            }
            if (!(obj instanceof Map)) {
                return null;
            }
            Map rawMap = (Map)obj;
            for (Object key : rawMap.keySet()) {
                if (key instanceof String) continue;
                return null;
            }
            return new Proxy((Map)obj);
        };
        private final Dialect dialect;
        private final Map<String, ?> capabilities;
        private final SessionId sessionId;

        Result(Dialect dialect, String sessionId, Map<String, ?> capabilities) {
            this.dialect = dialect;
            this.sessionId = new SessionId((String)Preconditions.checkNotNull((Object)sessionId));
            this.capabilities = capabilities;
            if (capabilities.containsKey("proxy")) {
                capabilities.put("proxy", massageProxy.apply(capabilities.get("proxy")));
            }
        }

        public Dialect getDialect() {
            return this.dialect;
        }

        public Response createResponse() {
            Response response = new Response(this.sessionId);
            response.setValue(this.capabilities);
            response.setStatus(0);
            response.setState("success");
            return response;
        }

        public String toString() {
            return String.format("%s: %s", new Object[]{this.dialect, this.capabilities});
        }
    }
}

