/* Auto-Generated React */
import React from 'react';
import 'smartclient-eval/release';
import 'smartclient-eval/skins/Tahoe';

import { SC, DynamicForm, HLayout, IButton, LGField, ListGrid, SelectItem, SortSpecifier, VLayout } from 'smartclient-eval/react';

// a "render target" can be defined to allow JSX to be loaded dynamically into an existing application.  This Showcase sets a
// render target of "showcaseSample" so each JSX file can be loaded and later removed when the user is done with the sample.
let target = SC.getRenderTarget() || "showcaseSample";

let onDsSelectorChanged = function (form, item, value) {
    if (value == 'UserIssues') {
        buttonLayout.show();
        lgWorld.hide();
        lgIssues.show();
    } else {
        buttonLayout.hide();
        lgWorld.show();
        lgIssues.hide();
        lgWorld.fetchData(lgWorld.getCriteria());
    }
};
let onUrgencyClick = function () {
    var aiAssessedUrgencyField = lgIssues.getFieldByName('aiAssessedUrgency');
    if (!aiAssessedUrgencyField) {
        aiAssessedUrgencyField = {
            name: 'aiAssessedUrgency',
            title: 'Issue Urgency',
            width: 175,
            aiFieldPrompt: 'assess the urgency of the reported issue',
            canEditAISummary: false,
            showHover: true
        };
        lgIssues.addField(aiAssessedUrgencyField);
    }
    lgIssues.showField(aiAssessedUrgencyField);
    var sortFieldCount = lgIssues.getSortFieldCount();
    if (sortFieldCount == 0 || sortFieldCount == 1 && lgIssues.isSortField(aiAssessedUrgencyField.name)) {
        lgIssues.toggleSort(aiAssessedUrgencyField.name);
    } else {
        lgIssues.sort(aiAssessedUrgencyField.name, 'ascending');
    }
};
let onImpactClick = function () {
    var aiAssessedImpactField = lgIssues.getFieldByName('aiAssessedImpact');
    if (!aiAssessedImpactField) {
        aiAssessedImpactField = {
            name: 'aiAssessedImpact',
            title: 'Department Impact',
            width: 175,
            aiFieldPrompt: 'assess the potential impact to the Department of the issue',
            canEditAISummary: false,
            showHover: true
        };
        lgIssues.addField(aiAssessedImpactField);
    }
    lgIssues.showField(aiAssessedImpactField);
    var sortFieldCount = lgIssues.getSortFieldCount();
    if (sortFieldCount == 0 || sortFieldCount == 1 && lgIssues.isSortField(aiAssessedImpactField.name)) {
        lgIssues.toggleSort(aiAssessedImpactField.name);
    } else {
        lgIssues.sort(aiAssessedImpactField.name, 'ascending');
    }
};
let onCustomPromptClick = function () {
    lgIssues.editAISortField();
};

// SC.render() calls ReactDOM.render() in React pre-18, and
// ReactDOM.createRoot().render() in React 18+, to avoid deprecation warnings.
SC.render(
    <VLayout membersMargin="15" width="100%" height="100%">
        <members>
            <DynamicForm ID="form" width="600">
                <items>
                    <SelectItem name="dsSelector" title="DataSource" defaultValue="UserIssues" required="true" changed={onDsSelectorChanged}>
                        <valueMap>
                                <value>UserIssues</value>
                                <value>worldDS</value>
                        </valueMap>
                    </SelectItem>
                </items>
            </DynamicForm>
            <HLayout membersMargin="10" ID="buttonLayout" width="*">
                <members>
                    <IButton title="Urgency" width="150" prompt="By analyzing each record’s Description for time‑sensitivity, the AI generates an urgency score and automatically moves the highest‑urgency items to the top of the grid. Ties are broken by ascending IssueID (first‑come, first‑served)." click={onUrgencyClick}/>
                    <IButton title="Impact" width="150" prompt="Select the issue category based on its impact: Critical (threatens core functions/safety), High (major disruptions needing immediate attention), Moderate (manageable disruptions), or Low (minimal effect on operations)." click={onImpactClick}/>
                    <IButton title="Custom Prompt" click={onCustomPromptClick}/>
                </members>
            </HLayout>
            <ListGrid ID="lgIssues" canHover="true" showHover="false" dataSource="UserIssues" autoFetchData="true" width="100%" height="100%" canAddAISortFields="true" sortViaAIMode="AIDE">
                <fields>
                    <LGField name="Issue_ID" width="150"/>
                    <LGField name="Reported_By" width="200"/>
                    <LGField name="Department" width="150"/>
                    <LGField name="Category" width="150"/>
                    <LGField name="Issue_Description" width="250" showHover="true" hoverWidth="300"/>
                </fields>
                <initialSort>
                    <SortSpecifier direction="ascending" property="Issue_ID"/>
                </initialSort>
            </ListGrid>
            <ListGrid ID="lgWorld" canHover="true" showHover="false" showFilterEditor="true" dataSource="worldDS" autoFetchData="false" width="100%" height="100%" visibility="hidden" dataFetchMode="local" canPickOmittedFields="true" canAddAISortFields="true" sortViaAIMode="AIDE" aiSortFieldMaxRecords="250">
                <fields>
                    <LGField name="countryCode" type="image" title="Flag" width="70" imageURLPrefix="flags/24/" imageURLSuffix=".png"/>
                    <LGField name="countryName" width="235"/>
                    <LGField name="continent" width="125"/>
                    <LGField name="government" width="235"/>
                    <LGField name="pressFreedom" title="Press Freedom" width="175" showHover="true" aiFieldPrompt="press freedom in the named country" canEditAISummary="false"/>
                </fields>
                <implicitCriteria fieldName="independence" operator="notNull"/>
                <initialCriteria continent="Europe"/>
                <initialSort>
                    <SortSpecifier direction="ascending" property="pressFreedom"/>
                    <SortSpecifier direction="ascending" property="countryName"/>
                </initialSort>
            </ListGrid>
        </members>
    </VLayout>,
    document.getElementById(target)
);
