/* Auto-Generated React */
import React from 'react';
import 'smartclient-eval/release';
import 'smartclient-eval/skins/Tahoe';

import { SC, Calendar, DSField, DataSource, HeaderItem, RadioGroupItem, SelectItem, TextItem, Validator } from 'smartclient-eval/react';

// a "render target" can be defined to allow JSX to be loaded dynamically into an existing application.  This Showcase sets a
// render target of "showcaseSample" so each JSX file can be loaded and later removed when the user is done with the sample.
let target = SC.getRenderTarget() || "showcaseSample";

var _today = new Date(2021, 4, 23);
var _start = _today.getDate() - _today.getDay();
var _month = _today.getMonth();
var _year = _today.getFullYear();
var eventData = [
    {
        eventId: 1,
        name: 'Meeting',
        description: 'Shareholders meeting: monthly forecast report',
        startDate: new Date(_year, _month, _start + 2, 9),
        endDate: new Date(_year, _month, _start + 2, 14)
    },
    {
        eventId: 2,
        name: 'Realtor',
        description: 'This canvas is styled by color settings on the CalendarEvent',
        startDate: new Date(_year, _month, _start + 3, 8),
        endDate: new Date(_year, _month, _start + 3, 10),
        headerTextColor: 'black',
        headerBackgroundColor: 'orange',
        headerBorderColor: 'darkorange',
        textColor: 'darkgreen',
        borderColor: 'darkorange',
        backgroundColor: '#ffffcc'
    },
    {
        eventId: 3,
        name: 'Soccer',
        description: 'Little league soccer finals',
        startDate: new Date(_year, _month, _start + 4, 13),
        endDate: new Date(_year, _month, _start + 4, 16)
    },
    {
        eventId: 4,
        name: 'Sleep',
        description: 'Catch up on sleep',
        startDate: new Date(_year, _month, _start + 4, 5),
        endDate: new Date(_year, _month, _start + 4, 9)
    },
    {
        eventId: 5,
        name: 'Inspection',
        description: 'This canvas is styled and disabled by custom styleName and canEdit settings on the CalendarEvent',
        startDate: new Date(_year, _month, _start + 4, 10),
        endDate: new Date(_year, _month, _start + 4, 12),
        styleName: 'testStyle',
        canEdit: false
    },
    {
        eventId: 6,
        name: 'Airport run',
        description: 'This canvas is styled by color settings on the CalendarEvent',
        startDate: new Date(_year, _month, _start + 4, 1),
        endDate: new Date(_year, _month, _start + 4, 3),
        headerTextColor: 'white',
        headerBackgroundColor: 'green',
        headerBorderColor: 'green',
        textColor: 'darkgreen',
        borderColor: 'darkgreen',
        backgroundColor: 'lightgreen'
    },
    {
        eventId: 7,
        name: 'Dinner Party',
        description: 'Prepare elaborate meal for friends',
        startDate: new Date(_year, _month, _start + 4, 17),
        endDate: new Date(_year, _month, _start + 4, 20)
    },
    {
        eventId: 8,
        name: 'Poker',
        description: 'Poker at Steve\'s house',
        startDate: new Date(_year, _month, _start + 4, 21),
        endDate: new Date(_year, _month, _start + 4, 23)
    },
    {
        eventId: 9,
        name: 'Directors Meeting',
        description: 'Board of directors meeting: discussion of next months strategy',
        startDate: new Date(_year, _month, _start + 5, 11),
        endDate: new Date(_year, _month, _start + 5, 15)
    }
];
eventData.getDataStartDate = function () {
    return new Date(2021, 4, 23);
};

// SC.render() calls ReactDOM.render() in React pre-18, and
// ReactDOM.createRoot().render() in React 18+, to avoid deprecation warnings.
SC.render(
    <>
        <DataSource ID="eventDS" title="eventDS" clientOnly="true" testData={eventData}>
            <fields>
                <DSField canFilter="true" name="eventId" type="sequence" primaryKey="true" title="Event Id" canEdit="false" readOnlyDisplay="static">
                    <validators>
                        <Validator type="isInteger" stopIfFalse="true" typeCastValidator="true" ID="_3" defaultErrorMessage="Must be a whole number.">
                            <resultingValue></resultingValue>
                        </Validator>
                    </validators>
                </DSField>
                <DSField name="name" title="Name"/>
                <DSField name="description" title="Description"/>
                <DSField name="startDate" title="Start Date"/>
                <DSField name="endDate" title="End Date"/>
            </fields>
        </DataSource>

        <Calendar dataSource="eventDS" autoFetchData="true" ID="eventCalendar" startDate={eventData.getDataStartDate()}>
            <eventEditorFields>
                <TextItem defaultValue="A New Event" name="name" required="true"/>
                <TextItem name="description"/>
                <HeaderItem defaultValue="Event Options"/>
                <SelectItem defaultToFirstOption="true" name="repeats" title="Repeats" colSpan="4">
                    <valueMap>
                            <value>Does not repeat</value>
                            <value>Daily</value>
                            <value>Weekly</value>
                            <value>Monthly</value>
                            <value>Yearly</value>
                    </valueMap>
                </SelectItem>
                <SelectItem defaultToFirstOption="true" name="reminderType" title="Reminder" width="70">
                    <valueMap>
                            <value>Pop-up</value>
                            <value>Email</value>
                    </valueMap>
                </SelectItem>
                <TextItem defaultValue="10" name="reminderValue" showTitle="false" width="60"/>
                <SelectItem defaultToFirstOption="true" name="reminderUnits" showTitle="false" width="70">
                    <valueMap>
                            <value>minutes</value>
                            <value>hours</value>
                            <value>days</value>
                    </valueMap>
                </SelectItem>
            </eventEditorFields>
            <eventDialogFields>
                <TextItem name="name" required="true"/>
                <RadioGroupItem vertical="false" name="sharing" title="Sharing" width="50">
                    <valueMap>
                            <value>Public</value>
                            <value>Private</value>
                    </valueMap>
                </RadioGroupItem>
            </eventDialogFields>
        </Calendar>
    </>,
    document.getElementById(target)
);
