// this sample uses previously captured responses from Yahoo finance so that if Yahoo is unavailable, the sample still works.
// at the point the Yahoo web service originally used to build this sample appears to be permanently unavailable, so setting
// this variable to true definitely will not work.
USE_YAHOO_FINANCE = false;

isc.FacetChart.create({
    ID: "stockChart",
    autoDraw: false,
    showTitle: false,
    minWidth: 500,
    minHeight: 500,
    showDataAxisLabel: false,
    canZoom: true,

    chartType: "Area",
    facets: [{ id: "date", title: "Day" }],
    valueProperty: "close",
    labelCollapseMode: "time",
    minLabelGap: 4,
    rotateLabels: "never",
    allowedChartTypes: ["Area", "Line"],

    _loadingMessage: "${loadingImage} Loading data...",

    _errorMessage:
        (USE_YAHOO_FINANCE
         ? "This test uses sample data provided by Yahoo&trade; Finance, " +
           "but Yahoo data is not currently available.  Refresh the sample to " +
           "try again.  You may need to wait a while for the Yahoo service to " +
           "become available again."
         : "Data is not currently available.<br>Please make sure that you are connected " +
           "to the Internet and then refresh the sample to try again."),

    _showMessage : function (message, alignCenter) {
        var label = this.messageLabel,
            align = alignCenter ? "center" : "left",
            snapTo = alignCenter ? "T" : "TL";
        if (label == null) {
            label = this.addPeer(isc.Label.create({
                autoDraw: false,
                width: 400,
                padding: 10,
                contents: message,
                align: align,
                dynamicContents: true,
                dynamicContentsVars: {
                    loadingImage: isc.Canvas.imgHTML(isc.Canvas.loadingImageSrc,
                                                     isc.Canvas.loadingImageSize)
                },
                valign: "center",
                showEdges: false,
                snapTo: snapTo
            }), "messageLabel");
        } else {
            label.setContents(message);
            label.setAlign(align);
            label.setSnapTo(snapTo);
        }

        label.show();
    },

    _hideMessage : function () {
        if (this.messageLabel != null) {
            this.messageLabel.hide();
        }
    },

    _updateData : function (symbol, name) {
        // Clear the chart and display a loading message.
        this.destroyItems();
        this._showMessage(this._loadingMessage, true);

        var stockDs = isc.DataSource.get(USE_YAHOO_FINANCE ? "stockData" : "staticStockData");
        stockDs.fetchData({ symbol: symbol }, function (dsResponse, data, dsRequest) {
            if (isc.isAn.Array(data) && data.length > 0) {
                stockChart._hideMessage();
                stockChart.title = name;
                // When using labelCollapseMode:"time", the data must be sorted in ascending
                // order by the data label facet ('date' in this case).
                stockChart.setData(data.sortByProperty("date", true));
            } else {
                stockChart._showMessage(stockChart._errorMessage, false);
                stockChart.title = null;
                stockChart.setData([]);
            }
        }, { willHandleError : true });
    }
});

isc.DynamicForm.create({
    ID: "symbolForm",
    autoDraw: false,
    items: [{
        name: "symbol",
        title: "Stock Symbol",
        canEdit: false,
        editorType: "ComboBoxItem",
        autoFetchData: false,
        optionDataSource: "nasdaqSymbols",
        pickListWidth: 450,
        pickListFields: [{ name: "symbol"}, { name: "name" }],
        displayField: "name",
        valueField: "symbol",
        sortField: "symbol",
        changeOnKeypress: false,
        changed : function (form, self, symbol) {
            if (!symbol) {
                stockChart.setData([]);
            } else {
                stockChart._updateData(symbol, this.getDisplayValue(symbol));
            }
        }
    }]
});
var symbolItem = symbolForm.getItem("symbol");

isc.VLayout.create({
    width: "100%",
    height: "100%",
    margin: 5,
    membersMargin: 20,
    members: [symbolForm, stockChart]
});

symbolItem.fetchData(function (symbolItem, dsResponse, data, dsRequest) {
    if (!(dsResponse.status < 0) && isc.isAn.Array(data) && data.length > 0) {
        symbolItem.setCanEdit(true);
        var symbol = data[0].symbol;
        symbolItem.setValue(symbol);
        stockChart._updateData(symbol, symbolItem.getDisplayValue(symbol));
    }
});
