/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.gss;

import com.google.gwt.core.ext.Generator;
import com.google.gwt.resources.gss.ast.CssDotPathNode;
import com.google.gwt.resources.gss.ast.CssJavaExpressionNode;
import com.google.gwt.resources.gss.ast.CssRuntimeConditionalRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConditionalBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConditionalRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssRootNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTree;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.passes.CompactPrinter;
import java.util.Stack;

public class CssPrinter
extends CompactPrinter {
    private static final int CONCAT_EXPRESSION_LIMIT = 20;
    private static final String CONTATENATION = " + ";
    private static final String COLON = " : ";
    private static final String LEFT_PARENTHESIS = "(";
    private static final String RIGHT_PARENTHESIS = ")";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String CONTATENATION_BLOCK = ") + (";
    private static final String CONDITIONAL_OPERATOR = ") ? (";
    private final Stack<Boolean> elseNodeFound = new Stack();
    private StringBuilder masterStringBuilder;
    private String css;
    private int concatenationNumber;

    public CssPrinter(CssTree tree) {
        super(tree);
    }

    public CssPrinter(CssNode node) {
        super(node);
    }

    public boolean enterTree(CssRootNode root) {
        this.masterStringBuilder.append(LEFT_PARENTHESIS);
        return super.enterTree(root);
    }

    public String getCompactPrintedString() {
        return this.css;
    }

    public void leaveTree(CssRootNode root) {
        this.masterStringBuilder.append(this.flushInternalStringBuilder()).append(RIGHT_PARENTHESIS);
        super.leaveTree(root);
    }

    public void runPass() {
        this.masterStringBuilder = new StringBuilder();
        this.concatenationNumber = 0;
        super.runPass();
        this.css = this.masterStringBuilder.toString().replaceAll(" \\+ \\(\"\"\\)", "").replaceAll("^\\(\"\"\\) \\+ ", "");
    }

    public boolean enterConditionalBlock(CssConditionalBlockNode node) {
        this.masterStringBuilder.append(this.flushInternalStringBuilder());
        this.masterStringBuilder.append(CONTATENATION_BLOCK);
        this.elseNodeFound.push(false);
        return true;
    }

    public void leaveConditionalBlock(CssConditionalBlockNode block) {
        if (!this.elseNodeFound.pop().booleanValue()) {
            this.masterStringBuilder.append(DOUBLE_QUOTE).append(DOUBLE_QUOTE);
        }
        this.masterStringBuilder.append(CONTATENATION_BLOCK);
        this.concatenationNumber = 0;
    }

    public boolean enterConditionalRule(CssConditionalRuleNode node) {
        if (node.getType() == CssAtRuleNode.Type.ELSE) {
            this.elseNodeFound.pop();
            this.elseNodeFound.push(true);
            this.masterStringBuilder.append(LEFT_PARENTHESIS);
        } else {
            CssRuntimeConditionalRuleNode conditionalRuleNode = (CssRuntimeConditionalRuleNode)node;
            this.masterStringBuilder.append(LEFT_PARENTHESIS);
            this.masterStringBuilder.append(conditionalRuleNode.getRuntimeCondition().getValue());
            this.masterStringBuilder.append(CONDITIONAL_OPERATOR);
            this.concatenationNumber = 0;
        }
        return true;
    }

    public void leaveConditionalRule(CssConditionalRuleNode node) {
        this.masterStringBuilder.append(this.flushInternalStringBuilder()).append(RIGHT_PARENTHESIS);
        if (node.getType() != CssAtRuleNode.Type.ELSE) {
            this.masterStringBuilder.append(COLON);
        }
    }

    protected void appendValueNode(CssValueNode node) {
        if (node instanceof CssJavaExpressionNode || node instanceof CssDotPathNode) {
            this.concat(LEFT_PARENTHESIS + node.getValue() + RIGHT_PARENTHESIS);
        } else {
            super.appendValueNode(node);
        }
    }

    private void concat(String stringToAppend) {
        this.masterStringBuilder.append(this.flushInternalStringBuilder());
        this.appendConcatOperation();
        this.masterStringBuilder.append(stringToAppend);
        this.appendConcatOperation();
    }

    private void appendConcatOperation() {
        if (this.concatenationNumber >= 20) {
            this.masterStringBuilder.append(CONTATENATION_BLOCK);
            this.concatenationNumber = 0;
        } else {
            this.masterStringBuilder.append(CONTATENATION);
            ++this.concatenationNumber;
        }
    }

    private String flushInternalStringBuilder() {
        String content = DOUBLE_QUOTE + Generator.escape((String)this.sb.toString()) + DOUBLE_QUOTE;
        this.sb = new StringBuilder();
        return content;
    }
}

