/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTable;
import java.util.List;
import java.util.Map;

public class CacheDriver
extends SQLDriver {
    private static Logger log = new Logger(CacheDriver.class.getName());

    public CacheDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
    }

    @Override
    public boolean supportsNativeReplace() {
        return false;
    }

    @Override
    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        throw new Exception("Not supported.");
    }

    @Override
    public String formatValue(Object value) {
        return value.toString();
    }

    @Override
    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        String output = this.escapeColumnName(columnName);
        if (remapName != null && !columnName.equals(remapName)) {
            output = output + " AS " + this.escapeColumnName(remapName);
        }
        if (tableName != null) {
            output = tableName + "." + output;
        }
        return output;
    }

    @Override
    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        String val = value.toString();
        if (val.equals("")) {
            return "\"\"";
        }
        return "'" + this.escapeValueUnquoted(value.toString(), false) + "'";
    }

    @Override
    public String escapeValueForFilter(Object value, String filterStyle) {
        if (value == null) {
            return null;
        }
        String rtn = "'";
        if (!"startsWith".equals(filterStyle)) {
            rtn = rtn + "%";
        }
        return rtn + this.escapeValueUnquoted(value, true) + "%'";
    }

    @Override
    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = this.matcher.reset(value.toString()).usePattern(SINGLE_QUOTE_PATTERN).replaceAll(SINGLE_QUOTE_ESCAPE);
        if (escapeForFilter) {
            escaped = this.matcher.reset(escaped).usePattern(BACKSLASH_PATTERN).replaceAll(BACKSLASH_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(PERCENT_PATTERN).replaceAll(PERCENT_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(UNDERSCORE_PATTERN).replaceAll(UNDERSCORE_ESCAPE);
        }
        return escaped;
    }

    @Override
    public String getNextSequenceValue(String columnName, SQLDataSource ds) throws Exception {
        throw new Exception("Not Supported");
    }

    public String getCurrentSequenceValue(String columnName) throws Exception {
        throw new Exception("Not Supported");
    }

    @Override
    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        String expr = "CASE " + column;
        for (String actualValue : valueMap.keySet()) {
            String displayValue = this.getLocalizedDisplayValue(valueMap.get(actualValue), request);
            displayValue = this.escapeValue(displayValue);
            expr = expr + " WHEN '" + actualValue + "' THEN " + displayValue;
        }
        expr = expr + " END";
        return expr;
    }

    @Override
    public int caseInsensitiveStrategy() {
        return 0;
    }

    @Override
    public String getNaturalDatabaseObjectName(String objectName) {
        return objectName;
    }

    @Override
    public String getDummyQuery() {
        return null;
    }
}

