/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.CacheDriver;
import com.isomorphic.sql.DB2Driver;
import com.isomorphic.sql.MysqlDriver;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLServerDriver;
import com.isomorphic.util.DataTools;
import com.isomorphic.velocity.Velocity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLValuesClause
extends Base {
    private static Logger log = new Logger(SQLValuesClause.class.getName());
    private DSRequest dsRequest;
    private SQLDataSource dataSource;
    private Map values;
    Map field2ColumnMap = null;
    private List customValueFields = null;

    public SQLValuesClause(DSRequest request, SQLDataSource dataSource) throws Exception {
        this(request, request.getValues(), dataSource, (List)request.constraints());
    }

    public SQLValuesClause(DSRequest dsRequest, Map values, SQLDataSource dataSource, List constraints) throws Exception {
        this.dsRequest = dsRequest;
        this.dataSource = dataSource;
        this.field2ColumnMap = dataSource.getCorrectDs2NativeFieldMap();
        if (constraints != null) {
            values = DataTools.subsetMap((Map)values, (List)constraints);
        }
        this.values = this.filterValid(values);
    }

    public static Object create(DSRequest request, SQLDataSource dataSource) throws Exception {
        Object rawValues = request.getRawValues();
        if (rawValues == null || rawValues instanceof Map) {
            return new SQLValuesClause(request, dataSource);
        }
        if (rawValues instanceof List) {
            ArrayList<SQLValuesClause> valuesClauses = new ArrayList<SQLValuesClause>();
            List constraints = (List)request.constraints();
            for (Map values : (List)rawValues) {
                if (values.isEmpty()) continue;
                valuesClauses.add(new SQLValuesClause(request, values, dataSource, constraints));
            }
            return valuesClauses;
        }
        throw new Exception("Data type: '" + rawValues.getClass().getName() + "' is not supported");
    }

    public List getCustomValueFields() {
        return this.customValueFields;
    }

    public void setCustomValueFields(List fields) {
        this.customValueFields = fields;
    }

    public boolean isEmpty() {
        return this.values == null;
    }

    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        return 1;
    }

    private Map filterValid(Map data) throws Exception {
        if (data == null) {
            return null;
        }
        HashMap validData = new HashMap();
        List validColumns = this.dataSource.getFieldNames();
        ArrayList<String> invalidColumns = new ArrayList<String>();
        for (String columnName : data.keySet()) {
            if (!validColumns.contains(columnName)) {
                invalidColumns.add(columnName);
                continue;
            }
            DSField field = this.dataSource.getField(columnName);
            if (field != null && (field.get((Object)"includeFrom") != null || field.isInapplicable())) {
                invalidColumns.add(columnName);
                continue;
            }
            validData.put(columnName, data.get(columnName));
        }
        if (!invalidColumns.isEmpty() && log.isInfoEnabled()) {
            log.info((Object)("Ignored data for non-existent or included columns: " + invalidColumns));
        }
        return validData;
    }

    public String getSQLStringForInsert() throws Exception {
        boolean omitValue;
        if (this.size() == 0) {
            log.debug((Object)"no data; returning empty string");
            return "";
        }
        StringBuffer columnList = new StringBuffer();
        StringBuffer valueList = new StringBuffer();
        Map sequences = this.dataSource.getSequences();
        SQLDriver driver = this.dataSource.getDriver();
        ArrayList<String> sequenceFieldNames = new ArrayList<String>();
        Iterator i = sequences.keySet().iterator();
        while (i.hasNext()) {
            sequenceFieldNames.add(this.dataSource.getFieldNameFromColumnName((String)i.next()));
        }
        List pks = this.dataSource.getPrimaryKeys();
        for (int i2 = 0; i2 < pks.size(); ++i2) {
            DSField field;
            if (this.values.containsKey(pks.get(i2)) || sequenceFieldNames.contains(pks.get(i2)) || (field = this.dataSource.getField((String)pks.get(i2))) != null && field.isAutoGenerated() && !field.containsKey((Object)"customInsertExpression")) continue;
            this.values.put(pks.get(i2), null);
        }
        this.values = DataTools.divideMap((Map)this.values, sequenceFieldNames);
        if (this.values == null) {
            this.values = new HashMap();
        }
        this.values = DataTools.getSortedMap((Map)this.values);
        for (String fieldName : this.values.keySet()) {
            String nativeFieldName;
            DSField field = this.dataSource.getField(fieldName);
            boolean skipCustomSQLCheck = false;
            if (this.customValueFields != null) {
                Iterator i3 = this.customValueFields.iterator();
                while (i3.hasNext()) {
                    if (!i3.next().equals(fieldName)) continue;
                    skipCustomSQLCheck = true;
                    break;
                }
            }
            if (field != null && (!skipCustomSQLCheck && field.getBoolean("customSQL") || field.get((Object)"tableName") != null || "relatedCount".equals(field.getType()) || (field.get((Object)"customSelectExpression") != null || field.get((Object)"customSQLExpression") != null) && field.get((Object)"customInsertExpression") == null && field.get((Object)"customUpdateExpression") == null) || (nativeFieldName = (String)this.field2ColumnMap.get(fieldName)) == null) continue;
            if (nativeFieldName.contains(".")) {
                nativeFieldName = nativeFieldName.substring(nativeFieldName.lastIndexOf(".") + 1);
            }
            if (columnList.length() != 0) {
                columnList.append(", ");
                valueList.append(", ");
            }
            columnList.append(this.dataSource.escapeColumnName(nativeFieldName));
            if (field.get((Object)"customInsertExpression") != null) {
                valueList.append(this.getCustomInsertExpression(field));
                continue;
            }
            if (field.get((Object)"customUpdateExpression") != null) {
                valueList.append(this.getCustomUpdateExpression(field));
                continue;
            }
            if (!driver.fieldAssignableInline(field)) {
                if (this.values.get(fieldName) == null) {
                    if (driver.shouldParameterizeNullValues()) {
                        valueList.append("?");
                        continue;
                    }
                    valueList.append("NULL");
                    continue;
                }
                valueList.append("?");
                continue;
            }
            valueList.append(this.dataSource.sqlValueForFieldValue(fieldName, this.values.get(fieldName)));
        }
        log.debug((Object)("Sequences: " + sequences));
        boolean bl = omitValue = driver instanceof DB2Driver || driver instanceof MysqlDriver || driver instanceof SQLServerDriver;
        if (!(driver instanceof SQLServerDriver) && !(driver instanceof CacheDriver)) {
            for (String columnName : sequences.keySet()) {
                String fieldName = this.dataSource.getFieldNameFromColumnName(columnName);
                if (this.values.containsKey(fieldName) && this.values.get(fieldName) != null) {
                    columnList.append(this.dataSource.escapeColumnName(columnName));
                    valueList.append(this.dataSource.sqlValueForFieldValue(fieldName, this.values.get(fieldName)));
                    continue;
                }
                DSField field = this.dataSource.getField(fieldName);
                if (field.getBoolean("implicitSequence", false)) continue;
                if (driver instanceof MysqlDriver) {
                    if (columnList.length() > 0) {
                        columnList.append(", ");
                    }
                    if (valueList.length() > 0) {
                        valueList.append(", ");
                    }
                    columnList.append(this.dataSource.escapeColumnName(columnName));
                    valueList.append("NULL");
                    continue;
                }
                if (omitValue) continue;
                if (columnList.length() > 0) {
                    columnList.append(", ");
                }
                if (valueList.length() > 0) {
                    valueList.append(", ");
                }
                columnList.append(this.dataSource.escapeColumnName(columnName));
                valueList.append(this.dataSource.getNextSequenceValue(columnName));
            }
        }
        if (columnList.toString() == null || "".equals(columnList.toString())) {
            return null;
        }
        return "(" + columnList.toString() + ") VALUES (" + valueList.toString() + ")";
    }

    public String getSQLStringForUpdate() throws Exception {
        Map newValues;
        List primaryKeys;
        if (this.size() == 0) {
            log.debug((Object)"no data; returning empty string");
            return "";
        }
        Map sequences = this.dataSource.getTable().getSequences();
        SQLDriver driver = this.dataSource.getDriver();
        if (driver instanceof SQLServerDriver) {
            this.values = DataTools.divideMap((Map)this.values, new ArrayList(sequences.keySet()));
        }
        if ((primaryKeys = this.dataSource.getPrimaryKeys()) != null && (newValues = DataTools.divideMap((Map)this.values, (List)primaryKeys)) != null) {
            this.values = newValues;
        }
        if (this.values == null) {
            return null;
        }
        this.values = DataTools.getSortedMap((Map)this.values);
        StringBuffer expr = new StringBuffer();
        for (String fieldName : this.values.keySet()) {
            String columnName;
            DSField field = this.dataSource.getField(fieldName);
            boolean skipCustomSQLCheck = false;
            if (this.customValueFields != null) {
                Iterator i = this.customValueFields.iterator();
                while (i.hasNext()) {
                    if (!i.next().equals(fieldName)) continue;
                    skipCustomSQLCheck = true;
                    break;
                }
            }
            if (field != null) {
                if (!skipCustomSQLCheck && field.getBoolean("customSQL") || field.get((Object)"tableName") != null || "relatedCount".equals(field.getType())) continue;
                if ((field.get((Object)"customSelectExpression") != null || field.get((Object)"customSQLExpression") != null) && field.get((Object)"customUpdateExpression") == null) {
                    log.info((Object)("Ignoring value for " + fieldName + " since it has a customSelectExpression or customSQLExpression but no customUpdateExpression"));
                    continue;
                }
            }
            if ((columnName = (String)this.field2ColumnMap.get(fieldName)) == null) continue;
            if (columnName != null && columnName.contains(".")) {
                columnName = columnName.substring(columnName.lastIndexOf(".") + 1);
            }
            if (expr.length() != 0) {
                expr.append(", ");
            }
            expr.append(this.dataSource.escapeColumnName(columnName) + "=");
            Object columnValue = this.values.get(fieldName);
            if (field.get((Object)"customUpdateExpression") != null) {
                expr.append(this.getCustomUpdateExpression(field));
                continue;
            }
            if (!driver.fieldAssignableInline(field)) {
                if (columnValue == null) {
                    if (driver.shouldParameterizeNullValues()) {
                        expr.append("?");
                        continue;
                    }
                    expr.append("NULL");
                    continue;
                }
                expr.append("?");
                continue;
            }
            expr.append(this.dataSource.sqlValueForFieldValue(fieldName, columnValue));
        }
        if (expr.toString() == null || "".equals(expr.toString())) {
            return null;
        }
        return expr.toString();
    }

    private String getCustomUpdateExpression(DSField field) throws Exception {
        String clause = (String)field.get((Object)"customUpdateExpression");
        Map context = Velocity.getStandardContextMap((DSRequest)this.dsRequest);
        return Velocity.evaluateWithSnippets((String)clause, (Map)context, (String)"customUpdateExpression", (DSRequest)this.dsRequest, (boolean)field.getBoolean("autoQuoteCustomExpressions", true), (boolean)false);
    }

    private String getCustomInsertExpression(DSField field) throws Exception {
        String clause = (String)field.get((Object)"customInsertExpression");
        Map context = Velocity.getStandardContextMap((DSRequest)this.dsRequest);
        return Velocity.evaluateWithSnippets((String)clause, (Map)context, (String)"customInsertExpression", (DSRequest)this.dsRequest, (boolean)field.getBoolean("autoQuoteCustomExpressions", true), (boolean)false);
    }
}

