/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.gss.ast;

import com.google.gwt.core.ext.Generator;
import com.google.gwt.thirdparty.common.css.SourceCodeLocation;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.guava.common.base.Strings;
import java.util.Arrays;
import java.util.List;

public class CssDotPathNode
extends CssValueNode {
    private String suffix;
    private String prefix;
    private String path;
    private String instance;

    public static String resolveExpression(String instance, String path, String prefix, String suffix) {
        String expression = path.replace(".", "().") + "()";
        if (!Strings.isNullOrEmpty(instance)) {
            expression = instance + "." + expression;
        }
        if (!Strings.isNullOrEmpty(prefix)) {
            expression = "\"" + Generator.escape((String)prefix) + "\" + " + expression;
        }
        if (!Strings.isNullOrEmpty(suffix)) {
            expression = expression + " + \"" + Generator.escape((String)suffix) + "\"";
        }
        return expression;
    }

    public CssDotPathNode(String dotPath, String prefix, String suffix, SourceCodeLocation sourceCodeLocation) {
        this(null, dotPath, prefix, suffix, sourceCodeLocation);
    }

    public CssDotPathNode(String instance, String dotPath, String prefix, String suffix, SourceCodeLocation sourceCodeLocation) {
        super(CssDotPathNode.resolveExpression(instance, dotPath, prefix, suffix), sourceCodeLocation);
        this.prefix = prefix;
        this.suffix = suffix;
        this.path = dotPath;
        this.instance = instance;
    }

    public CssValueNode deepCopy() {
        return new CssDotPathNode(this.instance, this.path, this.prefix, this.suffix, this.getSourceCodeLocation());
    }

    public String getPath() {
        return this.path;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getInstance() {
        return this.instance;
    }

    public List<String> getPathElements() {
        return Arrays.asList(this.path.split("\\."));
    }
}

