/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.apt;

import com.google.gwt.dev.util.Name;
import com.google.web.bindery.requestfactory.apt.State;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;

class DescriptorBuilder
extends SimpleTypeVisitor6<String, State> {
    DescriptorBuilder() {
    }

    @Override
    public String visitArray(ArrayType x, State state) {
        return "[" + x.getComponentType().accept(this, state);
    }

    @Override
    public String visitDeclared(DeclaredType x, State state) {
        return "L" + Name.BinaryName.toInternalName(state.elements.getBinaryName((TypeElement)x.asElement()).toString()) + ";";
    }

    @Override
    public String visitExecutable(ExecutableType x, State state) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (TypeMirror typeMirror : x.getParameterTypes()) {
            sb.append(typeMirror.accept(this, state));
        }
        sb.append(")");
        sb.append(x.getReturnType().accept(this, state));
        return sb.toString();
    }

    @Override
    public String visitNoType(NoType x, State state) {
        if (x.getKind().equals((Object)TypeKind.VOID)) {
            return "V";
        }
        return (String)super.visitNoType(x, state);
    }

    @Override
    public String visitPrimitive(PrimitiveType x, State state) {
        switch (x.getKind()) {
            case BOOLEAN: {
                return String.valueOf('Z');
            }
            case BYTE: {
                return String.valueOf('B');
            }
            case CHAR: {
                return String.valueOf('C');
            }
            case DOUBLE: {
                return String.valueOf('D');
            }
            case FLOAT: {
                return String.valueOf('F');
            }
            case INT: {
                return String.valueOf('I');
            }
            case LONG: {
                return String.valueOf('J');
            }
            case SHORT: {
                return String.valueOf('S');
            }
        }
        return (String)super.visitPrimitive(x, state);
    }

    @Override
    public String visitTypeVariable(TypeVariable x, State state) {
        return state.types.erasure(x).accept(this, state);
    }

    @Override
    public String visitWildcard(WildcardType x, State state) {
        return state.types.erasure(x).accept(this, state);
    }

    @Override
    protected String defaultAction(TypeMirror x, State state) {
        throw new RuntimeException("Unhandled type: " + ((Object)x).toString());
    }
}

