/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.SimplePropertyDescriptor;
import org.openqa.selenium.logging.LogLevelMapping;
import org.openqa.selenium.remote.SessionId;

public class JsonOutput
implements Closeable {
    private static final Logger LOG;
    private static final int MAX_DEPTH = 5;
    private static final Predicate<Class<?>> GSON_ELEMENT;
    private static final Map<Integer, String> ESCAPES;
    private final Map<Predicate<Class<?>>, SafeBiConsumer<Object, Integer>> converters;
    private final Appendable appendable;
    private final Consumer<String> appender;
    private Deque<Node> stack;
    private String indent = "";
    private String lineSeparator = "\n";
    private String indentBy = "  ";

    JsonOutput(Appendable appendable) {
        this.appendable = Objects.requireNonNull(appendable);
        this.appender = str -> {
            try {
                appendable.append((CharSequence)str);
            }
            catch (IOException e) {
                throw new JsonException("Unable to write to underlying appendable", e);
            }
        };
        this.stack = new ArrayDeque<Node>();
        this.stack.addFirst(new Empty());
        this.converters = ImmutableMap.builder().put(Objects::isNull, (obj, depth) -> this.append("null")).put(CharSequence.class::isAssignableFrom, (obj, depth) -> this.append(this.asString(obj))).put(Number.class::isAssignableFrom, (obj, depth) -> this.append(obj.toString())).put(Boolean.class::isAssignableFrom, (obj, depth) -> this.append((Boolean)obj != false ? "true" : "false")).put(Date.class::isAssignableFrom, (obj, depth) -> this.append(String.valueOf(TimeUnit.MILLISECONDS.toSeconds(((Date)obj).getTime())))).put(Enum.class::isAssignableFrom, (obj, depth) -> this.append(this.asString(obj))).put(File.class::isAssignableFrom, (obj, depth) -> this.append(((File)obj).getAbsolutePath())).put(URI.class::isAssignableFrom, (obj, depth) -> this.append(this.asString(obj.toString()))).put(URL.class::isAssignableFrom, (obj, depth) -> this.append(this.asString(((URL)obj).toExternalForm()))).put(UUID.class::isAssignableFrom, (obj, depth) -> this.append(this.asString(((UUID)obj).toString()))).put(Level.class::isAssignableFrom, (obj, depth) -> this.append(this.asString(LogLevelMapping.getName((Level)obj)))).put(SessionId.class::isAssignableFrom, (obj, depth) -> {
            this.beginObject();
            this.name("value");
            this.write(obj.toString());
            this.endObject();
        }).put(GSON_ELEMENT, (obj, depth) -> {
            LOG.log(Level.WARNING, "Attempt to convert JsonElement from GSON. This functionality is deprecated. Diagnostic stacktrace follows", new JsonException("Stack trace to determine cause of warning"));
            this.append(obj.toString());
        }).put(cls -> this.getMethod((Class<?>)cls, "toJson") != null, (obj, depth) -> this.convertUsingMethod("toJson", obj, (int)depth)).put(cls -> this.getMethod((Class<?>)cls, "asMap") != null, (obj, depth) -> this.convertUsingMethod("asMap", obj, (int)depth)).put(cls -> this.getMethod((Class<?>)cls, "toMap") != null, (obj, depth) -> this.convertUsingMethod("toMap", obj, (int)depth)).put(Collection.class::isAssignableFrom, (obj, depth) -> {
            this.beginArray();
            ((Collection)obj).forEach(o -> this.write(o, depth - 1));
            this.endArray();
        }).put(Map.class::isAssignableFrom, (obj, depth) -> {
            this.beginObject();
            ((Map)obj).forEach((key, value) -> this.name(String.valueOf(key)).write(value, depth - 1));
            this.endObject();
        }).put(Class::isArray, (obj, depth) -> {
            this.beginArray();
            Stream.of((Object[])obj).forEach(o -> this.write(o, depth - 1));
            this.endArray();
        }).put(cls -> true, (obj, depth) -> this.mapObject(obj, depth - 1)).build();
    }

    public JsonOutput setPrettyPrint(boolean enablePrettyPrinting) {
        this.lineSeparator = enablePrettyPrinting ? "\n" : "";
        this.indentBy = enablePrettyPrinting ? "  " : "";
        return this;
    }

    public JsonOutput beginObject() {
        this.stack.getFirst().write("{" + this.lineSeparator);
        this.indent = this.indent + this.indentBy;
        this.stack.addFirst(new JsonObject());
        return this;
    }

    public JsonOutput name(String name) {
        if (!(this.stack.getFirst() instanceof JsonObject)) {
            throw new JsonException("Attempt to write name, but not writing a json object: " + name);
        }
        ((JsonObject)this.stack.getFirst()).name(name);
        return this;
    }

    public JsonOutput endObject() {
        Node topOfStack = this.stack.getFirst();
        if (!(topOfStack instanceof JsonObject)) {
            throw new JsonException("Attempt to close a json object, but not writing a json object");
        }
        this.stack.removeFirst();
        this.indent = this.indent.substring(0, this.indent.length() - this.indentBy.length());
        if (topOfStack.isEmpty) {
            this.appender.accept(this.indent + "}");
        } else {
            this.appender.accept(this.lineSeparator + this.indent + "}");
        }
        return this;
    }

    public JsonOutput beginArray() {
        this.append("[" + this.lineSeparator);
        this.indent = this.indent + "  ";
        this.stack.addFirst(new JsonCollection());
        return this;
    }

    public JsonOutput endArray() {
        Node topOfStack = this.stack.getFirst();
        if (!(topOfStack instanceof JsonCollection)) {
            throw new JsonException("Attempt to close a json array, but not writing a json array");
        }
        this.stack.removeFirst();
        this.indent = this.indent.substring(0, this.indent.length() - this.indentBy.length());
        if (topOfStack.isEmpty) {
            this.appender.accept(this.indent + "]");
        } else {
            this.appender.accept(this.lineSeparator + this.indent + "]");
        }
        return this;
    }

    public JsonOutput write(Object value) {
        return this.write(value, 5);
    }

    public JsonOutput write(Object input, int depthRemaining) {
        this.converters.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(input == null ? null : input.getClass())).findFirst().map(Map.Entry::getValue).orElseThrow(() -> new JsonException("Unable to write " + input)).consume(input, depthRemaining);
        return this;
    }

    @Override
    public void close() {
        if (this.appendable instanceof Closeable) {
            try {
                ((Closeable)((Object)this.appendable)).close();
            }
            catch (IOException e) {
                throw new JsonException(e);
            }
        }
        if (!(this.stack.getFirst() instanceof Empty)) {
            throw new JsonException("Attempting to close incomplete json stream");
        }
    }

    private JsonOutput append(String text) {
        this.stack.getFirst().write(text);
        return this;
    }

    private String asString(Object obj) {
        StringBuilder toReturn = new StringBuilder("\"");
        String.valueOf(obj).chars().mapToObj(i -> ESCAPES.getOrDefault(i, "" + (char)i)).forEach(toReturn::append);
        toReturn.append('\"');
        return toReturn.toString();
    }

    private Method getMethod(Class<?> clazz, String methodName) {
        if (Object.class.equals(clazz)) {
            return null;
        }
        try {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            return this.getMethod(clazz.getSuperclass(), methodName);
        }
        catch (SecurityException e) {
            throw new JsonException("Unable to find the method because of a security constraint: " + methodName, e);
        }
    }

    private JsonOutput convertUsingMethod(String methodName, Object toConvert, int depth) {
        try {
            Method method = this.getMethod(toConvert.getClass(), methodName);
            if (method == null) {
                throw new JsonException(String.format("Unable to read object %s using method %s", toConvert, methodName));
            }
            Object value = method.invoke(toConvert, new Object[0]);
            return this.write(value, depth);
        }
        catch (ReflectiveOperationException e) {
            throw new JsonException(e);
        }
    }

    private void mapObject(Object toConvert, int maxDepth) {
        if (maxDepth < 1) {
            this.append("null");
            return;
        }
        if (toConvert instanceof Class) {
            this.write(((Class)toConvert).getName());
            return;
        }
        this.beginObject();
        for (SimplePropertyDescriptor pd : SimplePropertyDescriptor.getPropertyDescriptors(toConvert.getClass())) {
            Function<Object, Object> readMethod = pd.getReadMethod();
            if (readMethod == null) continue;
            this.name(pd.getName());
            this.write(pd.getReadMethod().apply(toConvert), maxDepth - 1);
        }
        this.endObject();
    }

    static {
        Predicate<Class> gsonElement;
        LOG = Logger.getLogger(JsonOutput.class.getName());
        try {
            Class<?> elementClass = Class.forName("com.google.gson.JsonElement");
            gsonElement = elementClass::isAssignableFrom;
        }
        catch (ReflectiveOperationException e) {
            gsonElement = clazz -> false;
        }
        GSON_ELEMENT = gsonElement;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i <= 31; ++i) {
            if (i == 8 || i == 12 || i == 10 || i == 13 || i == 9) continue;
            builder.put((Object)i, (Object)String.format("\\u%04x", i));
        }
        builder.put((Object)34, (Object)"\\\"");
        builder.put((Object)92, (Object)"\\\\");
        builder.put((Object)47, (Object)"\\u002f");
        builder.put((Object)8, (Object)"\\b");
        builder.put((Object)12, (Object)"\\f");
        builder.put((Object)10, (Object)"\\n");
        builder.put((Object)13, (Object)"\\r");
        builder.put((Object)9, (Object)"\\t");
        builder.put((Object)8232, (Object)"\\u2028");
        builder.put((Object)60, (Object)String.format("\\u%04x", 60));
        builder.put((Object)38, (Object)String.format("\\u%04x", 38));
        ESCAPES = builder.build();
    }

    @FunctionalInterface
    private static interface SafeBiConsumer<T, U> {
        public void consume(T var1, U var2);
    }

    private class JsonObject
    extends Node {
        private boolean isNameNext;

        private JsonObject() {
            this.isNameNext = true;
        }

        public void name(String name) {
            if (!this.isNameNext) {
                throw new JsonException("Unexpected attempt to set name of json object: " + name);
            }
            this.isNameNext = false;
            super.write(JsonOutput.this.asString(name));
            JsonOutput.this.appender.accept(": ");
        }

        @Override
        public void write(String text) {
            if (this.isNameNext) {
                throw new JsonException("Unexpected attempt to write value before name: " + text);
            }
            this.isNameNext = true;
            JsonOutput.this.appender.accept(text);
        }
    }

    private class JsonCollection
    extends Node {
        private JsonCollection() {
        }
    }

    private class Empty
    extends Node {
        private Empty() {
        }

        @Override
        public void write(String text) {
            if (!this.isEmpty) {
                throw new JsonException("Only allowed to write one value to a json stream");
            }
            super.write(text);
        }
    }

    private class Node {
        protected boolean isEmpty = true;

        private Node() {
        }

        public void write(String text) {
            if (this.isEmpty) {
                this.isEmpty = false;
            } else {
                JsonOutput.this.appender.accept("," + JsonOutput.this.lineSeparator);
            }
            JsonOutput.this.appender.accept(JsonOutput.this.indent);
            JsonOutput.this.appender.accept(text);
        }
    }
}

