
package com.smartgwt.client.docs;

/**
 * <h3>Server-side OData DataSource</h3>
 * <code>ODataDataSource</code> is a built-in server-side {@link
 * com.smartgwt.client.data.DataSource DataSource}  implementation that extends {@link
 * com.smartgwt.client.docs.ServerRestConnector RestConnector} to add  functionality for REST
 * webservices that follow the  <a href="https://www.odata.org/">OData protocol</a>.  Everything
 * that applies to  <code>RestConnector</code> also applies to <code>ODataDataSource</code> - it
 * is configured in the same way, provides the same support for pervasive Velocity templating,
 * etc. <p> In addition to the regular <code>RestConnector</code> facilities, 
 * <code>ODataDataSource</code> adds the following support, specifically for REST services  that
 * follow the OData protocol<ul> <li style="margin-bottom:1em">Generate an OData-compliant
 * "$filter" query from standard Smart GWT criteria.  Note, the generated filter query will
 * convert {@link com.smartgwt.client.data.DSRequest#getTextMatchStyle textMatchStyle} to the
 * corresponding OData function ("<code>substring</code>" becomes "<code>contains</code>" and
 * "<code>startsWith</code>" becomes "<code>startswith</code>"; other textMatchStyles just
 * generate straight equality checks), but there is no current support for true  {@link
 * com.smartgwt.client.data.AdvancedCriteria}</li> <li style="margin-bottom:1em">Generate an OData
 * "$orderby" parameter from the Smart GWT sortBy information</li> <li
 * style="margin-bottom:1em">Generate an OData "$select" parameter from the Smart GWT "outputs"
 * information</li> <li style="margin-bottom:1em">Derive "$skip" and "$top" attributes from the
 * Smart GWT startRow and endRow</li> <li style="margin-bottom:1em">Derive and apply the necessary
 * "maxpagesize" Prefer header to encourage the remote  server to allow the page size we would
 * like to use</li> <li style="margin-bottom:1em">Request the OData "$count" property and make use
 * of it to populate totalRows.   <li style="margin-bottom:1em">Modify certain things to match the
 * OData defaults, where that differs from the normal  <code>RestConnector</code> defaults</li>  
 * <li style="margin-bottom:1em">Apply all these generated and derived properties to the REST
 * call</li> </ul>
 */
public interface OdataDataSource {
}
