/*

  SmartClient Ajax RIA system
  Version v14.1p_2025-12-11/LGPL Deployment (2025-12-11)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//> @groupDef componentSchema
// A component schema is a special type of DataSource that describes a custom component.
// <P>
// Declaring a component schema for your custom component allows you to:
// <ul>
// <li> use simpler XML when creating your custom component: avoid having to specify the
// <code>constructor</code> and <code>xsi:type</code> attributes as described under
// +link{group:componentXML}
// <li> use your custom component within +link{group:reify,Reify}
// </ul>
// <P>
// <b>Example of a Component Schema</b>
// <P>
// In its most basic form, a component schema for a custom subclass of ListGrid called
// "<smartgwt>com.mycompany.</smartgwt>MyListGrid" looks like this:
// <pre>
// &lt;DataSource serverType="component" ID="MyListGrid"
//             inheritsFrom="ListGrid" instanceConstructor="<smartgwt>com.mycompany.</smartgwt>MyListGrid"/&gt;
// </pre>
// With this definition saved as "MyListGrid.ds.xml" in the project dataSources directory
// ([webroot]/shared/ds/ by default), you can now create an instance of
// <smartgwt>com.mycompany.</smartgwt>MyListGrid with just:
// <pre>
// &lt;MyListGrid width="500"/&gt;
// </pre>
// Note: you may need to restart your servlet engine/J2EE container before this example will
// work.
// <P>
// The attributes set directly on the DataSource tag have special meaning for a component
// schema definition:
// <ul>
// <li>+link{dataSource.serverType,serverType}="component" indicates this DataSource describes
// a component, as opposed to a SQL table or other data provider
// <li>+link{dataSource.ID,ID} means the tagName that will be used to create your custom
// component.  This must match the first component of the filename. (ID="MyListGrid" means the filename
// must be MyListGrid.ds.xml, and typically also matches the name of the class).
// <li>+link{dataSource.inheritsFrom}="ListGrid" inherits the ListGrid property definitions via
// +link{dataSource.inheritsFrom}.
// <li>instanceConstructor="<smartgwt>com.mycompany.</smartgwt>MyListGrid" indicates the
// <smartclient>SmartClient</smartclient><smartgwt>SmartGWT</smartgwt> class that
// <smartclient>+link{Class.create,create()}</smartclient> should be called on to construct
// an instance.
// <smartclient>
// <li>showLocalFieldsOnly is a boolean that, when set to true, tells the +link{group:reify,Reify}
// to show only the fields declared in this schema in the component editor.  Otherwise fields
// inherited via +link{dataSource.inheritsFrom} (all the way up the chain) are also included.
// <li>showSuperClassEvents is a boolean that, like showLocalFieldsOnly, optionally restricts
// the list of events shown in the Events tab of the +link{group:reify,Reify} to those defined in
// this schema only.
// <li>showSuperClassActions is a boolean that optionally restricts the list of actions shown
// in the menu when you map a component Event to a component Action within +link{group:reify,Reify}
// to those defined in this schema only.
// </smartclient>
// </ul>
// <P>
// <b>Declaring custom properties</b>
// <P>
// Custom properties are declared via +link{dataSource.fields,fields} as for an ordinary
// +link{DataSource}.  As with ordinary DataSources, it is legal to redeclare inherited fields
// in order to modify properties such as +link{dataSourceField.editorType,field.editorType}.
// <P>
// The following DataSourceField properties have special significance when a component schema
// is used to process +link{group:componentXML,component XML}:
// <ul>
// <li> +link{dataSourceField.type,field.type} declares the type of the field, and hence the
// type of the <smartclient>JavaScript</smartclient> value your custom class will be
// initialized with.  In order to declare subcomponents, can be set to the name of another component
// (built-in or custom).
// <li> +link{dataSourceField.multiple,field.multiple} declares that the field should always be
// array-valued even when only a single value is provided.  Also indicates that the field name
// should be used as a "wrapper tag" in the XML format for the component.
// <li> +link{dataSourceField.propertiesOnly,field.propertiesOnly}.  For fields that hold
// subcomponents, suppresses auto-construction to avoid +link{canvas.autoDraw,double drawing}
// and to allow subcomponents to be modified by their parent component before they are created
// and drawn
// </ul>
// When a component is edited within Reify, the DataSource properties that normally
// influence databound forms will influence the Component Editor (for example, field.title,
// field.editorType).  In addition, the following properties have special significance in
// component editing and component drag and drop:
// <ul>
// <li> +link{dataSourceField.inapplicable,field.inapplicable} indicates that an inherited
// field is inapplicable in this component.
// <li> +link{dataSourceField.group,field.group} indicates what group the property should be
// placed in when editing in Reify.
// <li> +link{dataSourceField.xmlAttribute,field.xmlAttribute}: indicates this field should
// serialize as an XML attribute.  Note that when constructing the component from XML, either
// an attribute or a subelement will continue to be accepted as means of specifying the field
// value, so this property is primarily set in order to make code generated by Reify
// maximally compact or to make it conform to externally set standards.
// </ul>
// <P>
//
// <smartclient>
// <b>Declaring Events and Actions</b>
// <P>
// Events and Actions are declared via a methods array.  In order for a method to be considered
// an event, it needs to have a method definition in the methods array (or be publicly
// documented in the SmartClient reference) and have been added to
// the class as a +link{group:stringMethods,StringMethod} via +link{Class.registerStringMethods}.
// <p>
// In order for a method to be considered an action, it needs to have a method definition in
// the methods array and have the <code>action</code> property set to <code>true</code>.  For
// example, the following is a definition of the 'hide' action available on any Canvas, as
// copied from Canvas.ds.xml:
// <pre>
//     &lt;methods&gt;
//         &lt;method name="hide" title="Hide" action="true"/&gt;
//     &lt;/methods&gt;
// </pre>
// For custom component actions, an array of expected parameters may be specified using the
// <code>params</code> attribute. Each entry in this array should have a specified type.
// By doing this, you allow the Reify to pass parameters through to actions when setting
// up events that call actions (possibly on another component).
// For example if you had a component with a custom action that expected to be passed a single
// parameter of type +link{class:ListGridRecord} you could define it as follows:
// <pre>
//     &lt;method name="showRecordDetails" title="Show Record Details" action="true"&gt;
//         &lt;params&gt;
//             &lt;param type="ListGridRecord"/&gt;
//         &lt;params&gt;
//     &lt;/method&gt;
// </pre>
// If a user working within the Reify then added ListGrid to the page and used the "+" icon
// to associate the +link{ListGrid.recordClick(),recordClick} event with this custom method, the
// Reify logic would automatically associate the parameters available in the fired event
// (in this case <code>recordClick</code>) with the expected parameters for the action to fire
// by type. So the <code>record</code> parameter of the event (known to be of type
// <code>ListGridRecord</code>) would be passed through to this custom <i>showRecordDetails</i>
// action as the first parameter.
// </smartclient>
//
// @treeLocation Concepts/Reify
// @title Component Schema
// @visibility external
//<


isc.DS.addProperties({
    _getSchemaFieldValidators : function (schemaFieldName) {
        var dataSource = this,
            validators,
            copiedValidators = false;

        do {
            var localSchemaField = dataSource.fields[schemaFieldName];
            if (localSchemaField) {
                if (localSchemaField.inapplicable == true) break;

                var localValidators = localSchemaField.validators;
                if (isc.isA.nonemptyArray(localValidators)) {
                    if (!validators) validators = localValidators;
                    else {
                        
                        for (var v = 0; v < localValidators.length; ++v) {
                            var validator = localValidators[v];
                            if (validator && !validators.contains(validator)) {
                                if (!copiedValidators) { // copy-on-write
                                    validators = validators.duplicate();
                                    copiedValidators = true;
                                }
                                validators.push(validator);
                            }
                        }
                    }
                }
            }

            var superDS = dataSource.superDS();
        } while (dataSource !== superDS && (dataSource = superDS));

        return validators;
    }
});


//> @object ComponentSchemaField
// A field in component schema.
// <p>
// This typically represents an attribute of an object or smartclass.
//
// @treeLocation Concepts/Reify/Component Schema
// @inheritsFrom DataSourceField
// @group componentSchema
// @visibility external
//<


//> @class ComponentSchema
// Specialized subclass of +link{DataSource}, used to represent +link{group:componentSchema, component schema}.
//
// @treeLocation Concepts/Reify/Component Schema
// @inheritsFrom DataSource
// @group componentSchema
// @visibility external
//<
isc.defineClass("ComponentSchema", "DataSource");

isc.ComponentSchema.addProperties({
    serverType: "component",
    componentSchema: true,

    //> @attr ComponentSchema.alwaysValidateSchemaFieldNames (Array of String : null : IR)
    // An array of field names that are always checked during validation of component +link{PaletteNode.defaults, defaults},
    // regardless of whether a value is supplied in the defaults.
    // <p>
    // This can be used to invoke validators for a particular schema field, so that the validators
    // can check the component defaults when using a default value for the field.
    //<
    alwaysValidateSchemaFieldNames: [],

    //> @attr ComponentSchema.fields (Array of ComponentSchemaField : null : IR)
    // The fields of the component schema.
    // @visibility external
    //<

    init : function () {
        this.addGlobalId = this.getInheritedProperty("addGlobalId");
        this.autoIdField = this.getInheritedProperty("autoIdField");

        var result = this.Super("init", arguments);

        var alwaysValidateSchemaFieldNames = this.alwaysValidateSchemaFieldNames;
        if (!isc.isAn.Array(alwaysValidateSchemaFieldNames)) {
            alwaysValidateSchemaFieldNames = this.alwaysValidateSchemaFieldNames = [alwaysValidateSchemaFieldNames];
        } else {
            alwaysValidateSchemaFieldNames = this.alwaysValidateSchemaFieldNames = alwaysValidateSchemaFieldNames.duplicate();
        }

        if (this.hasSuperDS()) {
            var superAlwaysValidateSchemaFieldNames = this.superDS().alwaysValidateSchemaFieldNames;
            if (isc.isAn.Array(superAlwaysValidateSchemaFieldNames)) {
                for (var n = 0; n < superAlwaysValidateSchemaFieldNames.length; ++n) {
                    var superAlwaysValidateSchemaFieldName = superAlwaysValidateSchemaFieldNames[n];
                    if (!alwaysValidateSchemaFieldNames.contains(superAlwaysValidateSchemaFieldName)) {
                        alwaysValidateSchemaFieldNames.push(superAlwaysValidateSchemaFieldName);
                    }
                }
            }
        }

        return result;
    }
});
