/*

  SmartClient Ajax RIA system
  Version v14.1p_2025-12-11/LGPL Deployment (2025-12-11)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
// SelectionOrRollOverCanvas: Canvas subclass with special undocumented 
// cssPointerEvents setting to allow events to be natively routed through to the 
// target canvas underneath (the body)
isc.defineClass("SelectionOrRollOverCanvas", "Canvas").addProperties({
    cssPointerEvents: "none"
});

//> @class  ListGrid
// A ListGrid is a +link{DataBoundComponent} that displays a list of objects in a grid, where
// each row represents one object and each cell in the row represents one property.
//
//  @inheritsFrom VLayout
//  @implements DataBoundComponent
//  @treeLocation Client Reference/Grids
//  @visibility external
//<
// Make ListGrid a subclass of VLayout. This allows us to change the order of the sub-components
// - show summary row between header and body, etc.

isc.ClassFactory.defineClass("ListGrid", "VLayout", "DataBoundComponent");

isc.defer("isc.ListGrid.addProperties({ showRollOver: !isc.Browser.isTouch });" +
"if (isc.Browser.hasDualInput) isc.ListGrid.addProperties({ handleMouseMove : " + 
"function (event, eventInfo) {return this._handleDualInputMouseMove(event, eventInfo);}});");

// Synonym for backCompat.  NOTE: define an alias rather than make a subclass, otherwise, attempts
// to skin the class using the old name would only affect the subclass!
isc.addGlobal("ListViewer", isc.ListGrid);
// define groups for documentation purposes

    //> @groupDef data
    //<

    //> @groupDef databinding
    // DataBinding means the automatic, highly customizable process of 'binding' a UI component
    // to a DataSource, so that a UI component displays, edits and saves DataSource records
    // using appropriate formatters, editors, validation rules, and persistence logic.
    //
    // @see interface:DataBoundComponent
    // @title DataBinding
    //<

    //> @groupDef sorting
    //<

    //> @groupDef editing
    // Data being displayed by a grid may be edited within the grid, by showing editing
    // interfaces embedded inside the cells of the grid.
    // <P>
    // <b>Enabling editing</b>
    // <P>
    // Editing is enabled when +link{listGrid.canEdit,canEdit} is <code>true</code>.  When enabled,
    // the user can begin editing via the
    // +link{listGrid.editEvent,editEvent}, typically click or double-click.  Editing can also be triggered
    // programmatically by a call to +link{listGrid.startEditing,startEditing()} or
    // +link{listGrid.startEditingNew,startEditingNew()}.
    // <P>
    // <b>New record creation</b>
    // <P>
    // By default, editing is restricted to existing records.  Setting +link{listGrid.listEndEditAction} to
    // "next" allows the user to create new records by simply navigating off the end of the dataset
    // with the keyboard.  Editing of new records can also be initiated with
    // +link{listGrid.startEditingNew()}, for example, from a button outside the grid.  See the
    // +link{group:unsavedRecords,Unsaved Records Overview} for special concerns when dealing
    // with unsaved records.
    // <P>
    // <b>Saving changes</b>
    // <P>
    // Saving of changes is triggered automatically when the user navigates out of the row or cell
    // being edited (based on +link{listGrid.saveByCell}) or when the user ends editing.   For
    // a "mass update" interface, automatic saving of changes can be disabled entirely via
    // +link{listGrid.autoSaveEdits,autoSaveEdits:false}, in which case a manual call to
    // +link{listGrid.saveEdits,saveEdits()} or +link{listGrid.saveAllEdits,saveAllEdits()} is required
    // to trigger saving.
    // <P>
    // If a grid has no DataSource, saving means that the properties of the +link{ListGridRecord}s
    // in +link{listGrid.data,grid.data} are directly changed.
    // <P>
    // For a grid with a DataSource, saving will be accomplished by using DataSource "update"
    // operations for existing records, and DataSource "add" operations for new records.  If multiple
    // records have been edited and +link{listGrid.saveAllEdits,saveAllEdits()} is called,
    // +link{rpcManager.startQueue,request queuing} will be automatically used to enable all
    // edits to be saved in one HTTP turnaround (if using the SmartClient Server).
    // <P>
    // By default, a grid will send only updated fields and primaryKey fields as part of
    // +link{dsRequest.data} so that the server can discern which fields the user actually changed.
    // However, the grid always includes the original field values in the
    // dsRequest as +link{dsRequest.oldValues}.
    // <P>
    // Note that although it is possible to load DataSource data without actually declaring a
    // +link{dataSourceField.primaryKey,primaryKey field}, a primaryKey must be declared for
    // editing and saving.  The values of primaryKey fields is how SmartClient identifies the
    // changed record to the server.
    // <P>
    // <b>Saving edits in a sorted data set:</b> When a user updates or adds a record in a sorted 
    // listGrid, the data set may be automatically +link{listGrid.unsort(),unsorted}.
    // When this happens, the sort indicator will be removed from sort
    // field headers, and all rows will stay in their current positions, including edited records
    // where the sort field value has been changed.<br>
    // Note that for a databound grid with a partial data set, a "true unsort" isn't possible 
    // without droppping the cache, as both client and server need to agree on the positions
    // of rows. In this case the grid is marked as unsorted, and all visible rows stay in place
    // until the next fetch occurs, at which point the cache is dropped and a truly unsorted
    // data set retrieved from the server. Typically the next fetch would be caused by the
    // user scrolling to a new position in the grid. Once that fetch occurs the positions
    // of rows within the grid will be updated to match the positions of rows in the unsorted
    // server-side data set, meaning if the user scrolled back to their previous position
    // they may see a different set of records. (See also +link{ResultSet.updatePartialCache}).
    // <P>
    // <b>Validation</b>
    // <P>
    // Any time saving is attempted, validation is automatically triggered.  Values entered by the
    // user will be checked against the +link{listGridField.validators} and the
    // +link{dataSourceField.validators}. Any invalid values abort an attempted save.
    // <P>
    // Similar to editing and saving, validation can be done on row transitions or on cell
    // transitions by setting +link{listGrid.validateByCell,validateByCell}, or can be disabled entirely
    // via +link{listGrid.neverValidate,neverValidate:true}.
    // <P>
    // <b>Editability of cells</b>
    // <P>
    // Editors will either be shown for the complete row or for a single cell based on
    // +link{listGrid,editByCell,editByCell}.  Whether a cell can be edited can be controlled on a
    // per field basis by setting +link{listGridField.canEdit,field.canEdit}, or on a per-record basis
    // by setting +link{listGrid.recordEditProperty,recordEditProperty} on a
    // +link{ListGridRecord,record}, or can be controlled on an arbitrary, programmatic basis via
    // an override of +link{listGrid.canEditCell()}.
    // <P>
    // Cells which are not editable just display the cell's current value.
    // <P>
    // <b>Keyboard Navigation</b>
    // <P>
    // Full keyboard navigation is supported by default, including Tab and Shift-Tab to navigate
    // between cells in a row, and Up Arrow and Down Arrow to traverse rows.  Several properties
    // on both grids and fields, all named *EditAction, control navigation behavior of certain keys
    // (eg Enter).
    // <P>
    // You can use +link{listGrid.startEditing,startEditing(<i>rowNum</i>, <i>colNum</i>)} to
    // programmatically move editing to a particular cell, for example, during a
    // +link{listGridField.changed,field.changed()} event.
    // <P>
    // <b>editValues (unsaved changes)</b>
    // <P>
    // The term "editValues" means changes that the user has made to the dataset which have not
    // been saved.  The grid manages and stores editValues separately from the data itself in order
    // to allow the user to revert to original values, and in order to enable to grid to send only
    // updated fields to the server.
    // <P>
    // Because editValues are stored separately, if you directly access the dataset (eg via
    // <code>grid.getData().get()</code>) you will see the records without the user's unsaved changes.
    // Many APIs exist for retrieving and managing editValues (search for editValue).
    // For the common case of needing to access the record-as-edited, you can call
    // +link{listGrid.getEditedRecord,grid.getEditedRecord(rowNum)}.
    // <P>
    // When accessing and manipulating edited data, you should think carefully about whether
    // you want to be working with the original data or with the edited version.  Values entered
    // by the user may not have been validated yet, or may have failed validation, hence you may
    // find a String value in a field of type "date" or "int", which could cause naive formatters or
    // totaling functions to crash.
    // <P>
    // Setting editValues via APIs such as +link{listGrid.setEditValue()} is fully equivalent
    // to the user making changes to data via the editing UI.  If you <i>also</i> allow editing
    // external to the grid, setting editValues is one way to combine changes from external
    // editors into the grid's edits, so that you can do a single save.
    // <P>
    // <b>Customizing Cell Editors</b>
    // <P>
    // When a cell is being edited, the editor displayed in the cell will be a +link{class:FormItem}.
    // The editor type for the cell will be determined by +link{listGrid.getEditorType()} based on the
    // specified +link{ListGridField.editorType} or +link{ListGridField.type, data type} for the field in
    // question.
    // <P>
    // You can customize the editor by setting +link{listGridField.editorProperties} to a set of
    // properties that is valid for that FormItem type.  Custom FormItem classes are also allowed,
    // for example, you may use +link{formItem.icons} to create an icon that launches a separate
    // +link{Dialog} in order to provide an arbitrary interface that allows the user to select the
    // value for a field.
    // <P>
    // <b>Events</b>
    // <P>
    // Editing triggers several events which you can provide handlers for in order to customize
    // editing behavior.  Some of the most popular are +link{listGridField.change,field.change()},
    // +link{listGridField.changed,field.changed()} for detecting changes made by the user,
    // +link{listGrid.cellChanged()} for detecting changes that have been successfully saved,
    // and +link{listGrid.editorEnter,editorEnter} and +link{listGrid.editorExit,editorExit()}
    // for detecting user navigation during editing.
    // <P>
    // <smartclient>
    // You can also install event handlers directly on the FormItem-based editors used in the grid
    // via +link{listGridField.editorProperties,editorProperties} as mentioned above.  When handling
    // events on items, or which involve items, be aware that in addition to standard
    // +link{FormItem} APIs, editors have the following properties:
    // <P>
    // - <code>rowNum</code>: The rowNum of the record being edited.<br>
    // - <code>colNum</code>: The colNum of the cell being edited.<br>
    // - <code>grid</code>: A pointer back to the listGrid containing the record.
    // </smartclient>
    // <smartgwt>
    // <code>ListGridField.setEditorType()</code> can be used to customize the editors shown
    // for each field, including providing FormItem-specific event handlers.  However,
    // ListGrid-provided event APIs should be used wherever possible (for example, use
    // <code>EditorEnterEvent</code> rather than <code>FocusEvent</code>).  If, in a FormItem
    // event handler, you need access to the ListGrid, you can either declare the event handler
    // as a Java "inner class" in a scope where the ListGrid is available as a final variable,
    // or you can use <code>event.getItem().getContainerWidget()</code>.  Note the ListGrid APIs
    // +link{listGrid.getEditRow,getEditRow()} and +link{listGrid.getEditCol,getEditCol()}
    // indicate what cell is being edited.
    // <P>
    // For more dynamic editor customization, include changing the type of editor used on a
    // per-row basis, use +sgwtLink{listGrid.setEditorCustomizer()}.
    // <P>
    // <b>NOTE:</b> with both APIs, in effect several FormItems are generated from the
    // customized FormItem you provide - see the docs for
    // +link{DataSourceField.editorType()} for special coding patterns that apply in this
    // case.
    // </smartgwt>
    // <P>
    // <b>Binary Fields</b>
    // <P>
    // The ListGrid will automatically show "view" and "download" icon buttons for binary field
    // types (see +link{type:ListGridFieldType}).  However, you cannot use an upload control
    // embedded within a ListGrid row to upload files (regardless of whether you use FileItem or
    // UploadItem).  This is because, in the browser's security model, native HTML upload
    // controls cannot be re-created and populated with a chosen file, and the ListGrid needs
    // to be able to re-create editors at any time in order to handle loading data on scroll,
    // scrolling editors in and out of view, adding new rows, changing sort direction, and
    // other use cases.
    // <P>
    // However you <i>can</i> create an editor with a +link{formItem.icons,FormItem icon} that
    // pops up a separate Window containing a FileItem in a DynamicForm, so long as the form in
    // the Window saves the uploaded file immediately rather than trying to have the grid
    // perform the save.
    //
    // @title Grid Editing
    // @treeLocation Client Reference/Grids/ListGrid
    // @visibility external
    //<
    


    //> @groupDef unsavedRecords
    // APIs such as +link{listGrid.startEditingNew(),startEditingNew()} or
    // +link{listGrid.listEndEditAction,listEndEditAction:"next"} allow editing records that have not
    // been saved to the server.  These unsaved records are special in several ways:
    // <ul>
    // <li> there is no actual Record object in the dataset for them: <code>getRecord(rowNum)</code>
    // will return null, instead, <code>getEditValues(rowNum)</code> allows access to field values for
    // the unsaved record
    // <li> rows for editing these records always appear at the end of the grid and do not sort with
    // other rows
    // <li> because unsaved records lack an actual Record object and lack a
    // +link{dataSourceField.primaryKey} value, they have limited functionality: they cannot be
    // selected, and do not support +link{listGrid.showRecordComponents} and certain other features.
    // </ul>
    // <P>
    // If you need to work with unsaved records and have all ListGrid features apply to them, this is
    // usually a sign that you should re-think your UI for adding new records.  Consider the following
    // approaches - which works best will depend on the application:
    // <ul>
    // <li> actually save a new record to persistent storage, then start editing it.  This has the
    // advantage that the user will never lose data by exiting the application with unsaved
    // records, which can be important if there is a lot of data entry before the record is ready to
    // save (for example, a new issue report in an issue-tracking applications, or a new blog entry).
    // This is also a good approach if the user may want to get a unique ID for the new record
    // right away (again useful for a new issue report or blog entry).
    // <P>
    // If values for several fields are required before the record should be visible on other screens
    // or to other users, you can add a field to the record to flag it as incomplete so that it is not
    // shown on other screens.  Alternatively, require certain fields to be entered via an external
    // form or dialog before the record is added to the grid.
    // <P>
    // Saving a new record and editing it can be done via +link{DataSource.addData()} followed by a call to
    // +link{listGrid.startEditing()} once the record has been saved.
    // <li> edit new records via a separate +link{DynamicForm,form} instead, possibly in a modal
    // +link{Window} - then unsaved records never need to be shown in the grid.  Similar to the
    // approach above, this modal form might have only certain minimum fields to make a valid
    // new record, then further editing could continue in the grid.
    // <li> use a +link{dataSource.clientOnly,clientOnly DataSource} so that records can be saved
    // immediately without contacting the server.  This is a good approach if several unsaved records
    // need to be manipulated by multiple components before they are finally saved.
    // <li> use +link{DataSource.updateCaches()} with an "add" DSResponse to cause a new record to be
    // added to the grid due to +link{ResultSet,automatic cache synchronization}.  At this point the
    // grid will believe the record exists on the server and it will be treated like any other saved
    // record.  This means your server code will need to handle the fact that the ListGrid will submit
    // "update" DSRequests for any subsequent edits.
    // </ul>
    // <b>NOTE about validation:</b> by design, SmartClient assumes that any record that has been
    // saved is valid and does not validate field values that appear in records loaded from the
    // server.  This includes records added to a clientOnly DataSource via
    // +link{DataSource.setCacheData()} as well as records added due to a call to
    // +link{DataSource.updateCaches()}.
    // <P>
    // Usually the best approach is to avoid this situation by editing such records in a form or other
    // control until they are valid rather than showing invalid records in a grid.  However, if such
    // records need to be considered invalid, one approach is to take field values and add them as
    // editValues via +link{listGrid.setEditValues()}.  At this point the ListGrid will consider the
    // values as user edits and will validate them.
    //
    // @title Handling Unsaved Records
    // @visibility external
    //<

    //> @groupDef imageColumns
    // Columns that show images either as their only appearance or in addition to text.
    //<

    //> @groupDef formulaFields
    // Fields with values calculated from other fields in the grid.
    //<

isc.defineClass("GridBody", isc.GridRenderer).addProperties({
    // suppress adjustOverflow while pending a redraw so we can resize smaller without seeing
    // a scrollbar flash in and out of existence
    adjustOverflowWhileDirty:false,

    
    _redrawToFixIEFocusScrollArtifacts:isc.Browser.isIE && isc.Browser.version > 9,

    initWidget : function () {
        this.Super("initWidget", arguments);

        
        if (isc.screenReader) this._redrawToFixIEFocusScrollArtifacts = false;

        this._cacheVariableHeightFieldNums();
    },

    fireSelectionUpdated : function () {
        this.grid.fireSelectionUpdated();
    },

    canSelectRecord : function(record) {
        return this.grid.canSelectRecord(record);
    },    


    // Override showSelectedStyle() to avoid showing inappropriate selected styling on group header nodes
    
    _showSelectedStyle : function (record, rowNum, colNum) {
        var lg= this.grid;        
        if (record && lg.isGrouped && !(lg.canSelectGroups && lg.selectionAppearance == "checkbox") 
            && record._isGroup) 
        {
            return false;
        }
        return this.Super("_showSelectedStyle", arguments);
    },

    redrawForSelectionChanged : function () {
        this.grid._markBodyForRedraw("selection changed");
    },

    // adjustOverflow() - overridden to support 'autoFitData' behavior
    adjustOverflow : function (reason, a,b,c,d) {
        // If we get naively called while undrawn just call Super which will bail.
        // Ditto if we're hidden using display:none - in that case we can't reliably get
        // sizing information from the DOM
        
        var isVisibleInDom = this.isDrawn() && !this._handleDisplayIsNone();
        if (!isVisibleInDom) return this.Super("adjustOverflow", arguments);
   
        // we call 'getDelta' from this method which can fall back through to 'adjustOverflow'
        // Avoid infinite looping if we hit this case.
        if (this._calculatingDelta) return;
        
        if (this.grid._updatingRecordComponents) {
            return this.Super("adjustOverflow", arguments);
        }

        
        var grid = this.grid;

        
        if (grid == null) return this.Super("adjustOverflow", arguments);

        // Invalidate cached scrollHeight / scrollWidth so any calls to getScrollWidth/Height will
        // pick up values reflecting the current rendered HTML
        if (this._scrollWidth != null) delete this._scrollWidth;
        if (this._scrollHeight != null) delete this._scrollHeight;

        
        var data = grid.data, isLoading = false;;

        if (isc.isA.ResultSet(data) && !data.lengthIsKnown()) {
            if (grid.emptyMessageHeight == null) {
                return this.invokeSuper(isc.GridBody, "adjustOverflow", reason,a,b,c,d);
            }
            isLoading = true;
        }

        var initialWidth = this.getWidth(), initialHeight = this.getHeight();
        var fitVertical = (this.autoFitData == "both"),
            fitHorizontal = fitVertical,
            frozen = grid && grid.frozenFields != null,
            isFrozenBody = frozen && grid && (grid.frozenBody == this);

        if (!fitVertical) fitVertical = (this.autoFitData == "vertical");
        if (!fitHorizontal) fitHorizontal = (this.autoFitData == "horizontal");
        // If we have frozen fields, the frozen body never shows scrollbars and always
        // gets sized to match the widths of the fields it contains (done as part of
        // setBodyFieldWidths). Don't worry about trying to run special auto-fit logic
        // on the frozen body.
        // - We do run auto-fit logic on the unfrozen body and take the size of the frozen
        //   body into account when doing so.
        // - We do still need to ensure the header layout is sized correctly when the frozen
        //   body is resized
        
        if (fitHorizontal || fitVertical) {
            var height, width, rowHeights, hscrollOn, vscrollOn, dX, dY;

            if (fitVertical) {
                var minHeight = this.grid.getAutoFitMinBodyHeight();
                height = minHeight;
                var totalRows = isLoading ? 0 : this.getTotalRows(),
                    rows = totalRows;

                rowHeights = 0;
                // ignore autoFitMaxRecords if set to zero - this means fit to all records!
                if (this.autoFitMaxRecords) {
                    rows = Math.min(rows, this.autoFitMaxRecords);
                }
                if (rows > 0) {
                    // We need to handle variable rowHeights so we're going to have to look at
                    // the table element to determine the heights - we already have a method to
                    // do that
                    var drawnRowHeights = this._getDrawnRowHeights();
                    // If we have any undrawn rows assume calculated sizes
                    
                    var firstDrawnRow = this._firstDrawnRow,
                        lastDrawnRow = this._lastDrawnRow;

                    

                    // fdr / ldr unset implies no drawn rows - set such that we calculate
                    // theoretical heights only
                    if (this._firstDrawnRow == null) {
                        firstDrawnRow = rows;
                        lastDrawnRow = rows;
                    }
                    // _isFrozenBody defined in GridRenderer
                    var isFrozenBody = this._isFrozenBody();
                    if (firstDrawnRow > 0) {
                        firstDrawnRow = Math.min(firstDrawnRow, rows);
                        for (var i = 0; i < firstDrawnRow; i++) {
                            var undrawnRowHeight = this.getRowHeight ?
                                                    this.getRowHeight(this.grid.getRecord(i), i, isFrozenBody)
                                                    : this.cellHeight;
                            rowHeights += undrawnRowHeight;
                        }
                    }
                    var lastLogicalRow = rows-1;
                    if (lastDrawnRow < lastLogicalRow) {
                        for (var i = lastDrawnRow+1; i < lastLogicalRow+1; i++) {
                            rowHeights += this.getRowHeight ?
                                            this.getRowHeight(this.grid.getRecord(i), i, isFrozenBody)
                                            : this.cellHeight;
                        }
                    }
                    // Measure the rendered rows and add up the heights.
                    // Note that getDrawnRowHeights() just returns an array of the heights of
                    // rendered rows so the first drawn row is the first entry in the array, not
                    // the _firstDrawnRow'th entry
                    lastDrawnRow = Math.min(lastDrawnRow, lastLogicalRow);
                    for (var i = 0; i <= lastDrawnRow-firstDrawnRow; i++) {
                        rowHeights += drawnRowHeights[i];
                    }
                    // If we are clipping off any rows we know we have a v-scrollbar
                    vscrollOn = totalRows > rows;

                    // Treat autoFitMaxHeight:0 as unspecified - resize as large as necessary
                    var autoFitMaxHeight = this.getAutoFitMaxHeight();
                    if (autoFitMaxHeight && rowHeights > autoFitMaxHeight) {
                        rowHeights = autoFitMaxHeight;
                        vscrollOn = true;
                    }
                    // this.logWarn("total rows to show:"+ rows +
                    //  ", rendered:" + [this._firstDrawnRow,this._lastDrawnRow] +
                    //  ", rowHeights total up to:"+ rowHeights +
                    //  ", current height:" + this.getHeight() +
                    //  ", body height based on ListGrid specified height:" + height);

                } else {
                    // The emptyMessage renders in the available space. If emptyMessageHeight
                    // is explicitly set, leave that much space for it.
                    
                    if (this.grid.emptyMessageHeight != null) {
                        rowHeights = this.grid.emptyMessageHeight;
                    }
                }
                

                // add some extra height if autoFitExtraRecords is set
                
                if (this.autoFitExtraRecords && this.autoFitExtraRecords > 0) {
                    var extraHeight = Math.round(this.autoFitExtraRecords * this.cellHeight);
                    rowHeights += extraHeight;
                }

            } else {
                vscrollOn = this.getScrollHeight() > this.getHeight();
            }

            if (fitHorizontal && !isFrozenBody) {
                var width = this.grid.getInnerWidth(),
                    frozenBodyWidth;
                if (frozen) {
                    var frozenWidths = this.grid.getFrozenSlots(this.grid._fieldWidths);
                    frozenBodyWidth = frozenWidths.sum();
                    width -= frozenBodyWidth;

                    // if the frozenWidths exceed the specified width for the grid as a whole,
                    // apply an arbitrary small positive min width for the unfrozen body
                }


                // Note that we're calling getColumnSizes on the GridRenderer
                // So if we the LG is frozen body this gives us the cols within the
                // appropriate body, not the total set of cols in the grid.
                var colSizes = this.getColumnSizes(),
                    contentWidth = colSizes.sum();
                if (this.autoFitMaxColumns) {
                    var maxCols = this.autoFitMaxColumns;
                    // bit of a hack - how to deal with maxCols specified as a number <= the
                    // number of frozen fields.
                    // For now we just enforce at least one unfrozen field
                    if (frozen) {
                        maxCols = Math.max(1, maxCols-this.grid.frozenFields.length);
                    }

                    if (maxCols < colSizes.length) {
                        colSizes = colSizes.slice(0, maxCols);
                    }
                }

                var colWidths = colSizes.sum();
                if (this.autoFitMaxWidth) {
                    var maxWidth = this.grid.getAutoFitMaxWidth();
                    if (frozen) maxWidth = Math.max(20, maxWidth - frozenBodyWidth);
                    colWidths = Math.min(maxWidth, colWidths);
                }
                hscrollOn = (this.overflow == isc.Canvas.SCROLL) ? true :
                            (this.overflow == isc.Canvas.AUTO) ? (contentWidth > Math.max(width, colWidths)) :
                            false;

            } else {
                hscrollOn = this.overflow == isc.Canvas.SCROLL ? true :
                            this.overflow == isc.Canvas.AUTO  ? this.getScrollWidth() > this.getWidth() :
                            false;
            }

            

            // Now we know if we have an h-scrollbar, adjust height and width for scrollbars /
            // borders / margin if appropriate
            if (fitVertical && rowHeights != null) {
                rowHeights += this.getVBorderPad() + this.getVMarginSize();
                if (hscrollOn) {
                    rowHeights += this.getScrollbarSize();
                    var autoFitMaxHeight = this.getAutoFitMaxHeight()
                    if (autoFitMaxHeight && rowHeights > autoFitMaxHeight) {
                        rowHeights = autoFitMaxHeight;
                    }
                }
                // Resize vertically if rowHeights (+ border etc) > the auto fit min height
                // (which is derived from the ListGrid's specified height)
                if (rowHeights > height) {
                    height = rowHeights;
                    this._vAutoFit = true;
                } else {
                    if (this._vAutoFit) delete this._vAutoFit;
                }
            }
            if (fitHorizontal && !isFrozenBody && colWidths != null) {

                colWidths += this.getHBorderPad() + this.getHMarginSize();
                // If we're showing a vertical scrollbar
                // or we're leaving a scrollbar gap, ensure we autoFit wide enough to
                // accommodate that scrollbar/gap
                if (vscrollOn || this.alwaysShowVScrollbar || this.grid._shouldLeaveScrollbarGap(!!vscrollOn)) {
                    colWidths += this.getScrollbarSize();
                    if (this.autoFitMaxWidth) {
                        var maxWidth = this.grid.getAutoFitMaxWidth();
                        if (frozen) maxWidth = Math.max(20, maxWidth - frozenBodyWidth);
                        colWidths = Math.min(maxWidth, colWidths);
                    }
                }
                // Resize horizontally if colWidths > width
                if (colWidths > width) {
                    width = colWidths;
                    this._hAutoFit = true;
                } else {
                    if (this._hAutoFit) delete this._hAutoFit;
                }
            }

            // Calculate the delta with our current size.
            this._calculatingDelta = true;            
            dY = this.getDelta(this._$height, height, this.getHeight());

            dX = this.getDelta(this._$width, width, this.getWidth());
            delete this._calculatingDelta;
            // If necessary resize to accommodate content!
            if (dY != null || dX != null) {
                this.resizeBy(dX, dY, null, null, this._$autoFitSize);
            } 

            // if width change != null, resize header to match body
            // Note that if isFrozenBody is true we skipped the dX calculation so
            // always resize the headerLayout to match
            
            if (dX != null || (isFrozenBody && fitHorizontal)) {
                var lg = this.grid,
                    scrollbarSize = lg._shouldLeaveScrollbarGap() ? lg.body.getScrollbarSize() : 0,
                    headerWidth = width - scrollbarSize,
                    totalHeaderWidth = headerWidth;
                if (frozen && lg.headerLayout) {

                    if (isFrozenBody) {
                        totalHeaderWidth = this.getWidth() + lg.body.getWidth();
                        // If we go past the autoFitMaxWidth limit, run adjustOverflow on the body
                        // to force it to shrink/start scrolling
                        if (lg.autoFitMaxWidth != null &&
                            (totalHeaderWidth + lg.getHBorderPad() +
                                lg.getHMarginSize() > lg.getAutoFitMaxWidth()))
                        {
                            // don't bother to go on and resize the header - we'll do that
                            // when the body adjust overflow method runs
                            return lg.body.adjustOverflow();
                        }
                        totalHeaderWidth -= scrollbarSize;

                    } else {
                        totalHeaderWidth = headerWidth + lg.frozenBody.getWidth();
                    }
                    lg.headerLayout.setWidth(totalHeaderWidth);
                }

                // We can skip resizing the frozen header - this is handled in setBodyFieldWidths
                if (!isFrozenBody) {
                    var header = lg.header;

                    if (header && header.isDrawn()) {
                        header.setWidth(headerWidth);
                    }
                }
            }

        // if autoFitData is null but we don't match our 'specified size', assume the property
        // has been modified and reset to specified size
        }
        if (isFrozenBody) {
            var frozenWidths = this.grid.getFrozenSlots(this.grid._fieldWidths),
                frozenContentWidth = frozenWidths.sum();
            var mustHScroll = this.getViewportWidth() < frozenContentWidth;
            if (this.grid.bodyOverflow == isc.Canvas.AUTO) {
                this.setCustomHScrollbar(mustHScroll);
            }
        }
        

        // catch the case where autoFitData has been cleared in either direction and
        // reset to specified size.
        var verticalChanged = (!fitVertical && this._vAutoFit),
            horizontalChanged = (!fitHorizontal && this._hAutoFit);
        if (verticalChanged || horizontalChanged) {
            delete this._vAutoFit;
            delete this._hAutoFit;

            var standardHeight = verticalChanged ? this.grid.getAutoFitMinBodyHeight() : null,
                standardWidth = horizontalChanged ?
                                (!frozen ? this.grid.getInnerWidth() :
                                    (this.grid.getInnerWidth() - this.grid.frozenBody.getWidth()) )
                                                  : null;
            this.resizeTo(standardWidth,standardHeight);
            // reset userHeight / userWidth to 100%, so future resizes to the LG cause the
            // body to also resize.
            if (!fitHorizontal) this.updateUserSize("100%", this._$width);
            if (!fitVertical)   this.updateUserSize("100%", this._$height);
            // reset field widths on the grid to resize the header to match the body
            this.grid._updateFieldWidths("autoFitData mode changed");
        }
        var returnVal = this.invokeSuper(isc.GridBody, "adjustOverflow", reason, a,b,c,d);
        // if size changed, refresh recordComponents to account for new draw area
        if ((fitVertical || fitHorizontal) &&
            (this.getWidth() != initialWidth || this.getHeight() != initialHeight))
        {
            this.grid.updateRecordComponents(true);
        }

        // Fire the "bodyOverflowed" observation. This updates frozen body end space and
        // summary row body right space to so these can keep in sync with body scrolling
        // even though the viewport sizes are different.
        if (!isFrozenBody) this.grid.bodyOverflowed();
        return returnVal;
    },
    
    // When determining auto-fit-field-widths, avoid adding a pixel to account for
    // rounding errors due to sub-pixel sized rendering coupled with pixel-resolution
    // reported sizes for cells whose content is actually sized to fill the available
    // space
    
    adjustForSubPixelSizing : function (colNum) {
        var grid = this.grid;
        if (grid._editorShowing || grid.alwaysShowEditors) {
            var fieldNum = grid.getFieldNumFromLocal(colNum, this),
                field = grid.getField(fieldNum),
                nonEditableField = !this.fieldIsEditable(field);
            if (!nonEditableField && (!grid.editByCell || grid.getEditCol() == fieldNum)) {
                return false;
            }
        }
        return true;
    },
    
    setCustomHScrollbar : function (show) {
        var scrollbar = this.customHscrollbar;
        
        if (!scrollbar) {
            if (!show) return;
        
            scrollbar = this.customHscrollbar = isc.ClassFactory.newInstance(
                this.scrollbarConstructor,
            {
                ID:this.getID()+"_custom_hscroll",
                autoDraw:false,
                _generated:true,
                zIndex:this.getZIndex() +1,
                showThumbTriggerArea: isc.Browser.isTouch || isc.Browser.supportsDualInput,
                vertical:false,
                scrollTarget:this,
                visibility:this.visibility,
                _redrawWithMaster:false,
                _resizeWithMaster:false,
                _redrawWithParent:false,

                // rely on snapTo for auto-positioning!                
                snapTo:"B",
                width:"100%",
                btnSize:this.getCustomScrollbarSize()
            });
            
            this.addPeer(scrollbar);
        }
        
        scrollbar.setVisibility(show);
        
    },
    

    // Override 'getSizeMayChangeOnRedraw' to return true when autoFitData is set.
    getSizeMayChangeOnRedraw : function () {
		var fitVertical = (this.autoFitData == "both"),
        	fitHorizontal = fitVertical;
		
	    if (!fitVertical) fitVertical = (this.autoFitData == "vertical");
	    if (!fitHorizontal) fitHorizontal = (this.autoFitData == "horizontal");
	    if (fitHorizontal || fitVertical) return true;
	    return this.Super("getSizeMayChangeOnRedraw", arguments);	    
    },

    getAutoFitMaxHeight : function () {
        return this.grid ? this.grid.getAutoFitMaxBodyHeight() : null;
    },
    
    // When determining auto-fit-field-widths (drawn size of columns) we render out an
    // offscreen tester containing tableHTML and look at the various cells' widths in a row.
    // If the grid is grouped, we need to choose a row which isn't the group header
    // since that contains col-spanning cells
    _getValidAutoFitRowNum : function () {
        var grid = this.grid;
        if (this.grid && this.grid.isGrouped) {
            var rowNum = 0;
            while (rowNum < this.grid.getTotalRows()) {
                var record = this.grid.getRecord(rowNum);
                if (record == null || !this.grid.isGroupNode(record)) {
                    return rowNum;
                }
                rowNum++;
            }
        }
        return 0;
    },

    _$autoFitSize: "autoFitSize",

    resizeBy : function (deltaX, deltaY, animating, suppressHandleUpdate, reason) {
        var autoFitSize = reason == this._$autoFitSize;

        // autoFitSize parameter: When autoFitData is true for this grid, we resize the
        // body to fit the data, and pass in the autoFitSize parameter to this method.
        // In the case of an explicit resize outside the autoFitData system, hang onto the
        // specified size so we can reset to it if the data shrinks, etc
        if (!autoFitSize) {
            this._specifiedWidth = this.getWidth() + (deltaX != null ? deltaX : 0);
        }

        // Note that return value of resizeBy indicates whether the size actually changed
        var returnVal = this.invokeSuper(isc.GridBody, "resizeBy", deltaX, deltaY, animating,
                                         suppressHandleUpdate, reason);
        // we usually update _userWidth/_userHeight as part of layout.childResized to
        // store the explicit width, which then stops the member reacting to the layout's
        // subsequent resizes.
        // However, if we're autoFitting the (unfrozen) body to content, we want a
        // subsequent resize of the grid as a whole to still cause the body to expand
        // further.
        // Therefore yank out this _userSize flag in this case.
        if (autoFitSize && deltaX != null && !this.frozen) {
            delete this._userWidth;
        }
        return returnVal;
    },

    // context menus (NOTE: ListGrid-level handling is identical for cell vs row context click)
    cellContextClick : function (record, rowNum, colNum) {
        var gridColNum = this.grid.getFieldNumFromLocal(colNum, this);
        return this.grid._cellContextClick(record, rowNum, gridColNum);
    },

    // Override _rowClick: If a record is marked as disabled this suppresses all events, but
    // if the user clicks in the "remove" field of an already removed record we actually want
    // to react to this and unmarkAsRemoved()
    _rowClick : function (rowNum, colNum) {
        if (!this.grid) return;
        var returnVal;
        var gridColNum = this.grid.getFieldNumFromLocal(colNum, this);
        
        var rec = rowNum >= 0 ? this.grid.getRecord(rowNum) : null,
            field = gridColNum >= 0 ? this.grid.getField(gridColNum) : null,
            isRemoveClick = false
        ;
        
        if (!isc.isA.RecordEditor(this.grid) && field && field.isRemoveField) {
            // If the user clicks inside the remove field on a group or summary row, don't fire
            // the remove-click!
            isRemoveClick = !rec || !(rec._isGroup || rec[this.grid.groupSummaryRecordProperty] || rec[this.grid.gridSummaryRecordProperty]);
        }
        
        if (isRemoveClick) {
            if (rowNum >= 0) {
                this.grid.removeRecordClick(rowNum,colNum);
                returnVal = false;
            }
        } else {
            returnVal = this.Super("_rowClick", arguments);
        }
        
        // if selectCellTextOnClick is true, select the cell text now
        if (returnVal != false && this.grid.shouldSelectCellTextOnClick(rowNum, gridColNum)) {
            this.grid.selectCellText(rowNum, gridColNum);
        }
        
        return returnVal;
    },

    
    _fixRowClickRow : function (record, rowNum, colNum) {
        var grid = this.grid
        if (grid && grid.data && grid.isGrouped && grid.isGroupNode(record) && 
            record != this.getCellRecord(rowNum, colNum))
        {
            // return the current rowNum of the groupNode
            
            var groupNodeIndex = grid.data.indexOf(record);
            if (groupNodeIndex >= 0) return groupNodeIndex;
        }
        return rowNum;
    },

    getCellHoverDelay : function (rowNum, colNum) {
        if (!this.grid) return;
        var gridColNum = this.grid.getFieldNumFromLocal(colNum, this);
        return this.grid.getCellHoverDelay(this.grid.getCellRecord(rowNum, gridColNum), rowNum,
                                           gridColNum);
    },


    _getCellHoverComponent : function (record, rowNum, colNum) {
        if (this.grid && isc.isA.ListGrid(this.grid)) {
            var gridColNum = this.grid.getFieldNumFromLocal(colNum, this);
            return this.grid._getCellHoverComponent(record, rowNum, gridColNum);
        }
    },

    
    _cacheVariableHeightFieldNums : function (skipOtherBody) {
        this._variableRecordHeightFieldNums = null;
        
        var grid = this.grid;

        if (grid && grid.variableRecordHeightFields != null) {
            var fieldNums = []
            ;
            for (var i = 0; i < grid.variableRecordHeightFields.length; i++) {
                var fieldName = grid.variableRecordHeightFields[i],
                    colNum = this.getFieldNum(fieldName)
                ;
                if (colNum >= 0) {
                    fieldNums.push(colNum);
                }
            }
            if (fieldNums.length > 0) {
                this._variableRecordHeightFieldNums = fieldNums;
            }

            
            if (!skipOtherBody) {
                var otherBody = this.frozen ? grid.body : grid.frozenBody;
                if (otherBody != null) {
                    otherBody._cacheVariableHeightFieldNums(true);
                }
            }
        }
    },

    // this ensures that if we're not showing any records we can still scroll the header fields
    // into view.
    expandEmptyMessageToMatchFields:true,
    applyHSpaceToEmptyMessage:true,

    // add/clear passback required to observe/ignore a ListGrid passthrough method
    _addPassbackForObservation : function (methodName) {
        var metadataProp = "_observation_" + methodName + "_metadata";
        if (this[metadataProp]) return;

        var observerMethod, saveMethodName = isc._obsPrefix + methodName;
        if (this[saveMethodName]) {
            observerMethod = this[methodName], this[methodName] = this[saveMethodName];
        }

        try {
            var originalMethod = this[methodName],
                passthroughs = this.grid._getBodyPassthroughMethods(this, [methodName]);
        } finally {
            if (observerMethod) this[methodName] = observerMethod;
        }
        this.addMethods(passthroughs);

        if (!isc.isAn.emptyObject(passthroughs)) this[metadataProp] = {
            originalMethod: originalMethod, passbackMethod: passthroughs[methodName]
        };

        if (this.logIsDebugEnabled() && this[metadataProp]) {
            this.logDebug("Added passback method on " + methodName +
                          " to support observation of the grid");
        }
    },

    _clearPassbackFromObservation : function (methodName) {
        var metadataProp = "_observation_" + methodName + "_metadata";

        var metadata = this[metadataProp];
        if (!metadata) return;

        var saveMethodName = isc._obsPrefix + methodName,
            expectedMethod = this[saveMethodName] ? this[saveMethodName] : this[methodName];
        if (expectedMethod != metadata.passbackMethod) return;

        var originalMethods = {};
        originalMethods[methodName] = metadata.originalMethod;
        if (this[saveMethodName]) {
            isc.Func.replaceWithMethod(originalMethods, methodName);
        }
        this.addMethods(originalMethods);
        delete this[metadataProp];        

        if (this.logIsDebugEnabled()) {
            this.logDebug("Cleared passback method on " + methodName +
                          " as the grid method will now be ignored");
        }
    },

    getInnerHTML : function () {
        // call bodyDrawing on the LG if we are the primary body
        this.grid.bodyDrawing(this);
        return this.Super("getInnerHTML", arguments);
    },
    
    // Override _canFocus to check for whether we have any data.
    _canFocus : function () {
        var canFocus = this.Super("_canFocus", arguments);
        if (canFocus && this.grid && !this.grid.canFocusInEmptyGrid && this.isEmpty()) {
            return false;
        }
        return canFocus;
    },

    // alwaysManageFocusNavigation is true for ListGrids - this means any tab-navigation within
    // the grid will ultimately rely on 'syntheticShiftFocus' rather than native tab-index
    // handling
    
    syntheticShiftFocus : function () {
        var grid = this.grid;
        if (grid && grid.frozenFields != null) {
            var focusCol = grid._getKeyboardClickNum(),
                fcBody = focusCol == -1 ? grid.body : grid.getFieldBody(focusCol);
            if (fcBody != this) return false;
        }
        return this.Super("syntheticShiftFocus", arguments);
    },

    // ------------------------------------------------------
    //
    // PrintHTML
    // This needs some tweaking to handle the following:
    // - printHTML can be generated asynchronously in 2 ways:
    //  - if number of rows exceeds printMaxRows we use timers to break up the HTML generation
    //  - if we have embeddedComponents fetching their printHTML may also be asynchronous
    //
    // In either case, 'getTableHTML()' will be fired more than once, asynchronously.
    // In the case of async embedded component printHTML generation, this is the standard
    // mechanism - see 'gotComponentPrintHTML' in GridRenderer.
    // In the case of splitting the printing into chunks, the _printingChunk
    // flag will be set and startRow/endRow will be shifted, then getTableHTML will be called
    // on a timer, repeatedly until all the rows' HTML is generated.
    //
    // We need to fire the 'prepareBodyForPrinting' and 'bodyDonePrinting' methods on the ListGrid
    // around each of these blocks - this is required as the ListGrid relies on the body to
    // handle generating header HTML and if there are frozen fields, HTML from the frozen
    // body, and does so by setting various flags on the GR body which'll be read by
    // getTableHTML()
    //
    
    
    getTablePrintHTML : function (context) {
        // context contains startRow, endRow, callback, printProperties, printWidths
        var startRow = context.startRow,
            endRow = context.endRow,
            totalRows = endRow != null ? (endRow - startRow) : this.getTotalRows(),
            maxRows = this.printMaxRows,
            printWidths = context.printWidths,
            printProps = context.printProps;

        var asyncPrintCallback = {
            target:this,
            methodName:"gotTablePrintHTML",
            printContext:context,
            printCallback:context.callback
        };

        context.callback = asyncPrintCallback;

        if (maxRows < totalRows) {
            this.logDebug("get table print html - breaking HTML into chunks", "printing");
            if (startRow == null) startRow = context.startRow = 0;
            if (endRow == null) endRow = context.endRow = this.getTotalRows();
            this.getPrintHTMLChunk(context);

            return null;
        }

        // No chunks - can only be asynchronous due to getTableHTML directly going async
        // to get embeddedComponentHTML
        var suspendPrintingContext = this.grid._prepareBodyForPrinting(printWidths, printProps);
        var printHTML = this.getTableHTML(null, startRow, endRow, null, asyncPrintCallback);

        // restore settings
        this.grid._bodyDonePrinting(suspendPrintingContext);
        return printHTML;
    },

    gotTablePrintHTML : function (HTML, asyncCallback) {
        var callback = asyncCallback.printCallback;
        if (callback) {
            this.fireCallback(callback, "HTML,callback", [HTML,callback]);
        }
    },

    // This is called repeatedly, asynchronously for each "chunk"
    // The first chunk may include fetches for component tableHTML so can also be asynchronous
    // itself.
    
    getPrintHTMLChunk : function (context, returnSynchronous) {

        var suspendPrintingContext = this.grid._prepareBodyForPrinting(context.printWidths);
        // printing chunk flag - used by the GR to avoid writing out the outer table tags for each
        // chunk.
        this._printingChunk = true;
        // Flag to indicate whether this is the first chunk being printed - used
        // to ensure we write necessary outer tableHTML content
        this._printingStartChunk = !context.isSubsequentChunk;


        // Second flag to indicate we are printing chunks. This is used only by
        // gotComponentPrintHTML() to reset the _printingChunk flag before calling
        // getTableHTML
        this._gettingPrintChunkHTML = true;

        var startRow = context.startRow,
            endRow = context.endRow,
            maxRows = this.printMaxRows,
            callback = context.callback;

        this.currentPrintProperties = context.printProps;
        

        if (!context.html) context.html = [];

        var chunkEndRow = context.chunkEndRow = Math.min(endRow, (startRow + maxRows)),
            chunkHTML = this.getTableHTML(null, startRow, chunkEndRow, null,
                {target:this, methodName:"gotPrintChunkHTML",
                    printContext:context, printCallback:context.callback
                });

        // restore settings
        this.grid._bodyDonePrinting(suspendPrintingContext);
        this._printingChunk = false;

        // chunkHTML will only be null if getTableHTML went asynchronous - can happen on the
        // first chunk while retrieving embedded componentHTML
        if (chunkHTML != null) {
            delete this._gettingPrintChunkHTML;
            this.gotPrintChunkHTML(chunkHTML, {printContext:context});
            if (returnSynchronous) {
                return chunkHTML;
            }
        }
    },
    gotPrintChunkHTML : function (HTML, callback) {
        var context = callback.printContext,
            startRow = context.startRow,
            endRow = context.endRow,
            chunkEndRow = context.chunkEndRow,
            maxRows = this.printMaxRows,
            gotHTMLCallback = context.callback;

        context.html.add(HTML);
        context.isSubsequentChunk = true;

        if (chunkEndRow < endRow) {
            context.startRow = chunkEndRow;
            return this.delayCall("getPrintHTMLChunk", [context], 0);
        }

        if (gotHTMLCallback != null) {
            var html = context.html.join(isc.emptyString);
            this.fireCallback(gotHTMLCallback, "HTML,callback", [html,gotHTMLCallback]);
        }
    },

    // In GridRenderer.getTableHTML(), when printing, we generate all embedded components'
    // print HTML up front, then slot it into the actual HTML for the table.
    // component printHTML may be asynchronously generated in which case this callback is
    // fired when we have the component HTML - default implementation re-runs getTableHTML
    // which now recognizes it's got component HTML and continues to get the actual table
    // HTML then fire the async callback.
    // Overridden to call 'prepareBodyForPrinting()' on the grid and reset the '_printingChunk'
    // flag if necessary
    gotComponentPrintHTML : function (HTML, callback) {

        var asyncCallback = callback.context.asyncCallback,
            context = asyncCallback.printContext;

        var printWidths = context.printWidths;

        var suspendPrintingContext = this.grid._prepareBodyForPrinting(printWidths);
        if (this._gettingPrintChunkHTML) {
            this._printingChunk = true;
        }

        var HTML = this.Super("gotComponentPrintHTML", arguments);
        if (this._printingChunk) delete this._printingChunk;

        if (HTML != null) {
            delete this._gettingPrintChunkHTML;
        } else {
            this.grid._bodyDonePrinting(suspendPrintingContext);
        }

    },

    // override getPrintHeaders / getPrintFooters to return the
    // already calculated HTML set up by the calling grid.
    
    getPrintHeaders : function (startCol, endCol) {
        var HTML = this._printHeadersHTML;
        // Lazily clean up this attribute.
        
        delete this._printHeadersHTML;
        return HTML == null ? "" : HTML;
    },

    getPrintFooters : function (startCol, endCol) {
        var HTML = this._printFootersHTML;
        delete this._printFootersHTML;
        return HTML == null ? "" : HTML;
    },

    // Row Spanning Cells
    // ----------------------------

    


    
    refreshCellValue : function (rowNum, colNum, refreshingRow, allowEditCellRefresh, skipRefreshCellHover) {
        var lg = this.grid;
        // Sanity check only - we shouldn't see a drawn, orphaned body
        if (lg == null) {
            return this.Super("refreshCellValue", arguments);
        }
 
        // If we need to delay the refresh, fire again after a delay
        if (!this._readyToRefreshCell(rowNum, colNum)) {
            this.delayCall("refreshCellValue", [rowNum, colNum, refreshingRow, allowEditCellRefresh, skipRefreshCellHover]);
            return;
        }

        var lgColNum = lg.getFieldNumFromLocal(colNum, this);

        // Handle the case of showing an edit form field for this cell.
        
        var editFieldName = lg.getEditorName(rowNum, lgColNum),
            fieldName = lg.getFieldName(lgColNum),
            form = lg._editRowForm,
            editItem, cellHasFocus = false,
            cellShowingEditor, cellWillShowEditor;
        
        if (form) {
                var editItem = form.getItem(editFieldName),
                    rowHasEditor = (lg._editorShowing && rowNum == lg.getEditRow());
                // sanity check if the colNum on the edit item doesn't match the colNum of the
                // cell we're refreshing, it doesn't relate to this cell.
                // This occurs in CubeGrids where we have one record per cell
                if (editItem && editItem.colNum != lgColNum) editItem = null;

            if (rowHasEditor) {
                // whether there is currently an editor in the cell
                cellShowingEditor = (editItem && editItem.isDrawn());
                // whether there will be an editor in the cell after refresh
                cellWillShowEditor = lg._shouldShowEditCell(rowNum,lgColNum);

                if (editItem != null && form.hasFocus) {
                    var formFocusItem = form.getFocusSubItem();
                    cellHasFocus = (formFocusItem == editItem ||
                                (editItem.items && editItem.items.contains(formFocusItem)));
                }
            // catch the case where we're clearing out a drawn item
            
            } else if (editItem && editItem.rowNum == rowNum) {
                cellWillShowEditor = false;
                cellShowingEditor = editItem.isDrawn();
            }
        }

        
        if (!allowEditCellRefresh && (cellHasFocus && cellShowingEditor && cellWillShowEditor))
        {
            return false;
        }

        // In some cases redraw can write out innerHTML, and then refresh a row
        // immediately from within that same redraw flow [from modifyContent], before
        // the editItemsDrawingNotification has fired.
        // In this case, rather than firing the drawing notification here, simply 
        // remove the item from the _drawnEditItems array. getEditCellValue() will re-add it 
        // if appropriate (called when we get the cell content), and we can wait for upstream 
        // code in redraw to complete and actually fire the drawn() notification
        
        var suppressItemNotifications = this._innerHTMLUpdatedForRedraw;
        if (suppressItemNotifications && this._drawnEditItems != null && 
            editItem != null && editItem.rowNum == rowNum) 
        {
            this._drawnEditItems.remove(editItem);
        }

        // If there is a visible editor in this cell, update it's value and blur before redrawing
        if (cellShowingEditor) {
            
            lg.getUpdatedEditorValue();

            if (editItem != null) {
                if (cellHasFocus) {
                    // Note - if the item will be visible after this method, silently blur and
                    // refocus. Otherwise allow the blur handler to fire, since we won't be
                    // restoring focus.
                    if (cellWillShowEditor) {
                        // Explicitly store focus for redraw, so we can refocus after
                        // redraw using the standard DF redraw mechanism
                        
                        editItem._storeFocusForRedraw();
                        form._blurFocusItemWithoutHandler();
                        
                        editItem._skipStoreFocusForRedraw = true;
                    }
                    else editItem.blurItem();
                }
                // If this method will clear a form item, notify it now
                // (drawing() / redrawing() notifications are handled separately when we
                // generate the item HTML)
                if (!cellWillShowEditor) editItem.clearing(true);
            }
        }
        
        if (this._drawnEditItems && this._drawnEditItems.length == 0) {
            delete this._drawnEditItems;
        }
    
        // Remember the native text selection for resetting if appropriate
        if (!cellShowingEditor && !cellWillShowEditor && lg.selectCellTextOnClick) {
            lg._selectedCellTextConfig = lg._getSelectedCellTextConfig(rowNum, lgColNum);
        }

        var correctedRowNum = rowNum
        if (rowNum >= 0 && colNum >= 0 && lg && lg.allowRowSpanning && lg.useRowSpanStyling)
        {
            // If we're asked to refresh a logical cell that's not rendered
            // (actually spanned by another cell) we could either refuse or refresh the
            // spanning cell. Refresh the spanning cell in case its value is calculated
            // from the cell in question.
            var startRow = this.getCellStartRow(rowNum, colNum);
            if (startRow != rowNum) {
                correctedRowNum = startRow;
            }
        }

        // Refresh the actual cell HTML
        isc.GridRenderer._instancePrototype.refreshCellValue.call(this, correctedRowNum, colNum, null, null, skipRefreshCellHover);

        if (editItem && editItem._skipStoreFocusForRedraw) delete editItem._skipStoreFocusForRedraw;
        if (editItem && (cellShowingEditor || cellWillShowEditor)) {
            // Call our method to fire the appropriate 'drawn()' / 'redrawn()' / 'cleared()'
            // notification on the edit item.

            
            if (cellWillShowEditor) lg._drawingItem = editItem;

            if (!suppressItemNotifications) lg._editItemsDrawingNotification(editItem, null, this);
            if (cellWillShowEditor) {
                delete lg._drawingItem;
                // restore focus if it had focus
                
                if (cellHasFocus) {
                    editItem._suppressGridTextSelection = true;
                    editItem._refocusAfterRedraw();
                    editItem._suppressGridTextSelection = false;
                }
            }
        } else {
            // If we had native text selection of cellContent and selectCellTextOnClick is
            // true, reset selection.
            if (lg.selectCellTextOnClick && lg._selectedCellTextConfig) {
        
                var config = lg._selectedCellTextConfig;
                delete lg._selectedCellTextConfig;
                
                var cell = this.getTableElement(config.rowNum, colNum);
                
                if (cell != null && window.getSelection != null) {
                    var range = window.document.createRange();
                    range.selectNodeContents(cell);
                
                    if (range.toString() == config.text) {
                        var sel = window.getSelection();
                        sel.removeAllRanges();
                        sel.addRange(range);    
                    }
                }
            }
            
            // If we have variable row heights and frozen fields, also refresh the
            // special "rowHeightSpacer" cells
            if (!refreshingRow && lg.frozenFields &&
                !lg.fixedRecordHeights &&
                lg.matchFrozenRowHeightsApproach == "rowHeightSpacerHTML" &&
                (lg.variableRecordHeightFields == null || lg.variableRecordHeightFields.contains(fieldName))) 
            {
                var frozenRow = lg.frozenBody.getTableElement(rowNum),
                    frozenSpacerCell = frozenRow 
                        ? frozenRow.cells[lg.frozenFields.length] : null,
                    unfrozenRow = lg.body.getTableElement(rowNum),
                    unfrozenSpacerCell = unfrozenRow 
                        ? unfrozenRow.cells[lg.fields.length - lg.frozenFields.length]
                        : null,
                    record = this.getCellRecord(rowNum, lgColNum);
                
                if (frozenSpacerCell) frozenSpacerCell.innerHTML = 
                    lg.frozenBody._getRowHeightSpacerCellValue(record, rowNum);
                if (unfrozenSpacerCell) unfrozenSpacerCell.innerHTML = 
                    lg.body._getRowHeightSpacerCellValue(record, rowNum);
            }
        }

    },


    // Cell Alignment
    // ---------------------------------------------------------------------------------------

    // cellAlignment - override to account for the fact that with frozen fields, body
    // colNum may be offset from ListGrid colNum
    getCellVAlign : function (record, field, rowNum, colNum) {
        if (this.grid && this.grid.getCellVAlign) {
            var gridColNum = this.grid.getFieldNumFromLocal(colNum, this);
            return this.grid.getCellVAlign(record, rowNum, gridColNum);
        }
    },
    getCellAlign : function (record, field, rowNum, colNum) {

        if (this.grid && this.grid.getCellAlign != null) {
            var gridColNum = this.grid.getFieldNumFromLocal(colNum, this);
            return this.grid.getCellAlign(record, rowNum, gridColNum);

        } else return field.cellAlign || field.align;
    },

    // Single Cell rows
    // ---------------------------------------------------------------------------------------

    // if this is removed, DONTCOMBINE directive no longer needed in GridRenderer.js
    _drawRecordAsSingleCell : function (rowNum, record,c) {
        var lg = this.grid;
        if (lg._isNewRecordRow(rowNum)) return true;
        
        return isc.GridRenderer._instancePrototype.
            _drawRecordAsSingleCell.call(this, rowNum,record,c);
        //return this.Super("_drawRecordAsSingleCell", arguments);
    },

    // showSingleCellCheckboxField()
    // If this record is showing a single cell value, should a checkbox field also show up next
    // to the record?
    showSingleCellCheckboxField : function (record) {
        var lg = this.grid;
        return lg && lg.showSingleCellCheckboxField(record);
    },

    // This method is called on records where _drawRecordAsSingleCell is true
    // returns the start/end col the single cell value should span.
    // Typically just spans all the cells we render out but if we're showing the
    // checkbox field we may want to NOT span over that field
    _getSingleCellSpan : function (record, rowNum, startCol, endCol) {
        // Span all columns if we're not showing a checkbox field
        
        if (rowNum == this._animatedShowStartRow ||
            !this.showSingleCellCheckboxField(record) ||
            (this.grid && this.grid.frozenBody != null && this.grid.frozenBody != this))
        {
            return [startCol,endCol];
        }

        
        var checkboxFieldPos = this.grid.getCheckboxFieldPosition()+1;
        return [Math.max(startCol, checkboxFieldPos), endCol];
    },

    // Cell ClipDiv overflow
    // ----------------------
    // Should we write "text-overflow:ellipsis" into our clip-div? Return false
    // for boolean fields / fields which show valueIconOnly
    _clipDiv_writeTextOverflowEllipsis:function (field) {
        if (this.grid.showEllipsisWhenClipped == false) return false;
        if (field != null && field.showEllipsisWhenClipped != null) return field.showEllipsisWhenClipped;
        if (field != null && this.grid.showValueIconOnly(field)) return false;
        return true;
    },    
    
    // If we have frozen fields and variable row heights, we can use the row-height-spacer
    // feature to synchronize row-heights across frozen and unfrozen bodies
    _writeRowHeightSpacerHTML : function (drawRect) {
        var grid = this.grid;
        
        if (!grid || grid.matchFrozenRowHeightsApproach != "rowHeightSpacerHTML") {
            return false;
        }
        
        // If we have variable row heights we may need to force a min-height for rows
        // (in either frozen or unfrozen body)
        if (!this.fixedRowHeights && grid) {
            // If we're incremental rendering overflowing columns, we do
            // need the row-height spacer unless we're rendering the specific col
            if (this._variableRecordHeightFieldNums) {
                var startCol = drawRect[2], endCol = drawRect[3];
                for (var i = 0; i < this._variableRecordHeightFieldNums; i++) {
                    var varHeightFieldNum = this._variableRecordHeightFieldNums[i]
                    if (varHeightFieldNum < startCol || varHeightFieldNum > endCol) {
                        return true;
                    }
                }
            }
            // If we have frozen fields which can overflow, we also need the row-height spacer
            if (grid.frozenFields && grid.frozenFields.length > 0) {
        
                var otherBody = this.frozen ? grid.body : grid.frozenBody;
                if (otherBody != null && 
                    // No explicit variable fields - any field can overflow so we need
                    // the spacer
                    (!grid.variableRecordHeightFields  ||
                    // Explicit variable fields are in the other body - again we need
                    // the spacer
                     otherBody._variableRecordHeightFieldNums) )
                {
                    return true;
                }
            }
        }
        // By default we don't want to write out the spacer!
        return false;
    },

    
    _getRowHeightSpacerCellValue : function (record, rowNum, drawRect) {
        var grid = this.grid;
        if (grid) {
            var rowHTML;
            var otherBody = this.frozen ? grid.body : grid.frozenBody;
            if (otherBody != null) {
                otherBody._suppressRowVPaddingBorder = true;
                otherBody._suppressMinHeightCSSText = true;
                
                // We want to pick up inactive cell values
                // for edit fields or any field with custom 'inactive' formatters
                otherBody._gettingRowHeightSpacerHTML = true;
                rowHTML = otherBody.getTableHTML(otherBody._variableRecordHeightFieldNums, 
                                                rowNum, rowNum+1, true);

                otherBody._gettingRowHeightSpacerHTML = false;
                otherBody._suppressRowVPaddingBorder = false;
                otherBody._suppressMinHeightCSSText = false;
                
            }
            if (this._variableRecordHeightFieldNums) {
                var drawnStartCol = drawRect[2],
                    drawnEndCol = drawRect[3],
                    cols = [];
                for (var i = 0; i < this._variableRecordHeightFieldNums.length; i++) {
                    var colNum = this._variableRecordHeightFieldNums[i];
                    if (colNum < drawnStartCol || colNum > drawnEndCol) {
                        cols.add(colNum);
                    }
                }
                
                if (cols.length > 0) {
                   
                    this._suppressRowVPaddingBorder = true;
                    this._suppressMinHeightCSSText = true;
                
                    // We want to pick up inactive cell values
                    // for edit fields or any field with custom 'inactive' formatters
                    this._gettingRowHeightSpacerHTML = true;
                    if (rowHTML == null) {
                        rowHTML = this.getTableHTML(cols, 
                                                rowNum, rowNum+1, true);
                    } else {
                        rowHTML = "<table cellspacing=0 cellpadding=0><tr><td>" +
                                    rowHTML + "</td><td>" + 
                                    this.getTableHTML(cols, rowNum, rowNum+1, true) + 
                                    "</td></tr></table>";
                    }

                    this._gettingRowHeightSpacerHTML = false;
                    this._suppressRowVPaddingBorder = false;
                    this._suppressMinHeightCSSText = false;
                }
            }
            if (rowHTML != null) return rowHTML;
        }
        return "&nbsp;";
    },

    // Scrolling / Scroll Sync
    // ---------------------------------------------------------------------------------------

    // Have v-scrolling occur on the frozen body on mouseWheel
    // This essentially duplicates the mouseWheel handler at the Canvas level for
    // widgets with visible scrollbars.
    mouseWheel : function () {
        if (this.frozen && this.grid != null) {
            
            
            var wheelTarget = this.ns.EH.lastEvent.wheelTarget;
            var wheelDeltaY = this.ns.EH.lastEvent.wheelDeltaY,
                wheelDeltaX = this.ns.EH.lastEvent.wheelDeltaX;
            // Can we scroll in the direction the user requested?
            var noScrollV = (wheelTarget != null && wheelTarget != this) || 
                            (wheelDeltaY == 0) ||
                             (wheelDeltaY < 0 && this.scrollTop == 0) ||
                             (wheelDeltaY > 0 && this.scrollTop == this.getScrollBottom()),

                noScrollH =  (this.customHscrollbar == null ||
                                !this.customHscrollbar.isVisible()) ||
                            (wheelTarget != null && wheelTarget != this) || 
                            (wheelDeltaX == 0) ||
                             (wheelDeltaX < 0 && this.scrollLeft == 0) ||
                             (wheelDeltaX > 0 && this.scrollLeft == this.getScrollRight());
            if (!noScrollH) {
                wheelTarget = this;
                var scrollLeft;
        
                // For each increment the user scrolled the mouse wheel, we want to move about 50px
                // This seems to approximately match native scrolling speed.
                scrollLeft = 
                    this.scrollLeft + Math.round(wheelDeltaX * isc.Canvas.scrollWheelDelta);
                // Note that scrollTo already catches scrolling past beginning or end
                this.scrollTo(scrollLeft, null, "mouseWheel");
            }
            
            if (!noScrollV) {
                var scrollTop = this.scrollTop + Math.round(wheelDeltaY * isc.Canvas.scrollWheelDelta);
                // Scroll the main body (we'll scroll in response to that) rather than
                // scrolling the frozen body directly.
                this.grid.body.scrollTo(null, scrollTop, "frozenMouseWheel");
            }
            
            if (!noScrollH || !noScrollV) return false;
        }
        return this.Super("mouseWheel", arguments);
    },

    // Override _getDrawRows()
    // Have the frozen body rely on the unfrozen body to handle drawAhead / quickDrawAhead
    // etc and keep set of drawn rows in sync
    
    _getDrawRows : function (a, b, c) {
        if (this.frozen && this.grid) {
            var grid = this.grid,
                body = grid.body;
            
            if (body._initialDrawRows != null) {
                return body._initialDrawRows;
            }
            return grid.body._getDrawRows(a, b, c);
        }
        return this.Super("_getDrawRows", arguments);
    },
    
    // Override getDrawAllMaxCells()
    // We need to keep frozen and unfrozen body draw rows in synch (absolutely required
    // for virtual scrolling to work).
    // This is handled by _getDrawRows() but that method isn't consulted if the
    // drawAllMaxCells threshold isn't hit.
    getDrawAllMaxCells : function () {
        var grid = this.grid;
        if (grid && grid.frozenFields != null && grid.virtualScrolling) {
            return 0
        }
        return this.drawAllMaxCells;
    },

    // Helper to determine whether the data currently has a known length
    // used by GR.getVisibleRows() / getDrawArea().
    lengthIsKnown : function () {
        var grid = this.grid,
            data = grid && grid.data;
        return ((data && data.lengthIsKnown) ? data.lengthIsKnown() : true);
    },

    // helper to check whether event is in a drag handle field
    
    _shouldAllowRecordDrag : function () {
        if (!isc.Browser.isTouch) return true;

        var grid = this.grid;
        if (!grid || !grid._shouldUseDragHandles()) return true;
        
        var fieldX = grid.getOffsetX(isc.EH.mouseDownEvent),
            fieldNum = grid.getEventColumn(fieldX),
            field = grid.getField(fieldNum)
        ;
        return field && field.isDragHandle;
    },

    // override to select on mouseDown (rather than mouseUp) for clicks in the drag handle field
    _shouldSelectOnMouseUp : function (colNum) {
        var field;
        if (isc.Browser.isTouch) { // drag handle check will only impact touch targets
            field = this.grid.getField(this.grid.getFieldNumFromLocal(colNum, this));
        }
        return this.invokeSuper(isc.GridBody, "_shouldSelectOnMouseUp", colNum,
                                field && field.isDragHandle);
    },

    // doneFastScrolling: ensure *both* bodies redraw without draw-ahead direction
    doneFastScrolling : function () {
        // we only expect to see this fire on the unfrozen body - the frozen body doesn't
        // show a scrollbar so won't get the thumb drag which initializes this method
        if (!this.frozen && this.grid != null && this.grid.frozenBody != null) {

            var redrawFrozenBody = this._appliedQuickDrawAhead;
            this.Super("doneFastScrolling", arguments);
            if (redrawFrozenBody) {
                this.grid.frozenBody._suppressDrawAheadDirection = true;
                this.grid.frozenBody.markForRedraw("Done fast scrolling on unfrozen body");
            }
        }
    },

    // observe the scroll routine of the body so we can sync up
    scrollTo : function (left, top, reason, animating) {
        if (isc._traceMarkers) arguments.__this = this;

        // restore native DOM handle appearance and behavior after user-initiated scroll
        if (this._hideScrollbars && reason == "nativeScroll") {
            
            delete this._hideScrollbars;
            this.setStyleName(this.styleName);
            
            var innerDiv = this._getZIndexDiv();
            if (innerDiv) innerDiv.className = "";
        }

        // Clamp the positions passed in to the edges of the viewport
        // (avoids the header from getting out of sync with the body.)
        
        if (left != null) {
            
            var maxScrollLeft = this.getScrollWidth() - this.getViewportWidth();
            left = Math.max(0, Math.min(maxScrollLeft, left));
        }
        if (top != null) {
            
            var maxScrollTop = this.getScrollHeight() - this.getViewportHeight();
            top = Math.max(0, Math.min(maxScrollTop, top));
        }
        var lg = this.grid;

        
        this.invokeSuper(isc.GridBody, "scrollTo", left,top,reason,animating);
        
        //this.logWarn("body.scrollTo: " + this.getStackTrace());
        // dontReport when we're being called in response to bodyScrolled
        // observation!
        var dontReport = this._noScrollObservation;

        
        if (!dontReport) lg.bodyScrolled(this.getScrollLeft(), this.getScrollTop(), this.frozen);

        // If the body scrolled without forcing a redraw, ensure any visible edit form
        // items are notified that they have moved.
        
        if (!this.isDirty() && lg._editorShowing) {
            var form = lg._editRowForm,
                allItems = form.getItems(),
                items = [];
            for (var i = 0; i < allItems.length; i++) {
                if (allItems[i].isDrawn()) items.add(allItems[i]);
            }
            form.itemsMoved(items);
        }

    },

    // helper to scroll to top without redrawing
    _resetScrollTopBeforeFetch : function () {
        var delayedRedraw = this._delayedRedraw;
        this._delayedRedraw = true;
        this.scrollTo(null, 0);
        this._delayedRedraw = delayedRedraw;
    },

    
    _fixIEFocusScrollArtifacts : function () {
        var mustRedraw = this._redrawToFixIEFocusScrollArtifacts;
        if (mustRedraw && this.grid && this.grid.frozenBody != null 
            && this.virtualScrolling) 
        {
            this.logWarn("Disabling redraw");
            mustRedraw = false;
        }
        
        if (mustRedraw) {
            // use fireOnPause to minimize redraws (Even though this means the lines sit there for
            // a few ms)
            this.fireOnPause("redrawToFixIEFocusScrollArtifacts", 
                {target:this, methodName:"markForRedraw", args:["fixIEScrollArtifacts"]}, 
                100);
        } else {
            var style = this.getStyleHandle();
            // trivial touch is sufficient to clear the odd focus-outline scroll artifacts
            if (style) style.backgroundColor = style.backgroundColor;
        }
    },

    // Embedded Components
    // ---------------------------------------------------------------------------------------

    // embedded components can be per row or per cell.
    // When per-cell the GR APIs act by colNum only, not by field name.
    // However for us to handle field reorder, show/hide, etc it's useful to hang fieldName
    // onto the embeddedComponents as well
    addEmbeddedComponent : function (component, record, rowNum, colNum, position, suppressRedraw) {
        var comp = this.invokeSuper(isc.GridBody, "addEmbeddedComponent", component, record,
                                    rowNum, colNum, position, suppressRedraw);
        if (component._currentColNum != null && component._currentColNum != -1 && this.grid) {
            var grid = this.grid,
                colNum = component._currentColNum,
                gridColNum = grid.getFieldNumFromLocal(colNum, this),
                fieldName = grid.getFieldName(gridColNum);

            component._currentFieldName = fieldName;

            // set up a map of embedded components per column (fieldName)
            // This will make lookup quicker.
            if (grid._columnComponentsMap == null) {
                grid._columnComponentsMap = {};
            }
            if (grid._columnComponentsMap[fieldName] == null) {
                grid._columnComponentsMap[fieldName] = {};
            }
            grid._columnComponentsMap[fieldName][component.getID()] = true;
            // skip "%" sized components since they should never expand a field.
            if (component._percent_width == null) {
                grid._fieldComponentWidthsChanged(fieldName);
            }
        }

        return component;
    },
    removeEmbeddedComponent : function (record, component, suppressRedraw) {
        var grid = this.grid;
        if (grid) {
            var fieldName = component._currentFieldName;
            if (fieldName != null) {
                if (grid._columnComponentsMap && grid._columnComponentsMap[fieldName]) {
                    delete grid._columnComponentsMap[fieldName][component.getID()];
                }
                if (component._percent_width == null) {
                    grid._fieldComponentWidthsChanged(fieldName);
                }
            }
            // Clear out the stored field name which is basically stale at this point.
            component._currentFieldName = null;
        }
        this.invokeSuper(isc.GridBody, "removeEmbeddedComponent", record, component, suppressRedraw);
    },


    // Override getMaxEmbeddedComponentHeight() / upateHeightForEmbeddedComponents to
    // respect listGrid.recordComponentHeight if specified, even if there are no
    // embedded components for this record.
    
    updateHeightForEmbeddedComponents : function (record, rowNum, height) {

        if (record && !this.grid._hasEmbeddedComponents(record) && this.grid.showRecordComponents
            && this.grid.recordComponentHeight != null)
        {
            // Reimplementing the superClass version, except that this logic is running even
            // when there are no embeddedComponents on the row.
            var details = this.getMaxEmbeddedComponentHeight(record, rowNum);
            if (details.allWithin) {
                height = Math.max(height,details.requiredHeight);
                //this.logWarn("in updateHeightForEmbeddedComponents ("+this.grid+"): details are "+isc.echoAll(details)+"\nheight is "+height);
            } else {
                height += details.requiredHeight;
                //this.logWarn("in updateHeightForEmbeddedComponents ("+this.grid+"): details are "+isc.echoAll(details)+"\nheight is "+height);
            }

            return height;
        }

        return this.invokeSuper(isc.GridBody, "updateHeightForEmbeddedComponents", record, rowNum, height);
    },

    getMaxEmbeddedComponentHeight : function (record, rowNum) {
        var heightConfig = this.invokeSuper(isc.GridBody, "getMaxEmbeddedComponentHeight",
                                        record, rowNum);
        if (this.grid.showRecordComponents && this.grid.recordComponentHeight != null) {
            heightConfig.requiredHeight = Math.max(heightConfig.requiredHeight,
                                            this.grid.recordComponentHeight);
        }
        return heightConfig;
    },
    _writeEmbeddedComponentSpacer : function (record) {
        if (record && this.grid && this.grid.showRecordComponents
            && this.grid.recordComponentHeight != null)
        {
            return true;
        }
        return this.invokeSuper(isc.GridBody, "_writeEmbeddedComponentSpacer", record);
    },

    _placeEmbeddedComponents : function () {
        
        if (this.grid && this.grid._autoFittingFields) {
            return;
        }
        return this.Super("_placeEmbeddedComponents", arguments);
    },

    getAvgRowHeight : function () {
        if (this.grid) return this.grid.getAvgRowHeight(this);
        return this.Super("getAvgRowHeight", arguments);
    },

    // override shouldShowAllColumns() - we can avoid showing all columns if row height
    // is variable *only* because of an expansion component expanding the entire row since
    // the heights won't vary per-cell.
    shouldShowAllColumns : function () {
        if (this.showAllColumns) {
            return true;
        }
        if (!this.fixedRowHeights) {
            if (this.grid.canExpandRecords && this.grid._specifiedFixedRecordHeights) {
                return false;
            }
            
            // If we have specific columns marked as overflowers we can support incremental
            // column rendering by ensuring the row height matches the rendered size for
            // those columns.
            // This will reduce the total amount of HTML we have to generate as we can
            // render only the out-of-view overflowing cells for measurement purposes 
            // rather than the whole row.
            if (this.grid.variableRecordHeightFields != null) {
                return false;
            }
            return true;
        }
        if (this.overflow == isc.Canvas.VISIBLE) {
            return true;
        }
        return false;

    },

    // Editing
    // ---------------------------------------------------------------------------------------

    //> @method listGrid.markForRedraw()
    // @include canvas.markForRedraw
    // @visibility external
    //<

    // Redraw overridden:
    // - Update the editRow form items (we don't create more items than we need when
    //   rendering incrementally)
    // - Update the values in the edit row form.
    redraw : function (reason,b,c,d) {
        // since we're doing a full redraw, cancel pending refreshCell() calls
        if (this._pendingCellRefreshTimer) this.cancelPendingCellRefresh();

        // check if a string grid.searchForm needs to be resolved
        if (this.grid) this.grid.checkForSearchForm();

        // flag to note we're redrawing - this is used by getDrawnFields()
        this._redrawing = true;
        // Ensure we pick up and size to a fresh value
        // and set the flag so clearCellValueCacheOnRedraw() doesn't 
        // clear the cache again.
        // This flag cleared below after Super() call.
        this._clearCellValueCacheForRedraw();
        this._clearedCellValueCacheInRedrawThread = true;
        
        this._cacheVariableHeightFieldNums();

        // If alwaysShowEditors is marked as true, but editorShowing is false it implies our
        // attempt to start editing on draw() failed - presumably there were no
        // editable cells in view.
        // See if we can start editing now in this case
        var lg = this.grid;

        if (lg.alwaysShowEditors && !lg._editorShowing) {
            // pull stashed value for target edit cell if provided
            // by scrollCellIntoView
            var rowNum, colNum;
            if (lg._editCellAfterRedraw) {
                rowNum = lg._editCellAfterRedraw[0];
                colNum = lg._editCellAfterRedraw[1];
                delete lg._editCellAfterRedraw;
            }
            lg.startEditing(rowNum,colNum,true,null,true);
        }
        if (lg._editorShowing && !lg._inShowEditForm) {
            lg._cacheCurrentEditCells();
        }

        
        var editForm = lg._editRowForm,
            editing = lg._editorShowing,
            editColNum, editRowNum, editRecord,
            completeWidths,
            fieldsToRemove;

        // If the grid is showing inactive Editor HTML for any cells, we'll clear it
        // (and potentially regenerate it) as part of redraw(). Notify the grid so it can clear
        // up inactive contexts stored on the edit form items
        
        lg._clearingInactiveEditorHTML();

        // if body redraw came from data change, folder opening, or resizing of content,
        // it's likely to introduce a v-scrollbar.
        // If leaveScrollbarGap is false, call '_updateFieldWidths()' before the redraw occurs so
        // we leave a gap for the v-scrollbar, rather than redrawing with both V and H scrollbar,
        // then resizing the fields and redrawing without an H-scrollbar.
        if (!lg.leaveScrollbarGap && lg.predictScrollbarGap && (this.overflow == isc.Canvas.AUTO)) {
            var vScrollOn = this.vscrollOn,
                
                vScrollWillBeOn = !lg.isEmpty() &&
                                  (lg.getTotalRows() * lg.cellHeight)  > this.getInnerHeight();

            if (vScrollOn != vScrollWillBeOn) {
                // ensure we don't try to recalculate field widths a second time by clearing
                // the _fieldWidthsDirty flag
                delete this._fieldWidthsDirty;
                lg._updateFieldWidths("body redrawing with changed vertical scroll-state");

            }
        }

        var editFieldName, suppressRowElementFocus = false;

        if (editing) {
            this.logInfo("redraw with editors showing, editForm.hasFocus: " +
                         editForm.hasFocus, "gridEdit");
            editColNum = lg.getEditCol();

            
            if (isc.Browser.isEdge) {
                editFieldName = lg.getFieldName(editColNum);
                lg._parkFocus(editForm ? editForm.getItem(editFieldName) : null, editColNum);
            }

            // See comments near _storeFocusForRedraw() for how edit form item focus is handled
            // on redraw
            this._storeFocusForRedraw();

            // This will add the new edit items corresponding to the newly displayed fields
            // and return the items that need to be removed (after the body is actually redrawn,
            // which will hide them)
            // It also fires the "clearing()" pre-clear notification if a drawn item is
            // removed. cleared() will be fired after the redraw completes.
            fieldsToRemove = this._updateEditItems();
            
        // If we're not editing, but we have an editForm with drawn items, fire the 'clearing()' notification.
        // We fire the cleared notification below (after the DOM has been updated)
        } else if (editForm != null) {
            var items = editForm.getItems();
            for (var i = 0; i < items.length; i++) {
                if (items[i].isDrawn()) items[i].clearing(true);
            }
            
        } else if (isc.screenReader) {
            var focusCanvas = this.ns.EH.getFocusCanvas();
            // Suppress focusing the row element if some other widget is focused.
            suppressRowElementFocus = focusCanvas !== this;
        } else {
            // Redraw when not editing / in screenReader mode: remember the native
            // text selection within a cell if there is one so we can reset it post draw
            
            if (lg.selectCellTextOnClick) {
                this._textSelectionConfig = lg._getSelectedCellTextConfig();
            }
        }

        // refresh field widths if necessary
        
        var fwReason = this._fieldWidthsDirty;
        if (fwReason) {
            
            delete this._fieldWidthsDirty;
            lg._updateFieldWidths(fwReason);
        }

        // store the new drawArea
        var newDrawArea = this.getDrawArea();
        

        var grid = this.grid,
            drawArea = this._oldDrawArea;

        if (!drawArea) drawArea = this._oldDrawArea = [0,0,0,0];

        var grid = this.grid,
            firstRecord = grid._getCachedCellRecord(newDrawArea[0]),
            lastRecord = grid._getCachedCellRecord(newDrawArea[1]),
            dataPresent = (firstRecord != null && lastRecord != null);

        if (dataPresent && !drawArea.equals(newDrawArea)) {
            // the old and new drawAreas differ and the extents of the new data are present -
            // fire the notification method and update the stored _oldDrawArea
            
            if (!this.frozen) {
                grid._drawAreaChanged(drawArea[0], drawArea[1], drawArea[2], drawArea[3], this);
                this._oldDrawArea = newDrawArea;
            }
        }

        
        delete this._drawnEditItems;

        this.invokeSuper(isc.GridBody, "redraw", reason,b,c,d);

        // clear the "redrawing" flag since the HTML is now up to date
        delete this._redrawing;
        // clear the flag indicating we already dropped our body cell-value-cache
        // so we drop cache again (as we should) on future redraws
        delete this._clearedCellValueCacheInRedrawThread;

        if (grid._clearRemoveAnimation) {
            // flag set from grid._removeDataAnimationComplete() - indicates the row-animation 
            // settings from an animated record remove need to be cleared
            delete grid._clearRemoveAnimation;
            this._clearLastRowAnimation()
        }

        // Always update all recordComponents on redraw().
        // don't rely on the draw area changing since we may be showing the same set of
        // rowNum/colNums but having underlying data or field meaning changes.
        // Note: updateRecordComponents() updates components in frozen and unfrozen bodies.
        // If this is a redraw of the frozen body, don't call updateRecordComponents() if
        // the redraw was tripped by scrolling or data change as in this case we'll also
        // get a redraw of the unfrozen body which can handle updating the RC's.
        // (DO still call the method in other cases as it may imply the fields in the frozen
        // body have changed, etc).
        // NOTE 2014: do this *after* calling Super() so that the drawn rows match the 
        // data        
        if (!(this.frozen && this._suppressRecordComponentsUpdate)) {
            grid.updateRecordComponents();
        }
        this._suppressRecordComponentsUpdate = false;

        if (editing) {
            // Remove the items that correspond to fields that are no longer rendered in the DOM
            if (fieldsToRemove != null && fieldsToRemove.length > 0) {
                editForm.removeItems(fieldsToRemove);
            }

            // Fire the method to notify form items that they have been drawn() / redrawn()
            // or cleared()
            
            lg._editItemsDrawingNotification(null, true, this);

            /*
            var itemColArray = [],
                items = lg._editRowForm.getItems();
            for (var i =0; i < items.length; i++) {
                itemColArray.add(items[i].colNum + " - " + items[i].name);
            }
            this.logWarn("After redraw - edit form covers these cols:" + itemColArray);
            */

            
            lg.updateEditRow(lg.getEditRow());

            
            var focusParkForm = isc.ListGrid._focusParkForm;
            if (isc.Browser.isEdge && editFieldName && focusParkForm &&
                (focusParkForm.hasFocus || focusParkForm.itemHasFocus()))
            {
                var focusItem = editForm.getItem(editFieldName);
                if (focusItem) this._delayedFocusEvent = focusItem.delayCall("focusAtEnd");

            } else if (editForm.hasFocus ||
                (this._editorSelection && isc.EH.getFocusCanvas() == null))
            {
                this._restoreFocusAfterRedraw(editColNum);
            } else {
                delete this._editorSelection;
            }

        } else {
            if (editForm != null) {
                // notify the form that it's items have been cleared() (will no-op if they're
                // not currently drawn)
                lg._editItemsDrawingNotification(null, null, this);
            }

            // _nativeFocusRow was remembered last time putNativeFocusInRow was called
            
            if (isc.screenReader) {
                this._putNativeFocusInRow(this.getNativeFocusRow(), this.getNativeFocusColumn(), suppressRowElementFocus);
            
            // Reset native text selection if appropriate
            } else if (lg.selectCellTextOnClick && this._textSelectionConfig != null) {
                var config = this._textSelectionConfig;
                delete this._textSelectionConfig;
            
                var colNum = lg.getLocalFieldNum(config.colNum);
                var cell = this.getTableElement(config.rowNum, colNum);
                
                if (cell != null && window.getSelection != null) {
                    var range = window.document.createRange();
                    range.selectNodeContents(cell);
                
                    if (range.toString() == config.text) {
                        var sel = window.getSelection();
                        sel.removeAllRanges();
                        sel.addRange(range);
                    }

                }            
            }
        }



        
        if (lg._scrollCell != null) lg._delayedScrollToCell();


    },
    
    _clearCellValueCacheForDraw : function () {
        
        if (this._clearedCellValueCacheInDrawThread) return;
        
        return this.Super("_clearCellValueCacheForDraw", arguments);
    },
    
    
    _clearCellValueCacheForRedraw : function () {
        // If we already cleared the cellValueCache in this thread due to our override
        // return
        
        if (this._clearedCellValueCacheInRedrawThread) return;
        
        // Also bail if we're doing a redraw thanks to explicit auto-fit rather than
        // data changed
        var grid = this.grid;
        if (grid && (grid._autoFittingField || grid._autoFittingFields)) {
            return;
        }
        return this.Super("_clearCellValueCacheForRedraw", arguments);
    },
    
    // Override bypassCellValueCache - avoid caching edit item cell values
    // This is appropriate for the case where we are writing out inactive 
    // element HTML - for example to measure the width of an auto-fit column.
    // Ditto for group-nodes, where we suppress the HTML altogether when getting
    // auto-fit measurement HTML
    
    bypassCellValueCache : function (record,rowNum,colNum) {
    
        if (this.grid) {
            var grid = this.grid;
            if (this.grid.isGrouped && record && record._isGroup) {
                return true;
                
            } else if (this.grid._editorShowing) {
                        
                var editRowNum = grid._editRowNum,
                    editStartRow = editRowNum;
                if (editStartRow != null && grid.allowRowSpanning) {
                    editStartRow = grid.getCellStartRow(editStartRow, fieldNum);
                }
            
                var isEditRow = editStartRow == rowNum;
                if (isEditRow) {
                    var fieldNum = grid.getFieldNumFromLocal(colNum, this);
                    var isEditCell = (!grid.editByCell || grid._editColNum == fieldNum) &&
                                  
                                  (grid._shouldShowEditCell(editRowNum,fieldNum));

                    if (isEditCell) return true;
                }
            }
            // We almost always want inactive 'measure' HTML for cells to be cached
            // so we don't have to render out grid content twice, but if there's
            // a separate inactive HTML formatter we'll need to call it, so can't
            // use the cache in this case.
            if (grid._gettingInactiveCellHTML(rowNum, 
                    grid.getFieldNumFromLocal(colNum, this))) 
            {
                if (grid.formatInactiveCellValue != null) return true;
                var field = grid.getField(colNum);
                if (field && field.formatInactiveCellValue != null) return true;
            }
        }
        // Default from GridRenderer simply avoids caching the print version
        return this.isPrinting;
    },
    
    redrawOnScroll : function (immediate) {
        if (this.frozen) this._suppressRecordComponentsUpdate = true;
        return this.Super("redrawOnScroll", arguments);
    },

    
    _lockVirtualScrolling : function () {
        this.grid._virtualScrollingLocked = true;
    },
    _canStopVirtualScrolling : function () {
        return !this.grid._virtualScrollingLocked;
    },    

    // force redraw on setDisabled() if we're showing an edit form to ensure we
    // redraw the items in enabled/disabled state
    setHandleDisabled : function (disabled) {
        var lg = this.grid;
        // need to force redraw generally, so that cell-styles get updated
        if (this.isDrawn()) { 
            this.markForRedraw("Grid body disabled");
        }
        return this.Super("setHandleDisabled", arguments);
    },

    // Add edit items corresponding to newly displayed fields (displayed due to incremental
    // rendering)
    // If any fields are to be hidden, do not remove these here, but return them in an array so
    // they can be removed from the form after the redraw completes
    // Note that the order of items in the form will not match the order of fields necessarily -
    // acceptable since developers will be interacting with the items' colNum attribute rather than
    // index in the edit form fields array.
    
    _updateEditItems : function () {
        // We keep the set of items in the editForm in sync with the set of
        // visible columns for performance.
        // Determine which items need to be created or removed here.
        var lg = this.grid, editForm = lg.getEditForm(),
            fieldsToRemove = [],
            editItems = editForm.getItems();
        if (!lg.editByCell) {

            // set up the vars used in creating form items
            var editRowNum = lg.getEditRow(),
                editRecord = lg.getRecord(editRowNum),
                
                completeWidths = lg.getEditFormItemFieldWidths(editRecord);

            // Determine what fields are rendered into the body
            // If we have frozen columns, we will always be showing them, in addition to whatever
            // fields are visible
            var editItems = editForm.getItems(),
                itemNames = editItems.getProperty("name"),
                fields = lg.getDrawnFields(),
                fieldNames = fields.getProperty("name");

            // minor optimization - if possible, avoid iterating through both arrays
            var lengthsMatch = editItems.length == fields.length,
                changed = false;
            
            // fields that are no longer drawn should be removed
            for (var i = 0; i < editItems.length; i++) {
                
                // don't actually remove the items until they have been removed from the DOM via
                // redraw
                var index = fieldNames.indexOf(itemNames[i]),
                    itemDrawn = editItems[i].isDrawn();

                if (index == -1) {
                    changed = true;
                    fieldsToRemove.add(editItems[i]);
                    if (itemDrawn){
                        editItems[i].clearing(true);
                    }
                } else {
                    var fieldName = itemNames[i],
                        // Check canEdit for each field - if it's canEdit:false we don't want to fire
                        // drawing notifications!
                        
                        canEdit = lg._shouldShowEditCell(editRowNum, index);
                    if (canEdit) {
                        
                        editItems[i].width = completeWidths[editItems[i].colNum];
                        editItems[i]._size = null;
                    } else {
                        // Fire the 'clearing()' pre-clear notification on items being removed
                        // from the DOM
                        if (itemDrawn) editItems[i].clearing(true);
                    }
                }
            }

            // newly rendered fields should be added
            if (!lengthsMatch || changed) {
                var editedVals = lg.getEditedRecord(editRowNum, 0);
                for (var i = 0; i < fields.length; i++) {
                    if (!itemNames.contains(fieldNames[i])) {
                        var colNum = lg.fields.indexOf(fields[i]);
                        var item = lg.getEditItem(
                                        fields[i],
                                        editRecord, editedVals, editRowNum,
                                        colNum, completeWidths[colNum]
                                   );
                        editForm.addItem(item);
                        if (editForm._fieldCriteriaCache) {
                            
                            delete editForm._fieldCriteriaCache[fieldNames[i]];
                        }
                    }
                }
                // Keep the edit form items in the same order in the items array as
                // they are in the ListGrid.
                
                editForm.items.sortByProperty("colNum", Array.ASCENDING);
            }
        }
        // if editByCell is true this is not necessary - we consistently have the editForm contain
        // only the necessary cell
        return fieldsToRemove;
    },

    // _storeFocusForRedraw()
    // called when the edit form is showing and the body is being redrawn.
    // remember the current focus state / selection of the edit form so we can reset it after
    // redrawing the item in the DOM
    // blur the item (suppressing the handler if the item will be refocused after redraw)


    

    
    _storeFocusForRedraw : function () {
        var lg = this.grid,
            editForm = lg.getEditForm(),
            editColNum = lg.getEditCol();

        if (editForm.hasFocus) {
            var focusItem = editForm.getFocusSubItem();
            if (focusItem) {
                focusItem.updateValue(true);
                var origFocusItem = focusItem;

                // We may be focused in a sub item, in which case we need to use the
                // parentItem to get the field name wrt our fields array
                while (focusItem.parentItem != null) {
                    focusItem = focusItem.parentItem;
                }

                // blur the focus item before removing it from the DOM.
                // If canEditCell for the current focus item returns false, we will
                // not redisplay it at the end of this method, so allow it to fire the
                // standard blur-handler
                
                
                if (!lg._shouldShowEditCell(focusItem.rowNum, focusItem.colNum) ||
                    editColNum != focusItem.colNum) {
                    
                    editForm.blur();
                } else {
                    
                    if (focusItem.hasFocus) {
                        // remember the current selection, so we can reset it after the redraw
                        // and refocus. [will have no effect if the item is not a text-item]
                        focusItem.rememberSelection();
                        this._editorSelection =
                            [focusItem._lastSelectionStart, focusItem._lastSelectionEnd];
                    }
                    editForm._blurFocusItemWithoutHandler();

                }
                
            }
        }
        
        editForm._setValuesPending = true;
    },

    // If the editForm is visible during a body redraw() this method ensures that after the
    // redraw completes, and the form items are present in the DOM, focus / selection is restored
    // to whatever it was before the redraw
    _restoreFocusAfterRedraw : function (editColNum) {
        var lg = this.grid,
            editForm = lg.getEditForm(),
            editItem = editForm.getItem(lg.getEditorName(lg.getEditRow(), editColNum));
        if (editItem != null && editItem.isDrawn()) {
            var scrollLeft = lg.body.getScrollLeft(),
                scrollTop = lg.body.getScrollTop(),
                viewportWidth = lg.body.getViewportWidth(),
                viewportHeight = lg.body.getViewportHeight(),
                rect = editItem.getRect(),
                // If we are partially out of the viewport, don't put focus into item -
                // forces a native scroll which can interfere with user scrolling.
                // Note: partially out of viewport actually could be ok for text items
                // where focus will only cause a scroll if the actual text is offscreen.
                
                // if the field is frozen, it won't be scrolled out of view
                frozen = this.grid.fieldIsFrozen(editColNum),
                outOfViewport = !frozen && 
                                (rect[0] < scrollLeft ||
                                rect[1] < scrollTop ||
                                rect[0] + rect[2] > (scrollLeft + viewportWidth) ||
                                rect[1] + rect[3] > (scrollTop + viewportHeight));
            if (!outOfViewport) {
                // Avoid selecting the focused value - we don't want rapid keypresses
                // to kill what was previously entered
                editForm._focusInItemWithoutHandler(editItem);
                // Reset the selection / text insertion point to whatever was
                // remembered before the redraw.
                
                if (this._editorSelection && this._editorSelection[0] != null) {
                    editItem.setSelectionRange(this._editorSelection[0], this._editorSelection[1]);
                }
                // clear up the _editorSelection flag so we don't try to restore focus again on
                // scroll
                delete this._editorSelection;
            }
        }
    },
    
    _suppressEventHandling : function (lastMouseEvent) {
        if (this.Super("_suppressEventHandling", arguments)) return true;
        // If an event occurred over an expansion component, don't react to it at the GridRenderer level
        
        if (lastMouseEvent) {
            var target = lastMouseEvent.target;
            while (target && target != this) {
                if (target.isExpansionComponent) return true;
                target = target.parentElement;
            }
        }
        return false;
    },
    
    // Override mouseOut to avoid clearing rollover styling when the user interacts with a
    // child of a CanvasItem editor
    
    mouseOut : function (a,b,c,d,e) {
        var grid = this.grid;
        if (grid.getEditRow() != null) {
            var editForm = grid.getEditForm();
            var target = isc.EH.getTarget();
            while (target && target.parentElement) {
                if (target.canvasItem != null && editForm.items.contains(target.canvasItem)) {
                    return;
                }
                if (target == this) break;
                target = target.parentElement;
            }
        }
        return this.invokeSuper(isc.GridBody, "mouseOut", a,b,c,d,e);
    },

    // Override cellMove: We need to be able to show validation error HTML
    cellMove : function (record,rowNum,colNum) {
        // If the event is bubbled from an embedded child widget no need to check for
        // icons
        if (isc.EH.lastEvent.target == this) {
            // If the error icon is SVG, the native target might be an element within the error
            // icon handle. We therefore need to examine ancestors of the native target, too.
            var errorIconTarget = isc.EH.lastEvent.nativeTarget;
            for (; errorIconTarget; errorIconTarget = errorIconTarget.parentNode) {
                if (errorIconTarget.getAttribute &&
                    errorIconTarget.getAttribute("isErrorIcon") == "true")
                {
                    break;
                }
                // stop if we reach this widget's handle
                if (errorIconTarget === this.getHandle()) {
                    errorIconTarget = null;
                    break;
                }
            }
            if (errorIconTarget) {
                // adjust for frozen fields
                colNum = this.grid.getFieldNumFromLocal(colNum, this);
                if (this.grid._overErrorIcon != null) {
                    var lastRow = this.grid._overErrorIcon[0],
                        lastCol = this.grid._overErrorIcon[1];
                    if (lastRow != rowNum || lastCol != colNum) {
                        this.grid._handleErrorIconOut(rowNum, colNum);
                    }
                }

                if (this.grid._overErrorIcon == null) {
                    this.grid._handleErrorIconOver(rowNum,colNum);
                }
            } else {
                if (this.grid._overErrorIcon != null) {
                    this.grid._handleErrorIconOut(rowNum, colNum);
                }
            }
        }
    },

    cellOut : function (record, rowNum, colNum) {
        if (this.grid._overErrorIcon != null) {
            this.grid._handleErrorIconOut(rowNum, colNum);
        }
    },

    // Override shouldShowRollOver to avoid styling the current edit cell with the over
    // style.
    // This avoids the issue where if you roll over the edit form items, the rollover style
    // would flash off as the body receives a mouseout (looks very weird).
    // Also - support showing the rollOver styling for the current focus row even if 
    // showRollOver is false.
    // We'll still use the rollOver style name in this case, but it improves keyboard accessibility
    // without requiring the normal rollOver effects.
    shouldShowRollOver : function (rowNum, colNum,a,b) {

        //if (!this.invokeSuper(isc.GridBody, "shouldShowRollOver", rowNum,colNum,a,b)) return false;
        
        var hiliteOnFocus = this.grid.hiliteRowOnFocus;
        if (hiliteOnFocus == null) {
            hiliteOnFocus = this.grid.showRollOver;
        }

        var lg = this.grid;
        if ((!lg.showRollOver &&
             (!hiliteOnFocus || (this._lastHiliteRow != rowNum)))
            || this._rowAnimationInfo) 
        {
            return false;
        }

        var record = lg.getRecord(rowNum);

        // Don't show roll over if the record in question doesn't want it.
        if (record && record[lg.recordShowRollOverProperty] === false) {
            return false;
        }
        // disabled cells don't show roll over styling
        if (!this.cellIsEnabled(rowNum, colNum, record)) return false;

        // don't show rollover for the edit row
        
        if (lg._editorShowing && rowNum == lg._editRowNum) {
            return false;
        }
        return true;
    },

    updateRollOver : function (rowNum, colNum, movingToNewCell) {
        var lg = this.grid;

        if (lg.showRollOverCanvas || lg.showRollUnderCanvas || 
            lg.showSelectedRollOverCanvas || lg.showSelectedRollUnderCanvas) 
        {
            // movingToNewCell param passed when the user rolled off one cell and over another
            // and this method is being called to clear the first cell hilight.
            // we can no-op in this case since we'll update the rollOverCanvas on the subsequent
            // call to this method, and that will avoid a clear/draw cycle (and flash)
            
            if (!movingToNewCell) {
                var leaving = !(this.lastOverRow == rowNum && this.lastOverCol == colNum);
                var gridColNum = lg.getFieldNumFromLocal(colNum, this);
                lg.updateRollOverCanvas(rowNum, gridColNum, leaving);
            }
            // no support for frozen body / rollOverCanvas yet

        }

        this.setRowStyle(rowNum, null, this.canSelectCells || this.useCellRollOvers ?
                         colNum : null);

        // frozen fields: if there is another body, force its rollover row to match and
        // update it
        var otherBody = (this == lg.body ? lg.frozenBody : lg.body);
        if (otherBody && !this.useCellRollOvers) {
            otherBody.lastOverRow = this.lastOverRow;
            otherBody.lastOverCol = this.lastOverCol;
            otherBody.setRowStyle(rowNum, null, (this.useCellRollOvers ? colNum : null));
        }
    },

    _selectCellOnMouseDown : function (record, rowNum, colNum) {
        
        this.grid.clearLastHilite();

        // remember the last cell clicked (used for keyboard navigation)
        // (Note: we use the same cell used for selection rather than the actual position
        // of the event as that's where the user will see the visual indication)
        this._lastSelectedRow = rowNum;
        this._lastSelectedCol = colNum;

        this.grid._lastSelectedBody = this;

        //this.logWarn("mouseDown at: " + [rowNum, colNum]);

        if (this.useRowSpanStyling) {
            // rowSpan-sensitive selection
            var gridSelection = this.grid.selectionManager;

            // selected cells are designed by the coordinates where spanning starts.
            // NOTE: this means that calling isSelected() with return false for any cell
            // coordinates where no cell exists in the DOM (because it was spanned over by a
            // rowSpanning cell in a previous row).  This is true even when the spanning cell
            // that eliminated that DOM cell is in facet selected.
            var startRow = this.getCellStartRow(rowNum, colNum);

            // for ctrl-click just select/deselect the clicked cell
            if (isc.EH.modifierKeyDown()) {
                var gridColumn = this.grid.getFieldNumFromLocal(colNum, this);
                gridSelection.selectOnMouseDown(this, startRow, gridColumn);
                return;
            }

            // deselect everything - shift modifiers, dragging or other cases not supported in
            // this mode
            gridSelection.deselectAll();

            // select all cells to the right that are partially or wholly spanned by the
            // clicked cell

            var gridBody, startCol, span,
                mode = this.rowSpanSelectionMode;

            if (mode == "forward" || mode == null) {
                // field num where the click landed, in terms of listGrid.fields
                startCol = this.grid.getFieldNumFromLocal(colNum, this);
                // cells spanned by the clicked cell
                span = this.getCellRowSpan(startRow, colNum);
            } else if (mode == "outerSpan") {
                // optionally, start the selection from the span of the first column, which
                // creates a selection behavior similar to the default row-level selection
                // behavior, based on the concept of the span in the first column defining the
                // "row"
                startCol = 0;
                gridBody = this.grid.getFieldBody(0);
                startRow = gridBody.getCellStartRow(rowNum, 0);
                span = gridBody.getCellRowSpan(startRow, 0);
            } else if (mode == "both") {
                // use the span of the clicked cell
                span = this.getCellRowSpan(startRow, colNum);
                // but go through all columns
                startCol = 0;
            } else {
                this.logWarn("unrecognized rowSpanSelectionMode: '" + mode + "'");
                return;
            }

            //this.logWarn("start cell: " + [startRow, startCol] +
            //             " spans: " + span);
            // for each column to the right of the starting column
            for (var column = startCol; column < this.grid.fields.length; column++) {
                // get the body that contains the field and the field's index within that body
                var bodyToSelect = this.grid.getFieldBody(column),
                    localFieldNum = this.grid.getLocalFieldNum(column);

                // for each row spanned by the starting cell
                for (var i = startRow; i < startRow+span; i++) {
                    // when selecting, select the coordinates of the beginning of the span
                    var cellStartRow = bodyToSelect.getCellStartRow(i, localFieldNum);
                    gridSelection.selectCell(cellStartRow, column);
                    // and skip past cells that were spanned over
                    i += (bodyToSelect.getCellRowSpan(cellStartRow, localFieldNum) - 1);
                }
            }
            return;
        }

        // if we're in the body, select rows or cells
        this.selectionManager.selectOnMouseDown(this, rowNum, colNum);
    },
    
    // override selectOnMouseDown/Up to disable selection when a row is clicked anywhere
    // besides the checkbox when selectionAppearance is checkbox.
    selectOnMouseDown : function (record, rowNum, colNum, d,e,f) {
        var shouldSelect = true,
            selApp = this.grid.selectionAppearance,
            cbSel = (selApp == "checkbox");
        if (cbSel) {
            // if frozen fields are showing, the cb field will show up in the frozen body!
            if ((this.grid.frozenFields != null && this.grid.frozenBody != this) || (
                // it's not the checkbox field and canSelectCells is false
                (this.grid.getCheckboxFieldPosition() != colNum && !this.canSelectCells) &&
                // it's not the expansion field, or it is but selectOnExpandRecord is false
                (this.grid.getExpansionFieldPosition() != colNum || !this.grid.selectOnExpandRecord)))
            {
                shouldSelect = false;
            }
        }
        
        if (shouldSelect) {
            if (this.canSelectCells) this._selectCellOnMouseDown(record, rowNum, colNum);
            else this.invokeSuper(isc.GridBody, "selectOnMouseDown", record, rowNum, colNum, d,e,f);
        }

        if (isc.screenReader) {
            // In screen reader mode, if canSelectCells is enabled, we want to hilite the cell;
            // otherwise, we will want to hilite the entire row.
            // _putNativeFocusInRow() calls _hiliteRecord(), so we will need to clear this hilite.
            this._putNativeFocusInRow(rowNum, colNum);
            if (this.canSelectCells) {
                var lastRow = this.lastOverRow,
                    lastCol = this.lastOverCol;
                this.lastOverRow = null;
                this.lastOverCol = null;
                this.updateRollOver(lastRow, lastCol);
                this.grid._lastKeyboardHiliteBody = this;
                this.grid._hiliteCell(rowNum, colNum);
            }
        } else {
            // If showRollOver is false and hiliteRowOnFocus is true we may be
            // showing a rollOver from keyboard navigation on another cell
            // Clear this now to avoid confusing styling.
            if (this._lastHiliteRow != null && this._lastHiliteRow != rowNum) {
                if (this.lastOverRow  == this._lastHiliteRow) {
                    var lastRow = this.lastOverRow,
                        lastCol = this.lastOverCol;
                    this.lastOverRow = null;
                    this.lastOverCol = null;
                    this.updateRollOver(lastRow, lastCol);
                }
            }
        }
        this._lastHiliteRow = rowNum;
        this._lastHiliteCol = colNum;
    },

    // If a user keyboard-navigated-to or clicked an unselectable row, should we deselect other rows?
    // Overridden to deselect others during keyboard navigation over group-nodes
    
    _deselectAllOnDisallowedSelectionEvent : function (record, rowNum, colNum, keyboardGenerated) {
        if (keyboardGenerated && this.grid.selectionType != "simple" && 
            !isc.EH.shiftKeyDown() && this.grid.isGroupNode(record)) 
        {
            return true;
        }
        return false;
    },

    
    // When showing the edit clickMask, a mouseDown will clear the mask and end editing
    // before normal mouse-down processing.
    // Override _getMouseDownCell to ensure, even if this caused the row-height to change, 
    // we return the cell coords before the change of row-height.
    _getMouseDownCell : function () {
        if (this._maskedMouseDownCell != null) {
            var cell = this._maskedMouseDownCell;
            // clear the property so it doesn't impact future mouseDowns
            this._maskedMouseDownCell = null;
            return cell;
        }
        return this.Super("_getMouseDownCell", arguments);
    },

    // Override mouseUp.
    // If the mouseUp occurred over a CanvasItem, ignore it.
    
    mouseUp : function () {
        var target = isc.EH.getTarget();
        
        if (this.grid && target != null && target != this && this.grid._editorShowing) {
            var editForm = this.grid.getEditForm();
            while (target != this && target != null && target != editForm) {
                if (target.canvasItem && editForm.items.contains(target.canvasItem)) {
                    return;
                }
                target = isc.isA.FormItem(target) ? target.containerWidget : target.parentElement;
            }
        }
        return this.Super("mouseUp", arguments);
    },

    selectOnMouseUp : function (record, rowNum, colNum, d,e,f) {
        var cbColNum = this.grid.getCheckboxFieldPosition(),
            selApp = this.grid.selectionAppearance;
        if (selApp != "checkbox" || (selApp == "checkbox" && cbColNum == colNum)) {
            this.invokeSuper(isc.GridBody, "selectOnMouseUp", record, rowNum, colNum, d,e,f);
        }
    },

    // Override handleSelectionChanged() to fire our viewStateChanged method
    handleSelectionChanged : function (record,state) {
        if (this.grid.suppressSelectionChanged) return;
        var returnVal = this.Super("handleSelectionChanged", arguments);
        // ignore the events that comes from the frozen body
        if (this._isFrozenBody() == 0) this.grid.handleViewStateChanged();
        return returnVal;
    },

    setSelection : function (selection) {
        this.clearSelection();
        this.Super("setSelection", arguments);
    },

    clearSelection : function () {
        var selection = this.selectionManager;
        this.Super("clearSelection", arguments);
        // if selection not inherited from ListGrid, destroy it
        if (selection && selection.isA("DependentCellSelection")) {
            selection.destroy();
        }
    },

    _setSeparateCellSelection : function (selection, firstCol) {
        this.clearSelection();
        if (selection) {
            this.selectionManager = this.selection = 
                selection.getDependentCellSelection(this.fields.length);
            this.selectionManager._updateDependency(firstCol);
            this.observe(this.selectionManager, "selectionChanged", function () {
                this._cellSelectionChanged(this.selectionManager.changedCells);
            });
        }
    },

    // When refreshing cellStyle, notify our edit items that the underlying cell style changed
    // so they can update if necessary
    _updateCellStyle : function (record, rowNum, colNum, cell, className, a,b,c) {
        this.invokeSuper(isc.GridBody, "_updateCellStyle", record, rowNum,colNum,cell,className,a,b,c);
        var lg = this.grid;
        if (lg && lg.getEditRow() == rowNum) {
            var fieldName = lg.getFieldName(lg.getFieldNumFromLocal(colNum, this)),
                form = lg.getEditForm(),
                item = form ? form.getItem(fieldName) : null;
            if (item && item.gridCellStyleChanged) {
                if (className == null) className = this.getCellStyle(record,rowNum,colNum);
                item.gridCellStyleChanged(record, rowNum, colNum, className);
            }
        }

    },

    // hovers: override getHoverTarget to return a pointer to our grid - this allows
    // the developer to call 'updateHover' directly on the grid.
    getHoverTarget : function () {
        return this.grid;
    },

    // direct keyPresses to the ListGrid as a whole to implement arrow navigation,
    // selection, etc
    
    keyPress : function (event, eventInfo) {
        return this.grid.bodyKeyPress(event, eventInfo);
    },

    // getters for the current keyboard focus row for key-events.
    
    getFocusRow : function () {
        return this.grid.getFocusRow();
    },
    getFocusCol : function () {
        var colNum = this.grid._getKeyboardClickNum();
        return this.grid.getLocalFieldNum(colNum);
    },

    
    _restoreFocusForClickMaskHide : function () {
        this._suppressKeyboardNavHiliting = true;
        this.focus();
        delete this._suppressKeyboardNavHiliting;
    },

    // Override _focusChanged to implement 'editOnFocus' - start editing the first
    // editable cell if appropriate.
    // See comments in 'editOnFocus' jsdoc comment for details of how this should work.
    _focusChanged : function (hasFocus) {
        // use the Super implementation to set up this.hasFocus BEFORE we further
        // manipulate focus due to editing.
        var returnVal = this.Super("_focusChanged", arguments);

        var lastEvent = isc.EH.lastEvent;

        // if we're acquiring focus because we're in the middle of a click sequence on the body,
        // the mouse handlers will correctly start editing or place focus on whatever row was hit, and we
        // should do nothing
        if (lastEvent.target == this &&
              (lastEvent.eventType == isc.EH.MOUSE_DOWN ||
               lastEvent.eventType == isc.EH.MOUSE_UP ||
               lastEvent.eventType == isc.EH.CLICK ||
               lastEvent.eventType == isc.EH.DOUBLE_CLICK)) 
        {
            // We still need to kill the suppressEditOnFocus flag, otherwise a modal-editing
            // grid with edit-on-focus enabled will get stuck with the flag if the user clicks
            // over the empty area
            if (this.grid._suppressEditOnFocus) {
                delete this.grid._suppressEditOnFocus;
            }            
            return returnVal;
        }

        // otherwise, entering focus due to a key event (tab, shift-tab) or something else (programmatic
        // including re-focus due to clickMask blur).
        var editCell,
            parent = this.grid;
        if (hasFocus && parent.canEdit != false) {
            // editOnFocus enabled, but not currently editing
            if (parent.editOnFocus && parent.canEdit != false &&
                parent.getEditRow() == null)
            {
                if (this.logIsInfoEnabled("gridEdit")) {
                    this.logInfo("Editing on focus: eventType: " + lastEvent.eventType +
                                 ", lastTarget " + lastEvent.target, "gridEdit");
                }

                // If we're explicitly suppressing edit on focus, don't start editing.
                if (parent._suppressEditOnFocus) {
                    delete parent._suppressEditOnFocus;
                } else {
                    // this'll run through every cell in every record until it finds one that's
                    // editable
                    var editCell = parent.getFocusCell();

                    
                    var editCellValid = isc.isAn.Array(editCell) && editCell[0] != null &&
                            editCell[0] >= 0 && editCell[1] != null && editCell[1] >= 0;
                    // If we can't edit the default focus/keyboard cell, check whether the
                    // row itself is editable - we don't want to jump to the first row if we
                    // can help it
                    if (editCellValid && !parent.canEditCell(editCell[0], editCell[1])) {
                        editCell = parent.findNextEditCell(editCell[0], editCell[1],
                                     true, true, // direction, stepThroughFields
                                     false, false, true, // checkStartingCell, checkPastListEnd, dontCheckPastRowEnd,
                                     false); // ignoreFocus
                        // If there are no editable cells in this row - just find the first editable cell
                        // in the grid
                        if (editCell == null) editCellValid = false;
                    }
                    if (!editCellValid) {
                        editCell = parent.findNextEditCell(0,0,true,true);
                    }

                    if (editCell != null) {
                        parent.handleEditCellEvent(editCell[0], editCell[1], isc.ListGrid.FOCUS);
                    }
                }
            }
        }

        // In screenReader mode, if focus is moving into the grid but we're not going into editing mode,
        // put focus onto the row element rather than onto the GR body.
        
        var hiliteOnFocus = parent.hiliteRowOnFocus;
        if (hiliteOnFocus == null) hiliteOnFocus = parent.showRollOver;
        if (isc.screenReader) {
            if (hasFocus) {
                if (editCell == null) {
                    // find the last hilited row if there is one
                    var rowNum = this.getNativeFocusRow();

                    //this.logWarn("focus entering body - focusing in native row: " + rowNum +
                    //             ", focus row was: " + parent.getFocusRow());
                    this._putNativeFocusInRow(rowNum, this.getNativeFocusColumn());
                }
            } else {
                parent.clearLastHilite();
            }
        // Even if we don't have screenReader mode enabled, hilite the current keyboard
        // target row on focus (but don't trigger a click or select it).
        // Also call clearLastHilite() on blur, so we don't show orphaned "over"
        // styling when the user takes focus from the grid
        } else if (hiliteOnFocus) {
            if (hasFocus) {
                // keyboard nav hiliting will be suppressed for focus due to hideClickMask()
                if (editCell == null && !this._suppressKeyboardNavHiliting) {
                    if (parent.canSelectCells) {
                        parent._navigateToNextCell(0, 1, true, true, "focus");
                    } else {
                        parent._navigateToNextRecord(1, true, "focus", true);
                    }
                }
            } else {
                // If the user mouseDowned on an embedded widget, such as a rollOverCanvas,
                // don't clear the hilight or we'll lose the roll-over canvas altogether.
                var mouseDownTarget = isc.EH.mouseDownTarget(),
                    eventType = isc.EH.lastEvent.eventType;
                if (eventType != isc.EH.MOUSE_DOWN || !this.contains(mouseDownTarget)) {
                    parent.clearLastHilite();
                }
            }

        }
        return returnVal;
    },

    // override putNativeFocusInRow to ensure we hilight the focus row
    _putNativeFocusInRow : function (rowNum, colNum, suppressFocus) {
        var parent = this.grid;
        if (parent) {
            var gridColNum = colNum == null ? null : parent.getFieldNumFromLocal(colNum, this);


            // if suppressFocus is passed, we're not actually focusing into the row so don't
            // hilite the row.
            if (parent.hiliteOnNativeRowFocus && !suppressFocus) {
                parent._hiliteRecord(rowNum, gridColNum);
            }
            // Let the grid know which body last had native cell focus applied to
            // it.
            if (!suppressFocus) {
                parent._lastNativeFocusBody = this;
                parent.keyboardClickField = gridColNum;
            }
        }

        return this.Super("_putNativeFocusInRow", arguments);
    },

    // override updateRowSelection to update selectionCanvas if necessary
    updateRowSelection : function (rowNum) {

        var lg = this.grid;
        if (!lg) return;

        

        if (lg.showSelectionCanvas || lg.showSelectionUnderCanvas) {
            lg.updateSelectionCanvas();
        }
            
        if (lg.showSelectedRollOverCanvas || lg.showSelectedRollUnderCanvas) {
            lg.updateRollOverCanvas(this.lastOverRow, this.lastOverCol);
        }
        if (lg._dontRefreshSelection) {
            return;
        }
        this.invokeSuper(isc.GridBody, "updateRowSelection", rowNum);

        if (isc.Canvas.ariaEnabled() && lg.selectionManager) {
            this.setRowAriaState(rowNum, "selected", lg.selectionManager.
                                 isSelected(lg.getRecord(rowNum), rowNum, true));
        }
        
        var cellsToRefresh = lg.getCellsToRefreshOnSelectionChange(rowNum);
        if (cellsToRefresh && cellsToRefresh.length > 0) {
            for (var i = 0; i < cellsToRefresh.length; i++) {
                lg.refreshCell(cellsToRefresh[i][0], cellsToRefresh[i][1]);
            }
        }
        // with selectionAppearance:"checkbox", also update checkbox in header
        if (lg.getCurrentCheckboxField() != null) {
            lg.updateCheckboxHeaderState();
        }
    },

    getCellStyle : function (record, rowNum, colNum) {
        var style = this.Super("getCellStyle", arguments);

        // skip potential additional styling for group and summary rows
        if (style.startsWith("groupNode") || style.startsWith("gridSummaryCell")) return style;

        if (this.grid.styledRowEnds) {
            // if styledRowEnds is true, append the first/lastCellStyle to the normal style
            if (colNum == 0) {
                style += " " + this.grid.firstCellStyle;
            } else if (colNum == this.grid.fields.length-1) {
                style += " " + this.grid.lastCellStyle;
            }
        }
        return style;
    },


    // Fired when selecting a list of entries (for every row)
    // Default implementation marks for redraw
    // Also set up to update SelectionCanvas when the thread completes.
    
    markForRowSelectionRefresh : function () {
        var lg = this.grid;
        if (!lg) return;
        if (lg.showSelectionCanvas || lg.showSelectionUnderCanvas) {
            lg.fireOnPause("updateSelectionCanvasFromRowRefresh", "updateSelectionCanvas");
        }
        if (lg.getCurrentCheckboxField() != null) {
            lg.fireOnPause("updateCheckboxHeaderFromRowRefresh", "updateCheckboxHeaderState");
        }
        if (lg.showSelectedRollOverCanvas || lg.showSelectedRollUnderCanvas) {
            lg.fireOnPause("updateSelectionRollOverCanvasFromRowRefresh",
                        {target:lg, methodName:"updateRollOverCanvas",
                         args:[this.lastOverRow, this.lastOverCol]});
        }

        if (lg._dontRefreshSelection) {
            return;
        }
        // This will mark the body for redraw (refreshing the actual styling / checkboxes)
        this.invokeSuper(isc.GridBody, "markForRowSelectionRefresh");
    },

    // ditto with _cellSelectionChanged
    _cellSelectionChanged : function (cellList,b,c,d) {
        var lg = this.grid;
        if (lg != null &&
            (lg.showSelectionCanvas || lg.showSelectionUnderCanvas))
        {
            lg.updateSelectionCanvas();
        }
        return this.invokeSuper(isc.GridBody, "_cellSelectionChanged", cellList, b,c,d);
    },

    // remove any dynamic references that point to us if we're being destroyed
    destroy : function () {
        var grid = this.grid;
        if (this == grid._lastSelectedBody)       grid._lastSelectedBody       = null;
        if (this == grid._lastKeyboardHiliteBody) grid._lastKeyboardHiliteBody = null;
        this.Super("destroy", arguments);
    },

    // Embedded components
    // -----------------------

    // animateShow selectionCanvas / rollOverCanvas if appropriate
    shouldAnimateEmbeddedComponent : function (component) {
        var grid = this.grid;
        if (component == grid.selectionCanvas) return grid.animateSelection;
        if (component == grid.selectionUnderCanvas) return grid.animateSelectionUnder;
        if (component == grid.rollOverCanvas) return grid.animateRollOver;
        if (component == grid.rollUnderCanvas) return grid.animateRollUnder;

        return false;
    },


    _handleEmbeddedComponentResize : function (component, deltaX, deltaY) {
        this.Super("_handleEmbeddedComponentResize", arguments);

        // Notify the grid - allows us to update the other body if we're showing
        // both a frozen and an unfrozen body
        this.grid._handleEmbeddedComponentResize(this, component, deltaX, deltaY);
    },

    // Override draw() to scroll to the appropriate cell if 'scrollCellIntoView' was called
    // before the body was drawn/created
    // Also update the edit form item rows if we're already editing.
    draw : function (a,b,c,d) {
        var lg = this.grid;
        if (lg.getEditRow() != null) {
            
            var rowNum = lg.getEditRow(),
                record = lg.getRecord(rowNum),
                fieldNum = lg.getEditCol(),
                form = lg._editRowForm,
                items = lg.getEditRowItems(record, rowNum, fieldNum, lg.editByCell),
                liveItems = form.getItems();

            var setItems = liveItems == null || items.length != liveItems.length;
            if (!setItems) {
                var liveItemNames = liveItems.getProperty("name");
                for (var i = 0; i < items.length; i++) {
                    if (!liveItemNames.contains(items[i].name)) {
                        setItems = true;
                        break;
                    }
                }
            }
            if (setItems) {
                this.logDebug("calling setItems on form from body draw","gridEdit");
                form.setItems(items);
            } else {
                this.logDebug("Skipping setItems() on form from body draw", "gridEdit");
            }

            
            form._setValuesPending = true;

        }

        
        delete this._drawnEditItems;

        
        if (lg._editorShowing && lg._currentEditCells == null) {
            lg._cacheCurrentEditCells();
        }
        this.invokeSuper(isc.GridBody, "draw", a,b,c,d);

        // If we are showing any edit form items, notify them that they have been written
        // into the DOM.
        
        if (lg._editRowForm) {
            lg._editItemsDrawingNotification(null, null, this);
        }
        // Tell the form to update its values (setItemValues())
        // (do this after the items have been notified that they're drawn to ensure items'
        // element values are set)
        lg.updateEditRow(lg.getEditRow());

        if (lg._scrollCell != null) lg._delayedScrollToCell();

        // Call 'updateRecordComponents()' on initial draw to set up recordComponents
        // If this is a ResultSet rather than an array, the updateRecordComponents method
        // will be able to skip all records and we'll render out the components on redraw.
        this.grid.updateRecordComponents();

        if (!this._updatingExpansionComponents) this.grid.updateExpansionComponents();

        
        if (isc.screenReader) {
            this._putNativeFocusInRow(this.getNativeFocusRow(), this.getNativeFocusColumn(), true);
        }

        // Update ruleContext with current selection status which could be set prior to drawing
        this.grid._updateRuleScope();
    },

    // rerun ListGrid-level layout if the body's scrolling state changes, to allow sizing
    // the header appropriately
    layoutChildren : function (reason,a,b,c) {
        this.invokeSuper(isc.GridBody, "layoutChildren", reason,a,b,c);
        // This method may be called with "scrolling state change" when a bodyLayout is
        // currently undrawn but drawing out its children - we've seen this in FF 3
        // In this case bail now since if _updateFieldWidths() is fired on an undrawn body it
        // bails, leaving the body mis sized
        
        if (!this.isDrawn() || (this.grid.frozenFields && !this.grid.bodyLayout.isDrawn())) {
            return;
        }
        var isScrollStateChanged = isc.startsWith(reason, "scrolling state changed"),
            isNewScrollbars      = isc.startsWith(reason, "introducing scrolling");
        if (isScrollStateChanged || isNewScrollbars) {
            
            if (this.isRTL() && !this._animatedShowStartRow) {
                this._placeEmbeddedComponents();
            }

            
            if (this._rowHeightAnimation == null) {
                this.grid.layoutChildren("body scroll changed");
                delete this._scrollbarChangeDuringAnimation;
            } else {
                this._scrollbarChangeDuringAnimation = true;
            }
        }
    },

    // Override rowAnimationComplete to call layoutChildren on the ListGrid if
    // scrollbars were introduced or cleared during animation.
    _rowAnimationComplete : function () {
        this.Super("_rowAnimationComplete", arguments);
        if (this._scrollbarChangeDuringAnimation) {
            this.grid.layoutChildren("body scroll changed during animation");
            delete this._scrollbarChangeDuringAnimation;
        }
    },


    // Override moved to notify any edit form items that they have moved.
    handleMoved : function (a,b,c,d) {
        this.invokeSuper(isc.GridBody, "handleMoved", a,b,c,d);
        this._notifyEditItemsOnMoved();
    },

    handleParentMoved : function (a,b,c,d) {
        this.invokeSuper(isc.GridBody, "handleParentMoved", a,b,c,d);
        this._notifyEditItemsOnMoved();
    },
    _notifyEditItemsOnMoved : function () {
        
        var lg = this.grid;
        if (lg._editorShowing) {
            var form = lg._editRowForm,
                allItems = form.getItems(),
                items = [];
            for (var i = 0; i < allItems.length; i++) {
                if (allItems[i].isDrawn()) items.add(allItems[i]);
            }
            form.itemsMoved(items);
        }
    },

    // Override show() / hide() / parentVisibilityChanged() / clear() to notify the Edit
    // form items that they have been shown / hidden.
    setVisibility : function (newVisibility,b,c,d) {
        this.invokeSuper(isc.GridBody, "setVisibility", newVisibility,b,c,d);
        var lg = this.grid;
        if (lg._editorShowing) lg._editRowForm.itemsVisibilityChanged();
        if (lg.fieldPickerWindow && newVisibility == "hidden") lg.fieldPickerWindow.hide();
    },

    parentVisibilityChanged : function (newVisibility,b,c,d) {
        this.invokeSuper(isc.GridBody, "parentVisibilityChanged", newVisibility,b,c,d);
        var lg = this.grid;
        if (lg._editorShowing) lg._editRowForm.itemsVisibilityChanged();
    },

    clear : function () {
        var lg = this.grid;
        lg._clearingInactiveEditorHTML();
        // Fire 'clearing' notifications on any drawn items. 
        var editForm = lg.getEditForm();
        if (editForm != null) {
            var items = editForm.getItems();
            for (var i = 0; i < items.length; i++) {
                if (items[i] && items[i].isDrawn()) {
                    items[i].clearing(false);
                }
            }
        }

        
        delete this._drawnEditItems;
        this.Super("clear", arguments);
        if (lg._editorShowing) {
            // If we're showing the editRow form, notify the items that they have
            // been removed from the DOM.
            lg._editItemsDrawingNotification(null, null, this);

            // Separate mechanism to notify the form that items are no longer visible.
            
            lg._editRowForm.itemsVisibilityChanged();
        }
    },

    // also notify the edit form items of z index change
    zIndexChanged : function () {
        this.Super("zIndexChanged", arguments);
        var lg = this.grid;
        // Note: setZIndex can be called at init time to convert "auto" to a numeric
        // zIndex - we therefore can't assume that we've been added to the ListGrid as
        // a child yet.
        if (lg && lg._editorShowing) lg._editRowForm.itemsZIndexChanged();

    },
    parentZIndexChanged : function (a,b,c,d) {
        this.invokeSuper(isc.GridBody, "zIndexChanged", a,b,c,d);
        var lg = this.grid;
        if (lg._editorShowing) lg._editRowForm.itemsZIndexChanged();
    },

    // Implement 'redrawFormItem()' - if one of the edit form items asks to redraw
    // we can simply refresh the cell rather than having the entire body redraw
    redrawFormItem : function (item, reason) {
        var lg = this.grid;
        if (lg && (item.form == lg._editRowForm) &&
            !(lg._deferBodyRedrawIfDirty && this.isDirty()))
        {
            // determine which cell
            var row = lg.getEditRow(), col = lg.getColNum(item.getFieldName());

            // If the user has edited the cell, or setValue() has been called on the item
            // we don't want a call to redraw() on the item to drop that value
            if (lg.getEditCol() == col) {
                lg.storeUpdatedEditorValue();
            }

            if (row >= 0 && col >= 0) lg.refreshCell(row, col, false, true);

        } else {
            return this.markForRedraw("Form Item Redraw " +
                                      (reason ? reason : isc.emptyString));
        }
    },

    
    sizeFormItem : function (item) {
        var lg = this.grid;
        var width = item.width,
            finalWidth;

        if (isc.isA.String(width)) {
            var fieldWidths = lg.getEditFormItemFieldWidths(item.record),
                fieldWidth = fieldWidths[lg.getFieldNum(item.getFieldName())];
             if (width == "*") {
                finalWidth = fieldWidth;
             } else if (width.charAt(width.length - 1) == "%") {
                var percentWidth = parseInt(width);
                if (isc.isA.Number(percentWidth)) {
                    finalWidth = Math.floor(fieldWidth * (percentWidth / 100));
                }
            }
        }

        var height = item.height,
            finalHeight;
        if (isc.isA.String(height)) {
            var cellHeight = lg.cellHeight;
            if (width == "*") {
                finalHeight = cellHeight;
            } else if (height.charAt(height.length - 1) == "%") {
               var percentHeight = parseInt(height);
               if (isc.isA.Number(percentHeight)) {
                   finalHeight = Math.floor(cellHeight * (percentHeight / 100));
               }
            }
        }
        // Hang the calculated values on the _size attribute as we do when running
        // normal stretch-resize policy in form items.
        
        if (finalHeight != null || finalWidth != null) {
            item._size = [finalWidth == null ? item.width : finalWidth,
                          finalHeight == null ? item.height : finalHeight];
        }

    },
   
    // Cell Styling: modify the 'alternate' column offset to account for
    // frozen columns if necessary
    getAlternateColumnOffset : function (record, rowNum, colNum) {
        var grid = this.grid;
        if (grid != null && (this == grid.body) && grid.frozenFields != null) {
            return grid.frozenFields.length;
        }
        return 0;
    },

    //>Animation
    // Override startRowAnimation - if doing a delayed redraw to kick off a row animation
    // to close an open folder, we need to temporarily open the folder again to get the
    // appropriate HTML for the animation rows.
    startRowAnimation : function (show, startRow, endRow, callback, speed, duration,
                                  effect, slideIn, delayed)
    {
        this.finishRowAnimation();

        var shouldOpenFolder = (delayed && (this._openFolder != null)),
            tg = this.grid;

        if (shouldOpenFolder) {
            var wasSuppressed = tg._suppressFolderToggleRedraw;
            tg._suppressFolderToggleRedraw = true;
            tg.data.openFolder(this._openFolder);
            tg._suppressFolderToggleRedraw = wasSuppressed;
        }
        this.Super("startRowAnimation", arguments);
        if (shouldOpenFolder) {
            var wasSuppressed = tg._suppressFolderToggleRedraw;
            tg._suppressFolderToggleRedraw = true;
            tg.data.closeFolder(this._openFolder);
            tg._suppressFolderToggleRedraw = wasSuppressed;
        }
        delete this._openFolder;
    }
    //<Animation
});


isc.ListGrid.addClassProperties({
    

    //> @type SortArrow
    //          Do we display an arrow for the sorted field ?
    //          @group  sorting, appearance
    //  @value  "none"   Don't show a sort arrow at all.
    //  @value  "corner" Display sort arrow in the upper-right corner (above the scrollbar) only.
    CORNER:"corner",
    //  @value  "field"  Display sort arrow above each field header only.
    FIELD:"field",
    //  @value  "both"   Display sort arrow above each field header AND in corner above scrollbar.
    //BOTH:"both", // NOTE: Canvas establishes this constant
    // @visibility external
    //<
    // NOTE: Canvas established the constant NONE ( == "none")

    //> @type ReorderPosition
    //  Controls where a drag-item should be dropped in relation to the target row
    // @value  isc.ListGrid.BEFORE  Drop the drag-item before the target-row
    // @value  isc.ListGrid.AFTER   Drop the drag-item after the target-row
    // @value  isc.ListGrid.OVER    Drop the drag-item over (onto) the target-row
    // @visibility external
    // @group dragdrop
    //<

    //> @classAttr ListGrid.BEFORE (Constant : "before" : [R])
    // A declared value of the enum types 
    // +link{type:RecordDropPosition,RecordDropPosition} and
    // +link{type:ReorderPosition,ReorderPosition}.
    // @visibility external
    // @constant
    //<
    BEFORE:"before",

    //> @classAttr ListGrid.AFTER (Constant : "after" : [R])
    // A declared value of the enum types 
    // +link{type:RecordDropPosition,RecordDropPosition} and
    // +link{type:ReorderPosition,ReorderPosition}.
    // @visibility external
    // @constant
    //<
    AFTER:"after",

    //> @classAttr ListGrid.OVER (Constant : "over" : [R])
    // A declared value of the enum types 
    // +link{type:RecordDropPosition,RecordDropPosition},
    // +link{type:ReorderPosition,ReorderPosition} and
    // +link{type:RecordDropAppearance,RecordDropAppearance}.
    // @visibility external
    // @constant
    //<
    OVER:"over",

    //> @type RecordDropAppearance
    // Controls how ListGrid record drop events report their
    // +link{listGrid.getRecordDropPosition(),dropPosition}, and where the drop indicator will be displayed
    // if appropriate.
    //
    // @value isc.ListGrid.OVER When the user drops onto a record, dropPosition will always be "over"
    // @value isc.ListGrid.BETWEEN When the user drops onto a record, dropPosition will be either
    //   "before" or "after" depending on whether the mouse was over the top or bottom of
    //   the target record
    // @value isc.ListGrid.BOTH When the user drops onto a record, if the drop occurs centered over the
    //   record, the dropPosition will be reported as "over", otherwise it will be
    //   "before" or "after" depending on whether the mouse was over the top or bottom of the
    //   target record.
    // @value isc.ListGrid.BODY No dropPosition will be reported
    //
    // @visibility external
    //<

    //> @classAttr ListGrid.BETWEEN (Constant : "between" : [R])
    // A declared value of the enum type  
    // +link{type:RecordDropAppearance,RecordDropAppearance}.
    // @visibility external
    // @constant
    //<
    BETWEEN: "between",

    //> @classAttr ListGrid.BOTH (Constant : "both" : [R])
    // A declared value of the enum type  
    // +link{type:RecordDropAppearance,RecordDropAppearance}.
    // @visibility external
    // @constant
    //<
    //BOTH:"both", // NOTE: Canvas establishes this constant

    //> @classAttr ListGrid.BODY (Constant : "body" : [R])
    // A declared value of the enum type  
    // +link{type:RecordDropAppearance,RecordDropAppearance}.
    // @visibility external
    // @constant
    //<
    BODY:"body",

    //> @type RecordDropPosition
    // Position of a +link{listGrid.recordDrop} operation with respect to the target record.
    // @value isc.ListGrid.OVER User dropped directly onto the record
    // @value isc.ListGrid.BEFORE User dropped before the record
    // @value isc.ListGrid.AFTER User dropped after the record
    // @value isc.ListGrid.NONE Drop position is not over a record
    //
    // @visibility external
    //<

    //> @classAttr ListGrid.NONE (Constant : "none" : [R])
    // A declared value of the enum type  
    // +link{type:RecordDropPosition,RecordDropPosition}.
    // @visibility external
    // @constant
    //<
    //NONE:"none", // NOTE: Canvas establishes this constant

    //> @type RowEndEditAction
    //  While editing a ListGrid, what cell should we edit when the user attempts to navigate
    //  into a cell past the end of an editable row, via a Tab keypress, or a programmatic
    //  saveAndEditNextCell() call?
    //
    // @value   "same"   navigate to the first editable cell in the same record
    // @value   "next"   navigate to the first editable cell in the next record
    // @value   "done"   complete the edit.
    // @value   "stop"   Leave focus in the cell being edited (take no action)
    // @value   "none"   take no action
    //
    // @visibility external
    // @group editing
    // @see ListGrid.rowEndEditAction
    //
    //<

    //> @type EnterKeyEditAction
    // What to do when a user hits enter while editing a cell
    // @value "done" end editing (will save edit values if +link{listGrid.autoSaveEdits}
    //  is true).
    // @value "nextCell" edit the next editable cell in the record
    // @value "nextRow" edit the same field in the next editable record
    // @value "nextRowStart" edit the first editable cell in next editable record
    //
    // @group editing
    // @visibility external
    //<

    //> @type EscapeKeyEditAction
    // What to do if the user hits escape while editing a cell.
    // @value "cancel" cancels the current edit and discards edit values
    // @value "done" end editing (will save edit values if +link{listGrid.autoSaveEdits}
    //  is true).
    // @value "exit" exit the editor (edit values will be left intact but not saved).
    // @value "ignore" do nothing special when the Escape key is pressed (ie, just ignore it)
    //
    // @group editing
    // @visibility external
    //<
    
    //> @type ArrowKeyEditAction
    // What to do if the user hits Up or Down arrow key while editing a cell.
    // @value "none" The grid will take no special action when the user presses up or down
    //   arrow keys within an editor
    // @value "editNext" The grid will intercept up and down arrow keypresses and navigate
    //   to the next or previous edit row by generating an appropriate +link{EditCompletionEvent}
    //
    // @group editing
    // @visibility external
    //<
    
    
    //> @type EditCompletionEvent
    //          What event / user interaction type caused cell editing to complete.
    //          @visibility external
    //          @group  editing
    //
    //          @value  isc.ListGrid.CLICK_OUTSIDE  User clicked outside editor during edit.
    //          @value  isc.ListGrid.CLICK  User started editing another row by clicking on it
    //          @value  isc.ListGrid.DOUBLE_CLICK  User started editing another row by double
    //                               clicking
    //          @value  isc.ListGrid.ENTER_KEYPRESS Enter pressed.
    //          @value  isc.ListGrid.ESCAPE_KEYPRESS    User pressed Escape.
    //          @value  isc.ListGrid.UP_ARROW_KEYPRESS  Up arrow key pressed.
    //          @value  isc.ListGrid.DOWN_ARROW_KEYPRESS    down arrow key.
    //          @value  isc.ListGrid.TAB_KEYPRESS   User pressed Tab.
    //          @value  isc.ListGrid.SHIFT_TAB_KEYPRESS   User pressed Shift+Tab.
    //          @value  isc.ListGrid.EDIT_FIELD_CHANGE      Edit moved to a different field (same row)
    //          @value  isc.ListGrid.PROGRAMMATIC   Edit completed via explicit function call
    // @visibility external
    //<

    //> @classAttr ListGrid.CLICK_OUTSIDE (Constant : "click_outside" : [R])
    // A declared value of the enum type  
    // +link{type:EditCompletionEvent,EditCompletionEvent}.
    // @visibility external
    // @constant
    //<
    CLICK_OUTSIDE:"click_outside",

    //> @classAttr ListGrid.CLICK (Constant : "click" : [R])
    // A declared value of the enum type  
    // +link{type:EditCompletionEvent,EditCompletionEvent}.
    // @visibility external
    // @constant
    //<
    CLICK:"click",

    //> @classAttr ListGrid.DOUBLE_CLICK (Constant : "doubleClick" : [R])
    // A declared value of the enum type  
    // +link{type:EditCompletionEvent,EditCompletionEvent}.
    // @visibility external
    // @constant
    //<
    DOUBLE_CLICK:"doubleClick",

    //> @classAttr ListGrid.ENTER_KEYPRESS (Constant : "enter" : [R])
    // A declared value of the enum type  
    // +link{type:EditCompletionEvent,EditCompletionEvent}.
    // @visibility external
    // @constant
    //<
    ENTER_KEYPRESS:"enter",

    //> @classAttr ListGrid.ESCAPE_KEYPRESS (Constant : "escape" : [R])
    // A declared value of the enum type  
    // +link{type:EditCompletionEvent,EditCompletionEvent}.
    // @visibility external
    // @constant
    //<
    ESCAPE_KEYPRESS:"escape",

    //> @classAttr ListGrid.UP_ARROW_KEYPRESS (Constant : "arrow_up" : [R])
    // A declared value of the enum type  
    // +link{type:EditCompletionEvent,EditCompletionEvent}.
    // @visibility external
    // @constant
    //<
    UP_ARROW_KEYPRESS:"arrow_up",

    //> @classAttr ListGrid.DOWN_ARROW_KEYPRESS (Constant : "arrow_down" : [R])
    // A declared value of the enum type  
    // +link{type:EditCompletionEvent,EditCompletionEvent}.
    // @visibility external
    // @constant
    //<
    DOWN_ARROW_KEYPRESS:"arrow_down",

    // left/right only used in conjunction with moveEditorOnArrow
    LEFT_ARROW_KEYPRESS:"arrow_left",
    RIGHT_ARROW_KEYPRESS:"arrow_right",

    //> @classAttr ListGrid.TAB_KEYPRESS (Constant : "tab" : [R])
    // A declared value of the enum type  
    // +link{type:EditCompletionEvent,EditCompletionEvent}.
    // @visibility external
    // @constant
    //<
    TAB_KEYPRESS:"tab",

    //> @classAttr ListGrid.SHIFT_TAB_KEYPRESS (Constant : "shift_tab" : [R])
    // A declared value of the enum type  
    // +link{type:EditCompletionEvent,EditCompletionEvent}.
    // @visibility external
    // @constant
    //<
    SHIFT_TAB_KEYPRESS:"shift_tab",

    //> @classAttr ListGrid.EDIT_FIELD_CHANGE (Constant : "field_change" : [R])
    // A declared value of the enum type  
    // +link{type:EditCompletionEvent,EditCompletionEvent}.
    // @visibility external
    // @constant
    //<
    EDIT_FIELD_CHANGE:"field_change",
    EDIT_ROW_CHANGE:"row_change",

    //> @classAttr ListGrid.PROGRAMMATIC (Constant : "programmatic" : [R])
    // A declared value of the enum type  
    // +link{type:EditCompletionEvent,EditCompletionEvent}.
    // @visibility external
    // @constant
    //<
    PROGRAMMATIC:"programmatic",

    // Focus is not a valid edit completion event - focusing in the grid can start an edit
    // if editOnFocus is true but this should not kill an existing edit.
    FOCUS:"focus",


    //> @classAttr ListGrid.GROUP_BY (Constant : "groupBy" : [R])
    // A declared value of the enum type 
    // +link{type:GroupTreeChangeType}
    // @visibility external
    // @constant
    //<
    GROUP_BY:"groupBy",

    //> @classAttr ListGrid.REGROUP (Constant : "regroup" : [R])
    // A declared value of the enum type 
    // +link{type:GroupTreeChangeType}
    // @visibility external
    // @constant
    //<
    REGROUP:"regroup",

    //> @classAttr ListGrid.INCREMENTAL (Constant : "incremental" : [R])
    // A declared value of the enum type 
    // +link{type:GroupTreeChangeType}
    // @visibility external
    // @constant
    //<
    INCREMENTAL:"incremental",


    // GridRenderer passthrough
    // --------------------------------------------------------------------------------------------

    // the following properties, when set on the ListGrid, are applied to the GridBody
    _gridPassthroughProperties : [
        // pass it a selection object (this enables selection behaviors)
        "selection",
        "selectionType",
        "canSelectCells",
        "canDragSelect",
        "selectionManager",
        "canSelectOnRightMouse",
        "recordCanSelectProperty",
        "useNativeTouchScrolling",

        "screenReaderNavigateByCell",

        // D&D
        "canDrag",
        "canAcceptDrop",
        "canDrop",

        // table geometry
        "autoFit",
        "wrapCells",
        "preserveWhitespace",
        "cellSpacing",
        "cellPadding",
        "cellHeight",
        "enforceVClipping",
        // autoFitData behavior implemented on GridBody class, not GR class
        "autoFitData",
        "autoFitMaxRecords",
        "autoFitMaxWidth",
        "autoFitMaxColumns",
        "autoFitMaxHeight",
        "autoFitExtraRecords",

        "allowRowSpanning",

        // incremental rendering
        // "showAllRecords" -> showAllRows done elsewhere
        "showAllColumns",
        "drawAllMaxCells",
        "drawAheadRatio",
        "quickDrawAheadRatio",
        "instantScrollTrackRedraw",
        "scrollRedrawDelay",
        "dragScrollRedrawDelay",
        "scrollWheelRedrawDelay",
        "touchScrollRedrawDelay",

        // printing
        "printMaxRows",

        //>Animation
        // If we're doing a speed rather than duration based row animation allow the cap to
        // be specified on the ListGrid / TreeGrid
        // (Note that this is documented in the TreeGrid class).
        "animateRowsMaxTime",
        //<Animation

        // documented by default setting
        "fastCellUpdates",

        // rollover
        "showRollOver",
        "useCellRollOvers",

        // hover
        "canHover",
        "showHover",
        "showHoverOnDisabledCells",
        "showClippedValuesOnHover",
        "hoverDelay",
        "hoverWidth",
        "hoverHeight",
        "hoverAlign",
        "hoverVAlign",
        "hoverStyle",
        "hoverOpacity",
        "hoverMoveWithMouse",
        "hoverAutoFitWidth",
        "hoverAutoFitMaxWidth",

        "hoverByCell",
        "keepHoverActive",
        "cellHoverOutset",

        // empty message
        "showEmptyMessage",
        "emptyMessageStyle",
        "emptyMessageTableStyle",

        // offline message
        "showOfflineMessage",
        "offlineMessageStyle",

        // special presentation of records
        "useCellRecords",
        "singleCellValueProperty",
        "isSeparatorProperty",

        // Focus things -- note no need to pass tabIndex through - layouts should auto-manage
        // their members' tab-orders correctly
        "accessKey",
        "canFocus",
        "_useNativeTabIndex",
        "tableStyle",
        "baseStyle",
        "recordCustomStyleProperty",
        "showSelectedStyle",
        "preserveFocusStylingOnMouseOut",
        
        // whether to use rowSpan-oriented cell styling behaviors
        "useRowSpanStyling",
        // selection mode when rowSpanning is active
        "rowSpanSelectionMode",

        "showFocusOutline"
    ],

    // the following methods, when called on the LV, will call the same-named method on the
    // GridRenderer (this.body).
    _lv2GridMethods : [
        // this makes it easier to override getCellStyle at the LV level, since you can call
        // these helpers as this.getCellStyleName()
        "getCellStyleName",
        "getCellStyleIndex",

        "_getShowClippedValuesOnHover",

        // setFastCellUpdates explicitly handled
        // in a method which keeps lg.fcu in sync with the
        // body property value
        //"setFastCellUpdates",

        // checking table geometry
        "getRowTop",
        "getRowPageTop",
        "getRowSize",
        "getDrawnRowHeight",

        // row span information
        "getCellStartRow",
        "getCellRowSpan",

        //> @method listGrid.getVisibleRows
        // @include gridRenderer.getVisibleRows()
        // @return (Array of Integer)
        // @visibility external
        //<
        "getVisibleRows",

        //> @method listGrid.getDrawnRows
        // @include gridRenderer.getDrawnRows()
        // @visibility external
        //<
        "getDrawnRows"
    ],

    // styling

    //> @method listGrid.getCellStyle()
    // @include gridRenderer.getCellStyle()
    // @see listGrid.getBaseStyle()
    //<

    // refresh
    //> @method listGrid.refreshCellStyle()
    //  @include    gridRenderer.refreshCellStyle()
    //<

    // events
    //> @method listGrid.cellOver()
    // @include gridRenderer.cellOver()
    //<
    //> @method listGrid.rowOver()
    // @include gridRenderer.rowOver()
    //<

    //> @method listGrid.cellOut()
    // @include gridRenderer.cellOut()
    //<
    //> @method listGrid.rowOut()
    // @include gridRenderer.rowOut()
    //<

    //> @method listGrid.cellHover()
    // @include gridRenderer.cellHover()
    //<
    //> @method listGrid.cellValueHover() ([A])
    // @include gridRenderer.cellValueHover()
    //<
    //> @method listGrid.rowHover()
    // @include gridRenderer.rowHover()
    //<
    //> @method listGrid.cellHoverHTML()
    // @include gridRenderer.cellHoverHTML()
    //<
    //> @method listGrid.cellValueHoverHTML()
    // @include gridRenderer.cellValueHoverHTML()
    //<

    //> @attr listGrid.showHoverOnDisabledCells (boolean : false : IRW)
    // @include gridRenderer.showHoverOnDisabledCells
    //<


    //> @method listGrid.cellContextClick()
    // @include gridRenderer.cellContextClick()
    // @example cellClicks
    //<
    //> @method listGrid.rowContextClick()
    // @include gridRenderer.rowContextClick()
    // @example recordClicks
    //<

    //> @method listGrid.cellMouseDown()
    // @include gridRenderer.cellMouseDown()
    //<
    //> @method listGrid.rowMouseDown()
    // @include gridRenderer.rowMouseDown()
    //<

    //> @method listGrid.cellMouseUp()
    // @include gridRenderer.cellMouseUp()
    //<
    //> @method listGrid.rowMouseUp()
    // @include gridRenderer.rowMouseUp()
    //<

    //> @method listGrid.cellClick()
    // Called when a cell receives a click event.
    // <P>
    // Note that returning false from this method will not prevent any
    // specified +link{listGrid.rowClick} handler from firing.
    //
    // @group   events
    // @param   record  (ListGridRecord)    Record object returned from getCellRecord()
    // @param   rowNum  (number)    row number for the cell
    // @param   colNum  (number)    column number of the cell
    // @return  (boolean)   whether to cancel the event
    // @visibility external
    // @example cellClicks
    //<

    //> @method listGrid.cellDoubleClick()
    // @include gridRenderer.cellDoubleClick()
    // @example cellClicks
    //<

    // Geometry
    //> @method listGrid.getRowTop()
    // @include gridRenderer.getRowTop()
    // @visibility external
    //<

    //> @method listGrid.getRowPageTop()
    // @include gridRenderer.getRowPageTop()
    // @visibility external
    //<

    // ListGrid / GridBody passthroughs
    // ---------------------------------------------------------------------------------------

    // the following methods, when called on the GridRenderer used as LV.body, call the same-named
    // method on the ListGrid instance itself
    _grid2LVMethods : [

        "getTotalRows",
        "isEmpty",
        "cellIsEnabled",
        "willAcceptDrop",

        // passed scroll change notification through
        "scrolled",

        // native element naming
        "getTableElementId",
        "getRowElementId",
        "getCellElementId",

        // shouldFixRowHeight - enables us to override the ListGrid level 'fixedRecordHeights'
        // for individual rows
        "shouldFixRowHeight",

        "getEmptyMessage",
        "getCanHover",
        // bubble stopHover on the GR up to stopHover here.
        "stopHover",

        "updateEmbeddedComponentZIndex"

        // NOTE: These methods pick up their parameters from the stringMethodRegistry on the
        // GridRenderer class. If expanding this list ensure that any methods that take parameters
        // are registered as stringMethods on that class
    ],

    // used by _invokeKeyboardCopyPasteShortcut for copy/paste between ListGrids
    _cellClipboard : null
});

isc.ListGrid.addClassMethods({
    makeBodyMethods : function (methodNames) {
        var funcTemplate = this._funcTemplate;
        if (funcTemplate == null) {
            funcTemplate = this._funcTemplate = [
                ,
                
                
                "this.grid._passthroughBody = this;" +
                "var returnVal = this.grid.",,"(",,");" +
                "this.grid._passthroughBody=null;" +
                "return returnVal;"];
        }

        var methods = {};

        for (var i = 0; i < methodNames.length; i++) {
            var methodName = methodNames[i],
                argString = isc.GridRenderer.getArgString(methodName),

                
                isCellIsEnabled = (methodName == "cellIsEnabled");

            funcTemplate[0] = "var methodName = '" + methodName + "';\n";
                
            if (isc.contains(argString, "colNum")) {
                // if there's a colNum argument, map it to the field index in the master
                funcTemplate[0] += "if (this.fields[colNum]) colNum = this.fields[colNum].masterIndex;"

            } else if (isc.isAn.emptyString(argString)) {
                // if there are no arguments, pass the body itself as a means of identifying
                // the calling body
                argString = "body";
                funcTemplate[0] += "body = this;";
            }
            if (isCellIsEnabled) {
                var checkRecord = "if (record === undefined) record = this.grid.getCellRecord(" + argString + ");";
                funcTemplate[0] += checkRecord;
            }

            // create a function that routes a function call to the target object
            funcTemplate[2] = methodName;
            funcTemplate[4] = (isCellIsEnabled ? "record," + argString : argString);
            var functionText = funcTemplate.join(isc.emptyString);

            //this.logWarn("for method: " + methodName + " with argString :"  + argString +
            //             " function text is: " + functionText);

            var method = methods[methodName] = isc._makeFunction(
                (isCellIsEnabled ? argString + ",record" : argString), functionText);
            method._isPassthroughMethod = true;
        }

        return methods;
    },
    

    classInit : function () {
        // create functions to have methods on the ListGrid's body call methods on the ListGrid
        // itself.  This is partly legacy support: the way to customize body rendering used to
        // be to install functions that controlled body rendering directly on the ListGrid
        // itself.

        // make certain grid methods appear on the LV for convenience, so you don't have to go
        // this.body.someGridMethod()
        

        this.addMethods(isc.ClassFactory.makePassthroughMethods(
            this._lv2GridMethods, "body"));

        // ----------------------------------------------------------------------------------------
        // create methods that can be installed on the body to call methods on the LV itself, for:
        var passthroughMethods = {};

        // - handlers (like cellOver) and overrides (like getCellCSSText) that we allow to be
        //   defined on the LV but are really grid APIs
        var gridAPIs = isc.getKeys(isc.GridRenderer._gridAPIs),
            passthroughMethods = isc.ListGrid.makeBodyMethods(gridAPIs);

        // - methods the grid needs to fulfill as the drag/drop target, which are really implemented
        //   on the LV
        isc.addProperties(passthroughMethods,
                          isc.ListGrid.makeBodyMethods(this._grid2LVMethods));

        this._passthroughMethods = passthroughMethods;

        

        // create methods on the ListGrid to act as Super implementations for per-instance
        // overrides of methods where we want to call the original GridRenderer implementation
        // as Super.
        var passBackMethods = {},
            funcTemplate = [
                ,
                // _passthroughBody is set up by the body function that called back up the
                // the grid method - if present, we use it to ensure we call the original
                // implementation on the correct body.
                "var _passthroughBody = this._passthroughBody || this.body;" +
                " if (_passthroughBody == null) {" +
                    "return;" +
                "}" +
                "if(_passthroughBody.__orig_",,")return _passthroughBody.__orig_",,"(",,")"],
            origPrefix  = "__orig_",
            gridProto = isc.GridRenderer.getPrototype();
        for (var i = 0; i < gridAPIs.length; i++) {
            var methodName = gridAPIs[i],
                argString = isc.GridRenderer.getArgString(methodName);
            if (isc.ListGrid.getInstanceProperty(methodName) == null) {

                if (isc.contains(argString, "colNum")) {
                    // if there's a colNum argument, map it to the field index in the body
                    
                    funcTemplate[0] = "if (colNum != null && colNum >= 0) colNum = this.getLocalFieldNum(colNum);"
                } else {
                    funcTemplate[0] = null;
                }
                funcTemplate[2] = funcTemplate[4] = methodName;
                funcTemplate[6] = argString

                passBackMethods[methodName] = isc._makeFunction(argString,
                    funcTemplate.join(isc.emptyString));
                // XXX this would also work, but imposes another Super call penalty, and is
                // odd (call to Super from outside of the object)
                //"return this.body.Super('" + methodName + "', arguments);");
            }
            
            gridProto[origPrefix + methodName] = gridProto[methodName];
        }
        this._passBackMethods = passBackMethods;
        this.addMethods(passBackMethods);

    },

    // retrieve possibly sorted list of coordinates from a coordinate record
    _getCoordinateList : function (coordinateRecord, sortByCoordinate) {
        var list = [];
        for (var coordinate in coordinateRecord) {
            if (coordinateRecord.hasOwnProperty(coordinate)){
                list.add(parseInt(coordinate));
            }
        }
        if (sortByCoordinate) {
            list.sort(function (a, b) { return a - b; });
        }
        return list;
    }
});

// add default properties to the class
isc.ListGrid.addProperties( {

    //> @attr listGrid.styleName (CSSStyleName : "listGrid" : IRW)
    // Default CSS class for the ListGrid as a whole.
    // @group appearance
    // @visibility external
    //<
    styleName:"listGrid",

    //> @attr listGrid.data (List of ListGridRecord : null : IRW)
    // A list of ListGridRecord objects, specifying the data to be used to populate the
    // ListGrid.  In ListGrids, the data array specifies rows.
    // <p>
    // When using a +link{DataSource}, rather than directly providing <code>data</code>, you will
    // typically call +link{fetchData()} instead, which will automatically establish
    // <code>data</code> as a +link{class:ResultSet,ResultSet} (see the +link{fetchData()} docs for details).
    // <p>
    // If you call <code>fetchData</code>, any previously supplied <code>data</code> is
    // discarded.  Also, it is not necessary to call <code>setData()</code> after calling
    // +link{ListGrid.fetchData()}.
    // <p>
    // When calling <code>setData()</code><smartgwt>,
    // if <code>data</code> is provided as a RecordList or ResultSet</smartgwt>, direct changes
    // to the list using Framework APIs such as <smartclient>+link{list.add()} or 
    // +link{list.remove()}</smartclient><smartgwt>+link{RecordList.add()} or 
    // +link{RecordList.remove()}</smartgwt> will be automatically <smartclient>observed</smartclient>
    // <smartgwt>detected</smartgwt> and the
    // ListGrid will redraw in response. However, direct changes to individual Records will not
    // be automatically <smartclient>observed</smartclient><smartgwt>detected</smartgwt>
    // and require calls to +link{refreshCell()} or 
    // +link{refreshRow()} to cause the ListGrid to visually update.  Calling methods such as
    // +link{ListGrid.updateData()}, +link{removeData()} or +link{addData()} always causes
    // automatic visual refresh.
    // <smartclient><p>
    // Note that direct manipulation of the data object without using the +link{List} APIs (for
    // example by directly assigning a new Record object to some index or calling non-Framework
    // APIs such as pop(), shift(), etc.) will not be reflected in the grid automatically, but 
    // developers can call +link{list.dataChanged()} directly to notify the grid of changes.
    // </smartclient>
    //
    // @group data
    // @see ListGridRecord
    // @setter setData()
    // @visibility external
    // @example inlineData
    // @example localData
    //<

    // useCellRecords - Is our data model going to be one record per cell or one record per row?
    useCellRecords:false,

    //> @object ListGridRecord
    // <smartclient>A ListGridRecord is a JavaScript Object whose properties contain values for each
    // +link{ListGridField}.</smartclient>
    // <smartgwt>ListGridRecord represents a JavaScript Object whose properties contain values 
    // for each +link{ListGridField}.</smartgwt> A ListGridRecord may have additional properties 
    // which affect the record's appearance or behavior, or which hold data for use by custom logic 
    // or other, related components.
    // <p>
    // <smartclient>
    // For example a ListGrid that defines the following fields:
    // <pre>
    // fields : [
    //     {name: "field1"},
    //     {name: "field2"}
    // ],
    // </pre>
    // </smartclient>
    // <smartgwt>
    // For example, if a ListGrid is getting its ListGridFields from the following DataSource definition:
    // <pre>
    // &lt;DataSource ... &gt;
    //      &lt;fields&gt;
    //          &lt;field name="field1" ... /&gt;
    //          &lt;field name="field2" ... /&gt;
    //      &lt;/fields&gt;
    // &lt;/DataSource&gt;
    // </pre>
    // </smartgwt>
    // <smartgwt>It might</smartgwt><smartclient>Might</smartclient> have the following data:
    // <P>
    // <pre>
    // data : [
    //     {field1: "foo", field2: "bar", customProperty:5},
    //     {field1: "field1 value", field2: "field2 value", enabled:false}
    // ]
    // </pre>
    // <smartclient>
    // Each line of code in the <code>data</code> array above creates one JavaScript Object via
    // JavaScript +link{type:ObjectLiteral,object literal} notation.  These JavaScript Objects are
    // used as ListGridRecords.
    // </smartclient>
    // <smartgwt>
    // The sample data shown above is in JSON format, and might be how data is returned from a REST 
    // web service.
    // </smartgwt>
    // <P>
    // Both records shown above have properties whose names match the name property of a
    // ListGridField, as well as additional properties. The second record will be disabled due to
    // <code>enabled:false</code>; the first record has a property "customProperty" which will
    // have no effect by default but which may be accessed by custom logic.
    // <P>
    // <smartgwt>
    // The same records could be constructed in Java like so:
    // <P>
    // <pre>
    // ListGridRecord records[] = new ListGridRecord[2];
    // records[0] = new ListGridRecord();
    // records[0].setAttribute("field1", "foo");
    // records[0].setAttribute("field2", "bar");
    // records[0].setAttribute("customProperty", 5);
    //
    // records[1] = new ListGridRecord();
    // records[1].setAttribute("field1", "field1 value");
    // records[1].setAttribute("field2", "field2 value");
    // records[1].setAttribute("enabled", false);
    // 
    // RecordList recordList = new RecordList();
    // recordList.addList(records);
    // </pre>
    // </smartgwt>
    // <P>
    // After a ListGrid is created and has loaded data, records may be accessed via
    // <smartgwt>
    // {@link com.smartgwt.client.widgets.grid.ListGrid#getDataAsRecordList()},
    // which will return a +link{ResultSet} (a subclass of
    // {@link com.smartgwt.client.data.RecordList}) if the listGrid is bound to a DataSource.
    // </smartgwt>
    // <smartclient>
    // +link{listGrid.data, listGrid.getData()}, for example, listGrid.getData().get(0) retrieves the first record.
    // +link{ListGrid.data} may be a +link{ResultSet} if the listGrid is bound to a DataSource.
    // </smartclient>
    // ListGridRecords are also passed to many events, such as
    // +link{ListGrid.cellClick,cellClick()}.
    // <P>
    // A ListGridRecord is <smartgwt>a wrapper around</smartgwt><smartclient>always</smartclient>
    // an ordinary JavaScript Object regardless of how the grid's
    // dataset is loaded (static data, java server, XML web service, etc), 
    // <smartclient>
    // and so supports the normal behaviors of JavaScript Objects, including accessing and 
    // assigning to properties via dot notation:
    // <pre>
    //     var fieldValue = record.<i>fieldName</i>;
    //     record.<i>fieldName</i> = newValue;
    // </pre>
    // </smartclient>
    // <smartgwt>
    // where you have access to its properties via setAttribute() and getAttribute() methods:
    // <pre>
    // record.setAttribute("field1", "foo");
    // String value1 = record.getAttribute("field1");
    // </pre>
    // </smartgwt>
    // <P>
    // Note however that simply assigning a value to a record won't cause the display to be
    // automatically refreshed - +link{listGrid.refreshCell()} needs to be called.  Also,
    // consider +link{group:editing,editValues vs saved values} when directly modifying
    // ListGridRecords.
    // <P>
    // See the attributes in the API tab for the full list of special properties on
    // ListGridRecords that will affect the grid's behavior.
    //
    // @treeLocation Client Reference/Grids/ListGrid
    // @inheritsFrom Record
    // @visibility external
    //<
    


    //> @attr listGrid.recordEnabledProperty (String : "enabled" : IR)
    // Property name on a record that will be checked to determine whether a record is enabled.
    // <P>
    // Setting this property on a record will effect the visual style and interactivity of
    // the record.  If set to <code>false</code> the record (row in a +link{ListGrid} or
    // +link{TreeGrid}) will not highlight when the mouse moves over it, nor will it respond to
    // mouse clicks.
    //
    // @see listGridRecord.enabled
    // @example disabledRows
    // @visibility external
    //<
    
    recordEnabledProperty: "enabled",

    //> @attr listGridRecord.enabled (boolean : null : IR)
    //
    // Default property name denoting whether this record is enabled. Property name may be
    // modified for some grid via +link{listGrid.recordEnabledProperty}.
    //
    // @visibility external
    // @example disabledRows
    //<

    //> @attr listGrid.canExpandRecordProperty (String : "canExpand" : IR)
    // Property name on a record that will be checked to determine whether a record can be
    // expanded.
    //
    // @see listGridRecord.canExpand
    // @group expansionField
    // @visibility external
    //<
    canExpandRecordProperty: "canExpand",

    //> @attr listGridRecord.canExpand (boolean : null : IR)
    //
    // Default property name denoting whether this record can be expanded. Property name may be
    // modified for the grid via +link{listGrid.canExpandRecordProperty}.
    //
    // @group expansionField
    // @visibility external
    //<

    //> @attr listGrid.recordCanRemoveProperty (String : "_canRemove" : IRA)
    // If set to false on a record and +link{ListGrid.canRemoveRecords,canRemoveRecords} is
    // true, removal of that record is disallowed in the UI. The icon in the remove field
    // is not shown.
    // @group  editing
    // @visibility external
    //<
    recordCanRemoveProperty:"_canRemove",

    //> @attr listGridRecord._canRemove (boolean : null : IRW)
    //
    // Default property name denoting whether this record can be removed. Property name may be
    // modified for the grid via +link{listGrid.recordCanRemoveProperty}.
    //
    // @group  editing
    // @visibility external
    //<

    //> @attr listGridRecord.isSeparator (boolean : null : IR)
    //
    // Default property name denoting a separator row.<br>
    // When set to <code>true</code>, defines a horizontal separator in the listGrid
    // object. Typically this is specified as the only property of a record object, since a
    // record with <code>isSeparator:true</code> will not display any values.<br>
    // Note: this attribute name is governed by +link{ListGrid.isSeparatorProperty}.
    // @visibility external
    //<

    //> @attr listGridRecord.customStyle (CSSStyleName : null : IRW)
    // Name of a CSS style to use for all cells for this particular record.
    // <P>
    // Note that using this property assigns a single, fixed style to the record, so rollover
    // and selection styling are disabled.  To provide a series of stateful styles for a record
    // use +link{listGridRecord._baseStyle} instead.
    // <P>
    // See +link{listGrid.getCellStyle()} for an overview of various ways to customize styling,
    // both declarative and programmatic.
    // <P>
    // If this property is changed after draw(), to refresh the grid call
    // +link{listGrid.refreshRow()} (or +link{listGrid.markForRedraw()} if several rows are
    // being refreshed).
    // <P>
    // If your application's data uses the "customStyle" attribute for something else, the
    // property name can be changed via +link{listGrid.recordCustomStyleProperty}.
    //
    // @visibility external
    //<

    //> @attr listGridRecord._baseStyle (CSSStyleName : null : IRW)
    // Name of a CSS style to use as the +link{listGrid.baseStyle} for all cells for this
    // particular record.
    // <P>
    // The styleName specified with have suffixes appended to it as the record changes state
    // ("Over", "Selected" and so forth) as described by +link{listGrid.getCellStyle()}.  For a
    // single, fixed style for a record, use +link{listGridRecord.customStyle} instead.
    // <P>
    // See +link{listGrid.getCellStyle()} for an overview of various ways to customize styling,
    // both declarative and programmatic.
    // <P>
    // If this property is changed after draw(), to refresh the grid call
    // +link{listGrid.refreshRow()} (or +link{listGrid.markForRedraw()} if several rows are
    // being refreshed).
    // <P>
    // If your application's data uses the "_baseStyle" attribute for something else, the
    // property name can be changed via +link{listGrid.recordBaseStyleProperty}.
    //
    // @visibility external
    //<

    //> @attr listGridRecord.singleCellValue (HTMLString : null : IRW)
    // Default property name denoting the single value to display for all fields of this row.
    // If this property is set for some record, the record will be displayed as a single
    // cell spanning every column in the grid, with contents set to the value of this
    // property.<br>
    // Note: this attribute name is governed by +link{ListGrid.singleCellValueProperty}.
    // @visibility external
    //<


    //> @attr listGridRecord.canDrag (boolean : null : IR)
    //
    // When set to <code>false</code>, this record cannot be dragged. If canDrag is false for
    // any record in the current selection, none of the records will be draggable.
    //
    // @visibility external
    //<

    //> @attr listGridRecord.canAcceptDrop (boolean : null : IR)
    //
    // When set to <code>false</code>, other records cannot be dropped on (i.e., inserted
    // via drag and drop) immediately before this record.
    //
    // @visibility external
    //<

    //> @attr listGridRecord.linkText (String : null : IRW)
    //
    //  The HTML to display in this row for fields with fieldType set to link. This overrides
    //  +link{attr:listGridField.linkText}.
    //
    //  @see type:ListGridFieldType
    //  @see type:FieldType
    //  @see attr:listGridField.linkText
    //  @see attr:listGrid.linkTextProperty
    //  @group  display_values
    //  @visibility external
    //<

    // Animation
    // ---------------------------------------------------------------------------------------
    // These apply to ListGrid grouping, which basically makes the data model into a Tree where animation
    // is applied for folder open/close.

    //> @attr listGrid.animateFolders (Boolean : true : IRW)
    // If true, when folders are opened / closed children will be animated into view.
    // <P>
    // For a ListGrid, this property applies when +link{ListGrid.canGroupBy,grouping} is enabled.
    // @group animation
    // @visibility animation
    //<
    animateFolders:true,

    //> @attr listGrid.animateFolderMaxRows (Integer : null : IRW)
    // If +link{animateFolders} is true for this grid, this number can be set to designate
    // the maximum number of rows to animate at a time when opening / closing a folder.
    // <P>
    // For a ListGrid, this property applies when +link{ListGrid.canGroupBy,grouping} is enabled.
    // @see treeGrid.getAnimateFolderMaxRows()
    // @group animation
    // @visibility external
    //<

    //> @attr listGrid.animateFolderTime (number : 100 : IRW)
    // When animating folder opening / closing, if +link{treeGrid.animateFolderSpeed} is not
    // set, this property designates the duration of the animation in ms.
    // <P>
    // For a ListGrid, this property applies when +link{ListGrid.canGroupBy,grouping} is enabled.
    // @group animation
    // @visibility animation
    // @see listGrid.animateFolderSpeed
    //<
    animateFolderTime:100,

    //> @attr listGrid.animateFolderSpeed (number : 3000 : IRW)
    // When animating folder opening / closing, this property designates the speed of the
    // animation in pixels shown (or hidden) per second. Takes precedence over the
    // +link{treeGrid.animateFolderTime} property, which allows the developer to specify a
    // duration for the animation rather than a speed.
    // <P>
    // For a ListGrid, this property applies when +link{ListGrid.canGroupBy,grouping} is enabled.
    // @group animation
    // @visibility animation
    // @see listGrid.animateFolderTime
    //<
    animateFolderSpeed:3000,

    //> @attr listGrid.animateFolderEffect (AnimationAcceleration : null : IRW)
    // When animating folder opening / closing, this property can be set to apply an
    // animated acceleration effect. This allows the animation speed to be "weighted", for
    // example expanding or collapsing at a faster rate toward the beginning of the animation
    // than at the end.
    // <P>
    // For a ListGrid, this property applies when +link{ListGrid.canGroupBy,grouping} is enabled.
    // @group animation
    // @visibility animation
    //<

    //> @attr listGrid.animateRowsMaxTime (number : 1000 : IRW)
    // If animateFolderSpeed is specified as a pixels / second value, this property will cap
    // the duration of the animation.
    // <P>
    // For a ListGrid, this property applies when +link{ListGrid.canGroupBy,grouping} is enabled.
    // @group animation
    // @visibility animation_advanced
    //<
    animateRowsMaxTime:1000,

    // external: doc'd on TreeGrid
    shouldAnimateFolder : function (folder) {
        if (!this.animateFolders || !this.isDrawn()) return false;
        
        if (this.autoFitData == "vertical" || this.autoFitData== "both") return false;

        var nodeLocator;
        if (this.data.isANodeLocator(folder)) {
            nodeLocator = folder;
            folder = folder.node;
        }

        var children;
        if (this.data.isFolder(folder)) {
            // Since we are only checking whether there are opened children, don't apply sorting
            // (the dontUseNormalizer parameter is true).
            children = this.data.getOpenList(nodeLocator || folder, null, null, null, null, null, null, true);
        }

        // No children - bit arbitrary whether we "animate" or not!
        
        if (children == null || children.length <= 1) return false;
        return (children.length <= this.getAnimateFolderMaxRows());
    },

    // external: doc'd on TreeGrid
    // returns the min of (3x the viewport row-count) or 75, meaning a given node may
    // or may not animate on open/close depending on the current grid height
    getAnimateFolderMaxRows : function () {
        var maxRows = this.animateFolderMaxRows;
        if (maxRows == null) {
            var vfRs = this.body ? this.body._getViewportFillRows() : [0,0];
            maxRows = Math.min(75, (vfRs[1]-vfRs[0]) * 3);
        }
        return maxRows
    },


    // DataBinding
    // ----------------------------------------------------------------------------------------

    //> @attr listGrid.fields (Array of ListGridField : null : [IRW])
    // An array of field objects, specifying the order, layout, formatting, and
    // sorting behavior of each field in the listGrid object.  In ListGrids, the fields
    // array specifies columns.  Each field in the fields array is a ListGridField object.
    // Any listGrid that will display data should have at least one visible field.
    // <p>
    // If +link{ListGrid.dataSource} is also set, this value acts as a set of overrides as
    // explained in +link{attr:DataBoundComponent.fields}. 
    // <P>
    // Note: grids with +link{listGrid.useAllDataSourceFields,useAllDataSourceFields:true} will
    // render the full set of dataSource fields in the order in which they are defined in
    // the dataSource - in this usage the component fields array is just a way to customize
    // the appearance of individual fields.
    // <P>
    // Grids with +link{listGrid.canPickOmittedFields,canPickOmittedFields:true} will only 
    // show the explicitly specified set of fields, but will similarly show them in
    // the order in which they're defined within the dataSource.
    //
    // @see    ListGridField
    // @see    setFields()
    // @group databinding
    // @visibility external
    // @example listGridFields
    // @example mergedFields
    //<

    //> @attr listGrid.defaultFields (Array of ListGridField Properties : null : IRA)
    // An array of listGrid field configuration objects.  When a listGrid is initialized, if this
    // property is set and there is no value for the <code>fields</code> attribute, this.fields will
    // be defaulted to a generated array of field objects duplicated from this array.
    // <P>
    // This property is useful for cases where a standard set of fields will be displayed
    // in multiple listGrids - for example a subclass of ListGrid intended to display a particular
    // type of data:<br>
    // In this example we would not assign a single +link{listGrid.fields} array directly to the
    // class via <code>addProperties()</code> as every generated instance of this class would
    // then point to the same fields array object. This would cause unexpected behavior such as
    // changes to the field order in one grid affecting other grids on the page.<br>
    // Instead we could use <code>addProperties()</code> on our new subclass to set
    // <code>defaultFields</code> to a standard array of fields to display. Each generated instance
    // of the subclass would then show up with default fields duplicated from this array.
    // @visibility external
    //<

    //> @attr listGrid.fetchFields (Array of ListGridField | String : null : [IRW])
    // Fields that will be always requested from the server when the grid fetches data, even 
    // if they are not visible - may be either an array of fields or a CSV string.
    // <p>
    // If <code>fetchFields</code> has been set, then aside from the declared 
    // <code>fetchFields</code>, the full set of requested fields will always include the 
    // primary-key fields from the dataSource and any 
    // visible fields that are also DataSource fields - so if either a
    // +link{SavedSearches,SavedSearch} or the +link{listGrid.fields} configuration includes
    // fields not declared in <code>fetchFields</code>, those fields will be requested from the
    // server even if they are not included in <code>fetchFields</code>.
    // <p>
    // In addition, any fields that are referenced by declarative features, such as 
    // +link{UserFormula} or +link{listGridField.visibleWhen}, will also be automatically 
    // included, even if not listed in <code>fetchFields</code>.  Also applies to declarative 
    // +link{expansionMode, expansion} and +link{hoverMode, hover} modes, where fields required
    // by those modes are also fetched.
    // <p>
    // This means you can essentially set <code>fetchFields</code> to just fields that always 
    // need to be there, whether visible or not - such as fields that are required by custom 
    // grid logic (e.g. formatters, or +link{listGrid.canEditCell}) or may be required when 
    // other components interact with the data (such as editing a record from the grid in a 
    // form via +link{dynamicForm.editSelectedData()}).
    // <p>
    // To enable the feature of causing just primary-keys, visible and declaratively 
    // required fields to be requested, without any specific additional fields, you can set 
    // <code>fetchFields</code> to the special value "*visible*".  In order for application 
    // code to more easily build a list of fields, you may also include this 
    // special value in a compound string, such as <i>"*visible*, field1, field2"</i> - in this 
    // case, the special value is simply ignored, since visible fields are always requested if 
    // <code>fetchFields</code> is set to a value.
    // <p>
    // If <code>fetchFields</code> includes fields which do not appear in the dataSource, 
    // a warning is logged and those fields will not be requested from the server.
    // <p>
    // 
    // Fields to be retrieved are communicated to the server via +link{dsRequest.outputs}.
    // <p>
    // If a user dynamically shows additional fields (via the field picking menu, via Saved 
    // Search or another mechanism), and such fields are not currently loaded, the ListGrid 
    // will automatically invalidate the data cache and issue a new fetch with a different 
    // dsRequest.outputs setting in order to fetch the necessary data.
    // <p>
    // If <code>fetchFields</code> has been set and outputs are also set via another mechanism 
    // (like +link{listGrid.fetchRequestProperties}), <code>fetchFields</code> wins.
    // <p>
    // Note that since <code>fetchFields</code> ultimately just sets 
    // +link{dsRequest.outputs}, +link{dataSourceField.outputWhen} settings will override 
    // <code>fetchFields</code> settings.  This also means that, currently, 
    // <code>fetchFields</code> is not supported by clientOnly 
    // DataSources, because they do not support dsRequest.outputs. 
    // <p>
    // Additionally, if +link{operationBinding.outputs} is specified in a server-side .ds.xml 
    // file, <code>fetchFields</code> will only be able to request fields listed as valid 
    // server outputs.  In general, client-specified outputs do not override server-specified 
    // outputs; client-specified outputs must be a subset of outputs listed on the server.
    // @group databinding
    // @visibility external
    //<

    //> @attr   listGrid.dataSource     (DataSource | ID : null : IRW)
    // @include dataBoundComponent.dataSource
    //<

    //> @attr listGrid.dataArity (String : "multiple" : IRWA)
    // A ListGrid is a +link{dataBoundComponent.dataArity,dataArity}:multiple component.
    // @group databinding
    // @visibility external
    //<

    //> @attr listGrid.autoFetchDisplayMap (Boolean : true : [IRW])
    // If true, for fields where +link{listGridField.optionDataSource} is specified,
    // a valueMap will be automatically created by making a +link{dataSource.fetchData()} call
    // against the specified dataSource and extracting a valueMap from the returned records
    // based on the displayField and valueField.
    // <P>
    // If set to false, valueMaps will not be automatically fetched.  In this case, setting
    // field.optionDataSource is effectively a shortcut for setting optionDataSource on
    // the editor via +link{listGridField.editorProperties}.
    // <P>
    // Can also be disabled on a per-field basis with +link{listGridField.autoFetchDisplayMap}.
    //
    // @group display_values
    // @see listGridField.autoFetchDisplayMap
    // @see listGridField.optionDataSource
    // @visibility external
    //<
    autoFetchDisplayMap:true,

    //> @attr listGrid.warnOnUnmappedValueFieldChange (Boolean : true : IRWA)
    // If a field has +link{listGridField.displayField} specified and has no
    // +link{listGridField.optionDataSource}, this field will display the value from the
    // <code>displayField</code> of each record by default (for more on this behavior
    // see +link{listGridField.optionDataSource}).
    // <P>
    // If such a field is editable, changing the edit value for the field on some record,
    // without updating the edit value for the associated display field on the same record
    // would mean the user would continue to see the unchanged display field value.
    // Developers can resolve this situation by programmatically setting an edit value for
    // the display field as well as the data field, or avoid it by specifying an optionDataSource
    // and ensuring +link{listGrid.autoFetchDisplayMap} is true, or setting an explicit valueMap
    // for the field.
    // <P>
    // By default, when the edit value on a field with a specified displayField and
    // no optionDataSource is set, we log a warning to notify the developer. This warning may
    // be disabled by setting <code>warnOnUnmappedValueFieldChange</code> to <code>false</code>.
    // <P>
    // Note: There are actually a couple of cases in which the system will automatically
    // derive a new display-field value and apply it to the record:
    // <ol><li>If the edit value was changed by a user actually editing the record
    // (rather than a programmatic call to setEditValue()), and the edit-item had
    // a valueMap or optionDataSource set, we automatically pick up the display value from
    // that item and store it as an edit-value for the displayField of the record</li>
    //     <li>If the listGrid has a loaded record in its data set whose valueField value matches
    // the edit value for the valueField, we automatically apply the displayField value from that
    // record as an edit value for the displayField on the newly edited record.</li></ol>
    // In either case, the display value for the record is updated automatically
    // (and the warning would not be logged).
    // @visibility external
    //<
    warnOnUnmappedValueFieldChange:true,

    //or <code>autoFetchDisplayMap</code> is false at
    // the +link{listGrid.autoFetchDisplayMap,listGrid}
    // or +link{listGridField.autoFetchDisplayMap,field} level, the field will display the
    // record value from the +link{

    //> @attr listGrid.saveLocally (boolean : null : IRA)
    // For grids with a specified +link{ListGrid.dataSource}, this property can be set to
    // <code>true</code> to cause the grid directly update its local data set instead of
    // performing an operation against it's configured DataSource.
    // <p>
    // When using this mode, data must be provided to the grid via +link{listGrid.setData()},
    // and must be provided as 
    // <smartclient>a simple Array of Records</smartclient>
    // <smartgwt>a RecordList</smartgwt>.  Setting <code>saveLocally</code> is invalid if
    // either +link{fetchData()} is called or if a +link{ResultSet} is provided as the data
    // model.
    // <p>
    // <code>saveLocally</code> mode includes changes made via 
    // +link{listGrid.canEdit,inline editing}, record removal via +link{canRemoveRecords}, as
    // well as programmatic calls to +link{listGrid.updateData()},
    // +link{listGrid.addData,addData()} and +link{listGrid.removeData,removeData()}.  This
    // also causes saves to be performed synchronously (unlike normal DataSource operations).
    // <p>
    // Note that using this mode also disables the automatic cache synchronization provided by
    // the DataSource system - changes made to this grid are saved only to this grid's data
    // set.
    // <P>
    // See also +link{listGrid.filterLocalData} to allow filtering, such as filtering performed
    // by the +link{filterEditor}, to also work only with the local data set.
    // <P>
    // If saveLocally is unset, and +link{listGrid.filterLocalData} is true, the saveLocally behavior is
    // enabled by default
    // 
    // @see useRemoteValidators
    // @visibility external
    // @group databinding
    //<
    

    //> @attr ListGrid.saveRequestProperties (DSRequest Properties : null : IRWA)
    // For editable grids with a specified +link{listGrid.dataSource}, where
    // +link{listGrid.saveLocally} is false, this attribute may be used to specify standard
    // DSRequest properties to apply to all save operations performed by this grid (whether
    // triggered by user interaction, or explicit saveEdits or saveAllEdits call).
    // <P>
    // An example usage would be to customize the prompt displayed while saving is in progress
    // if +link{listGrid.waitForSave} is true.
    // <P>
    // Note that for more advanced customization of save operations,
    // +link{dataBoundComponent.addOperation} and +link{dataBoundComponent.updateOperation}
    // are available to developers, allowing specification of an explicit +link{operationBinding}
    // for the add / update operation performed on save.
    //
    // @visibility external
    // @group databinding
    // @group editing
    //<

    //> @attr ListGrid.useRemoteValidators (boolean : null : IRWA)
    // If +link{listGrid.saveLocally} is specified, but this grid is bound to a DataSource which
    // includes remote field validators, by default edits will be saved synchronously and
    // these validators will not be executed.<br>
    // Set this property to <code>true</code> to ensure these remote validators are called when
    // saving edits in saveLocally mode. Note that since these remote validators need to run on
    // the server, saving with this property set is asynchronous, even though the data that
    // ultimately gets updated is already present on the client.
    // @visibility external
    // @group databinding
    //<

    //> @attr listGrid.useAllDataSourceFields (boolean : null : IRW)
    // @include dataBoundComponent.useAllDataSourceFields
    // @group databinding
    //<

    //> @attr listGrid.showDetailFields (Boolean : true : IR)
    // Whether to include fields marked <code>detail:true</code> from this component's
    // <code>DataSource</code>.
    // <P>
    // When this property is <code>true</code>, the <code>ListGrid</code> will include all
    // detail fields unless fields have been specifically declared using the
    // +link{listGrid.fields} array.
    // <P>
    // Any field which has been included directly in the <code>fields</code> array will be
    // included regardless of the fields <code>detail</code> attribute.
    // <p>
    // Detail fields included will initially be hidden but the user may show these fields via
    // the default header context menu (+link{listGrid.showHeaderContextMenu}).
    // <P>
    // The field's visibility can also be overridden programatically using the standard
    // +link{listGrid.showField()}, +link{listGrid.hideField()} and +link{listGridField.showIf}
    // APIs, for example, set showIf:"true" to show a detail field initially.
    // <P>
    // Setting this property to false will completely exclude all detail fields from the list
    // grid's fields array, such that they cannot be shown by the user or programmatically.
    //
    // @group databinding
    // @visibility external
    //<
    showDetailFields:true,

    //> @attr listGrid.showEllipsisWhenClipped (boolean : true : IRW)
    // Should ellipses be displayed when cell content is clipped? May be overridden at the field 
    // level via +link{listGridField.showEllipsisWhenClipped}
    // @visibility external
    //<
    showEllipsisWhenClipped:true,
    
    //> @attr ListGrid.titleField (String : see below : IRW)
    // Best field to use for a user-visible title for an individual record from this grid.
    // If +link{ListGrid.dataSource} is non null, this property may be specified on the
    // dataSource instead.
    // <p>
    // If not explicitly set, titleField looks for fields named "title", "name", and "id"
    // in that order.  If a field exists with one of those names, it becomes the titleField.
    // If not, then the first field is designated as the titleField.
    //  @visibility external
    //<

    //> @attr listGrid.dataProperties (ResultSet : null :IRWA)
    // For databound ListGrids, this attribute can be used to customize the +link{ResultSet}
    // object created for this grid when data is fetched
    // @group databinding
    // @visibility external
    //<


    // Saved Search
    // ---------------------------------------------------------------------------------------
    savedSearchItemDefaults: {
        _constructor: "SavedSearchItem"
    },

    //> @attr listGrid.saveDefaultSearch (boolean : true : IR)
    // Saves the name of the default search to localStorage, under the key "sc_defaultSearch:" + minimal
    // locator.
    // <p>
    // See +link{SavedSearches} "Default Searches" for why this is stored separately from the search itself
    // if there is no saved default search, but there is a +link{SavedSearches.defaultField}, the first
    // user-specfic search marked default will be used, otherwise the first admn search marked default
    // <p>
    // If +link{autoFetchData} is enabled, the autoFetch will be postponed as needed until a default search can be
    // looked up and applied.  If anything fails in the default search lookup, an autoFetch will still be
    // performed (without any saved search information)
    // @visibility external
    //<
    saveDefaultSearch: true,

    //> @attr listGrid.canSaveSearches (boolean : true : IR)
    // When enabled (the default), causes a "Saved views >" submenu to appear in the header
    // context menu, last, allowing the user to create new saved searches, select previously
    // saved searches, and edit or copy existing searches.
    // <p>
    // Note that disabling this feature does not mean that saved searches are disallowed - you
    // can stil implement a separate UI via a +link{SavedSearchItem} that targets this component.
    // But, when disabled, the grid-integrated menu described above will not be shown.
    // <p>
    // This feature uses the global settings found in +link{SavedSearches}.  Some aspects can
    // be overridden for this component.  See +link{savedSearchDS}, +link{savedSearchAdminRole}.
    // <p>
    // To avoid leaking local storage, this setting will be disregarded, disabling the feature,
    // unless the grid specifies +link{dataBoundComponent.savedSearchId,savedSearchId}, or an
    // explicit +link{getLocalId(),local or global ID} is present.
    // <p>
    // <b>Note:</b> this feature requires
    // +externalLink{https://www.smartclient.com/product/,SmartClient Pro} or better.
    // @visibility external
    //<
    


    //> @attr listGrid.savedSearchStoredState (SavedSearchStoredState : null : IR)
    // @include savedSearchItem.storedState
    // @visibility external
    //<
    savedSearchStoredState: null,

    //> @attr listGrid.noSavedSearchesText (HTMLString : "[None]" : IR)
    // Text to show in menu listing saved searches when there are no saved searches.
    // @visibility external
    // @group i18nMessages
    //<
    noSavedSearchesText: "[None]",

    //> @attr listGrid.savedSearchText (HTMLString : "Saved views" : IR)
    // Text to show for the saved searches submenu.
    // @visibility external
    // @group i18nMessages
    //<
    savedSearchText: "Saved views",

    //> @attr listGrid.newSearchText (HTMLString : "Save View..." : IR)
    // Text to show for saving the current view as a new "saved search".
    // @visibility external
    // @group i18nMessages
    //<
    newSearchText: "Save View...",

    //> @attr listGrid.savedSearchAdminSeparator (AutoChild ListGridRecord : {isSeparator:true} : IR)
    // Properties for the separator record between locally saved and admin searches.
    // @visibility external
    //<
    savedSearchAdminSeparatorDefaults: {
        isSeparator: true
    },

    //> @attr listGrid.savedSearchDS (String : null : IR)
    // Override of +link{SavedSearches.defaultDataSource} for this component.
    // @visibility external
    //<

    //> @attr listGrid.savedSearchAdminRole (String : null : IR)
    // Override of +link{SavedSearches.adminRole} for this component.
    // @visibility external
    //<

    // Grouping
    // ---------------------------------------------------------------------------------------

    //> @object GroupNode
    //
    // An auto-generated subclass of +link{TreeNode} representing the group nodes
    // in a grouped +link{ListGrid}.
    //
    // @see listGrid.groupBy()
    // @treeLocation Client Reference/Grids/ListGrid
    // @group grouping
    // @visibility external
    //<

    //> @attr groupNode.groupMembers (Array of ListGridRecord | GroupNode : see below : R)
    // Array of ListGridRecord that belong to this group, or, for multi-field grouping, array
    // of groupNodes of subgroups under this groupNode.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<

    //> @attr groupNode.groupTitle (HTMLString : see below : R)
    // The computed title for the group, which results from +link{listGridField.getGroupTitle()}
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<

    //> @attr groupNode.groupValue (Any : see below : R)
    // The value from which groups are computed for a field,
    // which results from +link{listGridField.getGroupValue()}
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<

    //> @attr groupNode.groupName (FieldName : see below : R)
    // Name of the field being grouped by this node.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<

    //> @attr listGrid.originalData (Object : null : R)
    // When grouped, a copy of the original ungrouped data.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<

    //> @attr listGrid.groupTree (AutoChild Tree : null : R)
    // The data tree that results from a call to  +link{listGrid.groupBy()}.
    // This will be a +link{ResultTree} if +link{listGrid.dataSource} is
    // present, otherwise it will be a +link{Tree}.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<

    //> @type GroupStartOpen
    // Possible values for the state of ListGrid groups when groupBy is called
    //
    // @value "all" open all groups
    // @value "first" open the first group
    // @value "none" start with all groups closed
    // @visibility external
    //<

    //> @attr listGrid.groupStartOpen (GroupStartOpen | Array : "first" : IRW)
    // Describes the default state of ListGrid groups when groupBy is called.
    //
    // Possible values are:
    // <ul>
    // <li>"all": open all groups
    // <li>"first": open the first group
    // <li>"none": start with all groups closed
    // <li>Array of group values that should be opened
    // </ul>
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<
    groupStartOpen:"first",

    //> @attr listGrid.canCollapseGroup (Boolean : true : IR)
    // Can a group be collapsed/expanded? When true a collapse/expand icon is shown
    // (+link{groupIcon,groupIcon}) and the user can collapse or expand the group by
    // clicking either the row as a whole or the opener icon (see +link{collapseGroupOnRowClick});
    //
    // When false the group icon is not shown and clicking on the row does
    // not change group state. Additionally +link{groupStartOpen,groupStartOpen} is
    // initialized to "all".
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<
    
    canCollapseGroup:true,
    
    //> @attr listGrid.collapseGroupOnRowClick (boolean : true : IR)
    // If +link{canCollapseGroup} is true, will a click anywhere on the group row
    // toggle the group's expanded state? If false, the user must click the
    // +link{groupIcon} directly to toggle the group.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<
    collapseGroupOnRowClick:true,

    //> @attr listGrid.groupTitleField (String : null : IR)
    // When a list grid is +link{listGrid.groupBy(),grouped}, each group shows
    // under an auto generated header node. By default the title of the group will be
    // shown, with a hanging indent in this node, and will span all columns in the grid.
    // Setting this property causes the titles of auto-generated group nodes to appear as
    // though they were values of the designated field instead of spanning all columns
    // and record values in the designated groupTitleField will appear indented under
    // the group title in a manner similar to how a TreeGrid shows a Tree.
    // <P>
    // Note if +link{listGrid.showGroupSummaryInHeader} is true, the header nodes will not show
    // a single spanning title value by default - instead they will show the summary values for
    // each field. In this case, if groupTitleField is unset, a
    // +link{listGrid.showGroupTitleColumn,groupTitleColumn} can be automatically generated to
    // show the title for each group.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<
    
    getGroupTitleField : function () {
        return this.groupTitleField;
    },

    _isGroupTitleField : function (field) {
        var groupTitleField = this.getGroupTitleField();
        return groupTitleField == null ? field._isGroupTitleColumn :
                                         field.name == groupTitleField;
    },

    //> @attr listGrid.showGroupTitleColumn (Boolean : true : IR)
    // If this grid is +link{listGrid.groupBy(),grouped} and +link{listGrid.showGroupSummaryInHeader}
    // is true, instead of group header nodes showing up with a single cell value spanning the full
    // set of columns, summaries for each field will show up in the appropriate columns of the
    // header node.
    // <P>
    // In this case there are 2 options for where the group title will show up. Developers may
    // specify an existing field to put the title values into via +link{listGrid.groupTitleField}.
    // If no groupTitleField is specified, this property may be set to <code>true</code>
    // which causes a <code>groupTitleColumn</code> to be automatically generated.
    // Each group header will show the group title in this column (records within the group will
    // not show a value for this column). The column appears in the leftmost position within the
    // grid (unless +link{listGrid.showRowNumbers} is true, in which case this column shows up
    // in the second-leftmost position), and by default will auto-fit to its data.
    // <P>
    // To customize this field, developers may modify
    // +link{listGrid.groupTitleColumnProperties}
    // <smartclient>or
    // +link{listGrid.groupTitleColumnDefaults} at the class level.</smartclient>
    // @visibility external
    //<
    showGroupTitleColumn:true,

    //> @attr listGrid.groupTitleColumnProperties (ListGridField Properties : null : IR)
    // Custom properties for the automatically generated <code>groupTitleColumn</code>.
    // <P>
    // See +link{listGrid.showGroupTitleColumn} for an overview of the groupTitleColumn.
    // @visibility external
    //<
    //groupTitleColumnProperties:null,

    //> @attr listGrid.groupTitleColumnDefaults (ListGridField Properties : object : IR)
    // Default properties for the automatically generated <code>groupTitleColumn</code>.
    // Default object includes properties to enable autoFitWidth to group title values.
    // <P>
    // To modify the behavior or appearance of this column, developers may set
    // +link{listGrid.groupTitleColumnProperties} at the instance level, or override this
    // object at the class level. If overriding this object, we recommend using
    // +link{class.changeDefaults()} rather than replacing this object entirely.
    // <P>
    // See +link{listGrid.showGroupTitleColumn} for an overview of the groupTitleColumn.
    // @visibility external
    //<
    groupTitleColumnDefaults:{
        canEdit:false,
        canFilter:false,
        canHide:false,
        canReorder:false,
        showDefaultContextMenu:false,
        autoFreeze:true,

        sortNormalizer:function (recordObject,fieldName,context) {
            return recordObject.groupTitle;
        },

        autoFitWidth:true,
        autoFitWidthApproach:"value",
        title:"&nbsp;"
    },

    // We actually show the special group title column if
    // - we're showing the group summary in the header
    // - we have no explicitly specified group title field
    // - the showGroupTitleColumn flag is true
    showingGroupTitleColumn : function () {
        return (this.isGrouped && this.showGroupSummary && this.showGroupSummaryInHeader
                && this.showGroupTitleColumn && this.getGroupTitleField() == null);
    },

    // groupTitleColumnName: This could be modified to display an actual field within the
    // grid data, but the developer might as well use groupTitleField instead.
    // Leaving unexposed for now.
    groupTitleColumnName:"groupTitle",

    getGroupTitleColumn : function () {
        var grid = this;
        var groupTitleColumn = isc.addProperties(
            {   _isGroupTitleColumn:true,
                // 'grid' available through closure
                getAutoFreezePosition: function () { return grid.getGroupTitleColumnPosition() }
            },
            this.groupTitleColumnDefaults,
            this.groupTitleColumnProperties
        );

        if (groupTitleColumn.name == null) {
            groupTitleColumn.name = this.groupTitleColumnName;
        }
        return groupTitleColumn;
    },

    getGroupTitleColumnPosition : function () {
        // This is really just a sanity check - we don't expect to be calling this method when
        // we're not showing the special groupTitleColumn
        if (!this.showingGroupTitleColumn()) return -1;

        
        var pos = 0;
        if (this.shouldShowRowNumberField())  pos++;
        if (this.shouldShowDragHandleField()) pos++;
        if (this.shouldShowCheckboxField())   pos++;
        if (this.shouldShowExpansionField())  pos++;
        return pos;
    },

    singleCellGroupHeaders : function () {
        return this._singleCellGroupHeaders(this.showGroupSummary, this.showGroupSummaryInHeader);
    },
    _singleCellGroupHeaders : function (showGroupSummary, showGroupSummaryInHeader) {
        if (this.getGroupTitleField() != null) return false;
        if (showGroupSummary && showGroupSummaryInHeader) return false;
        return true
    },

    //> @attr listGrid.showGroupSummaryInHeader (Boolean : false : IRW)
    // If this grid is +link{listGrid.groupBy(),grouped}, and +link{listGrid.showGroupSummary}
    // is true, setting this property causes field summary values for each group to be displayed
    // directly in the group header node, rather than showing up at the bottom of each
    // expanded group.
    // <P>
    // Note that this means the group header node will be showing multiple field values
    // rather than the default display of a single cell spanning all columns containing the
    // group title. Developers may specify an explicit +link{listGrid.groupTitleField}, or
    // rely on the automatically generated +link{listGrid.showGroupTitleColumn,groupTitleColumn}
    // to have group titles be visible as well as the summary values.
    // <P>
    // Also note that multi-line group summaries are not supported when showing
    // the group summary in the group header. If multiple
    // +link{listGridField.summaryFunction,field summary functions} are defined for some field
    // only the first will be displayed when this property is set to true.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<
    showGroupSummaryInHeader:false,

    //> @attr listGrid.showCollapsedGroupSummary (Boolean : false : IRW)
    // Should group summaries be visible when the group is collapsed?
    // <P>
    // This property only applies to +link{listGrid.groupBy(),grouped} grids showing
    // +link{listGrid.showGroupSummary,group summary rows}. When set to true, the
    // group summary row(s) for each group will show up under the group header nodes when
    // the group is collapsed, or at then end of the grouped set of data if the group
    // is expanded.
    // <P>
    // This property has no effect if +link{showGroupSummaryInHeader} is true.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<
    showCollapsedGroupSummary:false,

    //> @method listGridField.getGroupValue()
    // Return the value which records should be grouped by.
    // <P>
    // All records for which getGroupValue() returns the same value appear in the same
    // group.  Default is the result of +link{listGrid.getCellValue}.
    // <P>
    // While any type of value may be returned, avoiding the use of string values may
    // result in improved performance. In this case, +link{listGridField.getGroupTitle()}
    // may be implemented to map a numeric group value into a legible string.
    //
    // @param   value (Any)   raw value for the cell, from the record for the row
    // @param   record (ListGridRecord)
    //   Record object for the cell. Note: If this is a new row that has not been saved, in an
    //   editable grid, it has no associated record object. In this case the edit values will
    //   be passed in as this parameter (see +link{listGrid.getEditValues()})
    // @param   field (Object)    Field object for which to get group value
    // @param   fieldName (String)    The name of the field
    // @param   grid (ListGrid) the ListGrid displaying the cell
    // @return (Any) Group value to which this record belongs
    //
    // @see listGrid.groupBy()
    // @see listGridField.getGroupTitle()
    // @group grouping
    // @visibility external
    // @example customGrouping
    //<

    //> @method listGridField.getGroupTitle()
    // Return the title that should be shown to the user for the group with the
    // <code>groupValue</code> passed as a parameter.
    // <P>
    // Default title is the groupValue itself.
    //
    // @group grouping
    //
    // @param   groupValue (Any)   the value from the group is created, the result of
    //  +link{listGridField.getGroupValue()}
    // @param   groupNode (GroupNode) the node in the grid containing the group.
    // @param   field (Object)    Field object for which to get group value
    // @param   fieldName (String)    The name of the field
    // @param   grid (ListGrid) the ListGrid displaying the cell
    // @return (Any) Group value to which this record belongs
    //
    // @see listGrid.groupBy()
    // @see listGridField.getGroupValue()
    // @visibility external
    // @example customGrouping
    //<

    //> @attr listGridField.groupingModes (ValueMap : null : IR)
    // If this field can be grouped, this attribute represents the set of grouping styles that 
    // are available.  For example, a "date" field might be able to be 
    // grouped by week or month, as well as by the date itself.
    // <P>
    // If <code>groupingModes</code> are present and
    // +link{listGrid.canGroupBy,grouping is enabled}, the menu for this field includes a
    // submenu of possible grouping modes generated from the <code>groupingModes</code> valueMap.
    // When the user selects a particular grouping mode,
    // +link{listGridField.groupingMode,field.groupingMode} is set to the user's chosen mode,
    // and this choice can be detected via the <code>field</code> parameter to
    // +link{listGridField.getGroupValue()} in order to provide different modes of grouping.
    // <P>
    // The user may also choose to group records without specifying a grouping mode, in this case,
    // the +link{listGridField.defaultGroupingMode} is used.
    // <P>
    // Note that <code>getGroupValue</code>, <code>groupingModes</code> et al can be specified on
    // +link{SimpleType} declarations.  See this list of
    // +link{group:builtinGroupingModes, builtin grouping modes} for more information.    
    //
    // @group grouping
    // @visibility external
    //<

    //> @attr listGridField.groupingMode (Identifier : null : IR)
    // For a field that allows multiple +link{listGridField.groupingModes,grouping modes},
    // the current grouping mode.
    // <P>
    // This property is set when a user chooses a particular grouping mode, and may be set on
    // ListGrid creation to affect the initial grouping.
    //
    // @group grouping
    // @visibility external
    //<

    //> @attr listGridField.defaultGroupingMode (Identifier : null : IR)
    // Default groupingMode used when the user does not specify a mode or grouping is triggered
    // programmatically and +link{listGridField.groupingMode,field.groupingMode} is unset.
    // See +link{listGridField.groupingModes,field.groupingModes}.
    //
    // @group grouping
    // @visibility external
    //<

    //> @attr listGridField.groupPrecision (Integer : null : IR)
    // For fields of type:"float" or derived from float, number of digits after the decimal point
    // to consider when grouping.
    // <P>
    // For example, <code>groupPrecision:2</code> indicates that 45.238 and 45.231 group together,
    // but 45.22 and 45.27 are separate.
    // <P>
    // See also +link{listGridField.groupGranularity,groupGranularity} for grouping by broader
    // ranges.
    //
    // @group grouping
    // @visibility external
    //<

    //> @attr listGridField.groupGranularity (Integer : null : IR)
    // Granularity of grouping for numeric fields.
    // <P>
    // Groups will be formed based on ranges of values of size <code>groupGranularity</code>.  For
    // example, if groupGranularity were 1000, groups would be 0-1000, 1000-2000, etc.
    //
    // @group grouping
    // @visibility external
    //<

    //> @attr listGridField.canHilite (boolean : null : IRW)
    // Determines whether this field can be hilited.  Set to false to prevent this
    // field from appearing in HiliteEditor.
    //
    // @visibility external
    //<

    //> @attr listGridField.showHilitesInGroupSummary (Boolean : null : IRW)
    // Determines whether hiliting for this field is shown in a group summary.
    // Set to false to prevent this field from showing hilite in a group summary.
    // <P>
    // All hilites in group summary rows can be controlled with the
    // +link{listGrid.showHilitesInGroupSummary} property.
    //
    // @visibility external
    //<

    //> @attr listGridField.canGroupBy (Boolean : true : IRW)
    // Determines whether this field will be groupable in the header context menu.
    //
    // @see listGrid.groupBy()
    // @visibility external
    //<

    //> @attr listGridField.canSortClientOnly (Boolean : false : IRW)
    // When true, this field can only be used for sorting if the data is entirely client-side.
    //
    // @visibility external
    //<

    //> @attr listGridField.showDefaultContextMenu (Boolean : true : IRW)
    // When set to false, this field will not show a context menu in its header.
    //
    // @visibility external
    //<

    //> @attr listGridField.canExport (Boolean : null : IR)
    //  Dictates whether the data in this field be exported.  Explicitly set this
    //  to false to prevent exporting.  Has no effect if the underlying
    //  +link{dataSourceField.canExport, dataSourceField} is explicitly set to
    //  canExport: false.
    //
    // @visibility external
    //<

    //> @attr listGridField.exportRawValues (Boolean : null : IR)
    //  Dictates whether the data in this field should be exported raw by
    // +link{listGrid.exportClientData, exportClientData()}.  If set to true for a
    // field, the values in the field-formatters will not be executed for data in this field.
    // Decreases the time taken for large exports.
    //
    // @visibility external
    //<

    //> @attr listGridField.exportRawNumbers (Boolean : null : IR)
    // Dictates whether numeric values should be exported as raw numbers instead of
    // formatted values when using +link{listGrid.exportClientData, exportClientData()}.
    // <P>
    // This property is only consulted if <code>exportRawValues</code> is not set to
    // true at the +link{listGrid.exportRawValues,grid} or
    // +link{listGridField.exportRawValues,field} level. That property causes all values,
    // including numeric values, to be exported unformatted.
    // <P>
    // This is useful for cases where an explicit ListGrid formatter function simply displays the number
    // as a formatted string for the user (for example "1,234"). Exporting that formatted
    // string rather than the underlying numeric value causes spreadsheet applications such as
    // Excel to lose some functionality.
    // <P>
    // If this property is not explicitly set, numeric values will be exported as raw
    // numbers for +link{DSRequest.exportAs,XLS and OOXML export} only.
    // <P>
    // This property overrides the setting at the +link{listGrid.exportRawNumbers,grid} level.
    //
    // @visibility external
    //<
    
    //> @attr listGridField.summaryValue (HTMLString : null : IRW)
    // The value to display for a ListGridField when it appears in the +link{listGrid.summaryRow,summaryRow}.  The
    // default for normal fields is null and for special fields, like the +link{listGrid.checkboxField,checkboxField},
    // the default is to show a blank value (a non-breaking space).
    // @visibility external
    //<

    //> @attr listGrid.groupNodeStyle (String : "groupNode" : IRW)
    // The CSS style that +link{listGrid.groupBy,group} rows will have.
    // <P>
    // Note that this is not a +link{listGrid.getBaseStyle(),base style}, so, if this
    // property is set, group nodes will not show stateful styling
    // (different styles for +link{listGrid.showRollOver},
    // +link{listGrid.alternateRecordStyles}, etc). To enable stateful styling for
    // groupNodes, set this property to <code>null</code> and specify a
    // +link{groupNodeBaseStyle}
    //
    // @group grouping
    // @see group:grouping
    // @visibility external
    //<
    groupNodeStyle: "groupNode",

    //> @attr listGrid.groupNodeBaseStyle (String : null : IRW)
    // +link{listGrid.getBaseStyle(),Base style} for +link{listGrid.groupBy,group} rows.
    // <P>
    // Note that this property has no effect if +link{listGrid.groupNodeStyle} is
    // non null.
    //
    // @group grouping
    // @see group:grouping
    // @visibility external
    //<
    groupNodeBaseStyle: null,

    //> @attr listGrid.groupIcon (SCImgURL : "[SKINIMG]/TreeGrid/opener.gif" : IRW)
    // The URL of the base icon for the group icons in this listGrid. Default value may 
    // be overridden by the +link{group:skinning,current skin}.
    //
    // @group grouping
    // @see group:grouping
    // @visibility external
    //<
    groupIcon: "[SKINIMG]/TreeGrid/opener.gif",

    //> @attr listGrid.groupIconSize (Number : 16 : IRW)
    // Default width and height of group icons for this ListGrid.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<
    groupIconSize: 16,

    //> @attr listGrid.groupIconStyle (CSSStyleName : null : [IRW])
    // Custom style to apply to the +link{groupIcon} displayed in collapsible rows when 
    // +link{listGrid.canGroupBy} is true.
    // @group appearance
    // @visibility external
    //<

    //> @attr listGrid.groupIndentSize (Number : 20 : IRW)
    // Default number of pixels by which to indent subgroups relative to parent group.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @see listGrid.getGroupNodeHTML
    // @visibility external
    //<
    groupIndentSize: 20,

    //> @attr listGrid.groupLeadingIndent (Number : 10 : IRW)
    // Default number of pixels by which to indent all groups.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @see listGrid.getGroupNodeHTML
    // @visibility external
    //<
    groupLeadingIndent: 10,

    //> @attr listGrid.canGroupBy (Boolean : true : IRW)
    // If false, grouping via context menu will be disabled.
    //
    // @group grouping
    // @see listGrid.groupBy()
    // @visibility external
    //<
    canGroupBy: true,

    //> @attr listGrid.groupByMaxRecords (int : 1000 : IRW)
    // Maximum number of records to which a groupBy can be applied. If there are more records,
    // grouping will not be available via the default header context menu, and calls to
    // +link{listGrid.groupBy()} will be ignored.
    // <P>
    // The maximum exists because ListGrid grouping is performed in-browser, hence requires loading of
    // all records that match the current filter criteria before records can be grouped.  The default
    // maximum represents a number of records which are safe to load in legacy browsers such as Internet
    // Explorer 8 (modern browsers can handle far more), and is also a good upper limit from the
    // perspective of loading data from a database.
    // <P>
    // Going beyond this limit can cause "script running slowly" errors from legacy browsers (as well as
    // high database load).  To build an interface for grouping that handles arbitrary data volume, use
    // a TreeGrid with +link{treeGrid.loadDataOnDemand} with server-side grouping code.
    //
    // @group grouping
    // @see groupBy
    // @visibility external
    //<
    groupByMaxRecords: 1000,

    //> @attr listGrid.disabledGroupByPrompt (String : "Grouping is not supported for datasets of this size" : IRW)
    // Prompt to indicate that grouping is disabled as the
    // data set size exceeds +link{listGrid.groupByMaxRecords}.
    // <P>
    // This prompt will be shown as a hover for the disabled +link{canGroupBy,group by menu item}.
    // <P>
    // See also +link{listGrid.groupByMaxRecordsExceededMessage}.
    // 
    // @group i18nMessages
    // @visibility external
    //<
    disabledGroupByPrompt : "Grouping is not supported for datasets of this size",

    //> @attr listGrid.groupByMaxRecordsExceededMessage (String :  "Grouping has been disabled. This data set is too large to apply grouping efficiently." : IRW)
    // Warning shown to the user when a grouping attempt failed as the data set length exceeds
    // +link{listGrid.groupByMaxRecords}.
    // <P>
    // If defined, this prompt will be shown to the user in a +link{isc.warn(),warning dialog}
    // when the user attempts to group a data set that exceeds the
    // +link{listGrid.groupByMaxRecords} threshold.
    // <P>
    // This can occur if an already-grouped grid's filter criteria are modified such 
    // that a new set of records is loaded from the DataSource which exceeds the
    // +link{groupByMaxRecords} threshold.
    // <P>
    // It can also occur when a user attempts to group a grid with a partially loaded
    // data set where the true size of the data set is not known due to +link{progressiveLoading}.
    // In this case, the grouping logic will attempt to retrieve all the 
    // records in the data set and may get back a new total row count from the DataSource
    // which exceeds +link{listGrid.groupByMaxRecords}.
    // <P>
    // In either case the warning will be displayed to the user and the 
    // +link{canGroupBy,group by menu item} will be disabled.
    // <P>
    // See also +link{listGrid.disabledGroupByPrompt}.
    // 
    // @group i18nMessages
    // @visibility external
    //<
    groupByMaxRecordsExceededMessage : "Grouping has been disabled. This data set is too large to apply grouping efficiently.",

    //> @attr listGrid.groupByAsyncThreshold (int : 50 : IRW)
    // When grouping is requested with this number of records or more, an asynchronous approach is
    // used to avoid the browser showing a "script is running slowly.." message prompting the
    // user to stop execution of JavaScript.
    // <p>
    // Note that +link{groupByMaxRecords} must be set at least as high as +link{groupByAsyncThreshold}
    // or asynchronous grouping will never be used.
    // <p>
    // During async grouping, interactivity is blocked and the +link{asynchGroupingPrompt} is shown
    // to the user, then hidden when grouping completes; +link{groupByComplete} then fires.
    // <p>
    // Note that this async processing covers grouping <b>only</b> - it does not cover whole grid or
    // per-group summaries, client-side sort or filter, or other operations that may cause the browser
    // to show the "script is running slowly" prompt when working with very large sets of records in a
    // grid.
    // <p>
    // At this time, there is no generally effective way to avoid this warning dialog appearing with very
    // large datasets in Microsoft's Internet Explorer (IE).  IE's severely flawed detection algorithm for
    // runaway scripts has been shown to interrupt computations after only 0.2 seconds elapsed time
    // even if the computation would have finished in 0.3 seconds.  Optimizations that reduce
    // execution time can sometimes trigger the "script running slowly" dialog sooner.  Since not
    // every operation can reasonably be made asynchronous, the current recommendation is to avoid
    // working with overly large datasets until the affected versions of IE are obsoleted.
    // @visibility external
    //<
    groupByAsyncThreshold: 50,

    //> @attr listGrid.showAsynchGroupingPrompt (Boolean : null : IR)
    // If set to false, do not show the +link{asynchGroupingPrompt} dialog during
    // +link{groupByAsyncThreshold,asynchronous grouping}.
    // @visibility external
    //<

    //> @attr listGrid.asynchGroupingPrompt (HTMLString : "${loadingImage}&nbsp;Grouping data..." : IR)
    // The prompt to display while interactivity is blocked during +link{groupByAsyncThreshold,asynchronous grouping}.
    // @group i18nMessages
    // @visibility external
    //<
    asynchGroupingPrompt: "${loadingImage}&nbsp;Grouping data...",

    
    //> @attr listGrid.isGrouped (boolean : false : R)
    // True if this listGrid is grouped, false otherwise
    //
    // @group grouping
    // @visibility external
    // @see     groupBy
    //<

    //> @attr listGrid.nullGroupTitle (String : '-none-' : IRW)
    // Default alias to use for groups with no value
    //
    // @group grouping
    // @visibility external
    // @see     groupBy
    //<
    nullGroupTitle: "-none-",

    //> @attr listGrid.groupByField (String | Array of String : see below : IR)
    // List of fields to group grid records. If only a single field is used, that field
    // may be specified as a string. After initialization, use +link{listGrid.groupBy()}
    // to update the grouping field list, instead of modifying groupByField directly.
    // @group grouping
    // @visibility external
    // @see groupBy
    // @example dynamicGrouping
    //<


    // ----------------------
    // Value icons
    // The valueIcons object is a mapping between values and image URLs - when specified
    // we show the valueIcon image either next to, or instead of the normal cell value.

    //> @attr listGridField.valueIcons (Map<String,String> : null : IRW)
    // This property is a mapping from data values for this field to +link{SCImgURL,urls} for
    // icons to display for those data values.  
    // <p>
    // For example, given a field named "status" with possible values
    // "Normal", "Slow", "Offline", the follow definition would show various icons for that
    // field:
    // <P>
    // <smartclient>
    // <pre>
    // fields : [
    //     { name:"status",
    //       valueIcons: {
    //           Normal : "greenIcon.png",
    //           Slow : "yellowIcon.png",
    //           Offline : "redIcon.png"
    //       }
    //     },
    //     ... other fields ...
    // ]
    // </pre>
    // </smartclient>
    // <smartgwt>
    // <pre>
    // ListGridField statusField = new ListGridField("status");
    // statusField.setValueIcons(new HashMap&lt;String, String>() {{
    //    put("Normal", "greenIcon.png");
    //    put("Slow", "yellowIcon.png");
    //    put("Offline", "redIcon.png");
    // }});
    // </pre>
    // </smartgwt>
    // <p>
    // If a simple value-to-URL mapping is not enough, you can override +link{ListGrid.getValueIcon()}
    // to customize the behavior.  You can even specify an empty <code>valueIcons</code> map
    // and use +link{ListGrid.getValueIcon()} to return arbitrary icons with no fixed mapping.
    // <p>
    // <code>valueIcons</code> can either be displayed alongside the normal value or can
    // replace the normal field value so that only the icon is shown.  See
    // +link{listGridField.showValueIconOnly}.  When placed alongside the value, use
    // +link{valueIconOrientation} to control left- vs right-side placement.
    // <P>
    // If inline editing is enabled for this field, editors displayed for this field will also
    // show valueIcons.  This may be overridden by explicitly setting
    // +link{listGridField.editorValueIcons}.
    // <P>
    // Note that the following attributes related to valueIcon styling will also be picked up
    // by the editor from the ListGridField object unless explicitly specified via the
    // equivalent <code>editor_</code> attributes:<br>
    // +link{listGridField.valueIconWidth}<br>
    // +link{listGridField.valueIconHeight}<br>
    // +link{listGridField.valueIconSize}<br>
    // +link{listGridField.valueIconLeftPadding}<br>
    // +link{listGridField.valueIconRightPadding}<br>
    // +link{listGridField.imageURLPrefix}<br>
    // +link{listGridField.imageURLSuffix}
    // <P>
    // If +link{listGridField.valueIconClick()} is defined for the field, a pointer
    // cursor will be shown when the user rolls over the valueIcon, and the valueIconClick
    // method will execute when the user clicks the icon.
    //
    // @group imageColumns
    // @visibility external
    //<
    
    //> @method listGridField.valueIconClick()
    //
    // Executed when the user clicks on a +link{listGridField.valueIcons,value icon} within
    // this field. Return false to suppress default behavior of firing +link{recordClick} 
    // handlers, etc.
    //
    // @param   viewer      (ListGrid)  the listGrid that contains the click event
    // @param   record      (ListGridRecord)    the record that was clicked on
    // @param   recordNum   (number)    number of the record clicked on in the current set of
    //                                  displayed records (starts with 0)
    // @param   field       (ListGridField) the field that was clicked on (field definition)
    // @param   rawValue    (Any)   raw value of the cell (before valueMap, etc applied)
    // @param   editor      (FormItem) If this cell is being +link{listGrid.canEdit,edited}, 
    //  this method will fire when the user clicks the valueIcon on the edit item for the
    //  cell, passing in the editor item as the <code>editor</code> parameter. If the cell
    //  is not being edited, this value will be null.
    // @return  (boolean)   false to stop event bubbling
    //
    // @group   events
    //
    // @see attr:listGridField.valueIcons
    // @visibility external
    //<


    //> @attr listGrid.valueIconSize (number : 16 : IRW)
    // Default width and height of value icons for this ListGrid.
    // Can be overridden at the listGrid level via explicit +link{ListGrid.valueIconWidth} and
    // +link{ListGrid.valueIconHeight}, or at the field level via +link{ListGridField.valueIconSize},
    // +link{ListGridField.valueIconWidth} and {ListGridField.valueIconHeight}
    // @visibility external
    // @group imageColumns
    // @see ListGrid.valueIconWidth
    // @see ListGrid.valueIconHeight
    // @see ListGridField.valueIconSize
    //<
    valueIconSize:16,


    //> @attr listGrid.valueIconWidth (number : null : IRW)
    // Width for value icons for this listGrid.
    // Overrides +link{ListGrid.valueIconSize}.
    // Can be overridden at the field level
    // @group imageColumns
    // @visibility external
    //<

    //> @attr listGrid.valueIconHeight (number : null : IRW)
    // Height for value icons for this listGrid.
    // Overrides +link{ListGrid.valueIconSize}.
    // Can be overridden at the field level
    // @group imageColumns
    // @visibility external
    //<

    //> @attr listGridField.valueIconSize (number : null : IRW)
    // Default width and height of value icons in this field.
    // Takes precedence over valueIconWidth, valueIconHeight and valueIconSize specified at
    // the ListGrid level.
    // Can be overridden via +link{ListGridField.valueIconWidth} and {ListGridField.valueIconHeight}
    // @visibility external
    // @group imageColumns
    // @see ListGrid.valueIconSize
    // @see ListGridField.valueIconWidth
    // @see ListGridField.valueIconHeight
    //<

    //> @attr listGridField.valueIconWidth (number : null : IRW)
    // Width for value icons for this listGrid field.
    // Overrides +link{ListGrid.valueIconSize}, +link{ListGrid.valueIconWidth}, and
    // +link{ListGridField.valueIconSize}.
    // @group imageColumns
    // @visibility external
    //<

    //> @attr listGridField.valueIconHeight (number : null : IRW)
    // Height for value icons for this listGrid field.
    // Overrides +link{ListGrid.valueIconSize}, +link{ListGrid.valueIconHeight}, and
    // +link{ListGridField.valueIconSize}.
    // @group imageColumns
    // @visibility external
    //<

    //> @attr   listGridField.valueIconLeftPadding (number : null : IRW)
    // How much padding should there be on the left of valueIcons for this field
    // Overrides +link{listGrid.valueIconLeftPadding}
    // @group imageColumns
    // @see ListGridField.valueIcons
    // @visibility external
    //<

    //> @attr   listGridField.valueIconRightPadding (number : null : IRW)
    // How much padding should there be on the right of valueIcons for this field
    // Overrides +link{listGrid.valueIconRightPadding}
    // @group imageColumns
    // @see ListGridField.valueIcons
    // @visibility external
    //<

    //> @attr listGridField.editorValueIcons (Map<String,String> : null : IRW)
    // When some cell in this field is being edited, setting this property will specify the
    // value icons to display in the cell's editor. If unset, the editor's valueIcons
    // will be determined in the same way as it would be for a static cell.
    // @group imageColumns
    // @visibility external
    //<

    //> @attr listGridField.editorValueIconWidth (number : null : IRW)
    // When some cell in this field is being edited, setting this property will specify the
    // width for value icons in the cell's editor. If unset, the editor's valueIcon width and
    // height will be determined in the same way as it would be for a static cell.
    // @group imageColumns
    // @visibility external
    //<

    //> @attr listGridField.editorValueIconHeight (number : null : IRW)
    // When some cell in this field is being edited, setting this property will specify the
    // height for value icons in the cell's editor. If unset, the editor's valueIcon width and
    // height will be determined in the same way as it would be for a static cell.
    // @group imageColumns
    // @visibility external
    //<

    //> @attr listGridField.showValueIconOnly (boolean : null : IRW)
    // If this field has a valueIcons property specified, setting this property causes
    // the valueIcon for each value to be displayed in the cell without also showing the
    // record's value for the field.
    // <P>
    // If unset the default behavior is to show the icon only if an explicit valueMap is
    // specified as well in addition to a valueIcons map, otherwise show both the valueIcon and
    // value for the cell.
    // <P>
    // Note that if this field is editable +link{FormItem.showValueIconOnly} will be passed
    // through to editors displayed in this field.
    //
    // @group imageColumns
    // @see listGridField.valueIcons
    // @see listGridField.suppressValueIcon
    // @visibility external
    //<

    // NOTE: showValueIconOnly: the use cases are:
    // - represent a value as an icon only to minimize space
    // - show text, but add an icon as decoration, either to all values, or to emphasize some
    //   values for quicker scanning
    // The property 'showValueIconOnly' allows the developer to explicitly show the valueIcon
    // with or without text.  If showValueIconOnly is unset, we make the assumption that:
    // - if the field is *not* constrained to a fixed set of values (has no valueMap), there's
    //   no way to have icons for all the values, so the purpose of the icons is to add
    //   emphasis to certain values [so we show both text and images]
    // - otherwise the developer has an icon for every possible value, so there is no need for
    //   the value to also be displayed - we size the field large enough to accommodate the icon
    //   only, and suppress the text.

    //> @attr   listGridField.suppressValueIcon (boolean : null : IRW)
    // If this field has a valueIcons property specified, setting this property to true will
    // prevent the valueIcon being written out into this field's cells.
    // <P>
    // Note this property may also be set to false to avoid showing the standard
    // +link{listGrid.booleanTrueImage} and +link{listGrid.booleanFalseImage} for fields of type
    // <code>boolean</code>.
    //
    // @group imageColumns
    // @see listGridField.valueIcons
    // @see listGridField.showValueIconOnly
    // @visibility external
    //<

    //> @attr   listGridField.valueIconOrientation (String : null : IRW)
    // If we're showing a valueIcon for this field should it appear to the left or the right
    // of the text?  By default the icon will appear to the left of the textual value -
    // set this to "right" to show the icon on the right of the text.
    // Has no effect if +link{listGridField.showValueIconOnly} is true
    // @visibility external
    // @group imageColumns
    //<
    

    //> @attr   listGrid.valueIconLeftPadding (number : 2 : IRW)
    // How much padding should there be on the left of valueIcons by default
    // Can be overridden at the field level
    // @group imageColumns
    // @see ListGridField.valueIcons
    // @visibility external
    //<
    valueIconLeftPadding:2,

    //> @attr   listGrid.valueIconRightPadding (number : 2 : IRW)
    // How much padding should there be on the right of valueIcons by default
    // @group imageColumns
    // Can be overridden at the field level
    // @see ListGridField.valueIcons
    // @visibility external
    //<
    valueIconRightPadding:2,

    // ------------
    // Hilite Icons
    // ------------

    //> @attr listGrid.hiliteIcons (Array of String : ["[SKINIMG]/Dialog/notify.png", "[SKINIMG]/Dialog/warn.png", "[SKINIMG]/actions/approve.png"] : IR)
    // @include dataBoundComponent.hiliteIcons
    // @group hiliting
    // @visibility external
    //<

    //> @attr listGrid.hiliteIconPosition (HiliteIconPosition : "before" : IR)
    // @include dataBoundComponent.hiliteIconPosition
    // @group hiliting
    // @visibility external
    //<

    //> @attr listGrid.hiliteIconSize (number : 12 : IRW)
    // @include dataBoundComponent.hiliteIconSize
    // @group hiliting
    // @see hiliteIconWidth
    // @see hiliteIconHeight
    // @see ListGridField.hiliteIconSize
    // @visibility external
    //<

    //> @attr listGrid.hiliteIconWidth (number : null : IRW)
    // @include dataBoundComponent.hiliteIconWidth
    // @group hiliting
    // @visibility external
    //<

    //> @attr listGrid.hiliteIconHeight (number : null : IRW)
    // @include dataBoundComponent.hiliteIconHeight
    // @group hiliting
    // @visibility external
    //<

    //> @attr   listGrid.hiliteIconLeftPadding (number : 2 : IRW)
    // @include dataBoundComponent.hiliteIconLeftPadding
    // @group hiliting
    // @visibility external
    //<

    //> @attr   listGrid.hiliteIconRightPadding (number : 2 : IRW)
    // @include dataBoundComponent.hiliteIconRightPadding
    // @group hiliting
    // @visibility external
    //<

    //> @attr listGridField.hiliteIconPosition (HiliteIconPosition : null : IR)
    // When +link{listGrid.hiliteIcons} are present, where the hilite icon will be placed
    // relative to the field value.  See +link{type:HiliteIconPosition}.
    // Overrides +link{listGrid.hiliteIconPosition}.
    // @group hiliting
    // @visibility external
    //<

    //> @attr listGridField.hiliteIconSize (number : null : IRW)
    // Default width and height of +link{listGrid.hiliteIcons, hilite icons} in this field.
    // Takes precedence over hiliteIconWidth, hiliteIconHeight and hiliteIconSize specified at
    // the component level.
    // Can be overridden via +link{ListGridField.hiliteIconWidth} and
    // +link{ListGridField.hiliteIconHeight}
    // @group hiliting
    // @see ListGrid.hiliteIconSize
    // @see ListGridField.hiliteIconWidth
    // @see ListGridField.hiliteIconHeight
    // @visibility external
    //<

    //> @attr listGridField.hiliteIconWidth (number : null : IRW)
    // Width for hilite icons for this field.
    // Overrides +link{listGrid.hiliteIconSize}, +link{listGrid.hiliteIconWidth}, and
    // +link{ListGridField.hiliteIconSize}.
    // @group hiliting
    // @visibility external
    //<

    //> @attr listGridField.hiliteIconHeight (number : null : IRW)
    // Height for hilite icons for this field.
    // Overrides +link{listGrid.hiliteIconSize}, +link{listGrid.hiliteIconHeight}, and
    // +link{ListGridField.hiliteIconSize}.
    // @group hiliting
    // @visibility external
    //<

    //> @attr   listGridField.hiliteIconLeftPadding (number : null : IRW)
    // How much padding should there be on the left of +link{DataBoundComponent.hiliteIcons, hilite icons}
    // for this field?
    // Overrides +link{listGrid.hiliteIconLeftPadding}
    // @group hiliting
    // @visibility external
    //<

    //> @attr   listGridField.hiliteIconRightPadding (number : null : IRW)
    // How much padding should there be on the right of +link{DataBoundComponent.hiliteIcons, hilite icons}
    // for this field?
    // Overrides +link{listGrid.hiliteIconRightPadding}
    // @group hiliting
    // @visibility external
    //<


    

    //> @attr   ListGridField.imageURLPrefix (String : null : IRWA)
    // If this field has type [+link{type:ListGridFieldType}] set to <code>"image"</code>
    // and the URL for the image displayed is not absolute, the path of the URL will be relative
    // to this string<br>
    // Alternatively, if this field displays any valueIcons, this prefix will be applied to
    // the beginning of any +link{ListGridField.valueIcons} when determining the
    // URL for the image.
    // @group imageColumns
    // @visibility external
    // @example imageType
    //<

    //> @attr   ListGridField.imageURLSuffix (String : null : IRWA)
    // If any cells in this field are showing a value icon (see: +link{ListGridField.valueIcons})
    // or this is has +link{type:ListGridFieldType} set to <code>"image"</code>, the value
    // of this property will be appended to the end of the URL for the icon displayed.<br>
    // Typical usage might be to append a file type such as <code>".gif"</code> to the
    // filename of the image.<br>
    // For editable fields, this property will also be passed through to any editors as
    // +link{FormItem.imageURLSuffix}.
    // @group imageColumns
    // @visibility external
    // @example imageType
    //<

    //> @attr   ListGridField.editorImageURLPrefix (String : null : IRWA)
    // When some cell in this field is being edited, this property can be used to apply
    // an explicit +link{FormItem.imageURLPrefix} to the editor in question.
    // This can be used to modify the valueIcons within the editor.<br>
    // If unset, but +link{ListGridField.imageURLPrefix} is specified, that will be used
    // instead.
    // @group editing
    // @visibility external
    //<

    //> @attr   ListGridField.editorImageURLSuffix (String : null : IRWA)
    // When some cell in this field is being edited, this property can be used to apply
    // an explicit +link{FormItem.imageURLSuffix} to the editor in question.
    // This can be used to modify the valueIcons within the editor.<br>
    // If unset, but +link{ListGridField.imageURLPrefix} is specified, that will be used
    // instead.
    // @group editing
    // @visibility external
    //<

    //> @attr   listGrid.imageSize (number : 16 : IRW)
    // Default size of thumbnails shown for fieldTypes image and imageFile.  Overrideable on a
    // per-field basis via +link{attr:ListGridField.imageSize} or
    // +link{attr:ListGridField.imageWidth}/+link{attr:ListGridField.imageHeight}
    //
    // @group imageColumns
    // @visibility external
    //<
    imageSize: 16,

    //> @attr   listGridField.imageSize (number : 16 : IRW)
    // Size of images shown for fieldTypes image and imageFile in this field.
    // This setting overrides the global ListGrid default +link{attr:ListGrid.imageSize}.
    // <P>
    // If set to a String, assumed to be a property on each record that specifies the image
    // height.  For example, if <code>field.imageSize</code> is "logoSize",
    // <code>record.logoSize</code> will control the size of the image.
    //
    // @see attr:ListGridField.imageWidth
    // @see attr:ListGridField.imageHeight
    //
    // @group imageColumns
    // @visibility external
    //<

    //> @attr   listGridField.imageWidth (number : 16 : IRW)
    // Width of images shown for fieldTypes image and imageFile in this field.
    // <P>
    // If set to a String, assumed to be a property on each record that specifies the image
    // width.  For example, if <code>field.imageWidth</code> is "logoWidth",
    // <code>record.logoWidth</code> will control the width of the image.
    //
    // @see attr:ListGrid.imageSize
    // @see attr:ListGridField.imageSize
    // @see attr:ListGridField.imageHeight
    //
    // @group imageColumns
    // @visibility external
    //<

    //> @attr   listGridField.imageHeight (number : 16 : IRW)
    // Height of image shown for fieldTypes image and imageFile in this field.
    // <P>
    // If set to a String, assumed to be a property on each record that specifies the image
    // height.  For example, if <code>field.imageHeight</code> is "logoHeight",
    // <code>record.logoHeight</code> will control the height of the image.
    //
    // @see attr:ListGrid.imageSize
    // @see attr:ListGridField.imageSize
    // @see attr:ListGridField.imageWidth
    //
    // @group imageColumns
    // @visibility external
    //<

    // ListGridField
    // ---------------------------------------------------------------------------------------

    //  -- Define the 'listGridField' pseudo class for doc
    
    //> @object ListGridField
    // An ordinary JavaScript object containing properties that configures the display of
    // and interaction with the columns of a +link{ListGrid}.
    //
    // @see ListGrid.fields
    // @see ListGrid.setFields
    // @inheritsFrom DBCField
    // @treeLocation Client Reference/Grids/ListGrid
    // @visibility external
    //<

    //> @type ListGridFieldType
    // ListGrids format data for viewing and editing based on the <i>type</i> attribute of the
    // field.  This table describes how the ListGrid deals with the various built-in types.
    //
    // @value "text"    Simple text rendering for view.  For editing a text entry field is shown.
    // If the length of the field (as specified by the +link{attr:dataSourceField.length}
    // attribute) is larger than the value specified by +link{attr:listGrid.longTextEditorThreshold}, a
    // text input icon is shown that, when clicked on (or field is focused in) opens a larger
    // editor that expands outside the boundaries of the cell (textarea by default, but
    // overrideable via +link{ListGrid.longTextEditorType}).
    //
    // @value "boolean" For viewing and editing a checkbox is shown with a check mark for the
    // <code>true</code> value and no check mark for the <code>false</code> value. This behavior
    // may be suppressed by setting +link{listGridField.suppressValueIcon} for the field. See
    // +link{ListGrid.booleanTrueImage} for customization.
    //
    // @value "integer" A whole number, e.g. <code>123</code>. Consider setting
    // +link{listGridField.editorType,editorType} to use a +link{SpinnerItem}.
    //
    // @value "float" A floating point (decimal) number, e.g. <code>1.23</code>. 
    // Consider setting +link{listGridField.editorType,editorType} to use a +link{SpinnerItem}.
    //
    // @value "date" Field value should be a <code>Date</code> instance representing a logical
    // date, with no time of day information.  See +link{group:dateFormatAndStorage} for
    // details of the logical date type and how it is represented and manipulated.
    // <P>
    // Dates will be formatted using +link{listGridField.dateFormatter,ListGridField.dateFormatter}
    // if specified, otherwise
    // +link{ListGrid.dateFormatter,ListGrid.dateFormatter}.
    // If both these attributes are unset, dates are formatted
    // using the standard +link{DateUtil.setShortDisplayFormat(),short display format} for dates.
    // <P>
    // For editing, by default a +link{DateItem} is used with +link{DateItem.useTextField} set
    // to true, providing textual date entry plus a pop-up date picker. The
    // +link{DateItem.dateFormatter, dateFormatter} and +link{DateItem.inputFormat, inputFormat}
    // for the editor will be picked up from the ListGridField, if specified.
    //
    // @value "time" Field value should be a <code>Date</code> instance representing a logical
    // time, meaning time value that does not have a specific day and also has no timezone.  See
    // +link{group:dateFormatAndStorage} for details of the logical time type and how it is
    // represented and manipulated.
    // <P>
    // Times will be formatted using +link{listGridField.timeFormatter,ListGridField.timeFormatter}
    // if specified,
    // otherwise +link{ListGrid.timeFormatter,ListGrid.timeFormatter}.
    // <P>
    // If both these attributes are unset, times are formatted using the standard
    // +link{Time.shortDisplayFormat,short display format} for times.
    // <P>
    // For editing, by default a +link{TimeItem} is used. The
    // +link{TimeItem.timeFormatter, timeFormatter} for the editor will be picked up from
    // the ListGridField, if specified.
    //
    // @value "datetime" Field value should be a <code>Date</code> instance representing a
    // specific date and time value.  See +link{group:dateFormatAndStorage} for details of the
    // datetime type and how it is represented and manipulated.
    // <P>
    // Dates will be formatted using +link{listGridField.dateFormatter,ListGridField.dateFormatter}
    // if specified, otherwise
    // +link{ListGrid.datetimeFormatter,ListGrid.datetimeFormatter}.
    // If both these attributes are unset, dates are formatted
    // using the standard +link{DateUtil.setShortDatetimeDisplayFormat(),short display format} for
    // datetime values.
    // <P>
    // For editing, by default a +link{DateTimeItem} is used, providing textual date entry plus
    // a pop-up date picker.  The +link{DateItem.dateFormatter, dateFormatter} and
    // +link{DateItem.inputFormat, inputFormat} for the editor will be picked up from the
    // ListGridField, if specified.
    //
    // @value "sequence" Same as <code>text</code>
    //
    // @value "link"     Renders a clickable html link (using an HTML anchor tag: &lt;A&gt;).
    // The target URL is the value of the field, which is also the default display value.  You
    // can override the display value by setting +link{attr:listGridRecord.linkText} or
    // +link{attr:listGridField.linkText}.
    // <P>
    // Clicking the link opens the URL in a new window by default.  To change this behavior,
    // you can set <code>field.target</code>, which works identically to the "target"
    // attribute on an HTML anchor (&lt;A&gt;) tag.  See +link{listGridField.target} for more
    // information.
    // <P>
    // In inline edit mode, this type works like a text field.
    // <P>
    // To create a link not covered by this feature, consider using
    // +link{listGridField.formatCellValue()} along with +link{Canvas.linkHTML()}, or simply
    // +link{listGrid.getCellStyle,styling the field} to look like a link, and providing
    // interactivity via +link{listGridField.recordClick,field.recordClick()}.
    //
    // @value "image"   Renders a different image in each row based on the value of the field.  If
    // this URL is not absolute, it is assumed to be relative to
    // +link{ListGridField.imageURLPrefix} if specified. The size of the image is controlled by
    // +link{attr:listGridField.imageSize}, +link{attr:listGridField.imageWidth},
    // +link{attr:listGridField.imageHeight} (and by the similarly-named global default
    // attributes on the ListGrid itself).
    // <P>
    // You can also specify the following attributes on the field: <code>activeAreaHTML</code>, and
    // <code>extraStuff</code> - these are passed to +link{method:canvas.imgHTML} to generate the
    // final URL.
    // <P>
    // Note if you want to display icons <b>in addition to</b> the normal cell value, you
    // can use +link{listGridField.valueIcons,valueIcons} instead.
    //
    // @value "icon" Shows +link{listGridField.icon,field.icon} in every cell, and also in the
    // header.  Useful for a field that is used as a button, for example, launches a detail
    // window or removes a row.  Implement a +link{listGridField.recordClick,field.recordClick}
    // to define a behavior for the button.
    // <P>
    // NOTE: for a field that shows different icons depending on the field value, see
    // +link{listGridField.valueIcons}.
    // <P>
    // <code>type:"icon"</code> also defaults to a small field width, accommodating just the icon
    // with padding, and to a blank header title, so that the header shows the icon only.
    // <P>
    // +link{listGridField.iconWidth,field.iconWidth} and related properties configure
    // the size of the icon both in the header and in body cells.
    // <P>
    // If you want the icon to appear only in body cells and not in the header, set
    // +link{listGridField.cellIcon,field.cellIcon} instead, leaving field.icon null.
    //
    // @value "binary"  For viewing, the grid renders a 'view' icon (looking glass) followed by a
    // 'download' icon and then the name of the file is displayed in text.  If the user clicks the
    // 'view' icon, a new browser window is opened and the file is streamed to that browser
    // instance, using +link{dataSource.viewFile()}.  For images and other file types with
    // known handlers, the content is typically displayed inline - otherwise the browser will
    // ask the user how to handle the content.  If the download icon is clicked,
    // +link{dataSource.downloadFile()} is used to cause the browser to show a "save" dialog.
    // There is no inline editing mode for this field type.
    //
    // @value "imageFile"   Same as <code>binary</code>
    //
    // @value "summary" Show a calculated summary based on other field values within the
    //  current record. See +link{listGridField.recordSummaryFunction} for more information
    //
    // @value "any"       Fields of this type can contain any data value and have no default 
    // formatting or validation behavior. This is useful as the 
    // +link{SimpleType.inheritsFrom,parent type} for SimpleTypes
    // where you do not want any of the standard validation or formatting logic
    // to be inherited from the standard built-in types.
    //
    // @value "localeInt" An integer number with locale-based formatting, e.g. <code>12,345,678</code>.
    // See +link{group:localizedNumberFormatting,Localized Number Formatting}
    // for more info.
    // 
    // @value "localeFloat" A float number with locale-based formatting, e.g. <code>12,345.67</code>.
    // See +link{group:localizedNumberFormatting,Localized Number Formatting}
    // for more info.
    //
    // @value "localeCurrency" A float number with locale-based formatting and using currency
    // symbol, e.g. <code>$12,345.67</code>.
    // See +link{group:localizedNumberFormatting,Localized Number Formatting}
    // for more info.
    //
    // @value "phoneNumber" A telephone number.  Uses +link{formItem.browserInputType} "tel" to
    // hint to the device to restrict input.  On most mobile devices that have
    // software keyboards, this cause a specialized keyboard to appear which
    // only allows entry of normal phone numbers.  When displayed read-only,
    // a "phoneNumber" renders as an HTML link with the "tel:" URL scheme,
    // which will invoke the native phone dialing interface on most mobile
    // devices.  In addition, the CSS style "sc_phoneNumber" is applied.
    // <p>
    // By default, "phoneNumber" fields do not include validators, however the
    // following validator definition would limit to digits, dashes and the
    // "+" character:
    // xml:
    // <p>
    //     &lt;validator type="regexp" expression="^(\(?\+?[0-9]*\)?)?[0-9_\- \(\)]*$"
    //         errorMessage="Phone number should be in the correct format e.g. +#(###)###-##-##" /&gt;
    //     <smartclient>
    // <p>
    // or directly in JavaScript:
    // <p>
    // <pre>
    // {type:"regexp", expression:"^(\\(?\\+?[0-9]*\\)?)?[0-9_\\- \\(\\)]*$", 
    //     errorMessage:"Phone number should be in the correct format e.g. +#(###)###-##-##"}
    // </pre>
    // </smartclient>
    // <smartgwt>
    // <p>
    // or directly in Java:
    // <p>
    // <pre>
    // RegExpValidator v = new RegExpValidator();
    // v.setType(ValidatorType.REGEXP);
    // v.setErrorMessage("Phone number should be in the correct format e.g. +#(###)###-##-##");
    // v.setExpression("^(\\(?\\+?[0-9]*\\)?)?[0-9_\\- \\(\\)]*$");
    // </pre>
    // </smartgwt>
    // and adding "#" and "*" to the regular expressions above would allow for
    // users to enter special keys sometimes used for extension numbers or
    // pauses
    //
    // @see attr:listGridField.type
    // @see type:FieldType
    // @visibility external
    // @example gridsDataTypes
    //<

    //> @attr listGridField.type (ListGridFieldType : "text" : [IR])
    //  ListGrids picks a renderer for the view and edit mode of a field based on this attribute.
    //  See +link{ListGridFieldType} for a summary of how types are rendered.
    //
    //  @see type:ListGridFieldType
    //  @see type:FieldType
    //  @group  appearance
    //  @visibility external
    //<

    //> @attr listGridField.name
    // Name of this field.  Must be unique within the +link{ListGrid} as well as a valid
    // JavaScript identifier - see +link{FieldName} for details and how to check for validity.
    // <p>
    // The name of the field is also the property in each record which holds the record's value for
    // the field.
    // <p>
    // If a +link{ListGrid.dataSource} is specified and the +link{class:DataSource} has
    // a field with the same +link{DataSourceField.name, name}, the <code>ListGridField</code> and
    // +link{DataSourceField} are merged, with any properties on the
    // <code>ListGridField</code> overriding those on the <code>DataSourceField</code>.
    // @include DBCField.name
    // @visibility external
    //<

    //> @attr listGridField.dataPath (String : null : [IRA])
    // dataPath for this field. This property allows the grid to display details of nested data
    // structures in a flat list of columns.
    // @group data
    // @visibility external
    //<

    //> @attr listGridField.title
    // A title for this field, to display in the header for the field and in other
    // contexts such as the +link{listGrid.canPickFields,menu for picking visible fields}.
    // <smartclient>
    // Alternatively you can specify a +link{getFieldTitle()} method on the field to return the
    // HTML for the field title.
    // </smartclient>
    // <P>
    // Note: To customize the display of just the title in the header, use the
    // +link{listGridField.headerTitle} property instead so that other places where the title
    // appears in the UI are not affected.  For example, you might set <code>headerTitle</code>
    // to an empty string to suppress the header title on a narrow column, but you would retain
    // the normal title in the <code>title</code> property to avoid a blank menu item in the
    // field picker menu, +link{databoundComponent.editHilites,hilite editor}, and other contexts.
    // @include Field.title
    // @setter ListGrid.setFieldTitle()
    // @group  appearance
    // @visibility external
    //<

    //> @attr listGridField.showTitle (boolean : null : [IRW])
    // This property may be set to <code>false</code> to explicitly suppress display of
    // the field title in the column header button for the field.
    // @visibility external
    //<

    //> @method listGridField.getFieldTitle()
    // If your derivation of the field title is more complex than specifying a static string,
    // you can specify a getFieldTitle() method on your field to return the title string.
    // Otherwise you can use the +link{title} attribute on the field to specify the title.
    //
    // @param viewer (ListGrid) pointer back to the ListGrid
    // @param fieldNum (number) index of this field in the grid's fields array.
    // @return  (HTMLString) Field title.
    // @group appearance
    // @see attr:listGridField.title
    // @visibility external
    //<

    //> @attr listGridField.wrap (Boolean : null : [IRW])
    // Should the field title wrap if there is not enough space horizontally to accommodate it.
    // If unset, default behavior is derived from +link{listGrid.wrapHeaderTitles}.  (This is a
    // soft-wrap - if set the title will wrap at word boundaries.)
    // <P>
    // <b>Notes:</b><ul>
    // <li>If autofitting is active, +link{width} and +link{minWidth} can be set to control the
    // minimum field width - see the links for details.
    // <li>This feature is incompatible with +link{listGrid.clipHeaderTitles}, and
    // <code>clipHeaderTitles</code> will be disabled for wrapping fields.</ul>
    //
    // @see attr:listGrid.minFieldWidth
    // @visibility external
    //<

    //> @attr listGridField.rotateTitle (Boolean : null : [IR])
    // Whether to rotate the field's title so it's rendered vertically from bottom to top.
    // If unset, default behavior is derived from +link{listGrid.rotateHeaderTitles}.
    // @see listGrid.rotateHeaderTitles
    // @visibility external
    //<

    //> @attr listGridField.valign (VerticalAlignment : null : [IR])
    // Specifies vertical alignment in the column header for this field: "top", "center", or 
    // "bottom".  If unset, default behavior is derived from +link{listGrid.headerTitleVAlign}.
    // @see listGrid.rotateHeaderTitles
    // @visibility external
    //<

    //> @attr listGridField.cellPrompt (HTMLString : null : IRW)
    // HTML to show in a hover over cells in this field.  Useful for fixed hover text, such as 
    // a tooltip for an icon in a field of type "icon".  To show a custom prompt per cell,
    // see +link{listGridField.hoverHTML, hoverHTML}.
    // @visibility external
    //<

    //> @attr listGridField.aiHoverRequest (AIHoverRequest : null : IR)
    // If set and AI is +link{AI.isEnabled(), enabled}, the settings that configure requests to AI
    // to generate the contents of the hover displayed when the user hovers the mouse pointer
    // over a cell of the field.
    // <p>
    // Note: +link{ListGridField.showHover} must be <code>true</code> on this field, or
    // +link{ListGrid.showHover} must be <code>true</code> on the grid for the hovers to be
    // displayed.
    // <p>
    // While an AI request to generate hover text is pending, +link{ListGrid.placeholderAIHoverContents}
    // is used as the hover contents.
    // <p>
    // If the AI request is successful, then +link{ListGrid.aiHoverContentsPrefix} is prepended
    // to the AI-generated hover text, which is always HTML-escaped.<br>
    // If, however, the AI request is not successful, then the error message (see
    // +link{SummarizeValueResult.errorMessage}) will be displayed if available, otherwise the
    // +link{DataBoundComponent.defaultAsyncErrorHoverContents} will be displayed. Additionally,
    // properties on the hover when displaying error information can be specified with
    // +link{DataBoundComponent.asyncErrorHoverProperties}.
    // @example aiSummarizeOnHover
    // @visibility AI
    //<

    //> @attr listGridField.aiHoverContentsPrefix (HTMLString : null : IRW)
    // If set to a non-<code>null</code> value, override of +link{ListGrid.aiHoverContentsPrefix}
    // for this field.
    // @visibility AI
    //<

    //> @attr listGridField.hoverWrap (Boolean : null : IRW)
    // This property may be set to customize the <code>wrap</code> attribute for the
    // canvas shown when the mouse hovers over cells in this field. Note that this causes a 
    // soft-wrap - if set, the hover text will wrap at word boundaries.
    // <P>
    // If unset, default behavior is derived from +link{listGrid.headerHoverWrap}.
    // @visibility external
    //<

    //> @attr listGridField.hoverWidth (Integer : null : IRW)
    // Specifies the width of the canvas shown when the mouse hovers over cells in this field. 
    // <P>
    // If unset, default behavior is derived from +link{listGrid.headerHoverWidth}.
    // @visibility external
    //<

    //> @attr listGridField.target (String : "_blank" : IRW)
    // By default, clicking a link rendered by this item opens it in a new browser window.  You
    // can alter this behavior by setting this property.  The value of this property will be
    // passed as the value to the <code>target</code> attribute of the anchor tag used to render
    // the link.
    // <P>
    // If you set listGridField.target to "javascript", the default behavior is to catch and
    // consume mouse-clicks that would result in the link being followed.  Instead, the
    // +link{listGrid.cellClick()} event is fired for the containing cell.
    //
    // @visibility external
    //<

    //> @method listGridField.showIf()
    // An optional +link{group:stringMethods,stringMethod} which if provided, is evaluated to
    // conditionally determine whether this field should be displayed.
    // Evaluated on initial draw, then reevaluated on explicit
    // calls to <code>listGrid.refreshFields()</code> or <code>listGrid.setFields()</code>.
    // <P>
    // Use <code>+link{listGridField.hidden,hidden}:true</code> or <code>showIf:"false"</code>
    // to set a ListGrid field to initially hidden.<br>
    // The user will still be able to show the field via a context menu. 
    // This may be suppressed by setting +link{listGridField.canHide} to false, or by 
    // setting +link{listGrid.canPickFields} to false to suppress the
    // field-picker entirely.
    // <P>
    // Note that explicit calls to +link{listGrid.showField,grid.showField()} or hideField()
    // will wipe out the <code>showIf</code> expression, as will the end user showing and
    // hiding columns via the +link{listGrid.showHeaderContextMenu,header contextMenu}.
    // <P>
    // Also note that fields marked as +link{DataSourceField.detail,detail:true} will be hidden by
    // default even if +link{ListGrid.showDetailFields} is <code>true</code>. To show detail fields
    // inherited from a DataSource, include an explicit field definition for the field and
    // set this property to return <code>true</code>.
    // <P>
    // Note that the +link{listGridField.visibleWhen} attribute also exists as a criteria-based
    // way to dynamically determine field visibility.
    //
    // @param list (ListGrid) A pointer to the listGrid containing the field
    // @param field (ListGridField) the ListGridField object
    // @param fieldNum (Integer) the index of the field
    // @return (boolean) whether the field should be shown
    //
    // @group appearance
    // @see method:ListGrid.refreshFields
    // @visibility external
    //<

    //> @attr listGridField.hidden  (Boolean : null : IR)
    // Marks field as initially hidden.<br>
    // The user will still be able to show the field via a context menu. 
    // This may be suppressed by setting +link{listGridField.canHide} to false, or by 
    // setting +link{listGrid.canPickFields} to false to suppress the
    // field-picker entirely.
    // <p>
    // To mark a field as completely hidden (not shown to a user at all, in any component), set
    // +link{DataSourceField.hidden} instead.
    //
    // @group appearance
    // @visibility external
    //<


    //> @attr listGridField.visibleWhen (Criteria : null : IR)
    // Criteria to be evaluated to determine whether this field should be visible.
    // <P>
    // This criteria is dynamic and will be renterpreted each time the rule context changes.
    // Note that calling +link{listGrid.showField()} or +link{listGrid.hideField()} explicitly
    // will cause any visibleWhen attribute to be dropped.
    //
	// @group ruleCriteria
	// @visibility external
    //<

    //> @attr listGridField.enableWhen (Criteria : null : IR)
    // +link{group:ruleCriteria,Rule Criteria} to be evaluated that controls whether this field will be enabled.
    // <P>
    // When the criteria evaluates to false, the field is disabled:
    // <ul>
    //   <li>The field header is disabled. Users cannot sort, resize, reorder, open the header context menu,
    //       or otherwise interact with the header. </li>
    //   <li>The field’s cells are disabled for interaction. If the field is normally editable,
    //       it cannot be edited while disabled. </li>
    //   <li>The field remains visible; to hide a field use visible, showIf, or visibleWhen.</li>
    // </ul>
    // <P>
    // What still works while disabled
    // <ul>
    //   <li>Normal clicks that begin row editing still enter edit mode for the record,
    //       but the disabled field will not present an editor.</li>
    //   <li>Normal row/record selection and navigation still work (for example, clicking cells to select rows).</li>
    // </ul>
    // <P>
    // Scope and re-evaluation
    // <ul>
    //   <li>The rule is evaluated in the ListGrid’s ruleScope. When values in the ruleScope change,
    //       the rule is re-evaluated and the field’s enabled/disabled state updates accordingly.</li>
    // </ul>
    // <P>
    // Notes
    // <ul>
    //   <li>Applies to the entire field (column). It does not provide per-record or per-cell enablement.</li>
    //   <li>Use visibleWhen to control visibility instead of enablement.</li>
    //   <li>Disabling affects user interaction on the field header and contents; programmatic API calls can
    //       still modify data unless your application logic prevents it.</li>
    // </ul>
    // <P>
    // Typical uses
    // <ul>
    //   <li>Temporarily disable a column’s interactions until prerequisites are met
    //       (for example, a filter or selection is required).</li>
    //   <li>Prevent edits to a column based on user role or application state while keeping the column visible.</li>
    // </ul>
    //
	// @group ruleCriteria
	// @visibility external
    //<

    //> @attr listGridField.readOnlyWhen (Criteria : null : IR)
    // Criteria to be evaluated to determine whether this field should be editable.
    // <P>
    // This criteria is dynamic and will be renterpreted each time the rule context changes.
    //
	// @group ruleCriteria
	// @visibility reify
    //<

    //> @attr listGridField.frozen (boolean : null : IR)
    // Whether this field should be "frozen" for the purposes of horizontal scrolling.  See
    // +link{group:frozenFields}.
    //
    // @group frozenFields
    // @visibility external
    //<

    //> @attr listGridField.canFreeze (boolean : null : IR)
    // Whether this field should display freezing/unfreezing options in its header context menu.
    // See +link{group:frozenFields}.
    // @see method:listGrid.getHeaderContextMenuItems()
    // @group frozenFields
    // @visibility external
    //<

    //> @attr listGridField.autoFreeze (boolean : null : IR)
    // Whether this field should be automatically frozen when other fields are frozen.  When
    // true, the field will be automatically frozen to the extreme of the grid.  The
    // automatically generated +link{listGrid.checkboxField, checkbox},
    // +link{listGrid.expansionField, expansion} and
    // +link{listGrid.rowNumberField, rowNumber} fields are examples of fields that specify
    // <code>autoFreeze: true</code>.
    // <P>
    // You can control the position of this field in the array of frozen fields by providing a
    // +link{listGridField.getAutoFreezePosition} implementation.
    // @group frozenFields
    // @visibility external
    //<

    //> @method listGridField.getAutoFreezePosition()
    // When a field has +link{listGridField.autoFreeze,autoFreeze} set to true, developers can
    // implement this method to indicate where in the frozen-fields array this field should
    // appear.
    // <P>
    // Some automatically generated fields, such as
    // +link{listGrid.rowNumberField, rowNumberField},
    // +link{listGrid.expansionField, expansionField} and
    // +link{listGrid.checkboxField, checkboxField}, provide default implementations of this
    // method.
    // @return (number) the index at which this autoFreeze field should appear in the frozen body
    // @group frozenFields
    // @visibility external
    //<

    //> @attr listGridField.canHide (boolean : null : IRW)
    // If set to false, this field will be omitted from the column picker that appears in the
    // header context menu when +link{listGrid.canPickFields} is enabled.  This means that the
    // end user will not be able to hide it if it's currently shown, or show it if it's
    // currently hidden.
    // <P>
    // If this property is set to <code>false</code>, and the 
    // +link{listGrid.useAdvancedFieldPicker,advanced field picker} is shown, if the field
    // is +link{hidden}, the field will not show in the list of available fields. If the
    // field is visible, it will be displayed in the list of currently visible fields, but
    // the advanced field picker user interface will disallow hiding it.
    //
    // @see method:listGrid.getHeaderContextMenuItems()
    // @group appearance
    // @visibility external
    //<

    //> @attr listGridField.canDragResize (boolean : null : IR)
    // Whether this field can be dragResized using the mouse.  If unset, the default behavior
    // is governed by +link{listGrid.canResizeFields}.
    // @visibility external
    //<

    //> @attr listGridField.canReorder (boolean : null : IR)
    // Whether this field can be reordered using the mouse.  If unset, the default behavior is
    // governed by +link{listGrid.canReorderFields}.  Note that setting this property to
    // <code>false</code> will lock this field from being moved - that is, the user is
    // prevented from moving this field directly by dragging with the mouse, or by dropping
    // another field onto this field.
    // <P>
    // Note that setting <code>canReorder:false</code> on a field in the middle of a grid is
    // mostly useless, since it's possible that such a "locked" field may still be reordered
    // automatically, as a result of the user dragging one unlocked field onto another unlocked
    // field.
    // <P>
    // Fields in +link{listGrid.headerSpans,headerSpans} are treated as if they have
    // <code>canReorder:false</code> to keep the fields in the span together, except that
    // unlocked fields not in a span may be drag-reordered across them, even if they're at the
    // header's extreme left or right.  HeaderSpans themselves may not be drag-reordered.
    // @group dragging
    // @visibility external
    //<

    //> @attr listGridField.ignoreKeyboardClicks (boolean : null : IRW)
    // If the user is navigating through the grid using the keyboard, record click or double click
    // events may be generated via keyboard interactions (see +link{listGrid.generateClickOnSpace},
    // +link{listGrid.generateClickOnEnter}, +link{listGrid.generateDoubleClickOnSpace},
    // +link{listGrid.generateDoubleClickOnEnter} and +link{listGrid.arrowKeyAction}).
    // <P>
    // These synthetic events have both a target row and column.
    // Setting this flag to true ensures that this field will never be considered the target for
    // a keyboard click event.
    // @group events
    // @visibility external
    //<
    
    

    //> @attr listGridField.excludeFromState
    // @include dataSourceField.excludeFromState
    // @see ListGrid.getViewState()
    //<

     
    //> @attr listGridField.excludeFromFieldPicker
    // @include dataSourceField.excludeFromFieldPicker
    //<

    // Grid, Group and Record-level summaries
    // ---------------------------------------------------------------------------------------

    //> @attr listGridField.showGridSummary (Boolean : null : IR)
    // If +link{listGrid.showGridSummary} is true, should this field show a summary value.
    // If unset, this field will show a summary value in the summary row if an
    // explicit +link{listGridField.summaryFunction} is specified or if a
    // +link{SimpleType.getDefaultSummaryFunction(),default summary function} is defined
    // for the specified field type.
    // @visibility external
    //<

    //> @attr listGridField.showGroupSummary (boolean : null : IR)
    // If +link{listGrid.showGroupSummary} is true, should this field show a summary value
    // in a summary row when the grid is grouped?
    // If unset, this field will show a summary value in the summary row if an
    // explicit +link{listGridField.summaryFunction} is specified or if a
    // +link{SimpleType.getDefaultSummaryFunction(),default summary function} is defined
    // for the specified field type.
    // @visibility external
    //<

    //> @attr listGridField.summaryFunction (SummaryFunction | Array of SummaryFunction : null : IR)
    // If +link{listGrid.showGridSummary} or +link{listGrid.showGroupSummary} is true,
    // this attribute can be used to specify
    // an explicit +link{type:SummaryFunction} for calculating the summary value to
    // display.
    // <P>
    // If an array of summaryFunctions is specified, they will be executed in turn and the
    // grid will show multiple summary rows at the grid or group level (or both)
    // containing the resulting values.
    // @visibility external
    //<

    //> @attr listGridField.summaryValueTitle (String : null : IR)
    // If +link{listGrid.showGridSummary} or +link{listGrid.showGroupSummary} is true and the
    // +link{listGridField.summaryFunction} is set to <code>"title"</code>, this attribute may be
    // set to a string to display in the group and/or grid summary. If unspecified the
    // +link{listGridField.title} will show up in the summary.
    // @visibility external
    //<

    //> @method listGridField.getGridSummary() [A]
    // If +link{listGrid.showGridSummary} is true, and this method is specified it will be
    // called to generate the summary value to be displayed in the grid summary row. Note that
    // this is called instead of making use of the +link{listGridField.summaryFunction}.
    // <P>
    // As with +link{listGrid.getGridSummary()} this method may return an array of results -
    // in this case each result will show up in a separate row in the +link{listGrid.summaryRow}
    // grid.
    // <P>
    // If this grid is grouped, and +link{listGrid.showGroupSummary} is true, this method
    // will be passed a third parameter - an array of group-level summaries.
    // @param records (Array of ListGridRecord) records for which a summary is being generated
    // @param field (ListGridField) pointer to the field for which summary value is being generated
    // @param [groupSummaries] (Array of Object) If this grid is grouped and
    //  +link{listGrid.showGridSummary} is specified, this parameter contains an array of already-
    //  calculated summary values for each group in the grid. Each element in this array will
    //  be an object containing calculated summary values for each field in the grid, as well as
    //  a specified groupValue and groupName, allowing the developer to determine which group this
    //  summary value comes from
    // @return (Any) summary value to display.
    // @visibility external
    //<

    //> @attr listGridField.formatGridSummary (StringMethod : null : IR)
    // Optional stringMethod to format the summary value displayed
    // in the +link{listGrid.showGridSummary,grid summary}.
    // Takes a single parameter <code>value</code> and should return the formatted version
    // of that value. If specified this will be applied instead of any formatting logic applied
    // via +link{listGridField.formatCellValue()}, +link{listGrid.formatCellValue()}, etc.
    // <P>
    // Note that for fields with a specified summary function of "count", if no custom formatting
    // is applied, we default to formatting the count value by appending
    // <code>field.pluralTitle</code> if defined, otherwise <code>field.title</code> to the
    // numeric count value returned by the standard count function. To change this behavior for
    // such fields, specify an explicit 'formatGridSummary' and/or 'formatGroupSummary' method
    // @visibility external
    //<

    //> @method listGridField.getGroupSummary() [A]
    // If +link{listGrid.showGroupSummary} is true, and this method is specified it will be
    // called to generate the field summary value to be displayed for each group level summary row.
    // Note that this is called instead of making use of the +link{listGridField.summaryFunction}.
    // <P>
    // This method may return an array of results - in this case the group will show multiple summary
    // rows, with each entry in the array showing up in a different record.
    //
    // @param records (Array of ListGridRecord) records for which a summary is being generated
    //  (so all records in the group).
    // @param field (ListGridField) pointer to the field for which summary value is being generated
    // @param [groupNode] (Object) object with specified groupValue and groupName for this group
    // @return (Any) summary value to display
    // @visibility external
    //<

    //> @attr listGridField.formatGroupSummary (StringMethod : null : IR)
    // Optional stringMethod to format the group level summary values for this field displayed via
    // +link{listGrid.showGroupSummary}.
    // Takes a single parameter <code>value</code> and should return the formatted version
    // of that value.  If specified this will be applied instead of any formatting logic applied
    // via +link{listGridField.formatCellValue()}, +link{listGrid.formatCellValue()}, etc.
    // <P>
    // Note that for fields with a specified summary function of "count", if no custom formatting
    // is applied, we default to formatting the count value by appending
    // <code>field.pluralTitle</code> if defined, otherwise <code>field.title</code> to the
    // numeric count value returned by the standard count function. To change this behavior for
    // such fields, specify an explicit 'formatGridSummary' and/or 'formatGroupSummary' method
    // @visibility external
    //<

    //> @method listGridField.getRecordSummary() [A]
    // Only applies to +link{listGridFieldType,"summary"-type} fields. If specified, this
    // method will be called to generate the record summary value to be displayed for each row
    // in this field.  When this method is called, current values for other record summary
    // fields have not necessarily been stored on the record, but are accessible via
    // +link{listGrid.getRecordSummary()}.
    // <P>
    // The grid is passed to be able to evaluate dependency record summary values via
    // ListGrid.getRecordSummary(). Other than that, the properties and state of the grid should
    // not be used in the implementation of this method. To do so would be a source of undefined
    // behavior.
    // <P>
    // Note that if implemented, this is called instead of making use of the
    // +link{listGridField.recordSummaryFunction}.
    // <P>
    // If +link{listGrid.showGridSummary} or +link{listGrid.showGroupSummary} is true, this
    // field's value in the summary row[s] will still be calculated by calling this method.
    // In this case, the record object passed in will contain summary values for each field.
    // If custom handling is required for this case, it may be detected by checking the
    // record object's +link{listGridRecord.isGroupSummary} and +link{listGridRecord.isGridSummary}
    // attributes.
    
    //
    // @param record (ListGridRecord) record for which a summary is being generated
    // @param field (ListGridField) this field
    // @param grid (ListGrid) the grid
    // @return (Any) summary value to display
    
    // @visibility external
    //<

    

    //> @attr listGridField.recordSummaryFunction (RecordSummaryFunction : null : IR)
    // Only applies to fields of type <code>"summary"</code>.
    // Fields of this type will display a calculated value based on the other field values
    // within the current record.
    // <P>
    // This attribute specifies how the summary field value will be calculated. See
    // +link{type:RecordSummaryFunction} for valid options.
    // <P>
    // A subset of the ListGrid's fields will be passed to the RecordSummaryFunction.
    // <P>
    // The fields to be used for the summary calculation can be determined either by explicitly 
    // listing them (+link{listGridField.includeInRecordSummaryFields}), or by setting 
    // +link{listGridField.includeInRecordSummary} to true on fields that should be included and 
    // false on fields that should not.  
    // <P>
    // By default, all visible fields of numeric type are used.  Note that, in this mode, if the 
    // user is able to hide some fields, this could change the formula.  If this isn't desirable, 
    // consider setting +link{listGridField.canHide} to prevent fields from being hidden.  
    // Consider this even if fields to include in the summary are explicitly listed, as hidden 
    // fields involved in a visible calculation can be confusing for an end user.
    // <P>
    // If +link{listGrid.showGridSummary} or +link{listGrid.showGroupSummary} is true, this
    // field's value in the summary row[s] will still be calculated by calling this method.
    // In this case, the record object passed in will contain summary values for each field.
    // If custom handling is required for this case, it may be detected by checking the
    // record object's +link{listGridRecord.isGroupSummary} and +link{listGridRecord.isGridSummary}
    // attributes.
    // @see listGrid.recordSummaryAttributePrefix
    // @visibility external
    //<

    //> @attr listGridField.partialSummary (boolean : null : IR)
    // Only applies to fields of type <code>"summary"</code>.
    // This attribute is set on a summary field, when calculating the summary value from
    // some record, the summary function will only be passed the fields before this summary field.
    // This may be useful for displaying running totals across a record.
    // <P>
    // Note that this feature would typically be used with
    // +link{listGrid.canReorderFields,canReorderFields:false}
    // @visibility external
    //<

    //> @attr listGridField.includeInRecordSummary (boolean : null : IR)
    // If a listGrid is showing a field of type summary, should this field be passed to the
    // recordSummaryFunction when calculating the summary value to display.
    // If unset, fields are included if they are of type "integer" or "float" only (since most
    // summary functions perform numeric calculations). See also
    // +link{listGridField.includeInRecordSummaryFields}.
    // @visibility external
    //<
    //> @attr listGridField.includeInRecordSummaryFields (Array of FieldName : null : IR)
    // If this listGrid has any fields of type <code>"summary"</code> and
    // this field will be +link{listGridField.includeInRecordSummary,included} in summary calculations
    // by default, this attribute provides an opportunity to explicitly specify which summary fields
    // the record should be displayed in.
    // <P>
    // Specified as an array of fieldNames. If set, this field value will only be included for
    // record summary value calculations for summary fields whose name is included in this array.
    // @visibility external
    //<
    

    //> @attr listGridField.applyAfterSummary (Boolean : null : IRW)
    // If +link{listGridField.userFormula} is set for this field, and this grid is showing
    // +link{listGrid.showGroupSummary,group summaries} or a
    // +link{listGrid.showGridSummary,grid summary}, this property determines what field value
    // should be present in those summary rows. Should the field's user-formula be applied to the
    // calculated summary row (applyAfterSummary <code>true</code>), or should a standard
    // grid or group summary be applied to the user-formula values displayed in the grid
    // (applyAfterSummary <code>false</code>)?
    // <P>
    // Default behavior may be specified at the grid level via +link{listGrid.applyFormulaAfterSummary}
    // @visibility external
    //<

    // Header button icons
    // ---------------------------------------------------------------------------------------
    // Include all relevant docs from StatefulCanvas

    //> @attr listGridField.icon (SCImgURL: null : [IR])
    // Optional icon to show next to the title for this field.
    // Should be set to a URL to an image. Relative paths will be evaluated starting at
    // the imgDir of this component. This URL is partial - it may be updated to indicate
    // the current disabled (etc) state of the field.
    // <p>
    // If +link{listGridField.type,field.type} is set to "icon", this icon will also be shown
    // in every cell of this field - see also +link{listGridField.cellIcon,field.cellIcon}.
    // <p>
    // To change this property after fields have been passed to +link{listGrid.setFields()},
    // use +link{listGrid.setFieldIcon()}.
    //
    // @visibility external
    //<

    //> @attr listGridField.iconSize (Integer : null : [IR])
    // If +link{listGridField.icon} is specified, this property can be used to specify the
    // size of the icon to be displayed in the ListGrid header button.
    // (See +link{StatefulCanvas.iconSize})
    // @see listGridField.icon
    // @visibility external
    //<

    //> @attr listGridField.iconWidth (Integer : null : [IR])
    // If +link{listGridField.icon} is specified, this property can be used to specify the
    // width of the icon to be displayed in the ListGrid header button.
    // (See +link{StatefulCanvas.iconWidth})<br>
    // If this field is editable, and +link{ListGridField.editorIconWidth} is unset, this
    // property will be passed onto the editors for this field as +link{FormItem.iconWidth},
    // which will effect the default size for +link{ListGridField.icons, icons} displayed
    // in the editor.
    // @see listGridField.icon
    // @see listGridField.icons
    // @visibility external
    //<

    //> @attr listGridField.iconHeight (Integer : null : [IR])
    // If +link{listGridField.icon} is specified, this property can be used to specify the
    // height of the icon to be displayed in the ListGrid header button.
    // (See +link{StatefulCanvas.iconHeight})<br>
    // If this field is editable, and +link{ListGridField.editorIconHeight} is unset, this
    // property will be passed onto the editors for this field as +link{FormItem.iconWidth},
    // which will effect the default size for +link{ListGridField.icons, icons} displayed
    // in the editor.
    // @see listGridField.icon
    // @see listGridField.icons
    // @visibility external
    //<

    //> @attr listGridField.iconOrientation (String : "left" : [IR])
    // If this field is showing an icon, should it appear to the left or right of the title?<br>
    // Valid options are <code>"left"</code> or <code>"right"</code>
    // @see listGridField.icon
    // @visibility external
    //<
    // iconOrientation JS doc not included from statefulCanvas as that refers to
    // setIconOrientation(), and we don't have an exposed way to get at the ListGrid field
    // header button at runtime.

    //> @attr listGridField.iconSpacing (int : 6 : [IR])
    // @include statefulCanvas.iconSpacing
    // @see listGridField.icon
    // @visibility external
    //<

    //> @attr listGridField.showDisabledIcon (Boolean : true : [IR])
    // @include statefulCanvas.showDisabledIcon
    // @see listGridField.icon
    // @visibility external
    //<

    //> @attr listGridField.showRollOverIcon (Boolean : false : [IR])
    // @include statefulCanvas.showRollOverIcon
    // @see listGridField.icon
    // @visibility external
    //<

    //> @attr listGridField.showFocusedIcon (Boolean : false : [IR])
    // @include statefulCanvas.showFocusedIcon
    // @see listGridField.icon
    // @visibility external
    //<

    //> @attr listGridField.showDownIcon (Boolean : false : [IR])
    // @include statefulCanvas.showDownIcon
    // @see listGridField.icon
    // @visibility external
    //<

    //> @attr listGridField.showSelectedIcon (Boolean : false : [IR])
    // @include statefulCanvas.showSelectedIcon
    // @see listGridField.icon
    //  @visibility external
    //<

    //> @attr listGridField.cellIcon (SCImgURL : null : [IR])
    // For a field of type:"icon" only, set the icon that appears in body cells.  Unless
    // setting +link{listGridField.icon,field.icon}, setting field.cellIcon will not show an
    // icon in the header.
    // <p>
    // To change this property after fields have been passed to +link{listGrid.setFields()},
    // use +link{listGrid.setFieldCellIcon()}.
    //
    // @visibility external
    //<

    //> @attr   listGridField.iconCursor       (Cursor : null : IRWA)
    // Specifies the cursor to display when the mouse pointer is over an icon image in a cell
    // for either a field of type +link{listGridField.icon,icon} or a 
    // +link{listGridField.valueIcons,valueIcon}.
    // <P>
    // If not explicitly specified, see +link{listGrid.getIconCursor()} for how <code>"icon"</code>
    // fields determine icon image cursors, and +link{listGrid.getValueIconCursor()} for how
    // value icon image cursors are determined.
    //
    //  @visibility external
    //<


    //> @attr listGridField.showFileInline (boolean : null : [IR])
    // For a field of type:"imageFile", indicates whether to stream the image and display it
    // inline or to display the View and Download icons.
    //
    // @visibility external
    //<

    //> @attr listGridField.showEllipsisWhenClipped (Boolean : null : IRW)
    // Should ellipses be displayed when this field's cell content is clipped? To set this 
    // property at the grid level, use +link{listGrid.showEllipsisWhenClipped}
    // @visibility external
    //<
    
    //> @attr listGridField.format (FormatString : null : IR)
    // +link{FormatString} for numeric or date formatting.  See +link{dataSourceField.format}.
    // @group exportFormatting
    // @visibility external
    //<

    //> @attr listGridField.exportFormat (FormatString : null : IR)
    // +link{FormatString} used during exports for numeric or date formatting.  See
    // +link{dataSourceField.exportFormat}.
    // @group exportFormatting
    // @visibility external
    //<

    // FormItem icons
    // ---------------------------------------------------------------------------------------

    //> @attr listGridField.icons (Array of FormItemIcon Properties: null : [IRA])
    // If this field is editable, this property can be used to specify
    // +link{FormItem.icons, icons} to be displayed in the editors displayed for this field
    // @group editing
    // @visibility external
    //<

    //> @attr listGridField.editorIconWidth (number : null : [IRA])
    // If this field is editable, this property will be passed to editors displayed for
    // cells within this field as +link{FormItem.iconWidth}.<br>
    // If this property unset, the iconWidth property from the editor can be picked up from
    // +link{listGridField.iconWidth} instead.
    // @see listGridField.icons
    // @group editing
    // @visibility external
    //<

    //> @attr listGridField.editorIconHeight (number : null : [IRA])
    // If this field is editable, this property will be passed to editors displayed for
    // cells within this field as +link{FormItem.iconHeight}.<br>
    // If this property unset, the iconHeight property from the editor can be picked up from
    // +link{listGridField.iconHeight} instead.
    // @see listGridField.icons
    // @group editing
    // @visibility external
    //<

    //> @attr listGridField.defaultIconSrc (String : null : [IRA])
    // If this field is editable, this property will be passed to editors displayed for
    // cells within this field as +link{FormItem.defaultIconSrc}.
    // @see listGridField.icons
    // @group editing
    // @visibility external
    //<

    //> @attr listGridField.iconPrompt (String : null : [IRA])
    // If this field is editable, this property will be passed to editors displayed for
    // cells within this field as +link{FormItem.iconPrompt}.
    // @see listGridField.icons
    // @group editing
    // @visibility internal
    //<

    //> @attr listGridField.iconHSpace (String : null : [IRA])
    // If this field is editable, this property will be passed to editors displayed for
    // cells within this field as +link{FormItem.iconHSpace}.
    // @see listGridField.icons
    // @group editing
    // @visibility internal
    //<

    //> @attr listGridField.iconVAlign (String : null : [IRA])
    // If this field is editable, this property will be passed to editors displayed for
    // cells within this field as +link{FormItem.iconVAlign}.
    // @see listGridField.icons
    // @group editing
    // @visibility external
    //<

    // editor picker icon
    
    //> @attr listGridField.showPickerIcon (boolean : null : [IRA])
    // If this field is editable, this property will be passed to editors displayed for
    // cells within this field as +link{FormItem.showPickerIcon}.
    // @group editing
    // @visibility pickerIcon
    //<

    //> @attr listGridField.pickerIconSrc (String : null : [IRA])
    // If this field is editable, this property will be passed to editors displayed for
    // cells within this field as +link{FormItem.pickerIconSrc}.
    // @group editing
    // @visibility pickerIcon
    //<

    //> @attr listGridField.pickerIconWidth (Integer : null : [IRA])
    // If this field is editable, this property will be passed to editors displayed for
    // cells within this field as +link{FormItem.pickerIconWidth}.
    // @group editing
    // @visibility pickerIcon
    //<

    //> @attr listGridField.pickerIconHeight (Integer : null : [IRA])
    // If this field is editable, this property will be passed to editors displayed for
    // cells within this field as +link{FormItem.pickerIconHeight}.
    // @group editing
    // @visibility pickerIcon
    //<

    // Summary Title
    // ---------------------------------------------------------------------------------------

    //> @attr listGridField.summaryTitle (String : null : [IRWA])
    // Optional long summary title for this field, provided in addition to
    // +link{listGridField.title}. This gives the developer an option to use a very short,
    // or empty title for the ListGrid column (where space may be a factor), but have a longer
    // value available to be used elsewhere.
    // <p>
    // By default this value will be used for the title of the context-menu item
    // for showing/hiding the listGrid field when the user right-clicks on the ListGrid header.
    //
    // @group appearance
    // @see attr:listGridField.title
    // @deprecated Rather than customizing the summaryTitle developers should typically use
    //  the +link{listGridField.headerTitle} attribute to show a different
    //  title in the column header button than the title used elsewhere.
    // @visibility external
    //<

    //> @method listGridField.getSummaryTitle() [A]
    // Optional string method to return a long summary title for this field, if a dynamic
    // summary title is required for this field.
    //
    // @param viewer (ListGrid) pointer back to the ListGrid
    // @param field (ListGridField) pointer to the field object
    // @group appearance
    // @see attr:listGridField.summaryTitle
    // @see attr:listGridField.title
    // @deprecated Rather than customizing the summaryTitle developers should typically use
    //  the +link{listGridField.headerTitle} attribute to show a different
    //  title in the column header button than the title used elsewhere.
    // @visibility external
    //<

    // Header Appearance
    // ---------------------------------------------------------------------------------------

	//> @attr listGridField.width (Number | String : "*" : [IRW])
	// The width of this field, specified as either an absolute number of pixels,
	// a percentage of the remaining space like "25%", or "*" to split remaining space among
    // all fields which have "*". <P>
    // Caution: stretch sizes are currently ignored if the field is being autofitted
    // (see +link{listGrid.autoFitFieldWidths}), unless +link{listGrid.showHeader} is false.
    // <P>
    // Note: if autofitting is active for a field, the width will default to the numerical
    // autofit width for that field (so it will not be stretched larger to fill available
    // space).  Otherwise, if not autofitting, the width will default to "*" causing it to be
    // automatically stretched.
    // <P>
    // The width may be defaulted to a numerical value based on +link{dataSourceField.length}
    // if no +link{listGridField.valueMap} is set, subject to the initial values of
    // +link{minWidth} and +link{listGrid.minFieldWidth}.  If you'd rather have the field
    // stretched-sized to fit the available space, set its initial width to "*".
    // <P>
    // See also +link{listGrid.minFieldWidth} to ensure no field goes below a minimum size.
    // <P>
    // Use +link{listGrid.resizeField} to programmatically change field width after creation.
    // <P>
    // Use +link{listGrid.getFieldWidth} to access the rendered field width after
    // the ListGrid is drawn.
    //
    // @see ListGrid.autoFitFieldWidths
    // @see listGridField.minWidth
    // @see listGridField.maxWidth
	// @group appearance
	// @visibility external
	//<

	//> @attr listGridField.minWidth (Number : null : [IRW])
	// When a field is subject to autofitting (see +link{listGrid.autoFitFieldWidths}), sets the
    // minimum width of the field.  The actual allowed minimum will be the maximum of:<ul>
    // <li> this property,
    // <li> +link{width} (if a number),
    // <li> the aufofit value determined by the widest value content in this field's column
    // <li> +link{listGrid.minFieldWidth}
    // </ul>
	// @group appearance
    // @see listGridField.width
	// @visibility external
	//<

	//> @attr listGridField.maxWidth (Number : null : [IRW])
	// When +link{listGrid.showHeader} is false and a field is subject to autofitting (see
    // +link{listGrid.autoFitFieldWidths}), sets the maximum width of the field.  The actual
    // effective maximum will be the largest of this property, +link{minWidth}, and 
    // +link{listGrid.minFieldWidth}.  That is, +link{minWidth} and 
    // +link{listGrid.minFieldWidth} dominate this property.
	// @group appearance
    // @see listGridField.width
	// @visibility external
	//<
    
    //> @attr   listGridField.align (Alignment : null : [IRW])
    // Horizontal alignment for field's column header: "left", "right"
    // or "center". Applied to the column header title and cells by default. A separate
    // alignment for cells can be specified via +link{listGridField.cellAlign}.
    // <P>
    // If null, the default alignment depends on the field's declared +link{type} - generally
    // "left" except for numbers which are "right" - and if +link{rotateTitle} has been
    // specified, the default is always "center".
    // <P>
    // Note that if this field is editable, the alignment of cells in the body will also be
    // reflected in any editors for the field.
    //  @group  appearance
    //  @visibility external
    //<

    //> @attr listGridField.headerBaseStyle (CSSStyleName : null : [IRW])
    // Custom base style to apply to this field's header button instead of
    // +link{listGrid.headerBaseStyle}.<br>
    // Note that depending on the header button constructor, you may have to override
    // +link{listGridField.headerTitleStyle} as well.
    // @group appearance
    // @visibility external
    //<
    
    //> @attr listGridField.spannedHeaderBaseStyle (CSSStyleName : null : [IRW])
    // Custom base style to apply to this field's header button instead of
    // +link{listGrid.spannedHeaderBaseStyle} when the grid is showing header spans.<br>
    // @group gridHeader, appearance, headerSpan
    // @visibility external
    //<

    //> @attr listGridField.headerTitleStyle (CSSStyleName : null : [IRW])
    // Custom titleStyle to apply to this field's header button instead of
    // +link{listGrid.headerTitleStyle}.<br>
    // Note that this will typically only have an effect if
    // +link{listGrid.headerButtonConstructor} is set to +link{class:StretchImgButton} or a subclass
    // thereof.
    // @group appearance
    // @visibility external
    //<

    //> @attr listGridField.headerTitle (String : null : IR)
    // Optional title for the header button for this field. If specified this will be
    // displayed in the header button instead of +link{listGridField.title} or
    // +link{listGridField.name}. Set to an empty string to suppress the title in the
    // header button entirely.
    // @group appearance
    // @see listGridField.title
    // @visibility external
    //<



    // Header Spans
    // ---------------------------------------------------------------------------------------
    // - known limitations
    //   - can't reorder a column to before or after a spanned set of columns, if the spanned
    //   columns are at the start or end of the visible fields.
    //   - several uses of this.Super(), instead of the faster this.invokeSuper() approach.
    //   Attempt to use invokeSuper() failed, likely because the header is not a discrete
    //   class, but an instance of Toolbar, and my guess (Alex) is that Class.invokeSuper()
    //   doesn't handle this particular case.


    //> @attr listGrid.headerSpans (Array of HeaderSpan : null : IRW)
    // Header spans are a second level of headers that appear above the normal ListGrid headers,
    // spanning one or more listGrid fields in a manner similar to a column-spanning cell in an
    // HTML table.
    // <P>
    // A header span can be created by simply naming the fields the header should span.  The
    // example below creates a headerSpan that spans the first two fields of the ListGrid.
    // <smartclient>
    // <pre>
    //    isc.ListGrid.create({
    //        headerHeight:40,
    //        fields : [
    //            { name:"field1" },
    //            { name:"field2" },
    //            { name:"field3" }
    //        ],
    //        headerSpans : [
    //            {
    //                fields: ["field1", "field2"],
    //                title: "Field 1 and 2"
    //            }
    //        ]
    //    });
    // </pre>
    // </smartclient>
    // <smartgwt>
    // <pre>
    //      ListGrid grid = new ListGrid();
    //      grid.setHeaderHeight(40);
    //      grid.setFields(new ListGridField[] {
    //          new ListGridField("field1"),
    //          new ListGridField("field2"),
    //          new ListGridField("field3")
    //      });
    //      grid.setHeaderSpans(new HeaderSpan[] {
    //          new HeaderSpan("Field 1 and 2", new String[] {"field1", "field2"})
    //      });
    // </pre>
    // </smartgwt>
    // Header spans can be nested, allowing fields to be grouped by multiple levels of
    // granularity. See +link{headerSpan.spans} for further information on nesting spans.
    // <P>
    // Header spans will automatically react to resizing of the headers they span, and will be
    // hidden automatically when all of the spanned fields are hidden.
    // <P>
    // Header spans appear in the +link{listGrid.header,header} area of the ListGrid, sharing space
    // with the existing headers, so it's typical to set +link{listGrid.headerHeight} to
    // approximately double its normal height when using headerSpans, or if using nested header
    // spans, the default header height multiplied by the number of levels of header spans to be
    // shown.
    // <P>
    // See +link{headerSpan} for many properties that allow the control of the appearance of
    // headerSpans.
    // <smartclient>
    // Note that headerSpans are created via the +link{AutoChild} pattern, hence
    // you can change the SmartClient component being used, or any of its properties.
    // </smartclient>
    // <P>
    // Neither headerSpans themselves nor the fields within them may be drag reordered, but other
    // unspanned headers may be.
    // <P>
    // A span can only span adjacent fields - if a span is defined and the spanned fields don't
    // sit next to each other in the specified fields array, the fields array will be automatically
    // reordered to match the order specified in the span's +link{headerSpan.fields} array.
    // <P>
    // Note that headerSpans primarily provide a visual cue for grouping multiple headers
    // together.  If you have an OLAP, data "cube" or multi-dimensional data model, the
    // +link{CubeGrid} component is the right choice.
    //
    // @group headerSpan
    // @visibility external
    //<

    //> @attr listGrid.headerSpanHeight (Integer : null : IR)
    // Default height for a +link{listGrid.headerSpans,headerSpan} with no height specified.
    // <P>
    // If <code>headerSpanHeight</code> is not specified (the default), headerSpans will be 1/2
    // of +link{listGrid.headerHeight}.
    //
    // @group headerSpan
    // @visibility external
    //<

    //> @attr listGrid.headerSpanVAlign (VAlign : "center" : IR)
    // Default alignment for +link{listGrid.headerSpans,headerSpans} with no
    // +link{headerSpan.valign} specified.
    //
    // @group headerSpan
    // @visibility external
    //<
    headerSpanVAlign: "center",

    //> @attr listGrid.unspannedHeaderVAlign (VAlign : null : IR)
    // When +link{listGrid.headerSpans,headerSpans} are in use, this property sets the default
    // vertical alignment for fields which do <b>not</b> have a headerSpan.
    //
    // @group headerSpan
    // @visibility external
    //<

    //> @attr listGrid.headerSpanConstructor (SCClassName : null : IR)
    // +link{SCClassName,SmartClient Class} to use for headerSpans.  Typically a +link{Button} or
    // +link{StretchImgButton} subclass.
    // <P>
    // If unset, headerSpans will be created using the +link{listGrid.headerButtonConstructor}.
    //
    // @group headerSpan
    // @visibility external
    //<

    //> @attr listGrid.headerSpan (MultiAutoChild StatefulCanvas : null : IR)
    // +link{listGrid.headerSpans,headerSpans} are created via the +link{AutoChild} pattern, hence
    // <code>headerSpanConstructor</code>, <code>headerSpanDefaults</code> and
    // <code>headerSpanProperties</code> are valid.
    //
    // @group headerSpan
    // @visibility external
    //<

    //> @object HeaderSpan
    // A header span appears as a second level of headers in a ListGrid, spanning one or more
    // ListGrid columns and their associated headers.
    // <P>
    // See +link{listGrid.headerSpans}.
    // <P>
    // In addition to the properties documented here, all other properties specified on the
    // headerSpan object will be passed to the +link{Class.create,create()} method of the
    // +link{listGrid.headerSpanConstructor}.  This allows you to set properties such as
    // +link{button.baseStyle} or +link{stretchImgButton.src} directly in a
    // <code>headerSpan</code>.
    //
    // @group headerSpan
    // @treeLocation Client Reference/Grids/ListGrid
    // @visibility external
    //<

    //> @attr headerSpan.name (Identifier : null : IR)
    // Name for this headerSpan, for use in APIs like +link{listGrid.setHeaderSpanTitle()}.
    // <P>
    // Name is optional, but if specified, must be unique for this ListGrid (but not globally
    // unique) as well as a valid JavaScript identifier, as specified by ECMA-262 Section 7.6
    // (the <smartclient>+link{String.isValidID()}</smartclient><smartgwt>StringUtil.isValidID()
    // </smartgwt> function can be used to test whether a name is a valid JavaScript
    // identifier).
    // @group headerSpan
    // @visibility external
    //<

    //> @attr headerSpan.fields (Array of String : null : IR)
    // List of fields that this header spans.  Fields should be identified by their value for
    // +link{listGridField.name}.
    // <P>
    // Developers may define multiple levels of header-spans by specifying +link{headerSpan.spans}
    // however a span cannot be specified with both <code>fields</code> and <code>spans</code>.
    //
    // @group headerSpan
    // @visibility external
    //<

    //> @attr headerSpan.spans (Array of HeaderSpan : null : IR)
    // This property allows developer to "nest" header spans, grouping fields together by
    // multiple layers of granularity.
    // <P>
    // For example a group of fields could be nested within two layers of header spans as follows:
    // <smartclient>
    // <pre>
    // { title:"Europe", spans:[
    //      {title:"France", fields:["Paris", "Lyon"]},
    //      {title:"UK", fields:["London", "Glasgow"]},
    //      {title:"Spain", fields:["Barcelona"]}
    //  ]
    // }
    // </pre>
    // </smartclient>
    // <smartgwt>
    // <pre>
    //      HeaderSpan france = new HeaderSpan("France", new String[] {"Paris", "Lyon"});
    //      HeaderSpan uk = new HeaderSpan("UK", new String[] {"London", "Glasgow"});
    //      HeaderSpan spain = new HeaderSpan("Spain", new String[] {"Barcelona"});
    //
    //      HeaderSpan europe = new HeaderSpan();
    //      europe.setTitle("Europe");
    //      europe.setSpans(france, uk, spain);
    // </pre>
    // </smartgwt>
    // Note that a span definition can not include both <code>spans</code>
    // and +link{headerSpan.fields,fields}.
    // @group headerSpan
    // @visibility external
    //<

    //> @attr headerSpan.title (String : null : IR)
    // A title for this headerSpan, to display in the headerSpan button for this headerSpan
    // and in other contexts such as the +link{listGrid.canPickFields,menu for picking visible fields}.
    //
    // Note: if you want to use HTML tags to affect the display of the header, you should do so
    // via +link{headerSpan.headerTitle} instead so that other places where the title
    // appears in the UI are not affected.  Refer to discussion at +link{listGridField.title}.
    //
    // @group headerSpan
    // @visibility external
    //<

    //> @attr headerSpan.headerTitle (String : null : IR)
    // Optional title for the headerSpan button for this headerSpan. If specified this will be
    // displayed in the headerSpan button instead of +link{headerSpan.title}. Set to an empty
    // string to suppress the title in the header button entirely.
    //
    // @group headerSpan
    // @visibility external
    //<

    //> @attr headerSpan.headerBaseStyle (CSSStyleName : null : [IRW])
    // Custom base style to apply to the header button created for this span instead
    // of +link{listGrid.headerBaseStyle}.
    // <P>
    // Note that depending on the header button constructor, you may have to specify
    // +link{headerSpan.headerTitleStyle} as well.
    // @group appearance
    // @visibility external
    //<

    //> @attr headerSpan.headerTitleStyle (CSSStyleName : null : [IRW])
    // Custom titleStyle to apply to the header button created for this span instead of
    // +link{listGrid.headerTitleStyle}.
    // <p>
    // Note that this will typically only have an effect if
    // +link{listGrid.headerButtonConstructor} is set to +link{class:StretchImgButton} or a subclass
    // thereof.
    // @see headerSpan.headerBaseStyle
    // @group appearance
    // @visibility external
    //<

    //> @attr headerSpan.height (Integer : null : IR)
    // Height of this headerSpan.  Defaults to +link{listGrid.headerSpanHeight}.
    //
    // @group headerSpan
    // @visibility external
    //<

    //> @attr headerSpan.valign (VerticalAlignment: null : IR)
    // Vertical alignment of the title of this headerSpan.
    // <P>
    // Defaults to listGrid.headerSpanVAlign if unset.
    //
    // @group headerSpan
    // @visibility external
    //<

    //> @attr headerSpan.align (Alignment: "center" : IR)
    // Horizontal alignment of the title of this headerSpan.
    //
    // @group headerSpan
    // @visibility external
    //<

    //> @attr headerSpan.wrap (Boolean : null : [IR])
    // Should the span title wrap if there is not enough space horizontally to accommodate it.
    // If unset, default behavior is derived from +link{listGrid.wrapHeaderSpanTitles}.  (This
    // is a soft-wrap - if set the title will wrap at word boundaries.)
    //
    // @see listGridField.wrap
    // @visibility external
    //<

    //> @attr listGrid.showTreeColumnPicker (Boolean : true : IR)
    // When +link{listGrid.headerSpans} are in use, whether to show a hierarchical column picker
    // that includes both headerSpans and normal headers, with normal headers indented under
    // headerSpans similarly to how a +link{TreeGrid} displays a Tree.
    // <P>
    // If <code>showTreeColumnPicker</code> is false, no column picker will be shown on the
    // headerSpan itself, and the column picker for a clicked on a normal field header will include
    // only normal fields.
    //
    // @group headerSpan
    // @visibility external
    //<
    showTreeColumnPicker: true,

    //> @attr listGrid.spannedHeaderBaseStyle (CSSStyleName : null : IR)
    // +link{Button.baseStyle} to apply to the field header buttons for
    // this ListGrid when showing header spans.
    // Note that, depending on the +link{listGrid.headerButtonConstructor, Class} of the header
    // buttons, you may also need to set +link{listGrid.headerTitleStyle}.
    // @group   gridHeader, appearance, headerSpan
    // @visibility external
    //<

    // Cell Styling
    // ---------------------------------------------------------------------------------------

    //> @attr listGridField.cellAlign (Alignment : null : [IRW])
    // Horizontal alignment for cells in this field's column: "left", "right"
    // or "center".<br>
    // If null, alignment is derived from +link{ListGridField.align}. If this field is editable,
    // the alignment of cells in the body will also be reflected in any editors for the field.
    //  @group  appearance
    //  @visibility external
    //<

    //> @attr listGrid.reverseRTLAlign (Boolean : true : [IRW])
    // If a page is rendered in +link{isc.Page.isRTL(),RTL mode}, should
    // cell alignments specified +link{listGridField.cellAlign} be reversed (so
    // an <code>align:"right"</code> field will have content aligned on the left and
    // vice versa)?
    // <P>
    // This is true by default to match user expectation that text flows from
    // start-to end and is aligned with the start of text flow (left in LTR mode,
    // right in RTL mode) by default. May be set to false to have the specified
    // alignments be taken literally in RTL mode.
    // @group RTL
    // @visibility external
    //<
    reverseRTLAlign:true,


    //> @attr   listGridField.baseStyle (CSSStyleName : null : [IRW])
    //  Custom base style to apply to all cells in this field instead of +link{ListGrid.baseStyle}
    //  To override the baseStyle at the row level, use
    //  +link{ListGrid.recordBaseStyleProperty, record[listGrid.recordBaseStyleProperty]}
    //  instead.
    // @see ListGrid.recordBaseStyleProperty
    // @group appearance
    // @visibility external
    // @example gridCells
    //<

    // Sorting (per field)
    // ---------------------------------------------------------------------------------------

    //> @attr   listGridField.canSort (Boolean : true : [IRW])
    //  Enables or disables sorting by this column. If false, interactive
    //  sorting via header-clicks or menu-items will have no effect, but direct scripted calls
    //  to +link{ListGrid.sort, sort()} or +link{ListGrid.setSort, setSort()} will work as
    //  expected.
    //  @group  sorting
    //  @see    method:ListGrid.sort
    //  @see    attr:ListGrid.canSort
    //  @visibility external
    //<

    //> @attr listGridField.sortDirection (SortDirection : null : [IRW])
    // Specifies the default sorting direction for this column. If specified on the
    // +link{listGrid.sortField,default sort field} for the listGrid, sorting occurs
    // automatically, otherwise this will be the default direction when the user clicks the
    // field header, or calls +link{ListGrid.sort()} without specifying an explicit sort
    // direction.
    // <P>
    // Overrides +link{ListGrid.sortDirection}.
    // <p>
    // Because the grid's <code>sortDirection</code> setting is updated whenever the grid is
    // sorted, it is recommended to explicitly set the field's <code>sortDirection</code> if
    // it is important to use a particular sorting direction as the default for the field.
    //  @group  sorting
    //  @see type:SortDirection
    //  @visibility external
    //<

    //> @method listGridField.sortNormalizer() (A)
    // Optional function to return the value that should be used when sorting this field.
    // <P>
    // Note that, if the dataset exceeds +link{ListGrid.dataPageSize} and hence paging is
    // introduced, the grid relies on the server to provide sorting, and the sortNormalizer
    // will no longer be called.
    // <P>
    // For custom sort orders that can be executed both client and server, consider
    // +link{dataSourceField.sortByField}.
    //
    // @param recordObject    (Object)    record to normalize
    // @param fieldName       (String)    name of the field on which sorting occurred
    // @param context (ListGrid) A pointer back to the list grid displaying this field will
    //   be available as the <code>context</code> argument. Note that you can also get a pointer
    //   to the field definition object by calling <code>context.getFieldByName(fieldName)</code>
    //  @return (Any)   normalized value for sorting
    //  @group  sorting
    //  @visibility external
    //  @example dataTypes
    //<
    
    //> @attr listGridField.selectCellTextOnClick (Boolean : null : [IRW])
    // Should the cell content be natively selected (ready for copying to clip-board) 
    // on click?
    // <P>
    // See +link{listGrid.selectCellTextOnClick} for more information.
    // @visibility external
    //<

    // Editing (per field)
    // ----------------------------------------------------------------------------------------

    //> @attr listGridField.canEdit (boolean : null : [IRW])
    // This property establishes default editability for the field.  May be overridden by setting
    // the 'canEdit' property at the listGrid level. If not explicitly set and this grid is bound
    // to a dataSource, the +link{listGrid.canEditFieldAttribute} may be used to set default
    // editability at the field level.
    // <p>
    // An override of +link{listGrid.canEditCell} can be used for more dynamic control over whether
    // fields can be edited.
    //
    // <smartgwt><P>Note that this property may validly be <code>null</code> as a distinct state
    // from <code>false</code>.  See +link{listGrid.fieldIsEditable()} for an API that will
    // always return <code>true</code> or <code>false</code> as to whether editing is possible
    // by default.</smartgwt>
    //
    // @group  editing
    // @see attr:listGrid.canEdit
    // @see attr:listGrid.recordEditProperty
    // @see method:listGrid.canEditCell
    // @visibility external
    // @example disableEditing
    //<

    //> @attr listGridField.alwaysShowEditors (boolean : null : [IRW])
    // When this attribute is set, editors will be rendered into every row of the grid for
    // this field, rather than showing up in a single record at a time.
    // This attribute is only valid when +link{listGrid.editByCell} is false
    // @group editing
    //<
    


    //> @attr listGridField.defaultValue (Any : null : [IRW])
    // If this field +link{listGridField.canEdit, can be edited}, this property can be used to
    // specify a default value for this field's editor when adding new rows to the grid.
    // @see listGrid.startEditingNew()
    // @group editing
    // @visibility external
    //<

    //> @method listGridField.defaultDynamicValue()
    // +link{FormItem.defaultDynamicValue} to be applied to the cell editor for this field
    // when +link{listGridField.canEdit,editing}.
    // <P>
    // Note that editors are only generated for fields that are actually written out, and
    // as such <code>defaultDynamicValue</code> will not apply to
    // +link{listGridField.hidden,hidden fields}, or fields that are not drawn due to
    // +link{listGrid.showAllColumns,incremental column rendering}.
    // <P>
    // To apply arbitrary default values to the grid when editing new records, developers may
    // use the +link{listGrid.startEditingNew(),newValues parameter of startEditingNew()}.
    //
    // @param   item    (FormItem)  The editor for the cell itself (also available as "this").
    //                              Note that in addition to the standard FormItem APIs available
    //                              on the editor, it also has:<br>
    //                              - a pointer back to the containing listGrid
    //                              [<code>item.grid</code>]<br>
    //                              - the colNum being edited [<code>item.colNum</code>]<br>
    //                              - the rowNum being edited [<code>item.rowNum</code>]
    // @param   form    (DynamicForm) the managing DynamicForm instance
    // @param   values  (Object)      the current set of values for the form as a whole
    // @return (Any) dynamically calculated default value for this field's edit item.
    // @group editing
    // @visibility external
    //<

    //> @attr   listGridField.enterKeyEditAction (EnterKeyEditAction : "done" : [IRW])
    // What to do when a user hits enter while editing this field?<br>
    // Overrides the <code>enterKeyEditAction</code> as specified at the listGrid level while
    // focus is in this field.
    //  @group  editing
    //  @visibility external
    //<

    //> @attr   listGridField.escapeKeyEditAction (EscapeKeyEditAction : "cancel" : [IRW])
    // What to do when a user hits escape while editing this field?<br>
    // Overrides the <code>escapeKeyEditAction</code> as specified at the listGrid level while
    // focus is in this field.
    //  @group  editing
    //  @visibility external
    //<

    //> @attr   listGridField.arrowKeyEditAction (ArrowKeyEditAction : null : [IRW])
    // What to do when a user hits arrow key while editing this field?<br>
    // See +link{listGrid.getArrowKeyEditAction()}.
    //  @group  editing
    //  @visibility external
    //<

    
    //> @attr   listGridField.nextTabColNum (number : null : [IRWA])
    // If specified, when the user hits tab while editing this field, editing will move to the
    // specified colNum in the next row (or the first editable field after it), rather than the
    // next editable field in this row.
    //  @group  editing
    //  @visibility advancedInlineEdit
    //<

    //> @attr   listGridField.previousTabColNum (number : null : [IRWA])
    // If specified, when the user hits shift+tab while editing this field, editing will move
    // to the specified colNum in the previous row (or the first editable field before it),
    // rather than the previous editable field in this row.
    //  @group  editing
    //  @visibility advancedInlineEdit
    //<

    //> @attr listGridField.editorType (FormItemClassName : null : [IRWA])
    //      Name of form item class to use for the form item created to edit this field.
    //      (Only used if this field is editable).<br>
    //      Note: If this is not specified, the edit-form item type may be derived from the
    //      <code>editorType</code> property, typically inherited from datasource fields, or
    //      from the <code>type</code> of the field (showing the appropriate form item for
    //      the data-type). See the +link{group:editing} overview for more on editing ListGrid
    //      fields.
    //  @group  editing
    //  @see attr:listGrid.canEdit
    //  @visibility external
    //  @example customEditors
    //<
    // link to editing group documentation included as that describes the additional
    // "rowNum", "colNum" and "grid" properties stored on the editor.
    
    //> @attr   listGridField.editorProperties (FormItem Properties : null : [IRWA])
    // Properties to apply the the form item created to edit this field. (Only used if
    // this field is editable).
    // <P>
    // For example, if you have a field "shoeSize" with +link{dataSourceField.editorType} set
    // to "SpinnerItem" in order to use a SpinnerItem as your field editor, and you want to pass the
    // +link{spinnerItem.step} property to the created SpinnerItem:
    // <pre>
    //    fields : [
    //        { name:"shoeSize", editorType:"SpinnerItem",
    //          editorProperties : { step:0.5 } },
    //        ... other fields ...
    //    ]
    // </pre>
    //
    // @group editing
    // @visibility external
    // @example customEditors
    //<

    //> @attr listGridField.initialValue (Any : null : IR)
    // In an editable ListGrid, initial value for this field when the user begins editing a new
    // record.
    // <p>
    // <code>initialValue</code> applies only if a new record is created by end user action (such
    // as navigating past the end of the data when +link{listGrid.listEndEditAction} is "next") or
    // by a call to +link{listGrid.startEditingNew()} that <i>does not specify the
    // <code>initialValues</code></i> argument.
    //
    // @group editing
    // @visibility external
    //<
    
	//> @attr   listGrid.modalEditing (boolean : null : [IRWA])
	//      If this property is true, any mouse click outside of the open cell editors
    //      will end editing mode, hiding the cell editors and saving any changes to those
    //      cell values.
    // @group  editing
    // @visibility external
    // @example modalEditing
    //<

    //> @method listGridField.editorEnter (A)
    // Callback fired when the user first starts editing a cell.
    // <P>
    // This callback is typically used to establish dynamic default values via
    // +link{listGrid.setEditValue()} or +link{listGrid.setEditValues()}.
    //
    // @param record (ListGridRecord) record for the cell being edited.  <b>Will be null</b>
    //                                for a new, unsaved record.
    // @param value (Any) value for the cell being edited
    // @param rowNum (int)  row number for the cell
    // @param colNum (int)  column number of the cell
    // @param grid (ListGrid) ListGrid to which this field belongs
    // @group editing
    // @visibility external
    //<

    //> @method listGridField.editorExit (A)
    // Callback fired when the user attempts to navigate away from the current edit cell,
    // or complete the current edit.<br>
    // Return false from this method to cancel the default behavior (Saving / cancelling the
    // current edit / moving to the next edit cell)
    //
    // @param   editCompletionEvent (EditCompletionEvent)  What interaction triggered this
    //                                                          edit cell exit
    // @param   record     (ListGridRecord) record for the cell being edited
    // @param   newValue   (Any)    new edit value for the cell being edited. Note that if the
    //    user has not made any changes this will be undefined
    // @param   rowNum     (int)    row number for the cell
    // @param   colNum     (int)    column number of the cell
    // @param   grid    (ListGrid)  ListGrid to which this field belongs
    // @return  (boolean)   Returning false from this method will cancel the default behavior
    //                      (for example saving the row) and leave the editor visible and focus
    //                      in this edit cell.
    //  @group  editing
    //  @see listGrid.editorExit
    // @visibility external
    //<

    //> @method listGridField.cellChanged()
    // Callback fired when field changes value as the result of a cell edit.  Fired only on
    // successful save of edit, when the new value doesn't match the value before editing.<br>
    // <p>
    // Same signature as +link{method:listGrid.cellChanged()}, but defined on a per-field
    // basis.
    //
    // @param   record     (ListGridRecord) record for the cell being changed
    // @param   newValue   (Any)    new value for the cell
    // @param   oldValue   (Any)    old value for the cell
    // @param   rowNum     (number) row number for the cell
    // @param   colNum     (number) column number of the cell
    // @param   grid       (ListGrid)   grid where cell was changed.
    //
    // @group  editing
    // @see method:listGrid.cellChanged()
    // @visibility external
    //<

    //> @attr listGridField.validators (Array of Validator : null : [IRW])
    // Array of +link{class:Validator} objects for this field.  When the user edits cells in
    // this field, these validators will be applied to the edited value.<br>
    // Note: for databound listGrids, this property may be specified on the
    // +link{class:DataSourceField}, enabling both client and server side validation.
    // @see class:Validator
    // @see listGridField.required
    // @group gridValidation
    // @visibility external
    // @example dataValidation
    //<

    //> @attr listGridField.validateOnChange (boolean : null : [IRW])
    // If set to true, any +link{listGridField.validators} for this field will be run whenever
    // the value of the field is changed.
    // <P>
    // Analogous to the +link{FormItem.validateOnChange} property.
    // @group gridValidation
    // @visibility external
    //<

    //> @attr listGridField.required (Boolean : null : [IRW])
    // When the user edits cells in this field, is this value required to be non-empty
    // in order for validation to pass.<br>
    // Note: for databound listGrids, this property may be specified on the
    // +link{class:DataSourceField}, enabling both client and server side validation.
    //
    // @see listGridField.validators
    // @group gridValidation
    // @visibility external
    //<

    

    //> @attr listGridField.dateFormatter (DateDisplayFormat : null : [IRW])
    // Display format to use for date type values within this field.
    // <P>
    // The +link{listGridField.timeFormatter} may also be used to format underlying Date values as
    // times (omitting the date part entirely). If both <code>dateFormatter</code> and
    // <code>timeFormatter</code> are specified on a field, for
    // fields specified as +link{listGridField.type,type "time"} the
    // <code>timeFormatter</code> will be used, otherwise the <code>dateFormatter</code>
    // <P>
    // If <code>field.dateFormatter</code> and <code>field.timeFormatter</code> is unspecified,
    // date display format may be defined at the component level via
    // +link{ListGrid.dateFormatter,ListGrid.dateFormatter}, or for fields of type <code>"datetime"</code>
    // +link{ListGrid.datetimeFormatter,ListGrid.datetimeFormatter}. Otherwise the
    // default is to use the system-wide default short date format, configured via
    // +link{DateUtil.setShortDisplayFormat()}.  Specify any valid +link{type:DateDisplayFormat} to
    // change the format used by this item.
    // <P>
    // If this field is editable the dateFormatter will also be passed to the editor created
    // to edit this field. Note that you can also specify an explicit +link{listGridField.inputFormat}
    // which will be passed through to the editor as well, though this is not typically required
    // as the input format should be automatically derived by the SmartClient system
    // for standard DateDisplayFormats.
    //
    // @see listGrid.dateFormatter
    // @see listGrid.datetimeFormatter
    // @see listGridField.timeFormatter
    // @visibility external
    //<

    //> @attr listGridField.timeFormatter (TimeDisplayFormat : null : [IRWA])
    // Time-format to apply to date type values within this field.  If specified, any
    // dates displayed in this field will be formatted as times using the appropriate format.
    // This is most commonly only applied to fields specified as type <code>"time"</code> though
    // if no explicit +link{listGridField.dateFormatter} is specified it will be respected for other
    // fields as well.
    // <P>
    // If unspecified, a timeFormatter may be defined
    // +link{ListGrid.timeFormatter,at the component level} and will be respected by fields
    // of type <code>"time"</code>.
    // <P>
    // If this field is editable, the timeFormatter will also be passed to the editor created to
    // edit this field as +link{formItem.timeFormatter}.
    //
    // @group appearance
    // @visibility external
    //<
    //timeFormatter:null

    //> @attr listGridField.decimalPrecision (number : null : [IRW])
    // @include dataSourceField.decimalPrecision
    //
    // @group appearance
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr listGridField.decimalPad (number : null : [IRW])
    // @include dataSourceField.decimalPad
    //
    // @group appearance
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr listGridField.inputFormat (DateInputFormat : null : [IRWA])
    // For fields of type <code>"date"</code> or <code>"datetime"</code>, if this is an editable
    // listGrid, this property allows you to specify the +link{DateItem.inputFormat, inputFormat}
    // applied to the editor for this field.
    // @see listGridField.dateFormatter
    // @visibility external
    //<

    //> @attr listGridField.isRemoveField (boolean : null : [IRA])
    // If set to true and +link{listGrid.canRemoveRecords} is true, this field will be rendered
    // as the remove-field for this grid. In most common usage scenarios this field will essentially
    // be a placeholder indicating where the remove field should be rendered, meaning properties
    // other than <code>isRemoveField</code>, such as <code>name</code> or <code>title</code>, may
    // be left unset.
    // @see listGrid.canRemoveRecords
    // @visibility external
    //<

    //> @attr listGridField.isDragHandle (boolean : null : [IRA])
    // If set to true and +link{listGrid.useDragHandles} is true, this field will be treated as
    // the +link{listGrid.dragHandleField, drag handle field} for records in this grid with
    // respect to touch interaction.  However, visibility and field order for this field won't
    // be managed automatically by the Framework, as it is for the
    // +link{listGrid.dragHandleField} autochild.
    // <P>
    // Note that this is only fully supported for fields of +link{type}: "icon", for which we
    // can easily generate the necessary HTML and CSS to ensure proper behavior across browsers.
    // @see listGrid.showDragHandles()
    // @group dragHandleField
    //<

    //> @method listGridField.recordClick()
    //
    // Executed when this field is clicked on.  Note that if +link{ListGrid.recordClick()} is
    // also defined, it will be fired for fields that define a recordClick handler if the
    // field-level handler returns true. Return false to prevent the grid-level handler from firing.
    //
    // @param   viewer      (ListGrid)  the listGrid that contains the click event
    // @param   record      (ListGridRecord)    the record that was clicked on
    // @param   recordNum   (number)    number of the record clicked on in the current set of
    //                                  displayed records (starts with 0)
    // @param   field       (ListGridField) the field that was clicked on (field definition)
    // @param   fieldNum    (number)    number of the field clicked on in the listGrid.fields
    //                                  array
    // @param   value       (Any)    value of the cell (after valueMap, etc. applied)
    // @param   rawValue    (Any)   raw value of the cell (before valueMap, etc applied)
    // @param editedRecord (ListGridRecord) the clicked record with any unsaved
    //                                   edit values overlaid (see <code>listGrid.getEditedRecord()</code>).
    // @return  (boolean)   false to stop event bubbling
    //
    // @group   events
    //
    // @see method:listGrid.recordClick()
    // @visibility external
    // @example recordClicks
    //<

    //> @method listGridField.recordDoubleClick()
    //
    // Executed when this field is double-clicked.  Note that if
    // +link{ListGrid.recordDoubleClick()} is also defined, it will be fired for fields that define
    // a recordDoubleClick handler if the field-level handler returns true. Return false to prevent
    // the grid-level handler from firing.
    //
    //
    // @param   viewer      (ListGrid)  the listGrid that contains doubleclick event
    // @param   record      (ListGridRecord)    the record that was double-clicked
    // @param   recordNum   (number)    number of the record clicked on in the current set of
    //                                  displayed records (starts with 0)
    // @param   field       (ListGridField) the field that was clicked on (field definition)
    // @param   fieldNum    (number)    number of the field clicked on in the listGrid.fields
    //                                  array
    // @param   value       (Object)    value of the cell (after valueMap, etc. applied)
    // @param   rawValue    (Object)    raw value of the cell (before valueMap, etc applied)
    
    // @return  (boolean)   false to stop event bubbling
    //
    // @group   events
    //
    // @see method:listGrid.recordClick()
    // @visibility external
    // @example recordClicks
    //<

    // Filtering
    // ---------------------------------------------------------------------------------------

    //> @attr   listGridField.canFilter (boolean : null : [IRW])
    //      If showing a filter row for this ListGrid, should the filter criteria for this
    //      field be editable
    //  @group  filterEditor
    //  @visibility external
    //  @example disableFilter
    //<

    //> @attr listGridField.filterEditorValueMap (Object : null : [IRW])
    //  If this listGrid is showing a filter row, this property can be used to specify a
    //  mapping of internal data to/from display values to be in the appropriate filter
    //  row form item.
    //  @visibility external
    //  @group filterEditor
    //<

    //> @attr listGrid.useMultiSelectForFilterValueMaps (boolean : true : IRWA)
    // If +link{listGrid.showFilterEditor} is true, when creating a SelectItem 
    // for editing criteria for a field with a ValueMap, should the SelectItem
    // default to +link{SelectItem.multiple,multiple:true}?
    // <P>
    // This overrides +link{SearchForm.useMultiSelectForValueMaps} on the filterEditor's
    // edit form.
    // @visibility external
    //<
    useMultiSelectForFilterValueMaps:true,

    //> @attr listGridField.filterEditorType (FormItemClassName : null : [IRWA])
    //      If this ListGrid is showing a filter row, this property can be used to
    //      specify the form item class to use for the filter form item associated with this
    //      field
    //      (Only used if this field is not canFilter:false).<br>
    //      Note: If this is not specified, the edit-form item type may be derived from the
    //      'editorType' property, typically inherited from datasource fields, or from the
    //      'type' of the field (showing the appropriate form item for the data-type).
    //  @group  filterEditor
    //  @visibility external
    //<

    //> @attr   listGridField.defaultFilterValue (Any : null : [IRWA])
    // If this ListGrid is showing a filter row, this property can be used to apply a default
    // value to show in the filter editor for this field.
    // @group filterEditor
    // @visibility external
    //<
    

    //> @attr   listGridField.filterEditorProperties (FormItem Properties : null : [IRWA])
    // If this ListGrid is showing a filter row
    // (+link{listGrid.showFilterEditor,showFilterEditor}:true), this property
    // can be used to specify properties for the appropriate filter form item.
    // @group filterEditor
    // @visibility external
    //<
    
    //> @attr listGridField.operator (OperatorId : null : [R])
    // When +link{listGrid.allowFilterOperators, allowFilterOperators} is true, this read-only
    // property is set to the 
    // +link{Operator, filter/search operator} currently assigned to this field.  You can also
    // retrieve a field's current operator by calling +link{listGrid.getFieldSearchOperator}.
    // <p>
    // For a discussion of the various filtering and criteria-management APIs and when to use
    // them, see the +link{group:gridFiltering, Grid Filtering overview}.
    // <p>
    // While this property can be affected by users, via the
    // +link{listGrid.filterUsingText, "Filter using"} submenu of the grid's 
    // +link{listGrid.showHeaderContextMenu, headerContextMenu}, it can't be set directly in 
    // code.
    // <p>
    // However, developers can call +link{listGrid.setFieldSearchOperator} to modify a field's 
    // current operator, or +link{listGrid.clearFieldSearchOperator} to reset a field to it's 
    // default operator.
    // <p>
    // To specify a particular default operator for a field, see 
    // +link{listGridField.filterOperator}.
    // @see filterOperator
    // @visibility external
    //<

    //> @attr listGridField.filterOnKeypress (Boolean : null : [IRWA])
    // If set this will override the 
    // +link{listGrid.filterOnKeypress, filterOnKeypress setting at the grid level}
    // <p>
    // For a discussion of the various filtering and criteria-management APIs and when to use
    // them, see the +link{group:gridFiltering, Grid Filtering overview}.
    // @group filterEditor
    // @see listGrid.fetchDelay
    // @visibility external
    //<

    //> @attr listGridField.showFilterEditorHovers (Boolean : null : IR)
    // When set to false, no hover is shown for the field editor in this field. Otherwise,
    // a hover shows the current field's criteria description along with the
    // +link{listGrid.filterWindowCriteria} description if configured.
    // <p>
    // All hovers for the filter editor can be disabled using
    // +link{listGrid.showFilterEditorHovers}.
    // <p>
    // The descriptive text for criteria is formatted by +link{DataSource.getAdvancedCriteriaDescription}.
    // 
    // @see listGrid.showFilterEditorHovers
    // @visibility external
    //<

    //> @attr listGrid.fetchDelay (number : 300 : IRWA)
    // If we're showing the filterEditor (+link{listGrid.showFilterEditor} is true), 
    // and +link{filterByCell} or +link{filterOnKeypress} are enabled, this
    // property is the delay in milliseconds between the user changing the filter and the
    // filter request being sent to the server. If multiple changes are made to the filter
    // within this fetch delay, only the most recent will actually cause a re-filter
    // @see explicitFetchDelay
    // @group filterEditor
    // @visibility external
    //<
    fetchDelay:300,

    //> @attr listGrid.explicitFetchDelay (number : 0 : IRWA)
    // If we're showing the filterEditor (+link{listGrid.showFilterEditor} is true), this
    // property determines the delay in kicking off the filter request if the current filter
    // values are submitted by clicking the filter button or hitting return.  By default, this
    // property is set to zero so that a filter request is immediately sent.
    // @see fetchDelay
    // @group filterEditor
    // @visibility external
    //<
    explicitFetchDelay:0,

    //> @attr listGridField.shouldPrint (boolean : null : IRW)
    // Whether this field should be included in the printable representation of the grid.
    //
    // @group printing
    // @visibility external
    //<

    // AutoComplete
    // ---------------------------------------------------------------------------------------

    //> @attr listGridField.autoComplete (AutoComplete : null : IRW)
    // Whether to allow browser autoComplete when editing this field.
    // <p>
    // If unset, defaults to listGrid.autoComplete
    //
    // @see listGrid.autoComplete
    // @visibility external
    //<

    //> @attr listGridField.uniqueMatch (boolean : null : IRW)
    // When autoComplete is enabled, whether to offer only unique matches to the user.
    // <p>
    // If unset, defaults to listGrid.uniqueMatch.
    //
    // @see listGrid.uniqueMatch
    // @visibility autoComplete
    //<
    uniqueMatch:true,


    // Formatting (per field)
    // --------------------------------------------------------------------------------------------

    //> @method listGridField.getCellValue()
    // A stringMethod which returns the cell value to display for this field for some record.
    // If defined, called by ListGrid.getCellValue().  Called in the scope of the field object.
    //
    // Deprecated as of Jan 12 05 in favor of +link{listGridField.formatCellValue()}, because 
    // 'getCellValue()' is a lower-level API which handles (for example) returning the HTML
    // for editors within the cell.
    //
    // @param  viewer  (ListGrid)  the ListGrid for which we're returning a cellValue
    // @param  record  (Object)    the current record object
    // @param  recordNum   (number)    row-index of the current record
    // @param  field   (ListGridField) current field object
    // @param  fieldNum    (number)    column-index of the current field
    // @param  value   (Any)   unformatted value for this field, determined via
    //                          ListGrid.getRawCellValue()
    // @see    method:listGrid.getCellValue
    // @see method:listGridField.formatCellValue
    // @group  display_values
    // @visibility internal
    // @return (Any)   value to display in the ListGrid cell
    // @deprecated As of SmartClient 5.5, use +link{listGridField.formatCellValue}.
    //<

    // We provide separate formatters for the raw value displayed in a static cell, and the
    // value displayed in an editor.
    // This makes sense because:
    // - developers are likely to want to apply different formats - for example including some
    //   raw HTML in the static value, but not in the value displayed in a text based editor.
    // - the more common 'formatCellValue()' needs no parser to convert from the formatted value
    //   back to the raw value
    // If a developer wishes to apply the same formatter in both cases, the suggested approach
    // would be to write a single formatter function and have it be called from both methods.

    //> @method listGridField.formatCellValue()
    // Return the HTML to display in cells of this field.
    // <P>
    // Given the raw value for this field as taken from the record Formatter to apply to the
    // static values displayed in cells for this field.
    // <P>
    // <i>Example usage</i>: formatting a currency value stored in cents (so "100" to "$1.00")<br>
    // The value passed to this method is the raw value for the cell.<br>
    // Takes precedence over <code>formatCellValue</code> defined at the grid level for cells
    // in this field.
    // <P>
    // Note: this formatter will not be applied to the values displayed in cells being edited.
    // The +link{listGridField.formatEditorValue,formatEditorValue()} is provided for that purpose.
    //
    // @group display_values
    //
    // @param   value (Any)   raw value for the cell, from the record for the row
    // @param   record   (ListGridRecord)
    //   Record object for the cell. Note: If this is a new row that has not been saved, in an
    //   editable grid, it has no associated record object. In this case the edit values will
    //   be passed in as this parameter (see +link{listGrid.getEditValues()})
    // @param   rowNum  (number)    row number for the cell
    // @param   colNum  (number)    column number for the cell.
    // @param   grid    (ListGrid) the ListGrid displaying the cell
    // @return (HTMLString) HTML to display in the cell
    //
    // @see listGrid.formatCellValue()
    // @see listGridField.formatEditorValue()
    // @deprecated <smartgwt>Use +link{ListGridField.setCellFormatter()} or 
    // +link{ListGrid.setCellFormatter()} to install a +link{class:CellFormatter}.
    //  This method is not a valid override point for the default behavior.</smartgwt>
    // @visibility external
    // @example formatValues
    //<

    //> @method listGridField.formatInactiveCellValue()
    // Field-level formatter for inactive content.
    // <P>
    // If present, this method will be invoked instead of +link{listGridField.formatCellValue()} in cases 
    // where the grid is rendering non-interactive content outside. 
    // See +link{listGrid.formatInactiveCellValue()} for more details.
    // <P>
    // @param   value (Any)   raw value for the cell, from the record for the row
    // @param   record   (ListGridRecord)
    //   Record object for the cell. Note: If this is a new row that has not been saved, in an
    //   editable grid, it has no associated record object. In this case the edit values will
    //   be passed in as this parameter (see +link{listGrid.getEditValues()})
    // @param   rowNum  (number)    row number for the cell
    // @param   colNum  (number)    column number for the cell.
    // @param   grid    (ListGrid) the ListGrid displaying the cell
    // @return (HTMLString) HTML to display in the cell
    //
    // @see listGrid.formatInactiveCellValue()
    // @visibility external
    //<    
    
    //> @attr listGridField.escapeHTML (boolean : null : IRW)
    // By default HTML values in ListGrid cells will be interpreted by the browser.
    // Setting this flag to <code>true</code> will cause HTML characters to be escaped, meaning the
    // raw value of the field (for example <code>"&lt;b&gt;AAA&lt;/b&gt;"</code>) is displayed
    // to the user rather than being interpreted as HTML (for example <code>"<b>AAA</b>"</code>)
    // <p>
    // If this field has an +link{ListGridField.aiFieldPrompt}, then the default value of
    // this setting is <code>true</code>.
    // @see skipLineBreaks
    // @visibility external
    //<

    //> @attr listGridField.skipLineBreaks (boolean : null : IRW)
    // By default, when +link{escapeHTML,escaping HTML}, we convert line breaks (\r\n, \r, and
    // \n) to HTML &lt;br&gt tags so that visible cell content respects the original break
    // characters. Set this property true to instead show the content as a single line (or
    // potentially wrapped to avoid clipping if +link{ListGrid.wrapCells} is true).
    // <P>
    // If defaulted to null, behavior is determined by +link{listGrid.skipLineBreaks}.
    // @see escapeHTML
    // @visibility external
    //<

    //> @attr listGridField.linkText (String : null : IRW)
    // The HTML to display in cells of this field if the fieldType is set to link.
    // <P>
    // This property sets linkText that will be the same for all records.  You can set linkText
    // on a per-record basis via +link{attr:listGridRecord.linkText}.
    //
    //  @see type:ListGridFieldType
    //  @see type:FieldType
    //  @see attr:listGridRecord.linkText
    //  @see attr:listGrid.linkTextProperty
    //  @see attr:listGridField.linkTextProperty
    //  @group  display_values
    //  @visibility external
    //  @example linkImage
    //<

    //> @attr listGridField.linkTextProperty (String : null : IRW)
    // Name of the property in a ListGridRecord that holds the HTML to display in cells of this
    // field if the fieldType is set to "link".
    //
    //  @see type:ListGridFieldType
    //  @see type:FieldType
    //  @see attr:listGridRecord.linkText
    //  @see attr:listGridField.linkText
    //  @see attr:listGrid.linkTextProperty
    //  @group  display_values
    //  @visibility external
    //<

    //> @attr listGridField.linkURLPrefix (String : null : IRWA)
    // If this field has type [+link{type:ListGridFieldType}] set to <code>"link"</code>,
    // setting this property will apply a standard prefix to the link URL for cells in this field.
    // @visibility external
    //<


    //> @attr listGridField.linkURLSuffix (String : null : IRWA)
    // If this field has type [+link{type:ListGridFieldType}] set to <code>"link"</code>,
    // setting this property will apply a standard suffix to the link URL for cells in this field.
    // @visibility external
    //<

    // --------------------
    // Editing

    //> @method listGridField.formatEditorValue
    // Return the value to display in cells of this field which are being edited.
    // <P>
    // <i>Example usage</i>: converting a stored value in cents (100) to a dollar-and-cents
    // value in the editor (1.00)
    // <P>
    // The value passed to this method is the raw value for the cell.
    // <P>
    // <code>formatEditorValue</code> takes precedence over +link{listGrid.formatEditorValue()}
    // defined at the grid level for cells in this field.
    // <P>
    // To convert the formatted value displayed within an editor back to a raw value, implement
    // +link{listGridField.parseEditorValue} as well.
    //
    // @group editing
    //
    // @param   value (Any)   raw value for the cell being edited
    // @param   record   (ListGridRecord)
    //   Record object for the cell. Note: If this is a new row that has not been saved, in an
    //   editable grid, it has no associated record object. In this case the edit values will
    //   be passed in as this parameter.
    // @param   rowNum  (number)    row number for the cell
    // @param   colNum  (number)    column number for the cell.
    // @param   grid    (ListGrid Instance) A pointer to the ListGrid displaying the cell
    // @return (Any) formatted value to display in the editor
    //
    // @see listGridField.formatCellValue()
    // @see listGrid.formatEditorValue()
    // @see listGridField.parseEditorValue()
    //
    // @visibility external
    //<

    //> @method listGridField.parseEditorValue
    // Method used to convert the value displayed in an editor for some cell in this field into
    // a raw value for saving.<br>
    // Takes precedence over <code>parseEditorValue</code> defined at the grid level.
    //
    // @group editing
    //
    // @param   value (Any)   value displayed in the editor for the cell
    // @param   record (Object) record object for the row being edited. May be null if this
    //                          is a new row being added to the end of the list.
    // @param   rowNum  (number)    row number for the cell
    // @param   colNum  (number)    column number for the cell.
    // @param   grid    (ListGrid Instance) A pointer to the ListGrid displaying the cell
    // @return (Any) raw value for the field derived from formatted value in editor
    // @see listGrid.parseEditorValue()
    // @see listGridField.formatEditorValue()
    // @visibility external
    //<

    //> @attr listGridField.valueMap (Object | Array of String : null : IRW)
    // Array of legal values for this field, or an Object where each property maps a stored
    // value to a user-displayable value.<br>
    // Note that if this field is editable (see +link{listGrid.canEdit},
    // +link{listGridField.canEdit}), editors displayed for this field will pick up their
    // valueMap either from this value or from +link{listGridField.editorValueMap}.
    // <P>
    // See also +link{dataSourceField.valueMap}.
    //
    // @group display_values
    // @see ListGrid.setValueMap()
    // @see ListGrid.getDisplayValue()
    // @visibility external
    // @example listType
    //<

    //> @attr listGridField.sortByMappedValue (boolean : null : IRW)
    // If +link{listGridField.valueMap} is set, and the grid is +link{listGrid.setSort(),sorted}
    // by this field, should the data be sorted by the underlying data value or the
    // mapped display value. If unset, will sort by display value. Set to <code>false</code>
    // to sort by underlying data value. Note that this has no effect if
    // a +link{listGridField.sortNormalizer} has been specified.
    // @visibility external
    //<

    //> @attr listGridField.multiple (Boolean : null : IR)
    // Indicates that this field should always be Array-valued. This property will be
    // passed through to the generated edit-item when editing the field - so if
    // +link{listGridField.valueMap} is set, the default editor will be a +link{SelectItem} with
    // +link{SelectItem.multiple} set to true.
    // <P>
    // Note that for databound grids it typically makes sense to set +link{DataSourceField.multiple}
    // rather than setting the property directly on the ListGridField object.
    // @group editing
    // @visibility external
    //<

    //> @attr listGridField.editorValueMap (ValueMap : null : IRW)
    // A valueMap to use for editors shown for this field.  By default if this is not
    // specified +link{listGridField.valueMap,field.valueMap} will be used instead.
    // <P>
    // Dynamic valueMaps can be provided by implementing +link{listGrid.getEditorValueMap()}.
    //
    // @group editing
    // @visibility external
    // @see listGrid.getEditorValueMap()
    // @see listGrid.setEditorValueMap()
    //<

    //> @method listGridField.change()
    // If this field is editable, any +link{formItem.change, change} handler specified
    // on the ListGridField will be passed onto the editors for this field.
    // <P>
    // Note that if +link{listGridField.canToggle} is true, the user may change the value of
    // a boolean field without going into edit mode by single clicking on the field. In this
    // case the +link{listGridField.change()} and +link{listGridField.changed()} handlers will
    // fire but the <code>form</code> and <code>item</code> parameters will be null.
    //
    // @param   form    (DynamicForm) the managing DynamicForm instance
    // @param   item    (FormItem)    the editor (form item) itself (also available as "this").
    //                              Note that in addition to the standard FormItem APIs available
    //                              on the editor, it also has:<br>
    //                              - a pointer back to the containing listGrid
    //                              [<code>item.grid</code>]<br>
    //                              - the colNum being edited [<code>item.colNum</code>]<br>
    //                              - the rowNum being edited [<code>item.rowNum</code>]
    // @param   value   (Any)         The new value of the form item
    // @param   oldValue    (Any)     The previous value of the form item
    // @return (Boolean) The change may be cancelled <smartclient>by returning false</smartclient>
    // @see listGridField.changed()
    // @see listGrid.cellChanged()
    // @group editing
    // @visibility external
    //<

    //> @method listGridField.changed()
    // If this field is editable, any +link{formItem.changed, changed} handler specified
    // on the ListGridField will be passed onto the editors for this field.
    // Note that if +link{listGridField.canToggle} is true, the user may change the value of
    // a boolean field without going into edit mode by single clicking on the field. In this
    // case the +link{listGridField.change()} and +link{listGridField.changed()} handlers will
    // fire but the <code>form</code> and <code>item</code> parameters will be null.
    //
    // @param   form    (DynamicForm) the managing DynamicForm instance
    // @param   item    (FormItem)    the editor (form item) itself (also available as "this").
    //                              Note that in addition to the standard FormItem APIs available
    //                              on the editor, it also has:<br>
    //                              - a pointer back to the containing listGrid
    //                              [<code>item.grid</code>]<br>
    //                              - the colNum being edited [<code>item.colNum</code>]<br>
    //                              - the rowNum being edited [<code>item.rowNum</code>]
    // @param   value   (Any)         The current value (after the change).
    // @see listGridField.change()
    // @see listGrid.cellChanged()
    // @group editing
    // @visibility external
    //<

    //> @attr listGridField.emptyCellValue (HTMLString : null : IRW)
    // The value to display for a cell whose value is null or the empty string after
    // applying +link{listGridField.formatCellValue(),formatting} and valueMap (if any).
    // <p>
    // This is the field-specific attribute.  You may also set the +link{ListGrid.emptyCellValue}
    // at the grid level to define the emptyCellValue for all empty fields in the grid.
    //
    // @group display_values
    // @visibility external
    // @example emptyValues
    //<

    //> @attr listGridField.pendingAsyncCellValue (HTMLString : null : IRW)
    // A field-specific value to display for cells whose value is pending asynchronous generation.
    // <p>
    // If set, this will override the grid-wide +link{ListGrid.pendingAsyncCellValue} setting
    // for the field.
    // @see ListGrid.isValuePendingAsync()
    // @visibility AI
    //<

    //> @attr listGridField.asyncErrorCellValue (HTMLString : null : IRW)
    // A field-specific value to display for cells when an error occurred during asynchronous
    // generation.
    // <p>
    // If set, this will override the grid-wide +link{ListGrid.asyncErrorCellValue} setting
    // for the field.
    // @see ListGrid.isValueAsyncError()
    // @visibility external
    //<

    //> @attr listGridField.asyncMissingCellValue (HTMLString : null : IRW)
    // A field-specific value to display for cells whose value was not generated by the previous
    // asynchronous operation to generate it, or will not be generated by an asynchronous operation
    // due to currently being disabled.
    // <p>
    // If set, this will override the grid-wide +link{ListGrid.asyncMissingCellValue} setting
    // for the field.
    // @visibility external
    //<



    // Field.optionDataSource
    // --------------------------------------------------------------------------------------------

    //> @attr listGridField.autoFetchDisplayMap (boolean : null : [IRW])
    // If true, automatically fetches records and derives a valueMap from
    // +link{listGridField.optionDataSource}.
    // <p>
    // Same as +link{listGrid.autoFetchDisplayMap}, but defined on a per-field basis.
    //
    // @group display_values
    // @see listGrid.autoFetchDisplayMap
    // @visibility external
    //<

    //> @attr listGridField.displayValueFromRecord (boolean : null : IRWA)
    // If a +link{listGridField.displayField} is set, should this field show record values from
    // the <code>displayField</code>?
    // <P>
    // If +link{listGridField.displayField} is specified, and there is no separate
    // +link{listGridField.optionDataSource}, by default we will show display-field values
    // from the same record. Setting this property to false would disable this behavior.
    // <P>
    // Alternatively, if there is a +link{listGridField.optionDataSource} (and
    // +link{listGridField.autoFetchDisplayMap} is false), the displayField would be ignored
    // for the field and the underlying +link{listGridField.name,record[fieldName] value} would
    // be displayed to the user. This property may be set to true to override this behavior and
    // pick up values from the <code>displayField</code> for display in this field even when there
    // is an optionDataSource set.
    // <P>
    // Note that this property has no effect on fields with an explicitly specified valueMap, or
    // with an optionDataSource where +link{listGridField.autoFetchDisplayMap} is true.
    // @visibility external
    //<

    //> @attr listGridField.optionTextMatchStyle (TextMatchStyle : null : [IR])
    // For fields with an +link{listGridField.optionDataSource}, where
    // +link{listGridField.autoFetchDisplayMap} is true, this property will govern
    // the <code>textMatchStyle</code> attribute of the +link{DSRequest} parameter passed to
    // +link{DataSource.fetchData()} when retrieving the remote data set to be used as
    // a basis for this field's valueMap.
    // @group display_values
    // @visibility external
    //<

    //> @attr listGridField.optionFilterContext (DSRequest Properties : null : [IR])
    // If this field has an optionDataSource specified and
    // +link{listGridField.autoFetchDisplayMap,autoFetchDisplayMap} is set, this attribute
    // provides a way to customize the dataSource request issued to fetch the display map from
    // the option dataSource.  This provides, among other capabilities, a way to trigger the
    // server to return summary records.
    // @see group:serverSummaries
    // @group display_values
    // @visibility external
    //<

    //> @attr listGridField.optionOperationId (String : null : [IR])
    // If this field has an optionDataSource specified and
    // +link{listGridField.autoFetchDisplayMap,autoFetchDisplayMap} is set, this attribute
    // provides a way to customize the +link{DSRequest.operationId} passed to
    // <code>dataSource.fetchData()</code> when retrieving the display map from the option
    // dataSource.
    // @group display_values
    // @visibility external
    //<

    //> @attr listGridField.optionDataSource (String : null : [IRW])
    // Derive a +link{valueMap} by fetching records from another DataSource and extracting
    // the +link{listGridField.valueField,valueField} and
    // +link{listGridField.displayField,displayField} in the loaded records, to derive one
    // valueMap entry per record loaded from the optionDataSource.
    // <P>
    // Unlike the similar use of +link{pickList.optionDataSource} for +link{PickList,pickLists}
    // used during editing or filtering, <code>listGridField.optionDataSource</code> causes the
    // <b>entire set of records from the optionDataSource to be fetched</b>, without paging.
    // Hence listGridField.optionDataSource is appropriate only for smaller valueMaps, and in 
    // this situation, +link{dataSource.cacheAllData} may be a better choice, since it creates a
    // write-through cache usable across all components.
    // <p>
    // For very large valueMap situations, such as an accountId field that should be displayed 
    // as an accountName where there are thousands of accounts, the correct approach is:
    // <ul>
    // <li> do not set listGridField.optionDataSource
    // <li> declare two fields in the DataSource, eg "accountId" and "accountName".
    // <li> Set the +link{ListGridField.displayField} attribute on the data field to the
    //      name of the display field.
    // <li> When fetching records for display in a grid, have your server send back values for
    //      both fields, but show only the data field ("accountId") in the grid.
    // </ul>
    // In this case the cells in the accountId field will show the record value from the
    // accountName field.  This approach means the valueMap will never be loaded in its
    // entirety, instead, each loaded record contains the valueMapping for that one record, as
    // a pair of fields within the record.
    // <p>
    // If you are using the SmartClient Server Framework with the SQL or JPA/Hibernate built-in
    // connectors, this entire approach can be achieved very easily using the
    // +link{dataSourceField.includeFrom} setting - see the
    // +link{dataSourceField.includeFrom,docs for includeFrom} for details.
    // <P>
    // Notes:
    // <ul>
    // <li>When using the above approach, it is key that the server return <b>both</b>
    // the underlying stored value <b>and</b> the display value, as suggested above.
    // This approach allows the +link{pickList.optionDataSource} property to be used to
    // provide paged valueMaps during inline editing and
    // +link{ListGrid.showFilterEditor,inline filtering}. This can be achieved by setting the
    // <code>optionDataSource</code> attribute on the form item used to edit the field
    // via +link{listGridField.editorProperties} (for editing) or
    // +link{listGridField.filterEditorProperties,field.filterEditorProperties} (for
    // filtering), without specifying an optionDataSource at the listGridField level.
    // Alternatively developers can use +link{listGridField.autoFetchDisplayMap} to
    // suppress the fetch against the optionDataSource at the listGrid level.</li>
    // <li>Setting <code>listGridField.optionDataSource</code> to the same dataSource as the
    // listGrid is not the same as omitting the optionDataSource setting entirely. Unless
    // +link{listGridField.autoFetchDisplayMap} has been set to explicitly disable fetching,
    // a fetch will be performed against the dataSource to build a valueMap which will be used
    // as the definitive mapping from data to display values, rather than picking up the display
    // values from the records themselves. This distinction is required to support cases where
    // the +link{listGridField.valueField} points to a different field in the grid (useful for
    // hierarchical relationships, for example), or where +link{listGridField.optionCriteria} or
    // +link{listGridField.optionOperationId} are specified and return different data from
    // the records displayed within the grid.</li>
    // <li>If a displayField is specified, with no associated optionDataSource, and the field is
    // editable, updating the edit value for the field may not automatically update the displayField
    // edit value, meaning the user may not realize the edit value has been modified.
    // If the new value came from the user editing the field, and the edit item has
    // a valueMap or optionDataSource specified, the display value is picked up automatically and
    // stored out on the displayField for the record. However if the value was set programmatically,
    // the developer should also set the edit value for the display field to ensure the displayed
    // value reflects the new edit value. Note that when this occurs, a warning will be logged
    // which can be disabled via +link{listGrid.warnOnUnmappedValueFieldChange}.</li>
    // <li>For very advanced usage a developer can use +link{listGridField.displayValueFromRecord}
    // to explicitly tell the grid whether or not to display the display field value for the record
    // in this field when a displayField is specified. See documentation on that property for more
    // information</li>
    // </ul>
    //
    // @group display_values
    // @visibility external
    //<

    //> @attr listGridField.valueField (String : null : [IRW])
    // Specifies the +link{listGridField.optionDataSource} field used to retrieve the stored
    // values that are to be mapped to the display values (specified by
    // +link{listGridField.displayField}). Note that if this field is editable this will also
    // be applied to this field's editors.
    //
    // @group display_values
    // @visibility external
    //<

    //> @attr listGridField.displayField (FieldName : null : IRW)
    // Specifies the +link{listGridField.optionDataSource} field used to retrieve the display
    // values that are to be mapped from the internal values specified by +link{valueField}.
    // <P>
    // If no <code>optionDataSource</code> is defined for the field and
    // +link{ListGridField.displayValueFromRecord} is not set to <code>false</code>, the cell will display
    // the displayField value for the current record instead of the underlying value for
    // this field.  This approach can be used for situations where field values need a
    // stored-value-to-displayed-value mapping, but the set of all possible values is too large to
    // load as a +link{ValueMap} - see +link{listGridField.optionDataSource} for more details
    // on this approach.  Note that if this field is editable this will also be applied to this
    // field's editors.  +explorerExample{largeValueMapSQL,This sample} illustrates this
    // approach achieved via a server-side SQL join.
    // <p>
    // The display value for a record with a specified <code>displayField</code> can be
    // picked up via +link{ListGrid.getDisplayValue()}.
    //
    // @group display_values
    // @visibility external
    //<

    //> @attr listGridField.sortByDisplayField (boolean : null : [IRW])
    // For a field with +link{ListGridField.displayField} configured, should client-side sorting
    // be performed on the display field value? Unless explicitly set to <code>false</code>,
    // the display field value is used.
    //
    // @group display_values
    // @visibility external
    //<

    //> @attr listGridField.optionCriteria (Criteria : null : [IRW])
    // If +link{optionDataSource} is set for this ListGridField, criteria specified in this
    // attribute will be passed to the dataSource when performing the fetch operation to
    // determine data-value to display-value mappings
    // <P>
    // See also +link{listGridField.optionTextMatchStyle}.
    // @group display_values
    // @visibility external
    //<


    // ---------

    //> @attr listGridField.includeFrom (String : null : [IR])
    // Indicates this field's values should be fetched from another, related DataSource.
    // The individual field will inherit settings such as +link{listGridField.type,field.type}
    // and +link{listGridField.title,field.title} from the related DataSource just like
    // fields from the primary DataSource.
    // <P>
    // When +link{listGrid.fetchData(),fechData()} is called, the automatically created +link{DSRequest} will
    // specify +link{dsRequest.additionalOutputs} requesting the field, and any +link{Criteria}
    // generated by the component will likewise refer to the field from the related DataSource.
    // <P>
    // It's an error to use this property if the ListGrid does not have a DataSource at all.
    // The related DataSource must be loaded or a warning will be logged and the field
    // definition ignored.
    // <P>
    // This value is expected to be set to the following format
    // <code>dataSourceID.fieldName</code> where <i>dataSourceID</i> is the ID of the
    // related dataSource and <i>fieldName</i> is the name of the field from that dataSource
    // from which you wish to retrieve values. Note that if this property is set and
    // +link{ListGridField.name,field.name} is not explicitly specified, this field's <code>name</code> will
    // default to the <i>fieldName</i> value from this property.
    // <p>
    // Note about automatic cache updates: "update" and "add" operations
    // submitted automatically by this ListGrid will include
    // <code>dsRequest.additionalOutputs</code> to ensure all data necessary
    // for cache updates is returned by the server.
    // <p>
    // If your grid shows data that can be edited elsewhere in the UI (not by
    // inline editing), to avoid problems with +link{ResultSet} automatic
    // cache synchronization, you may need to switch from using
    // <code>listGridField.includeFrom</code> to
    // <code>dataSourceField.includeFrom</code>.  This is because
    // server responses to "add" and "update" operations which are initiated
    // outside of this grid do not know about the
    // <code>listGridField.includeFrom</code> setting, and so will not
    // automatically return data for fields included in this way.  Switching
    // to <code>dataSourceField.includeFrom</code> ensures the field is
    // always included in server responses, avoiding the issue.
    //
    // @group display_values
    // @visibility crossDS
    //<

    // ----------------------------------------------------------------------------------------
    // Don't show scrollbars -- scrolling occurs in the body

    //> @attr listGrid.overflow (Overflow : Canvas.HIDDEN : IRW)
    // Since +link{body} is configured with overflow: auto by default, no overflow
    // is expected for the +link{listGrid} itself so by default it has overflow: hidden.
    // @see layout.overflow
    // @visibility external
    //<
    overflow:isc.Canvas.HIDDEN,

    //> @attr listGrid.backgroundColor (String : "white" : IRW)
    // @group appearance
    //<
    backgroundColor:"white",

    //> @attr listGrid.minHeight (number : varies : IRW)
    // Sets the +link{canvas.minHeight,minimum height} for the entire list (smaller than this
    // doesn't tend to work very well).  If not set, this value will be defaulted when
    // +link{draw()} is called to something reasonable based on whether we're showing the
    // +link{showFilterEditor,filter editor}, +link{showHeader,header}, 
    // +link{showGridSummary,summary rows}, and/or the +link{showEmptyMessage,empty message}.
    // Any top or bottom CSS padding specified by +link{emptyMessageStyle} will be taken into
    // account, increasing <code>minHeight</code> so that the empty message can be shown without
    // overflow.
    // <P>
    // <b>Note:</b> Minimum sizes do not apply to all situations.
    // See +link{canvas.minWidth,minimum sizing rules} for details.
    //
    // @group sizing
    // @see canvas.minHeight
    // @visibility external
    //<

    // sum up contributions from each member of LG as a VLayout
    _getDefaultMinHeight : function () {
        
        var minHeight = this.cellHeight + this.getVMarginBorderPad();
        
        if (this.showHeader)       minHeight += this.headerHeight;
        if (this.showFilterEditor) minHeight += this.filterEditorHeight;
        if (this.showEmptyMessage) minHeight += this._getEmptyMessageStyleVPad();
        if (this.showGridSummary)  minHeight += this.summaryRowHeight;
        return minHeight;
    },

    defaultWidth:200,

    //> @attr listGrid.recordSummaryAttributePrefix (String : "_" : IRA)
    // Prefix prepended to the name of a +link{listGridField.recordSummaryFunction,"summary"}
    // +link{listGridField.type,type} field when accessing its value as record metadata.
    // The Framework may write out this value to make rendering the cell values or calculating
    // a +link{showGridSummary,grid summary row} or +link{showGroupSummary,group summary rows}
    // more efficient.
    // @see listGridField.type
    // @see listGridField.recordSummaryFunction
    // @visibility external
    //<
    recordSummaryAttributePrefix: "_",

    _getRecordSummaryAttributeProperty : function (field) {
        var fieldName = isc.isA.String(field) ? field : field.name;
        return this.recordSummaryAttributePrefix + fieldName;
    },

    // GridRenderer properties
    // ---------------------------------------------------------------------------------------

    //> @attr listGrid.showAllRecords (Boolean : false : [IRW])
    // Whether all records should be drawn all at once, or only records visible in the
    // viewport.
    // <P>
    // Drawing all records causes longer initial rendering time, but allows smoother vertical
    // scrolling.  With a very large number of records, showAllRecords will become too slow.
    // <P>
    // This setting is incompatible with +link{dataFetchMode}: "paged" as it requires all
    // records matching the criteria to be fetched from the server at once.
    //
    // @see drawAheadRatio
    // @see drawAllMaxCells
    // @group performance
    // @visibility external
    // @example autofitRows
    //<
    //showAllRecords:false,

    //> @attr listGrid.showAllColumns (Boolean : false : IR)
    // @include gridRenderer.showAllColumns
    //<
    //showAllColumns:false,

    //> @attr listGrid.drawAllMaxCells (int : 250 : IRWA)
    // @include gridRenderer.drawAllMaxCells
    // @group performance
    // @visibility external
    //<
    drawAllMaxCells:250,


    //> @attr listGrid.drawAheadRatio (float : 2.0 : IRW)
    // How far should we render records ahead of the currently visible area?  This is expressed as
    // a ratio from viewport size to rendered area size.
    // <P>
    // Tweaking drawAheadRatio allows you to make tradeoffs between continuous scrolling speed vs
    // initial render time and render time when scrolling by large amounts.
    // <P>
    // NOTE: Only applies when showAllRecords is false.
    //
    // @group performance
    // @visibility external
    // @example databoundFetch
    //<
    drawAheadRatio: isc.Browser.useHighPerformanceGridTimings ? 2.0 : 1.3,

    //> @attr listGrid.quickDrawAheadRatio (float : 2.0 : IRW)
    // @include gridRenderer.quickDrawAheadRatio
    // @group performance
    //<
    quickDrawAheadRatio: isc.Browser.useHighPerformanceGridTimings ? 2.0 : 1.0,

    //> @attr listGrid.instantScrollTrackRedraw (Boolean : true : IRW)
    // @include gridRenderer.instantScrollTrackRedraw
    // @group performance
    // @visibility external
    //<

    //> @attr listGrid.scrollRedrawDelay (int : 0 : IRW)
    // @include gridRenderer.scrollRedrawDelay
    // @group performance
    // @visibility external
    //<
    scrollRedrawDelay: isc.Browser.useHighPerformanceGridTimings ? 0 : 75,

    //> @attr listGrid.dragScrollRedrawDelay (int : 75 : IRW)
    // @include gridRenderer.dragScrollRedrawDelay
    // @group performance
    // @visibility external
    //<
    dragScrollRedrawDelay: 75,
    
    //> @attr listGrid.scrollWheelRedrawDelay (Integer : 0 : IRW)
    // While scrolling an incrementally rendered grid, using the mouseWheel, time in 
    // milliseconds to wait before redrawing, after the last mouseWheel movement by the user.  
    // If not specified +link{scrollRedrawDelay} will be used as a default for both
    // drag scrolling and mouseWheel scrolling.
    // <P>
    // Note that if specified, this value will typically be larger than 
    // +link{scrollRedrawDelay}. From experimentation, the default setting of 
    // <code>250</code> is typically enough time for a user to rapidly scroll through a
    // grid (rotating the scroll wheel with repeated flicks), without redrawing between
    // rotations, but this will differ depending on how long the redraw takes. A larger
    // delay may be warranted for grids with large numbers of columns, heavy custom 
    // formatting, etc.
    // <P>
    // See also
    // +link{gridRenderer.instantScrollTrackRedraw} for cases where this delay is skipped.
    //
    // @group performance
    // @visibility external
    //<
    scrollWheelRedrawDelay: isc.Browser.useHighPerformanceGridTimings ? 0 : 250,

    //> @attr listGrid.touchScrollRedrawDelay (Integer : 0 : IRW)
    // While scrolling an incrementally rendered grid, using the inertial scrolling, time in 
    // milliseconds to wait before redrawing, after the last touchScroll by the user.  
    // If not specified +link{scrollRedrawDelay} will be used as a default for both
    // drag scrolling and touch scrolling.
    // <P>
    // Note that if specified, this value will typically be larger than 
    // +link{scrollRedrawDelay}.
    // <P>
    // See also
    // +link{gridRenderer.instantScrollTrackRedraw} for cases where this delay is skipped.
    //
    // @group performance
    // @visibility external
    //<
    touchScrollRedrawDelay: isc.Browser.useHighPerformanceGridTimings ? 0 : 300,
    
    //> @attr listGrid.virtualScrolling (boolean : null : [IRA])
    // When incremental rendering is switched on and there are variable record heights, the virtual
    // scrolling mechanism manages the differences in scroll height calculations due to the
    // unknown sizes of un-rendered rows to make the scrollbar and viewport appear correctly.
    // <P>
    // When the <code>virtualScrolling</code> system is active, the last scroll position
    // scrolls the last record to the top of the viewport, leaving blank space underneath.
    // This is a necessary and unavoidable consequence of mapping the position of the scrollbar
    // thumb to an unknown amount of remaining space without being able to know the total
    // scrollable area in advance (since record heights vary).
    // <P>
    // virtualScrolling is switched on automatically when +link{fixedRecordHeights} is false and
    // also when
    // using the +link{listGrid.showRecordComponents,recordComponents subsystem}, as
    // recordComponents expand the rows that contain them. This flag should be manually enabled
    // when calling +link{listGrid.addEmbeddedComponent()} if embedded components can
    // cause record sizes to expand beyond specified cellHeight.
    // <P>
    // virtualScrolling is also automatically enabled when +link{listGrid.canExpandRecords} is true
    // to handle the fact that expanded rows may render at variable heights.
    //
    // @see recordComponentHeight
    // @visibility external
    //<

    //> @attr listGrid.dataPageSize (Integer : null : IRW)
    // @include dataBoundComponent.dataPageSize
    // @group performance
    // @visibility external
    // @example databoundFetch
    //<

    //> @attr listGrid.dataFetchMode (FetchMode : "paged" : IR)
    // @include dataBoundComponent.dataFetchMode
    // @see listGrid.showAllRecords
    //<

    // configures ResultSet.fetchDelay, delay in MS before fetches are triggered
    
    // NOTE: setting this value to 0 causes filterData() to fire its callback twice - at least
    // in part because RS acts synchronously in this case and various LG/DBC logic expects to
    // markForRedraw() which acts on a timer.
    //
    //> @attr ListGrid.dataFetchDelay (Integer : 1 : IRWA)
    // Delay in milliseconds before fetching data.
    // <P>
    // Note: the floor value for this attribute is 1.  If you set this value to zero, it will
    // be defaulted to 1 for you instead.
    //
    // @group databinding
    // @see DataBoundComponent.dataFetchDelay
    // @see ResultSet.fetchDelay
    // @visibility external
    //<
    dataFetchDelay : isc.Browser.useHighPerformanceGridTimings ? 1 : 300,

    //> @attr listGrid.body (MultiAutoChild GridRenderer : null : R)
    // GridRenderer used to render the dataset.
    // <p>
    // Note that this is a multi-instance component when there are frozen fields because in
    // addition to the primary body AutoChild, a "frozen body" AutoChild is created to render
    // the frozen portion of the dataset.
    // @see ListGrid.getBody()
    // @visibility external
    //<
    body:null,

    bodyConstructor:"GridBody",

    //> @attr listGrid.bodyOverflow (Overflow : isc.Canvas.AUTO : [IRWA])
    // Overflow setting for the "body", that is, the area of the grid where data values are
    // rendered.
    // <P>
    // <b>This is a very advanced setting</b> which is typically only changed by subclasses
    // of ListGrid which never show a header.  To achieve auto-fitting, instead use properties
    // such as +link{listGrid.autoFitData}, +link{listGrid.autoFitFieldWidths} and
    // +link{listGrid.fixedRecordHeights}.
    //
    //      @visibility external
    //      @group  sizing
    //      @example autofitRows
    //<
    bodyOverflow:isc.Canvas.AUTO,
    

    //> @attr listGrid.bodyBackgroundColor (String : "white" : IRW)
    // Background color applied to the ListGrid body (that is, the area of the grid where
    // data values are rendered).<br>
    // Note that this will typically not be visible to the user unless there are few enough
    // rows that there is visible space in the body below the last row. To style data cells,
    // override +link{ListGrid.baseStyle} instead.
    //      @group  appearance
    // @visibility external
    //<
    bodyBackgroundColor:"white",

    //> @attr listGrid.bodyStyleName (CSSStyleName : null : IRW)
    // CSS style used for the body of this grid.  If applying a background-color to the body
    // via a CSS style applied using this property, be sure to set
    // +link{ListGrid.bodyBackgroundColor} to <code>null</code>.
    //      @group  appearance
    // @visibility external
    //<
    //bodyStyleName:null,

    //> @attr listGrid.frozenBodyStyleName (CSSStyleName : null : IRW)
    // CSS style used for the +link{listGrid.canFreezeFields, frozen-body} of this grid.  If 
    // applying a background-color to the body via a CSS style applied using this property, be 
    // sure to set +link{ListGrid.bodyBackgroundColor} to <code>null</code>.
    // @group appearance
    // @visibility external
    //<
    //frozenBodyStyleName:null,

    // whether to allow the body and header to have different border sizes and automatically
    // adjust the body column sizes to compensate such that column boundaries line up.
    allowMismatchedHeaderBodyBorder : true,

    //> @attr listGrid.emptyCellValue (HTMLString : "&nbsp;" : IRW)
    // The value to display for cells whose value is null or the empty string after applying
    // +link{listGrid.formatCellValue(),formatting} and valueMap (if any).
    // <p>
    // This is the grid-wide attribute.  You may also set the +link{ListGridField.emptyCellValue}
    // on a per-field basis.
    //
    // @group cellStyling
    // @see ListGrid.pendingAsyncCellValue
    // @see ListGrid.asyncErrorCellValue
    // @see ListGrid.asyncMissingCellValue
    // @visibility external
    // @example emptyValues
    //<
    emptyCellValue:"&nbsp;",

    //> @attr listGrid.pendingAsyncCellValue (HTMLString : "&nbsp;" : IRW)
    // The value to display for cells whose value is pending asynchronous computation.
    // <p>
    // This is the grid-wide setting. +link{ListGridField.pendingAsyncCellValue} can override
    // the grid setting for a specific field.
    // @see ListGrid.isValuePendingAsync()
    // @visibility external
    //<
    pendingAsyncCellValue:"&nbsp;",

    //> @attr listGrid.asyncErrorCellValue (HTMLString : "!" : IRW)
    // The value to display for cells when an error occurred during asynchronous computation.
    // <p>
    // This is the grid-wide setting. +link{ListGridField.asyncErrorCellValue} can override
    // the grid setting for a specific field.
    // @see ListGrid.isValuePendingAsyncOrAsyncError()
    // @group i18nMessages
    // @visibility external
    //<
    asyncErrorCellValue:"!",

    //> @attr listGrid.asyncMissingCellValue (HTMLString : "-" : IRW)
    // The value to display for cells whose value was not computed by the previous asynchronous
    // operation to compute it, or will not be computed by an asynchronous operation due to
    // currently being disabled.
    // For example, the previous asynchronous operation may have been canceled, or the grid
    // may be displaying too many values to compute AI-generated values for a field.
    // <p>
    // This is the grid-wide setting. +link{ListGridField.asyncMissingCellValue} can override
    // the grid setting for a specific field.
    // @group i18nMessages
    // @visibility external
    //<
    asyncMissingCellValue:"-",

    //> @attr listGrid.minimumCellHeight (number : 20 : IR)
    // Minimum height for ListGrid cells, settable by the skin, based on the size of the 
    // checkbox media used for boolean fields plus minimal surrounding padding.  
    // <code>minimumCellHeight</code> is used by +link{Canvas.resizeControls()} to 
    // avoid shrinking ListGrid rows so much that correct display is impossible.  
    // Do not set minimumCellHeight on a per-instance basis - it's only for use in custom skins.
    // @visibility external
    //<
    minimumCellHeight:20,

    //> @attr listGrid.cellHeight (number : 20 : [IRW])
    // Default height for each row in pixels. See +link{listGrid.fixedRecordHeights} and
    // +link{listGrid.enforceVClipping} for information on how rows are sized when 
    // cell content height exceeds this specified value.
    // @visibility external
    // @example multilineValues
    //<
    cellHeight:20,

    //> @attr listGrid.normalCellHeight (number : 20 : [IRWA])
    // If +link{listGrid.baseStyle} is unset, base style will be derived from
    // +link{listGrid.normalBaseStyle} if this grid has fixed row heights and
    // the specified +link{listGrid.cellHeight} matches this value. Otherwise
    // +link{listGrid.tallBaseStyle} will be used.
    // @visibility external
    //<
    normalCellHeight:20,

    //> @attr listGrid.fixedRecordHeights (Boolean : true : IRWA)
    // Should we vertically clip cell contents, or allow rows to expand vertically to show all
    // contents?
    // <P>
    // If we allow rows to expand, the row height as derived from
    // +link{gridRenderer.getRowHeight(),getRowHeight()} or the
    // default +link{cellHeight} is treated as a minimum.
    // <P>
    // Setting <code>fixedRecordHeights</code> to false enables the +link{virtualScrolling}
    // system.
    // <P>
    // <b>NOTE:</b><ul>
    // <li>Setting fixedRecordHeights to false for +link{CubeGrid} is not supported, though a
    // similar option for the row headers is available as +link{CubeGrid.autoSizeHeaders}.
    // <li>By default, for performance reasons, clipping is not enforced for
    // some kinds of content (such as images) on all browsers.  Set
    // +link{enforceVClipping,enforceVClipping:true} to enforce clipping for
    // all types of content on all browsers.
    // </ul>
    //
    // @include gridRenderer.fixedRowHeights
    // @example autofitValues
    //<
    fixedRecordHeights: true,
    
    //> @attr listGrid.variableRecordHeightFields (Array of ListGridField : null : IRWA)
    // If +link{listGrid.fixedRecordHeights} is false, and this grid has 
    // +link{listGridField.frozen,frozen fields}, this property may be used to identify
    // a specific field or set of fields expected to vertically overflow the specified 
    // +link{listGrid.cellHeight}, causing rows to expand.
    // <P>
    // This is an advanced property provided for performance improvement. By expressly
    // specifying which fields can drive the rendered heights of rows, the system can
    // target logic to ensure row heights are consistent across frozen and unfrozen fields,
    // etc on cells from those specific fields, making such logic more efficient.
    // <P>
    // Note that setting this property will not cause other fields to be clipped
    // @visibility internal
    //<
    // We currently use this to optimize the rowHeightSpacerHTML strategy for
    // specific columns.
     
    
//     variableRecordHeightFields:null,

    //> @attr listGrid.enforceVClipping (Boolean : false : IRW)
    // For performance reasons, even when +link{fixedRecordHeights} is set, vertical clipping
    // is not enforced by default for some kinds of content (such as images) on all browsers.
    // Set +link{enforceVClipping,enforceVClipping:true} to enforce clipping for all types of
    // content on all browsers.
    // <P>
    // This additional setting is likely to be phased out as browsers improve.
    //
    // @visibility external
    //<
    

    //> @attr listGrid.fixedFieldWidths (Boolean : true : IRWA)
    // Should we horizontally clip cell contents, or allow columns to expand horizontally to
    // show all contents?
    // <P>
    // If we allow columns to expand, the column width is treated as a minimum.
    // <P>
    // NOTE: the header does not automatically respond to expanded field widths.
    // If your grid is showing a header we'd recommend developers consider
    // setting +link{listGrid.autoFitFieldWidths} rather than using this attribute.
    // @group cellStyling
    // @visibility external
    //<
    // NOTE: doc is duplicated here because in the ListGrid we need to discuss the header.
    fixedFieldWidths:true,
    
    // Frozen fields combined with variable rowHeights
    
    matchFrozenRowHeightsApproach:"rowHeightSpacerHTML",
    
    // autoFit attributes

    //> @type Autofit 
    // Possible values to change the behavior of how data will fill the ListGrid.
    // @value "vertical" expand vertically to accommodate records.
    // @value "horizontal" expand horizontally to accommodate fields.
    // @value "both" expand horizontally and vertically to accommodate content.
    // @group autoFitData
    // @visibility external
    //<

    //> @attr listGrid.autoFitData (Autofit : null : IRW)
    // Should this ListGrid automatically expand to accommodate the size of records and fields?
    // <P>
    // Valid settings are
    // <ul><li><code>"vertical"</code>: expand vertically to accommodate records.</li>
    //     <li><code>"horizontal"</code>: expand horizontally to accommodate fields.</li>
    //     <li><code>"both"</code>: expand horizontally and vertically to accommodate content.</li>
    // </ul>
    // How far the ListGrid will expand may be limited via the following properties:
    // +link{ListGrid.autoFitMaxHeight}, +link{ListGrid.autoFitMaxRecords},
    // +link{ListGrid.autoFitMaxWidth}, +link{ListGrid.autoFitMaxColumns}.
    // <P>
    // Note that this property causes the grid as a whole to expand to fit records or fields.
    // To have the fields or records themselves expand to fit cell contents, see
    // +link{listGrid.autoFitFieldWidths} and +link{listGrid.fixedRecordHeights}.
    // @group autoFitData
    // @visibility external
    //<

    //> @attr listGrid.autoFitMaxHeight (Integer : null : IRW)
    // If +link{listGrid.autoFitData} is set to <code>"vertical"</code> or <code>"both"</code> this
    // property provides an upper limit on how far the ListGrid will expand vertically to accommodate
    // its content. If content exceeds this height, scrollbars will be introduced as usual.
    // In addition to this property, +link{ListGrid.autoFitMaxRecords} allows you to limit vertical
    // expansion based on the number of rows to be rendered.
    // <p>
    // Note: Unlike +link{ListGrid.autoFitMaxWidth}, this property cannot be set to a string
    // percentage value; it must be a numeric pixel value or <code>null</code>.
    // @group autoFitData
    // @visibility external
    //<

    //> @attr ListGrid.autoFitMaxRecords (int : 50 : IRW)
    // If +link{listGrid.autoFitData} is set to <code>"vertical"</code> or <code>"both"</code> this
    // property provides the maximum number of records for which the ListGrid will expand. If more
    // records are present, scrolling will be introduced to reach them as normal.
    // If unset, by default the ListGrid will expand to accommodate as many records as are present.
    // @group autoFitData
    // @visibility external
    //<
    autoFitMaxRecords:50,

    //> @attr ListGrid.autoFitExtraRecords (Integer : null : IRW)
    // If +link{listGrid.autoFitData} is set to <code>"vertical"</code> or <code>"both"</code>,
    // setting this property will cause the ListGrid body to size large enough to accommodate
    // the actual data and also leave this many extra rows' worth of blank space below the last
    // record. If a maximum size is specified via +link{listGrid.autoFitMaxHeight} or
    // +link{listGrid.autoFitMaxRecords}, it will still be respected. Once the data set
    // is large enough to fill or exceed that space, this property no longer has an effect.
    // @group autoFitData
    // @visibility external
    //<
//    autoFitExtraRecords:0,

    //> @attr listGrid.autoFitMaxWidth (Integer | String : null : IRW)
    // If +link{listGrid.autoFitData} is set to <code>"horizontal"</code> or <code>"both"</code>
    // this property provides an upper limit on how far the ListGrid will expand horizontally to
    // accommodate its content. Value may be specified as a numeric pixel value or
    // a percentage value.
    // <P>
    // If content exceeds this width, scrollbars will be introduced as usual.
    // In addition to this property, +link{ListGrid.autoFitMaxColumns} allows you to limit
    // horizontal expansion based on the number of columns to be rendered.
    // @group autoFitData
    // @visibility external
    //<
    
    //>@method listGrid.getDataSource()
    // The DataSource that this component should bind to for default fields and 
    // for performing +link{DSRequest,DataSource requests}.
    //
    // @return (DataSource)  Datasource object for this ListGrid instance.
    // @visibility external
    //<
    
    //> @method listGrid.getAutoFitMaxWidth()
    // Returns the +link{listGrid.autoFitMaxWidth}. Note that this method always returns
    // an integer value - autoFitMaxWidth specified as a percentage will be resolved
    // to a pixel value before being returned.
    //
    // @return (Integer) autoFitMaxWidth pixel value
    // @visibility external
    // @group autoFitData
    //<
    getAutoFitMaxWidth : function () {
        var width = this.autoFitMaxWidth;
        if (width != null) {
            if (!isc.isA.Number(width)) {
                if (this._autoFitMaxPixelWidth == null) {
                    this._autoFitMaxPixelWidth = 
                        this._convertPercentageWidth(this.autoFitMaxWidth);
                }
                width = this._autoFitMaxPixelWidth;
            }
        }
        return width;
    },
    
    // Method to resolve a percentage width value to a pixel value based on the
    // size of this widget's container
    // Used for autoFitMaxWidth
    
    _convertPercentageWidth : function (percentWidth) {

        // get the relevant full size
        // this is the page width/height if this canvas has no parents, or
        // the parent element's inner width/height, otherwise
        var parent, fullSize, insideParent;
        
        // viewport vs outer size determined by percentBox setting
        if (this.percentSource || (this.snapTo && this.masterElement)) {
            parent = this.percentSource || this.masterElement;
            insideParent = (this.percentBox == this._$viewport),
            fullSize = (insideParent ? parent.getViewportWidth()
                                                  : parent.getVisibleWidth());
        } else {
            parent = this.parentElement;

            
            if (isc.Layout && isc.isA.Layout(parent) && parent.hasMember(this)) {
                fullSize = !parent.vertical ? parent.getTotalMemberSpace() :
                                        parent.getBreadth() - parent._getBreadthMargin();
            } else if (parent) {
                fullSize = parent.getInnerWidth();
            } else {
                fullSize = isc.Page.getWidth();
            }
        }
        
        
        
        return Math.round((parseInt(percentWidth, 10) / 100) * fullSize);
        
    },
    
    _resolvePercentageSize : function () {
        if (this.autoFitMaxWidth != null && !isc.isA.Number(this.autoFitMaxWidth)) {
            delete this._autoFitMaxPixelWidth;
            // Mark for adjust overflow - this will resize the grid as a whole if necessary
            if (this.body) {
                this.body._markForAdjustOverflow("Resolving percentage autoFitMaxWidth");
            }
        }
        this.Super("_resolvePercentageSize", arguments);
    },
    
    
    
    //> @attr ListGrid.autoFitMaxColumns (int : 50 : IRW)
    // If +link{listGrid.autoFitData} is set to <code>"horizontal"</code> or <code>"both"</code>
    // this property provides the maximum number of columns for which the ListGrid will expand.
    // If more columns are present, scrolling will be introduced to reach them as normal.
    // If unset the ListGrid will expand to accommodate as many columns as are defined for the
    // grid.
    // @group autoFitData
    // @visibility external
    //<
    autoFitMaxColumns:50,


    //> @attr listGrid.canAutoFitFields (Boolean : true : IRW)
    // Can the user perform one-time autofit for specific columns in this grid?
    // <P>
    // If set to true, the default header menu will include options to auto fit
    // +link{listGrid.autoFitAllText,all fields} such that they fit their
    // content or titles as specified via +link{listGridField.autoFitWidthApproach}.<br>
    // Autofitting of individual fields via a
    // +link{listGrid.autoFitFieldText,header context menu item}, or the
    // +link{listGrid.headerAutoFitEvent} will also be enabled when this
    // property is set unless +link{listGridField.canAutoFitWidth} is explicitly set to false
    // <P>
    // Note that the ability to perform one-time autofitting of fields via this 
    // subsystem is separate from the programmatic autofit behavior enabled 
    // via +link{listGrid.autoFitFieldWidths}.
    // <P>
    // This subsystem is requires canResizeFields be enabled and will be disabled if
    // that property is set to false
    // @visibility external
    // @group autoFitFields
    //<
    
    canAutoFitFields:true,
    

    //> @type AutoFitEvent
    // Event on a listGrid header to trigger auto-fit of the listgrid field.
    // @value "doubleClick" React to a double click on the listGrid header.
    // @value "click" React to a click on the listGrid header.
    // @value "none" No event will trigger auto-fit.
    // @group autoFitFields
    // @visibility external
    //<

    //> @attr listGrid.headerAutoFitEvent (AutoFitEvent : "doubleClick" : IR)
    // Event on a ListGrid header that triggers auto fitting to data and/or title.
    // <P>
    // Note that if sorting is enabled for the field and the headerAutoFitEvent is "click", both
    // sorting and autofit occur on a click.
    // <P>
    // Only has an impact when +link{listGrid.canAutoFitFields} or 
    // +link{listGridField.canAutoFitWidth} is set to <code>true</code>.
    //
    // @visibility external
    // @group autoFitFields
    //<
    headerAutoFitEvent:"doubleClick",

    //> @attr listGridField.canAutoFitWidth (Boolean : null : IR)
    // Should the user be allowed to perform one-time autofitting of this field via
    // a header context-menu option?
    // <P>
    // When enabled, the default header context menu for this field will
    // include an item to auto-fit the field and users will be able to autofit the field
    // via the +link{listGrid.headerAutoFitEvent}.
    // <P>
    // If unset, these behaviors are enabled when +link{listGrid.canAutoFitFields} is true.
    // <P>
    // If this property is set to false, and +link{listGrid.canAutoFitFields} is true,
    // this field will be ommitted from auto-fit when the user selects the header menu 
    // option to +link{listGrid.autoFitAllText,auto fit all fields}.
    // <P>
    // Note - this property governs user-initiated auto-fit only. It has no impact on
    // autoFit set up via +link{listGridField.autoFitWidth} and +link{listGrid.autoFitFieldWidths}.
    // <P>
    // Note that if +link{listGrid.showRecordComponents,showing record components}, per-cell record
    // components are not taken into account when determining the size for column auto fit.
    // The default +link{listGrid.getDefaultFieldWidth()} implementation looks at cell content
    // only. We typically recommend that, for fields showing record-components, 
    // +link{listGridField.autoFitWidth} and +link{listGrid.canAutoFitFields} be disabled, or if 
    // the record components are of a predictable size, a +link{listGridField.defaultWidth}
    // be specified.<br>
    // This is particularly pertinent where +link{listGrid.recordComponentPosition}
    // is set to "within", in which case cells' content is often empty or completely covered
    // by record-components.
    //
    // @see listGrid.autoFitDateFields
    // @see listGrid.autoFitTimeFields
    // @visibility external
    //<

    //> @attr listGridField.autoFit (AutoFitWidthApproach : null : [IRW])
    // When set, this attribute causes this field to be auto-sized directly by effectively 
    // setting +link{listGridField.autoFitWidth} to true and applying an
    // +link{listGridField.autoFitWidthApproach}.  This direct approach is different from 
    // and less verbose than applying +link{listGrid.autoFitFieldWidths, similar properties} 
    // on the +link{class:ListGrid, grid} and overriding them on a per-field basis.
    // @group autoFitFields
    // @visibility external
    //<

    //> @attr listGridField.autoFitWidth (Boolean : null : IR)
    // Should this listGrid field autofit its width to either titles or content?
    // <P>
    // This overrides the +link{listGrid.autoFitFieldWidths} attribute on a per-field basis.
    // <P>
    // Note that if +link{listGrid.showRecordComponents,showing record components}, per-cell record
    // components are not taken into account when determining the size for column auto fit.
    // The default +link{listGrid.getDefaultFieldWidth()} implementation looks at cell content
    // only. We typically recommend that, for fields showing record-components, 
    // +link{listGridField.autoFitWidth} and +link{listGridField.canAutoFitWidth} be disabled, or if 
    // the record components are of a predictable size, a +link{listGridField.defaultWidth}
    // be specified.<br>
    // This is particularly pertinent where +link{listGrid.recordComponentPosition}
    // is set to "within", in which case cells' content is often empty or completely covered
    // by record-components.        
    // <p>
    // For a more direct alternative, see +link{listGridField.autoFit}, which effectively turns
    // on this setting and applies +link{listGridField.autoFitWidthApproach} with a single 
    // property.
    // @setter ListGrid.setAutoFitWidth()
    // @see listGrid.autoFitDateFields
    // @see listGrid.autoFitTimeFields
    // @visibility external
    // @group autoFitFields
    //<
    
    //> @attr listGridField.defaultWidth (Integer : null : IR)
    // Optional "default width" for this field. If set, this value will be returned by the
    // +link{listGrid.getDefaultFieldWidth()} method, and used as the autoFit size for
    // the field's content.
    //
    // @visibility external
    // @group autoFitFields
    //<

    //> @attr listGrid.autoFitFieldWidths (Boolean : null : IR)
    // Should ListGrid fields autofit their widths to titles or content?
    // This property may be overridden on a per-field basis via +link{listGridField.autoFitWidth}.
    // Developers may wish to consider disabling autoFit for fields known to have 
    // exceptionally long content as this can lead to large horizontal scrollbars and unwieldy UI.
    // <P>
    // The +link{listGrid.autoFitWidthApproach} controls whether fitting is to values, titles
    // or both. This property may also be overridden on a per field basis.
    // <P>
    // If +link{listGridField.width,field.width} is also set on the field, it will be taken as a minimum width.
    // +link{listGrid.minFieldWidth} will also be respected.
    // <P>
    // By default, the entire available width of the grid will still be used, by allocating any "extra"
    // space to specific columns - see +link{listGrid.autoFitFieldsFillViewport} for details on
    // controlling this behavior.
    // <P>
    // When this feature is enabled, autofitting is active on an ongoing basis.
    // Autofitting will be performed:
    // <ul>
    //  <li> whenever the dataset is completely changed or rows are added or removed
    //  <li> whenever a field which is autofitting is changed
    //  <li> on a manual call to +link{listGrid.autoFitField()} or
    //       +link{listGrid.autoFitFields()}
    // </ul>
    // Auto-fitting behavior continues until the user resizes the field manually, at which
    // point it stops. The user can also perform a one-time auto-fit of fields via
    // the header context menu if +link{listGrid.canAutoFitFields} is enabled.
    // <P>
    // When autofitting to column values, +link{listGrid.getDefaultFieldWidth()} will be
    // called to determine the space required for a field's values. This method
    // uses values from the rendered set of rows to calculate the required column width, which means the
    // field width may still be smaller than values from non-rendered rows.  See
    // +link{listGrid.showAllRecords} and +link{listGrid.drawAheadRatio}) to control incremental
    // rendering of rows.
    // <P>
    // Note that for <code>icon</code> type fields, the +link{listGrid.autoFitIconFields}
    // property setting may turn on auto-fit-width behavior for specific fields by default,
    // even if <code>autoFitFieldWidths</code> is false for the grid as a whole.
    // <P>
    // Using this feature has a performance penalty roughly comparable to always rendering
    // one additional field per field where autofitting is enabled.  Specifically, enabling it
    // for all fields would be comparable to <i>both</i> doubling the number of fields
    // <i>and</i> disabling +link{listGrid.showAllColumns,horizontal incremental rendering}.
    // In a grid where only half the fields are normally visible and hence only half are
    // normally rendered, this would be roughly 4 times slower overall.
    // <P>
    // This performance penalty is a result of +link{getDefaultFieldWidth()} having to
    // render out the data set offscreen and measure the rendered content - it does not apply
    // for cases where this method can return a simple fixed values (as with icon fields).
    // <P>
    // Which fields are currently autofitting is saved as part of the
    // +link{getViewState,view state} of the ListGrid.
    // <P>
    // Interaction with wrapping: If +link{listGrid.wrapCells,wrapping of cell values} is 
    // enabled, autoFit behavior based on +link{listGrid.autoFitWidthApproach,cell content}
    // will render fields wide enough to contain the <i>unwrapped</i> cell values.
    // If +link{listGridField.wrap,wrapping of field titles} is enabled, when fitting to 
    // a title, a field will render wide enough to accommodate the <i>wrapped</i> title without
    // clipping (so wide enough for the natural wrap-point / longest word or unwrappable string).
    // <p>
    // Note that, if you just want to autofit specific fields, rather than trying to achieve 
    // cascading from grid-level settings with specific field overrides, the quick, single 
    // setting to use is +link{listGridField.autoFit}.
    // @visibility external
    // @group autoFitFields
    //<
    

    //> @attr listGrid.autoSizeHeaderSpans (Boolean : false : IR)
    // If this listGrid has specified +link{listGrid.headerSpans}, setting this
    // attribute to true will cause spans to expand to accommodate long titles if necessary.
    // @visibility external
    // @group headerSpan
    // @group autoFitFields
    //<
    autoSizeHeaderSpans:false,


    //> @attr listGrid.autoFitClipFields (Array of String : null : IR)
    // If +link{listGrid.autoFitFieldWidths} is enabled and the calculated field sizes
    // are wide enough that horizontal scrolling would be introduced, this attribute may be
    // set to an array of fieldNames, causing those fields to be clipped rather than
    // forcing horizontal scrollbars to appear.
    // <P>
    // Note: If any +link{ListGridField.frozen,frozen columns} are included in this list they
    // will not be clipped.
    // @group autoFitFields
    // @visibility external
    //<

    //> @attr listGrid.autoFitFieldsFillViewport (Boolean : true : IR)
    // If +link{listGrid.autoFitFieldWidths} is enabled, and extra space is available after
    // autofitting all fields, should the grid automatically expand one field to fill the extra
    // space.
    // <P>
    // When enabled, the field to expand may be specified via +link{autoFitExpandField}.
    // <P>
    // Note this logic will not expand a +link{ListGridField.frozen,frozen column}.
    //
    // @group autoFitFields
    // @visibility external
    //<
    autoFitFieldsFillViewport:true,

    //> @attr listGrid.autoFitExpandField (String : null : IR)
    // The field to expand if +link{listGrid.autoFitFieldWidths} and
    // +link{autoFitFieldsFillViewport} are enabled and
    // auto-fitting will not fill all available horizontal space.
    // <P>
    // If unset, will default to the text field with the longest
    // +link{dataSourceField.length} if length is set, otherwise, the first text
    // field with no width specified.
    // <P>
    // Note that expanding +link{ListGridField.frozen,frozen columns} is not supported.
    // @group autoFitFields
    // @visibility external
    //<

    //> @type AutoFitWidthApproach
    // How should field width be determined when +link{listGridField.autoFitWidth} is true?
    // @value "value" Size field to fit to the data value(s) contained in the field.
    // @value "title" Size field to fit the field title
    // @value "both" Size field to fit either the field title or the data values in the field
    //  (whichever requires more space).
    //
    // @group autoFitFields
    // @visibility external
    //<

    //> @attr listGrid.autoFitWidthApproach (AutoFitWidthApproach : "value" : [IRW])
    // When a user requests column autofitting via the
    // +link{getHeaderContextMenuItems,header context menu} or via a
    // +link{headerAutoFitEvent,mouse gesture}, what autofit approach is used.
    // <p>
    // For information about auto-fitting specific fields, see +link{listGridField.autoFit}.
    // @group autoFitFields
    // @visibility external
    //<
    autoFitWidthApproach:"value",

    // If we're autoFitting to values, and we're showing a grid summary, should the
    // grid summary values be taken into account when sizing columns?
    // By default they are - set this flag to false to disable this behavior.
    includeGridSummaryInAutoFitWidth:true,

    //> @attr listGridField.autoFitWidthApproach (AutoFitWidthApproach : null : [IRW])
    // When a user requests column autofitting via the
    // +link{listGrid.getHeaderContextMenuItems,header contextMenu} or via a
    // +link{listGrid.headerAutoFitEvent,mouse gesture}, what autofit approach is used. If set, this
    // setting overrides the autoFitWidthApproach specified at the ListGrid level.
    // <p>
    // For a more direct alternative, see +link{listGridField.autoFit}, which effectively sets
    // this attribute and turns on +link{listGridField.autoFitWidth}.
    // @group autoFitFields
    // @visibility external
    //<

    //> @type AutoFitIconFieldType
    // How should fields of +link{listGridFieldType,type:"icon"} be sized by default?
    // @value "none" Apply no special sizing to icon fields - treat them like any other
    //   field in the grid
    // @value "iconWidth" size the field to accommodate the width of the icon
    // @value "title" size the field to accommodate the title (or the width of the icon if
    //   it exceeds the width of the title.
    //
    // @group autoFitFields
    // @visibility external
    //<

    //> @attr listGrid.autoFitIconFields (AutoFitIconFieldType : "title" : [IRW])
    // SmartClient listGrids have special logic to automatically size fields that
    // are displayed as an icon - that is fields with
    // +link{listGridFieldType,type:"icon"}, fields displaying only
    // +link{listGridField.showValueIconOnly,value icons}, and boolean fields (which
    // are rendered as a checkmark type icon by default.
    // <P>
    // This attribute controls this behavior - governing whether icon fields should
    // be sized to fit their content (icon), title, or whether to disable this
    // behavior. Setting this value to <code>"title"</code> or <code>"iconWidth"</code>
    // will cause +link{listGridField.autoFitWidth} to be enabled by default for all
    // icon fields with the +link{listGridField.autoFitWidthApproach} set to
    // <code>"value"</code> or <code>"both"</code> as appropriate. Note that the
    // width required for the icons is calculated by +link{listGrid.getDefaultFieldWidth()}
    // which performs a simple calculation based on the specified icon width for these
    // types of fields.
    // <P>
    // This setting governs default behavior for icon fields - for specific fields within
    // a grid, this default behavior can be overridden by setting an explicit
    // +link{listGridField.width} or
    // explicitly enabling +link{listGridField.autoFitWidth} and setting
    // +link{listGridField.autoFitWidthApproach} on the field in question.
    // @see listGrid.autoFitFieldWidths
    // @group autoFitFields
    // @visibility external
    //<
    autoFitIconFields:"title",
    
    //> @attr listGrid.autoFitDateFields (AutoFitWidthApproach : "value" : IRW)
    // Should listGrids automatically size date fields to fit their values or titles?
    // If set to <code>"value"</code>, fields of type date will be rendered at the
    // size specified by +link{listGrid.defaultDateFieldWidth}, 
    // (or +link{listGrid.defaultEditableDateFieldWidth} for editable fields). This static
    // value is appropriate for dates rendered with the standard short-date formatter.
    // If set to <code>"title"</code> or <code>"both"</code>, the drawn width of the title
    // will be taken into account when sizing the column.
    // <P>
    // This is achieved by enabling +link{listGridField.autoFitWidth,autoFitWidth:true}
    // on date fields when this property is set to anything other than <code>"none"</code>,
    // setting the +link{listGridField.autoFitWidthApproach} to the value specified here
    // and having logic in +link{listGrid.getDefaultFieldWidth()} pick up the
    // +link{listGrid.defaultDateFieldWidth} or +link{listGrid.defaultEditableDateFieldWidth}
    // if appropriate.
    // @group autoFitFields
    // @visibility external
    //<
    autoFitDateFields:"value",

    
    defaultFieldWidthScaleFactors: {
        Date: 6, EditableDate: 4, DateTime: 9, EditableDateTime: 6, Time: 6
    },
    
    //> @attr listGrid.defaultDateFieldWidth (Integer : varies : IRW)
    // Default width for date type fields. See +link{listGrid.autoFitDateFields} for
    // details on how this property is used.
    // @group autoFitFields
    // @visibility external
    //<
    defaultDateFieldWidth: 60,
    
    //> @attr listGrid.defaultEditableDateFieldWidth (Integer : varies : IRW)
    // Default width for editable date type fields. See +link{listGrid.autoFitDateFields} for
    // details on how this property is used.
    // @group autoFitFields
    // @visibility external
    //<
    defaultEditableDateFieldWidth: 94,

    //> @attr listGrid.defaultDateTimeFieldWidth (Integer : varies : IRW)
    // Default width for datetime type fields. See +link{listGrid.autoFitDateFields} for
    // details on how this property is used.
    // @group autoFitFields
    // @visibility external
    //<
    defaultDateTimeFieldWidth: 92,
    
    //> @attr listGrid.defaultEditableDateTimeFieldWidth (Integer : varies : IRW)
    // Default width for editable datetime type fields. See +link{listGrid.autoFitDateFields}
    // for details on how this property is used.
    // @group autoFitFields
    // @visibility external
    //<
    defaultEditableDateTimeFieldWidth: 130,
    
    //> @attr listGrid.autoFitTimeFields (AutoFitWidthApproach : "value" : IRW)
    // Should listGrids automatically size time fields to fit their values or titles?
    // If set to <code>"value"</code>, fields of type time will be rendered at the
    // size specified by +link{listGrid.defaultTimeFieldWidth}. This static
    // value is appropriate for dates rendered with the standard time formatter.
    // If set to <code>"title"</code> or <code>"both"</code>, the drawn width of the title
    // will be taken into account when sizing the column.
    // <P>
    // This is achieved by enabling +link{listGridField.autoFitWidth,autoFitWidth:true}
    // on date fields when this property is set to anything other than <code>"none"</code>,
    // setting the +link{listGridField.autoFitWidthApproach} to the value specified here
    // and having logic in +link{listGrid.getDefaultFieldWidth()} pick up the
    // +link{listGrid.defaultTimeFieldWidth} if appropriate.
    // @group autoFitFields
    // @visibility external
    //<
    autoFitTimeFields:"value",
    
    //> @attr listGrid.defaultTimeFieldWidth (Integer : varies : IRW)
    // Default width for time type fields. See +link{listGrid.autoFitDateFields} for
    // details on how this property is used.
    // @group autoFitFields
    // @visibility external
    //<
    defaultTimeFieldWidth: 65,

    //> @attr listGrid.skipLineBreaks (boolean : null : IRW)
    // Whether to skip line breaks for all fields by default when
    // +link{listGridField.escapeHTML,escaping HTML}.  This property can be overridden at the
    // field level by +link{listGridField.skipLineBreaks}.
    // @see listGridField.escapeHTML
    // @visibility external
    //<
    shouldSkipLineBreaks : function (field) {
        var skipLineBreaks = field.skipLineBreaks;
        return skipLineBreaks || skipLineBreaks != false && this.skipLineBreaks;
    },

    //> @attr listGrid.leaveScrollbarGap (Boolean : true : IRW)
    // Whether to leave a gap for the vertical scrollbar, even when it's not present.
    // <P>
    // Note that if leaveScrollbarGap is false and vertical scrolling is introduced, fields
    // will be resized to fit the smaller body area if possible, in order to avoid horizontal
    // scrolling also being required.
    //
    // @group appearance
    // @visibility external
    // @example autofitRows
    //<
    
    leaveScrollbarGap:true,

    // leaveScrollbarGap has meaning at the Layout level. We don't expect to ever show a vscrollbar
    // at the actual ListGrid level so override 'getBreadth' to avoid leaving a gap outside the
    // actual component members (header, body etc).
    getBreadth : function () {
        return this.getInnerWidth();
    },

    // if leaveScrollbarGap is false, whether to resize fields when vscrolling is introduced
    resizeFieldsForScrollbar:true,

    //> @attr listGrid.autoFit (boolean : false : IRWA)
    // If true, make columns only wide enough to fit content, ignoring any widths specified.
    // Overrides fixedFieldWidths.
    // <P>
    // NOTE: the header does not automatically respond to expanded field widths
    //  @group  sizing
    //<
    
    //autoFit:false,

    //> @attr listGrid.wrapCells (Boolean : false : IRWA)
    // Should content within cells be allowed to wrap?
    // <P>
    // Even if content is allowed to wrap, if +link{fixedRecordHeights} is set, the content
    // will be clipped off at the cell boundary.  Either set a larger, fixed +link{cellHeight}
    // to reveal more content, or set +link{fixedRecordHeights} to false to allow auto-sizing.
    //
    // @example autofitValues
    // @visibility external
    //<
    //wrapCells:false,

    //> @attr listGrid.preserveWhitespace (Boolean : false : IRWA)
    // Should cells be written out with css that will preserve whitespace?
    // <P>
    // If true, depending on the value of +link{listGrid.wrapCells}, the css generated
    // for cells will use the
    // +externalLink{https://www.w3.org/wiki/CSS/Properties/white-space#Values,white-space}
    // property values of <code>pre</code> or <code>pre-wrap</code>.
    // This avoids collapsing sequences of whitespace without requiring
    // special <i>&amp;nbsp;</i> characters.
    //
    // @visibility external
    //<
    
    
    //> @attr listGrid.showClippedValuesOnHover (Boolean : null : IRA)
    // @include gridRenderer.showClippedValuesOnHover
    //<
    showClippedValuesOnHover:null,

    //> @attr listGrid.cellSpacing (number : 0 : [IRW])
    // @include gridRenderer.cellSpacing
    // @visibility internal
    //<
    
    cellSpacing:0,

    //> @attr listGrid.cellPadding (number : 2 : [IRW])
    // @include gridRenderer.cellPadding
    //<
    cellPadding:2,

    //> @attr listGrid.dateFormatter (DateDisplayFormat : null : [IRW])
    // How should Date type values be displayed in this ListGrid by default?
    // <P>
    // This property specifies the default DateDisplayFormat to apply to Date values
    // displayed in this grid for all fields except those of +link{listGridField.type,type "time"}
    // (See also +link{listGrid.timeFormatter}).<br>
    // If +link{listGrid.datetimeFormatter} is specified, that will be applied by default
    // to fields of type <code>"datetime"</code>.
    // <P>
    // Note that if +link{listGridField.dateFormatter} or +link{listGridField.timeFormatter} are
    // specified those properties will take precedence over the component level settings.
    // <P>
    // If unset, date values will be formatted according to the system wide
    // +link{DateUtil.setShortDisplayFormat(),short display format} or
    // +link{DateUtil.setShortDatetimeDisplayFormat(),short datetime display format} for
    // datetime type fields.
    // <P>
    // If this field is editable the dateFormatter will also be passed to the editor created
    // to edit this field as +link{DateItem.dateFormatter, dateFormatter}.
    // In this case you may also need to set +link{listGrid.dateInputFormat}.
    //
    // @visibility external
    //<
    //dateFormatter:null,

    //> @attr listGrid.datetimeFormatter (DateDisplayFormat : null : [IRW])
    // Display format to use for fields specified as type 'datetime'.  Default is to use the
    // system-wide default date time format, configured via
    // +link{DateUtil.setShortDatetimeDisplayFormat()}.  Specify any
    // valid +link{type:DateDisplayFormat} to change the display format for datetimes used by this grid.
    // <smartclient>
    // May be specified as a function. If specified as  a function, this function will be executed in the scope of the Date
    // and should return the formatted string.
    // </smartclient>
    // <P>
    // May also be specified at the field level via
    // +link{listGridField.dateFormatter}
    // <P>
    // If this field is editable the dateFormatter will also be passed to the editor created
    // to edit this field as +link{DateItem.dateFormatter, dateFormatter}.
    // In this case you may also need to set +link{listGrid.dateInputFormat}.
    //
    // @see listGridField.dateFormatter
    // @group appearance
    // @visibility external
    //<

    //> @attr listGrid.dateInputFormat (DateInputFormat : null : [IRWA])
    // If this is an editable listGrid, this property will specify the
    // +link{DateItem.inputFormat, inputFormat} applied to editors for fields of type
    // <code>"date"</code>. May be overridden per field via +link{listGridField.inputFormat}.
    // @see listGrid.dateFormatter
    // @visibility external
    //<

    // function to call appropriate date formatter
    // Note: this is executed in the scope of a field object - see 'applyFieldDefaults'
    _formatDateCellValue : function (value, field, grid, record, rowNum, colNum) {

        if (isc.isA.Date(value)) {
            // A developer may force a "date" or "datetime" type field value to be displayed as time
            // by specifying a timeFormatter and no dateFormatter on the field.
            if (grid._formatAsTime(field)) {
                var formatter = grid._getTimeFormatter(field);
                var isLogicalTime = isc.SimpleType.inheritsFrom(field.type, "time");
                return isc.Time.toTime(value, formatter, isLogicalTime);
            }

            var isDatetime = field && isc.SimpleType.inheritsFrom(field.type, "datetime"),
                isLogicalDate = !isDatetime && isc.SimpleType.inheritsFrom(field.type, "date"),
                formatter = grid._getDateFormatter(field);

            // rely on date.toShortDateTime() / toShortDate() to handle applying the
            // custom formatter if specified, otherwise picking up the appropriate system-wide
            // default for the data type.
            // The second parameter to toShortDateTime() explicitly causes the date to be displayed
            // in the custom timezone set up in Time.setDefaultDisplayTimezone
            if (isDatetime) return value.toShortDateTime(formatter, true);
            return value.toShortDate(formatter, !isLogicalDate);
        }
        return value;
    },

    // Date formatting helpers:
    // Called from formatDateCellValue() / formatTimeCellValue() [which are type-specific formatters
    // applied to fields as part of field init], and also as a catch-all for
    // Date type values in fields of some other specified data-type.
    // We use a consistent pattern across DataBoundComponents:
    // - developer can specify explicit dateFormatter / timeFormatter per field and they'll be used.
    //   if both are specified dateFormatter takes precedence except in "time" type fields.
    // - developer can specify dateFormatter, datetimeFormatter and timeFormatter per component and
    //   they'll be used if no per-field settings are found.

    // If a field has a JS Date value, should we format it as a time? True for "time" type fields
    // or fields with an explicit time formatter only.
    _formatAsTime : function (field) {
        if (field == null) return false;

        // If at the field level the timeFormatter is defined *(and there's no date formatter)
        // respect it.
        if (field.timeFormatter != null && field.dateFormatter == null) return true;
        // timeFormatter null and dateFormatter non-null --> format as date
        
        if (field.dateFormatter != null && field.timeFormatter == null) return false;
        return isc.SimpleType.inheritsFrom(field.type, "time");
    },

    _getDateFormatter : function (field) {
        
        if (field == null) return this.dateFormatter;
        
        if (field.dateFormatter != null) return field.dateFormatter;
        // displayFormat is back-compat at this point - only applies to fields of type
        // date or datetime (or subtypes thereof)
        if (field.displayFormat != null && 
            (isc.SimpleType.inheritsFrom(field.type, "date") || isc.SimpleType.inheritsFrom(field.type, "datetime"))) 
        {
            return field.displayFormat;
        }
        
        if (this.datetimeFormatter != null && isc.SimpleType.inheritsFrom(field.type, "datetime")) {
            return this.datetimeFormatter;
        }

        return this.dateFormatter;
    },

    // This picks up *explicit* dateInputFormat to pass through to the edit-item. No need to
    // include logic to derive from the display format if no explicit input format was specified,
    // that'll be handled by the FormItem code.
    _getDateInputFormat : function (field) {
        var inputFormat;
        if (field) inputFormat = field.inputFormat
        if (!inputFormat) inputFormat = this.dateInputFormat;
        return inputFormat;
    },

    // function to call appropriate number formatter
    // If no number formatter is defined, the default formatter will be used [standard 'toString']
    // is the default
    _formatNumberCellValue : function (value, field, grid, record, rowNum, colNum) {
        if (isc.isA.Number(value)) {
            if (isc.SimpleType.inheritsFrom(field.type, "float") &&
                (field.decimalPrecision != null || field.decimalPad != null))
            {
                return isc.Canvas.getFloatValueAsString(
                        value, field.decimalPrecision, field.decimalPad);
            } else if (field.precision != null) {
                return isc.Canvas.getNumberValueAsString(value, field.precision, field.type);
            } else {
                var formatter = (field.numberFormatter || field.formatter || grid.numberFormatter);
                return value.toFormattedString(formatter);
            }
        }

        // If passed a non-number just return it
        return value;
    },

    //> @attr listGrid.timeFormatter (TimeDisplayFormat : "toShortPaddedTime" : [IRW])
    // Display format to use for fields specified as type 'time'.  May also be specified at
    // the field level via +link{listGridField.timeFormatter}.<br>
    // If unset, time fields will be formatted based on the system wide
    // +link{Time.shortDisplayFormat}.<br>
    // If this field is editable, the timeFormatter will also be passed to the editor
    // created to edit any time type fields as +link{TimeItem.timeFormatter}
    // @group appearance
    // @visibility external
    //<
    timeFormatter:"toShortPaddedTime",

    _getTimeFormatter : function (field) {
        if (field != null) {
            if (field.timeFormatter != null) return field.timeFormatter;
            if (field.displayFormat != null && isc.SimpleType.inheritsFrom(field.type, "time")) {
                return field.displayFormat;
            }
        }
        return this.timeFormatter;
    },

    // function to call appropriate time formatter
    // Note: this is executed in the scope of a field object - see 'applyFieldDefaults'
    _formatTimeCellValue : function (value, field, grid, record, rowNum, colNum) {
        var time = value;
        if (isc.isA.String(time)) {
            // Pass in the 'validTime' param - If we're given a string which doesn't
            // parse to a time we don't want to display "12:00 am"
            time = isc.Time.parseInput(time, true);
        }
        if (isc.isA.Date(time)) {
            // If dateFormatter is set on the field, and timeFormatter is not, we respect it
            // even for fields of explicit type "time"
            if (!grid._formatAsTime(field)) {
                
                return time.toShortDate(grid._getDateFormatter(field), true);
            }
            var formatter = grid._getTimeFormatter(field);

            // If we're passed an invalid formatter
            return isc.Time.toTime(time, formatter, true);
        }
        return value;
    },

    _formatBinaryCellValue : function (value, field, grid, record, rowNum, colNum) {
        
        if (isc.isA.String(value)) return value;
        if (record == null) return null;

        var fieldName = field.name,
            ds = grid.getDataSource(),
            filenameField = (ds ? ds.getFilenameField(fieldName) : null) || fieldName + "_filename",
            fileName = record[filenameField],
            value
        ;

        if (field.type=="imageFile" && field.showFileInline == true) {
            var urlProperty = fieldName + "_imgURL";

            if (!record[urlProperty]) {
                var dimensions = isc.Canvas.getFieldImageDimensions(field, record),
                    image = grid.getDataSource().getFileURL(record, field.name);

                dimensions.width = dimensions.width || grid.imageSize;
                dimensions.height = dimensions.height || grid.imageSize;
                value = record[urlProperty] =
                    isc.Canvas.imgHTML(image, dimensions.width, dimensions.height,
                                       null, null, isc.Canvas._$allowRelativeSrc);
            } else
                value = record[urlProperty];
        } else {
            if (field.showFileInline == true) { // non-imageFile field
                this.logWarn("_formatBinaryCellValue(): Unsupported field-type for showFileInline: "+field.type);
            }

            
            if (!field.filenameSuppressed && (fileName == null || isc.isAn.emptyString(fileName))) {
                return this.emptyCellValue;
            }

            var viewAction = "'" + grid.getID() +".view",
                dlAction = "'" + grid.getID() +".download",
                completion = "";
            if (field && field.name) {
                completion = "Cell(" + rowNum + ", \"" + field.name + "\")'";
            } else {
                completion = "Row(" + rowNum + ")'";
            }
            var viewIconHTML = isc.Canvas.imgHTML({
                src: "[SKIN]actions/view.png",
                width: 16,
                height: 16,
                extraCSSText: "cursor:" + isc.Canvas.POINTER_OR_HAND,
                eventStuff: " onclick=" + viewAction + completion
            });
            var downloadIconHTML = isc.Canvas.imgHTML({
                src: "[SKIN]actions/download.png",
                width: 16,
                height: 16,
                extraCSSText: "cursor:" + isc.Canvas.POINTER_OR_HAND,
                eventStuff: " onclick=" + dlAction + completion
            });

            value = viewIconHTML + "&nbsp;" + downloadIconHTML +
                (fileName ? "&nbsp;" + fileName : "");
        }

        return value;
    },

    // value is rendered as an anchor - the href and name of the anchor is the value.  By default
    // opens in a new browser window - this can be overridden by setting the 'target' property on
    // the record.
    //
    // The name of the link can be overridden by setting the 'linkName' property on the record.  By
    // default we use the value.
    _$linkTemplate:[
        "<a href='",
        ,   // 1: HREF
        // give links in LG-fields the same colors as LinkItems in the framework
        "' class='linkText' target='",
        ,   // 3: name of target window
        // onclick handler enables us to prevent popping a window if (EG) we're masked.
        //                      5: ID
        "' onclick='if(window.",     ,") return ",
                //  7:ID                         9:rowNum,     11:colNum
                         ,"._linkClicked(event,",        ,",",          ,");'>",
        ,   // 13: link text
        "</a>"
    ],
    _$doubleEscapedQuote:"\\'",
    _$_blank:"_blank",

    _formatLinkCellValue : function (value, field, grid, record, rowNum, colNum) {
        if (value == null || isc.is.emptyString(value)) return value;

        // target window
        var target = field.target ?
                        field.target.replaceAll(grid._$singleQuote, grid._$doubleEscapedQuote) :
                        grid._$_blank;
        // get the linkText property. If defined on the field, use that, otherwise
        // use the linkTextProperty from the grid.
        var linkTextProp = field.linkTextProperty ? field.linkTextProperty : grid.linkTextProperty;
        var linkText = (record && record[linkTextProp]) ? record[linkTextProp]
                                                            : field.linkText || value;

        // link URL
        var href = "" + value;

        if (target == "javascript") {
            // target is "javascript" - make the link inert and have the cellClick event fired
            // instead
            href = "javascript:void";
        } else {
            if (field.linkURLPrefix) href = field.linkURLPrefix + href;
            if (field.linkURLSuffix) href = href + field.linkURLSuffix;
            href = href.replaceAll(grid._$singleQuote, grid._$doubleEscapedQuote);
        }

        // combine
        var template = grid._$linkTemplate;
        template[1] = href;
        template[3] = target;
        var ID = grid.getID();
        template[5] = ID;
        template[7] = ID;
        template[9] = rowNum;
        template[11] = colNum;
        template[13] = linkText;

        return template.join(isc.emptyString);
    },

    _linkClicked : function (event, rowNum, colNum) {
        // don't allow the click if the cell should not be interactive.
        var record = this.getRecord(rowNum),
            mustCancel = (
                this.destroyed || !this.isDrawn() || !this.isVisible() ||
                isc.EH.targetIsMasked(this.body) ||
                !this.recordIsEnabled(record, rowNum, colNum)),
            field = this.getField(colNum);

        if (event.target == "javascript" || field.target == "javascript") {
            mustCancel=true;
            this.cellClick(record, rowNum, colNum);
        }

        if (mustCancel) {
            
            if (!isc.Browser.isIE) {
                event.preventDefault();
            }

            return false;
        }
        return true;
    },

    //> @attr listGrid.linkTextProperty (String : "linkText" : [IRW])
    // Property name on a record that will hold the link text for that record.
    // <P>
    // This property is configurable to avoid possible collision with data values in the
    // record.
    // <P>
    // Use +link{listGridField.linkTextProperty} if you have more than one link field and
    //
    // @see type:ListGridFieldType
    // @see type:FieldType
    // @see attr:listGridField.linkText
    // @see attr:listGridField.linkTextProperty
    // @group  display_values
    // @visibility external
    //<
    linkTextProperty : "linkText",

    // value is a URL to an image
    _formatImageCellValue : function (value, field, grid, record, rowNum, colNum) {
        // if no value is stored, just return an empty string so we don't render a broken image
        if (value == null || isc.isAn.emptyString(value)) return isc.emptyString;

        // if any of field.imageWidth/Height/Size are set as strings, assume they are property
        // names on the record
        
        var dimensions = isc.Canvas.getFieldImageDimensions(field, record);

        dimensions.width = dimensions.width || grid.imageSize;
        dimensions.height = dimensions.height || grid.imageSize;

        
        var src = value,
            prefix = field.imageURLPrefix || field.baseURL || field.imgDir;

        // If imageURLSuffix is specified, apply it to the value
        if (field.imageURLSuffix != null) src += field.imageURLSuffix;

        

        return isc.Canvas.imgHTML(src, dimensions.width, dimensions.height, null,
                                  field.extraStuff, prefix, field.activeAreaHTML, null, null,
                                  null, null, field.eventStuff);
    },

    // show field.icon in the cell
    _formatIconCellValue : function (value, field, grid, record, rowNum, colNum) {
        // prevent an icon from being shown in the filter editor if the field has canFilter
        if (isc.isA.RecordEditor(grid) && grid.isAFilterEditor() && field.canFilter == false) return null;

        if (field._iconHTML) return field._iconHTML;
        var cursor = grid.getIconCursor(field),
            extraCSSText;
        if (cursor != null) {
            if (cursor == isc.Canvas.HAND && isc.Browser._usePointerCursorForHand) {
                cursor = isc.Canvas.POINTER;
            }
            extraCSSText = "cursor:" + cursor;
        }

        var imgConfig = {
            src:field.cellIcon || field.icon,
            width:field.iconWidth || field.iconSize || grid.imageSize,
            height:field.iconHeight || field.iconSize || grid.imageSize
        };
        if (extraCSSText) imgConfig.extraCSSText = extraCSSText;
        field._iconHTML = isc.Canvas.imgHTML(imgConfig);
        return field._iconHTML;
    },

    // CSS styles
    // --------------------------------------------------------------------------------------------

    //> @attr listGrid.fastCellUpdates (Boolean: true : I)
    // @include gridRenderer.fastCellUpdates
    // @group performance
    //<
    // explicitly set fastCellUpdates at the LG level
    // this will be passed through to our body and allows us to check
    // this.fastCellUpdates directly rather than looking at the attribute on the body
    
    fastCellUpdates:isc.Browser.isIE && !isc.Browser.isIE9,

    //> @method listGrid.setFastCellUpdates()
    // @include gridRenderer.setFastCellUpdates()
    // @visibility external
    //<
    // explicit implementation keeps this.fastCellUpdates in sync with the version in the
    // body so we can check it directly in this.getBaseStyle
    setFastCellUpdates : function (fcu) {
        if (this.body != null) {
            this.body.setFastCellUpdates(fcu);
            // if the body refused to set to the specified
            // value, respect that.
            fcu = this.body.fastCellUpdates;
        }
        if (this.frozenBody != null) {
            this.frozenBody.setFastCellUpdates(fcu);
        }
        this.fastCellUpdates = fcu;
    },

    //> @attr listGrid.baseStyle (CSSStyleName : null : [IR])
    // +link{gridRenderer.baseStyle,base cell style} for this listGrid.
    // If this property is unset, base style may be derived from +link{listGrid.normalBaseStyle}
    // or +link{listGrid.tallBaseStyle} as described in
    // +link{listGrid.getBaseStyle()}.
    // <P>
    // See +link{group:cellStyleSuffixes} for details on how stateful suffixes are combined
    // with the base style to generate stateful cell styles.
    //
    // @visibility external
    // @group appearance
    //<

    //> @attr listGrid.normalBaseStyle (CSSStyleName : "cell" : [IR])
    // "Normal" baseStyle for this listGrid. Only applies if +link{listGrid.baseStyle} is
    // set to null.
    // <P>
    // If <code>baseStyle</code> is unset, this
    // property will be used as a base cell style if the grid is showing fixed height rows, and
    // the specified cellHeight matches +link{listGrid.normalCellHeight} (and in Internet Explorer,
    // +link{listGrid.fastCellUpdates} is false). Otherwise +link{listGrid.tallBaseStyle} will
    // be used.
    // <P>
    // Having separate styles defined for fixed vs. variable height rows allows the developer
    // to specify css which is designed to render at a specific height (typically using
    // background images, which won't scale), without breaking support for styling rows
    // of variable height.
    // <P>
    // See +link{group:cellStyleSuffixes} for details on how stateful suffixes are combined
    // with the base style to generate stateful cell styles.
    //
    // @see listGrid.getBaseStyle()
    // @visibility external
    //<
    normalBaseStyle:"cell",

    //> @attr listGrid.tallBaseStyle (CSSStyleName : "cell" : [IR])
    // "Tall" baseStyle for this listGrid. Only applies if +link{listGrid.baseStyle} is
    // set to null.
    // <P>
    // If <code>baseStyle</code> is unset, this
    // property will be used as a base cell style unless the grid is showing fixed height
    // rows with a specified cellHeight that matches +link{listGrid.normalCellHeight}, in
    // which case +link{listGrid.normalBaseStyle} will be used. Note that in Internet Explorer
    // if +link{listGrid.fastCellUpdates} is true, <code>tallBaseStyle</code> will also be
    // used even if the cellHeight matches the specified <code>normalCellHeight</code> for the
    // grid.
    // <P>
    // See +link{group:cellStyleSuffixes} for details on how stateful suffixes are combined
    // with the base style to generate stateful cell styles.
    //
    // @see listGrid.getBaseStyle()
    // @visibility external
    //<
    tallBaseStyle:"cell",

    
    

    //> @attr listGrid.editFailedBaseStyle (CSSStyleName : null : [IRWA])
    //  A base name for the CSS class applied to cells when editing has failed.<br>
    //  If this listGrid is editable, this style will be applied to any edited cells for which
    //  validation failed.<br>
    //  As with the default 'baseStyle' property, this style will have "Dark", "Over", "Selected",
    //  or "Disabled" appended to it according to the state of the cell.<br>
    // If null, cells for which editing has failed will be rendered using the normal base style
    // classNames, but with custom CSSText applied as derived from <code>this.editFailedCSSText</code>
    // @visibility external
    // @group   appearance
    // @see baseStyle
    // @see editFailedCSSText
    //<
    editFailedBaseStyle:null,   //"cellEditFailed",

    //> @attr listGrid.editFailedCSSText (String : "color:red;border:1px solid red;" : [IRWA])
    //  Custom CSS text to be applied to cells when editing has failed.<br>
    //  If this listGrid is editable, this css text will be applied to any edited cells for which
    //  validation failed, on top of the base style for the cell.<br>
    // For further customization of styling for cells that failed editing validation, use
    // <code>this.editFailedBaseStyle</code> instead.
    // @visibility external
    // @group   appearance
    // @see editFailedBaseStyle
    //<
    editFailedCSSText:"color:red;border:1px solid red;",

    //> @attr listGrid.editPendingBaseStyle (CSSStyleName : null : [IRA])
    // A base name for the CSS class applied to cells containing pending (unsaved) edits<br>
    // As with the default 'baseStyle' property, this style will have "Dark", "Over", "Selected",
    // or "Disabled" appended to it according to the state of the cell.
    // <P>
    // If this property is null (the default setting), cells with pending edits will pick up
    // custom css text to be applied on top of the normal base style from
    // <code>this.editPendingCSSText</code>.
    //
    // @group appearance
    // @see baseStyle
    // @visibility external
    //<
    editPendingBaseStyle:null, //"cellEditPending",

    //> @attr listGrid.editPendingCSSText (String : "color:#0066CC;" : [IRWA])
    // Custom CSS text to be applied to cells with pending edits that have not yet been
    // submitted.<br>
    // For further customization of styling for cells with pending edits use
    // <code>this.editPendingBaseStyle</code> instead.
    // @group appearance
    // @see editFailedBaseStyle
    // @visibility external
    //<
    editPendingCSSText:"color:#0066CC;",

    //> @attr listGrid.editPendingMarkerStyle (CSSStyleName : null : [IRWA])
    // The name of a CSS class used to overlay regular cell styles with additional styling when
    // a cell has unsaved edits - these styles are in addition to the styling applied by 
    // +link{listGrid.editPendingCSSText} or +link{listGrid.editPendingBaseStyle}.
    // <p>
    // You can use a custom class that overlays styling of your choosing, or use the default 
    // <i>pendingMarker</i> class which is present in modern skins and provides a small 
    // corner-marker in the top-left of unsaved cells.
    // <p>
    // Once set, this styleName is automatically appended to the style-list for cells with 
    // unsaved edits.
    // @group appearance
    // @see baseStyle
    // @visibility external
    //<
    editPendingMarkerStyle:null, //"pendingMarker",

    //> @attr listGrid.recordCustomStyleProperty (String : "customStyle" : IRW)
    // @include GridRenderer.recordCustomStyleProperty
    // @visibility external
    // @see listGrid.getCellStyle()
    // @see listGrid.recordBaseStyleProperty
    //<
    recordCustomStyleProperty:"customStyle",

    //> @attr listGrid.recordBaseStyleProperty (String : "_baseStyle" : [IRWA])
    // This attribute allows custom base styles to be displayed on a per-record basis.
    // To specify a custom base-style for some record set
    // <code>record[listGrid.recordBaseStyleProperty]</code> to the desired base style name -
    // for example if <code>recordBaseStyleProperty</code> is <code>"_baseStyle"</code>, set
    // <code>record._baseStyle</code> to the custom base style name.
    //
    // @visibility external
    // @group appearance
    // @see listGrid.baseStyle
    //<
    recordBaseStyleProperty:"_baseStyle",

    //> @attr listGrid.frozenBaseStyle (String : null : [IRW])
    // If this listGrid contains any frozen fields, this property can be used to apply a custom
    // baseStyle to all cells in those frozen fields. If unset, the standard base style will be
    // used for both frozen and unfrozen cells.
    // @visibility external
    // @group appearance, frozenFields
    // @see listGrid.baseStyle
    // @see listGridField.frozen
    //<

    //> @attr listGrid.shrinkForFreeze (Boolean : false : IRWA)
    // If this list grid is showing any +link{listGridField.frozen,frozen} fields, and a horizontal
    // scrollbar is visible at the bottom of the liquid columns, should an equivalent scrollbar gap
    // be left visible below the frozen columns?<br>
    // Note that if set to <code>true</code> any backgroundColor or border applied to the ListGrid
    // will show up below the bottom row of the frozen column(s).
    // @group frozenFields
    // @visibility external
    //<
    shrinkForFreeze:false,

    //> @attr listGrid.alternateRecordStyles (Boolean : false : [IRW])
    // @include gridRenderer.alternateRowStyles
    // @group cellStyling
    // @example gridCells
    //<
    //alternateRecordStyles:false,
   
    //> @attr listGrid.alternateRecordSuffix (String : "Dark" : [IRW])
    // @include gridRenderer.alternateRowSuffix
    // @group cellStyling
    // @example gridCells
    //<
    alternateRecordSuffix:"Dark",
   
    //> @attr listGrid.alternateRecordFrequency (number : 1 : [IRW])
    // @include gridRenderer.alternateRowFrequency
    // @group cellStyling
    //<
    alternateRecordFrequency:1,   

    //> @attr listGrid.alternateFieldStyles (boolean : false : [IRW])
    // @include gridRenderer.alternateColumnStyles
    // @visibility external
    // @group cellStyling
    //<
    //alternateFieldStyles:false,

    //> @attr listGrid.alternateFieldSuffix (String : "AltCol" : [IRW])
    // @include gridRenderer.alternateColumnSuffix
    // @group cellStyling
    //<
    alternateFieldSuffix:"AltCol",

    //> @attr listGrid.alternateFieldFrequency (number : 1 : [IRW])
    // @include gridRenderer.alternateColumnFrequency
    // @visibility external
    // @group cellStyling
    //<
    alternateFieldFrequency:1,

    //> @attr listGrid.alternateBodyStyleName (CSSStyleName : null : [IRWA])
    // Optional css style to apply to the body if +link{listGrid.alternateRecordStyles} is true
    // for this grid. If unset +link{listGrid.bodyStyleName} will be used to style the body
    // regardless of the +link{listGrid.alternateRecordStyles,alternateRecordStyles} setting.
    // @visibility external
    //<

    // property you can set per-record to add custom CSSText
    recordCSSTextProperty : "cssText",

    //> @attr listGrid.includeHilitesInSummaryFields
    // @include dataBoundComponent.includeHilitesInSummaryFields
    // @visibility external
    //<

    //> @method listGrid.shouldIncludeHiliteInSummaryField()
    // @include dataBoundComponent.shouldIncludeHiliteInSummaryField
    // @visibility external
    //<

    //> @attr listGrid.showHiliteInCells (boolean : false : IRWA)
    // When cell styling is being updated (updateCellStyle()), should the HTML content of the
    // cell also be updated?  If false, only the cell's CSS styling will be updated.
    //
    // You should turn this on if you've implemented 
    // +link{listGrid.formatCellValue(),formatting} that adds styling cues to a cell
    // (like an inline image), which need be updated as the cell switches states.
    // (eg, if you would use different HTML for a selected cell's contents).
    //      @group  hiliting, drawing
    //<
    //showHiliteInCells:false,

    //> @attr listGrid.showHilitesInGroupSummary (boolean : true : IRW)
    // Determines whether hiliting for any field in this grid is shown in a group summary.
    // This setting affects all fields of the grid.
    // <P>
    // To suppress hilites for a specific field see +link{listGridField.showHilitesInGroupSummary}.
    // <P>
    // Hiliting in summary fields (columns) can be enabled by setting
    // +link{listGrid.includeHilitesInSummaryFields,includeHiliteInSummaryField} to true.
    //
    // @visibility external
    //<
    showHilitesInGroupSummary:true,

    //> @attr listGrid.hiliteCanReplaceValue (boolean : null : IR)
    // If set, end users can create advanced hiliting rules that will use the
    // +link{hilite.replacementValue} feature to cause values in hilited cells
    // to be replaced with a user-entered value.  For example, a user could create a hilite rule
    // that replaces numeric values ranging from 0.5 to 1.0 with the text "LOW".
    // <p>
    // Specifically, when the "Add Advanced Rule" button is pressed and
    // <code>hiliteCanReplaceValue</code> is true, the user will see a text entry field titled
    // "Replace value with" (+link{hiliteReplaceValueFieldTitle}) and if they enter a value, that
    // value will appear in the grid cell in lieu of the cell's original value.
    //
    // @group hiliting
    // @visibility external
    //<

    //> @attr listGrid.hiliteReplaceValueFieldTitle (String : "Replace value with" : IR)
    // Title used for the text box shown when +link{listGrid.hiliteCanReplaceValue} is set.
    // @group i18nMessages
    // @visibility external
    //<
    hiliteReplaceValueFieldTitle : "Replace value with",
    
    //> @attr listGrid.hiliteHTMLAfterFormat (boolean : true : IR)
    // If set to true, custom HTML applied as part of hiliting will be applied after
    // +link{listGrid.formatCellValue(),formatting} for each cell. If false, hilite
    // HTML will be applied before formatting.
    // <P>
    // This applies to the following hilite properties:
    // <ul>
    // <li>+link{Hilite.replacementValue}</li>
    // <li>+link{Hilite.htmlBefore}</li>
    // <li>+link{Hilite.htmlAfter}</li>
    // <li>+link{Hilite.htmlValue}</li>
    // </ul>
    // <P>
    // May be overridden per field via +link{listGridField.hiliteHTMLAfterFormat}
    //
    // @visibility external
    //<
    // Also the undocumented
    // <li>+link{Hilite.htmlOpposite}</li>
    hiliteHTMLAfterFormat:true,

    //> @attr listGridField.hiliteHTMLAfterFormat (Boolean : null : IR)
    // If set to true, custom HTML applied as part of hiliting will be applied after
    // +link{listGrid.formatCellValue(),formatting} for each cell in this column. If false, hilite
    // HTML will be applied before formatting.
    // <P>
    // This attribute overrides +link{listGrid.hiliteHTMLAfterFormat} as defined at the
    // component level.
    //
    // @visibility external
    //<

    //> @attr listGrid.showSelectedStyle (Boolean : true : IRW )
    // @include gridRenderer.showSelectedStyle
    //<
    showSelectedStyle : true,

    // Keyboard handling
    // ---------------------------------------------------------------------------------------

    //> @attr listGrid.generateClickOnSpace (Boolean : true : IRWA)
    // If true, when the user navigates to a cell using arrow keys and hits space,
    // the cell will respond to a click event.
    // @visibility external
    //<
    generateClickOnSpace : true,

    //> @attr listGrid.generateClickOnEnter (Boolean : false : IRWA)
    // If true, when the user navigates to a cell using arrow keys and hits Enter,
    // the cell will respond to a click event.
    // @visibility external
    //<
    //generateClickOnEnter : false,

    //> @attr listGrid.generateDoubleClickOnSpace (Boolean : false : IRWA)
    // If true, when the user navigates to a cell using arrow keys and hits Space,
    // the cell will respond to a double click event.
    // @visibility external
    //<
    // generateDoubleClickOnSpace : false,

    //> @attr listGrid.generateDoubleClickOnEnter (Boolean : true : IRWA)
    // If true, when the user navigates to a cell using arrow keys and hits Enter,
    // the cell will respond to a double click event.
    // @visibility external
    //<
    generateDoubleClickOnEnter : true,

    //> @attr listGrid.arrowKeyAction (String : null : IRWA)
    // Action to perform when the listGrid has keyboard focus (but not editing focus) and a user
    // presses the arrow keys to navigate around the grid.
    // <P>
    // If +link{canSelectCells} is true, navigation occurs by cell - the user can move
    // to a new cell in any direction.<br>
    // If +link{canSelectCells} is false, navigation typically occurs by row - the user can
    // move up or down through the rows in the grid.
    // <P>
    // For actions that fire events (click or doubleClick), both cell and record level events are
    // fired (for example for arrowKeyAction <code>"activate"</code>, +link{cellDoubleClick()}
    // and +link{recordDoubleClick()} are fired for the new position.<br>
    // Note that if +link{canSelectCells} is false, the events will be fired as if a click or
    // double click had occurred on the first cell where
    // +link{listGridField.ignoreKeyboardClicks} is not true.
    // <P>
    // Possible actions are:
    // <ul>
    // <li><code>"select"</code> : select the next row or cell in the grid and call 
    //     click handlers.</li>
    // <li><code>"selectOnly"</code> : select the next row or cell in the grid without firing 
    //      click handlers.</li>
    // <li><code>"focus"</code> : move focus to the next row or cell in the grid without 
    //     changing the selection or calling click handlers.</li>
    // <li><code>"activate"</code> : select and activate the next row or cell in the list (calls
    //  <code>recordDoubleClick</code> handler)</li>
    // <li><code>"none"</code> : no action</li>
    // <li> <code>null</code> : if +link{listGrid.selectionAppearance} is "checkbox", behaves as if set
    //  to "focus"; otherwise, behaves as if set to "select"</li>
    // </ul>
    // <P>
    // Note: If this grid is editable, behavior while editing is governed by the result of 
    // +link{listGrid.getArrowKeyEditAction()}.
    // <P>
    // See also +link{listGrid.generateClickOnEnter}, +link{listGrid.generateClickOnSpace},
    // +link{listGrid.generateDoubleClickOnEnter} and +link{listGrid.generateDoubleClickOnSpace}
    //
    // @group events
    // @visibility external
    //<
    arrowKeyAction: null,

    //> @attr ListGrid.hiliteRowOnFocus (Boolean : null : IRW)
    // When the grid body gets keyboard focus, should we highlight the current focus row,
    // using the rollover cell style?
    // <P>
    // This property may be explicitly set to control this behavior independently of
    // +link{showRollOver}.
    // Otherwise (if this property is null), we will show the roll-over styling for the
    // keyboard focus row if +link{showRollOver} is true.
    // @visibility external
    //<
    
//    hiliteRowOnFocus:null,

    //> @attr listGrid.showRecordComponents (boolean : null : IRW)
    // When enabled, +link{createRecordComponent()} will be called when saved rows are being
    // rendered, and any returned component will be displayed embedded within the row or cell.
    // <P>
    // recordComponents are not created for newly added rows which have not yet been saved.  
    // See the +link{group:unsavedRecords, Handling Unsaved Records overview} for more
    // information.
    // <P>
    // Depending on the +link{showRecordComponentsByCell} setting,
    // <code>createRecordComponent()</code> will be called either once per row, or once for
    // every cell.
    // <P>
    // Depending on +link{recordComponentPosition}, components can either be placed underneath
    // normal record or cell content ("expand" setting) or placed so that they overlap normal
    // cell content ("within" setting).  For the "within" setting, the default is to fill the
    // row or cell, but the component can specify percent size or even use
    // +link{canvas.snapTo,snapTo-positioning} to place itself within the row or cell.
    // <p>
    // The "expand" setting is incompatible with +link{canFreezeFields,frozen columns}
    // <i>unless</i> all <code>recordComponents</code> are the same height and they are present
    // in every row, in which case the fixed height of all <code>recordComponents</code> can be
    // set via +link{recordComponentHeight} to re-enable frozen fields.
    // <p>
    // Using <code>recordComponents</code> potentially means creating one component for every
    // visible grid row or cell and so can impact performance.  Before using this subsystem:
    // <ul>
    // <li> consider using +link{listGridField.valueIcons} (possibly with a specified 
    //      +link{listGridField.valueIconClick()} handler) for icons based on field values
    //      which may be displayed alone in the cell or alongside standard content
    //      (see +link{listGridField.showValueIconOnly});
    // <li> for clickable icons representing actions that can be taken on a record, also 
    //      consider using +link{type:ListGridFieldType,a field of type "icon"}, or 
    //      multiple such fields
    // <li> for controls that only need to appear on rollover, consider
    //      +link{showRollOverCanvas,rollOver controls}
    // <li> if you are trying to customize the editor for a field, you can provide a custom
    //      control via +link{listGridField.editorType}, and +link{formItem.icons} are a common
    //      way to add clickable buttons.  You can also
    //      +link{getEditorType,provide different controls per record}.  These options are
    //      usually better that using <code>recordComponents</code> as custom editors, since
    //      you won't have to manage issues like making the <code>recordComponent</code> appear
    //      only when editing, having changes affect +link{group:editing,editValues},
    //      triggering saves and handling validation errors, etc.
    // </ul>
    // <P>
    // See +link{recordComponentPoolingMode} for an overview of how best to optimize use of
    // <code>recordComponents</code> for different data sets.
    // <p>
    // Regardless of the pooling mode, you can explicitly refresh record components via
    // +link{listGrid.invalidateRecordComponents()} and
    // +link{listGrid.refreshRecordComponent()}.
    // <P>
    // <i>Interaction with +link{listGrid.autoFitFieldWidths,column auto-fit}</i>: per-cell record
    // components are not taken into account when determining the size for column auto fit.
    // The default +link{listGrid.getDefaultFieldWidth()} implementation looks at cell content
    // only. We typically recommend that, for fields showing record-components, 
    // +link{listGridField.autoFitWidth} and +link{listGridField.canAutoFitWidth} be disabled, or if 
    // the record components are of a predictable size, a +link{listGridField.defaultWidth}
    // be specified.<br>
    // This is particularly pertinent where +link{listGrid.recordComponentPosition}
    // is set to "within", in which case cells' content is often empty or completely covered
    // by record-components.
    //
    // @see recordComponentPosition
    // @see showRecordComponentsByCell
    // @see recordComponentPoolingMode
    // @see showRecordComponent()
    // @see createRecordComponent()
    // @see updateRecordComponent()
    //
    // @group recordComponents
    // @visibility external
    //<

    //> @type EmbeddedPosition
    // How a component should be embedded within its record or cell
    // @value "expand" component should be placed underneath normal record or cell content,
    //        expanding the records.  Expanding records can result in variable height rows,
    //        in which case +link{listGrid.virtualScrolling,virtualScrolling} should be
    //        enabled.
    // @value "within" component should be placed within the normal area of the record or cell.
    //        Percentage sizes will be treated as percentages of the record and
    //        +link{Canvas.snapTo} positioning settings are also allowed and refer to the
    //        rectangle of the record or cell. Note that for components embedded within cells,
    //        cell align and vAlign will be used if snapTo is unset (so top / left alignment
    //        of cell content will map to snapTo of "TL", etc).
    // @visibility external
    //<

    //> @attr listGrid.recordComponentPosition (EmbeddedPosition : null : IRW)
    // if +link{listGrid.showRecordComponents} is true, how should the component appear within
    // the cell. Valid options are
    // <ul><li><code>"within"</code>: the component will be rendered inside the record / cell.
    //  +link{canvas.snapTo} may be set to specify where the component should render within
    //  the row or cell, and +link{canvas.snapOffsetTop} / +link{canvas.snapOffsetLeft} may
    //  be set to indent recordComponents within their parent cells.
    //  Note that if unset, the component will show up at the top/left edge
    //  for components embedded within an entire row, or for per-cell components, cell
    //  align and valign will be respected.  Note also that, when rendering components "within"
    //  cells, specified component heights will be respected and will change the height of the
    //  row.  However, if you want components to completely fill a cell at it's default height,
    //  set height: "100%" or rows will render at the default height of the component. </li>
    // <li><code>"expand"</code>: the component will be written into the cell below the
    //  normal cell content, causing the cell to expand vertically to accommodate it.
    // <li><code>null</code>: If this attribute is unset, we will default to showing
    //  recordComponents with position <code>"within"</code> if
    //  +link{showRecordComponentsByCell} is true, otherwise using <code>"expand"</code>
    //  logic.
    // </ul>
    // @see showRecordComponents
    // @group recordComponents
    // @visibility external
    //<
    
//    recordComponentPosition:"expand",


    //> @attr listGrid.showRecordComponentsByCell (boolean : null : IRWA)
    // If true, shows +link{listGrid.showRecordComponents, recordComponents} in cells, rather
    // than just in records.
    // @group recordComponents
    // @visibility external
    //<

    //> @type RecordComponentPoolingMode
    // The method of component-pooling to employ for +link{listGrid.showRecordComponents,recordComponents}.
    // <P>
    // @value "viewport" components are destroyed when the record is not being rendered.  Best
    //        for large datasets where embedded components differ greatly per record.
    // @value "data" components are +link{canvas.clear,clear()ed} when not in the viewport, but
    //        stay with a record until the record is dropped from cache.  Best for guaranteed
    //        small datasets.
    // @value "recycle" components are pooled and will be passed to
    //       +link{listGrid.updateRecordComponent,updateRecordComponent()} with the
    //       <code>recordChanged</code> parameter set to true.  Best for large datasets where
    //       embedded components are uniform across different records and can be efficiently
    //       reconfigured to work with a new record
    // @visibility external
    //<

    //> @attr listGrid.recordComponentPoolingMode (RecordComponentPoolingMode : "viewport" : IRWA)
    // The method of +link{type:RecordComponentPoolingMode, component-pooling} to employ for
    // +link{showRecordComponents,recordComponents}.
    // <P>
    // The default mode is "viewport", which means that recordComponents are destroyed as soon
    // their record is no longer being rendered (scrolled out of the viewport, eliminated by
    // search criteria, etc).
    // <P>
    // For a large or dynamic data set where the components shown on different rows are
    // similar, switch to "recycle" mode, which pools recordComponents by detaching them from
    // records that are not visible and re-using them in other records.  In this mode, you
    // should implement +link{updateRecordComponent()} to apply any changes to make reused
    // components applicable to the new record they appear in, if necessary.  For example, if
    // you have several controls in your <code>recordComponents</code>, and not all of the
    // controls apply to every record, your <code>updateRecordComponent()</code> implementation
    // could simply hide or disable inapplicable controls, and this would be much faster than
    // creating a whole new set of controls every time a given record is scrolled into view.
    // <p>
    // If you are using +link{showRecordComponentsByCell,per-cell recordComponents}, and you
    // have components of different types in different columns and still want to take
    // advantage of component recycling, you can set +link{listGrid.poolComponentsPerColumn} to
    // ensure that components intended for one column are not recycled for use in another
    // column that should have a different component.
    // <P>
    // Note that, if different records have distinctly different components embedded
    // in them, or multiple columns in each record embed different components, you should
    // leave the recordComponentPoolingMode at "viewport" if your dataset is very large or
    // use "data" otherwise.
    // @group recordComponents
    // @visibility external
    //<
    recordComponentPoolingMode:"viewport",

    //> @attr listGrid.poolComponentsPerColumn (Boolean : true : IRW)
    // Should recycled +link{listGrid.showRecordComponents,record components}, be pooled
    // per column or per record. Only applies if +link{listGrid.showRecordComponentsByCell} is true.
    // <P>
    // When +link{listGrid.recordComponentPoolingMode} is "recycle" and you have components of
    // different types in different columns, set this property to true to ensure that
    // components intended for one column are not recycled for use in another column that
    // should have a different component.
    // <P>
    // If no components applicable to a particular column are available in the pool, the system
    // calls +link{listGrid.createRecordComponent, createRecordComponent}.
    //
    // @group recordComponents
    // @visibility external
    //<
    
    poolComponentsPerColumn:true,

	// Rollover
	// --------------------------------------------------------------------------------------------
    //>	@attr listGrid.showRollOver (Boolean : true : IRW)
    // Should we show different styling for the cell the mouse is over?
    // <p>
    // If true, the cell style will have the suffix "Over" appended.
    // <p>
    // Can be overridden on a per-record basis via +link{listGridRecord.showRollOver}.
    //
    // @group appearance
    // @visibility external
    //<
    // showRollOver: null, // !isc.Browser.isTouch

    //> @attr listGrid.recordShowRollOverProperty (String : "showRollOver" : IR)
    // Name of the property that can be set on a per-record basis to disabled rollover for an
    // individual record when +link{listGrid.showRollOver} is true.
    //
    // @group appearance
    // @visibility external
    //<
    recordShowRollOverProperty:"showRollOver",

    //> @attr listGridRecord.showRollOver (Boolean : null : IR)
    // Set to false to disable rollover for this individual record when +link{listGrid.showRollOver}
    // is true.
    // <p>
    // Note this property can be renamed to prevent collision with data members - see
    // +link{listGrid.recordShowRollOverProperty}.
    //
    // @group appearance
    // @visibility external
    //<

    //> @attr listGridRecord.embeddedComponent (Canvas : null : IR)
    // A component that should be rendered on top of this record, similar to a
    // +link{listGrid.showRecordComponents,record component} but statically defined on the record.
    // <p>
    // The embedded component will default to covering all fields of the record, but specific fields
    // can be specified via +link{embeddedComponentFields}.
    // <p>
    // By default, the embeddedComponent will fill the entire vertical and horizontal space of the
    // record (or of the specified fields).  +link{embeddedComponentPosition} can be set to control
    // exact sizing behavior.
    // <smartclient>
    // <p>
    // When creating a component to use as an embedded component the component will most likely
    // end up drawing before the record it is due to be embedded within, therefore it is recommended
    // to set +link{canvas.autoDraw,autoDraw} to false on the embedded component.
    // </smartclient>
    // <p>
    // When a record with an <code>embeddedComponent</code> is eliminated from view by filtering or
    // because it is not currently rendered due to +link{listGrid.showAllRecords,incremental rendering}, the
    // ListGrid may +link{canvas.hide()} or +link{canvas.clear()} it.
    // <p>
    // If the current dataset is completely replaced (by a call to +link{listGrid.setData()} or
    // +link{listGrid.setDataSource()}, for example), any embedded component is
    // +link{canvas.deparent(),deparented} (which implies being +link{canvas.clear(),clear()ed}).
    // <p>
    // When a ListGrid is +link{canvas.destroy(),destroyed}, it will destroy() all embedded components
    // regardless of whether they are currently visible.  Use a call to +link{listGrid.setData()} immediately
    // before destroying the ListGrid to avoid this effect when unwanted.
    // <p>
    // For more advanced control over the lifecycle of components displayed over records, including
    // deferred creation and pooling, use the +link{listGrid.showRecordComponents,record components}
    // subsystem.
    //
    // @group appearance
    // @visibility external
    //<

    //> @attr listGridRecord.embeddedComponentPosition (EmbeddedPosition : null : IR)
    // Sizing policy applied to the embedded component.  Default behavior if unspecified is the same
    // as +link{EmbeddedPosition} "within" (fill space allocated to the record, including the ability
    // use percentage sizing and snapTo offset).  Use "expand" to have the record expand to accommodate
    // the embedded components' specified sizes instead.
    //
    // @group appearance
    // @visibility external
    //<

    //> @attr listGridRecord.embeddedComponentFields (Array of String : null : IR)
    // Fields where the +link{embeddedComponent} will be displayed, if specified.
    // <p>
    // Regardless of the order of fields specified, the component will appear from whichever field is
    // earlier in the current visible order to whichever field is later, inclusive of the specified
    // fields.
    // <p>
    // To have the component appear in just one field, either specify a single-element Array or
    // specific a two element Array with both fields the same.
    // <p>
    // If either field is hidden or invalid (no such field), the component will occupy only a single
    // field.  If both fields are hidden, the component will be hidden until one or more of the fields
    // are shown.
    //
    // @group appearance
    // @visibility external
    //<

    //> @attr listGrid.useCellRollOvers (Boolean : null : IRW)
    // Are rollovers cell-level or row-level?
    // @visibility external
    //<

    //> @attr listGrid.showRollOverCanvas (Boolean : null : IRWA)
    // When enabled, when the mouse moves over a row or cell (depending on
    // +link{useCellRollOvers}), an arbitrary Canvas can be shown layered on top of the row or
    // cell (the +link{listGrid.rollOverCanvas}), layered underneath the row or cell (the
    // +link{listGrid.rollUnderCanvas}), or both. 
    // <P>
    // This can be used to dynamically show controls or informational displays only on
    // rollover.  For example, controls to delete a row might appear only on rollover so they
    // do not clutter the static display, or a "rollUnder" Canvas could be used to display
    // additional information that can appear behind normal cell values (like displaying
    // percent complete via as a bar of color that appears behind text values).
    // <p>
    // +link{canvas.snapTo,snapTo positioning} can be used to place the
    // rollOver/rollUnderCanvas.  With <code>useCellRollOvers</code>, positioning is relative
    // to the cell, for row-level rollOver, position is relative to the portion of the
    // row that is scrolled into view (this implies a row-level rollOver/UnderCanvas can never
    // be placed horizontally scrolled out of view, but this is possible for a cell-level
    // rollOver).  
    // <p>
    // <code>snapTo</code> positioning makes it easy to do something like place a button at the
    // right edge of the grid, next to the scrollbar: just set snapTo:"R" on the
    // <code>rollOverCanvas</code>.
    // <p>
    // The rollOver/rollUnder Canvas can be a single static component (the same for all
    // cells/rows) configured via the +link{AutoChild} system, or can instead be provided
    // dynamically by implementing +link{getRollOverCanvas()} and/or +link{getRollUnderCanvas()}.
    // <p>
    // The rollOver/rollUnder canvas will be automatically added to the grid's
    // +link{listGrid.body,body} as an 
    // +link{listGrid.addEmbeddedComponent(),embedded component}.<br>
    // For grids with +link{listGridField.frozen,frozen fields}, the behavior is as follows:
    // <ul><li>If +link{useCellRollOvers} is false (the default), embedded components
    //   will be added to both the body and the frozen body</li>
    // <li>Otherwise the component will be added to whichever body contains the cell the
    //   user is currently over</li></ul>
    // The rollOver/rollUnder canvas added to the frozen body will be created by calling
    // the +link{getFrozenRollOverCanvas()} or +link{getFrozenRollUnderCanvas()} methods.
    // The default implementation for these methods matches their equivalents for non-frozen
    // rollOver / rollUnder canvases - it will use the autoChild subsystem to create a
    // canvas from the +link{rollOverCanvas} autoChild configuration.
    // <p>
    // <code>showRollOverCanvas</code> has no effect if +link{showRollOver} is <code>false</code>.
    // <P>
    // See also +link{listGrid.showSelectedRollOverCanvas}.
    //
    // @example gridRollOverReticleEffect
    // @example rolloverControls
    // @group rowEffects
    // @see ListGrid.showRollUnderCanvas
    // @visibility external
    //<
    //showRollOverCanvas:null,

    //> @attr listGrid.rollOverCanvas (AutoChild Canvas : null : RA)
    // AutoChild created and embedded in the grid if +link{ListGrid.showRollOver,showRollOver}
    // is <code>true</code> and +link{ListGrid.showRollOverCanvas,showRollOverCanvas} is
    // <code>true</code> or for selected records, if
    // +link{listGrid.showSelectedRollOverCanvas,showSelectedRollOverCanvas} 
    // is true. This component will be created and displayed above the current rollOver
    // row or cell.
    // <P>
    // Note that if this grid has frozen fields, the +link{AutoChild} subsystem will use the 
    // <code>rollOverCanvas</code> configuration settings to create the +link{frozenRollOverCanvas}
    // (displayed in the frozen listGrid body).
    // <p>
    // The <code>rollOverCanvas</code> has the following read-only attributes set:<br>
    // - <code>this.grid</code> - a pointer to the grid<br>
    // - <code>this.record</code> - a pointer to the current roll over record object in the grid
    // @example gridRollOverReticleEffect
    // @example rolloverControls
    // @group rowEffects
    // @see ListGrid.frozenRollOverCanvas
    // @see ListGrid.rollUnderCanvas
    // @visibility external
    //<
    
    //> @attr listGrid.frozenRollOverCanvas (Canvas : null : RA)
    // Automatically generated canvas embedded in the grid's frozen body if 
    // +link{ListGrid.showRollOver,showRollOver}
    // is <code>true</code> and +link{ListGrid.showRollOverCanvas,showRollOverCanvas} is
    // <code>true</code> or for selected records, if
    // +link{listGrid.showSelectedRollOverCanvas,showSelectedRollOverCanvas} 
    // is true. This component will be created and displayed above the current rollOver
    // row or cell in the frozen body.
    // <P>
    // The frozenRollOverCanvas will be created using the +link{AutoChild} subsystem, and
    // will derive its configuration from the +link{rollOverCanvas}
    // autoChild properties (<code>"rollOverCanvasProperties"</code>, et al).
    // <p>
    // The <code>frozenRollOverCanvas</code> has the following read-only attributes set:<br>
    // - <code>this.grid</code> - a pointer to the grid<br>
    // - <code>this.record</code> - a pointer to the current roll over record object in the grid
    //
    // @group rowEffects
    // @see ListGrid.rollOverCanvas
    // @see ListGrid.frozenRollUnderCanvas
    // @visibility external
    //<
    
    //> @attr listGrid.showRollUnderCanvas (Boolean : null : IRWA)
    // If roll overs are enabled, should the +link{ListGrid.rollUnderCanvas,rollUnderCanvas}
    // be displayed?
    // <p>
    // Use of the <code>showRollUnderCanvas</code> is enabled if +link{ListGrid.showRollOver,showRollOver}
    // is <code>true</code>, and either +link{ListGrid.showRollOverCanvas,showRollOverCanvas}
    // is <code>true</code> and <code>showRollUnderCanvas</code> is unset, or <code>showRollUnderCanvas</code>
    // is explicitly set to <code>true</code>.
    // <P>
    // See also +link{listGrid.showSelectedRollUnderCanvas}.
    //
    // @example gridAnimatedSelection
    // @see ListGrid.showRollOverCanvas
    // @visibility external
    //<
    //showRollUnderCanvas:null,

    //> @attr listGrid.rollUnderCanvas (AutoChild Canvas : null : RA)
    // AutoChild created and embedded in the grid if +link{ListGrid.showRollOver,showRollOver}
    // is <code>true</code>, and either +link{ListGrid.showRollOverCanvas,showRollOverCanvas}
    // is <code>true</code> and +link{ListGrid.showRollUnderCanvas,showRollUnderCanvas} is
    // unset, or <code>showRollUnderCanvas</code> is explicitly set to <code>true</code>.
    // This component will be created and displayed behind the current rollOver row or cell in the
    // page's z-order, meaning that it will only be visible if the cell styling is transparent.
    // <P>
    // Note that if this grid has frozen fields, the +link{AutoChild} subsystem will use the 
    // <code>rollUnderCanvas</code> configuration settings to create the +link{frozenRollUnderCanvas}
    // (displayed in the frozen listGrid body).
    // <p>
    // The <code>rollUnderCanvas</code> has the following read-only attributes set:<br>
    // - <code>this.grid</code> - a pointer to the grid<br>
    // - <code>this.record</code> - a pointer to the current roll over record object in the grid
    // @example gridAnimatedSelection
    // @group rowEffects
    // @visibility external
    //<
    
    //> @attr listGrid.frozenRollUnderCanvas (Canvas : null : RA)
    // Automatically generated canvas embedded in the grid's frozen body as a 
    // +link{listgrid.rollUnderCanvas,roll under canvas}.
    // This component will be created and displayed above the current rollOver
    // row or cell in the frozen body.
    // <P>
    // The frozenRollUnderCanvas will be created using the +link{AutoChild} subsystem, and
    // will derive its configuration from the +link{rollUnderCanvas}
    // autoChild properties (<code>"rollUnderCanvasProperties"</code>, et al).
    // <p>
    // The <code>frozenRollUnderCanvas</code> has the following read-only attributes set:<br>
    // - <code>this.grid</code> - a pointer to the grid<br>
    // - <code>this.record</code> - a pointer to the current roll over record object in the grid
    //
    // @group rowEffects
    // @see ListGrid.rollUnderCanvas
    // @see ListGrid.frozenRollOverCanvas
    // @visibility external
    //<    
    
    //> @attr listGrid.showSelectedRollOverCanvas (Boolean : false : IRWA)
    // This setting causes the +link{listGrid.rollOverCanvas,roll over canvas} to be
    // displayed when the user rolls over selected records in the grid (but not when
    // rolling over other records). This can be useful to display a "Selected Over"
    // appearance which can't be easily achieved via standard cell styling.
    // @group rowEffects
    // @visibility external
    //<

    //> @attr listGrid.showSelectedRollUnderCanvas (Boolean : false : IRWA)
    // This setting causes the +link{listGrid.rollUnderCanvas,roll under canvas} to be
    // displayed when the user rolls over selected records in the grid (but not when
    // rolling over other records). This can be useful to display a "Selected Over"
    // appearance which can't be easily achieved via standard cell styling.
    // <P>
    // As with +link{listGrid.showRollUnderCanvas}, if this property is unset, but
    // the related +link{listGrid.showSelectedRollOverCanvas} property is true, both the
    // the roll under and roll under canvases will be displayed as the user rolls 
    // over selected records.
    // @group rowEffects
    // @visibility external
    //<
    
    //> @attr listGrid.showRollOverInExpansion (Boolean : null : IRWA)
    // This setting causes the +link{listGrid.rollOverCanvas,roll over canvas} to be
    // sized to cover the normal row and the expansion layout. Otherwise the
    // rollOverCanvas is only shown for the un-expanded part of the row.
    // @group rowEffects
    // @visibility external
    //<

    // We enable showSelectedRollOverCanvas and showRollOverInExpansion in the Tahoe
    // skin to provide the "Selected over" focus glow
    // - a box shadow which extends beyond the edges of the rows - not easily 
    // achievable via CSS on the cells themselves.
    
    
    //> @attr listGrid.preserveFocusStylingOnMouseOut (Boolean : true : IRWA)
    // If +link{listGrid.showRollOver} or +link{listGrid.hiliteRowOnFocus} is true
    // the current keyboard focus row for navigation via arrow keys, etc, will
    // be hilighted with <code>"Over"</code> styling. This is particularly 
    // valuable to indicate which row has keyboard focus where there are multiple 
    // selected rows, or where the user is navigating without changing selection 
    // (see +link{listGrid.arrowKeyAction}).<br>
    // However, note that as the user interacts with the rows using the mouse, the rollover 
    // styling will be updated to reflect the mouse position if +link{showRollOver} is true.
    // <P>
    // When the user rolls the mouse off the grid, the default behavior is to re-style
    // the current focus row with <code>"Over"</code> styling if the grid has keyboard
    // focus. That way a user has a clear visual indication of where navigation 
    // would start. This may be disabled by setting <code>preserveFocusStylingOnMouseOut</code>
    // to false.
    //
    // @visibility external
    //<
    preserveFocusStylingOnMouseOut: true,

    //>Animation

    //> @attr listGrid.animateRollOver (Boolean : false : IRWA)
    // If the +link{ListGrid.rollOverCanvas,rollOverCanvas} is enabled, setting this property
    // to <code>true</code> ensures that when the <code>rollOverCanvas</code> is displayed it
    // is animated into view via +link{Canvas.animateShow()}. Note that the animation effect
    // may be customized via +link{Canvas.animateShowEffect}, +link{Canvas.animateShowTime} and
    // +link{Canvas.animateShowAcceleration} set in <code>rollOverCanvasProperties</code>.
    // @group rowEffects
    // @visibility external
    //<
    animateRollOver: false,

    //> @attr listGrid.animateRollUnder (Boolean : false : IRWA)
    // If the +link{ListGrid.rollUnderCanvas,rollUnderCanvas} is enabled, setting this property
    // to <code>true</code> ensures that when the <code>rollUnderCanvas</code> is displayed it
    // is animated into view via +link{Canvas.animateShow()}. Note that the animation effect
    // may be customized via +link{Canvas.animateShowEffect}, +link{Canvas.animateShowTime} and
    // +link{Canvas.animateShowAcceleration} set in <code>rollUnderCanvasProperties</code>.
    // @example gridAnimatedSelection
    // @group rowEffects
    // @visibility external
    //<
    animateRollUnder: false,

    //<Animation

    //> @attr listGrid.showBackgroundComponents (Boolean : false : IRW)
    // If <code>true</code> this grid will create and show per-row backgroundComponents
    // as detailed +link{listGrid.backgroundComponent,here}.
    // @visibility external
    //<

    //> @attr listGrid.backgroundComponent (MultiAutoChild Canvas : null : IR)
    // Has no effect unless +link{listGrid.showBackgroundComponents} is <code>true</code>.
    // <P>
    // Canvas created and embedded in the body behind a given record.   When
    // +link{listGridRecord.backgroundComponent} is set, this autoChild canvas
    // will be constructed (if listGridRecord.backgroundComponent is not already a Canvas) and
    // its properties combined with those of listGridRecord.backgroundComponent and then
    // displayed behind a specific record in the page's z-order, meaning
    // it will only be visible if the cell styling is transparent.
    // @group rowEffects
    // @visibility external
    //<
    backgroundComponentDefaults: {
        snapTo:"TL",
        autoDraw: false,
        opacity: "50%"
    },

    // Hover
    // --------------------------------------------------------------------------------------------

    //> @attr listGrid.canHover (boolean : null : [IRW])
    // @include gridRenderer.canHover
    // @group hovers
    // @see attr:listGrid.showHover
    // @see attr:listGridField.showHover
    // @example valueHoverTips
    //<
    // are hover events and hover popups enabled?
    //canHover:false,

    //> @attr listGrid.showHover (Boolean : true : [IRW])
    // If true, and +link{ListGrid.canHover, canHover} is also true, shows popup hover text 
    // next to the mouse when the user hovers over a cell.  The content of the hover is 
    // determined by +link{ListGrid.cellHoverHTML, cellHoverHTML()}.
    // <P>
    // This is the default setting for the grid and can be overridden on a 
    // +link{listGridField.showHover, per-field} basis.
    // @group hovers
    // @see ListGrid.canHover
    // @see ListGrid.cellHoverHTML()
    // @visibility external
    //<
    // if canHover:true, should we show hover popups?
    showHover: true,

    //> @attr listGrid.showClippedHeaderTitlesOnHover (boolean : true : [IRA])
    // If true and a header button's title is clipped, then a hover containing the full field
    // title is enabled.
    // @group hovers
    // @see ListGrid.headerTitleClipped()
    // @see ListGrid.headerHoverHTML()
    // @visibility external
    //<
    showClippedHeaderTitlesOnHover: true,

    //> @attr listGridField.showHover (boolean : null : IRW)
    // Whether to show hovers for this field.  The default hover will be the contents of the
    // cell the user is hovering over, and can be customized via
    // +link{listGridField.hoverHTML,field.hoverHTML()}.
    // <P>
    // +link{ListGrid.showHover} can be set to true to cause hovers to be shown for all fields
    // by default.  In this case, <code>field.showHover</code> can be set to false to suppress
    // hovers for an individual field.
    // <P>
    // All hovers can be disabled, regardless of other settings, by setting
    // +link{ListGrid.canHover} to false.
    // @visibility external
    // @example valueHoverTips
    //<

    //> @attr listGridField.showHoverComponents (Boolean : null : IRW)
    // When set to true and showHover is also true for the field, shows a widget hovering at 
    // the mouse point.
    // <P>
    // A number of builtin modes are provided - see +link{type:HoverMode}.
    // <P>
    // Also supported at the +link{listGrid.showHoverComponents, ListGrid-level}.
    // @group hoverComponents
    // @visibility external
    //<

    // can be set to false to cause hover to be per-row instead of per-cell
    //hoverByCell:true,

    // if canHover:true, should an active hover remain active until we leave the listGrid?
    // default behavior is to clear/deactivate the hover on each cellOut/rowOut
    //keepHoverActive:false,

    // the space between the borders of the cell and the hover, in pixels
    cellHoverOutset:5,

    // Note: hoverWidth, hoverStyle, et al will be picked up by the grid renderer when showing
    // cell hovers (handled by GridRenderer class)

    //> @attr listGrid.hoverStyle (CSSStyleName : "gridHover" : [IRWA])
    // Style to apply to hovers shown over this grid.
    // @see listGrid.showHover
    // @group hovers
    // @visibility external
    //<
    hoverStyle:"gridHover",

    //> @attr listGridField.prompt (HTMLString : null : IR)
    // Causes a tooltip hover to appear on the header generated for this field (effectively
    // sets +link{canvas.prompt} for the header).
    //
    // @visibility external
    //<

    //> @attr listGridField.editorHint (HTMLString : null : IRW)
    // Specifies "hint" string to show when the field is edited to indicate something to the
    // user.  For a field using a +link{TextItem} editor, the hint is shown within the field by
    // default.
    //
    // @visibility reify
    //<

    // Selection
    // --------------------------------------------------------------------------------------------

    //> @attr listGrid.selection (Selection | CellSelection : null : [RA])
    // @include listGrid.selectionManager
    // @getter noauto
    // @group selection
    // @deprecated in favor of +link{selectionManager()}
    // @visibility external
    //<
    

    //> @attr listGrid.selectionManager (Selection | CellSelection | MultiLinkSelection : null : [RA])
    // The +link{group:selection,Selection object} associated with the <code>ListGrid</code>.
    // @group selection
    // @visibility external
    //<
    


    //> @attr listGrid.selectionAppearance (SelectionAppearance : "rowStyle" : IRW)
    // How selection of rows should be presented to the user.
    // <P>
    // For <code>selectionAppearance:"checkbox"</code> with multiple selection
    // allowed, you would typically use +link{listGrid.selectionType}:"simple" (the default).  Because
    // <code>selectionType</code> and <code>selectionAppearance</code> are unrelated,
    // the combination of <code>selectionAppearance:"checkbox"</code> and
    // <code>selectionType:"multiple"</code> results in a grid where multiple selection can
    // only be achieved via shift-click or ctrl-click.
    // <P>
    // If using <code>"checkbox"</code> for a +link{listGrid}, see also
    // +link{listGrid.checkboxField} for customization APIs.
    // <P>
    // If using <code>"checkbox"</code> for a +link{treeGrid}, an extra icon,
    // +link{treeGrid.getExtraIcon} is not supported. Additionally only
    // +link{listGrid.selectionType}:"simple" and "single" are supported.
    // You can also toggle the display of a disabled checkbox on a treeGrid, displayed
    // when the node can't be selected, via +link{TreeGrid.showDisabledSelectionCheckbox}.
    // <p>
    // Note that the default behavior when you enable checkbox selection is to continue to show
    // the selected style.  This can be changed by setting +link{showSelectedStyle} to false.
    // @group selection
    // @visibility external
    //<
    selectionAppearance: "rowStyle",

    //> @attr listGrid.canSelectAll (boolean : null : [IRW])
    // Controls whether a checkbox for selecting all records appears in the header with
    // +link{listGrid.selectionAppearance, selectionAppearance} set to "checkbox"
    //
    // @group selection
    // @visibility external
    //<
    
    //> @attr listGrid.showHeaderPartialSelection (boolean : null : [IRW])
    // Should partial selection of all records be shown in header with a special icon?
    // The partial icon will show in the header when +link{listGrid.canSelectAll} is
    // enabled and at least one record is selected but all records are not selected.
    // To only show all selected and none selected states, set this attribute to <code>false</code>.
    //
    // @group selection
    // @visibility external
    //<
    
    //> @attr listGrid.canSelectGroups (boolean : false : [IRW])
    // Controls whether a checkbox for selecting +link{listGrid.groupBy(),groups} appears
    // in the group node if +link{selectionAppearance} is set to <code>"checkbox"</code>
    // @group selection
    // @visibility external
    //<
    
    //> @attr listGrid.showPartialSelection (Boolean : false : [IRW])
    // Should partially selected parents (in a Tree data set) be shown with special icon?
    // This has an impact in grouped grids where +link{canSelectGroups} is true. The
    // partial icon will show up for the group header node when a group is partially
    // selected.
    // @group selection
    // @visibility external
    //<

    //> @attr listGrid.deselectOnPartialCheckboxClick (Boolean : false : [IRW])
    // Should partially selected checkbox be deselected or selected on click? This setting
    // affects +link{canSelectAll, header selection checkbox}, +link{canSelectGroups, group
    // checkboxes} and folder checkbox selection in a Tree data set.
    // <p>
    // By default clicking a partially selected checkbox selects it.
    // @group selection
    // @visibility external
    //<

    //> @attr listGrid.selectionType (SelectionStyle : null : [IRW])
    // Defines a listGrid's clickable-selection behavior.
    // <P>
    // The default selection appearance is governed by +link{listGrid.selectionAppearance}: if
    // selectionAppearance is "checkbox", this will be "simple", otherwise, this will be
    // "multiple".
    //
    // @group   selection, appearance
    // @see type:SelectionStyle
    //      @visibility external
    // @example multipleSelect
    //<
    selectionType:null,

    //> @attr listGrid.selectionProperty (String : null : IRA)
    // If specified, the selection object for this list will use this property to mark records
    // as selected.  In other words, if this attribute were set to <code>"isSelected"</code>
    // any records in the listGrid data where <code>"isSelected"</code> is <code>true</code>
    // will show up as selected in the grid. Similarly if records are selected within the grid
    // after the grid has been created, this property will be set to true on the selected
    // records.
    //
    // @group  selection, appearance
    // @visibility external
    //<
    //selectionProperty:null,

    //> @attr listGrid.reselectOnUpdate (boolean : true : IRA)
    // If true, when an update operation occurs on a selected record in a
    // +link{listGrid.dataSource,databound} listGrid, ensure the updated record is
    // re-selected when the operation completes.
    // The +link{listGrid.reselectOnUpdateNotifications} attributes governs whether
    // +link{listGrid.selectionUpdated()} and +link{listGrid.selectionChanged()} will fire
    // when this occurs.
    // @visibility external
    //<
    // This property is passed to the selection object in DBC.createSelectionModel()
    reselectOnUpdate:true,

    //> @attr listGrid.reselectOnUpdateNotifications (SelectionNotificationType : "selectionChanged" : IRWA)
    // if +link{listGrid.reselectOnUpdate} is true, this property governs what
    // selection changed notifications should be triggered when a selected record
    // is edited then automatically reselected when the edited data is merged into
    // the data set.
    // @visibility external
    //<
    reselectOnUpdateNotifications:"selectionChanged",

    //> @attr listGrid.recordCanSelectProperty (String : "canSelect" : IRA)
    // If set to false on a record, selection of that record is disallowed.
    // @visibility external
    //<
    recordCanSelectProperty:"canSelect",

    //> @attr listGridRecord.canSelect (boolean : null : IR)
    //
    // Default property name denoting whether this record can be selected. Property name may be
    // modified for the grid via +link{listGrid.recordCanSelectProperty}.
    //
    // @visibility external
    //<

    //> @attr listGrid.canSelectCells (Boolean : false : IR)
    // Enables cell-level selection behavior as well as
    // +link{useCellRollOvers,cell-level rollover}.
    // <P>
    // To query and manipulate cell-level selections, use +link{getCellSelection()} to retrieve
    // the +link{CellSelection}.
    // <P>
    // Note that the ListGrid has a data model of one +link{Record} per row, unlike the
    // +link{CubeGrid} which supports one +link{CellRecord} per cell.  For this reason
    // record-oriented APIs that act on the selection will act on entire Records that have
    // <i>any</i> selected cells (examples include drag and drop and transferSelectedData()).
    // <P>
    // More generally, <code>canSelectCells</code> is primarily intended to enable developers
    // to build Excel-like interactions on local datasets, by using +link{setData()} plus
    // +link{saveLocally}:true rather than record-oriented DataSources and data binding.
    // You can also use <code>canSelectCells</code> in conjunction with +link{selectionAppearance} 
    // set to "checkbox" to complete this experience.
    // <P>
    // The following keyboard selection behaviors are enabled with this property in
    // addition to standard single-selection Arrow Key navigation:
    // <P>
    // SHIFT +        [Arrow Key]:  begin or continue incremental selection
    // <P>
    // SHIFT + CTRL + [Arrow Key]:  incremental selection to the end of row or column
    // <P>
    // CTRL  + A: select all cells (enabled only with +link{listGrid.canSelectAll})
    // <P>
    // Incremental selection allows selection of rows and columns of cells via keyboard
    // or mouse provided the shift key is down.  Behavior is designed to match Excel.
    // Thus, if a previous selection has begun, cells will be selected from that origin.
    // <P>
    // Users may also navigate through cells using the <i>Tab</i> and <i>Shift+Tab</i>
    // keypresses if +link{listGrid.navigateOnTab} is true. When a user tabs to the
    // end of the row, the +link{listGrid.rowEndEditAction} is used to determine whether
    // to shift selection to the next row, return to the beginning of the same row, or
    // simply move on through the page's tab order.
    //
    // @visibility external
    //<
    //canSelectCells:false,

    //> @attr listGrid.screenReaderNavigateByCell (boolean : false : IRW)
    // If +link{isc.setScreenReaderMode(),screen reader mode is enabled}, and
    // +link{listGrid.canSelectCells} is true should the user be able to navigate 
    // the grid cell-by-cell, highlighting and focusing on individual cells within the
    // selected row via left and right arrow keypresses?
    // <P>
    // If +link{listGrid.canSelectCells} is true, this property will have no effect as
    // all navigation is by cell.
    // 
    // @visibility external
    //<
    
    screenReaderNavigateByCell:false,

    //> @attr listGrid.navigateOnTab (boolean : null : IRW)
    // If +link{listGrid.canSelectCells} is true, this property allows the user
    // to navigate through the cells of a grid using Tab and Shift+Tab keypresses.
    // When a user tabs to the
    // end of the row, the +link{listGrid.rowEndEditAction} is used to determine whether
    // to shift selection to the next row, return to the beginning of the same row, or
    // simply move on through the page's tab order.
    // <P>
    // Note - if this property is not explicitly set, navigateOnTab behavior will be 
    // enabled for grids unless +link{isc.setScreenReaderMode(),screenReader mode is on} in 
    // which case it will be disabled.<br> 
    // Developers should be aware that setting <code>navigateOnTab</code> explicitly to true
    // enabled the behavior even in screenReader mode. This may have an impact on the 
    // accessibility of an application - screen reader mode users navigating the
    // application via the keyboard would have to tab through every single data cell
    // in the grid grid before being able to tab to the next component.
    //
    // @visibility external
    //<
    
    navigateOnTab:null,

    shouldNavigateOnTab : function () {
        var navigateOnTab = this.navigateOnTab;
        if (navigateOnTab == null) navigateOnTab = !isc.screenReader;
        return this.canSelectCells && navigateOnTab;
    },
    // Undocumented corollary for arrowKeyAction for navigateOnTab
    tabKeyAction:"select",

    //> @attr listGrid.useCopyPasteShortcuts (Boolean : null : IRW)
    // For ListGrids with +link{listGrid.canSelectCells,canSelectCells:true}, enabling this
    // property will cause the listGrid to intercept standard browser copy/paste shortcut
    // keys and perform the following behavior.
    // <ul>
    // <li><i>ctrl+c</i>: retrieve selected cell data 
    //     via a call to +link{listGrid.getSelectedCellData()}, and temporarily store it 
    //     in memory in a "clipboard" variable.</li>
    // <li><i>ctrl+v</i>: apply any previously copied data stored in the "clipboard" variable 
    //     into the current grid selection via +link{listGrid.applyCellData}.</li>
    // <li><i>ctrl+d</i>: copy cell values from top row of selected cells down to all rows
    // <li><i>ctrl+r</i>: copy cell values from left column of selected cells right to all columns
    // </ul>
    // <b>Note:</b> setting this property to true will disable standard copy and paste behavior
    // to the native Browser or OS-level clipboard. To copy data to and
    // from applications outside of the browser, use the technique shown in the
    // +explorerExample{gridToExcel,Grid to Excel} and
    // +explorerExample{excelToGrid,Excel to Grid} samples.
    // <P>
    // If this property is unset, default behavior will enable these shortcuts if
    // +link{listGrid.canSelectCells} is true, and +link{listGrid.canDragSelectText} and
    // +link{listGrid.selectCellTextOnClick} are both false, so as to minimize the chances
    // of interfering with native copy and paste of cell content.
    // @visibility external
    //<
    useCopyPasteShortcuts: null,
    _shouldUseCopyPasteShortcuts : function () {
        if (!this.canSelectCells) return false;

        var canSelectCellText = this.canDragSelectText || this.selectCellTextOnClick;
        if (this.useCopyPasteShortcuts == null) {
            return !canSelectCellText;
        } else {
            if (canSelectCellText && !isc.ListGrid._loggedCopyPasteWarning) {
                this.logWarn("Both 'useCopyPasteShortcut' and either " + 
                    "'canDragSelectText' or 'selectCellTextOnClick' is enabled for this grid. " +
                    "This configuration will allow the user to select cell content for copying " +
                    "but will intercept the OS level 'copy' keyboard shortcut, potentially " +
                    "resulting in a confusing user experience.");
                isc.ListGrid._loggedCopyPasteWarning = true;
            }
            return this.useCopyPasteShortcuts;
        }
    },

    //> @attr listGrid.originBaseStyle (CSSStyleName : null : IRW)
    // Name of a CSS Style to use as the +link{listGrid.baseStyle} for a cell that
    // is currently a selection origin for shifted incremental cell selection.
    // Only has an effect if +link{listGrid.canSelectCells} is true.
    // <P>
    // @visibility external
    //<
    //originBaseStyle: null,

    //> @attr listGrid.copyEmptyCells (boolean : true : IRW)
    // Determines whether empty cells (those with an undefined value) are present
    // in the records generated by +link{listGrid.getSelectedCellData}, If true, an
    // empty cell in the selection will be added to the record with a null value.
    // If false, an empty cell will not be represented in the record at all.
    //<
    copyEmptyCells: true,

    //> @attr listGrid.canDragSelect (Boolean : false : IRW)
    //  If this property is true, users can drag the mouse to select several rows or cells.
    //  This is mutually exclusive with rearranging rows or cells by dragging.
    // <p>
    // <strong>NOTE:</strong> If <code>canDragSelect</code> is initially enabled or might be
    // dynamically enabled after the grid is created, it may be desirable to disable
    // +link{Canvas.useTouchScrolling,touch scrolling} so that touch-dragging records/cells
    // selects them rather than starting a scroll. If +link{Canvas.disableTouchScrollingForDrag}
    // is set to <code>true</code>, then touch scrolling will be disabled automatically.
    // However, for +link{group:accessibility,accessibility} reasons, it is recommended to
    // leave touch scrolling enabled and provide an alternative set of controls that can be
    // used to perform drag-selection.
    //  @group  selection
    //  @visibility external
    //  @example dragListSelect
    //<
    //canDragSelect:false,

    //> @attr listGrid.canDragSelectText (Boolean : false : IRW)
    // If this property is true, users can drag the mouse to select text within grid rows,
    // ready to be cliped to clipboard.<br>
    // This is mutually exclusive with
    // +link{canReorderRecords,rearranging rows or cells by dragging}, and with
    // +link{canDragSelect,drag selection of rows}.
    // <P>
    // To enable selecting cell text on click, see +link{listGrid.selectCellTextOnClick}.
    //
    // @group selection
    // @visibility external
    //<
    //canDragSelectText:false,

    //> @attr listGrid.canDropInEmptyArea (Boolean : true : IRW)
    // If set to false, dropping over an empty part of the grid body is disallowed and the
    // no-drop indicator is displayed.
    // @group dragdrop
    // @visibility external
    //<
    //canDropInEmptyArea: true,

    //> @attr listGrid.showSelectionCanvas (Boolean : null : IRWA)
    // If +link{ListGrid.selectionType,selectionType} is set to
    // <smartclient>"single",</smartclient>
    // <smartgwt>{@link com.smartgwt.client.types.SelectionStyle#SINGLE},</smartgwt>
    // setting this property to <code>true</code> means selection will be displayed to the
    // user with the +link{ListGrid.selectionCanvas,selectionCanvas} and/or
    // +link{ListGrid.selectionUnderCanvas,selectionUnderCanvas} rather than with CSS styling.
    // <p>
    // If <code>showSelectionCanvas</code> is set to <code>true</code>, then the
    // <code>selectionUnderCanvas</code> will automatically be enabled unless
    // +link{showSelectionUnderCanvas,showSelectionUnderCanvas} is set to <code>false</code>.
    // <p>
    // NOTE: It is recommended to use the <code>selectionUnderCanvas</code> rather than the
    // <code>selectionCanvas</code> if possible because the <code>selectionCanvas</code> is
    // stacked on top of the selected record and this may interfere with event handling in rare
    // cases. If no interactive components are shown in the <code>selectionCanvas</code> and it
    // simply provides custom styling, then the <code>selectionUnderCanvas</code> should be used
    // instead.
    // <p>
    // With +link{ListGrid.canFreezeFields,frozen fields}, the <code>selectionCanvas</code>
    // is displayed only over the non-frozen fields of the selected row.
    // @group rowEffects
    // @see ListGrid.showSelectionUnderCanvas
    // @visibility external
    //<
    //showSelectionCanvas:null,

    //> @attr listGrid.selectionCanvas (AutoChild Canvas : null : RA)
    // AutoChild created and embedded in the grid if +link{ListGrid.showSelectionCanvas,showSelectionCanvas}
    // is <code>true</code> and the +link{ListGrid.selectionType,selectionType} is
    // <smartclient>"single".</smartclient>
    // <smartgwt>{@link com.smartgwt.client.types.SelectionStyle#SINGLE}.</smartgwt>
    // This component will be created and displayed above the selected record whenever the
    // selection changes.
    // <p>
    // NOTE: It is recommended to use the +link{ListGrid.selectionUnderCanvas,selectionUnderCanvas}
    // rather than the <code>selectionCanvas</code> if possible because the <code>selectionCanvas</code>
    // is stacked on top of the selected record and this may interfere with event handling in rare
    // cases. If no interactive components are shown in the <code>selectionCanvas</code> and it
    // simply provides custom styling, then the <code>selectionUnderCanvas</code> should be used
    // instead.
    // <p>
    // The <code>selectionCanvas</code> has the following read-only attributes set:<br>
    // - <code>this.grid</code> - a pointer to the grid<br>
    // - <code>this.record</code> - a pointer to the currently selected record in the grid
    // @group rowEffects
    // @see ListGrid.selectionUnderCanvas
    // @visibility external
    //<

    //> @attr listGrid.showSelectionUnderCanvas (Boolean : null : IRWA)
    // If +link{ListGrid.selectionType,selectionType} is set to
    // <smartclient>"single",</smartclient>
    // <smartgwt>{@link com.smartgwt.client.types.SelectionStyle#SINGLE},</smartgwt>
    // and either +link{showSelectionCanvas,showSelectionCanvas} is <code>true</code> and
    // <code>showSelectionUnderCanvas</code> is unset, or <code>showSelectionUnderCanvas</code>
    // is explicitly set to <code>true</code>, then selection will be displayed to the
    // user with the +link{ListGrid.selectionCanvas,selectionCanvas} and/or
    // +link{ListGrid.selectionUnderCanvas,selectionUnderCanvas} rather than with CSS styling.
    // Setting <code>showSelectionUnderCanvas</code> to <code>false</code> will disable
    // the use of the <code>selectionUnderCanvas</code>.
    // <p>
    // With +link{ListGrid.canFreezeFields,frozen fields}, the <code>selectionUnderCanvas</code>
    // is displayed only behind the non-frozen fields of the selected row.
    // @example gridRoundedSelection
    // @group rowEffects
    // @see ListGrid.showSelectionCanvas
    // @visibility external
    //<
    
    //showSelectionUnderCanvas:null,

    //> @attr listGrid.selectionUnderCanvas (AutoChild Canvas : null : RA)
    // AutoChild created and embedded in the grid if +link{ListGrid.showSelectionCanvas,showSelectionCanvas}
    // is <code>true</code> and +link{ListGrid.showSelectionUnderCanvas,showSelectionUnderCanvas}
    // is unset, or <code>showSelectionUnderCanvas</code> is explicitly set to <code>true</code>,
    // and the +link{ListGrid.selectionType,selectionType} is
    // <smartclient>"single".</smartclient>
    // <smartgwt>{@link com.smartgwt.client.types.SelectionStyle#SINGLE}.</smartgwt>
    // This component will be created and displayed behind the selected record whenever the
    // selection changes.
    // <p>
    // The <code>selectionUnderCanvas</code> has the following read-only attributes set:<br>
    // - <code>this.grid</code> - a pointer to the grid<br>
    // - <code>this.record</code> - a pointer to the currently selected record object in the grid
    // @example gridRoundedSelection
    // @group rowEffects
    // @see ListGrid.selectionCanvas
    // @visibility external
    //<

    //>Animation

    //> @attr listGrid.animateSelection (Boolean : false : IRWA)
    // If the +link{ListGrid.selectionCanvas,selectionCanvas} is enabled, setting
    // this property to <code>true</code> ensures that when the <code>selectionCanvas</code>
    // is displayed it is animated into view via +link{Canvas.animateShow()}. Note that the
    // animation effect may be customized via +link{Canvas.animateShowEffect},
    // +link{Canvas.animateShowTime} and +link{Canvas.animateShowAcceleration} set in
    // <code>selectionCanvasProperties</code>.
    // @group rowEffects
    // @see ListGrid.animateSelectionUnder
    // @visibility external
    //<
    animateSelection: false,

    //> @attr listGrid.animateSelectionUnder (Boolean : false : IRWA)
    // If the +link{ListGrid.selectionUnderCanvas,selectionUnderCanvas} is enabled, setting
    // this property to <code>true</code> ensures that when the <code>selectionUnderCanvas</code>
    // is displayed it is animated into view via +link{Canvas.animateShow()}. Note that the
    // animation effect may be customized via +link{Canvas.animateShowEffect},
    // +link{Canvas.animateShowTime} and +link{Canvas.animateShowAcceleration} set in
    // <code>selectionUnderCanvasProperties</code>.
    // @example gridAnimatedSelection
    // @group rowEffects
    // @see ListGrid.animateSelection
    // @visibility external
    //<
    animateSelectionUnder: false,

    //<Animation

    //> @attr listGrid.checkboxField (AutoChild ListGridField : null : IR)
    // Returns the specially generated checkbox field used when +link{selectionAppearance} is
    // "checkbox".  Created via the +link{AutoChild} pattern so that
    // <code>checkboxFieldDefaults</code> and <code>checkboxFieldProperties</code> are available
    // for skinning purposes. Note that +link{listGridField.shouldPrint} is <code>false</code>
    // for the checkboxField by default - if you want this column to show up in the grid's print
    // view, use <code>checkboxFieldProperties</code> to set this property to true.
    // <P>
    // This field will render an icon to indicate the selected state of each row, which, when
    // clicked will toggle the selection state. The icon src may be configured using
    // +link{listGrid.checkboxFieldTrueImage} and +link{listGrid.checkboxFieldFalseImage}, as
    // well as +link{listGrid.checkboxFieldImageWidth} and +link{listGrid.checkboxFieldImageHeight}.
    // <P>
    // The checkboxField can be detected by calling +link{listGrid.isCheckboxField()} on any
    // ListGridField object.
    //
    // @group checkboxField
    // @visibility external
    //<

    //> @attr listGrid.checkboxFieldTrueImage (SCImgURL : null :IRWA)
    // If +link{listGrid.selectionAppearance} is set to <code>"checkbox"</code> this property
    // determines the image to display in the checkbox field for a selected row.
    // If unset, the +link{listGrid.booleanTrueImage} will be used. Note that the special
    // value "blank" means that no image will be shown.
    // @see ListGrid.checkboxFieldFalseImage
    // @see ListGrid.checkboxFieldImageWidth
    // @see ListGrid.checkboxFieldImageHeight
    // @see ListGrid.printCheckboxFieldTrueImage
    // @group checkboxField
    // @visibility external
    //<

    //> @attr listGrid.checkboxFieldFalseImage (SCImgURL : null :IRWA)
    // If +link{listGrid.selectionAppearance} is set to <code>"checkbox"</code> this property
    // determines the image to display in the checkbox field for an unselected row.
    // If unset, the +link{listGrid.booleanFalseImage} will be used. Note that the special
    // value "blank" means that no image will be shown.
    // @see ListGrid.checkboxFieldTrueImage
    // @see ListGrid.checkboxFieldImageWidth
    // @see ListGrid.checkboxFieldImageHeight
    // @see ListGrid.printCheckboxFieldFalseImage
    // @group checkboxField
    // @visibility external
    //<

    //> @attr listGrid.checkboxFieldPartialImage (SCImgURL : null :IRWA)
    // If +link{listGrid.selectionAppearance} is set to <code>"checkbox"</code> this property
    // determines the image to display in the checkbox field for a partially selected row.
    // If unset, the +link{listGrid.booleanPartialImage} will be used. Note that the special
    // value "blank" means that no image will be shown.
    // @see ListGrid.checkboxFieldTrueImage
    // @see ListGrid.checkboxFieldImageWidth
    // @see ListGrid.checkboxFieldImageHeight
    // @see ListGrid.printCheckboxFieldPartialImage
    // @group checkboxField
    // @group printing
    // @visibility external
    //<
    //printCheckboxFieldPartialImage:null,

    //> @attr listGrid.printCheckboxFieldTrueImage (SCImgURL : null :IRWA)
    // If set, the +link{ListGrid.checkboxFieldTrueImage} to use when +link{group:printing,printing}.
    // @see ListGrid.checkboxFieldTrueImage
    // @group checkboxField
    // @group printing
    // @visibility external
    //<
    //printCheckboxFieldTrueImage:null,

    //> @attr listGrid.printCheckboxFieldFalseImage (SCImgURL : null :IRWA)
    // If set, the +link{ListGrid.checkboxFieldFalseImage} to use when +link{group:printing,printing}.
    // @see ListGrid.checkboxFieldFalseImage
    // @group checkboxField
    // @group printing
    // @visibility external
    //<
    //printCheckboxFieldFalseImage:null,

    //> @attr listGrid.printCheckboxFieldPartialImage (SCImgURL : null :IRWA)
    // If set, the +link{ListGrid.checkboxFieldPartialImage} to use when +link{group:printing,printing}.
    // @see ListGrid.checkboxFieldPartialImage
    // @group checkboxField
    // @group printing
    // @visibility external
    //<
    //printCheckboxFieldPartialImage:null,

    //> @attr listGrid.checkboxFieldImageWidth (Integer : null : IR)
    // If +link{listGrid.selectionAppearance} is set to <code>"checkbox"</code> this property
    // may be set to govern the width of the checkbox image displayed to indicate whether a row is
    // selected. If unset, the checkboxField image will be sized to match the
    // +link{listGrid.booleanImageWidth} for this grid.
    // @group checkboxField
    // @visibility external
    //<

    //> @attr listGrid.checkboxFieldImageHeight (Integer : null : IR)
    // If +link{listGrid.selectionAppearance} is set to <code>"checkbox"</code> this property
    // may be set to govern the height of the checkbox image displayed to indicate whether a row is
    // selected. If unset, the checkboxField image will be sized to match the
    // +link{listGrid.booleanImageHeight} for this grid.
    // @group checkboxField
    // @visibility external
    //<

    // Empty and loading messages
    // --------------------------------------------------------------------------------------------

    //> @attr listGrid.showEmptyMessage (Boolean : true : [IRW])
    // @include gridRenderer.showEmptyMessage
    // @example emptyGrid
    //<
    showEmptyMessage:true,

    //> @attr listGrid.emptyMessage (HTMLString : "No items to show." : [IRW])
    // @include gridRenderer.emptyMessage
    // @example emptyGrid
    //<
    emptyMessage:"No items to show.",

    setEmptyMessage : function (emptyMessage) {
        this.emptyMessage = emptyMessage;
        if (this.body && this.body.isDrawn()){
            this.body.markForRedraw();
        }
    },
            
    //> @attr listGrid.emptyMessageStyle (CSSStyleName : "emptyMessage" : [IRW])
    // The CSS style name applied to the +link{emptyMessage} if displayed.
    // @group emptyMessage
    // @visibility external
    //<
    emptyMessageStyle:"emptyMessage",

    _getEmptyMessageStyleVPad : function () {
        return isc.GridRenderer._getEmptyMessageStyleVPad(this.emptyMessageStyle);
    },

    //> @attr listGrid.filterButtonPrompt (String : "Filter" : [IR])
    // The prompt to show when the mouse hovers over the Filter button in the FilterEditor.
    // @group i18nMessages
    // @visibility external
    //<
    filterButtonPrompt : "Filter",


    //> @attr listGrid.loadingDataMessage (HTMLString : "${loadingImage}&nbsp;Loading data..." : IRW)
    // The string to display in the body of a listGrid while data is being loaded.
    // Use <code>"&#36;{loadingImage}"</code> to include +link{Canvas.loadingImageSrc,a loading image}.
    // @see loadingDataMessageStyle
    // @group emptyMessage, i18nMessages
    // @visibility external
    //<
    loadingDataMessage : "${loadingImage}&nbsp;Loading data...",

    //> @attr listGrid.loadingDataMessageStyle (CSSStyleName : "loadingDataMessage" : [IRW])
    // The CSS style name applied to the loadingDataMessage string if displayed.
    // @group emptyMessage
    // @visibility external
    //<
    loadingDataMessageStyle: "loadingDataMessage",

    //> @attr listGrid.loadingMessage (String : "&nbsp;" : IR)
    // If you have a databound listGrid and you scroll out of the currently loaded dataset, by
    // default you will see blank rows until the server returns the data for those rows.  The
    // loadingMessage attribute allows you to specify arbitrary html that will be shown in each
    // such "blank" record while the data for that record is loading.
    //
    // @group emptyMessage, i18nMessages
    // @visibility external
    //<
    loadingMessage:"&nbsp;",

    // Separator / Single Cell rows
    // ---------------------------------------------------------------------------------------

    //> @attr listGrid.singleCellValueProperty (String : "singleCellValue" : IRW)
    // If <code>record[this.singleCellValueProperty]</code> is set for some record, the
    // record will be displayed as a single cell spanning every column in the grid, with
    // contents set to the value of <code>record[this.singleCellValueProperty]</code>.
    // @visibility external
    //<
    singleCellValueProperty:"singleCellValue",

    //> @attr listGrid.isSeparatorProperty (String : "isSeparator" : IRW)
    // If <code>record[this.isSeparatorProperty]</code> is set for some record, the
    // record will be displayed as a simple separator row.
    // @visibility external
    //<
    isSeparatorProperty:"isSeparator",

    // Filter Editor (aka QBE)
    // ---------------------------------------------------------------------------------------

    //> @attr listGrid.showFilterEditor (boolean : false : IRW)
    // Should this listGrid display a filter row.  If true, this ListGrid
    // will be drawn with a single editable row, (separate from the body) with a filter button.
    // <P>
    // Values entered into this row are used as filter criteria to filter this List's data.
    // The +link{listGrid.filterByCell} and +link{listGrid.filterOnKeypress} attributes allow
    // developers to configure whether filtering occurs automatically on change or requires
    // an enter-keypress or filter button click.<br>
    // +link{listGrid.autoFetchTextMatchStyle} determines
    // the textMatchStyle for the request passed to +link{listGrid.fetchData()}.
    // <P>
    // The default +link{formItem.operator,search operator} for an item in the filterEditor can
    // be set via +link{listGridField.filterOperator}.   When <code>field.filterOperator</code> 
    // has been set calls to retrieve the criteria from the grid return +link{AdvancedCriteria}.  
    // See also +link{allowFilterOperators} for a UI that allows end users to change the search
    // operator on the fly
    // <P>
    // Note that if +link{listGrid.filterData()} or +link{listGrid.fetchData()} is called
    // directly while the filter editor is showing, the filter editor values will be updated to
    // reflect the new set of criteria. If you wish to retain the user entered filter criteria
    // and modify a subset of field values programmatically, this can be achieved by
    // copying the existing set of criteria and adding other changes - something
    // like this:
    // <smartclient>
    // <pre><code>
    //   var newCriteria = myListGrid.getFilterEditorCriteria();
    //   isc.DataSource.combineCriteria(newCriteria, {
    //      field1:"new value1",
    //      field2:"new value2"
    //   });
    //   myListGrid.setCriteria(newCriteria);
    // </code></pre>
    // </smartclient>
    // <smartgwt>
    // <pre><code>
    //   Criteria newCriteria = myListGrid.getFilterEditorCriteria();
    //   newCriteria = DataSource.combineCriteria(newCriteria,
    //      new Criteria("field1", "new value1")
    //   );
    //   myListGrid.setCriteria(newCriteria);
    // </code></pre>
    // </smartgwt>
    // In this example code we're using +link{listGrid.getFilterEditorCriteria()} rather than
    // +link{listGrid.getCriteria()} - this ensures that if the user has typed a new value into
    // the filter editor, but not yet clicked the filter button, we pick up the value the user
    // entered.  This sample code uses +link{dataSource.combineCriteria()} to combine the
    // existing filterEditorCriteria with some new custom criteria.  This technique is
    // applicable to both simple and advanced criteria.
    // <P>
    // If you call <code>filterData()</code> and pass in criteria for dataSource
    // fields that are not present in the ListGrid, these criteria will continue to be applied
    // along with the user-visible criteria.
    // <P>
    // <b>filterEditor and advanced criteria</b>: If a developer calls <code>filterData()</code>
    // on a ListGrid and passes in +link{AdvancedCriteria}, expected behavior of the filter
    // editor becomes ambiguous, since AdvancedCriteria has far more complex filter
    // expression support than the ordinary filterEditor can represent.
    // <P>
    // Default behavior for AdvancedCriteria will combine the AdvancedCriteria with the values
    // in the filter editor as follows:
    // <ul>
    // <li>If the top level criteria has operator of type "and":<br>
    //  Each field in the top level
    //  criteria array for which a 'canFilter' true field is shown in the listGrid will show up
    //  if the specified operator matches the default filter behavior
    //  (based on the +link{listGrid.autoFetchTextMatchStyle}).<br>
    //  If the user enters values in the filter editor, these will be combined with the
    //  existing AdvancedCriteria by either replacing or adding field level criteria at the top
    //  level.</li>
    // <li>If the top level criteria is a single field-criteria:<br>
    //  If the field shows up in the listGrid and is canFilter:true, it will be displayed to
    //  the user (if the operator matches the default filter behavior for the field).<br>
    //  If the user enters new filter criteria in the filterEditor, they will be combined with
    //  this existing criterion via a top level "and" operator, or if the user modifies the
    //  field for which the criterion already existed, it will be replaced.</li>
    // <li>Otherwise, if there are multiple top level criteria combined with an "or" operator,
    //  these will not be shown in the filter editor. Any filter parameters the user enters will
    //  be added to the existing criteria via an additional top level "and" operator, meaning
    //  the user will essentially filter a subset of the existing criteria</li>
    // </ul>
    //  @group filterEditor
    //  @visibility external
    //  @example filter
    //<
    
    // showFilterEditor:false

    //> @attr listGrid.canShowFilterEditor (boolean : true : IRW)
    // Should a menu item allowing the user to show or hide the 
    // +link{listGrid.showFilterEditor,filter editor} be displayed in 
    // the +link{listGrid.headerContextMenu, headerContextmenu}?
    // <P>
    // Note that if this ListGrid is not +link{listGrid.dataSource,bound to a dataSource} 
    // it can not be filtered. In this case the context menu
    // option to show the filterEditor will not be displayed even if 
    // <code>canShowFilterEditor</code> is true.
    // <p>
    // Enabling +link{filterViaAIMode,filter via AI} forces this setting to true.
    //
    // @group filterEditor
    // @see showFilterEditorTitle
    // @see hideFilterEditorTitle
    // @visibility external
    // @example filter
    //<
    canShowFilterEditor: true,
    // Suppress the 'showFilterEditor' menu item unless the grid is actually filterable
    _canShowFilterEditor : function () {
        if (this.shouldAllowFilterViaAI()) return true;
        if (!this.canShowFilterEditor) return false;

        
        if (this.getDataSource() == null) return false;
        var hasFilterableField = false;
        var fields = this.getFields();
        if (fields != null) {
            for (var i = 0; i < fields.length; i++) {
                if (fields[i].canFilter != false) {
                    hasFilterableField = true;
                    break;
                }
            }
        }
        return hasFilterableField;
    },

    //> @attr listGrid.showFilterEditorTitle (String : "Show Filter Row" : IRW)
    // When +link{listGrid.canShowFilterEditor, canShowFilterEditor} is true, this is the title
    // for the filterEditor show/hide menu-item, in the 
    // +link{listGrid.headerContextMenu, headerContextmenu}, when the filterEditor is hidden.
    // <P>
    // +link{listGrid.hideFilterEditorTitle, hideFilterEditorTitle} affects the same menu-item
    // when the filterEditor is visible.
    // @group filterEditor, i18nMessages
    // @visibility external
    // @example filter
    //<
    showFilterEditorTitle: "Show Filter Row",
    
    //> @attr listGrid.hideFilterEditorTitle (String : "Hide Filter Row" : IRW)
    // When +link{listGrid.canShowFilterEditor, canShowFilterEditor} is true, this is the title
    // for the filterEditor show/hide menu-item, in the 
    // +link{listGrid.headerContextMenu, headerContextmenu}, when the filterEditor is visible.
    // <P>
    // +link{listGrid.showFilterEditorTitle, showFilterEditorTitle} affects the same menu-item
    // when the filterEditor is hidden.
    // @group filterEditor, i18nMessages
    // @visibility external
    // @example filter
    //<
    hideFilterEditorTitle: "Hide Filter Row",

    //> @attr listGrid.filterEditor (RecordEditor AutoChild : null : R)
    // If +link{listGrid.showFilterEditor} is set to true, the <code>filterEditor</code>
    // is automatically created as an AutoChild.
    // <P>
    // The filterEditor autoChild is a +link{RecordEditor} - essentially it is a specialized listGrid
    // in edit mode for editing a single set of values to be used as criteria. Once created, 
    // developers may access it and use standard listGrid APIs to interact with it.
    // For example, given a listGrid <i><code>myListGrid</code></i>,
    // live edit items could be accessed via<br>
    // <smartclient>
    // <code>
    // myListGrid.filterEditor.getEditFormItem(someFieldName);
    // </code>
    // </smartclient>
    // <smartgwt>
    // <code>
    // myListGrid.getFilterEditor().getEditFormItem(someFieldName);
    // </code>
    // </smartgwt>
    // <P>
    // Developers may configure the AutoChild using +link{filterEditorProperties}.
    //
    // @group filterEditor
    // @see filterEditorSubmit
    // @see filterOnKeypress
    // @see filterByCell
    // @visibility external
    //<

    //> @attr listGrid.filterEditorProperties (RecordEditor Properties : null : IR)
    // Properties to apply to the automatically generated +link{listGrid.filterEditor}
    // if +link{listGrid.showFilterEditor} is true.
    // @visibility external
    //<
    filterEditorDefaults : { 
        shouldPrint:false,
        // dataContext should not be auto-populated on the filter editor
        autoPopulateData:false,
        headerRadius: null
    },

    //> @attr listGrid.filterButtonProperties (Button Properties : null : IR)
    // If +link{listGrid.showFilterEditor} is true, this attribute may be used to customize the
    // filter button shown to the right of the filterEditor row.
    // @visibility external
    //<

    //> @attr listGrid.filterEditorHeight (number : 22 : IRW)
    // Height for the filterEditor, if shown.
    //
    //  @group filterEditor
    //  @visibility external
    //<
    filterEditorHeight:22,

    //> @attr listGrid.clearCriteriaOnFilterEditorHide (boolean : true : IR)
    // When set to false, this attribute prevents user-criteria in the 
    // +link{listGrid.filterEditor, filterEditor} from being cleared when the user hides it.
    // @group filterEditor
    // @visibility external
    //<
    clearCriteriaOnFilterEditorHide: true,

    //> @attr listGrid.autoFetchAsFilter (boolean : null : IR)
    // Determines whether +link{filterData()} or +link{fetchData()} should be called when this
    // grid is initially filtered via +link{autoFetchData}, or filtered by the user via the
    // +link{showFilterEditor,filterEditor}.
    // @group databinding
    // @deprecated in favor of listGrid.autoFetchTextMatchStyle
    //<
    // Note: This was exposed in the 7.0 release candidate builds only.
    // Leaving supported (deprecated) but not publicly documented
    // If set, at init time, it will set textMatchStyle to exact or substring (handled in Canvas.js)

    //> @attr listGrid.autoFetchTextMatchStyle (TextMatchStyle : "substring" : IR)
    // When this grid is initially filtered via +link{autoFetchData}, or filtered by the user
    // via the +link{showFilterEditor,filterEditor}, this attribute can be used to set the
    // <code>textMatchStyle</code> on the dsRequest passed to <code>fetchData()</code>.
    // <P>
    // To use a mixture of textMatchStyles, set an appropriate
    // +link{formItem.operator, operator} on a field's
    // +link{listGridField.filterEditorProperties, filterEditorProperties}.
    // @group databinding
    // @visibility external
    //<
    // implemented in canvas.getInitialFetchContext() and recordEditor.performAction()
    autoFetchTextMatchStyle:"substring",

    
// Filter Operators

//> @attr listGrid.allowFilterOperators (Boolean : null : IR)
// Causes a menu item titled +link{filterUsingText,"Filter using"} to appear in the
// +link{showHeaderContextMenu,headerContextMenu} that allows the end user to pick an advanced
// +link{type:OperatorId,search operator} to use for this field.
// <p>
// Once an operator has been chosen, the active operator is indicated by an
// +link{operatorIcon} placed within the field (you can alternatively cause the
// icon to +link{alwaysShowOperatorIcon,always be present}).  The <code>operatorIcon</code> 
// shows the same textual representation of the search operator as is used by the
// +link{formItem.allowExpressions} feature.  Clicking on the icon provides a second way to 
// modify the search operator.  
// <p>
// This feature is enabled by default if +link{dataSource.supportsAdvancedCriteria()} is true, 
// for all fields where it is normally possible to filter by typing in a search string.  This 
// excludes field types such as "date" or "boolean" which show specialized filter controls.  
// Use +link{listGridField.allowFilterOperators} to disable this interface for individual 
// fields, or set +link{dataSourceField.canFilter} to false to disallow filtering entirely for 
// a field.
// <p>
// Note that this feature is similar to +link{listGrid.allowFilterExpressions}, which allows 
// the end users to directly type in characters such as "&gt;" to control filtering.
// <code>allowFilterOperators</code> is easier to use and more discoverable than
// <code>allowFilterExpressions</code>, and also avoids the drawback where special characters 
// like "&gt;" cannot be used in filter values.  However, <code>allowFilterExpressions</code> 
// allows users to make use of certain operators that <code>allowFilterOperators</code> does 
// not support, such as using the "betweenInclusive" operator by typing "5...10".
// <P>
// When both <code>allowfilterExpressions</code> and <code>allowFilterOperators</code> are set,
// filter expressions entered in to the edit-area are parsed and the operator automatically 
// applied to the +link{operatorIcon}.
// <P>
// If +link{allowFilterWindow} is enabled another option,
// +link{advancedFilteringText,"Advanced Filtering"}, is added to the "Filter using" menu.
//
// @see allowFilterWindow
// @visibility external
//<

// the default value of allowFilterOperators is null, on both ListGrid and ListGridField - at
// runtime, calculate an appropriate value for it, first checking the field, then the grid,
// and finally allowing filterOperators if the DS supports advancedCriteria
shouldAllowFilterOperators : function (field) {
    if (this.allowFilterOperators == false ||
        (this.filterViaAIMode != null && !this.canShowFilterEditor))
    {
        return false;
    }
    
    if (!this.dataSource) return false;
    if (field) {
        if (isc.isA.String(field)) field = this.getFieldByName(field);
        if (!field) {
            // there's no field matching the fieldName we were passed
        } else {
            var editorClass = isc.FormItemFactory.getItemClass(this.getFilterEditorType(field));
            // no support for operators in non-TextItem fields
            if (!isc.isA.TextItem(editorClass)) return false;
            // support an undocumented flag, SimpleType.allowFilterOperators - if this is false,
            // return false - for now, deal with date and boolean here as well
            var type = field._simpleType,
                ST = isc.SimpleType
            ;
            if (type) {
                if (ST.inheritsFrom(type.type, "date") || ST.inheritsFrom(type.type, "datetime") ||
                    ST.inheritsFrom(type.type, "boolean")) return false;
                if (type.allowFilterOperators == false) return false;
            }

            // if the field specifies canFilter:false, return false
            if (field.canFilter == false) return false;
            // if the field specifies a value for allowFilterOperators, return it
            if (field.allowFilterOperators != null) return field.allowFilterOperators;
        }
    }
    // if the grid specifies canFilter:false, return false
    if (this.canFilter == false) return false;
    // if the grid specifies a value for allowFilterOperators, return it
    if (this.allowFilterOperators != null) return this.allowFilterOperators;
    // if there's a DS, return the result of supportsAdvancedCriteria()
    var ds = this.getDataSource();
    if (ds) return ds.supportsAdvancedCriteria();
    // otherwise, return false
    return false;
},

//> @attr listGrid.alwaysShowOperatorIcon (Boolean : null : IR)
// When +link{allowFilterOperators} is enabled, whether to show the +link{operatorIcon} for all
// filterable fields, or only for fields where the user has explicitly chosen a search operator
// different from the default operator for the field.
// <p>
// The default operator for a field is determined by +link{autoFetchTextMatchStyle} or by
// setting +link{listGridField.filterOperator} for a specific field.
// @visibility external
//<

shouldAlwaysShowOperatorIcon : function (field, item) {
    if (field) {
        if (isc.isA.String(field)) field = this.getFieldByName(field);
        if (field && field.alwaysShowOperatorIcon != null) return field.alwaysShowOperatorIcon;
        var filterEditor = this.getFilterEditor();
        if (!item && filterEditor) item = filterEditor.editor.getEditForm().getItem(field.name)
        if (item && item.alwaysShowOperatorIcon != null) return item.alwaysShowOperatorIcon;
    }
    if (this.alwaysShowOperatorIcon != null) return this.alwaysShowOperatorIcon;
    return false;
},

//> @attr listGrid.operatorIcon (MultiAutoChild FormItemIcon : null : I)
// Inline icon shown inside +link{listGrid.showFilterEditor,filter editor} fields when
// +link{allowFilterOperators} is enabled.
// @visibility external
//<

//> @attr listGrid.filterUsingText (String : "Filter using" : IR)
// Text for the menu item shown in the +link{showHeaderContextMenu,headerContextMenu} when
// +link{allowFilterOperators} is enabled.
// @group i18nMessages
// @visibility external
//<
filterUsingText: "Filter using",

//> @attr listGrid.defaultFilterOperatorSuffix (String : "(default)" : IR)
// Text to show after the name of the default filterOperator in the 
// +link{showHeaderContextMenu,headerContextMenu} when +link{allowFilterOperators} is enabled.
// @group i18nMessages
// @visibility external
//<
defaultFilterOperatorSuffix: "(default)",

// and some APis on ListGridField

//> @attr listGridField.allowFilterOperators (Boolean : null : IR)
// Per-field setting for +link{listGrid.allowFilterOperators}.  Can be used to enable
// the filter operators UI for a particular field if the ListGrid-level setting is not
// enabled, or to disable filter operators for a particular field if the ListGrid-level setting
// is enabled.
// <p>
// For a discussion of the various filtering and criteria-management APIs and when to use
// them, see the +link{group:gridFiltering, Grid Filtering overview}.
// @visibility external
//<

//> @attr listGridField.allowFilterExpressions (boolean : null : IR)
// Field-level setting for +link{listGrid.allowFilterExpressions}:true - controls whether search 
// expressions can be entered directly into the filter item for this field.  You can also have
// parsing of the expression remove the operator symbol and apply it to an 
// +link{listGrid.allowFilterOperators, icon} in the editor.,
// <P>
// This attribute can also be set at the +link{listGrid.allowFilterExpressions, ListGrid level}.
// <p>
// For a discussion of the various filtering and criteria-management APIs and when to use
// them, see the +link{group:gridFiltering, Grid Filtering overview}.
// @group advancedFilter
// @visibility external
//<

//> @attr listGridField.alwaysShowOperatorIcon (Boolean : null : IR)
// Per-field setting for +link{ListGrid.alwaysShowOperatorIcon}. Can be used to force a particular
// field to always show it's +link{ListGrid.operatorIcon, operatorIcon}, even if it has no 
// filter-value, or is using the default +link{listGridField.filterOperator, search operator}.
// <p>
// For a discussion of the various filtering and criteria-management APIs and when to use
// them, see the +link{group:gridFiltering, Grid Filtering overview}.
// @visibility external
//<

//> @attr listGridField.filterOperator (OperatorId : null : IR)
// With the +link{listGrid.showFilterEditor,FilterEditor} showing, the default +link{Operator} 
// to use when matching values for this field.
// <p>
// For a discussion of the various filtering and criteria-management APIs and when to use
// them, see the +link{group:gridFiltering, Grid Filtering overview}.
// <P>
// Users can override this default operator, or revert to it, with the 
// +link{listGrid.filterUsingText, "Filter using"} submenu, in the grid's 
// +link{listGrid.showHeaderContextMenu, headerContextMenu}; developers can use 
// +link{listGrid.setFieldSearchOperator} to modify the operator and 
// +link{listGrid.clearFieldSearchOperator} to reset to the default.
// <p>
// Note that you can set all FilterEditor fields to default to either substring or exact
// match via +link{listGrid.autoFetchTextMatchStyle,autoFetchTextMatchStyle}, but if you 
// want a mix of exact vs substring match on different fields, you need to use this 
// property, and your ListGrid will produce +link{AdvancedCriteria} rather than the 
// simpler +link{Criteria} format.  This is automatically and transparently handled by the 
// SmartClient Server's SQLDataSource and HibernateDataSource in Power Edition or above, 
// but if you have your own filtering implementation, it will need to be able to handle 
// AdvancedCriteria.
// @see listGridField.operator
// @visibility external
//<


	// Editing
	// --------------------------------------------------------------------------------------------
	//> @attr listGrid.canEdit (Boolean : null : [IRW])
	//      Can the user edit cells in this listGrid? Can be set for the listGrid, and overridden for
	//      individual fields.<br>
	//      If 'canEdit' is false at the listGrid level, fields can never be edited - in this case
	//      the canEdit property on individual fields will be ignored.<br>
	//      If 'canEdit' is set to true at the listGrid level, setting the 'canEdit' property to
	//      false at the field level will prevent the field from being edited inline unless a
	//      custom override of +link{canEditCell} allows it.<br>
	//      If 'canEdit' is not set at the listGrid level, setting 'canEdit' to true at the field
    //      level enables the field to be edited inline.
    //      <P>
    //      For more information on editing, see the +link{group:editing,editing overview}.
    //
	//      @visibility external
	//      @group  editing
	//      @see    startEditing()
    //      @see listGridField.canEdit
    //      @see listGrid.recordEditProperty
    //      @see listGrid.canEditCell()
	//      @see    fields
    //      @example editByRow
	//<
	//canEdit:null,

    //> @attr listGrid.canEditNew (Boolean : null : [IRW])
    //  Can the user add new rows?
    //  @group  editing
    //  @see attr:listGrid.canEdit
    //  @see attr:listGrid.recordEditProperty
    //  @visibility internal
    //<
    canEditNew: false,

    //> @attr listGrid.recordEditProperty (String : "_canEdit" : [IRWA])
    // Property name on a record that should be checked to determine whether the record may be
    // edited.
    // <br>
    // This property is configurable to avoid possible collision with data values in record.
    // With the default setting of "_canEdit", a record can be set non-editable by ensuring
    // record._canEdit == false.
    // <br>
    // For controlling editability for the entire grid or for a field, set grid.canEdit or
    // field.canEdit.
    //
    //  @group  editing
    //  @see attr:listGrid.canEdit
    //  @see attr:listGridField.canEdit
    //  @see method:listGrid.canEditCell
    //  @visibility external
    //<
    recordEditProperty:"_canEdit",

    //> @attr listGridRecord._canEdit (boolean : null : IR)
    //
    // Default property name denoting whether this record can be edited. Property name may be
    // modified for the grid via +link{listGrid.recordEditProperty}.
    //
    // @group  editing
    // @visibility external
    //<

    // Name for property used by internal '_testRowEditData' method to track whether
    // records have been compared to edit-data in order to map rowNums to edit values.
    // Customizable, in case of collision with record data - but unlikely to be overridden.
    editValuesTestedProperty:"_editValuesTested",

    //> @attr listGrid.alwaysShowEditors (boolean : null : [IRA])
    // When this attribute is set, editors will be appear to be present in every row of the 
    // grid, allowing the user to immediately start editing any cell, rather than showing 
    // up in a single record at a time.<br>
    // This attribute is only valid when +link{listGrid.editByCell} is false.
    // <P>
    // This setting has some limitations and is typically only used for simple grids with 
    // a limited set of fields and standard editors.
    // <ul>
    // <li>Not all formItem types are supported. Default editors for standard data types 
    //  (text, boolean, date, datetime, integer and float) are all supported, but custom
    //   editorType, including CanvasItem based editors are not. Fields with an unsupported
    //   editor type will show static values for all rows other than the current edit row, though
    //   users can start editing these with a single click</li> 
    // <li><code>alwaysShowEditors:true</code> grids do not support showing different
    //   editor types for the same field in different rows</li>
    // <li>In some cases there may be visual differences between the editor displayed in the
    //   edit row and the editor displayed in other rows.</li>
    // <li>From a design perspective, this mode presents a very "busy-looking" UI,
    //     which can made it harder to read the actual data. Functionally having 
    //     +link{listGrid.editEvent} set to "click" provides the same single-click to edit
    //     any cell user experience without the busy UI.</li>
    // <li>In some cases there may be a performance penalty for writing out so many controls
    //     (editors for every cell of the grid).</li>
    // </ul>
    // Note that in addition to alwaysShowEditors, listGrid support single-click editing
    // via +link{listGrid.editEvent,editEvent:"click"}, and, for boolean fields, 
    // +link{listGridField.canToggle}
    //
    // @group editing
    // @visibility external
    //<
    

    //> @attr listGrid.editByCell (boolean : null : [IRW])
    // Determines whether when the user edits a cell in this listGrid the entire row becomes
    // editable, or just the cell that received the edit event.
    // <P>
    // No effect if this.canEdit is false or null.
    //
    // @group editing
    // @see listGrid.canEdit
    // @example editByCell
    // @visibility external
    //<

    //> @attr listGrid.saveByCell (boolean : null : [IRW])
    // Whether edits should be saved whenever the user moves between cells in the current edit
    // row.
    // <P>
    // If unset, defaults to +link{editByCell,this.editByCell}.
    // <P>
    // To avoid automatic saving entirely, set +link{autoSaveEdits}:false.
    //
    //  @group  editing
    //  @visibility external
    //  @see listGrid.editByCell
    //<

    //> @attr listGrid.validateByCell (boolean : null : [IRW])
    // Whether client-side validation checks should be performed when the user moves between
    // cells in the current edit row.  If unset, defaults to +link{listGrid.editByCell}.
    // <P>
    // Note that validation always occurs when a row is to be saved, so setting
    // +link{saveByCell}:true forces validation on cell transitions.  To completely disable
    // automatic validation, set +link{neverValidate}:true.
    //
    // @group gridValidation
    // @visibility external
    // @see group:editing
    //<
    

    // autoValidate will disable validation on row-transitions, so validation will only
    // occur on save attempts.  Not currently exposed.
    autoValidate:true,

    //> @attr listGrid.validateOnChange (boolean : null : [IRW])
    // If true, validation will be performed on each edited cell when each editor's
    // "change" handler is fired.
    //
    // @see ListGridField.validateOnChange
    // @group gridValidation
    // @visibility external
    //<
    //validateOnChange:null

    //> @attr listGrid.neverValidate (boolean : null : [IRWA])
    // If true, validation will not occur as a result of cell editing for this grid.
    //  @group  gridValidation
    // @visibility external
    //<
    //neverValidate:null,


    //> @attr listGrid.canRemoveRecords (Boolean : false : IRW)
    // If set, provide UI for the user to remove records from the grid as an additional field
    // showing the +link{listGrid.removeIcon}, which, when clicked, will call
    // +link{listGrid.removeRecordClick()} which removes the row from the data set (or if
    // +link{deferRemoval} is true changes the +link{listGrid.markRecordRemoved()} status
    // for the record). Individual records can be marked to prevent removal - see
    // +link{listGrid.recordCanRemoveProperty}.
    // <P>
    // To add a confirmation dialog before a record is removed, set
    // +link{listGrid.warnOnRemoval}.
    // <P>
    // If deferring removal, the record will appear marked with the +link{removedCSSText}
    // until the removal is committed via a call to +link{saveEdits()}.
    // Otherwise, the record will disappear from view. If +link{listGrid.animateRemoveRecord}
    // is true, the removed record will appear to shrink out of view when it is removed.
    // <P>
    // By default the field will display the +link{listGrid.removeIcon} next to each record, and
    // will be rendered as the rightmost column. Two mechanisms exist to further modify this field:
    // <ul>
    // <li>To change the position of the remove-field, include an explicitly specified field with
    //     the attribute +link{listGridField.isRemoveField,isRemoveField:true} set. This will then
    //     be used as the remove field instead of adding a field to the beginning of the set of
    //     columns.</li>
    // <li>Additional direct configuration of the remove field may be achieved by modifying
    //     +link{listGrid.removeFieldProperties}.</li>
    // </ul>
    // If +link{deferRemoval} is true, when a record is marked as removed, the the icon will
    // change to display the +link{listGrid.unremoveIcon} for this row. Clicking on this icon
    // will call +link{listGrid.unmarkRecordRemoved()} to mark the record as no longer pending
    // deletion.
    // @group editing
    // @visibility external
    //<

    //> @attr listGrid.warnOnRemoval (Boolean : false : IRW)
    // If +link{listGrid.canRemoveRecords} is true, when the user clicks the remove icon
    // for some record, should we show a warning message
    // (defined as +link{listGrid.warnOnRemovalMessage}) and allow the user to cancel removal?
    // @visibility external
    //<
    warnOnRemoval:false,
    //> @attr listGrid.warnOnRemovalMessage (String : "Are you sure you want to delete this record?" : IRW)
    // Warning message to show the user on a click on the 'remove' icon
    // if +link{listGrid.canRemoveRecords} is true and
    // +link{listGrid.warnOnRemoval} is true.
    // @visibility external
    // @group i18nMessages
    //<
    warnOnRemovalMessage:"Are you sure you want to delete this record?",

    shouldShowRemoveField : function () {
        if (this.fieldSourceGrid != null) return this.fieldSourceGrid.shouldShowRemoveField();
        return this.canRemoveRecords;
    },

    //> @attr listGrid.recordRemovedProperty (String : "_removed" : IR)
    // Property name used as an edit-value on a record that has been marked for removal via
    // +link{listGrid.markRecordRemoved()}.
    //
    // @see listGridRecord.removed
    // @visibility internal
    //<
    // This property is internal - the "_removed" flag is obfuscated and unlikely to collide
    // with real world data but could be configured to be something different if this became an issue.
    recordRemovedProperty: "_removed",

    //> @method listGrid.markRecordRemoved()
    // Marks a record deleted such that a later call to +link{saveEdits()} or +link{saveAllEdits()}
    // will cause a "remove" +link{DSRequest} to be submitted.
    // <P>
    // A removed record is disabled and non-editable, and uses +link{removedCSSText} for its CSS
    // style, which by default will show strikethrough text.
    // <P>
    // Contrast this method with removeSelectedData(), which immediately submits a DSRequest to
    // remove the selected records from the dataset.
    // <P>
    // Records that have been marked for removal using this method may be 'unmarked' via a call to
    // +link{listGrid.unmarkRecordRemoved()}, or by discarding edit values (+link{discardEdits()}).
    //
    // @param rowNum (number) row number for the record to mark
    //
    // @group editing
    // @visibility external
    //<
    markRecordRemoved : function (rowNum, suppressRefresh) {
        if (!isc.isA.Number(rowNum)) rowNum = this.findRowNum(rowNum);
        // hide the edit form if we're mid-edit.
        if (this.getEditRow() == rowNum) this.hideInlineEditor();
        // deselect if we're selected.
        this.deselectRecord(rowNum);

        this.setEditValue(rowNum, this.recordRemovedProperty, /* newValue */ true,
                          /* suppressDisplay */ suppressRefresh,
                          /* suppressChange */ false,
                          /* suppressSummaryRecalc */ suppressRefresh);
        if (!suppressRefresh) this.refreshRow(rowNum);
    },

    //> @method listGrid.markRecordsRemoved()
    // Marks an array of records deleted such that a later call to +link{saveEdits()} or 
    // +link{saveAllEdits()} will cause a "remove" +link{DSRequest} to be submitted.
    // <P>
    // This method is similar to +link{listGrid.markRecordRemoved} but should be more efficient
    // in avoiding unneeded duplicate refreshes due to the multiple records getting marked.
    //
    // @param records (Array of ListGridRecord | number) records or indices to mark removed
    //   
    // @see listGrid.markRecordRemoved
    // @group editing
    // @visibility external
    //<
    markRecordsRemoved : function (records) {
        if (records == null) return;
        if (!isc.isAn.Array(records)) records = [records];
        for (var i = 0; i < records.length; i++) {
            this.markRecordRemoved(records[i], true);
        }
    },

    //> @method listGrid.recordMarkedAsRemoved()
    // Returns true if the specified record is marked as removed via a call to
    // +link{markRecordRemoved()}
    // @param rowNum (int) index of row to verify
    // @return (Boolean) true if the specified record has been marked for removal
    // @visibility external
    // @group editing
    //<
    recordMarkedAsRemoved : function (rowNum) {
        if (rowNum == null) return false;
        if (!isc.isA.Number(rowNum)) {
            
            rowNum = this.getEditSessionRowNum(rowNum);
            if (rowNum == null) return false;
        }
        return (this.getEditValue(rowNum, this.recordRemovedProperty) == true);
    },

    //> @method listGrid.unmarkRecordRemoved()
    // Reverses a previous call to +link{markRecordRemoved()}.
    // <P>
    // Note that a record that is marked for removal and then un-marked retains any uncommitted
    // edits from before it was marked for removal.  These can be discarded with
    // +link{discardEdits()}.
    // @param rowNum (int) index of record to clear the 'removed'
    // @group editing
    // @visibility external
    //<
    unmarkRecordRemoved : function (rowNum, suppressRefresh) {
        if (!isc.isA.Number(rowNum)) rowNum = this.findRowNum(rowNum);
        this.clearEditValue(rowNum, this.recordRemovedProperty);
        if (!suppressRefresh) this.refreshRow(rowNum);
    },

    

    //> @attr listGrid.removedCSSText (String : "text-decoration:line-through;" : [IRWA])
    //  Custom CSS text to be applied to records that have been
    // +link{listGrid.markRecordRemoved(),marked for removal}.
    // <P>
    // This CSS text will be applied on top of standard disabled styling for the cell.
    //
    // @visibility external
    // @group   appearance
    //<
    removedCSSText:"text-decoration:line-through;",

    //> @method listGrid.markSelectionRemoved()
    // Marks the currently selected records as removed, as though +link{markRecordRemoved()} had
    // been called.
    //
    // @group editing
    // @visibility external
    //<
    markSelectionRemoved : function () {
        var records = this.getSelectedRecords(),
            recordsLength = records.length;
        for (var i = 0; i < recordsLength; ++i) {
            // We can pass the record object into markRecordRemoved even though it's doc'd
            // as taking just rowNum
            this.markRecordRemoved(records[i], true);
        }
        this.markForRedraw();
    },

    //> @attr listGrid.deferRemoval (boolean : null : IR)
    // When enabled, the field shown by +link{listGrid.canRemoveRecords} causes records to be
    // marked for future removal via +link{markRecordRemoved()} instead of immediately being
    // removed.
    // <P>
    // When a record has been marked for removal, an icon in the
    // <code>canRemoveRecords</code> field allowing it to be unmarked will be displayed.
    // <P>
    // If not explicitly specified by this property, removal of records will be deferred if
    // +link{autoSaveEdits} is false for the grid.
    // @group editing
    // @visibility external
    //<

    shouldDeferRemoval : function () {
        if (this.deferRemoval != null) return this.deferRemoval;
        return !this.autoSaveEdits;
    },

    //> @attr listGrid.removeIcon (SCImgURL : "[SKIN]/actions/remove.png" : IR)
    // When +link{ListGrid.canRemoveRecords} is enabled, default icon to show in
    // the auto-generated field that allows removing records.
    // @visibility external
    //<
    removeIcon:"[SKIN]/actions/remove.png",

    //> @attr listGrid.unremoveIcon (SCImgURL : "[SKIN]/actions/undo.png" : IR)
    // When +link{ListGrid.canRemoveRecords} is enabled, this icon will be shown in the
    // auto generated field fro removing records if the record has been marked as removed via
    // +link{listGrid.markRecordRemoved()}. At this point, clicking on the icon will
    // unmark the record as removed.
    // @visibility external
    //<
    unremoveIcon:"[SKIN]/actions/undo.png",

    //> @attr listGrid.removeIconSize (Number : 16 : IRW)
    // Default width and height of +link{removeIcon,remove icons} for this ListGrid.
    //
    // @visibility external
    //<
    removeIconSize: 16,

    //> @attr listGrid.removeIconStyle (CSSStyleName : null : [IRW])
    // Custom style to apply to the image in the +link{removeFieldProperties, removeField} 
    // displayed in rows when +link{listGrid.canRemoveRecords} is true.  Affects the icons 
    // provided by +link{removeIcon} and +link{unremoveIcon}.
    // @group appearance
    // @visibility external
    //<

    //> @attr listGrid.animateRemoveRecord (Boolean : true : IRW)
    // When +link{ListGrid.canRemoveRecords} is enabled, should records be animated out of view
    // when they are removed by the user?
    // @visibility external
    //<
    // When showing alternate records styles, the styles will essentially be reassigned after the
    // animation completes which means we finish our smooth animation with what looks a little like
    // a jump - not clear how to avoid this, but we could warn about this in the attribute
    // description.
    animateRemoveRecord:true,

    //> @attr listGrid.animateRemoveTime (number : 100 : IRW)
    // When animating record removal
    // +link{listGrid.animateRemoveRecord,(see animateRemoveRecord)}, if
    // +link{listGrid.animateRemoveSpeed} is not
    // set, this property designates the duration of the animation in ms.
    // @group animation
    // @visibility animation
    // @see listGrid.animateRemoveRecord
    //<
    animateRemoveTime:100,

    //> @attr listGrid.animateRemoveSpeed (number : 200 : IRW)
    // When +link{listGrid.animateRemoveRecord, animating record removal}, this property
    // designates the speed of the animation in pixels per second. Takes precedence over the
    // +link{listGrid.animateRemoveTime} property, which allows the developer to specify a
    // duration for the animation rather than a speed.
    // @group animation
    // @visibility animation
    // @see listGrid.animateRemoveRecord
    //<
    animateRemoveSpeed:200,

    //> @attr listGrid.removeFieldTitle (String : "&nbsp;" : IRWA)
    // The title to use for the +link{listGrid.removeFieldDefaults, remove field}.
    // <P>
    // By default this title is not displayed in the remove column header button as the
    // +link{listGrid.removeFieldDefaults} sets +link{listGridField.showTitle} to <code>false</code>.
    // @visibility external
    //<
    removeFieldTitle: isc.nbsp,

    //> @attr listGrid.removeFieldDefaults (ListGridField Properties : {...} : IR)
    // Default configuration properties for the "remove field"
    // displayed when +link{ListGrid.canRemoveRecords} is enabled.
    // +link{classMethod:class.changeDefaults()} should be used when modifying this object.
    // <P>
    // The default configuration includes a +link{listGridField.recordClick()} handler which
    // calls +link{listGrid.removeData()} to actually perform the data removal.
    // @visibility external
    //<
    removeFieldDefaults:{
        type:"icon",
        width:24,
        showDefaultContextMenu:false,
        selectCellTextOnClick:false,
        canEdit:false,
        canHide:false,
        canSort:false,
        canGroupBy:false,
        canFilter:false,
        showTitle:false,
        canExport: false,
        autoFitWidth: false,
        canDragResize: false,
        canAutoFitWidth: false,
        ignoreKeyboardClicks:true,
        showGridSummary: false,
        showGroupSummary: false,
        summaryValue: "&nbsp;",
        // disable this from ever being assigned as the treeField
        treeField:false,

        // flag that means this is a special builtin field, not for formulas/export/etc
        featureField: true

        // No need for a recordClick handler.
        // We explicitly override '_rowClick()' on the gridBody class to fire the removeRecordClick
        // event. This handles the case where the icon is marked for removal already, therefore
        // disabled, so we wouldn't get a field.recordClick notification.

        // In setFields() we override 'formatCellValue' to return the appropriate icon
        // (removeIcon / unremoveIcon).

    },

    //> @attr listGrid.removeFieldProperties (ListGridField Properties : null : IR)
    // Configuration properties for the "remove field" displayed when
    // +link{ListGrid.canRemoveRecords} is enabled.
    // <smartclient>These configuration settings will be overlaid
    // on top of the +link{listGrid.removeFieldDefaults}.</smartclient>
    // @visibility external
    //<

    //> @attr listGrid.filterByCell (boolean : true : [IRWA])
    // If we're showing the +link{listGrid.showFilterEditor,filterEditor}, should this list
    // be filtered every time the user changes edit values for particular cells rather than
    // waiting for an Enter keypress or a click on the filterEditor submit button.
    // <P>
    // Note that by default fields in the filter editor will be set to 
    // +link{formItem.changeOnKeypress,changeOnKeypress:false}, so the grid will not filter as
    // the user types in text-based items.<br>
    // To enable filtering as the user types in text fields, we recommend the 
    // +link{filterOnKeypress} attribute. Also note that <code>filterOnKeypress:true</code>
    // implies filtering will occur on change to edit values for cells, even if <code>filterByCell</code>
    // is not set to true.
    //
    // @group filterEditor
    // @see listGrid.fetchDelay
    // @visibility external
    //<
    filterByCell:true,

    setFilterByCell : function (filterByCell) {
        this.filterByCell = filterByCell;
        var filterEditor = this.getFilterEditor();
        if (filterEditor) filterEditor._applySourceWidgetFilterByCell();
    },

    //> @attr listGrid.filterOnKeypress (boolean : false : [IRW])
    // When this attribute is true and this component has been assigned a 
    // +link{listGrid.searchForm, searchForm} or is showing the 
    // +link{listGrid.showFilterEditor,filterEditor}, data will be filtered automatically as 
    // users change values in those components.
    // <P>
    // In the <code>filterEditor</code> case, this is equivalent to setting 
    // +link{formItem.changeOnKeypress} to true for each text-based field in the 
    // +link{listGridField.filterEditorProperties} when +link{filterByCell} is true.
    // <P>
    // @group filterEditor
    // @see listGrid.fetchDelay
    // @visibility external
    //<

    //> @attr listGrid.waitForSave (Boolean : false : [IRWA])
    // If this is an editable listGrid, this property determines whether the user will be
    // able to dismiss the edit form, or navigate to another cell while the save is in
    // process (before the asynchronous server response returns).
    //  @group  editing
    // @visibility external
    //<
    //waitForSave:false,

    //> @attr listGrid.stopOnErrors (Boolean : false : [IRWA])
    // If this is an editable listGrid, this property determines how failure to save due to
    // validation errors should be displayed to the user.
    // <P>
    // If this property is true, when validation errors occur the errors will be displayed
    // to the user in an alert, and focus will be returned to the first cell to fail validation.
    // <P>
    // If false, the cells that failed validation will be silently styled with the
    // editFailedBaseStyle.
    // <p>
    // <b>Note:</b> stopOnErrors being set to true implies that 'waitForSave' is also true.
    // We will not dismiss the editor until save has completed if stopOnErrors is true.
    //
    // @group editing
    // @see waitForSave
    // @visibility external
    //<
    //stopOnErrors:false,

    //> @attr listGrid.autoSaveEdits (Boolean : true : [IRW])
    // If this ListGrid is editable, should edits be saved out when the user finishes editing
    // a row (or a cell if +link{ListGrid.saveByCell} is true).
    // <P>
    // The default of <code>true</code> indicates that edits will be
    // +link{saveByCell,automatically saved} as the
    // user navigates through the grid and/or +link{enterKeyEditAction,hits 'Enter'} to end
    // editing.  See the +link{group:editing,Grid Editing} overview for details.
    // <P>
    // Setting <code>autoSaveEdits</code> false creates a "mass update" / "mass delete"
    // interaction where edits will be retained for all edited cells (across rows if
    // appropriate) until +link{saveEdits()} is called to save a particular row, or
    // +link{saveAllEdits()} is called to save all changes in a batch.
    // <P>
    // <b>Note:</b> when +link{listGrid.groupByField,listGrid grouping} is enabled, or when
    // working with hierarchical data in a +link{treeGrid}, users have the option to hide
    // records from view by collapsing the parent folder or group. This, in conjunction with
    // <code>autoSaveEdits</code> being set to <code>false</code> can lead to a case where
    // a user is unable to save edits due to validation errors on hidden rows. Therefore we
    // recommend developers consider having validators in place such that errors are caught
    // and displayed to the user on change or editor exit rather than being caught only when
    // saving is attempted. If it's not possible for all validation to be performed immediately 
    // on row exit, we recommend that a different UI design be used that does not involve
    // <code>autoSaveEdits</code> being set to <code>false</code>.
    //
    // @group editing
    // @visibility external
    //<
    autoSaveEdits:true,

    // ListGrid validation error icon. Very similar API to the FormItem class validation error
    // icon.

    //> @attr ListGrid.showErrorIcons (boolean : true : IRW)
    //  If this grid is editable, and an edit has caused validation failure for some cell,
    //  should we show an icon to indicate validation failure?
    //  @group  errorIcon
    //  @visibility external
    //<
    showErrorIcons : true,

    //> @attr ListGrid.errorIconHeight (Integer : 16 : IRW)
    //      Height of the error icon, if we're showing icons when validation errors occur.
    //  @group  errorIcon
    //  @visibility external
    //<
    errorIconHeight : 16,

    //> @attr ListGrid.errorIconWidth (Integer : 16 : IRW)
    //      Height of the error icon, if we're showing icons when validation errors occur.
    //  @group  errorIcon
    //  @visibility external
    //<
    errorIconWidth : 16,
    
    //> @attr ListGrid.errorIconSrc (SCImgURL : "[SKIN]/ListGrid/validation_error_icon.png" : IRW)
    //      Src of the image to show as an error icon, if we're showing icons when validation
    //      errors occur.
    //  @group  errorIcon
    //  @visibility external
    //<
    errorIconSrc : "[SKIN]/validation_error_icon.png",

    //> @attr listGrid.confirmCancelEditing (Boolean : false : [IRW])
    // If this is an editable listGrid, when the user attempts to cancel an edit, should we
    // display a confirmation prompt before discarding the edited values for the record?
    //
    //  @visibility external
    //  @group  editing
    //<
    //confirmCancelEditing:false,

    //> @attr listGrid.cancelEditingConfirmationMessage (String : Cancelling this edit will discard unsaved changes for this record. Continue? : [IRW])
    // If this is an editable listGrid, and <code>this.confirmCancelEditing</code> is true
    // this property is used as the message to display in the confirmation dismissal prompt.
    //
    //  @visibility external
    //  @group  editing, i18nMessages
    //<
    cancelEditingConfirmationMessage:"Cancelling this edit will discard unsaved changes for this record. Continue?",

    //> @attr listGrid.confirmDiscardEdits (Boolean : true : [IRW])
    // For editable listGrids, outstanding unsaved edits when the user performs a new filter
    // or sort will be discarded. This flag determines whether we should display a confirmation
    // dialog with options to save or discard the edits, or cancel the action in this case.
    //
    //  @visibility external
    //  @group  editing
    //<
    confirmDiscardEdits:true,

    //> @attr listGrid.autoConfirmSaveEdits (Boolean : false : [IRW])
    // For editable listGrids, outstanding unsaved edits when the user performs a new filter
    // or sort will be discarded by default. This flag determines whether we should save such
    // edits automatically in this case.  See also +link{listGrid.confirmDiscardEdits}, which 
    // allows the user to choose whether to save or discard the unsaved edits.
    //  @visibility external
    //  @group  editing
    //<
    autoConfirmSaveEdits:false,

    //> @attr listGrid.confirmDiscardEditsMessage (String : "This action will discard unsaved changes for this list.": [IRW])
    // If <code>this.confirmDiscardEdits</code> is true, this property can be used to customize the
    // error message string displayed to the user in a dialog with options to
    // cancel the action, or save or discard pending edits in response to sort/filter actions
    // that would otherwise drop unsaved edit values.
    // @visibility external
    // @group editing, i18nMessages
    //<
    confirmDiscardEditsMessage:"This action will discard all unsaved changes for this list.",

    //> @attr listGrid.discardEditsSaveButtonTitle (String :"Save" : IRW)
    // If +link{listGrid.confirmDiscardEdits} is true this is the title for the save button
    // appearing in the lost edits confirmation dialog. Override this for localization if necessary.
    // @visibility external
    // @group editing, i18nMessages
    //<
    discardEditsSaveButtonTitle:"Save",

    //> @attr listGrid.addNewBeforeEditing (boolean : false : IRWA)
    // When creating a new edit record via 'startEditingNew()' [or tabbing beyond the end
    // of the last editable field in a list], should we contact the server to create a
    // server-side record before editing begins?
    // @group   editing
    // @visibility advancedInlineEdit
    //<
    //addNewBeforeEditing:false,

    //> @attr listGrid.rowEndEditAction (RowEndEditAction : null : IRW)
    // If the user is editing a record in this listGrid, and attempts to navigate to a field
    // beyond the end of the row, via tab (or shift-tab off the first editable field), this
    // property determines what action to take:<ul>
    // <li>"next": start editing the next (or previous) record in the list
    // <li>"same": put focus back into the first editable field of the same record.
    // <li>"done": hide the editor
    // <li>"stop": leave focus in the cell being edited
    // <li>"none": no action
    // </ul>
    // @group editing
    // @visibility external
    //<
    //rowEndEditAction:"next",

    //> @attr listGrid.listEndEditAction (RowEndEditAction : null : IRW)
    // If the user is editing the last record in this listGrid, and attempts to navigate
    // beyond the last row either by tabbing off the last editable field, or using the down
    // arrow key, this property determines what action to take:<ul>
    // <li>"next": start editing a new record at the end of the list.
    // <li>"done": hide the editor
    // <li>"stop": leave focus in the cell being edited
    // <li>"none": no action
    // </ul>
    // <P>
    // See the +link{group:editing,Grid Editing overview} and also the
    // +link{group:unsavedRecords,Editing Unsaved Records overview} for context about how newly
    // added records behave.
    //
    // @group editing
    // @visibility external
    // @example enterNewRows
    //<
    
    //listEndEditAction:"stop",

    //> @attr listGrid.showNewRecordRow (boolean    : null  : [IRW])
    // If this is an editable ListGrid, setting this property to true causes an extra 
    // row with the +link{listGrid.newRecordRowMessage} to be displayed below the last record.
    // <P>
    // Clicking this row will start editing a new record at the end of the data set, as if
    // +link{listGrid.startEditingNew()} had been called.
    // <P>
    // Note that for +link{listGrid.dataSource,databound grids}, the new record row will
    // be suppressed if the grid has not +link{listGrid.fetchData(),fetched data}, unless
    // +link{listGrid.saveLocally} has been set.
    //
    // @visibility external
    //<

    //> @attr listGrid.newRecordRowMessage (String : "-- Add New Row --" : IR)
    // If this listGrid is showing the 'newRecordRow' (used for adding new rows to the end
    // of the data), this property determines what message should be displayed in this row.
    //
    // @group editing, i18nMessages
    // @visibility external
    //<
    newRecordRowMessage:"-- Add New Row --",

    shouldShowNewRecordRow : function () {
        return this.showNewRecordRow && 
                // If this.canEdit is false editing is disallowed (hide the row)
                // If true allow it
                // *if unset, it's ambiguous - we could loop through the fields looking
                //   for editable fields but we don't currently do this
                this.canEdit &&
                // If we're databound, suppress the row if we've never fetched
                // unless we're saving locally!
                (this.getDataSource() == null || this.shouldSaveLocally() ||
                    (isc.ResultSet && isc.isA.ResultSet(this.data))
                ); 
    },

    //> @attr listGrid.enterKeyEditAction (EnterKeyEditAction : "done" : IRW)
    // What to do when a user hits enter while editing a cell:
    // <ul>
    // <li>"nextCell": start editing the next editable cell in this record (or the first
    //     editable cell in the next record if focus is in the last editable cell in the row)
    // <li>"nextRow": start editing the same field in the next row (skipping any rows where
    //      that would be a non-editable cell.
    // <li>"nextRowStart": start editing the first editable cell in the next row.
    // <li>"done": hide the editor (editing is complete)
    // </ul>
    // Note that if this.autoSaveEdits is true, this may cause a save of the current edit values
    // @group   editing
    // @visibility external
    //<
    enterKeyEditAction:"done",

    //> @attr listGrid.escapeKeyEditAction (EscapeKeyEditAction : "cancel" : IRW)
    // What to do when a user hits escape while editing a cell:<ul>
    // <li>"cancel": close the editor and discard the current set of edit values
    // <li>"done": just close the editor (the edit is complete, but the edited values are retained).
    // </ul>
    // Note that if +link{autoSaveEdits} is true, this may cause a save of the current edit values
    // @group editing
    // @visibility external
    //<
    escapeKeyEditAction:"cancel",
    
    //> @attr   listGrid.arrowKeyEditAction (ArrowKeyEditAction : null : [IRW])
    // What to do when a user hits arrow key while editing a field?<br>
    // If not explicitly specified +link{listGrid.getArrowKeyEditAction()} 
    // will return an appropriate action depending on the field type.
    //
    //  @group  editing
    //  @visibility external
    //<
    


    //> @type ListGridEditEvent
    // Event that will trigger inline editing.
    //
    // @value "click"       A single mouse click triggers inline editing
    // @value "doubleClick" A double click triggers inline editing
    // @value "none"        No mouse event will trigger editing.  Editing must be
    //                      programmatically started via +link{listGrid.startEditing()}
    //                      (perhaps from an external button) or may be triggered by
    //                      keyboard navigation if +link{listGrid.editOnFocus} is set.
    //
    // @group editing
    // @visibility external
    //<

    //> @attr listGrid.editEvent (ListGridEditEvent : "doubleClick" : IRW)
    // Event that will trigger inline editing, see +link{type:ListGridEditEvent} for options.
    // <P>
    // Note this setting has no effect unless +link{canEdit} has been set to enable editing.
    // <P>
    // See also +link{editOnFocus} and +link{startEditing}.
    //
    // @group editing
    // @visibility external
    // @example editByRow
    //<
    editEvent:isc.EH.DOUBLE_CLICK,

    //> @attr listGrid.editOnFocus (boolean : null : [IRWA])
    // Should we start editing when this widget receives focus (if this ListGrid supports
    // editing)?
    // <P>
    // Note that this property being set to true will cause editing to occur on a single
    // click, even if +link{editEvent} is <code>"doubleClick"</code>, because single clicking
    // the grid will place keyboard focus there automatically.
    // <P>
    // If this property is set together with +link{listEndEditAction} being set to "next", 
    // users can create a new edit row in an empty grid by simply tabbing into the grid.
    //
    // @group editing
    // @visibility external
    //<
    // Note that +link{canFocusInEmptyGrid} must be set to <code>true</code> for this
    // to be supported.
    // Note - editOnFocus behavior is slightly more complicated than might be imagined. Actual
    // behavior:
    // - focus must go to the body (not the header) to start editing.
    // - if we are currently editing, getting focus will not trigger a new edit.
    // - if the focus is a result of clicking on the listGrid body, we will only start editing
    //   if the user clicked on an editable cell -- this is the same behavior as with
    //   editEvent:"click"
    // - otherwise when this widget receives focus, the first editable row will become editable.

    //> @attr listGrid.editOnF2Keypress (Boolean : true : [IRWA])
    // Should we start editing when the widget has focus and the user presses the "f2" key
    // (if this ListGrid supports editing)?
    // <P>
    // Note that if +link{listGrid.editEvent} is set to <code>"click"</code> or
    // <code>"doubleClick"</code>, the <code>Space</code> or <code>Enter</code> key may
    // also be used to start editing, depending on the value for +link{generateClickOnSpace},
    // +link{generateDoubleClickOnSpace}, +link{generateClickOnEnter} and
    // +link{generateDoubleClickOnEnter}.
    // <P>
    // If +link{listGrid.canEdit} is false, or +link{listGrid.editEvent} is set to "none" this
    // property has no effect.
    //
    // @group editing
    // @visibility external
    //<
    // Tested on:
    // FF 4.0.1 (Mac)
    // Chrome 11.0.696.77 (Mac)
    // Safari 5.0.5 (Mac)
    // IE 8 (XP)
    editOnF2Keypress:true,

    
    //> @attr listGrid.editOnKeyPress (boolean : null : [IRWA])
    // If set to true, when this grid has focus, if the user starts typing character keys
    // we'll start editing the focused cell.
    // @group editing
    // @visibility internal
    //<

    //> @attr listGrid.moveEditorOnArrow (boolean : null : [IRWA])
    // If +link{listGrid.editOnKeyPress, editOnKeyPress} is true, once the user starts editing
    // a cell by typing while focused in it, should left / right arrow keys cause the
    // edit cell to shift horizontally?
    // @group editing
    // @visibility internal
    //<
    

    //> @attr listGrid.selectOnEdit (Boolean : true : [IRWA])
    //  When the user starts editing a row, should the row also be selected?
    //  <P>
    //  See +link{listGrid.editSelectionType} for how edit-selection behaves.
    // @group editing
    // @visibility external
    //<
    selectOnEdit : true,

    //>@attr listGrid.editSelectionType (SelectionStyle : "single" : IRW)
    // If +link{listGrid.selectOnEdit} is true, what should be the edit-selection behavior
    // be?
    // <P>
    // Default setting of <code>"single"</code> will cause the edit row to be automatically
    // selected and any other selection in the grid to be dropped.<br>
    // If set to <code>"multiple"</code>, selection will be additive (as a record goes 
    // into edit mode, it is selected in addition to any pre-existant selection).
    // <P>
    // If set to <code>null</code> behavior is as follows:<ul>
    // <li>For grids with +link{listGrid.selectionType} set to
    // <code>"simple"</code> edit rows will be selected additively - this is the same
    // behavior as if the <code>editSelectionType</code> was <code>"multiple"</code></li>
    // <li>Otherwise edit rows will be selected singly - this is the same behavior as
    // if the <code>editSelectionType</code> was <code>"single"</code></li>
    // </ul>
    // @visibility external
    //<
     
    
    editSelectionType: "single",
    
    //> @attr listGridField.canToggle (Boolean : varies : IRWA)
    // Allows a boolean or +link{valueMap,valueMapped} field to be edited without going into
    // edit mode. When this attribute is set, clicking on the field will change the value - for
    // boolean fields toggling between <code>true</code> and <code>false</code>, and for valueMapped
    // fields, advancing the value to the next option in the valueMap.
    // <P>
    // To enable this feature, +link{listGrid.canEdit} must be set to true.
    // For boolean type fields <code>canToggle</code> is true by default, meaning setting
    // <code>canEdit</code> to true implies the user can toggle the value via a single click
    // without going into edit mode. You can disable this by explicitly setting
    // <code>canToggle</code> to false for a boolean field.<br>
    // Note that you can enable toggling only (without allowing the user to edit other fields)
    // by just setting +link{listGrid.editEvent,grid.editEvent:"none"}.
    // <P>
    // If +link{listGrid.editEvent} is set to "click", when the user clicks on the field,
    // the value will be toggled, and inline editing will be triggered as usual.
    // Otherwise the toggled value will be saved immediately to the server, or if
    // +link{listGrid.autoSaveEdits} has been set to false, will be stored as an edit value
    // for the record.
    //
    // @group editing
    // @visibility external
    //<

    //> @attr listGrid.enumCriteriaAsInitialValues (Boolean : true : IR)
    // In a ListGrid that has a DataSource and has filter criteria that include values for
    // fields declared as +link{type:FieldType,type "enum"} in the DataSource, by default a newly
    // edited row will use those filter criteria as initial values.
    // <P>
    // For example, if a ListGrid is showing all Accounts that have status:"Active" and a new row
    // is created, the new row will default to status:"Active" unless this flag is set to false.
    //
    // @group editing
    // @visibility external
    //<
    enumCriteriaAsInitialValues:true,

    //> @attr listGrid.application (Application : null : IRW)
    //      Application to use when saving edited values in a databound ListGrid
    //  @group  editing
    //<

    //> @attr listGrid.autoComplete (AutoComplete : null : IRW)
    // Whether to do inline autoComplete in text fields during inline editing<br>
    // Overridden by +link{ListGridField.autoComplete} if specified.
    // If unset picks up the default from the appropriate editor class (subclass of FormItem).
    //
    // @see listGridField.autoComplete
    // @group autoComplete
    // @visibility external
    //<
    //autoComplete:null,

    //> @attr listGrid.uniqueMatch (boolean : true : IRW)
    // When SmartClient autoComplete is enabled, whether to offer only unique matches to the
    // user.
    // <p>
    // Can be individually enabled per TextItem, or if set for the grid as a whole, can
    // be set differently for individual fields.
    //
    // @see listGridField.uniqueMatch
    // @group autoComplete
    // @visibility autoComplete
    //<

    // autoSelectEditors - if true when the user starts editing a cell always select the content
    // of the cell
    autoSelectEditors:true,
    // defaults for the form used for inline editing
    
    editFormDefaults: {
        
        canSelectText:true,
        autoDraw:false,
        // gotcha: if the user has e.g. enabled implicitSave on all DynamicForms, disable it
        // here because the various endEdit actions will then fire a duplicate save
        implicitSave: false,
        implicitSaveOnBlur: false,        
        // disable tabbing to icons by default
        // Overridden in the MiniDateRangeItem at the item level as there's no
        // focusable element except the picker for that item type
        
        canTabToIcons:false,

        // show error icons on the left by default
        errorOrientation:"left",
        showErrorText:false,
        showErrorStyle:false,
        
        itemKeyPress:function (item, keyName, characterValue) {
            return this.grid.editorKeyPress(item, keyName, characterValue);
        }
    },

    //> @attr listGrid.longTextEditorThreshold (int : 255 : IRW)
    // When the length of the field specified by +link{attr:dataSourceField.length} exceeds this
    // value, the ListGrid shows an edit field of type +link{attr:listGrid.longTextEditorType}
    // rather than the standard text field when the field enters inline edit mode.
    //
    // @group editing
    // @visibility external
    //<
    longTextEditorThreshold : 255,

    //> @attr listGrid.longTextEditorType (String : "PopUpTextAreaItem" : IRW)
    // When the length of the field specified by +link{attr:dataSourceField.length} exceeds
    // <code>this.longTextEditorThreshold</code> show an edit field of this type
    // rather than the standard text field when the field enters inline edit mode.
    //
    // @group editing
    // @visibility external
    //<
    longTextEditorType : "PopUpTextAreaItem",

    // functions installed into FormItems used for inline editing.
    // Note - these will be executed in the scope of the form item (not in the scope of the
    // ListGrid).
    //
    // Set up keyboard handling on form items to handle user navigation via "Enter", "Escape",
    // "Tab" keypresses, etc.
    //
    // NOTE: in Moz, if the user is holding down tab and we are cancelling the field change
    // *while logging to an open Log window*, we'll be stuck in the field indefinitely.  This
    // is probably a non-bug but can look like a freeze.
    //
    // row editing: Cancel tab to prevent focus cycling through the visible form items, since
    // for the first/last editable or visible item, we want to place focus in newly drawn
    // editors (on next/previous row, or just in newly drawn area that we scrolled into)
    editorKeyDown : function (item, keyName) {
        
        if (isc.Browser.isMoz && item && item.multiple &&
            isc.isA.NativeSelectItem(item) && keyName == "Enter")
        {
            item._selectedOnEnterKeydownSet = true;
            item._selectedOnEnterKeydown = item.getValue();
        }
    },

    isMultiLineEditor : function (item) {
        return item.getIsMultiLineEditor();
    },
    editorKeyPress : function (item, keyName, characterValue) {

        // We will return false to cancel native behavior on any key event for the keys
        // used for navigating around the edit cells (arrow keys, tab, etc.)
        var EH = isc.EH,
            returnValue,
            editEvent;

        var isMultiLineEditor =  this.isMultiLineEditor(item);
        
        
        if (keyName == "Enter") {
            // If the event occurred over an icon, we don't want to interfere with it, as
            // enter will activate the link (for accessibility)
            if (item.getFocusIconIndex() != null) return;

            // allow enter to work normally for text areas.  Alt + Enter overrides.
            if (isMultiLineEditor && isc.EH.altKeyDown() == false) {
                return returnValue;
            }
            if (item._selectedOnEnterKeydownSet) {
                var oldVal = item._selectedOnEnterKeydown;
                delete item._selectedOnEnterKeydown;
                delete item._selectedOnEnterKeydownSet;
                item.setValue(oldVal);
            }
            editEvent = isc.ListGrid.ENTER_KEYPRESS;
            returnValue = false;

        } else if (keyName == "Escape") {
            editEvent = isc.ListGrid.ESCAPE_KEYPRESS;
            returnValue = false;
    
        } else if (keyName == "Arrow_Up") {
        
            var action = this.getArrowKeyEditAction(item, keyName);
            if (action == "none") {
                return returnValue;
            }
            editEvent = isc.ListGrid.UP_ARROW_KEYPRESS;
            returnValue = false;

        } else if (keyName == "Arrow_Down") {
            var action = this.getArrowKeyEditAction(item, keyName);
            if (action == "none") {
                return returnValue;
            }

            editEvent = isc.ListGrid.DOWN_ARROW_KEYPRESS;
            returnValue = false;

        // if the user started editing via editOnKeyPress and the 'moveEditorOnArrow' flag is true
        // we shift cells on left/right arrow
        } else if (this.moveEditorOnArrow && this._editSessionFromKeyPress) {
            if (keyName == "Arrow_Left") {
                editEvent = isc.ListGrid.LEFT_ARROW_KEYPRESS;
                returnValue = false;
            } else if (keyName == "Arrow_Right") {
                editEvent = isc.ListGrid.RIGHT_ARROW_KEYPRESS;
                returnValue = false;
            }
        }

        if (editEvent != null) {
            
            
            if (isc.EH.clickMaskUp()) {
                isc.EH.setMaskedFocusCanvas(null, isc.EH.clickMaskRegistry.last());
            }

            // Fire cellEditEnd to handle saving out the value / moving to the next cell as
            // appropriate
            this.cellEditEnd(editEvent);
        }
        return returnValue;
    },
    
    //> @method listGrid.getArrowKeyEditAction()
    // How should "Up" and "Down" arrow keypresses be handled when the user is editing
    // an item in the grid.
    // <P>
    // Returning "none" will cause the grid to take no action and allow default up/down
    // arrow key behavior within the editor to proceed. Returning "editNext" will create
    // an appropriate +link{type:EditCompletionEvent} (<i>"arrow_up"</i> or
    // <i>"arrow_down"</i> and cause the grid to start editing the previous or next row).
    // <P>
    // Default behavior varies by item type. For items where up and down arrows have
    // significant functionality to the editor this method returns <i>"none"</i>, allowing
    // that standard behavior to proceed. This includes:<br>
    // - Multi line editors (such as TextAreaItems)<br>
    // - SelectItems<br>
    // - SpinnerItems<br>
    // For other items, the default return value will be <i>"edit_next"</i>
    // <P>
    // To override these defaults, developers may specify an explicit arrowKeyEditAction
    // at the +link{listGrid.arrowKeyEditAction,grid}, or 
    // +link{listGridField.arrowKeyEditAction,field} level.
    // @param item (FormItem) Edit item receiving the up or down arrow keypress event
    // @param keyName (KeyName) Key pressed (one of "Arrow_Up" or "Arrow_Down")
    // @return (ArrowKeyEditAction) action to take
    // @visibility external
    //<
    
    getArrowKeyEditAction : function (item, keyName) {
    
        var field = this.getField(item.name),
            arrowKeyAction = field.arrowKeyEditAction || this.arrowKeyEditAction;
        if (arrowKeyAction != null) return arrowKeyAction;
        
        var textArea = this.isMultiLineEditor(item);
        
        if (textArea && !isc.EH.altKeyDown()) arrowKeyAction = "none";
        else if (isc.isA.SpinnerItem(item) && !isc.EH.altKeyDown()) arrowKeyAction = "none";
        else if (isc.isA.SelectItem(item) && !isc.EH.ctrlKeyDown()) arrowKeyAction = "none";
        else if (isc.isA.PresetCriteriaItem(item) && !isc.EH.ctrlKeyDown()) arrowKeyAction = "none";
        else if (isc.EH.ctrlKeyDown() && isc.EH.shiftKeyDown()) arrowKeyAction = "none";
        else {
            arrowKeyAction = "editNext";
        }
        
        return arrowKeyAction;
        
    },

    
    // Override elementFocus on the form items:
    // If we're editing the whole row, and the user clicks in a new field to focus in it,
    // call 'editCellEnd' method to perform validation / saving on the previous
    // edit field (if required).
    
    _editFormItem_elementFocus : function (suppressHandlers) {
        var cell = this._setLGEditCellForFocus(suppressHandlers);
        this.Super("elementFocus", arguments);
        this._fireLGEditorEnter(cell[0], cell[1]);
    },
    _editFormItem_setLGEditCellForFocus : function (suppressHandlers) {

        

        var form = this.form,
            lg = form.grid;
        
        
        var rowNum, colNum, fieldName, fieldChanged;
        if (lg._editorShowing) {
            rowNum = lg._editRowNum;
            if (!lg.editByCell) {
                rowNum = lg._editRowNum;
                fieldName = this.getFieldName();
                colNum = lg.fields.findIndex("name", fieldName);

                if (!suppressHandlers) {
                    fieldChanged = (lg._editColNum != colNum);
                    // If the user has clicked in another field in the edit form,
                    // fire editField on the appropriate field
                    if (fieldChanged) {
                    // store the new edit cell
                        lg.setNewEditCell(rowNum, colNum);
                    // fire 'cellEditEnd' to save / validate before moving to the new cell
                        lg.cellEditEnd(isc.ListGrid.EDIT_FIELD_CHANGE);

                    // Note - if we could cancel the focus here, it might make sense, as the
                    // cellEditEnd callback method will re-focus in the new focus cell, but we can't
                    // cancel the focus by simply returning false from this method.
                    // Therefore allow the focus to proceed, and fall through to the super
                    // implementation of this method which will fire focus handlers, show any
                    // 'showOnFocus' icons, etc.
                    }
                }
            } else {
                colNum = lg._editColNum;
            }
        }
        return [rowNum, colNum];
    },
    _editFormItem_fireLGEditorEnter : function (rowNum, colNum) {
        var form = this.form,
            lg = form.grid;

        if (lg._editorShowing) {
            // If this is the current edit field, and hasn't yet fired its 'editorEnter' handlers
            // fire them now.
            var rowEnter = this._rowEnterOnFocus,
                cellEnter = this._cellEnterOnFocus;
            // Note: we're clearing out the flags before we fire the handlers. If the
            // handler trips a change of edit row, etc., we want editorExit to fire.
            delete this._rowEnterOnFocus;
            delete this._cellEnterOnFocus;

            
            var editVals = isc.addProperties(
                {},
                lg.getCellRecord(rowNum,colNum),
                lg._getEditValues(rowNum,colNum)
            );

            if (cellEnter) {
                var fieldName = lg.getFieldName(colNum);
                lg._handleEditorEnter(this, rowNum, colNum, editVals[fieldName]);
            }
            if (rowEnter) lg._handleRowEditorEnter(this, rowNum, editVals);

        } else {
            lg.logWarn("suppressing editorEnter handlers on focus as listGrid._editorShowing is null");
        }
    },


    // Header
    // ----------------------------------------------------------------------------------------

    //> @groupDef gridHeader
    // Properties and methods related to the ListGrid header. ListGrid headers are implemented
    // as a +link{class:Toolbar} of buttons shown at the top of the ListGrid
    // (one button per column).<br>
    // The toolbar header provides UI for interacting with the ListGrid fields directly (sorting,
    // resizing, reordering columns, etc).
    // @visibility external
    //<

    //> @attr listGrid.header (AutoChild Layout : null : R)
    // A Toolbar used to manager the headers shown for each column of the grid.
    // @group gridHeader
    // @visibility external
    //<

    //> @attr listGrid.headerContextMenu (AutoChild Canvas : null : R)
    // The context menu displayed for column headers.
    // @group gridHeader
    // @visibility external
    //<

    //> @attr listGrid.cellContextMenu (AutoChild Layout : null : R)
    // The menu displayed when a cell is right clicked on.
    // @visibility external
    //<

    //> @attr listGrid.spanContextMenu (AutoChild Layout : null : R)
    // The menu displayed when a cell is right clicked on.
    // @group gridHeader
    // @visibility external
    //<

    //> @attr listGrid.canTabToHeader (boolean : null : IR)
    // Should the header be included in the tab-order for the page? If not explicitly specified,
    // the header will be included in the tab order for the page if 
    // <smartclient>+link{isc.setScreenReaderMode,isc.setScreenReaderMode()}</smartclient> 
    // <smartgwt>
    // {@link com.smartgwt.client.util.SC#setScreenReaderMode SC.setScreenReaderMode()}
    // </smartgwt>
    // is called.
    // @group accessibility
    // @visibility external
    //<
    //canTabToHeader:null,

    //> @attr listGrid.canTabToSorter (Boolean : false : IR)
    // Should the +link{listGrid.sorterConstructor,corner sort button} be included in the 
    // tab-order for the page? 
    // @group accessibility
    // @visibility external
    //<
    canTabToSorter:false,

    //> @attr listGrid.headerHeight (number : 22 : [IRW])
    //          The height of this listGrid's header, in pixels.
    //      @setter setHeaderHeight()
    //      @visibility external
    //      @group  gridHeader, sizing
    //<
    // Note: we treat a headerHeight of zero as an equivalent of showHeader:false
    headerHeight:22,

    //> @attr listGrid.minFieldWidth (int : 15 : IRW)
    // Minimum size, in pixels, for ListGrid headers.
    // @visibility external
    //<
    minFieldWidth:15,

    //> @attr listGrid.showHeader (Boolean: true : [IRW])
    // Should we show the header for this ListGrid?
    // @group gridHeader, appearance
    // @visibility external
    //<
    showHeader:true,

    //> @attr listGrid.headerBarStyle (CSSStyleName : null : IR)
    // Set the CSS style used for the header as a whole.
    // @group   gridHeader, appearance
    // @visibility external
    //<
    //headerBarStyle:null,

    //> @attr listGrid.headerBackgroundColor (CSSColor: "#CCCCCC" : IRW)
    // BackgroundColor for the header toolbar. Typically this is set to match the color
    // of the header buttons.
    //      @group  gridHeader, appearance
    // @visibility external
    //<
    headerBackgroundColor:"#CCCCCC",
    
    // We want to support a drop shadow under the header.
    // Only supported for css-based headers as we don't want peers floating around
    // in the LG children.
    // We can't use headerDefaults directly for this as if we have frozen cols the
    // shadow should apply to the headerLayout, not the header itself.
    
    
    //> @attr listGrid.showHeaderShadow (Boolean : false : IRW)
    // Should the header show a drop-shadow?
    // Shadow will be applied to the header, or for a grid with frozen columns, the
    // header layout. 
    // <P>
    // Header shadow will only be displayed if +link{canvas.useCSSShadow,css shadows} are
    // being used.
    // @see listGrid.headerShadowVOffset
    // @see listGrid.headerShadowHOffset
    // @see listGrid.headerShadowSoftness
    // @see listGrid.headerShadowColor
    // @visibility external
    //<
    showHeaderShadow:false,

    //> @attr listGrid.headerShadowVOffset (Number : 1 : IRA)
    // If +link{listGrid.showHeaderShadow} is true, the +link{canvas.shadowVOffset} for
    // the header shadow
    // @visibility external
    //<
    headerShadowVOffset:1,

    //> @attr listGrid.headerShadowHOffset (Number : 0 : IRA)
    // If +link{listGrid.showHeaderShadow} is true, the +link{canvas.shadowHOffset} for
    // the header shadow
    // @visibility external
    //<    
    headerShadowHOffset:0,
    
    //> @attr listGrid.headerShadowSoftness (Number : 1 : IRA)
    // If +link{listGrid.showHeaderShadow} is true, the +link{canvas.shadowSoftness} for
    // the header shadow
    // @visibility external
    //<
    headerShadowSofness:1,

    //> @attr listGrid.headerShadowColor (CSSColor : null : IRA)
    // If +link{listGrid.showHeaderShadow} is true, the +link{canvas.shadowColor} for
    // the header shadow.
    // @visibility external
    //<
    // Unset by default - rely on standard skin shadow color

    headerDefaults : {

        // immediately reposition headers during drag resizing, don't delay
        instantRelayout:true,
        // when the user resizes buttons, don't try to fit them into the available space -
        // allow the user to introduce hscrolling
        enforcePolicy:false,
        
        // force createButtonsOnInit to false in case a dev sets it to true globally
        createButtonsOnInit: false,

        // when the header is clicked, have it call headerClick() on us
        itemClick : function (button, buttonNum) {
            this.Super("itemClick",arguments);
            this.grid._headerClick(buttonNum, this);
        },

        itemDoubleClick : function (button, buttonNum) {
            this.Super("itemDoubleClick", arguments);
            this.grid._headerDoubleClick(buttonNum, this);
        },

        showContextMenu : function () {
            return this.grid.headerBarContextClick(this);
        },

        // can a reorder-dragged field from revertPos be dropped at position?
        
        _canReorderDrop : function (position, revertPos) {
            var grid = this.grid,
                spanMap = grid.spanMap;
            if (!spanMap) return false;
            
            var fields = grid.fields,
                field = fields[position];
            if (!field) return false;

            // check whether field is being dropped after the last span field, or before the
            // first, depending on whether we're dragging to the right or left, respectively
            
            var dropAfter = revertPos < position;
            for (var lastSpan, span = spanMap[field.name]; span != null; 
                 lastSpan = span, span = span.parentSpan)
            {
                
                if (span.canReorder == false) return false;

                // deepest span has a field array, parent spans have span arrays
                var fields = span.fields;
                if (fields) {
                    // we're only intereested in visible fields, so exclude those hidden
                    
                    var fieldMap = grid._getFieldMap();
                    fields = fields.filter(function (id) {return fieldMap[id];});
                    if (field.name != (dropAfter ? fields.last() : fields.first())) {
                        return false;
                    }
                } else {
                    // skip spans not visible due to them containing only hidden fields
                    var spans = span.spans.filter(function (span) {return span.liveObject;});
                    if (lastSpan != (dropAfter ? spans.last() : spans.first())) {
                         return false;
                    }
                }
            }
            return true;
        },

        backgroundRepeat:isc.Canvas.NO_REPEAT,

        // don't print the header, we handle this as part of the body instead, to ensure column
        // alignment
        shouldPrint:false,

        // Override focusInNextButton() - when the user is navigating through buttons
        // with the arrow keys we want to allow them to cross from the frozen to unfrozen
        // headers and vice-versa
        _focusInNextButton : function (forward, startingIndex) {
            var movedWithinToolbar = this.Super("_focusInNextButton", arguments);
            if (!movedWithinToolbar && this.grid && this.grid.frozenFields) {
                if (forward == null) forward = true;
                return this.grid._focusInNextHeader(this, forward);
            }
            return movedWithinToolbar;
        }

    },

    //> @attr listGrid.headerButtonConstructor (Class : null : IR)
    // Widget class for this ListGrid's header buttons. If unset, constructor will be
    // picked up directly from the standard +link{class:Toolbar} button constructor.
    // @group   gridHeader, appearance
    // @visibility external
    //<

    //> @attr listGrid.headerBaseStyle (CSSStyleName : null : IR)
    // +link{Button.baseStyle} to apply to the buttons in the header, and the sorter, for
    // this ListGrid.
    // Note that, depending on the +link{listGrid.headerButtonConstructor, Class} of the header
    // buttons, you may also need to set +link{listGrid.headerTitleStyle}.
    // @group gridHeader, appearance
    // @see group:skins
    // @see clipHeaderTitles
    // @see wrapHeaderTitles
    // @visibility external
    //<

    //> @attr listGrid.headerTitleStyle (CSSStyleName : null : IR)
    // +link{StretchImgButton.titleStyle} to apply to the buttons in the header, and the sorter,
    // for this ListGrid.
    // Note that this will typically only have an effect if
    // +link{listGrid.headerButtonConstructor} is set to +link{class:StretchImgButton} or a subclass
    // thereof.
    // @group   gridHeader, appearance
    // @visibility external
    //<

    //> @attr listGrid.frozenHeaderBaseStyle (CSSStyleName : null : IR)
    // If this listGrid contains any frozen fields, this property can be used to apply a custom
    // headerBaseStyle to the frozen set of fields. If unset, the standard headerBaseStyle
    // will be used for both frozen and unfrozen cells.
    // @visibility external
    // @group gridHeader, appearance, frozenFields
    // @see listGrid.headerBaseStyle
    // @see listGridField.frozen
    //<

    //> @attr listGrid.frozenHeaderTitleStyle (CSSStyleName : null : IR)
    // If this listGrid contains any frozen fields, this property can be used to apply a custom
    // headerTitleStyle to the frozen set of fields. If unset, the standard headerTitleStyle
    // will be used for both frozen and unfrozen cells.
    // @visibility external
    // @group gridHeader, appearance, frozenFields
    // @see listGrid.headerTitleStyle
    // @see listGridField.frozen
    //<

    // Helper called from syntheticShiftFocus on header buttons. This allows us to
    // skip over the frozen / unfrozen header buttons in the page's tab order if 
    // canTabToHeader is true
    // When a button gets focus we'll remember which header it was in and then skip over the
    // other header unless a user explicitly puts focus into it via arrow-keys or clicking
    
    skipHeaderButtonFocus : function (headerButton) {
        if (headerButton.parentElement.tabWithinToolbar) return false;

        if (this.lastFocusHeader != null && this.lastFocusHeader != headerButton.parentElement) {
            return true;
        }
        return false;
    },

    headerButtonFocusChanged : function (headerButton, hasFocus) {
        if (hasFocus) this.lastFocusHeader = headerButton.parentElement;
    },

    // This method is called from header / frozenHeader.focusInNextButton() when the user
    // has hit left/right arrows to the end of the header.
    // If appropriate we'll jump focus to the first button in the next header.
    _focusInNextHeader : function (header, forward) {
        if (this.frozenFields) {
            var nextHeader = forward ? this.header : this.frozenHeader;
            if (nextHeader != header) {
                var buttons = nextHeader.getMembers(),
                    focusIndex = forward ? 0 : buttons.length-1,
                    step = forward ? 1 : -1,
                    end = forward ? -1 : buttons.length;

                while (focusIndex != end) {
                    var button = buttons[focusIndex]; 
                    if (button._canFocus()) {
                        button.focus();
                        // Returning true will indicate successful shift of focus
                        return true;
                    }
                    focusIndex += step;
                }
            }
        }
        return false;
    },

    //> @attr listGrid.headerButtonDefaults (Button Properties: {...} : IRA)
    // Defaults to apply to all header buttons. To modify this object,
    // use +link{class.changeDefaults(), ListGrid.changeDefaults()}
    // rather than replacing with an entirely new object.
    // @group   gridHeader, appearance
    // @visibility external
    //<
    headerButtonDefaults:{
        clipTitle: true,

        syntheticShiftFocus : function () {
            var grid = this.parentElement ? this.parentElement.grid : null;
            if (grid && grid.skipHeaderButtonFocus(this)) return false;
            return this.Super("syntheticShiftFocus", arguments);
        },

        focusChanged : function () {
            var grid = this.parentElement ? this.parentElement.grid : null;
            if (grid) {
                grid.headerButtonFocusChanged(this, this.hasFocus);
            }
            
            if (this.hasFocus && this.parentElement && this.parentElement._updateFocusButton) {
                this.parentElement._updateFocusButton(this)
            }
        },

        // override getCurrentCursor to show default (non pointer) for canSort:false fields
        getCurrentCursor : function () {
            var grid = this.parentElement ? this.parentElement.grid : null;
            var currentCursor = isc.Canvas.DEFAULT;
            if (grid && this.masterIndex != null) {
                var field = grid.getField(this.masterIndex),
                    canSort = grid._canSort(field) != false;
                if (canSort) currentCursor = isc.Canvas.HAND;
            } else {
                if (this.isSorterButton) {
                    if (!grid && isc.isA.ListGrid(this.parentElement)) grid = this.parentElement;
                    if (grid) {
                        var canSort = grid._canSort(grid._getSortFieldNum()) != false;
                        if (canSort) currentCursor = isc.Canvas.HAND;
                    }
                } else {
                    currentCursor = this.getClass().getPrototype().cursor;
                }
            }
            this.cursor = currentCursor;
            return this.Super("getCurrentCursor", arguments);
        },

        
        _getVPadding : function () {
            if (this._cachedVPadding != null) return this._cachedVPadding;

            // Determine the padding size from the DOM.
            var top, bottom,
            pxString = isc.px;

            // if it's drawn, examine the style of the drawn HTML element first
            if (this.isDrawn()) {
                var element = this._getCellElement();
                if (element) {
                    top    = isc.Element.getTopPaddingSize(element);
                    bottom = isc.Element.getBottomPaddingSize(element);
                }
            }

            var className = this.getStateName();
            if (className) {
                if (!isc.isA.Number(top))    top    = isc.Element._getTopPadding(className);
                if (!isc.isA.Number(bottom)) bottom = isc.Element._getBottomPadding(className);
            }

            if (!isc.isA.Number(top))    top    = 0;
            if (!isc.isA.Number(bottom)) bottom = 0;

            return this._cachedVPadding = top + bottom;
        },

        dragScrollType:"parentsOnly",
        minWidth:20,
        hoverDelay:500
    },

    //> @attr listGrid.headerButtonProperties (Button Properties: null : IRA)
    // Properties to apply to all header buttons.
    // Overrides defaults applied via  +link{ListGrid.headerButtonDefaults}.
    // @group   gridHeader, appearance
    // @visibility external
    //<

    //> @attr listGrid.clipHeaderTitles (Boolean : varies : IRA)
    // Whether the ListGrid should manage the clipping of titles of header buttons, showing
    // ellipses if the title is clipped, and potentially showing the full title
    // on +link{listGrid.showClippedHeaderTitlesOnHover,hover}.
    // <p>
    // In some cases this may be preferable to the button component's default clipping behavior
    // because if a +link{ListGrid.showSortArrow,sort arrow} or sort numeral is displayed for
    // a header, then the button's default clipping behavior may clip the sort arrow/numeral
    // whereas ListGrid-managed title clipping utilizes special HTML which keeps the sort
    // arrow/numeral visible.
    // <p>
    // This feature is automatically enabled if supported by the browser. The only supported
    // use of this attribute is to <em>disable</em> the feature by setting clipHeaderTitles
    // to false.
    // <P>
    // Note that this feature is incompatible with +link{listGridField.wrap}, and will
    // automatically be disabled for wrapping fields.
    // 
    // @see headerBaseStyle
    // @group gridHeader, appearance
    // @visibility external
    //<
    
    
    clipHeaderTitles: (!isc.Browser.isIE ||
                       (isc.Browser.version > 6 && isc.Browser.isStrict) ||
                       isc.Browser.version >= 10),

    //> @attr listGrid.wrapHeaderTitles (Boolean : null : IR)
    // If +link{listGridField.wrap} is not explicitly set, should fields wrap?  If autofitting,
    // see the docs on that property for the details of how the minimum width for a field is
    // determined.
    // 
    // @see minFieldWidth
    // @see headerBaseStyle
    // @visibility external
    //<
    

    //> @attr listGrid.rotateHeaderTitles (Boolean : null : IR)
    // Whether to rotate the field titles so they're rendered vertically from bottom to top.
    // Can be overridden for individual fields by setting +link{listGridFIeld.rotateTitle}.
    // <P>
    // Note that you can manually set the header height and field widths as you please when
    // using this feature, but it's not compatible with +link{autoFitHeaderHeights} or
    // autofitting of field widths in any +link{AutoFitWidthApproach} other than "value".
    // <P>
    // You can use +link{headerTitleVAlign} or +link{listGridField.valign} to control vertical
    // positioning of the titles, and +link{listGridField.align} to control the horizontal.
    // You may also choose between +link{clipHeaderTitles,clipping} or 
    // +link{wrapHeaderTitles,wrapping}, and set +link{showHeaderMenuButton} as you please
    // (which reserves space in each header button for the header menu button).
    // <P>
    // Note that this feature is incompatible with clipping via +link{clipHeaderTitles}:false,
    // and may not work with older browsers, particular IE versions before IE10.  The
    // "TreeFrog" and "Basic" +link{group:skins,skins} are not supported for this feature.
    //
    // @see headerTitleVAlign
    // @see listGridFIeld.valign
    // @see listGridField.rotateTitle
    // @example rotatedTitles
    // @visibility external
    //<

    //> @attr listGrid.headerTitleVAlign (VerticalAlignment : null : IR)
    // Specifies vertical alignment in the column headers: "top", "center", or "bottom".  Can 
    // be overridden for individual fields by setting +link{listGridField.valign}.
    // <p>
    // When using +link{rotateHeaderTitles,rotated titles}, this attribute defaults to "bottom"
    // if it remains unset.
    // @see listGridFIeld.valign
    // @see rotateHeaderTitles
    // @see listGridField.rotateTitle
    // @visibility external
    //<
    //headerTitleVAlign: isc.Canvas.BOTTOM,

    //> @attr listGrid.wrapHeaderSpanTitles (Boolean : null : IR)
    // If +link{headerSpan.wrap} is not explicitly set, should fields wrap?  If autofitting,
    // see the docs on that property for the details of how the minimum width for a field is
    // determined.
    // 
    // @see minFieldWidth
    // @visibility external
    //<
    

    //> @attr listGrid.sorterConstructor (Class : Button : IR)
    // Widget class for the corner sort button, if showing.  This button displays the current
    // sort direction of the primary sort field (either the only sorted field or the first in a
    // +link{listGrid.canMultiSort, multi-sort} grid) and reverses the direction of that field
    // when clicked.  For consistent appearance, this
    // is usually set to match +link{listGrid.headerButtonConstructor}
    // @group gridHeader, appearance
    // @visibility external
    //<
    sorterConstructor:isc.Button,
    

    //> @attr listGrid.sorterButtonTitle (String : "corner menu" : IR)
    // The title for the corner sort button.  The title will only
    // +link{Class.changeDefaults(), ListGrid.changeDefaults()} rather than replacing with an
    // entirely new object.
    // @group i18nMessages, gridHeader, appearance
    // @visibility external
    //<
    sorterButtonTitle: "corner menu",

    //> @attr listGrid.sorterDefaults (Object : {...} : IRA)
    // Defaults to apply to the corner sort button. To modify this object, use
    // +link{Class.changeDefaults(), ListGrid.changeDefaults()} rather than replacing with an
    // entirely new object.
    // @group gridHeader, appearance
    // @visibility external
    //<
    sorterDefaults:{
        _redrawWithParent:false,
        getTitle : function () {
            if (this.creator.loadingData && !this.creator.isEmpty()) {
                return isc.Canvas.imgHTML(isc.Canvas.loadingImageSrc);
            } else {
                return this.creator.getSortArrowImage();
            }
        },
        click : function () { return this.creator._sorterClick() },
        showContextMenu : function() { return this.creator._sorterContextClick() },
        isSorterButton: true,
        allowFilterOperators: false,
        align: "center"
    },

    //> @attr listGrid.sorterProperties (Button Properties: null : IRA)
    // Properties to apply to the sorter button. Overrides defaults applied via
    // +link{ListGrid.sorterDefaults}.
    // @group gridHeader, appearance
    // @visibility external
    //<

    // Sorting
    // --------------------------------------------------------------------------------------------

    //> @attr listGrid.sortByGroupFirst (Boolean : null : [IRW]) 
    // If set, whenever grouping is performed by an end user or by a programmatic call to 
    // +link{groupBy()}, data is implicitly sorted by all of the grouped columns, in the order 
    // they were passed to groupBy. Any user-configured sorting is applied after sorting by 
    // grouped columns.
    // <p>
    // Sorting by grouped fields will be in ascending or descending order according to whether 
    // the grid is currently sorted (by any field) in ascending or descending order, defaulting 
    // to ascending if the grid is not sorted. Implicit sorting by group can be forced to be 
    // always ascending or always descending by setting +link{groupSortDirection}.
    // <p>
    // The sorting is "implicit" in the sense that the sorting is not shown in the ListGrid 
    // headers, and not shown in the +link{multiSortDialog} if enabled.  An end user cannot 
    // currently remove the implicit sorting themselves (except by removing the grouping), 
    // though it is possible to override it by providing an explicit sort on the group's column.
    // Clicking on the grouped field's header reveals the usual sort indicators with all
    // the same semantics.
    // <p>
    // The correct way to remove implicit sorting programmatically is to call 
    // +link{setSortByGroupFirst(),setSortByGroupFirst(false)}.
    // <p>
    // Programmatic calls to +link{getSort()} will not include the implicit sort in 
    // the list of return sort specifiers, and calls to +link{setSort()} will implicitly add 
    // the sorting by grouped columns before the specified sort.
    // <p>
    // Note that directly calling ResultSet.getSort() will include the implicit sort 
    // information.
    // 
    // @group sorting, grouping
    // @see groupSortDirection
    // @see groupSortNormalizer
    // @visibility external
    //<

    //> @attr listGrid.groupSortDirection (SortDirection : null : [IRW]) 
    // When +link{sortByGroupFirst} is active, the sorting direction applied for implicit 
    // sorting by the field(s) used for grouping. Default of null means that sort direction 
    // is based on the current direction of user-configured sort, or is "ascending" if the 
    // user has not sorted the data.
    //
    // @group sorting, grouping
    // @see sortByGroupFirst
    // @see groupSortNormalizer
    // @see SortSpecifier.direction
    // @visibility external
    //<

    //> @method listGrid.groupSortNormalizer()
    // When +link{sortByGroupFirst} is active, the sorting 
    // +link{SortSpecifier.normalizer,normalizer} applied for implicit sorting by the field(s)
    // used for grouping.
    // <P>
    // No default implementation.
    //
    // @param record  (ListGridRecord)  record to normalize
    // @param fieldName    (FieldName)  name of the field on which sorting occurred
    // @param context       (ListGrid)  the grid is passed to allow property and method access
    // @return (Any)  normalized value for sorting
    // @group sorting, grouping
    // @see sortByGroupFirst
    // @see groupSortDirection
    // @see SortSpecifier.normalizer
    // @example customGroupSorting
    // @visibility external
    //<

    //> @attr listGrid.sortBinaryByFileName (boolean : true : [IRW])
    // For any fields of +link{FieldType,type "binary"}, should sorting be performed
    // against the fileName of the value for the field? For SmartClient server backed
    // dataSources, this is applied to the record automatically as described in the
    // +link{group:binaryFields} overview.
    // <P>
    // If set to false, binary fields will be sorted against the record value for the
    // field in question. Client-side sorting does not support this, so developers who
    // actually want to support a sort against the binary itself would typically set
    // +link{resultSet.useClientSorting} to false on the +link{dataProperties} block for
    // this grid.
    // <P>
    // Note that this setting will have no effect if +link{dataSourceField.sortByField} is
    // specified
    // @group sorting
    // @visibility external
    //<
    sortBinaryByFileName:true,    
    
    //> @attr listGrid.canSort (Boolean : true : [IRW])
    // Enables or disables interactive sorting behavior for this listGrid. Does not
    // affect sorting by direct calls to the +link{listGrid.sort, sort} or
    // +link{listGrid.setSort, setSort} methods.
    //
    // @group sorting
    // @visibility external
    //<
    canSort:true,

    //> @attr listGrid.canUnsort (boolean : false : [IRW])
    // When set to true, the third click on a column header removes the sort indicator
    // from the field.
    //
    // @group sorting
    // @visibility internal
    //<
    canUnsort:false,

    //> @attr listGrid.invalidateCacheOnUnsort (boolean : false : [IRW])
    // If true, and +link{listGrid.canUnsort} is also true and the grid is databound to a
    // +link{ResultSet}, then unsort causes the grid to drop the current client-side
    // data cache and refetch the current range of records from the server.
    //
    // @group sorting
    // @visibility internal
    //<
     
    invalidateCacheOnUnsort: false,

    //> @attr listGrid.selectHeaderOnSort (Boolean : true : [IRW])
    // If true, show the field-header for the sorted field (or the first field in a
    // +link{listGrid.canMultiSort, multi-sort} grid) in the selected state.
    //
    // @group sorting
    // @visibility external
    //<
    selectHeaderOnSort: true,

    
    //sortFieldNum:null,

    //> @attr listGrid.sortField (String | int : null : IR)
    // Specifies the field by which this grid should be initially sorted. Can be set to either a
    // +link{listGridField.name,field name} or the index of the field in the fields Array.
    // <P>
    // ListGrids also support being initialized with multiple-field sort via
    // +link{listGrid.initialSort}. If initialSort is specified, it will be used in preference
    // to this property.
    // <P>
    // To sort the grid after it has been initialized, use +link{ListGrid.sort()} or
    // +link{listGrid.setSort()}. Details about the current sort of a live grid can be
    // retrieved by calling +link{listGrid.getSortField()} or +link{listGrid.getSort()}
    //
    // @group sorting
    // @example sort
    // @visibility external
    //<

    //> @attr listGrid.keyboardClickField (String | number : null : [IRW])
    // When simulating click events listGrid rows as a result of keyboard events
    // (navigating using the arrow keys, space, enter for doubleClick), which column
    // should the event be generated upon?
    // Should be set to the name or index of the desired column.
    // If null, defaults to the first column where +link{listGridField.ignoreKeyboardClicks}
    // is not false.
    // @group  events
    //<
    // If +link{listGrid.screenReaderNavigateByCell} is true, this property is updated 
    // dynamically to track which column has focus

    //> @attr listGrid.sortDirection (SortDirection : "ascending" : [IRW])
    // Sorting direction of this ListGrid. If specified when the ListGrid is initialized,
    // this property will be the default sorting direction for the +link{listGrid.sortField}.
    // May be overridden by specifying +link{ListGridField.sortDirection}.
    // <P>
    // After initialization, this property will be updated on +link{ListGrid.sort()} or
    // +link{ListGrid.setSort()} to reflect the current sort direction of the grid. When
    // this grid is sorted by multiple fields, the grid's sortDirection reflects the
    // sort direction of the primary sort field.
    // <p>
    // Note: A side effect of +link{setSort()} is that it updates the grid's <code>sortDirection</code>
    // to the direction of the first sort. In particular, if there is an +link{attr:initialSort} or
    // +link{attr:sortField}, then <code>sortDirection</code> will be updated during initialization
    // to the direction of the first sort.
    // @group  sorting
    // @see type:SortDirection
    // @example sort
    // @setter sort()
    // @visibility external
    //<
    
    sortDirection: "ascending",

    //> @attr listGrid.showSortArrow (SortArrow : null : [IRW])
    // Indicates whether a sorting arrow should appear for the listGrid, and its
    // location. See +link{SortArrow} for details.
    // <P>
    // Clicking the sort arrow reverses the direction of sorting for the current sort
    // column (if any), or sorts the listGrid by its first sortable column. The arrow
    // image on the button indicates the current direction of sorting.
    // If undefined, the sort arrow will show up in the sorted field, and the
    // corner sort button will be displayed if a vertical scrollbar is being displayed
    //
    // @group sorting, appearance
    // @visibility external
    //<
    
    //showSortArrow:null,

    

    //> @attr listGrid.sortArrowMenuButtonSpaceOffset (int : 7 : [IRW])
    // When +link{leaveHeaderMenuButtonSpace} is true, configures the amount of space beyond the
    // +link{headerMenuButtonWidth} on the right side of a ListGrid header button (left for
    // +link{Page.isRTL(),RTL mode}) to reserve for the sort arrow if sorting is active for
    // that field and the arrow will be shown.  May be increased for more separation between
    // the sort arrow and the title text, at the expense of a reduced space for the title text.
    // <P>
    // This value may need to be customized in your skin or if +link{sortAscendingImage} or 
    // +link{sortDescendingImage} are changed.
    //
    // @see sortNumeralMenuButtonSpaceOffset
    // @visibility external
    //<
    sortArrowMenuButtonSpaceOffset : 7,

    //> @attr listGrid.sortNumeralMenuButtonSpaceOffset (int : 9 : [IRW])
    // When +link{leaveHeaderMenuButtonSpace} is true, configures the amount of space beyond the
    // +link{headerMenuButtonWidth} on the right side of a ListGrid header button (left for
    // +link{Page.isRTL(),RTL mode}) to reserve for the sort numeral if 
    // +link{canMultiSort,multi-sorting} is active for that field and the numeral will be shown.
    // May be increased for more separation between the title text and the sort arrow when 
    // multi-sorting.  
    // <P>
    // Note that larger values may required if 10 or more fields are sorted at once, as the
    // numeral will occupy more space.  This value may need to be customized in your skin or if
    // +link{sortAscendingImage} or +link{sortDescendingImage} are changed.
    //
    // @see sortArrowMenuButtonSpaceOffset
    // @visibility external
    //<
    sortNumeralMenuButtonSpaceOffset : 9,

    //> @attr listGrid.canPickFields (Boolean : true : [IRW])
    // Indicates whether the field picker item and submenu should be present in the header
    // context menu. This menu allows the user to hide visible fields and show hidden fields.
    // <p>
    // By default only fields explicitly included in the +link{listGrid.fields} array will
    // be available in this menu, unless +link{listGrid.canPickOmittedFields} is set to true for
    // a databound grid.
    // <p>
    // A specific field can be omitted from the column picker via +link{listGridField.canHide}.
    //
    // @visibility external
    //<
    canPickFields: true,

    //> @attr listGrid.canPickOmittedFields (Boolean : false : [IR])
    // If true, the +link{listGrid.canPickFields,field picker menu} will include
    // entries for all dataSource fields, including those not
    // included in the specified +link{listGrid.fields,fields array}.
    // <P>
    // This property only applies to grids with a specified +link{listGrid.dataSource},
    // where +link{listGrid.fields} is explicitly set and +link{useAllDataSourceFields}
    // is false. The +link{listGrid.canPickFields} property must also be set to true
    // to allow the user to view the field picker menu.
    // <P>
    // <b>Note: grids with <code>canPickOmittedFields:true</code>, like those
    // with +link{useAllDataSourceFields,useAllDataSourceFields:true} will render
    // fields in the order in which they are defined in the dataSource rather than
    // the order in which they're defined in the +link{listGrid.fields,listGrid fields array}.</b>
    //
    // @visibility external
    //<
    canPickOmittedFields:false,

    // Frozen Fields (aka Frozen Columns)
    // ---------------------------------------------------------------------------------------

    //> @groupDef frozenFields
    // Frozen fields are fields that do not scroll horizontally with other fields, remaining on
    // the screen while other fields may be scrolled off.  This feature is typically used to
    // allow basic identifying information (like an "accountId") to remain on screen while the
    // user scrolls through a large number of related fields.
    // <P>
    // Fields can be programmatically frozen via setting
    // +link{listGridField.frozen,field.frozen} to true when the grid is created, or
    // dynamically frozen and unfrozen via +link{listGrid.freezeField(),freezeField()} and
    // +link{listGrid.unfreezeField,unfreezeField()}.
    // The setting +link{listGrid.canFreezeFields,canFreezeFields} enables a user interface to
    // allow end users to dynamically freeze and unfreeze fields.
    // <P>
    // The frozen fields feature is not compatible with the following features:
    // <ul>
    // <li> +link{autoFitData}:"horizontal", as well as headers that autoFit to titles
    //      (normally enabled via <code>field.overflow:"visible"</code>)
    // <li> the +link{CubeGrid} subclass of ListGrid
    // <li> nested grids
    // </ul>
    // The frozen fields feature <b>is</b> compatible with column resize and reorder, selection
    // and multi-selection, loading data on demand, inline editing, drag and drop and reorder
    // of records, the +link{TreeGrid} subclass of ListGrid, and all dynamic styling-related and
    // formatting-related features.
    // <P>
    // The +link{listGrid.frozenFieldsMaxWidth} property may be used to specify a maximum
    // size for the frozen fields. If their combined width exceeds this, a 
    // horizontal scrollbar will be displayed, allowing the user to scroll the frozen
    // fields independently of the other fields in the grid.
    // <P>
    // Troubleshooting tip: If you encounter misalignment between rows in frozen and unfrozen 
    // columns, this is likely due to one of the following causes:
    // <ul><li>Inconsistent border/padding: all cells in a row in a table must have the same
    //     top and bottom border thickness, and all cells in a column must have the same 
    //     horizontal border and padding width, or the table is invalid, 
    //     with no clear rules for rendering it.  The HTML/CSS spec doesn't say what to 
    //     do in this situation, and browser engines behave inconsistently.</li>
    // <li>For grids with +link{listGrid.fixedRecordHeights,fixedRecordHeights:true}, the cell contents,
    //     inclusive of border and padding, needs to be less than your configured 
    //     +link{listGrid.cellHeight}, or you need to set +link{listGrid.enforceVClipping} to cause us 
    //     to clip it as necessary. Breaking this rule can cause misalignment between rows in
    //     frozen and unfrozen columns as some fields have cells with taller content.
    //     (This does not apply for grids with <code>fixedRecordHeights</code> set to false).
    // </li></ul>
    //
    // @title Frozen Fields
    // @visibility external
    //<

    //> @attr listGrid.canFreezeFields (boolean : null : IRW)
    // Whether an interface should be shown to allow user is allowed to dynamically "freeze" or
    // "unfreeze" columns with respect to horizontally scrolling. If unset, this property defaults
    // to <code>true</code> unless:<ul>
    // <li>+link{listGrid.fixedRecordHeights,this.fixedRecordHeights} is <code>false</code></li>
    // <li>+link{listGrid.bodyOverflow,this.bodyOverflow} is <code>"visible"</code></li>
    // <li>+link{listGrid.autoFitData,this.autoFitData} is set to <code>"horizontal"</code> or
    // <code>"both"</code></li>
    // <li>Any field has overflow set to <code>"visible"</code></li></ul>
    // <P>
    // Note that the <code>canFreezeFields</code> setting enables or disables the user
    // interface for freezing and unfreezing fields only.  Fields can be programmatically
    // frozen via setting +link{listGridField.frozen,field.frozen} to true when the grid is
    // created, or dynamically frozen and unfrozen via +link{freezeField()} and
    // +link{unfreezeField()}.
    // <P>
    // Developers should also be aware that if the cell content for some field exceeds
    // the specified +link{cellHeight}, and +link{enforceVClipping} is not set to true, 
    // this can cause misalignment between rows in frozen and unfrozen columns. See the
    // +link{group:frozenFields,Frozen fields overview} for more on this.
    //
    //
    // @group frozenFields
    // @visibility external
    //<
    // Note that fixedColumnWidths:false will also disable canFreezeFields but this
    // is not currently public.
    
    //> @attr listGrid.frozenFieldsMaxWidth (String | Integer : null : IRW)
    // Maximum width available for any +link{group:frozenFields,frozen fields} shown 
    // in this grid. May be specified as a percentage or numeric pixel value.
    // <P>
    // If the frozen fields' combined width exceeds this value, a
    // horizontal scrollbar will be shown, allowing the frozen fields to be horizontally
    // scrolled (independently from the unfrozen fields).
    // @visibility external
    //<
    
    
    // -------------------------
    // Formula / summary fields (picked up from databoundcomponent)
    
    //> @attr listGrid.badFormulaResultValue        (String : "." : IRW)
    // @include dataBoundComponent.badFormulaResultValue
    //<
    
    //> @attr listGrid.missingSummaryFieldValue     (String : "-" : IRW)
    // @include dataBoundComponent.missingSummaryFieldValue
    //<
    
    //> @attr listGrid.missingFormulaFieldValue (String : "-" : IRW)
    // @include dataBoundComponent.missingFormulaFieldValue
    //<

    //> @attr listGrid.canAddFormulaFields (boolean : false : IRW)
    // @include dataBoundComponent.canAddFormulaFields
    // @visibility external
    //<

    //> @method listGrid.getFormulaFieldValue()
    // @include dataBoundComponent.getFormulaFieldValue()
    // @param field (ListGridField) field that has a formula
    // @param record (Record) record to use to compute formula value
    // @return (Double | String) formula result if a valid number or
    // +link{dataBoundComponent.badFormulaResultValue} if invalid
    // @visibility external
    //<

    //> @attr listGrid.canAddSummaryFields (boolean : false : IRW)
    // @include dataBoundComponent.canAddSummaryFields
    // @visibility external
    //<

    //> @method listGrid.getSummaryFieldValue()
    // @include dataBoundComponent.getSummaryFieldValue()
    // @param field (ListGridField) field that has a summary format
    // @param record (Record) record to use to compute formula value
    // @return (String) formula result
    // @visibility external
    //<


    //> @attr listGrid.canEditHilites (boolean : false : IRW)
    // @include dataBoundComponent.canEditHilites
    // @visibility external
    //<

    //> @attr listGrid.hilites
    // Hilites to be applied to the data for this grid.  See +link{group:hiliting}.
    // <p>
    // It is undefined behavior to share the same record objects, or the same +link{ResultSet} instances,
    // among multiple grids if one of the grid's fields specifies a +link{ListGridField.userFormula, userFormula},
    // +link{ListGridField.userSummary, userSummary}, +link{ListGridField.aiFieldPrompt, aiFieldPrompt},
    // or +link{ListGridField.aiHoverRequest, aiHoverRequest}, or if one of the grids has a
    // +link{Hilite} with an asynchronous filter in the hilite's +link{Hilite.criteria, criteria}.
    // @include DataBoundComponent.hilites
    // @visibility external
    //<

    // Context Menus
    // --------------------------------------------------------------------------------------------

    //> @attr listGrid.showCellContextMenus (Boolean : false : [IRW])
    // Whether to show a context menu with standard items for all context clicks on rows in the
    // body.
    // @visibility external
    //<
    //showCellContextMenus:false,

    //> @attr listGrid.openRecordEditorContextMenuItemTitle (String : "Edit" : [IRW])
    // If +link{listGrid.canOpenRecordEditor} is true and +link{listGrid.showCellContextMenus}
    // is true, this property specifies the title for the context menu item shown allowing the
    // user to perform editing on a row via an embedded form.
    // @group i18nMessages
    // @visibility nextedGrid
    //<
    openRecordEditorContextMenuItemTitle:"Edit",

    //> @attr listGrid.dismissEmbeddedComponentContextMenuItemTitle (String : "Dismiss" : IRW)
    // If +link{listGrid.showCellContextMenus} is true, and we are currently showing either
    // an embedded editor (see +link{listGrid.canOpenRecordEditor}) or an embedded
    // detail grid (see +link{listGrid.canOpenRecordDetailGrid}, this property
    // specifies the title for the context menu item shown allowing the user to dismiss the
    // embedded component.
    // @group i18nMessages
    // @visibility nextedGrid
    //<
    dismissEmbeddedComponentContextMenuItemTitle:"Dismiss",

    //> @attr listGrid.deleteRecordContextMenuItemTitle (String : "Delete" : IRW)
    // If +link{listGrid.showCellContextMenus} is true, this property
    // specifies the title for the context menu item shown allowing the user to delete the
    // record on which the contextMenu was shown.
    // @group i18nMessages
    // @visibility experimental
    //<
    deleteRecordContextMenuItemTitle:"Delete",


    //> @attr listGrid.canOpenRecordDetailGrid (boolean : true : [IRW])
    // Whether context menu items will be shown for viewing records from related DataSources in
    // grids embedded in the record.
    // <P>
    // Valid only when <code>showCellContextMenus</code> is true.
    // @visibility nestedGrid
    //<
    canOpenRecordDetailGrid:true,

    //> @attr listGrid.recordDetailGridProperties (Object : null : [IR])
    // Properties for detail grids shown embedded inside rows.
    // @visibility nestedGrid
    //<

    //> @attr listGrid.canOpenRecordEditor (boolean : true : [IRW])
    // Whether a context menu item will be shown for editing records with a form embedded in
    // the record.
    // <P>
    // Valid only when <code>showCellContextMenus</code> is true.
    // @visibility nestedGrid
    //<
    canOpenRecordEditor:true,

    //> @attr listGrid.recordEditorProperties (Object : null : [IR])
    // Properties for editor forms shown embedded inside rows.
    // @see listGrid.canOpenRecordEditor
    // @visibility nestedGrid
    //<

    //> @attr listGrid.recordEditorSaveButtonTitle (String : "Save" : [IRW])
    // Title for the Save button shown in the editor form embedded inside rows if
    // +link{listGrid.canOpenRecordEditor} is true.
    // @see listGrid.canOpenRecordEditor
    // @group i18nMessages
    // @visibility nestedGrid
    //<
    recordEditorSaveButtonTitle:"Save",

    //> @attr listGrid.recordEditorCancelButtonTitle (String : "Cancel" : [IRW])
    // Title for the Cancel button shown in the editor form embedded inside rows if
    // +link{listGrid.canOpenRecordEditor} is true.
    // @see listGrid.canOpenRecordEditor
    // @group i18nMessages
    // @visibility nestedGrid
    //<
    recordEditorCancelButtonTitle:"Cancel",


    //>!BackCompat 2007.02.02
    // showCornerContextMenu was never externally documented and we have no in-code comments
    // about having ever exposed this property, so it may be safe to get rid of this
    // back-compat

    //> @attr listGrid.showCornerContextMenu (boolean : null : [IR])
    // Whether to allow a context menu on the sorter with standard items for showing and hiding
    // fields.
    // @deprecated as of 5.6 in favor of +link{attr:listGrid.showHeaderContextMenu}
    //<
    //<!BackCompat

    //> @attr listGrid.showHeaderContextMenu (Boolean : true : [IR])
    // Whether to show a context menu on the header with standard items for showing and hiding
    // fields.  Not supported for +link{cubeGrid}.
    // @group gridHeader
    // @see method:listGrid.displayHeaderContextMenu()
    // @see method:listGrid.getHeaderContextMenuItems()
    // @visibility external
    //<
    // NOTE: avoid crashing if Menu class isn't loaded by defaulting to false.
    // when we load the Menu class, we override this default.
    //showHeaderContextMenu:false,

    //> @attr listGrid.showHeaderSpanContextMenu (Boolean : true : [IR])
    // Whether to show a context menu on the header span with standard items for showing and hiding
    // fields.  Not supported for +link{cubeGrid}.
    // @group gridHeader
    // @see method:listGrid.getHeaderSpanContextMenuItems()
    // @visibility external
    //<
    // NOTE: avoid crashing if Menu class isn't loaded by defaulting to false.
    // when we load the Menu class, we override this default.
    //showHeaderSpanContextMenu:false,

    // headerMenuButton
    // ----------------------------
    //> @attr listGrid.showHeaderMenuButton (Boolean : true : [IR])
    // If set to true and +link{listGrid.showHeaderContextMenu,showHeaderContextMenu} is true, the
    // +link{listGrid.headerMenuButton} will be displayed when the user rolls
    // over the header buttons in this grid.  Not supported for +link{cubeGrid}.
    // @group headerMenuButton
    // @visibility external
    //<
    // As with showHeaderContextMenu, this default should not be set to true until we know
    // for sure that Menu has been loaded (see Menu.js)
    //showHeaderMenuButton:true,

    //> @attr listGrid.leaveHeaderMenuButtonSpace (boolean : null : [IWA])
    // If +link{listGrid.showHeaderMenuButton} is true, when auto-fitting fields to
    // the title width via +link{listGrid.autoFitFieldWidths} or +link{listGridField.autoFitWidth},
    // should the button be sized such that there is enough space for the header menu button to
    // show without covering the field title?
    // <P>
    // May be explicitly specified at the +link{listGridField.leaveHeaderMenuButtonSpace,field level}
    // or at the +link{listGrid.leaveHeaderMenuButtonSpace,grid level}. If not explicitly
    // specified space will be left for fields with
    // +link{listGridField.align} set to <code>"left"</code> or <code>"right"</code>, but not for
    // fields with align set to <code>"center"</code>.
    //
    // @see sortArrowMenuButtonSpaceOffset
    // @see sortNumeralMenuButtonSpaceOffset
    // @group headerMenuButton
    // @visibility external
    //<
    leaveHeaderMenuButtonSpace:null,

    //> @attr listGridField.leaveHeaderMenuButtonSpace (boolean : null : [IWA])
    // If +link{listGrid.showHeaderMenuButton} is true, when auto-fitting fields to
    // the title width via +link{listGrid.autoFitFieldWidths} or +link{listGridField.autoFitWidth},
    // should the button be sized such that there is enough space for the header menu button to
    // show without covering the field title?
    // <P>
    // May be explicitly specified at the +link{listGridField.leaveHeaderMenuButtonSpace,field level}
    // or at the +link{listGrid.leaveHeaderMenuButtonSpace,grid level}. If not explicitly
    // specified space will be left for fields with
    // +link{listGridField.align} set to <code>"left"</code> or <code>"right"</code>, but not for
    // fields with align set to <code>"center"</code>.
    //
    // @group headerMenuButton
    // @visibility external
    //<

    //> @attr listGrid.headerMenuButtonConstructor (ClassName : null : [IRA])
    // Constructor for the  +link{listGrid.headerMenuButton}. If unset a standard "Button" will
    // be rendered out. Note that this property may be overridden by different skins.
    // @group headerMenuButton
    // @visibility external
    //<
    //headerMenuButtonConstructor: "StretchImgButton",

    //> @attr listGrid.headerMenuButton (AutoChild StatefulCanvas : null : [RA])
    // If +link{showHeaderMenuButton} is true, when the user rolls over the header buttons in this
    // grid the headerMenuButton will be shown over the header button in question. When clicked
    // this button will display the standard header context menu (see
    // +link{listGrid.displayHeaderContextMenu}).
    // <P>
    // +link{group:headerMenuButton,Several properties} exist to customize the appearance of the
    // headerMenuButton. Also see the +link{type:AutoChild} documentation for information on how
    // to make free-form modifications to autoChild widgets
    // @group headerMenuButton
    // @visibility external
    //<

    //> @attr listGrid.headerMenuButtonIcon (URL : "[SKIN]/ListGrid/headerMenuButton_icon.gif" : [IRA])
    // If +link{listGrid.showHeaderMenuButton} is true, this property governs the icon shown on the
    // auto-generated <code>headerMenuButton</code>
    // @group headerMenuButton
    // @visibility external
    //<
    headerMenuButtonIcon:"[SKIN]/ListGrid/headerMenuButton_icon.gif",

    //> @attr listGrid.headerMenuButtonIconWidth (number : 7 : [IRA])
    // If +link{listGrid.showHeaderMenuButton} is true, this property governs the width of the icon
    // shown on the auto-generated <code>headerMenuButton</code>
    // @group headerMenuButton
    // @visibility external
    //<
    headerMenuButtonIconWidth:7,

    //> @attr listGrid.headerMenuButtonIconHeight (number : 7 : [IRA])
    // If +link{listGrid.showHeaderMenuButton} is true, this property governs the height of the icon
    // shown on the auto-generated <code>headerMenuButton</code>
    // @group headerMenuButton
    // @visibility external
    //<
    headerMenuButtonIconHeight:7,

    //> @attr listGrid.headerMenuButtonWidth (number : 16 : [IRA])
    // If +link{listGrid.showHeaderMenuButton} is true, this property governs the width of the
    // auto-generated <code>headerMenuButton</code>
    // @see rotatedHeaderMenuButtonWidth
    // @group headerMenuButton
    // @visibility external
    //<
    headerMenuButtonWidth:16,

    //> @attr listGrid.headerMenuButtonHeight (Number | String : "100%" : [IRA])
    // If +link{listGrid.showHeaderMenuButton} is true, this property governs the height of the
    // auto-generated <code>headerMenuButton</code>
    // @see rotatedHeaderMenuButtonHeight
    // @group headerMenuButton
    // @visibility external
    //<
    headerMenuButtonHeight:"100%",

    //> @attr listGrid.rotatedHeaderMenuButtonWidth (number : 16 : [IRA])
    // If +link{listGrid.showHeaderMenuButton} is true, this property governs the width of the
    // auto-generated <code>headerMenuButton</code> over a 
    // +link{listGridField.rotateTitle,rotated} header button.
    // @see headerMenuButtonWidth
    // @group headerMenuButton
    // @visibility external
    //<
    rotatedHeaderMenuButtonWidth:"100%",

    //> @attr listGrid.rotatedHeaderMenuButtonHeight (Number | String : "100%" : [IRA])
    // If +link{listGrid.showHeaderMenuButton} is true, this property governs the height of the
    // auto-generated <code>headerMenuButton</code> over a
    // +link{listGridField.rotateTitle,rotated} header button.
    // @see headerMenuButtonHeight
    // @group headerMenuButton
    // @visibility external
    //<
    rotatedHeaderMenuButtonHeight:16,

    // Drag Resize / Reorder / Drag and Drop
    // --------------------------------------------------------------------------------------------

    //> @attr listGrid.canDragRecordsOut (Boolean : false : [IRW])
    // Indicates whether records can be dragged from this listGrid and dropped elsewhere.
    // <p>
    // <strong>NOTE:</strong> If <code>canDragRecordsOut</code> is initially enabled or might be
    // dynamically enabled after the grid is created, it may be desirable to disable
    // +link{Canvas.useTouchScrolling,touch scrolling} so that touch-dragging a record starts
    // a drag operation rather than a scroll, but see the discussion of 
    // +link{listGrid.showDragHandles(), drag handles}. If 
    // +link{Canvas.disableTouchScrollingForDrag} is set to <code>true</code>, then touch
    // scrolling will be disabled automatically. However, for
    // +link{group:accessibility,accessibility} reasons, it is recommended to leave touch
    // scrolling enabled and provide an alternative set of controls that can be used to perform
    // drag and drop of records out of the grid.
    // @visibility external
    // @group  dragging
    // @see ListGridRecord.canDrag
    // @see ListGridRecord.canAcceptDrop
    // @see showDragHandles()
    // @example dragListMove
    // @example recordsAcrossWindows
    //<
    canDragRecordsOut:false,

    //> @attr listGrid.canAcceptDroppedRecords (Boolean : false : [IRW])
    // Indicates whether records can be dropped into this listGrid.
    // @visibility external
    // @group  dragging
    // @see ListGridRecord.canDrag
    // @see ListGridRecord.canAcceptDrop
    // @example dragListMove
    //<
    //canAcceptDroppedRecords:false,

    //> @attr listGrid.canReorderRecords (Boolean : false : [IRW])
    // Indicates whether records can be reordered by dragging within this <code>ListGrid</code>.
    // <p>
    // <strong>NOTE:</strong> If <code>canReorderRecords</code> is initially enabled or might be
    // +link{ListGrid.setCanReorderRecords(),dynamically enabled} after the grid is created,
    // it may be desirable to disable +link{Canvas.useTouchScrolling,touch scrolling}
    // so that touch-dragging a record starts a reorder operation rather than a scroll,
    // but see the discussion of +link{listGrid.showDragHandles(), drag handles}. If 
    // +link{Canvas.disableTouchScrollingForDrag} is set to <code>true</code>, then touch
    // scrolling will be disabled automatically. However, for +link{group:accessibility,accessibility}
    // reasons, it is recommended to leave touch scrolling enabled and provide an alternative
    // set of controls that can be used to perform drag-reordering of records.
    // @group  dragging
    // @see ListGridRecord.canDrag
    // @see ListGridRecord.canAcceptDrop
    // @see showDragHandles()
    // @example dragListMove
    // @example gridsDragReorder
    // @visibility external
    //<
    //canReorderRecords:false,

    //> @attr listGrid.canReorderFields (Boolean : true : [IRW])
    // Indicates whether fields in this listGrid can be reordered by dragging and dropping
    // header fields.  If true, can be overridden at the field level via 
    // +link{listGridField.canReorder}.
    // @group dragging
    // @example columnOrder
    // @visibility external
    //<
    canReorderFields:true,

    //> @attr listGrid.canResizeFields (Boolean : true : [IRW])
    // Indicates whether fields in this listGrid can be resized by dragging header
    // fields.
    // @visibility external
    // @group  dragging
    // @example columnSize
    //<
    canResizeFields:true,

    // for dragging records out, use the drag tracker
    dragAppearance:isc.EH.TRACKER,

    // if you set canDragResize to true on the grid show an outline rather than the tracker!
    dragResizeAppearance:isc.EH.OUTLINE,

    //> @type DragTrackerMode
    // When records are being dragged from within a ListGrid, what sort of drag-tracker
    // should be displayed?
    // @value "none" Don't display a drag tracker at all
    // @value "icon" Display an icon to represent the record(s) being dragged. Icon src is
    //              derived from +link{ListGrid.getDragTrackerIcon()}
    // @value "title" Display a title for the record being dragged. Title derived from
    //              +link{ListGrid.getDragTrackerTitle()}
    // @value "record" Display the entire record being dragged
    // @group dragTracker
    // @visibility external
    //<

    //> @attr listGrid.dragTrackerMode (DragTrackerMode : "icon" : [IRA])
    // When records are being dragged from within a ListGrid, what sort of drag-tracker
    // should be displayed?<br>
    // Note that if multiple records are being dragged the displayed tracker will be
    // based on the first selected record.
    // @group dragTracker
    // @visibility external
    //<
    dragTrackerMode:"title",
    

    //> @attr listGrid.resizeFieldsInRealTime (boolean : see below : IRWA)
    // If <code>true</code>, the grid contents are redrawn in real time as fields are resized.
    // This can be slow with a large grid and/or on some platforms. By default, this is enabled
    // in modern desktop browsers. This is automatically switched off in mobile browsers.
    //
    // @group dragging
    // @visibility external
    //<
    resizeFieldsInRealTime: ((isc.Browser.isIE && isc.Browser.isWin)
                            || (isc.Browser.isFirefox && isc.Browser.geckoVersion >= 20080529)
                            // Safari 3.0+, Google Chrome
                            || (isc.Browser.isSafari && isc.Browser.safariVersion >= 500)),

    //> @attr listGrid.dragDataAction
    // @include dataBoundComponent.dragDataAction
    //<

    // Embedded Components
    // --------------------------------------------------------------------------------------------
    //> @attr listGrid.embeddedComponentIndent (Integer : 25 : IRW)
    // This is the pixel-amount by which child components are offset within the grid-body, by 
    // default from the left, or from the right when +link{Page.isRTL, RTL} is in effect.  For
    // +link{ListGrid.canExpandRecords, expanding rows}, this attribute is overridden by 
    // +link{ListGrid.expansionIndent}.
    // <P>
    // This setting overrides the +link{ListGrid.embeddedComponentMargin, general margin} for
    // embedded-components, on the appropriate side.
    // @group expansionField
    // @visibility external
    //<
    embeddedComponentIndent: 25,

    //> @attr listGrid.embeddedComponentMargin (Integer : 0 : IRW)
    // This is the space to apply as margin around child-components embedded in this grid.  
    // This value is overridden on one side for 
    // +link{ListGrid.canExpandRecords, expansion components} by 
    // +link{ListGrid.expansionIndent, expansionIndent} and in other scenarios
    // by +link{ListGrid.embeddedComponentIndent}.
    // @group expansionField
    // @visibility external
    //<
    embeddedComponentMargin: 0,
    
    getEmbeddedComponentMargin : function () {
        // if embeddedComponentMargin is set, return it
        if (this.embeddedComponentMargin != null) return this.embeddedComponentMargin;
        // internal legacy default 
        return 0;
    },

    //> @attr listGrid.expansionIndent (Integer : null : IRW)
    // When +link{ListGrid.canExpandRecords, canExpandRecords} is true, this is the 
    // pixel-amount by which child components are offset within the grid-body, by default
    // from the left, or from the right when +link{Page.isRTL, RTL} is in effect.  If unset,
    // assumes the width of the +link{ListGrid.expansionField, expansionField}, so that child
    // components line up with the following field, according to RTL.
    // <P>
    // This setting overrides the +link{ListGrid.embeddedComponentIndent, general indent} for
    // embedded-components, on the appropriate side.
    // @group expansionField
    // @visibility external
    //<
    expansionIndent: null,

    getExpansionIndent : function () {
        // if expansionIndent is set, return it
        if (this.expansionIndent != null) return this.expansionIndent;
        // size the indent to the width of the expansionField
        var field = this.getExpansionField();
        var width = field ? this.getFieldWidth(field) : null;
        if (width != null) return width;
        // internal legacy default 
        return 25;
    },

    // Nested Master-Detail
    // --------------------------------------------------------------------------------------------
    nestedGridDefaults : {
        height:150
    },

    // Skinning
    // --------------------------------------------------------------------------------------------
    //> @attr listGrid.skinImgDir (SCImgURL : "images/ListGrid/" : IRWA)
    // Where do 'skin' images (those provided with the class) live?
    // @group appearance, images
    // @visibility external
    //<
    skinImgDir:"images/ListGrid/",

    //> @attr listGrid.sortAscendingImage (SCImgURL | ImgHTMLProperties : {...} : IRWA)
    // Image to show when sorted in ascending order. Can be either a regular +link{SCImgURL} 
    // src, or an +link{class:ImgHTMLProperties} object.
    // @see sortArrowMenuButtonSpaceOffset
    // @visibility external
    //<
    sortAscendingImage:{src:"[SKIN]sort_ascending.gif", width:7, height:7},

    //> @attr listGrid.sortDescendingImage (SCImgURL | ImgHTMLProperties : {...} : IRWA)
    // Image to show when sorted in descending order. Can be either a regular +link{SCImgURL} 
    // src, or an +link{class:ImgHTMLProperties} object.
    // @group appearance
    // @see sortArrowMenuButtonSpaceOffset
    // @visibility external
    //<
    sortDescendingImage:{src:"[SKIN]sort_descending.gif", width:7, height:7},

    //> @attr listGrid.trackerImage (SCImgURL | ImgHTMLProperties : {...} : IRWA)
    // Default image to use for the dragTracker when things are dragged within or out of this
    // list.  Can be either a regular +link{SCImgURL} src, or an +link{class:ImgHTMLProperties} 
    // object.
    //
    // @group dragTracker
    // @see listGrid.dragTrackerMode
    // @see listGrid.getDragTrackerIcon()
    // @visibility external
    //<
    trackerImage:{src:"[SKIN]tracker.gif", width:16, height:16},

    //> @attr listGrid.booleanBaseStyle (CSSStyleName : null : IRA)
    // An optional CSS style to apply to the checkbox image. If supplied, and the checkbox is
    // enabled, the base style is suffixed with "True", "False", or "Partial" if the checkbox
    // is selected, unselected, or partially selected; if the checkbox is disabled, the suffix
    // is "TrueDisabled", "FalseDisabled", or "PartialDisabled".
    // <p>
    // <b>NOTE:</b> This attribute is not supported by +link{TreeGrid}.
    // @group imageColumns
    // @see ListGrid.printBooleanBaseStyle
    // @visibility external
    //<

    //> @attr listGrid.printBooleanBaseStyle (CSSStyleName : null : IRA)
    // If set, the +link{ListGrid.booleanBaseStyle,booleanBaseStyle} to use when +link{group:printing,printing}.
    // @group imageColumns
    // @group printing
    // @see ListGrid.booleanBaseStyle
    // @visibility external
    //<

    //> @attr listGrid.booleanTrueImage (SCImgURL : null : IRWA)
    // Image to display for a true value in a boolean field. The special value "blank" means
    // that no image will be shown.
    // <P>
    // To turn this off explicitly set +link{listGridField.suppressValueIcon} to true.
    // <P>
    // If this, +link{listGrid.booleanFalseImage} and +link{listGrid.booleanPartialImage}
    // are unset, this will be set to the default +link{CheckboxItem.checkedImage}.
    // <P>
    // +link{group:skinning,Spriting} can be used for this image, by setting this property to
    // a +link{type:SCSpriteConfig} formatted string. Alternatively developers can
    // omit this property and instead use CSS directly in the 
    // +link{ListGrid.booleanBaseStyle} property to provide a "boolean true" appearance.
    //
    // @see ListGrid.booleanFalseImage
    // @see ListGrid.booleanPartialImage
    // @see ListGrid.printBooleanTrueImage
    // @group imageColumns
    // @visibility external
    //<
    booleanTrueImage:null,

    //> @attr listGrid.booleanFalseImage (SCImgURL : null : IRWA)
    // Image to display for a false value in a boolean field. Default <code>null</code> value
    // or the special value "blank" means no image will be displayed.
    // <P>
    // To turn this off explicitly set +link{listGridField.suppressValueIcon} to true
    // <P>
    // If this, +link{listGrid.booleanTrueImage} and +link{listGrid.booleanPartialImage}
    // are unset, this will be set to the default +link{CheckboxItem.uncheckedImage}.
    // <P>
    // <P>
    // +link{group:skinning,Spriting} can be used for this image, by setting this property to
    // a +link{type:SCSpriteConfig} formatted string. Alternatively developers can
    // omit this property and instead use CSS directly in the 
    // +link{ListGrid.booleanBaseStyle} property to provide a "boolean false" appearance.
    //
    // @group imageColumns
    // @see ListGrid.booleanTrueImage
    // @see ListGrid.booleanPartialImage
    // @see ListGrid.printBooleanFalseImage
    // @visibility external
    //<
    booleanFalseImage:null,

    //> @attr listGrid.booleanPartialImage (SCImgURL : null : IRWA)
    // Image to display for a partially true value in a boolean field (typically selection).
    // The special value "blank" means that no image will be shown.
    // <P>
    // To turn this off explicitly set +link{listGridField.suppressValueIcon} to true.
    // <P>
    // If this, +link{listGrid.booleanTrueImage} and +link{listGrid.booleanFalseImage}
    // are unset, this will be set to the default +link{CheckboxItem.partialSelectedImage}.
    // <P>
    // +link{group:skinning,Spriting} can be used for this image, by setting this property to
    // a +link{type:SCSpriteConfig} formatted string. Alternatively developers can
    // omit this property and instead use CSS directly in the 
    // +link{ListGrid.booleanBaseStyle} property to provide a "boolean true" appearance.
    //
    // @see ListGrid.booleanTrueImage
    // @see ListGrid.booleanFalseImage
    // @see ListGrid.printBooleanPartialImage
    // @group imageColumns
    // @visibility external
    //<
    booleanPartialImage:null,

    //> @attr listGrid.printBooleanTrueImage (SCImgURL : null : IRWA)
    // If set, the +link{ListGrid.booleanTrueImage} to use when +link{group:printing,printing}.
    // <p>
    // If this, +link{listGrid.printBooleanFalseImage} and +link{listGrid.printBooleanPartialImage}
    // are unset, this will be set to the default +link{CheckboxItem.printCheckedImage}.
    // @group imageColumns
    // @group printing
    // @see ListGrid.booleanTrueImage
    // @visibility external
    //<
    printBooleanTrueImage:null,

    //> @attr listGrid.printBooleanFalseImage (SCImgURL : null : IRWA)
    // If set, the +link{ListGrid.booleanFalseImage} to use when +link{group:printing,printing}.
    // <p>
    // If this, +link{listGrid.printBooleanTrueImage} and +link{listGrid.printBooleanPartialImage}
    // are unset, this will be set to the default +link{CheckboxItem.printUncheckedImage}.
    // @group imageColumns
    // @group printing
    // @see ListGrid.booleanFalseImage
    // @visibility external
    //<
    printBooleanFalseImage:null,

    //> @attr listGrid.printBooleanPartialImage (SCImgURL : null : IRWA)
    // If set, the +link{ListGrid.booleanPartialImage} to use when +link{group:printing,printing}.
    // <p>
    // If this, +link{listGrid.printBooleanTrueImage} and +link{listGrid.printBooleanFalseImage}
    // are unset, this will be set to the default +link{CheckboxItem.printPartialSelectedImage}.
    // @group imageColumns
    // @group printing
    // @see ListGrid.booleanPartialImage
    // @visibility external
    //<
    printBooleanPartialImage:null,

    //> @attr listGrid.booleanImageWidth (number : 16 : IRWA)
    // Width for the +link{listGrid.booleanTrueImage}, +link{listGrid.booleanFalseImage}
    // and +link{listGrid.booleanPartialImage}.
    // Note: If +link{listGrid.booleanTrueImage} is unset, the +link{checkboxItem.checkedImage}
    // will be used to indicate a true value in a boolean field. In this case this property is
    // ignored in favor of +link{checkboxItem.valueIconWidth}.
    // @group imageColumns
    // @visibility external
    //<
    
    booleanImageWidth:16,

    //> @attr listGrid.booleanImageHeight (number : 16 : IRWA)
    // Height for the +link{listGrid.booleanTrueImage}, +link{listGrid.booleanFalseImage}
    // and +link{listGrid.booleanPartialImage}.
    // Note: If +link{listGrid.booleanTrueImage} is unset, the +link{checkboxItem.checkedImage}
    // will be used to indicate a true value in a boolean field. In this case this property is
    // ignored in favor of +link{checkboxItem.valueIconHeight}.
    // @group imageColumns
    // @visibility external
    //<
    booleanImageHeight:16,

    
    //> @attr listGrid.mozBodyOutlineColor (String : "white" : IRWA)
    // If we're in Moz Firefox 1.5 or above, and showing a header, what color should the
    // dotted focus outline show around the body. Must be a color that contrasts with the
    // header of the ListGrid.
    // @visibility internal
    //<
    mozBodyOutlineColor:"white",
    //> @attr listGrid.mozBodyNoHeaderOutlineColor (String : "red" : IRWA)
    // If we're in Moz Firefox 1.5 or above, and we're not showing a header, what color
    // should the dotted focus outline show around the body. Must be a color that contrasts
    // with the header of the ListGrid.
    // @visibility internal
    //<
    mozBodyNoHeaderOutlineColor:"red",

// -----------------------------------------------------------------------------------------
// drag handles
//

    //> @method listGrid.showDragHandles()
    // Shows an additional field near the beginning of the field list (after any
    // +link{showRowNumbers,row number} field) that can be dragged to drag the current
    // selection.  This feature is useful in +link{Browser.isTouch,touch environments} where
    // both touch scrolling and dragging are needed on the same grid, and allows scrolling to
    // be triggered on the other fields so that both operations are available.  Targeted touch
    // environments include both mobile devices, and Windows hardware that supports
    // +link{Browser.supportsDualInput,Dual Input Mode} such as Microsoft Surface.
    // <P>
    // Note that the +link{dragHandleField,drag handle field} will never be shown unless 
    // +link{canReorderRecords} or +link{canDragRecordsOut} are true.
    // <P>
    // In IE11 or Microsoft Edge, dragging a record in a grid may not be possible using a touch
    // device without enabling drag handles, or disabling native touch scrolling by setting
    // &nbsp;<code>window.isc_useNativeTouchScrolling = false</code>&nbsp; before SmartClient
    // is loaded.
    // <P>
    // <h4>Background</h4>
    // <P>
    // One alternative to adding a drag handle field would be to use long touch to start a drag
    // (with normal touch triggering scrolling).  However, this is unsupportable in IE11 or Edge
    // on Microsoft Surface (with native scrolling) because native scrolling cannot be canceled
    // on the fly using Event.preventDefault(), but instead must be disabled by applying the
    // appropriate CSS at rendering time.  (Such limitations are not present elsewhere, such as
    // on Android or IPhone browsers.)
    // <P>
    // For more details, some links are provided below.  Note that while IE10 is mentioned in
    // some of the links, the reasoning is still relevant now for IE11 and Edge as the
    // limitations remain:
    // <ul>
    // <li>+externalLink{https://quirksmode.org/mobile/default.html,Cross-browser support of touchMove}
    // <li>+externalLink{https://stackoverflow.com/questions/26218146/pointer-events-ie11-surface,preventDefault() doesn't work in IE11 on MS Surface}
    // <li>+externalLink{https://stackoverflow.com/questions/49299496/html5-pointermove-touchmove-not-working-in-microsoft-edge,preventDefault() doesn't work in Edge on MS Surface}
    // <li>+externalLink{https://web.archive.org/web/20160309214328/https://connect.microsoft.com/IE/feedback/details/767646/ms-touch-action-does-not-allow-a-way-to-programmatically-prevent-default-touch-behavior,preventDefault() failure reported to Microsoft against IE10}
    // </ul>
    // @see hideDragHandles()
    // @see dragHandleField
    // @see dragHandleIcon
    // @see dragHandleIconSize
    // @example gridsTouchDrag
    // @group dragHandleField
    // @visibility external
    //<
    showDragHandles : function() {
        this._showDragHandles = true;
        this.refreshFields();
    },

    //> @method listGrid.hideDragHandles()
    // Hides the +link{dragHandleField,drag handle field}, if currently shown.
    // @see showDragHandles()
    // @group dragHandleField
    // @visibility external
    //<
    hideDragHandles : function() {
        this._showDragHandles = false;
        this.refreshFields();
    },

    //> @attr listGrid.showInitialDragHandles (boolean : null : IRA)
    // When set to true, shows the +link{dragHandleField,drag handle field} on initial draw.
    // @see showDragHandles()
    // @see hideDragHandles()
    // @see dragHandleField
    // @group dragHandleField
    // @visibility external
    //<

    //> @attr listGrid.dragHandleFieldTitle (String : "&nbsp;" : IRWA)
    // The title to use for the +link{listGrid.dragHandleField, drag handle field}.
    // <P>
    // By default this title is not displayed in the drag column header button as the
    // autochild defaults for the field set +link{listGridField.showTitle} to
    // <code>false</code>.
    // @see showDragHandles()
    // @group dragHandleField
    // @visibility external
    //<
    dragHandleFieldTitle: isc.nbsp,

    //> @attr listGrid.dragHandleIcon (SCImgURL : "[SKIN]/actions/drag.png" : IR)
    // Default icon to show in the +link{dragHandleField,drag handle field}..
    // @see showDragHandles()
    // @group dragHandleField
    // @visibility external
    //<
    dragHandleIcon:"[SKIN]/actions/drag.png",

    //> @attr listGrid.dragHandleIconSize (Number : 16 : IRW)
    // Default width and height of +link{dragHandleIcon,drag handle icons} for this ListGrid.
    // @see showDragHandles()
    // @group dragHandleField
    // @visibility external
    //<
    dragHandleIconSize: 16,
    
    // used to scale the width/height of the dragHandle icon
    //dragHandleIconWidth: 30,
    //dragHandleIconHeight: 30,

    //> @attr listGrid.dragHandleField (AutoChild ListGridField : null : IR)
    // An automatically generated field that can be dragged to drag the current selection
    // (where otherwise the grid itself might be scrolled).  Visibility is controlled by 
    // +link{showInitialDragHandles}, +link{showDragHandles()}, and +link{hideDragHandles()}.
    // @group dragHandleField
    // @visibility external
    //<
    dragHandleFieldDefaults: {
        type:"icon",
        width:24,
        name: "_dragHandleField",
        isDragHandle: true,

        canEdit: false,
        canHide: false,
        canSort: false,
        canGroupBy: false,
        canFilter:false,
        showTitle:false,
        canExport: false,
        // use autoFitWidth, to deal with the image being scaled
        autoFitWidth: true,
        canAutoFitWidth: false,
        canDragResize: false,
        excludeFromState:true,
        showDefaultContextMenu: false,
        selectCellTextOnClick:false,
        ignoreKeyboardClicks:true,
        keyboardFiresRecordClick: false,
        showGroupSummary:false,
        showGridSummary:false,
        summaryValue: "&nbsp;",
        // specifically disable filterOperators for this builtin field
        allowFilterOperators: false,
        autoFreeze: true,
        // disable this from ever being assigned as the treeField
        treeField:false, 
        cellAlign: "center"
    },

    //> @attr listGrid.useDragHandles (Boolean : false : [IRA])
    // Whether this grid should assume drag handles are present when deciding how to
    // handle touch interactions.  The primary use case is to set this property true if the
    // +link{listGrid.dragHandleField} autochild is not being shown, but one or more user
    // fields have been marked as +link{listGridField.isDragHandle,isDragHandle}: true.
    // <P>
    // Note that <code>useDragHandles</code> has no impact if the +link{dragHandleField,drag
    // handle field} autochild is being shown due to +link{showInitialDragHandles} or 
    // +link{showDragHandles()}.
    // @see showDragHandles()
    // @group dragHandleField
    //<

    // helper to check whether drag interaction should assume drag handles are present
    _shouldUseDragHandles : function () {
        if (this.fieldSourceGrid) return this.fieldSourceGrid._shouldUseDragHandles();
        return (this._showDragHandles || this.useDragHandles) && 
            (this.canReorderRecords || this.canDragRecordsOut);
    },

    // should the drag handle field autochild be added by setFields()
    shouldShowDragHandleField : function () {
        if (this.fieldSourceGrid) return this.fieldSourceGrid.shouldShowDragHandleField();
        return this._showDragHandles && (this.canReorderRecords || this.canDragRecordsOut);
    },

    // return the autogenerated drag handle field, if it's already been created
    getCurrentDragField : function () {
        var fields = this.completeFields || this.fields;
        if (!fields) return null;
        var dragHandleFields = fields.find("name", "_dragHandleField");
        if (!dragHandleFields) return null;
        return isc.isAn.Array(dragHandleFields) ? dragHandleFields[0] : dragHandleFields;
    },
    
    // return desired position of drag handle field autochild; should be after row number field
    getDragFieldPosition : function () {
        if (this.fieldSourceGrid) return this.fieldSourceGrid.getDragFieldPosition();
        if (!this.shouldShowDragHandleField()) return -1;
        
        var pos = 0;
        if (this.shouldShowRowNumberField()) pos++;
        return pos;
    },

    // create the drag handle field autochild
    getDragField : function () {
        var grid = this,
        dragHandleField = {
            title: this.dragHandleFieldTitle,
            cellIcon: this.dragHandleIcon,
            iconWidth: this.dragHandleIconWidth || this.dragHandleIconSize,
            iconHeight: this.dragHandleIconHeight || this.dragHandleIconSize,
            getAutoFreezePosition: function () {return grid.getDragFieldPosition();}
        };
        isc.addProperties(dragHandleField, this.dragHandleFieldDefaults, 
                                           this.dragHandleFieldProperties);
        return dragHandleField;
    },

    // helper to check whether event is in a drag handle field
    _shouldAllowRecordDrag : function () {

        if (!isc.Browser.isTouch || !this._shouldUseDragHandles()) {
            return true;
        }
        var body = this.body;
        if (!body || !body._usingNativeTouchScrolling()) return true;

        
        var fieldX = this.getOffsetX(isc.EH.mouseDownEvent),
            fieldNum = this.getEventColumn(fieldX),
            field = this.getField(fieldNum)
        ;
        return field && field.isDragHandle;
    },


// -----------------------------------------------------------------------------------------
// row numbers
//

    //> @attr listGrid.showRowNumbers (boolean : null : IRWA)
    // When set to true, shows an additional field at the beginning of the field-list
    // (respecting RTL) that displays the current rowNum for each record.
    // @group rowNumberField
    // @visibility external
    //<

    //> @attr listGrid.rowNumberStyle (CSSStyleName : "specialCol" : IRWA)
    // The CSS Style name for the +link{listGrid.rowNumberField}.
    // @group rowNumberField
    // @visibility external
    //<
    rowNumberStyle: "specialCol",
    
    //> @attr listGrid.applyRowNumberStyle (boolean : true : IRWA)
    // If +link{showRowNumbers} is true, should we apply the +link{rowNumberStyle} to
    // the +link{listGrid.rowNumberField}
    // @group rowNumberField
    // @visibility external
    //<
    applyRowNumberStyle:true,

    //> @attr listGrid.rowNumberStart (number : 1 : IRWA)
    // The number to start the row-count from - default value is 1.
    // @group rowNumberField
    // @visibility external
    //<
    rowNumberStart: 1,

    //> @attr listGrid.rowNumberField (AutoChild ListGridField : null : IRWA)
    // An automatically generated field that displays the current row number when
    // +link{listGrid.showRowNumbers, showRowNumbers} is true.
    // @group rowNumberField
    // @visibility external
    //<
    rowNumberFieldDefaults: {
        name: "_rowNumberField",
        excludeFromState:true,
        selectCellTextOnClick:false,
        canEdit: false,
        canFilter:false,
        canGroupBy: false,
        selectCellTextOnClick:false,
        canSort: false,
        canExport: false,
        canHide: false,
        canReorder: false,
        canDragResize: false,
        // make this special field canHilite false so we don't see it in HiliteEditors by default
        canHilite: false,
        canAutoFitWidth: false,
        showAlternateStyle: false,
        _isRowNumberField: true,
        showDefaultContextMenu: false,
        keyboardFiresRecordClick: false,
        showGroupSummary:false,
        showGridSummary:false,
        summaryValue: "&nbsp;",
        // specifically disable filterOperators for this builtin field
        allowFilterOperators: false,
        formatCellValue : function (value, record, rowNum, colNum, grid) {
            if (grid.isGrouped) {
                if (record == null || record._isGroup) return "&nbsp;";
                
                var groupedRowNum = grid.getGroupedRecordIndex(record);
                // skip any records we can't find in the group tree (EG summary rows)
                if (groupedRowNum == -1) return null;
                return (grid.rowNumberStart + groupedRowNum);
            } else {
                return this.rowNumberStart + rowNum;
            }
        },
        autoFreeze: true,
        // disable this from ever being assigned as the treeField
        treeField:false,
        // flag that means this is a special builtin field, not for formulas/export/etc
        featureField: true
    },

    // helper method to get index of the group in which a record exists
    getParentGroupIndex : function (record) {
        // bail if we're not grouped (return group 0)
        if (!this.isGrouped) return 0;

        // find out which group this record is in
        var tree = this.groupTree,
            parentNode = tree.getParent(record),
            rootChildren = tree.getChildren(tree.getParent(parentNode)),
            groupCount = 0;

        if (!isc.isA.ResultSet(rootChildren) || rootChildren.lengthIsKnown()) {
            for (var i = 0, length = rootChildren.getLength(); i < length; ++i) {
                var child = rootChildren.getCachedRow(i);
                if (child != null && child.groupValue == parentNode.groupValue) {
                    groupCount = i;
                    break;
                }
            }
        }

        return groupCount;
    },

    //> @method listGrid.getGroupedRecordIndex()
    // Returns the true row index for a grouped record excluding group and
    // summary records. Records in closed groups are included in number.
    // <p>
    // Function is not applicable for non-grouped grids and will return -1
    // if called.
    //
    // @param record (ListGridRecord) record to number
    // @return (int) row index for record or -1 for group or summary records
    // @group rowNumberField
    // @visibility external
    //<
    getGroupedRecordIndex : function (record) {
        // bail if we're not grouped
        if (!this.isGrouped) return -1;
        // find the true index of this record in a grouped grid - indexOf doesn't cater for
        // closed groups
        var tree = this.groupTree,
            
            parentNode = tree == null ? null : tree.getParent(record);

        // Checking for parentNode == null allows us to skip group-summary nodes which
        // shouldn't be counted anyway.
        if (parentNode == null) return -1;

        
        if (tree.getLevel(record) > 1) {
            var recurseState = { currentIndex: 0, parentNode: parentNode, record: record };
            this.getGroupedRecordIndexRecursive(tree.root, recurseState);
            return recurseState.currentIndex;
        }

        var rootChildren = tree.getChildren(tree.getParent(parentNode)),
            groupCount = 0,
            trueIndex = 0;

        if (!isc.isA.ResultSet(rootChildren) || rootChildren.lengthIsKnown()) {
            for (var i = 0, rootChildrenLength = rootChildren.getLength(); i < rootChildrenLength; ++i) {
                var child = rootChildren.getCachedRow(i);
                if (child != null) {
                    if (child.groupValue == parentNode.groupValue) {
                        var siblings = tree.getChildren(child);
                        if (!isc.isA.ResultSet(siblings) || siblings.lengthIsKnown()) {
                            for (var j = 0, siblingsLength = siblings.getLength(); j < siblingsLength; ++j) {
                                var sibling = siblings.getCachedRow(j);
                                if (sibling != null && this.objectsAreEqual(sibling, record)) {
                                    return trueIndex + j;
                                }
                            }
                        }
                    }
                    var prevSiblings = tree.getChildren(child);
                    if (!isc.isA.ResultSet(prevSiblings) || prevSiblings.lengthIsKnown()) {
                        var length = prevSiblings.getLength();
                        // Don't count group summary rows - these show up at the end of the
                        // group [and we support an arbitrary number of them]
                        if (this.showGroupSummary && !this.showGroupSummaryInHeader) {
                            for (var ii = length - 1; ii >=0; --ii) {
                                var prevSibling = prevSiblings.getCachedRow(ii);
                                if (prevSibling != null) {
                                    if (prevSibling[this.groupSummaryRecordProperty]) --length;
                                    else break;
                                }
                            }
                        }
                        trueIndex += length;
                    }
                }
            }
        }

        return trueIndex;
    },

    getGroupedRecordIndexRecursive : function (startNode, state) {
        var tree = this.groupTree;
        if (!startNode) startNode = tree.root;

        // iterate through all the children of the node
        var children = tree.getChildren(startNode);
        if (!children) return true;
        if (isc.isA.ResultSet(children) && !children.lengthIsKnown()) return true;

        var parentNode = state.parentNode,
            record = state.record
        ;

        // for each child
        var length = children.getLength();
        for (var i = 0; i < length; ++i) {
            var child = children.getCachedRow(i);

            if (child == null) {
                // Do nothing.
            } else if (tree.isFolder(child)) {
                if (!this.getGroupedRecordIndexRecursive(child, state)) {
                    return false;
                }
            } else {
                if (startNode.groupName == parentNode.groupName && 
                    startNode.groupValue == parentNode.groupValue &&
                    this.objectsAreEqual(child, record))
                {
                    return false;
                }
                // Don't count group summary rows
                if (!child[this.groupSummaryRecordProperty]) {
                    state.currentIndex++;
                }
            }
        }
        return true;
    },

    // helper method to compare the properties on two objects
    objectsAreEqual : function (object1, object2) {
        for (var key in object1) {
            if (object1[key] != object2[key]) return false;
        }
        return true;
    },

    _rowNumberFieldWidth: 30,
    getRowNumberField : function () {
        var grid = this,
            rnField = {
                // default the width
                width:this._rowNumberFieldWidth,
                rowNumberStart: this.rowNumberStart,
                getAutoFreezePosition: function () { return grid.getRowNumberFieldPosition() }
            }
        ;
        if (this.applyRowNumberStyle) rnField.baseStyle = this.rowNumberStyle;
        isc.addProperties(rnField, this.rowNumberFieldDefaults, this.rowNumberFieldProperties);

        rnField.title = isc.nbsp;

        return rnField;
    },

    getCurrentRowNumberField : function () {
        var fields = this.completeFields || this.fields,
            rnFields = fields.find("name", "_rowNumberField");
        return !rnFields ? null : isc.isAn.Array(rnFields) ? rnFields[0] : rnFields;
    },

    //> @method listGrid.isRowNumberField()
    // Identifies whether the passed-in field is the specially generated
    // +link{listGrid.rowNumberField, rowNumberField} used when +link{showRowNumbers} is
    // true.  Use this method in your custom event handlers to avoid inappropriately
    // performing actions when the rowNumberField is clicked on.
    //
    // @param field (ListGridField) field to test
    // @return (Boolean) whether the provided field is the rowNumberField
    // @group rowNumberField
    // @visibility external
    //<
    isRowNumberField : function (field) {
        if (!field || !field._isRowNumberField) return false;
        else return true;
    },

    // helper function to get the rowNumber field position
    // Appears at the far left of the grid, to the left of the other special fields which are
    // - group summary title field
    // - expansion component icon field
    // - checkbox selection field
    getRowNumberFieldPosition : function () {
        if (this.fieldSourceGrid) return this.fieldSourceGrid.getRowNumberFieldPosition();
        if (!this.shouldShowRowNumberField()) return -1;
        return 0;
    },

    shouldShowRowNumberField : function () {
        // fieldSourceGrid: for cases like the summaryRow / filterEditor where we
        // share field objects across grids (and don't necessarily percolate settings like
        // 'showRowNumbers').
        return this.fieldSourceGrid ? this.fieldSourceGrid.shouldShowRowNumberField()
                                    : (this.showRowNumbers == true);
    },

    //> @attr listGrid.exportRawValues (Boolean : null : IR)
    // Dictates whether the data in this grid should be exported raw by
    // +link{listGrid.exportClientData, exportClientData()}.  If set to true,
    // data will not be processed by field-formatters during exports.
    // Decreases the time taken for large exports.  This property can also be set at the
    // +link{listGridField.exportRawValues, field level}.
    //
    // @visibility external
    //<
    
    //> @attr listGrid.exportRawNumbers (Boolean : null : IR)
    // Dictates whether numeric values should be exported as raw numbers instead of
    // formatted values when using +link{listGrid.exportClientData, exportClientData()}.
    // <P>
    // This property is only consulted if <code>exportRawValues</code> is not set to
    // true at the +link{listGrid.exportRawValues,grid} or
    // +link{listGridField.exportRawValues,field} level. That property causes all values,
    // including numeric values, to be exported unformatted.
    // <P>
    // This is useful for cases where an explicit ListGrid formatter function simply displays the number
    // as a formatted string for the user (for example "1,234"). Exporting that formatted
    // string rather than the underlying numeric value causes spreadsheet applications such as
    // Excel to lose some functionality.
    // <P>
    // If this property is not explicitly set, numeric values will be exported as raw
    // numbers for +link{DSRequest.exportAs,XLS and OOXML export} only.
    // <P>
    // May be overridden at the field level via +link{listGridField.exportRawNumbers}.
    // 
    // @visibility external
    //<

// -----------------------------------------------------------------------------------------
// RowCountDisplay / RowRangeDisplay
//

    //> @groupDef rowRangeDisplay
    // ListGrids are able to create a +link{listGrid.getRowRangeDisplay(),specialized label}
    // that will display the currently visible range of rows in the viewport along with
    // a total row count for the current data set.
    // <P>
    // When +link{dataSource.progressiveLoading,progressive loading is active},
    // the +link{resultSet.getRowCount(),reported row count} for list grid's 
    // data may not accurately reflect the true number of rows in the data set.
    // <P>
    // See +link{type:RowCountStatus} for more details. Note that
    // for custom dataSources where progressive loading is active, the 
    // +link{dsResponse.estimatedTotalRows} may be used to explictly provide either
    // an estimated or exact row count for the data set (distinct from the reported
    // +link{dsResponse.totalRows}.
    // <P>
    // When the true size of the data set is not known, the <code>rowRangeDisplay</code>
    // will format the reported length in a way that indicates it is not an exact count
    // (see +link{listGrid.getFormattedRowCount()}). If +link{listGrid.autoFetchRowCount}
    // is set to <code>true</code>, a separate row count fetch will be intiated as soon
    // as data arrives, so an accurate row count will be displayed as soon as that fetch
    // completes. Alternatively, if +link{listGrid.canRequestRowCount}
    // is set to <code>true</code>, the user may click the label to issue a row count fetch
    // request and get back an accurate row count to display to the user. 
    // <P>
    // As an alternative to using the <code>rowRangeDisplay</code> autoChild, developers 
    // may also make use of various list grid APIs such as +link{listGrid.getRowCountStatus()},
    // +link{listGrid.getRowCount()}, +link{listGrid.getRowRangeDisplayValue()} and
    // +link{listGrid.fetchRowCount()} to directly display or retrieve row counts.
    // 
    // @title Grid row-range and row-count display
    // @visibility external
    // @treeLocation Client Reference/Grids/ListGrid
    //<

    //> @attr listGrid.rowRangeDisplay (RowRangeDisplay AutoChild : null : R)
    // +link{RowRangeDisplay} autoChild, which may be retrieved by calling +link{listGrid.getRowRangeDisplay()}.
    //
    // @group rowRangeDisplay
    // @visibility external
    //<
    rowRangeDisplayConstructor:"RowRangeDisplay", // defined later in this file

    //> @attr listGrid.canRequestRowCount (boolean : false : IRW)
    // Depending on whether +link{dataSource.progressiveLoading} is active,
    // the exact count of available rows
    // may not be known, and <code>canRequestRowCount</code> 
    // controls whether the end user may explicitly request it by clicking
    // the +link{rowRangeDisplay} label.
    // <P>
    // When this property is set to <code>true</code>, the 
    // user may request an accurate row count if one is not
    // currently known by +link{rowRangeDisplay.canRequestRowCount,clicking} 
    // the +link{listGrid.rowRangeDisplay}. To have a row count fetch operation 
    // occur automatically when progressive data is loaded instead of requiring
    // a user interaction to initiate the fetch, see +link{autoFetchRowCount}.
    // <P>
    // Note: This property also acts as a default for 
    // +link{resultSet.applyRowCountToLength}. By default, if set to true, 
    // a user may therefore click the rowRangeDisplay label to request a
    // row count query be executed on the server, and when the query is complete
    // they may scroll the listGrid body freely, retrieving records from anywhere
    // within the data set.
    // <P>
    // If +link{listGrid.applyRowCountToLength} is explicitly set it will
    // be applied to the grid's data object instead of using <code>applyRowCountToLength</code>
    // as a default. For finer grained control, a developer may set both properties
    // to false and manage behavior by explicitly calling +link{listGrid.fetchRowCount()}
    // and +link{resultSet.setFullLength(),listGrid.data.setFullLength()} from application
    // code.
    // 
    // @group rowRangeDisplay
    // @visibility external
    //<
    canRequestRowCount:false,

    //> @attr listGrid.autoFetchRowCount (boolean : false : IRW)
    // Depending on whether +link{dataSource.progressiveLoading} is active, 
    // the exact count of available rows
    // may not be available as part of the standard data fetch response - setting
    // <code>autoFetchRowCount:true</code> will cause a fetch for an accurate row count to be issued
    // as soon as data arrives (from a +link{dsResponse.progressiveLoading,progressive dataSource response})
    // without an accurate row count. This value will then be available for display in the
    // +link{rowRangeDisplay} label.
    // <P>
    // To allow users to request an accurate row count by clicking
    // the +link{rowRangeDisplay} instead of kicking off a row count fetch automatically,
    // use +link{canRequestRowCount}.
    // <P>
    // The <code>autoFetchRowCount</code> value will be passed through to the 
    // +link{ResultSet.autoFetchRowCount,ResultSet data object}
    // which is responsible for issuing the row count fetch(es) at appropriate times.
    //
    // @visibility external
    // @group rowCountDisplay
    //<

    //> @attr listGrid.applyRowCountToLength (Boolean : null : IRW)
    // This property allows developers to explicitly set +link{resultSet.applyRowCountToLength}
    // for this grid's data object.
    // <P>
    // If not explicitly specified this will be derived from +link{listGrid.canRequestRowCount}
    // @group rowRangeDisplay
    // @visibility external
    //<

    //> @attr listGrid.blockingRowCountFetch (Boolean : null : IRW)
    // If specified, this attribute will be applied to this grid's +link{resultSet.blockingRowCountFetch,data object}
    // for dataBound grids.
    //
    // @group rowRangeDisplay
    // @visibility external
    //<

    
    //> @method listGrid.getRowRangeDisplay()
    // This method will create and return a +link{class:RowRangeDisplay} autoChild
    // with +link{rowRangeDisplay.sourceGrid} set to this listGrid.
    // <P>
    // Note that this method will only create one rowRangeDisplay instance. Calling
    // it repeatedly will return the same canvas.
    //
    // @return (RowRangeDisplay) RowRangeDisplay component
    // @group rowRangeDisplay
    // @visibility external
    //<
    getRowRangeDisplay : function () {
        if (this.rowRangeDisplay == null || this.rowRangeDisplay.destroyed) {
            this.rowRangeDisplay = this.createAutoChild("rowRangeDisplay", {
                sourceGrid:this,
                canRequestRowCount:this.canRequestRowCount
            });
        }
        return this.rowRangeDisplay;
    },

    //> @type RowRangeDisplayStyle 
    // Governs how +link{listGrid.getRowRangeDisplayValue()} formats the row range
    // and row count for display
    //
    // @value "full" The +link{listGrid.fullRowRangeDisplayValue} template will be used
    //   to display both row range and row count
    // @value "brief" The +link{listGrid.briefRowRangeDisplayValue} template will be used
    //   to display both row range and row count
    // @value "countOnly" The +link{listGrid.getFormattedRowCount()} will be displayed
    //      with no other text.
    // @value "rangeOnly" The +link{listGrid.getFormattedRowRange()} will be displayed
    //      with no other text.
    // @group rowRangeDisplay
    // @visibility external
    //<

    //> @attr listGrid.rowRangeDisplayStyle (RowRangeDisplayStyle : "full" : IRW)
    // How should the +link{getFormattedRowRange()} format the row range
    // and row count for display to the user?
    // @group rowRangeDisplay
    // @visibility external
    //<
    rowRangeDisplayStyle:"full",

    //> @attr listGrid.fullRowRangeDisplayValue (String : "Showing ${rowRange} of ${rowCount} rows" : IRW)
    // Dynamic String specifying the format for the 
    // +link{getRowRangeDisplayValue(),row range summary value} when 
    // +link{rowRangeDisplayStyle} is set to <code>"full"</code>.
    // <P>
    // The following variables are available for evaluation within this string:
    // <ul><li><code>rowRange</code>: the +link{getFormattedRowRange(),formatted row range}</li>
    //     <li><code>rowCount</code>: the +link{getFormattedRowCount(),formatted row count}</li></ul>
    // @visibility external
    // @group i18nMessages
    //<
    fullRowRangeDisplayValue:"Showing ${rowRange} of ${rowCount} rows",

    //> @attr listGrid.briefRowRangeDisplayValue (String : "${rowRange} of ${rowCount}" : IRW)
    // Dynamic String specifying the format for the 
    // +link{getRowRangeDisplayValue(),row range summary value} when 
    // +link{rowRangeDisplayStyle} is set to <code>"brief"</code>.
    // <P>
    // The following variables are available for evaluation within this string:
    // <ul><li><code>rowRange</code>: the +link{getFormattedRowRange(),formatted row range}</li>
    //     <li><code>rowCount</code>: the +link{getFormattedRowCount(),formatted row count}</li></ul>
    // @visibility external
    // @group i18nMessages
    //<    
    briefRowRangeDisplayValue:"${rowRange} of ${rowCount}",

    //> @attr listGrid.emptyRowRangeDisplayValue (String : "&nbsp;" : IRW)
    // +link{getRowRangeDisplayValue(),Row range summary display value} when the grid is empty.
    // @visibility external
    // @group i18nMessages
    //<    
    emptyRowRangeDisplayValue:"&nbsp;",

    //> @method listGrid.getRowRangeDisplayValue()
    // This method will return a row range summary display value containing the
    // currently visible row range and row count for the data set.
    // <P>
    // The +link{rowRangeDisplay} label autoChild shows this value as its contents.
    // <P>
    // The format of the display value is governed by the +link{rowRangeDisplayStyle}
    //
    // @return (String) formatted row range summary value
    // @group rowRangeDisplay
    // @visibility external
    //<
    getRowRangeDisplayValue : function () {

        if (this.isEmpty()) return this.emptyRowRangeDisplayValue;

        var style = this.rowRangeDisplayStyle;
        if (style == "countOnly") {
            return this.getFormattedRowCount();
        }
        if (style == "rangeOnly") {
            return this.getFormattedRowRange();
        }

        // get the appropriate template and evaluate it
        var summaryTemplate = style == "full" ? this.fullRowRangeDisplayValue : this.briefRowRangeDisplayValue;

        return  summaryTemplate.evalDynamicString(
                    this, 
                    {rowCount:this.getFormattedRowCount(), rowRange:this.getFormattedRowRange()}
                );
    },

    // rowRangeDisplayValueChanged: Observable method fired whenever getRowRangeDisplayValue() will return
    // a new value thanks to dataChanged or scrolling

    rowRangeDisplayValueChanged : function (reason) {
//!DONTOBFUSCATE  (legal to observe and pick up params)

    },

    //> @attr listGrid.rowRangeFormat (String : "${startRow}-${endRow}" : IRW)
    // Dynamic String specifying the format for the 
    // +link{getFormattedRowRange(),visible row range}.
    // <P>
    // The following variables are available for evaluation within this string:
    // <ul><li><code>startRow</code>: first visible row in the viewport as a 
    //         +link{isc.NumberUtil.toLocalizedString(),formatted string}</li>
    //     <li><code>endRow</code>: last visible row in the viewport as a 
    //         +link{isc.NumberUtil.toLocalizedString(),formatted string}</li></ul>
    // @visibility external
    // @group i18nMessages
    //<
    rowRangeFormat:"${startRow}-${endRow}",

    //> @method listGrid.getFormattedRowRange()
    // Uses the +link{rowRangeFormat} to return a formatted display 
    // value showing the currently visible set of rows in the listGrid viewport.
    // <P>
    // If this listGrid has never been drawn, so has no meaningful "viewport",
    // this method will return an empty string.
    // <P>
    // See also +link{getRowRangeDisplayValue()}
    //
    // @return (String) formatted row range value
    // @visibility external
    //<
    getFormattedRowRange : function () {
        if (!this.body) return "";
        var visibleRows = this.getVisibleRows();
        var startRow = isc.NumberUtil.toLocalizedString(visibleRows[0]+1),
            endRow = isc.NumberUtil.toLocalizedString(visibleRows[1]+1);

        return this.rowRangeFormat.evalDynamicString(
                    this, {startRow:startRow, endRow:endRow}
               );
    },

    childResized : function (child, deltaX, deltaY, reason) {
        // Whenever the body viewport size changes (likely due to the grid as a whole resizing, but could
        // also come from showFilterEditor, etc), refresh our visible row range if necessary
        if (child == this.body && deltaY != null && deltaY != 0 &&
            this.rowRangeDisplayStyle != "countOnly") 
        {
            this.rowRangeDisplayValueChanged("Body resized");
        }
        return this.Super("childResized", arguments);
    },

    //> @attr listGrid.unknownRowCountDisplayValue (String : "many" : IRW)
    // Value to return from +link{getFormattedRowCount()} when the row count is unknown
    // @group i18nMessages
    // @visibility external
    //<
    unknownRowCountDisplayValue:"many",


    //> @attr listGrid.loadingRowCountDisplayIcon (SCImgURL : "[SKINIMG]/loading_horizontal.gif" : IRW)
    // The URL of the icon to display as a +link{getFormattedRowCount(),row count value} when
    // the row count is loading.
    //
    // @group rowRangeDisplay
    // @visibility external
    //<
    loadingRowCountDisplayIcon: "[SKINIMG]/loading_horizontal.gif",

    //> @attr listGrid.loadingRowCountDisplayIconWidth (Number : 16 : IRW)
    // Width for the +link{loadingRowCountDisplayIcon} 
    //
    // @group rowRangeDisplay
    // @visibility external
    //<
    loadingRowCountDisplayIconWidth: 16,

    //> @attr listGrid.loadingRowCountDisplayIcoHeight (Number : 16 : IRW)
    // Height for the +link{loadingRowCountDisplayIcon} 
    //
    // @group rowRangeDisplay
    // @visibility external
    //<
    loadingRowCountDisplayIconHeight: 16,

    //> @attr listGrid.exactRowCountFormat (String : "${rowCount}" : IRW)
    // Format for the string returned from +link{getFormattedRowCount()} when
    // +link{getRowCountStatus(),row count status} is <code>"exact"</code>.
    // <P>
    // The variable <code>rowCount</code> is available for evaluation within
    // this string and will be set to the +link{getRowCount(),current row count} 
    // as a +link{isc.NumberUtil.toLocalizedString(),locale-formatted number}.
    // 
    // @group rowRangeDisplay
    // @visibility external
    //<
    exactRowCountFormat:"${rowCount}",

    //> @attr listGrid.minimumRowCountFormat (String : "${rowCount}+" : IRW)
    // Format for the string returned from +link{getFormattedRowCount()} when
    // +link{getRowCountStatus(),row count status} is <code>"minimum"</code>.
    // <P>
    // The variable <code>rowCount</code> is available for evaluation within
    // this string and will be set to the +link{getRowCount(),current row count} 
    // as a +link{isc.NumberUtil.toLocalizedString(),locale-formatted number}.
    //
    // @group rowRangeDisplay
    // @visibility external
    //<
    minimumRowCountFormat:"${rowCount}+",

    //> @attr listGrid.approximateRowCountFormat (String : "~${rowCount}" : IRW)
    // Format for the string returned from +link{getFormattedRowCount()} when
    // +link{getRowCountStatus(),row count status} is <code>"approximate"</code>.
    // <P>
    // The variable <code>rowCount</code> is available for evaluation within
    // this string and will be set to the +link{getRowCount(),current row count} 
    // as a +link{isc.NumberUtil.toLocalizedString(),locale-formatted number}.
    //
    // @group rowRangeDisplay
    // @visibility external
    //<
    approximateRowCountFormat:"~${rowCount}",

    //> @attr listGrid.maximumRowCountFormat (String : "-${rowCount}" : IRW)
    // Format for the string returned from +link{getFormattedRowCount()} when
    // +link{getRowCountStatus(),row count status} is <code>"maximum"</code>.
    // <P>
    // The variable <code>rowCount</code> is available for evaluation within
    // this string and will be set to the +link{getRowCount(),current row count} 
    // as a +link{isc.NumberUtil.toLocalizedString(),locale-formatted number}.
    //
    // @group rowRangeDisplay
    // @visibility external
    //<
    maximumRowCountFormat:"-${rowCount}",

    //> @attr listGrid.rangeRowCountFormat (String : "${minRowCount}-${maxRowCount}" : IRW)
    // Format for the string returned from +link{getFormattedRowCount()} when
    // +link{getRowCountStatus(),row count status} is <code>"range"</code>.
    // <P>
    // The following variables are available for evaluation within this string:
    // <ul><li><code>minRowCount</code>: the lower bound of this row count value
    //         from +link{getRowCountRange(),getRowCountRange()[0]},
    //         as a +link{isc.NumberUtil.toLocalizedString(),locale-formatted number}.</li>
    //     <li><code>minRowCount</code>: the upper bound of this row count value
    //         from +link{getRowCountRange(),getRowCountRange()[1]},
    //         as a +link{isc.NumberUtil.toLocalizedString(),locale-formatted number}.</li></ul>
    //
    // @group rowRangeDisplay
    // @visibility external
    //<
    rangeRowCountFormat:"${minRowCount}-${maxRowCount}",

    //> @attr listGrid.rowCountDisplayPrecision (Integer : null : IRW)
    // When an exact +link{listGrid.getRowCount(),row count} is not known due
    // to progressive loading, this attribute allows the formatted row count
    // returned by +link{getFormattedRowCount()} and ultimately displayed in 
    // the +link{listGrid.rowRangeDisplay,rowRangeDisplay label} to be rounded to
    // a multiple of the specified value. If not explicitly set, this value
    // defaults to the +link{resultSet.resultSize,page size} for the data.
    // <P>
    // For example if the server reports a +link{dsResponse.totalRows}
    // of <code>320</code> while progressive loading is active (meaning this is not an
    // exact row count), and <code>rowCountDisplayPrecision</code> is set to
    // <code>150</code>, the formatted rowCount may display <code>300+</code>
    // <P>
    // The precision will round either up or down depending on 
    // the +link{getRowCountStatus(),row count status}.
    // <ul><li><code>rowCountStatus:"exact"</code> - this setting has no effect</li>
    //     <li><code>rowCountStatus:"minimum"</code> - the reported row count will be 
    //         rounded down to the previous multiple of this value.</li>
    //     <li><code>rowCountStatus:"maximum"</code> - the reported row count will be 
    //         rounded up to the next multiple of this value.</li>
    //     <li><code>rowCountStatus:"approximate"</code> - the reported row count will be 
    //         rounded either up or down to the nearest multiple of this value.</li>
    //     <li><code>rowCountStatus:"range"</code> - the reported minimum row count will be 
    //         rounded down to the next multiple of this value, and the reported maximum
    //         will be rounded up to the next multiple of this value.</li>
    // </ul>
    // Note the formatted row count will never be rounded down to zero - if the row count
    // is less than the <code>rowCountDisplayPrecision</code>, the exact reported row count 
    // value will be displayed. This could typically only occur if <code>rowCountDisplayPrecision</code>
    // is more than the +link{resultSet.resultSize,page size} for the data.
    // <P>
    // This value may be set to <code>1</code> to effectively disable the rounding behavior
    // altogether (the row count will not be displayed exactly as reported).
    // <P>
    // Note that this is purely a formatting setting for the formatted row count string.
    // It has no impact on the behavior of the grid in terms of 
    // the reported +link{resultSet.getLength(),data length}, 
    // +link{listGrid.getTotalRows(),totalRows} or scrollable area.
    //
    // @group rowRangeDisplay
    // @visibility external
    //<
    // rowCountDisplayPrecision:1,

    //> @method listGrid.getFormattedRowCount()
    // Returns the +link{listGrid.getRowCount(),current total row count} for
    // this grid as a formatted string.
    // <P>
    // Due to +link{dataSource.progressiveLoading,progressiveLoading},
    // an exact total row count may not be available. Depending on the 
    // current +link{getRowCountStatus(),rowCount status}, this method will return
    // a value in one of the following formats. Note that if the row count is not
    // exact, the numeric value will be rounded to the nearest multiple of 
    // +link{rowCountDisplayPrecision}.
    // <ul>
    //  <li><code>"exact"</code>: The row count will be formatted using +link{exactRowCountFormat}</li>
    //  <li><code>"minimum"</code>: The row count will be formatted using +link{minimumRowCountFormat}</li>
    //  <li><code>"approximate"</code>: The row count will be formatted using +link{approximateRowCountFormat}</li>
    //  <li><code>"maximum"</code>: The row count will be formatted using +link{maximumRowCountFormat}</li>
    //  <li><code>"range"</code>: The row count range will be formatted using +link{rangeRowCountFormat}</li>
    //  <li><code>"unknown"</code>: The +link{unknownRowCountDisplayValue} will be displayed</li>
    //  <li><code>"loading"</code>: The +link{loadingRowCountDisplayIcon} will be displayed</li>
    // </ul>
    // See also +link{listGrid.getRowRangeDisplayValue()}.
    // 
    // @return (String) the formatted rowCount display value
    // @group rowRangeDisplay
    // @visibility external
    //<
    getFormattedRowCount : function () {

        var status = this.getRowCountStatus();
        if (status == "unknown") {
            return this.unknownRowCountDisplayValue;
        }
        if (status == "loading") {
            return this.imgHTML({
                src:this.loadingRowCountDisplayIcon,
                width:this.loadingRowCountDisplayIconWidth,
                height:this.loadingRowCountDisplayIconHeight
            });
        }

        // In this case we're going to use a formatted value
        if (status == "range") {
            var totalRowRange = this.getRowCountRange(),
                min = this._applyRowCountDisplayPrecision(totalRowRange[0],"minimum"),
                max = this._applyRowCountDisplayPrecision(totalRowRange[1],"maximum");
            return this.rangeRowCountFormat.evalDynamicString(
                    this, 
                    {   
                        minRowCount:isc.NumberUtil.toLocalizedString(min), 
                        maxRowCount:isc.NumberUtil.toLocalizedString(max)
                    }
            );

        } else {

            var totalRows = this._applyRowCountDisplayPrecision(this.getRowCount(), status);
            totalRows = isc.NumberUtil.toLocalizedString(totalRows);

            var format = this.exactRowCountFormat;
            switch (status) {
                case "minimum" :
                    format = this.minimumRowCountFormat;
                    break;
                case "approximate" :
                    format = this.approximateRowCountFormat;
                    break;
                case "maximum" :
                    format = this.maximumRowCountFormat;
                    break;
            }
            return format.evalDynamicString(this, {rowCount:totalRows});
        }
    },

    _applyRowCountDisplayPrecision : function (totalRows, status) {
        if (totalRows == null) return totalRows; // sanity check for bad values
        if (status == "exact") return totalRows;

        // Round the value if configured to do so:
        var precision = this.rowCountDisplayPrecision;
        // default to data page size
        if (precision == null) {
            precision = this.data ? this.data.resultSize : this.dataPageSize;
        }
        if (precision == null || precision == 1 || precision == 0) return totalRows;

        var multiple = 0;
        if (status == "approximate") {
            multiple = Math.round(totalRows/precision);
        } else if (status == "maximum") {
            multiple = Math.ceil(totalRows/precision);
        } else if (status == "minimum") {
            multiple = Math.floor(totalRows/precision);
        }
        if (multiple == 0) return totalRows;
        return (multiple*precision);
    },

    //> @method listGrid.getRowCount()
    // Retrieves the +link{resultSet.getRowCount(),row count} for the grid, which
    // may differ from the reported +link{resultSet.getLength(),data length} if 
    // +link{dataSource.progressiveLoading,progressive loading} is enabled.
    // <P>
    // See also +link{getRowCountStatus()}
    //
    // @return (Integer) current row count for the grid
    // @group rowRangeDisplay
    // @visibility external
    //<
    getRowCount : function () {
        if (this.data && this.data.getRowCount) return this.data.getRowCount();
        return this.data && this.data.getLength() || 0;
    },

    //> @method listGrid.getRowCountRange()
    // Retrieves the +link{resultSet.getRowCountRange(),row count range} for 
    // listGrids where +link{dataSource.progressiveLoading,progressive loading} is
    // active and the row count has been specified as a +link{resultSet.getRowCountStatus(),range}.
    // <P>
    // The returned value will be a two element array, containing the min and max bounds
    // for the row-count. Note that if the row count has not been recorded as a range,
    // the first element in the array will be the +link{getRowCount(),row count}, and
    // the second element will be null.
    // @return (Array of Integer) minimum and maximum bounds for the row count
    // @group rowRangeDisplay
    // @visibility external
    //<
    getRowCountRange : function () {
        if (this.data && this.data.getRowCountRange) return this.data.getRowCountRange();
        return [this.getRowCount(),null];
    },

    //> @method listGrid.getRowCountStatus()
    // This method indicates whether +link{listGrid.getRowCount()} reflects an accurate
    // row-count for this listGrid. An accurate row count may not currently be available
    // if +link{dataSource.progressiveLoading,progressiveLoading} is active.
    // <P>
    // See +link{type:RowCountStatus} for further details.
    //
    // @return (RowCountStatus) Current row-count status for this grid
    // @group rowRangeDisplay
    // @visibility external
    //<
    getRowCountStatus : function () {
        // The ResultSet deals with retrieving the fetch responses
        // and tracks the estimatedTotalRows returned by the server.
        if (this.data && this.data.getRowCountStatus != null) return this.data.getRowCountStatus();
        if (this.data && this.data.lengthIsKnown != null && !this.data.lengthIsKnown()) return "unknown";
        return "exact";
    },

    //> @method listGrid.fetchRowCount()
    // For databound grids, method will fall through to +link{resultSet.fetchRowCount()}, allowing
    // developers to request an accurate row count from the dataSource when
    // +link{dataSource.progressiveLoading,progressive loading is active}.
    //
    // @param [callback] (RowCountCallback) Callback to fire when the fetch request completes.
    //  To retrieve details of the row-count that was retrieved from the server, use
    //  the <code>getRowCount()</code> and <code>getRowCountStatus()</code> methods.
    // @param [dsRequest] (DSRequest Properties) Custom properties for the row count fetch request
    //
    // @group rowRangeDisplay
    // @visibility external
    //<
    fetchRowCount : function (callback, dsRequest) {
        if (this.data && this.data.fetchRowCount) this.data.fetchRowCount(callback, dsRequest);
    },

// -----------------------------------------------------------------------------------------
// Expando Rows
//

    //> @type ExpansionComponentPoolingMode
    // The method of pooling to employ for +link{listGrid.canExpandRecords,expansionComponents}.
    // <P>
    // @value "destroy" auto-created, built-in components are destroyed when record are
    //        +link{listGrid.collapseRecord,collapsed}.
    // @value "none" all expansion components are deparented from the grid when a record is
    //        +link{listGrid.collapseRecord,collapsed} but are not destroyed.  It is the responsibility
    //        of the developer to handle component destruction
    // @visibility external
    //<

    //> @attr listGrid.expansionComponentPoolingMode (ExpansionComponentPoolingMode : "destroy" : IRWA)
    // The method of +link{type:RecordComponentPoolingMode, component-pooling} to employ for
    // +link{canExpandRecords,expansionComponents}.
    // <P>
    // The default mode is "destroy", which means that automatically created expansionComponents
    // are destroyed when rows are collapsed.
    //
    // @visibility external
    //<
    expansionComponentPoolingMode: "destroy",

    
    destroyCustomExpansionComponents: false,

    //> @attr listGrid.canExpandRecords (Boolean : false : IRW)
    // When set to true, shows an additional field at the beginning of the field-list
    // (respecting RTL) to allow users to expand and collapse individual records.
    // See +link{listGrid.expandRecord()} and +link{listGrid.expansionMode} for details
    // on record expansion.
    // <P>
    // +link{listGrid.virtualScrolling} is automatically enabled when canExpandRecords is
    // set to true.
    // <P>
    // Note that expanded records are not currently supported in conjunction
    // with +link{listGridField.frozen,frozen fields}.
    //
    // @group expansionField
    // @visibility external
    //<

    //> @attr listGrid.canExpandMultipleRecords (Boolean : true : IRW)
    // When +link{listGrid.canExpandRecords} is true, this property indicates whether multiple
    // records can be expanded simultaneously.  If set to false, expanding a record will
    // automatically collapse any record which is already expanded.  The default value is
    // <code>true</code>.
    //
    // @group expansionField
    // @visibility external
    //<
    canExpandMultipleRecords: true,

    //> @attr listGrid.maxExpandedRecords (Integer : null : IRW)
    // When +link{listGrid.canExpandRecords} and +link{listGrid.canExpandMultipleRecords} are
    // both true, this property dictates the number of
    // records which can be expanded simultaneously.  If the expanded record count hits the
    // value of this property, further attempts to expand records will result in a popup
    // warning (see +link{listGrid.maxExpandedRecordsPrompt}) and expansion will be cancelled.
    // <P>
    // The default value is null, meaning there is no limit on the number of expanded records.
    //
    // @group expansionField
    // @visibility external
    //<

    //> @attr listGrid.maxExpandedRecordsPrompt (HTMLString : "This grid is limited to ${count} simultaneously expanded records.  Please collapse some expanded records and retry." : IR)
    // This is a dynamic string - text within <code>&#36;{...}</code> will be evaluated as JS code
    // when the message is displayed. Note that the local variable <code>count</code> will be
    // available and set to this.maxExpandedRecords. The string will be executed in the scope of the
    // ListGrid so <code>this</code> may also be used to determine other information about this grid.
    // <P>
    // Default value returns <P>
    // <code>
    // <i>This grid is limited to <code>[+link{listGrid.maxExpandedRecords}]</code> simultaneously
    // expanded records.  Please collapse some expanded records and retry.</i>
    // </code>
    // @visibility external
    // @group i18nMessages
    //<
    maxExpandedRecordsPrompt: "This grid is limited to ${count} simultaneously expanded records.  Please collapse some expanded records and retry.",

    //> @type ExpansionMode
    // When +link{ListGrid.canExpandRecords, canExpandRecords} is true, ExpansionMode
    // dictates the type of UI to be displayed in the expanded portion of the row.
    // <P>
    // There are a number of builtin ExpansionModes and you can override
    // +link{listGrid.getExpansionComponent, getExpansionComponent()} to create your own
    // expansion behaviors.
    //
    //  @value  "detailField"  Show a single field's value in an +link{class:HtmlFlow}. Field
    //      to use is +link{listGrid.detailField}.
    //  @value  "details"   Show a +link{class:DetailViewer} displaying those fields from the
    //      record which are not already displayed in the grid.
    //  @value  "related"    Show a separate +link{class:ListGrid} containing related-records.
    //      See +link{ListGridRecord.detailDS} and +link{ListGrid.recordDetailDSProperty} for
    //      more information.
    //  @value  "editor"    Show a +link{class:DynamicForm} to edit those fields from the
    //      record which are not already present in the grid.  If the record is collapsed with
    //      unsaved changes and +link{listGrid.expansionEditorShowSaveDialog} is not set, Edits
    //      will be saved automatically, or stored as +link{group:editing,editValues} if
    //      +link{listGrid.autoSaveEdits} is false.  Otherwise, a confirmation dialog is
    //      displayed.  Can optionally show a
    //      +link{listGrid.showExpansionEditorSaveButton,save button} and
    //      +link{listGrid.expansionEditorCollapseOnSave,auto-collapse} when save is pressed.
    //      If a record fails validation on save and the field in question is not visible in
    //      the grid, the record is automatically expanded and validated to show the errors.
    //  @value  "detailRelated"    Show a +link{class:DetailViewer} displaying those fields
    //      from the record not already displayed in the grid, together with a separate
    //      +link{class:ListGrid} containing related-records.
    // @group expansionField
    // @visibility external
    //<

    //> @attr listGrid.detailField (String : null : IRW)
    // The field whose contents to show in the expanded portion of a record when
    // +link{listGrid.canExpandRecords, canExpandRecords} is <code>true</code> and
    // +link{type:ExpansionMode, listGrid.expansionMode} is <code>detailField</code>.
    // @group expansionField
    // @visibility external
    //<

    //> @attr listGrid.expansionMode (ExpansionMode : null : IRW)
    // The +link{ExpansionMode} for records in this grid.
    // <p>
    // If +link{ListGrid.canExpandRecords, canExpandRecords} is true but <code>expansionMode</code>
    //  is not set, it defaults to "detailRelated" if +link{listGrid.detailDS} is set, or to 
    // "details" otherwise.
    // @group expansionField
    // @visibility external
    //<

    //> @attr listGrid.expansionField (AutoChild ListGridField : null : IRWA)
    // The field providing the facility to expand and collapse rows.
    // @group expansionField
    // @visibility external
    //<
    expansionFieldDefaults: {
        name: "_expansionField",
        canEdit: false,
        canFilter: false,
        canGroupBy: false,
        canSort: false,
        canExport: false,
        canHide: false,
        canReorder: false,
        canDragResize: false,
        // make this special field canHilite false so we don't see it in HiliteEditors
        canHilite: false,
        _isExpansionField: true,
        showDefaultContextMenu: false,
        keyboardFiresRecordClick: false,
        cellAlign: "center",
        summaryValue: "&nbsp;",
        // specifically disable filterOperators for this builtin field
        allowFilterOperators: false,
        
        cellMouseDown : function (viewer, record, rowNum, colNum) {
            if (!viewer.canExpandRecords || record._isGroup) return;
            if (!viewer._canExpandRecord(record, viewer.getRecordIndex(record))) return;
            if (viewer.isExpanded(record)) viewer.collapseRecord(record);
            else viewer.expandRecord(record);
        },
        formatCellValue : function (value, record, rowNum, colNum, grid) {
            // This ensures that if we're looking at an edit row for a new record we
            // don't show the expansion icon
            record = grid.getCellRecord(rowNum, colNum);
            if (record == null || record._isGroup) return null;
            if (!grid._canExpandRecord(record, rowNum)) return null;
            var src = grid.isExpanded(record) ? grid.expansionFieldTrueImage : grid.expansionFieldFalseImage
            var state;
            if (grid.expansionFieldImageShowSelected && grid.isSelected(record, rowNum)) {
                state = "selected";
            }
            if (grid.expansionFieldImageShowRTL && grid.isRTL()) {
                state = state == null ? "rtl" : state + "_rtl";
            }
            if (state != null) {
                src = isc.Img.urlForState(src, null, null, null, null, state);
            }
            return grid.getValueIconHTML(src, grid.expansionFieldImageStyle, this, isc.Canvas.HAND);
        },
        autoFreeze: true,
        // disable this from ever being assigned as the treeField
        treeField:false,
        // flag that means this is a special builtin field, not for formulas/export/etc
        featureField: true
    },

    // Helper method - should this grid show the special expansion field when canExpandRecords is true
    shouldShowExpansionField : function () {
        return this.fieldSourceGrid ? this.fieldSourceGrid.shouldShowExpansionField()
                                    : this.canExpandRecords;
    },

    //> @attr listGrid.expansionFieldTrueImage (SCImgURL : null :IRWA)
    // If +link{listGrid.canExpandRecords} is set to <code>true</code>, this property
    // determines the image to display in the expansion field for expanded rows.
    // If unset, the +link{listGrid.booleanTrueImage} will be used.
    // @see listGrid.expansionFieldFalseImage
    // @see listGrid.expansionFieldImageWidth
    // @see listGrid.expansionFieldImageHeight
    // @group expansionField
    // @visibility external
    //<
    expansionFieldTrueImage: "[SKINIMG]/ListGrid/group_opened.gif",

    //> @attr listGrid.expansionFieldFalseImage (SCImgURL : null :IRWA)
    // If +link{listGrid.canExpandRecords} is set to <code>true</code>, this property
    // determines the image to display in the expansion field for collapsed rows.
    // If unset, the +link{listGrid.booleanFalseImage} will be used.
    // @see listGrid.expansionFieldTrueImage
    // @see listGrid.expansionFieldImageWidth
    // @see listGrid.expansionFieldImageHeight
    // @group expansionField
    // @visibility external
    //<
    expansionFieldFalseImage: "[SKINIMG]/ListGrid/group_opening.gif",

    //> @attr listGrid.expansionFieldImageShowRTL (boolean : false : IRA)
    // If this grid is in RTL mode, should an "_rtl" suffix be added to the +link{expansionFieldTrueImage,expansionFieldTrueImage}
    // and +link{expansionFieldFalseImage,expansionFieldFalseImage} image URLs? This should only
    // be enabled if RTL media for the true and false expansion field images are available.
    // <P>
    // If both this property and +link{expansionFieldImageShowSelected} are true, and
    // the grid is in RTL mode, both suffixes will be applied to selected rows'
    // expansion field images (combined as "selected_rtl").
    //
    // @group RTL
    // @group expansionField
    // @visibility external
    //<
    expansionFieldImageShowRTL: false,

    //> @attr listGrid.expansionFieldImageShowSelected (boolean : false : IRA)
    // Should a "_selected" suffix be added to the 
    // +link{expansionFieldTrueImage,expansionFieldTrueImage}
    // and +link{expansionFieldFalseImage,expansionFieldFalseImage} image URLs for
    // selected rows?
    // <P>
    // This allows developers to provide separate expansion field media for selected
    // rows, in case the selected row style does not contrast well with the standard
    // expansion field image media.
    // <P>
    // If both this property and +link{expansionFieldImageShowRTL} are true, and
    // the grid is in RTL mode, both suffixes will be applied to selected rows'
    // expansion field image (combined as "selected_rtl")
    //
    // @group expansionField
    // @visibility external
    //<
    expansionFieldImageShowSelected: false,


    //> @attr listGrid.expansionFieldImageWidth (Integer : null : IR)
    // If +link{listGrid.canExpandRecords} is set to <code>true</code>, this property
    // may be set to govern the width of the expansion image displayed to indicate whether a row
    // is expanded. If unset, the expansionField image will be sized to match the
    // +link{listGrid.booleanImageWidth} for this grid.
    // @group expansionField
    // @visibility external
    //<

    //> @attr listGrid.expansionFieldImageHeight (Integer : null : IR)
    // If +link{listGrid.canExpandRecords} is set to <code>true</code>, this property
    // may be set to govern the height of the expansion image displayed to indicate whether a
    // row is expanded. If unset, the expansionField image will be sized to match the
    // +link{listGrid.booleanImageHeight} for this grid.
    // @group expansionField
    // @visibility external
    //<

    //> @attr listGrid.expansionFieldImageStyle (CSSStyleName : null : [IRW])
    // Custom style to apply to the image in the +link{expansionField} displayed in 
    // collapsible rows when +link{listGrid.canExpandRecords} is true.  Affects the icons 
    // provided by +link{expansionFieldTrueImage} and +link{expansionFieldFalseImage}.
    // @group appearance
    // @visibility external
    //<

    //> @method listGrid.getExpansionField()
    // Returns the specially generated expansion field used when +link{canExpandRecords} is
    // true.
    // <P>
    // Called during +link{setFields()}, this method can be overridden to add advanced dynamic
    // defaults to the expansion field (call Super, modify the default field returned by Super,
    // return the modified field).  Normal customization can be handled by just setting
    // +link{AutoChild} properties, as mentioned under the docs for +link{listGrid.expansionField}.
    //
    // @return (ListGridField)
    // @group expansionField
    // @visibility external
    //<
    // the amount to add to the icon width to get the expansion field width
    expansionFieldExtraWidth: 16,
    getExpansionField : function () {
        var grid = this,
            expField = {
                excludeFromState:true,
                // default the width to the width of the icon plus an arbitrary buffer
                width: this._getExpansionFieldImageWidth() + this.expansionFieldExtraWidth,
                getAutoFreezePosition: function () { return grid.getExpansionFieldPosition() }
            }
        ;

        // if expansionFieldImageWidth/Height are set on this grid, pass them through to the field
        expField.valueIconWidth = this._getExpansionFieldImageWidth();
        expField.valueIconHeight = this._getExpansionFieldImageHeight();

        // combine the properties for the field using the autoChild pattern
        isc.addProperties(expField, this.expansionFieldDefaults, this.expansionFieldProperties);

        expField.title = isc.nbsp;

        return expField;
    },

    getCurrentExpansionField : function () {
        var fields = this.completeFields || this.fields,
            expFields = fields.find("name", "_expansionField");
        return !expFields ? null : isc.isAn.Array(expFields) ? expFields[0] : expFields;
    },

    _getExpansionFieldImageWidth : function () {
        return this.expansionFieldImageWidth || this.booleanImageWidth ||
                (isc.CheckboxItem ? isc.CheckboxItem.getInstanceProperty("valueIconWidth") : null);
    },
    _getExpansionFieldImageHeight : function () {
        return this.expansionFieldImageHeight || this.booleanImageHeight ||
                (isc.CheckboxItem ? isc.CheckboxItem.getInstanceProperty("valueIconHeight") : null);
    },

    //> @method listGrid.isExpansionField()
    // Identifies whether the passed-in field is the specially generated
    // +link{listGrid.expansionField,expansionField} used when +link{canExpandRecords} is
    // true.  Use this method in your custom event handlers to avoid inappropriately
    // performing actions when the expansionField is clicked on.
    //
    // @param field (ListGridField) field to test
    // @return (Boolean) whether the provided field is the expansion field
    // @group expansionField
    // @visibility external
    //<
    isExpansionField : function (field) {
        if (!field) return false;
        var fieldObj = this.getField(field);
        if (fieldObj && fieldObj._isExpansionField) return true;
        return false;
    },

    // helper function to get the expansion field position
    // This is one of the fields that appears "stuck" to the left of the grid - these are
    // - row number field
    // - group summary title field
    // - expansion field
    // - checkbox selection field
    getExpansionFieldPosition : function () {
        if (this.fieldSourceGrid != null) return this.fieldSourceGrid.getExpansionFieldPosition();

        if (!this.shouldShowExpansionField()) return -1;
        
        var pos = 0;
        if (this.shouldShowRowNumberField())  pos++;
        if (this.shouldShowDragHandleField()) pos++;
        if (this.shouldShowCheckboxField())   pos++;
        return pos;
    },

    _canExpandRecord : function (record,rowNum) {
        if (record == null) record = this.getRecord(rowNum);
        if (record == null) return false;
        return this.canExpandRecord(record,rowNum);
    },
    //> @method listGrid.canExpandRecord()
    // Indicates whether a given record or rowNum can be expanded.  The default implementation
    // checks the value of +link{listGrid.canExpandRecords} and
    // <code>record[+link{listGrid.canExpandRecordProperty}]</code>.
    // <P>
    // Override this method for more specific control over individual record expansion.
    // <P>
    // <b>Note:</b> Rows with no underlying record in the data array - for example newly
    // added edit rows that have not yet been saved - cannot be expanded.
    //
    // @param record (ListGridRecord) record to work with
    // @param rowNum (Number) rowNum of the record to work with
    // @return (boolean) true if the record can be expanded
    // @group expansionField
    // @visibility external
    //<
    canExpandRecord : function (record, rowNum) {
        return record[this.canExpandRecordProperty] == false ? false :
            true && (this.canExpandRecords != false);
    },

    //> @method listGrid.setCanExpandRecords()
    // Setter for +link{listGrid.canExpandRecords}
    // @param canExpand (boolean) new value for listGrid.canExpandRecords.
    // @visibility external
    //<
    setCanExpandRecords : function (canExpand) {
        if (this.canExpandRecords == canExpand) return;
        if (!canExpand) {
            var data = this.data;
            if (data) {
                var expandedRows = this._getExpandedRows();
                if (expandedRows != null) {
                    for (var i = 0; i < expandedRows.length; i++) {
                        this.collapseRecord(expandedRows[i]);
                    }
                }
            }
        }
        this.canExpandRecords = canExpand;
        this.refreshFields();
    },

    //> @method listGrid.expandRecord()
    // Expands a given +link{ListGridRecord, record} by creating a subcomponent and inserting it
    // in to the record's grid-row.  A number of built-in +link{ExpansionMode, expansionModes}
    // are supported by the default implementation of
    // +link{listGrid.getExpansionComponent, getExpansionComponent()} and you can override
    // that method to provide your own expansion behavior.
    // <P>
    // Once a record has been expanded, the currently visible expansion component may be
    // retrieved via +link{getCurrentExpansionComponent()}.
    //
    // @param record (ListGridRecord) record to expand
    // @group expansionField
    // @visibility external
    //<
    _expandedRecordCount: 0,
    expandRecord : function (record, shouldRedraw) {
        if (!this.body) {
            // called before draw - add the record to an internal array, this method
            // will be called again with this record after the grid has drawn
            if (!this._recordsToExpand) this._recordsToExpand = [];
            this._recordsToExpand.add(record);
            return;
        }

        var result = false,
            component
        ;

        if (!this.isExpanded(record)) {

            // notification method / cancellation point
            
            if (this.onExpandRecord != null && !this.onExpandRecord(record)) return false;

            if (!this.canExpandMultipleRecords) {
                // can only expand one record - if one's expanded already, collapse it now
                if (this._currentExpandedRecord)
                    this.collapseRecord(this._currentExpandedRecord);
                this._currentExpandedRecord = record;
            } else if (this.maxExpandedRecords != null) {
                // limited number of expanded records allowed - if we've hit that number, show the
                // maxExpandedRecordsPrompt and return
                if (this._expandedRecordCount >= this.maxExpandedRecords) {
                    var message = this.maxExpandedRecordsPrompt.evalDynamicString(this, {
                        count: this.maxExpandedRecords
                    });
                    isc.say(message);
                    return false;
                }
            }

            // create an appropriate subcomponent and bind it
            component = this._getExpansionComponent(record);
            var extraSpaceInMargins = this.getEmbeddedComponentMargin();
            var isRTL = this.isRTL(),
                layoutProperties = {
                    layoutLeftMargin: isRTL ? extraSpaceInMargins : this.getExpansionIndent(),
                    layoutRightMargin: isRTL ? this.getExpansionIndent() : extraSpaceInMargins,
                    layoutTopMargin: (extraSpaceInMargins != 0) ? extraSpaceInMargins - 3 : 0,
                    layoutBottomMargin: extraSpaceInMargins
                }
            ;
            if (component) layoutProperties.members = [component];
            var layout = this.createAutoChild("expansionLayout", layoutProperties);
            layout.isExpansionComponent = true;
            layout.removeOnHideField = true;
            this.addEmbeddedComponent(layout, record, this.data.indexOf(record));
            this._setExpanded(record, true);
            this._setExpansionComponent(record, true);
            this._expandedRecordCount++;
            if (!this.canExpandMultipleRecords) this._currentExpandedRecord = record;
            // only return true if the record was actually expanded as a result of this call 
            result = true;
        }

        if (shouldRedraw != false) {
            this.delayCall("markForRedraw", ["Expanded Record"]);
        }

        return result;
    },
    
    //> @method listGrid.expandRecords()
    // Expands the passed list of +link{ListGridRecord, records} by creating a subcomponent for
    // each record and inserting them it in to the record's grid-row.  Calls
    // +link{listGrid.expandRecord, expandRecord} for each passed record, but only marks the
    // grid for redraw once, after all expansions are complete.
    // 
    // @param records (Array of ListGridRecord) records to expand
    // @group expansionField
    // @visibility external
    //<
    expandRecords : function (records) {
        if (!records || records.length == 0) return;
        var len = records.length;
        for (var i=0; i<len; i++) {
            var isLast = (i == len - 1);
            this.expandRecord(records[i], isLast);
        }
    },

    //> @method listGrid.collapseRecord()
    // Collapses a given +link{ListGridRecord, record} which has been previously expanded using
    // +link{listGrid.expandRecord}.
    // <P>
    // Depending on the +link{listGrid.expansionComponentPoolingMode, pooling mode},
    // this method may automatically destroy expansionComponents.  By default, components
    // created automatically by the ListGrid will be auto-destroyed.  This
    // behavior can be changed by setting a different pooling mode.
    // <P>
    // Note that components created via an override to +link{listGrid.getExpansionComponent}
    // will <b><i>not</i></b> be auto-destroyed - developers should override
    // <code>collapseRecord</code> to take care of clean-up for such components.
    //
    // @param record (ListGridRecord) record to collapse
    // @group expansionField
    // @visibility external
    //<
    collapseRecord : function (record, shouldRedraw) {
        // no passed record
        if (!record) return;

        var component = this._getEmbeddedComponents(record).find("isExpansionComponent", true);

        // bail if there's no expansion component on the passed record
        if (!component) return;

        // set this flag here because collapse can be interactive (and can be cancelled)
        this._redrawOnCollapseRecord = shouldRedraw;

        if (isc.isA.Layout(component)) {
            var member = component.getMember(0);
            if (member) {
                if (!isc.isA.DynamicForm(member)) member = member.formMember;
                if (isc.isA.DynamicForm(member) && member.valuesHaveChanged()) {
                    this.saveAndCollapseRecord(member, component, record, true, true);
                    return;
                }
            }
        }

        this._collapseRecord(record, component);
    },

    //> @method listGrid.collapseRecords()
    // Collapses the passed list of expanded +link{ListGridRecord, records}.  Calls
    // +link{listGrid.collapseRecord, collapseRecord} for each passed record, but only marks
    // the grid for redraw once, after all records have been collapsed.
    // 
    // @param records (Array of ListGridRecord) records to collapse
    // @group expansionField
    // @visibility external
    //<
    collapseRecords : function (records) {
        if (!records || records.length == 0) return;
        var len = records.length;
        for (var i=0; i<len; i++) {
            var isLast = (i == len - 1);
            this.collapseRecord(records[i], isLast);
        }
    },

    saveAndCollapseRecord : function (member, component, record, shouldShowSaveDialog, shouldCollapse) {
        if (this.autoSaveEdits == true) {
            var _this = this;

            if (this.expansionEditorShowSaveDialog && shouldShowSaveDialog) {
                isc.confirm(this.expansionEditorSaveDialogPrompt,
                    function (yes) {
                        if (yes) {
                            _this.saveExpansionDetail(member, component, record, shouldCollapse);
                        } else {
                            if (shouldCollapse) _this._collapseRecord(record, component);
                        }
                    }
                );
            } else {
                this.saveExpansionDetail(member, component, record, shouldCollapse);
            }
            return;
        } else {
            var _values = member.getChangedValues(),
                rowNum = this.getRecordIndex(record),
                _this = this
            ;

            if (this.expansionEditorShowSaveDialog && shouldShowSaveDialog) {
                isc.confirm("You have unsaved changes - do you want to save them now?",
                    function (yes) {
                        if (yes) {
                            _this._saveExpansionEditorValues(rowNum, _values);
                        }
                        if (shouldCollapse) _this._collapseRecord(record, component);
                    }
                );
                return;
            } else {
                _this._saveExpansionEditorValues(rowNum, _values);
                if (shouldCollapse) this._collapseRecord(record, component);
                return;
            }
        }
    },

    
    _saveExpansionEditorValues : function (rowNum, values) {
        for (var key in values) {
            this.setEditValue(rowNum, key, values[key]);
        }
    },

    saveExpansionDetail : function (member, component, record, shouldCollapse) {
        var _this = this;
        member.saveData(
            function (dsResponse, data, dsRequest) {
                if (data) {
                    record = data;
                    if (shouldCollapse) _this._collapseRecord(record, component);
                    else member.editRecord(record);
                }
            }, { showPrompt: true, promptStyle: "cursor" }
        );
    },

    _collapseRecord : function (record, component) {
        if (!record) return;
        component = component ||
            this._getEmbeddedComponents(record).find("isExpansionComponent", true);

        if (this.isExpanded(record)) {
            // notification method / cancellation point
            
            if (this.onCollapseRecord != null && !this.onCollapseRecord(record)) return;

            if (this._currentExpandedRecord && this._currentExpandedRecord == record)
                delete this._currentExpandedRecord;

            this.removeEmbeddedComponent(record, component ? component : this.frozenFields ? this.frozenFields.length : 0);
            this._expandedRecordCount--;
        }
        this._setExpanded(record, false);

        if (this._redrawOnCollapseRecord != false) {
            // only markForRedraw if shouldRedraw:false wasn't passed to collapseRecord
            this.markForRedraw();
        }
    },

    

    _$expandedPrefix:"_expanded_",

    //> @method listGrid.isExpanded()
    // Whether a given +link{ListGridRecord, record} is expanded or collapsed.
    //
    // @param record (ListGridRecord) record in question
    // @group expansionField
    // @return  (Boolean)           true if the node is expanded
    // @visibility external
    //<
    isExpanded : function (record) {
        return (!record ? false : !!record[this._$expandedPrefix + this.ID]);
    },

    //> @method listGrid.getExpandedRecords()
    // Returns the list of +link{ListGridRecord, records} from this ListGrid that are
    // +link{listGrid.expandRecord(),expanded}
    //
    // @group expansionField
    // @return  (Array of ListGridRecord) All expanded records in the grid
    // @visibility external
    //<
    getExpandedRecords : function () {
        return this._getExpandedRows();
    },

    _setExpanded : function (record, value) {
        record[this._$expandedPrefix + this.ID] = value;
    },
    _getExpandedRows : function () {
        return this.data.findAll(this._$expandedPrefix + this.ID, true);
    },

    _$hasExpansionComponentPrefix:"_hasExpansionComponent_",
    _hasExpansionComponent : function (record) {
        return record[this._$hasExpansionComponentPrefix + this.ID];
    },
    _setExpansionComponent : function (record, value) {
        record[this._$hasExpansionComponentPrefix + this.ID] = value;
    },

    
    _$embeddedComponentsPrefix:"_embeddedComponents_",

    _hasEmbeddedComponents : function (record) {
        if (!record) return false;
        var ids = record[this._$embeddedComponentsPrefix + this.ID];
        return (ids != null && ids.length > 0);
    },
    _getEmbeddedComponents : function (record) {
        if (!record) return [];
        // Convert array of IDs into an array of component references
        var ids = record[this._$embeddedComponentsPrefix + this.ID],
            components = []
        ;
        if (!ids) return components;
        for (var i = 0; i < ids.length; i++) {
            components[i] = isc.Canvas.getById(ids[i]);
        }
        return components;
    },
    _setEmbeddedComponents : function (record, value) {
        record[this._$embeddedComponentsPrefix + this.ID] = value;
    },

    _addEmbeddedComponent : function (record, component) {
        if(!record[this._$embeddedComponentsPrefix + this.ID]) {
            record[this._$embeddedComponentsPrefix + this.ID] = [];
        }
        if (!record[this._$embeddedComponentsPrefix + this.ID].contains(component.getID())) {
            record[this._$embeddedComponentsPrefix + this.ID].add(component.getID());
        }
    },
    _removeEmbeddedComponent : function (record, component) {

        var ids = record[this._$embeddedComponentsPrefix + this.ID];
        if (ids == null) return;
        if (ids.length == 0) {
            record[this._$embeddedComponentsPrefix + this.ID] = null;
            return;
        }
        ids.remove(component.getID());
        if (ids.length == 0) {
            record[this._$embeddedComponentsPrefix + this.ID] = null;
        }
    },

    _deleteEmbeddedComponents : function (record, value) {
        delete record[this._$embeddedComponentsPrefix + this.ID];
    },

    
    _$recordComponentsPrefix:"_recordComponents_",
    _hasRecordComponents : function (record) {
        return (record && record[this._$recordComponentsPrefix + this.ID] != null);
    },
    _getRecordComponents : function (record) {
        if (!record) return null;

        // Convert array of IDs into an array of component references
        var ids = record[this._$recordComponentsPrefix + this.ID],
            components = {}
        ;
        if (ids) {
            for (var key in ids) {
                if (ids[key].isNullMarker) {
                    components[key] = ids[key];
                } else {
                    components[key] = isc.Canvas.getById(ids[key]);
                }
            }
        }
        return components;
    },
    _addRecordComponent : function (record, fieldName, component) {
        if(!record[this._$recordComponentsPrefix + this.ID]) {
            record[this._$recordComponentsPrefix + this.ID] = {};
        }
        if (component.isNullMarker) {
            record[this._$recordComponentsPrefix + this.ID][fieldName] = component;
        } else {
            record[this._$recordComponentsPrefix + this.ID][fieldName] = component.getID();
        }
    },
    _deleteRecordComponent : function (record, fieldName) {
        var ids = record[this._$recordComponentsPrefix + this.ID];
        if (ids == null) return;
        if (isc.isAn.emptyObject(ids)) {
            record[this._$recordComponentsPrefix + this.ID] = null;
            return;
        }
        // Not per-cell - just use the special "no field" fieldName
        if (fieldName == null) fieldName = this._$noFieldString;

        delete ids[fieldName];
        if (isc.isAn.emptyObject(ids)) {
            record[this._$recordComponentsPrefix + this.ID] = null;
        }
    },

    //> @attr listGrid.expansionDetailField (MultiAutoChild HTMLFlow : null : RA)
    // Automatically generated +link{class:HTMLFlow} for displaying the contents of
    // +link{listGrid.detailField, a specified field} in a record's expanded section when
    // +link{type:ExpansionMode, listGrid.expansionMode} is <code>detailField</code>.
    // <P>
    // This component is an +link{type:AutoChild} and as such may be customized via
    // <code>listGrid.expansionDetailFieldProperties</code> and
    // <code>listGrid.expansionDetailFieldDefaults</code>.
    // <P>
    // Note, however, that this is a multi-instance component (potentially one per record),
    // so it is created using +link{Class.createAutoChild, createAutoChild()} not
    // +link{Class.addAutoChild, addAutoChild()}, and no default single instance is created by
    // name on the grid.
    //
    // @group expansionField
    // @visibility external
    //<
    expansionDetailFieldDefaults: {
        _constructor: isc.HTMLFlow,
        selectCellTextOnClick:false,
        autoDraw: false,
        width: "100%",
        height: "100%"
    },
    //> @attr listGrid.expansionDetails (MultiAutoChild DetailViewer : null : RA)
    // Automatically generated +link{class:DetailViewer} for displaying the details of a record
    // in its expanded section when
    // +link{type:ExpansionMode, listGrid.expansionMode} is <code>details</code>.  Note that
    // only those fields
    // which do not already appear in the grid are displayed in the expanded section.
    // <P>
    // This component is an +link{type:AutoChild} and as such may be customized via
    // <code>listGrid.expansionDetailsProperties</code> and
    // <code>listGrid.expansionDetailsDefaults</code>.
    // <P>
    // Note, however, that this is a multi-instance component (potentially one per record),
    // so it is created using +link{Class.createAutoChild, createAutoChild()} not
    // +link{Class.addAutoChild, addAutoChild()}, and no default single instance is created by
    // name on the grid.
    //
    // @group expansionField
    // @visibility external
    //<
    expansionDetailsDefaults: {
        _constructor: isc.DetailViewer,
        autoDraw: false,
        width: "100%",
        _shouldSkipGeneratingComponent: true
    },
    //> @attr listGrid.expansionRelated (MultiAutoChild ListGrid : null : RA)
    // Automatically generated +link{class:ListGrid} for displaying data related to a record
    // in its expanded section when
    // +link{type:ExpansionMode, listGrid.expansionMode} is <code>related</code>.
    // The +link{class:DataSource} containing the related data is provided by
    // +link{listGrid.getRelatedDataSource, getRelatedDataSource()} which, by default,
    // returns the DataSource referred to in +link{listGridRecord.detailDS}.
    // <P>
    // This component is an +link{type:AutoChild} and as such may be customized via
    // <code>listGrid.expansionRelatedProperties</code> and
    // <code>listGrid.expansionRelatedDefaults</code>.
    // <P>
    // Note, however, that this is a multi-instance component (potentially one per record),
    // so it is created using +link{Class.createAutoChild, createAutoChild()} not
    // +link{Class.addAutoChild, addAutoChild()}, and no default single instance is created by
    // name on the grid.
    //
    // @group expansionField
    // @visibility external
    //<
    expansionRelatedDefaults: {
        _constructor: isc.ListGrid,
        autoDraw: false,
        width: "100%",
        warnOnReusedFields:false,
        autoFitData: "vertical",
        autoFitMaxRecords: 4
    },

    //> @attr listGrid.expansionEditor (MultiAutoChild DynamicForm : null : RA)
    // Automatically generated +link{class:DynamicForm} for editing the details of a record
    // in its expanded section when
    // +link{type:ExpansionMode, listGrid.expansionMode} is <code>editor</code>.  Note that only
    // those fields which do not already appear in the grid will appear in the expanded section.
    // <P>
    // According to the value of +link{showExpansionEditorSaveButton}, a save button is shown
    // beneath the editor.  You can save the values in the editor by clicking this button
    // <P>
    // This component is an +link{type:AutoChild} and as such may be customized via
    // <code>listGrid.expansionEditorProperties</code> and
    // <code>listGrid.expansionEditorDefaults</code>.
    // <P>
    // Note, however, that this is a multi-instance component (potentially one per record),
    // so it is created using +link{Class.createAutoChild, createAutoChild()} not
    // +link{Class.addAutoChild, addAutoChild()}, and no default single instance is created by
    // name on the grid.
    //
    // @group expansionField
    // @visibility external
    //<
    expansionEditorDefaults: {
        _constructor: "DynamicForm",
        autoDraw: false,
        numCols: 4,
        colWidths: ["*", "*", "*", "*"],
        width: "100%",
        saveOperationType: "update"
    },

    //> @attr listGrid.expansionEditorShowSaveDialog (boolean : null : IR)
    // When +link{listGrid.canExpandRecords, canExpandRecords} is true and
    // +link{listGrid.expansionMode, expansionMode} is <i>editor</i>, whether a dialog should be
    // displayed when an expanded row is collapsed while it's nested editor has changed values.
    //
    // @group expansionField
    // @visibility external
    //<
    //expansionEditorShowSaveDialog: null,

    //> @attr listGrid.expansionEditorSaveDialogPrompt (String : "You have unsaved changes - do you want to save them now?" : IR)
    // When +link{listGrid.canExpandRecords, canExpandRecords} is true and
    // +link{listGrid.expansionMode, expansionMode} is <i>editor</i>, the prompt to display
    // in a dialog when an expanded row is collapsed while it's nested editor has changed values.
    //
    // @group expansionField,i18nMessages
    // @visibility external
    //<
    expansionEditorSaveDialogPrompt: "You have unsaved changes - do you want to save them now?",

    //> @attr listGrid.expansionEditorCollapseOnSave (Boolean : true : RW)
    // When +link{expansionMode} is <i>editor</i>, should the row be collapsed following a
    // save initiated by the expansion-component's +link{expansionEditorSaveButton, save button}.
    //
    // @group expansionField
    // @visibility external
    //<
    expansionEditorCollapseOnSave: true,

    //> @attr listGrid.showExpansionEditorSaveButton (Boolean : true : RW)
    // When +link{expansionMode} is <i>editor</i>, should a Save button be shown below the
    // the expanded editor?
    // <P>
    // Note that if an expanded-row containing an editor is collapsed while changes are
    // outstanding, changes will be either be automatically updated to the grid, or will first
    // show a confirmation dialog, according to the value of
    // +link{expansionEditorShowSaveDialog}.
    //
    // @group expansionField
    // @visibility external
    //<
    showExpansionEditorSaveButton: true,

    //> @attr listGrid.expansionEditorSaveButton (MultiAutoChild IButton : null : RA)
    // Automatically generated +link{class:IButton} for saving the values in the expanded
    // portion of a ListGrid row.
    // <P>
    // This component is an +link{type:AutoChild} and as such may be customized via
    // <code>listGrid.expansionEditorSaveButtonProperties</code> and
    // <code>listGrid.expansionEditorSaveButtonDefaults</code>.
    // <P>
    // Note, however, that this is a multi-instance component (potentially one per record),
    // so it is created using +link{Class.createAutoChild, createAutoChild()} not
    // +link{Class.addAutoChild, addAutoChild()}, and no default single instance is created by
    // name on the grid.
    //
    // @group expansionField
    // @visibility external
    //<
    expansionEditorSaveButtonDefaults: {
        _constructor: "IButton",
        autoFit: true,
        layoutAlign: "center",
        click : function () {
            if (!this.grid || !this.form || !this.record) return;
            var grid = this.grid,
                component = grid._getEmbeddedComponents(this.record).find("isExpansionComponent", true)
            ;

            // bail if no expansion component on the record 
            if (!component) return;

            this.grid.saveAndCollapseRecord(this.form, component, this.record, false,
                this.grid.expansionEditorCollapseOnSave
            );
        }
    },

    //> @attr listGrid.expansionEditorSaveButtonTitle (String : "Save" : RWA)
    // The title for the +link{expansionEditorSaveButton}.
    //
    // @group expansionField,i18nMessages
    // @visibility external
    //<
    expansionEditorSaveButtonTitle: "Save",

    //> @attr listGrid.expansionDetailRelated (MultiAutoChild HLayout : null : RA)
    // Automatically generated +link{class:HLayout} appearing in a record's expanded section
    // when +link{type:ExpansionMode, listGrid.expansionMode} is <code>detailRelated</code>.
    // This component contains two other autoChild components,
    // a +link{class:DetailViewer} for viewing fields from the record which are not already
    // present in the grid and a separate embedded +link{class:ListGrid} for displaying other
    // data related to this record via record.detailDS.  See +link{listGrid.expansionDetails}
    // and +link{listGrid.expansionRelated} for more information.
    // <P>
    // This component is an +link{type:AutoChild} and as such may be customized via
    // <code>listGrid.expansionDetailRelatedProperties</code> and
    // <code>listGrid.expansionDetailRelatedDefaults</code>.
    // <P>
    // Note, however, that this is a multi-instance component (potentially one per record),
    // so it is created using +link{Class.createAutoChild, createAutoChild()} not
    // +link{Class.addAutoChild, addAutoChild()}, and no default single instance is created by
    // name on the grid.
    //
    // @group expansionField
    // @visibility external
    //<
    expansionDetailRelatedDefaults: {
        _constructor: isc.HLayout,
        autoDraw: false,
        width: "100%",
        height: "100%"
    },

    //> @attr listGrid.expansionLayout (MultiAutoChild VLayout : null : RA)
    // Automatically generated +link{class:VLayout} which fills a record's expanded section
    // and contains other builtin +link{ExpansionMode, expansion-components}.  You can also
    // override +link{listGrid.getExpansionComponent, getExpansionComponent()} to provide
    // components of your own specification.
    // <P>
    // This component is an +link{type:AutoChild} and as such may be customized via
    // <code>listGrid.expansionLayoutProperties</code> and
    // <code>listGrid.expansionLayoutDefaults</code>.
    // <P>
    // Note, however, that this is a multi-instance component (potentially one per record),
    // so it is created using +link{Class.createAutoChild, createAutoChild()} not
    // +link{Class.addAutoChild, addAutoChild()}, and no default single instance is created by
    // name on the grid.
    //
    // @group expansionField
    // @visibility external
    //<
    expansionLayoutDefaults: {
        _constructor: isc.VLayout,
        autoDraw: false,
        
        height: 10,
        overflow: "visible"
    },

    //> @method listGrid.getCurrentExpansionComponent()
    // Returns the expansion component derived from +link{listGrid.getExpansionComponent()}
    // currently visible in some record, or null if the specified record is not showing
    // an expansion component.
    //
    // @param record (Integer | ListGridRecord) rowNum or record to get the expansionComponent for
    // @return (Canvas) the currently visible expansion component for the expanded row.
    // @group expansionField
    // @visibility external
    //<
    getCurrentExpansionComponent : function (record) {
        if (isc.isA.Number(record)) record = this.getRecord(record);

        // bail if no record
        if (!record) return null;

        // we actually hang 'isExpansionComponent' onto the layout containing the generated
        // expansion component so return its (only) member.
        var component = this._getEmbeddedComponents(record).find("isExpansionComponent", true);
        if (component) {
            return component.members[0];
        }
        return null;
    },

    _getExpansionComponent : function (record) {
        if (this.expansionScreen) {
            return this.getExpansionScreen(record);
        } else {
            return this.getExpansionComponent(record);
        }
    },

    //> @method listGrid.getExpansionComponent()
    // When +link{canExpandRecords} is true, gets the embedded-component to show as a given
    // record's expansionComponent.  This component is then housed in
    // +link{listGrid.expansionLayout, a VLayout} and embedded into a record's row.
    // <P>
    // By default, this method returns one of a set of built-in components, according to the
    // value of +link{type:ExpansionMode, listGrid.expansionMode}.  You can override this method
    // to return any component you wish to provide as an expansionComponent.
    // <P>
    // As long as the record is expanded, this component may be retrieved via a call to
    // +link{getCurrentExpansionComponent()}.
    // <P>
    // When an expanded record is collapsed, the component is disassociated from the record and
    // may or may not be automatically destroyed.  By default, built-in components will be
    // destroyed on unembed according to the +link{listGrid.expansionComponentPoolingMode,
    // pooling mode} being used.  Custom expansion components, created via an override of
    // getExpansionComponents(), will <b><i>not</i></b> be auto-destroyed - developers should
    // override +link{collapseRecord} to take care of clean-up for such components.
    //
    // @param record (ListGridRecord) record to get the expansionComponent for
    // @return (Canvas | Canvas Properties) the component to embed
    // @see expansionScreen
    // @group expansionField
    // @visibility external
    //<
    getExpansionComponent : function (record) {
        return this._getStockEmbeddedComponent(record, true, false, this.getRecordIndex(record), 0);
    },

    //> @attr listGridRecord.backgroundComponent (Canvas : null : IR)
    // Has no effect unless +link{listGrid.showBackgroundComponents} is <code>true</code>.
    // <P>
    // Canvas created and embedded in the body behind a given record.   When set, either as
    // a Canvas or Canvas Properties, will be constructed if necessary, combined with the
    // autoChild properties specified for +link{listGrid.backgroundComponent} and displayed
    // behind this record in the page's z-order, meaning
    // it will only be visible if the cell styling is transparent.
    // @group rowEffects
    // @visibility external
    //<

    //> @attr listGrid.expansionScreen (String : null : IR)
    // Screen to create (via +link{RPCManager.createScreen,createScreen()}) in lieu of calling
    // +link{getExpansionComponent()}.
    // <P>
    // If this grid has a +link{listGrid.dataSource,dataSource}, the created screen is
    // provided with a +link{canvas.dataContext} that includes the record being expanded.
    // Be sure the expansion screen meets these +link{canvas.autoPopulateData,requirements}
    // to utilize the <code>dataContext</code>.
    // @group expansionField
    // @visibility external
    //<

    expansionScreenPlaceholderDefaults: {
        _constructor: isc.Label,
        autoDraw: false,
        border: "1px solid red",
        contents: "expansionScreen<br>Placeholder",
        align: "center"
    },

    getExpansionScreen : function (record) {
        var ds = this.getDataSource(),
            settings = {
                suppressAutoDraw: true
            }
        ;
        if (ds) {
            settings.dataContext = {};
            settings.dataContext[ds.ID] = record;
        }
        var screen = isc.RPCManager.createScreen(this.expansionScreen, settings);
        if (!screen) {
            screen = this.createAutoChild("expansionScreenPlaceholder");
        }
        return screen;
    },

// Expando Rows - Record implementation

    //> @attr listGrid.detailDS (String : null : IRW)
    // If +link{canExpandRecords} is true and +link{type:ExpansionMode,listGrid.expansionMode}
    // is <code>"related"</code>, this property specifies the dataSource for the
    // related records grid to be shown embedded in expanded records.
    // <P>
    // This property may also be specified on a per-record basis - see
    // +link{recordDetailDSProperty}
    //
    // @group expansionField
    // @visibility external
    //<

    //> @attr listGrid.recordDetailDSProperty (String : "detailDS" : IRWA)
    // The name of the ListGridRecord property that specifies the DataSource to use when
    // +link{type:ExpansionMode, listGrid.expansionMode} is "related".  The default is
    // +link{ListGridRecord.detailDS}. Note that you can set the +link{detailDS} at the
    // grid level instead if the same dataSource is to be used for all records.
    //
    // @group expansionField
    // @visibility external
    //<
    recordDetailDSProperty: "detailDS",

    //> @attr listGridRecord.detailDS (DataSource : null : IRWA)
    // The default value of +link{listGrid.recordDetailDSProperty}.
    //
    // @group expansionField
    // @visibility external
    //<

    //> @method listGrid.getRelatedDataSource()
    // Returns the +link{class:DataSource} containing data related to the passed record.  Used
    // when +link{ListGrid.canExpandRecords} is true and +link{ExpansionMode} is "related". The
    // default implementation returns the DataSource specified in
    // +link{listGridRecord.detailDS} if set, otherwise +link{listGrid.detailDS}.
    //
    // @param   record  (ListGridRecord)    The record to get the Related dataSource for.
    // @return (DataSource) The related DataSource for the "record" param
    //
    // @visibility external
    //<
    getRelatedDataSource : function (record) {
        return isc.DS.getDataSource(record[this.recordDetailDSProperty]) ||
                    isc.DS.get(this.detailDS);
    }

    //> @attr listGrid.childExpansionMode (ExpansionMode : null : IRWA)
    // For +link{ExpansionMode, expansionModes} that show another grid or tree, what the
    // child's expansionMode should be.
    // <P>Default value <code>null</code> means no further expansion.
    //
    // @group expansionField
    // @visibility external
    //<

    //> @attr listGrid.expansionCanEdit (Boolean : null : IRWA)
    // For +link{ExpansionMode, expansionModes} that show another grid or tree, is that
    // component editable?
    // <P>The default value for this property is <code>false</code>.
    //
    // @group expansionField
    // @visibility external
    //<

    //> @attr listGrid.filterLocalData (boolean : null : IRA)
    // Causes filtering to be performed against the local data set, even when a
    // +link{listGrid.dataSource} is provided.
    // <p>
    // When using this mode, data must be provided to the grid via +link{listGrid.setData()},
    // and must be provided as 
    // <smartclient>a simple Array of Records</smartclient>
    // <smartgwt>a RecordList</smartgwt>.  
    // <p>
    // Note that a +link{listGrid.dataSource} must be provided for filtering to occur
    // even when filtering locally.
    // <P>
    // If this property is set to true, the supplied data is applied as the 
    // +link{resultSet.allRows, complete dataset} of a +link{class:ResultSet}, which is then 
    // filtered according to the specified criteria, and the results displayed. If false, a 
    // normal databound fetch will occur, retrieving records that match the specified criteria 
    // from this component's +link{listGrid.dataSource}.
    // <p>
    // <code>filterLocalData</code> includes both calls to +link{listGrid.fetchData()} and
    // +link{listGrid.filterData()} as well as automatic filtering when the
    // +link{listGrid.filterEditor} is enabled.
    // <p>
    // If this property is not explicitly set, default behavior will filter against the
    // dataSource unless the grid has a specified +link{DataPath, dataPath}, in which case
    // filtering will occur locally.
    // <p>
    // See also +link{listGrid.saveLocally} to cause saves to ignore the DataSource and affect
    // the local data set only.
    //
    // @visibility external
    //<

    //> @attr listGrid.recordDropAppearance (RecordDropAppearance : isc.ListGrid.BETWEEN : [IRW])
    // If +link{canAcceptDroppedRecords} is true for this listGrid, this property governs
    // whether the user can drop between, or over records within the grid.
    // This controls what +link{type:RecordDropPosition} is passed to the +link{recordDrop()}
    // event handler.
    //
    // @visibility external
    //<
    , recordDropAppearance: isc.ListGrid.BETWEEN
});



isc.ListGrid.addMethods({

// warnOnReusedFields -- will log a warning at init time if this.fields is set to an array of
// field objects which are already displayed as fields in another grid.
// Internal - we only disable this for a couple of special cases where we really do want to share
// field objects across grids, like the record editor
warnOnReusedFields:true,


init : function () {
    if (this.disableTouchScrollingForDrag &&
        (this.canDragRecordsOut || this.canDragSelect || this.canReorderRecords) &&
        this.useTouchScrolling == null)
    {
        this.logInfo("Automatically disabling touch scrolling", "scrolling");
        this.useTouchScrolling = false;
    }
    // move minHeight update from draw(), to ensure it's present before the body gets added
    if (this.minHeight == null) this.minHeight = this._getDefaultMinHeight();

    this.Super("init", arguments);
},

//> @method ListGrid.initWidget() (A)
// Initialize the canvas and call listGrid.setData().
// @param [all arguments] (Object) objects with properties to override from default
//<
initWidget : function () {
    // set a flag that prevents sortChanged() from firing during initialization
    this._initializing = true;

    // see comments above in dataFetchDelay definition 
    if (this.dataFetchDelay === 0) this.dataFetchDelay = 1;

    
    this.Super("initWidget", arguments);

    // allow deprecated attribute +link{selection} to access +link{selectionManager}
    if (this.selectionManager != null) this.selection = this.selectionManager;

    
    if (this.showAllRecords && this.dataFetchMode == "paged") {
        this.logWarn("dataFetchMode: 'paged' isn't supported for grids with showAllRecords: " +
                     "true");
    }

    // Disable `resizeFieldsInRealTime' in mobile browsers.
    if (isc.Browser.isMobile) this.resizeFieldsInRealTime = false;

    // call the setter on 'showRecordComponents()' - this disables the
    // drawAllMaxCells logic for the grid.
    if (this.showRecordComponents) {
        delete this.showRecordComponents;
        this.setShowRecordComponents(true);
    }

    // set the default style for the expansionDetailField to whatever the hoverStyle is - means 
    // the field-value, the HTML content, looks the same when embedded as an expansionComponent 
    // as it would if the same HTML were shown in a hover 
    
    if (!this.expansionDetailFieldDefaults.styleName) {
        this.expansionDetailFieldDefaults.styleName = this.hoverStyle;
    }

    // we want to avoid a fields array object getting re-used across multiple ListGrids.
    // This can happen if the developer does something like assigning a fields object to the
    // instance prototype.
    // To handle this we have another attribute 'defaultFields' which may be set on the instance
    // prototype and differs only from initializing with a fields block in that array will be
    // shallow cloned and assigned to this.fields rather than sharing the same object across
    // ListGrid instances
    
    if (this.fields == null && this.defaultFields != null) {
        this.fields = isc.shallowClone(this.defaultFields);
        //this.logWarn("fields picked up from this.defaultFields -- now set to:" + this.fields);
    } else if (this.warnOnReusedFields && this.fields != null) {
        if (this.fields._initializedFieldsArray) {
            this.logWarn("ListGrid initialized with this.fields attribute set to an array " +
                "which is already being displayed in another ListGrid instance. To reuse " +
                "standard field configuration across multiple ListGrids, use " +
                "listGrid.defaultFields rather than assigning directly to listGrid.fields.");

        // Also catch the case where the developer re-uses individual fields within separate
        // arrays across grids
        } else {

            var dupedFields;
            if (isc.isAn.Array(this.fields)) {
                dupedFields = this.fields.findIndex("_initializedFieldObject", true) != -1;
            } else if (isc.isAn.Object(this.fields)) {
                for (var fieldName in this.fields) {
                    var field = this.fields[fieldName];
                    if (field && field._initializedFieldObject) {
                        dupedFields = true;
                        break;
                    }
                }
            }
            if (dupedFields) {
                 this.logWarn("ListGrid initialized with this.fields attribute set to an array " +
                "containing fields which are already being displayed in another ListGrid " +
                "instance. To reuse standard field configuration across multiple ListGrids, use " +
                "listGrid.defaultFields rather than assigning directly to listGrid.fields.");
            }
        }

        // Set a flag on the array and the individual field objects - this allows us catch the case
        // where a developer reuses a standard fields array across multiple grids rather than using
        // the defaultFields attribute
        // 
        // Also use this opportunity to check for null slots in the fields array
        
        this.fields._initializedFieldsArray = true;
        if (isc.isAn.Array(this.fields)) {
            for (var ri = this.fields.length; ri > 0; --ri) {
                var field = this.fields[ri - 1];
                if (field == null) {
                    this.logWarn("ListGrid initialization: Specified fields array includes null entry. Removing.");
                    this.fields.removeAt(ri - 1);
                    continue;
                }
                field._initializedFieldObject = true;
            }

        } else if (isc.isAn.Object(this.fields)) {
            for (var fieldName in this.fields) {
                var field = this.fields[fieldName];
                if (field) {
                    field._initializedFieldObject = true;
                }
            }
        }
    }

    if (this.canEditNew) this.listEndEditAction = this.rowEndEditAction = "next";

    if (this.alwaysShowEditors) {
        this.editByCell = false;

        // disable selection
        
        this.selectionType = "none";
        this.selectOnEdit = false;

        if (this.canGroup != false) {
            this.logInfo("grouping functionality is not supported when alwaysShowEditors is true." +
                    " Explicitly disabling this.canGroup", "inactiveEditorHTML");
            this.canGroup = false;
        }
        if (this.modalEditing) {
            this.logInfo("modalEditing is not supported when alwaysShowEditors is true." +
                " Explicitly setting this.modalEditing to false", "inactiveEditorHTML");
            this.modalEditing = false;
        }

        // enforce editEvent:"click" - this means that if the user clicks on a cell which
        // isn't showing an inactive editor (for example where showEditorPlaceholder is true),
        // we still start editing that row/cell
        this.editEvent = "click";

        // If canEdit is unset, and we have no fields explicitly marked as canEdit:true,
        // flip the default to true.
        // This gives us the most intuitive behavior - if the developer specifies per-field
        // editability we'll respect it, otherwise we'll default to canEdit true
        if (this.canEdit == null) {
            var fields = this.getFields() || [],
                hasEditableFields = false
            ;
            for (var i = 0; i < fields.length; i++) {
                if (fields[i].canEdit == true) {
                    hasEditableFields = true;
                    break;
                }
            }

            if (!hasEditableFields) {
                this.logInfo("alwaysShowEditors has been set for this grid but canEdit is unset and " +
                  "no fields are explicitly marked as editable. Defaulting this.canEdit to true. " +
                  "Note that to avoid this override developers can explicitly specify canEdit " +
                  "at the grid or field level", "inactiveEditorHTML");
                this.canEdit = true;
            }
        }

    }

    this.updateFixedRecordHeights();

    // disable canAddFormulaField if the required component isn't present
    if (this.canAddFormulaFields && isc.FormulaBuilder == null) {
        this.logInfo("Required modules for adding formula fields not present - setting " +
                    "canAddFormulaFields to false.");
        this.canAddFormulaFields = false;
    }
    if (this.canAddSummaryFields && isc.SummaryBuilder == null) {
        this.logInfo("Required modules for adding summary fields not present - setting " +
                    "canAddSummaryFields to false.");
        this.canAddSummaryFields = false;
    }

    // default to canSelectCells mode if we're using rowSpan-sensitive styling
    if (this.useRowSpanStyling && this.canSelectCells == null) this.canSelectCells = true;

    // default cell-level roll overs to the value of canSelectCells
    if (this.useCellRollOvers == null) this.useCellRollOvers = this.canSelectCells;

    // force loading rows to contain at least &nbsp; otherwise row height may be reported as less
    // than the actual height.
    if (this.loadingMessage == null || this.loadingMessage == isc.emptyString)
        this.loadingMessage = "&nbsp;";

    // default our overflow to "visible" if autoFitData is set
    if (this.autoFitData != null) {
        this._specifiedOverflow = this.overflow;
        this.setOverflow("visible");
    }

    // default our groupStartOpen to "all" if canCollapseGroup is false
    if (this.canCollapseGroup == false) this.groupStartOpen = "all";

    // force sortDirection to a SortDirection (it could have been a boolean in the past)
    this.sortDirection = Array.shouldSortAscending(this.sortDirection) ? "ascending" : "descending";
    // store off the initial sortDirection - we'll revert to this when unsorting
    this._baseSortDirection = Array.shouldSortAscending(this.sortDirection) ? "ascending" : "descending";

    // Hilite state takes precedence over hilites because it is likely applied
    // from a user-saved location whereas hilites is the default.
    if (this.hiliteState) this.setHiliteState(this.hiliteState);

    // initialize the data object, setting it to an empty array if it hasn't been defined
    
    this.setData(this.data ? null : this.getDefaultData());

    // set up selectionType dynamic default
    this.setSelectionAppearance(this.selectionAppearance, true);

    this._setUpDragProperties();

    // parse the headerRadius string and cache it as an array
    if (this.headerRadius) this.setHeaderRadius(this.headerRadius);

    // parse the recordRadius string and cache it as an array
    if (this.recordRadius) this.setRecordRadius(this.recordRadius);

    // duplicate the initial recordRadiusTargets array
    if (this.recordRadiusTargets) this.recordRadiusTargets = this.recordRadiusTargets.duplicate();

    // check if grid.searchForm can be set up yet - in Reify/ComponentXML, this will be an 
    // unresolved string-ID initially, and the widget with that ID may not yet have been 
    // created
    if (this.searchForm) this.checkForSearchForm();

    // set initial visibility of drag handles used for dragging records on touch devices
    if (this.showInitialDragHandles) this._showDragHandles = this.showInitialDragHandles;

    if(!this.canResizeFields) this.canAutoFitFields=false;
    
    
    if (this.wrapHeaderTitles == null) {
        this.wrapHeaderTitles = this._getHeaderButtonAutoChildConfig("wrap") || false;
    }
    if (this.wrapHeaderSpanTitles == null) {
        this.wrapHeaderSpanTitles = this._getHeaderButtonAutoChildConfig("wrap", true) || false;
    }

    
    if (this.embeddedComponentIndentOtherMargins != null) {
        this.embeddedComponentMargin = this.embeddedComponentIndentOtherMargins;
        delete this.embeddedComponentIndentOtherMargins;
    }

    // Remember the initial groupState.
    // This allows us to avoid unnecessary calls to groupStateChanged when
    // regroup runs, but the groupBy fields are unaltered
    this.currentGroupState = this.getGroupState();

    // clear out the flag that prevents sortChanged() from firing during initialization
    delete this._initializing;
},

// Ensure that properties related to variable row heights are set correclty
// This method is lazily called on body.draw() / redraw() 

// if we have variable record heights and virtualScrolling is unset, switch it on

updateFixedRecordHeights : function () {
    
    var variableRowHeights = (this.canExpandRecords || (this.fixedRecordHeights == false));
    if (variableRowHeights != this._hasVariableRowHeights) {
        this._hasVariableRowHeights = variableRowHeights;
        if (variableRowHeights && this.virtualScrolling == null) {
            // the _specifiedFixedRecordHeights flag is used by shouldShowAllColumns - we know
            // that even though a row may exceed its cell height this isn't due to any cell's content
            // in the row, so we don't need to render out every column to get correctly sized rows.
            if (this.fixedRecordHeights) this._specifiedFixedRecordHeights = this.fixedRecordHeights;
            this.fixedRecordHeights = false;
            this.virtualScrolling = true;
        }
        if (this.body) {
            this.body.fixedRowHeights = this.fixedRecordHeights;
            this.body.virtualScrolling = this.virtualScrolling;
        }
        if (this.frozenBody) {
            this.frozenBody.fixedRowHeights = this.fixedRecordHeights;
            this.frozenBody.virtualScrolling = this.virtualScrolling;
        }
    }

},

//> @method listGrid.setFixedRecordHeights()
// Setter for +link{listGrid.fixedRecordHeights}
// @param fixedRecordHeights (boolean) New fixedRecordHeights value
// @visibility external
//<
setFixedRecordHeights : function (fixedRecordHeights) {
    this.fixedRecordHeights = fixedRecordHeights;
    this.updateFixedRecordHeights();
    if (this.isDrawn()) this.markForRedraw();
},

//> @method listGrid.setWrapCells()
// Setter for +link{listGrid.wrapCells}
// @param wrapCells (boolean) New wrapCells value
// @visibility external
//<
setWrapCells : function (wrapCells) {
    if (this.wrapCells == wrapCells) return;
    
    this.wrapCells = wrapCells;
    if (this.body) this.body.wrapCells = wrapCells;
    if (this.frozenBody) this.frozenBody.wrapCells = wrapCells;
    if (this.isDrawn()) this.markForRedraw();
},


_handleDualInputMouseMove : function (event, eventInfo) {
    if (event && event.DOMevent) {
        var domEvent = event.DOMevent,
            mouseEvent = isc.EH.isMouseEvent(domEvent.type, true, domEvent)
        ;
        if (mouseEvent) {
            isc.ListGrid.addProperties({ showRollOver: true});
            delete this._touchEnabled;
        }
    }
    return this.invokeSuper(isc.ListGrid, "handleMouseMove", event, eventInfo);
},

enableTouchSupport : function () {
    this.Super("enableTouchSupport", arguments);
    isc.ListGrid.addProperties({ showRollOver: false});
},

_getHeaderButtonAutoChildConfig : function (property, isSpan) {
    var value;

    // give the autochild properties priority, using the button properties as fallback for span
    if (isSpan) {
        value = this.headerSpanProperties ? this.headerSpanProperties[property] : null;
    }
    if (value == null) {
        value = this.headerButtonProperties ? this.headerButtonProperties[property] : null;
    }

    // bail if we've found a value
    if (value != null) return value;

    // now check the autochild defaults, using the button defaults as fallback for span
    if (isSpan) {
        value = this.headerSpanDefaults ? this.headerSpanDefaults[property] : null;
    }
    if (value == null) {
        value = this.headerButtonDefaults ? this.headerButtonDefaults[property] : null;
    }

    return value;
},

_storeDragProperties : function () {
    if (!this._initialDragProperties) {
        var iDP = this._initialDragProperties = {};
        iDP.canDrag = this.canDrag;
        iDP.canDrop = this.canDrop;
        iDP.canAcceptDrop = this.canAcceptDrop;
    }
},
_restoreDragProperties : function () {
    var iDP = this._initialDragProperties;
    if (iDP) {
        this.canDrag = iDP.canDrag;
        this.canDrop = iDP.canDrop;
        this.canAcceptDrop = iDP.canAcceptDrop;
    }
},
_setUpDragProperties : function () {
    if (!this._initialDragProperties) {
        // store the original dragProperties
        this._storeDragProperties();
    }
    // set up our specific drag-and-drop properties

    this.canDrag = !this.canDragSelectText &&
                    (this.canDrag || this.canDragRecordsOut || this.canReorderRecords ||
                    this.canDragSelect);
    this.canDrop = (this.canDrop || this.canDragRecordsOut || this.canReorderRecords);
    this.canAcceptDrop = (this.canAcceptDrop || this.canAcceptDroppedRecords ||
                    this.canReorderRecords);

},

//> @method listGrid.setCanReorderRecords()
// Setter for the +link{listGrid.canReorderRecords} attribute.
// @param canReorderRecords (boolean) new value for <code>this.canReorderRecords</code>
// @visibility external
//<
setCanReorderRecords : function (canReorderRecords) {
    if (canReorderRecords != this.canReorderRecords) {
        this.canReorderRecords = canReorderRecords;
        this._restoreDragProperties();
        this._setUpDragProperties();
        this.redraw();
    }
},

getEmptyMessage : function () {
    if (isc.ResultSet && isc.isA.ResultSet(this.data) && !this.data.lengthIsKnown()) {
        if (isc.Offline && isc.Offline.isOffline()) {
            return this.offlineMessage;
        }
        return this.loadingDataMessage == null ? "&nbsp;" :
            this.loadingDataMessage.evalDynamicString(this, {
                loadingImage: this.imgHTML(isc.Canvas.loadingImageSrc,
                                           isc.Canvas.loadingImageSize,
                                           isc.Canvas.loadingImageSize)
            });
    }
    if (this.isOffline()) {
        return this.offlineMessage;
    }
    return this.emptyMessage == null ? "&nbsp;" : this.emptyMessage.evalDynamicString(this, {
        loadingImage: this.imgHTML(isc.Canvas.loadingImageSrc,
                                   isc.Canvas.loadingImageSize,
                                   isc.Canvas.loadingImageSize)
    });
},

isEmpty : function () {
    if (!this.data) return true;

    // treat having no fields as being empty so we don't attempt to write out and manipulate
    // an empty table
    if (!this.fields || this.fields.length == 0) return true;

    
    if (isc.ResultSet && isc.isA.ResultSet(this.data)) {

        if (this.data.isPaged()) {
            if (!this.data.isEmpty()) return false;

            if (this.shouldShowNewRecordRow()) return false;

            
            var editRows = this.getAllEditRows();
            if (editRows && editRows.length > 0) {
                for (var i = 0; i < editRows.length; i++) {
                    if (editRows[i] >= 0) return false;
                }
            }
            return true;
        } else {
            // If our length is not known we must be in the process of loading, so return the
            // loading message.
            return (!this.data.lengthIsKnown() || this.getTotalRows() == 0);
        }
    } else {
        return (this.getTotalRows() == 0);
    }
},

//> @attr listGrid.preserveEditsOnSetData (boolean : null : IRWA)
// By default any edit values in an editable ListGrid are dropped when 'setData()' is called,
// as previous edits are almost certainly obsoleted by the new data-set.
// This flag allows the developer to suppress this default behavior.
// @visibility internal
// @group data
//<
// Leave this internal for now - no known use cases for it, but seems like something that
// could come up.
//preserveEditsOnSetData : null,

//> @method listGrid.setData()
// Provides a new data set to the ListGrid after the grid has been created or drawn.
// The ListGrid will redraw to show the new data automatically.
// <P>
// Note that passing null will not clear +link{data}, but will regroup it and reapply the
// current sort, highlighting, and summaries to the grid.  Size will be recalculated for fields
// marked as +link{listGridField.autoFitWidth,autofitWidth}:true and a +link{selectionManager,
// selection manager} will be created if none exists.  To clear the grid instead, pass [].
//
// @param newData (List of ListGridRecord) data to show in the list
// @group data
// @visibility external
//<

setData : function (newData, clearGroupBy) {
    // if the current data and the newData are the same, bail
    //  (this also handles the case that both are null)
    if (this.data == newData) return;

    if (!this.preserveEditsOnSetData) this.discardAllEdits();

    // drop "lastHiliteRow" -no sense in hanging onto it
    this.clearLastHilite();

    // if we are currently pointing to data, stop observing it
    if (this.data) {
        this._ignoreData(this.data);
        // if the data was autoCreated, destroy it to clean up RS<->DS links
        if (newData && this.data._autoCreated && isc.isA.Function(this.data.destroy)) {
            this.data.destroy();
        }
    }
    if (this.originalData && (newData || !this.data)) {
        this._ignoreData(this.originalData);
        if (this.originalData != newData && this.originalData._autoCreated &&
            isc.isA.Function(this.originalData.destroy))
        {
            this.originalData.destroy();
        }
        delete this.originalData;
    }

    

    // temporarily hide any overflow to avoid visual glitches if there's no data yet
    if (this.overflow != isc.Canvas.HIDDEN && 
        isc.ResultSet && isc.isA.ResultSet(newData) && !newData.lengthIsKnown())
    {
        this._suppressBodyOverflow();
    } else {
        this._restoreBodyOverflow();
    }

    // if newData was passed in, remember it
    if (newData) this.data = newData;

    // if data is not set, bail
    if (!this.data) {
        this.dataSetChanged();
        return;
    }

    // create a new selection if we don't have one or if we receive new data
    
    if (!this._isGrouped && !this.isGrouped && 
        (!this.selectionManager || (this.data != this.selectionManager.data))) 
    {
        this.createSelectionModel();
    }

    // observe the data so we will update automatically when it changes
    this._observeData(this.data);

    var sortFromData, sortSpecifiers;
    // if data is a resultSet, and it already has both data and sortSpecifiers, apply the
    // sortSpecifiers from the ResultSet to this grid, replacing those already on the grid
    if (isc.isA.ResultSet(this.data) && !(clearGroupBy && this.sortByGroupFirst) && 
        (sortFromData = this.data.getSort()) && this.data.lengthIsKnown())
    {
        
        sortFromData = sortFromData.filter(function (specifier) {
            return !specifier.sortedImplicitly;
        });
        sortSpecifiers = sortFromData;
    } else {
        sortSpecifiers = this.getSort();
    }
    
    
    var groupByFields = this._groupByFields || this.getGroupByFields() || isc._emptyArray;
    if (sortSpecifiers || (this.sortByGroupFirst && !groupByFields.isEmpty())) {
        if (this.fields) this.setSort(sortSpecifiers);
        else {
            // if there are no fields, run setSort() later from setFields() 
            this.initialSort = sortSpecifiers;
            this._pendingSort = true;
        }
    }

    // Call this._remapEditRows() if we're hanging onto edit values
    // as we know they're now out of date.
    
    if (this.preserveEditsOnSetData) this._remapEditRows();

    // if we can regroup, do so.
    
    this.regroup(true);

    this.calculateRecordSummaries(/* records */ null, /* fields */ null,
                                  /* recalculateSummaries */ true,
                                  /* suppressDisplay */ true);

    // if this.alwaysShowEditors is set, and we have data, and we're not currently showing
    // editors, show them now.
    
    var fetching = isc.ResultSet && isc.isA.ResultSet(this.data) && !this.data.lengthIsKnown();
    if (!fetching && this._alwaysShowEditors() && !this._editorShowing) {
        this.startEditing(null,null,true,null,true);
    }

    if (this.hilites) this.applyHilites(true);

    
    if (isc.ResultSet && isc.isA.ResultSet(this.data) &&
        !(this.data.allRows && this.data.neverDropCache) &&
        this.body && this.body.overflow == "visible")
    {
        this.body.showAllRows = false;
    }

    // clear out the current expanded row count, along with the current expanded record,
    // if there is one, since the expansionComponents have been dropped, along with the
    // records they were in
    this._expandedRecordCount=0;
    if (!this.canExpandMultipleRecords && this._currentExpandedRecord)
        delete this._currentExpandedRecord;

    if (this._lastStoredSelectedState) {
        this.setSelectedState(this._lastStoredSelectedState);
        delete this._lastStoredSelectedState;
    }

    // if any fields are marked as autoFitWidth, recalculate their sizes
    
    if (this.isEmpty() && ((isc.ResultSet && isc.isA.ResultSet(this.data)) || 
                    (isc.ResultTree && isc.isA.ResultTree(this.data))) )
    {
        this._updateFieldWidthsOnDataArrived = true;
    } else {
        this.updateFieldWidthsForAutoFitValue("setData called.");
    }

    // mark us as dirty so we'll be redrawn if necessary
    this._markBodyForRedraw("setData");
    this.updateBodyCanFocusForData();

    this.dataSetChanged();
},


// Determine which field to expand when autoFitFieldWidths is true and the
// fields don't take up the full set of space available.
// If +link{listGrid.autoFitExpandField} is explicitly set use it.
// Otherwise, basically we want to find the first field that will not look odd to expand
// Implementation:
// - if a field is not of type text, ignore (don't want to expand images, dates, booleans, numbers)
// - If field has showValueIconsOnly set, ignore (even though it has text content it shouldn't
//   expand beyond the value icons width)
// - field.length:
//      - if all fields have field.length specified, expand the largest one
//      - if no fields have this property set, just expand the first text field
//      - if *some* fields have field.length set - the length may indicate a small field
//        (say 2 characters) which we don't want to expand.
//        Expand fields with no specified length in preference to those with
//        a small specified length.
autoFitExpandLengthThreshold : 10,
getAutoFitExpandField : function () {
    if (!this.autoFitFieldsFillViewport) return null;

    if (this.autoFitExpandField != null) {
        var field = this.getField(this.autoFitExpandField);
        // We don't support auto-expanding a frozen field at this time
        
        if (field != null && this.fields && this.fields.contains(field) &&
            (!this.frozenFields || !this.frozenFields.contains(field)))
        {
            return field;
        }
    }
    var fields = [], lengthFields = [];

    if (this.fields) {
        for (var i = 0; i < this.fields.length; i++) {
            var field = this.fields[i];
            if (!field.showValueIconOnly &&
               (field.type == null ||
                (isc.SimpleType.inheritsFrom(field.type, "text") && 
                 !isc.SimpleType.inheritsFrom(field.type, "image"))
               ))
            {
                if (!this._suppressedFrozenFields && field.frozen) continue;
                fields.add(field);
                
                if (field != null && field.length != null && field.maxWidth == null) {
                   lengthFields.add(field);
                }

            }
        }
    }

    if (lengthFields.length > 0) {
        lengthFields.sortByProperty("length", Array.DESCENDING);
        if (lengthFields.last().length >= this.autoFitExpandLengthThreshold ||
            lengthFields.length == fields.length)
        {
            return lengthFields[0];
        }
    }
    if (fields.length > 0) {
        
        if (fields.filter(function (field) {return field.maxWidth != null;}).length > 0) {
            fields.sortByProperty("minWidth", Array.DESCENDING, function (field) {
                return field.maxWidth || Infinity;
            });
        }
        var i = 0;
            field = fields[i]
        // Note: This conditional contains cases where we should *not* auto expand the field
        while (field != null &&
                // Respect explicitly specified pixel width
                ((field.width != null && field.width != "*") ||
                // Explicit length less than the min "expand" number of characters
                 (field.length != null &&
                    field.length < this.autoFitExpandLengthThreshold))
              )
        {
            i++;
            field = fields[i];
        }
        return field;
    }

    // Note that this could still return null - no text fields etc.
    return null;
},

// updateFieldWidthsForAutoFitValue()
// If this.autoFitWidthApproach means we size to
// column data and any fields are marked as autoFitWidth:true,
// this method will set the _fieldWidthsDirty flag on the gridRenderer, causing
// _updateFieldWidths() to be called on the next body redraw,
// Calling code should call this before causing a body redraw.
updateFieldWidthsForAutoFitValue : function (reason) {
    var fields = this.fields;
    if (!fields) return;
    for (var i = 0; i < fields.length; i++) {
        var field = fields[i],
            body = this.getFieldBody(field);
        if (!body || body._fieldWidthsDirty) continue;

        var shouldAutoFit = this.shouldAutoFitField(field);
        if (!shouldAutoFit) continue;
        var approach = this.getAutoFitWidthApproach(field);

        if (approach == "value" || approach == "both") {
            fields._appliedInitialAutoFitWidth = false;
            body._fieldWidthsDirty = "Updating field widths for field auto-fit" +
                                     (reason ? ": " + reason : ".");
            body.markForRedraw(body._fieldWidthsDirty);
        }
    }
},

invalidateCache : function () {
    // make sure that header checkbox is unchecked after refreshing cache
    // (Only do this if we're not maintaining selection across filters etc)
    var selectionManager = this.selectionManager,
        trackUnloadedItems = selectionManager && 
                            selectionManager._shouldTrackUnloadedItems && 
                            selectionManager._shouldTrackUnloadedItems()
    ;

    
    if (!trackUnloadedItems && this.getCheckboxFieldPosition() != -1) {
        var defaultIsSelected = selectionManager.defaultIsSelected;
        if (defaultIsSelected) {
            this.selectAllRecords();
        } else {
            this.deselectAllRecords();
        }
        this._setCheckboxHeaderState(defaultIsSelected);   
    } 

    // if we have a stored drawArea, delete it now so that the
    // redraw recalculates it and reapplies recordComponents
    if (this.body && this.body._oldDrawArea) delete this.body._oldDrawArea;

    // clear metadata - last caller from dataChanged() of master grid
    if (this._isSummaryRow) delete this._masterGridDataChangedTXID;
 
    try {
        return this.Super("invalidateCache", arguments);
    } finally {
        this.dataSetChanged();
    }
},

dataSetChanged : function () {
    
    this._clearGridSummaryData();

    
    delete this._virtualScrollingLocked;
},

// use this rather than field.canSort to handle canSortClientOnly fields
_canSort : function (field) {
    if (!isc.isAn.Object(field)) {
        field = this.getSpecifiedField(field);
    }
    if (field == null) return false;

    var canSort = (field.canSort == false) ? false : this.canSort == false ? false : true;
    canSort = canSort && this._canSortData(field);

    return canSort;
},

_canSortData : function (fieldName) {
    
    var field = isc.isAn.Object(fieldName) ? fieldName : this.getSpecifiedField(fieldName);
    if (field == null) return false;

    if (isc.isAn.Array(this.data)) return true;
    if (field.canSortClientOnly == true) {
        if (isc.isA.ResultSet(this.data)) {
            if (!this.data.lengthIsKnown() || !this.data.canSortOnClient()) {
                return false;
            }
        }
    }

    return true;
},

// helper to determine whether this grid can be sorted on multiple fields - returns false if
// either canMultiSort or canSort are false, or if the data itself doesn't support multiSort
_canMultiSort : function () {
    var canMultiSort = (this.canMultiSort != false) && this.canSort && this._canMultiSortData();
    return canMultiSort;
},

// helper to determine whether this grid's data supports sorting on multiple fields
_canMultiSortData : function () {
    var canMultiSort = this.canMultiSort;

    // if data doesn't support setSort (resultSet and Array do), disable multiSort
    if (!this.data || !this.data.setSort) {
        canMultiSort = false;
    } else if (this.getDataSource() && canMultiSort != false) {
        canMultiSort = this.getDataSource().canMultiSort && this.canSort;
    }

    return canMultiSort;
},

// helper method to get an appropriate sortDirection for a field
_getFieldSortDirection : function (field) {
    var field = isc.isAn.Object(field) ? field : this.getSpecifiedField(field),
        direction;

    var fieldDir = field ? field.sortDirection : null;
    if (fieldDir != null) {
        direction = Array.shouldSortAscending(fieldDir) ? "ascending" : "descending";
    } else if (this.sortDirection != null) {
        direction = Array.shouldSortAscending(this.sortDirection) ? "ascending" : "descending";
    } else {
        direction = Array.shouldSortAscending(this._baseSortDirection) ? "ascending" : "descending";
    }

    return direction;
},

// Override createSelectionModel, from DataBoundComponent, to set the body's selection object
// with our selection object. Our body GridRenderer will then observe selection.setSelected.
createSelectionModel : function () {

    this.invokeSuper(isc.ListGrid, "createSelectionModel", arguments);
    
    if (isc.isA.Canvas(this.body)) {
        this.body.setSelection(this.selectionManager);
        if (this.frozenBody) {
            this.frozenBody.setSelection(this.selectionManager);
            // create separate selection objects for body/frozenBody
            this._separateDependentSelections();
        }
    }
},


selectionChange : function (record, newState) {
    if (this.body == null && this.selectionChanged != null) {
        this.selectionChanged(record, newState);
    }
},

destroySelectionModel : function () {
    if (this.body) this.body.clearSelection();
    if (this.frozenBody) this.frozenBody.clearSelection();
    return this.Super("destroySelectionModel", arguments);
},

//> @method listGrid.setSelectionType() [A]
// Changes selectionType on the fly.
// @param   selectionType (SelectionStyle)  New selection style.
// @visibility external
//<
setSelectionType : function (selectionType, ignoreCheckbox) {
    // NOTE: this is sufficient because the Selection object dynamically inspects this property
    // on it's grid
    this.selectionType = selectionType;
    if (this.body) this.body.selectionType = selectionType;
    if (this.frozenBody) this.frozenBody.selectionType = selectionType;
},

//> @method listGrid.setSelectionAppearance()
// Changes selectionAppearance on the fly.
// @param   selectionAppearance (SelectionAppearance)    new selection appearance
// @visibility external
//<
setSelectionAppearance : function (selectionAppearance, isInit) {
    if (this.selectionAppearance == selectionAppearance && !isInit) return;

    this.selectionAppearance = selectionAppearance;

    // at initialization time, if selectionType wasn't explicitly set, default selectionType to
    // "simple" for "checkbox" appearance, otherwise "multiple"
    if (isInit && this.selectionType == null && !this.canSelectCells) {
        this.selectionType = (selectionAppearance == "checkbox" ? isc.Selection.SIMPLE :
                                                                  isc.Selection.MULTIPLE);
    }

    // If this.completeFields is set (IE setFields has run already), we need to either add or
    // remove the checkboxField
    // Call setFields() with a duplicate of the current set of fields, less the
    // checkboxField (if there was one)
    // This will create a new checkboxField if necessary otherwise just clear the existing one
    if (this.completeFields != null) {
        var completeFields = [];
        for (var i = 0; i < this.completeFields.length; i++) {
            var field = this.completeFields[i];
            if (this.isCheckboxField(field)) continue;
            completeFields.add(field);
        }
        this.setFields(completeFields);
    }
},

//> @attr listGrid.discardDataOnSetFetchOperation (boolean : true : IRA)
// If +link{setFetchOperation()} is invoked while this grid is showing a filtered data-set,
// should the data set be discarded?
// @visibility external
//<

discardDataOnSetFetchOperation:true,

//> @method listGrid.setFetchOperation()
// Update the +link{fetchOperation} at runtime.
// <P>
// If this grid is currently showing a filtered data set it will be discarded by default.
// Developers may issue a new +link{fetchData(),fetch} to fetch a new set of data using
// the new operation. Set +link{discardDataOnSetFetchOperation} to false to avoid
// dropping the existing set of data automatically. In this case if you want to
// clear the existing data you should call +link{setData()} and pass in an empty array
// in application code.
// <P>
// Developers should be aware changing the fetch operation at runtime can lead to
// a bad user experience in some cases.
// <P>
// For example if a fetch operation does not provide data for fields that are visible
// (or fails to provide hidden data used in formula fields, etc), this may lead
// to missing values in the grid.
// <P>
// Similarly, any smart behaviors based on the operationBinding definition, 
// such as special treatment of operationBindings that involve Server Summaries, or 
// any automated behavior around picking visible fields, or determining which fields are editable,
// will not be recalculated in response to <code>setFetchOperation()</code>
// <P>
// If you need such ground-up recalculation, consider re-creating the grid as a whole instead.
// @param operationId (String) new fetch operation ID.
// @return (ListGrid) this grid
// @visibility external
//<

setFetchOperation : function(operationId) {
    if (this.fetchOperation == operationId) return this;

    this.Super("setFetchOperation", arguments);
    if (this.hasFilteredData() && this.discardDataOnSetFetchOperation) {
        this.logInfo("fetch operation has changed: Current data set will be discarded");
        this.setData([]);
    }
    return this;
},


//> @method listGrid.setBodyOverflow()  ([A])
// Update the +link{listGrid.bodyOverflow, bodyOverflow} for this listGrid.
// @param overflow (Overflow) new overflow setting for the body
// @visibility external
//<
setBodyOverflow : function (newOverflow) {
    if (this._specifiedBodyOverflow) {
        this._specifiedBodyOverflow = newOverflow;
    } else        this.bodyOverflow = newOverflow;
    if (this.body) this.body.setOverflow(this.bodyOverflow);
},

// cache current overflow, then set overflow: "hidden"
_suppressBodyOverflow : function () {
    if (this._specifiedBodyOverflow) return;
    var overflow = this.bodyOverflow;
    this.setBodyOverflow(isc.Canvas.HIDDEN);
    this._specifiedBodyOverflow = overflow;
},

// restore overflow cached by _suppressBodyOverflow()
_restoreBodyOverflow : function () {
    var overflow = this._specifiedBodyOverflow;
    if (overflow) {
        delete this._specifiedBodyOverflow;
        this.setBodyOverflow(overflow);
    }
},

//> @method listGrid.setBodyStyleName()
// Update the +link{listGrid.bodyStyleName,bodyStyleName} for this listGrid.
// @param styleName (CSSStyleName) new body style name
// @visibility external
//<
setBodyStyleName : function (styleName) {
    this.bodyStyleName = styleName;
    if (this.body && (!this.alternateBodyStyleName || !this.alternateRecordStyles)) {
        this.body.setStyleName(styleName);
    }
},

//> @method listGrid.setAlternateBodyStyleName()
// Update the +link{listGrid.alternateBodyStyleName,alternateBodyStyleName} for this listGrid.
// @param styleName (CSSStyleName) new body style name when showing alternateRecordStyles
// @visibility external
//<
setAlternateBodyStyleName : function (styleName) {
    this.alternateBodyStyleName = styleName;
    if (this.body && this.alternateRecordStyles) {
        // if passed 'null', reset to this.bodyStyleName
        this.body.setStyleName(styleName || this.bodyStyleName);
    }
},

//> @method listGrid.setAlternateRecordStyles()
// Setter for +link{listGrid.alternateRecordStyles}
// @param alternateStyles (boolean) New value for <code>this.alternateRecordStyles</code>
// @visibility external
//<
setAlternateRecordStyles : function (alternateStyles) {
    if (this.alternateRecordStyles == alternateStyles) return;
    this.alternateRecordStyles = alternateStyles;

    if (this.body && (this.alternateBodyStyleName != null)) {
        if (alternateStyles) this.body.setStyleName(this.alternateBodyStyleName);
        else this.body.setStyleName(this.bodyStyleName);
    }

},

// Override hasInherentHeight / width: If we're autoFitting to our data, advertise inherent height
// This means that a layout will not expand us to fit the available space.

hasInherentHeight : function (a,b,c,d) {
    if (this.inherentHeight != null) return this.inherentHeight;
    if (this.autoFitData == isc.Canvas.VERTICAL || this.autoFitData == isc.Canvas.BOTH) {
        return true;
    }
    return this.invokeSuper(isc.ListGrid, "hasInherentHeight", a,b,c,d);
},

hasInherentWidth : function (a,b,c,d) {
    if (this.inherentWidth != null) return this.inherentWidth;
    if (this.autoFitData == isc.Canvas.HORIZONTAL || this.autoFitData == isc.Canvas.BOTH) {
        return true;
    }
    return this.invokeSuper(isc.ListGrid, "hasInherentWidth", a,b,c,d);
},

//> @method listGrid.setAutoFitData()
// Setter for +link{listGrid.autoFitData}.
// @param autoFitData (Autofit) One of <code>"vertical"</code>, <code>"horizontal"</code>
//  or <code>"both"</code>. To disable auto fit behavior, pass in <code>null</code>.
// @group autoFitData
// @visibility external
//<
setAutoFitData : function (autoFitData) {
    this.autoFitData = autoFitData;

    if (this._autoDerivedCanFreeze && (autoFitData == "both" || autoFitData == "horizontal")) {
        delete this._autoDerivedCanFreeze;
        delete this.canFreezeFields;
    }
    if (autoFitData == null && this._specifiedOverflow) {
        this.setOverflow(this._specifiedOverflow);
    } else if (this.overflow != "visible") {
        this._specifiedOverflow = this.overflow;
        this.setOverflow("visible");
    }
    if (this.body) {
        this.body.autoFitData = this.autoFitData;
        this.body.adjustOverflow();
    }
    if (this.frozenBody) {
        this.frozenBody.autoFitData = this.autoFitData;
        this.frozenBody.adjustOverflow();
    }
},

// On dragResize, we need to turn off autoFitData behavior, as the desired size is now being explicitly
// specified rather than driven by content.
dragResizeStart : function () {
    this.resizeTo(this.getVisibleWidth(),this.getVisibleHeight());
    this.setAutoFitData("none");
    return this.Super("dragResizeStart", arguments);
},

//> @method listGrid.setAutoFitExtraRecords()
// Setter for +link{listGrid.autoFitExtraRecords}.
// @param extraRecords (Integer) Number of extra rows beyond the data-size we'll expand to
// accommodate if +link{listGrid.autoFitData,auto fit} is enabled vertically.
// @group autoFitData
// @visibility external
//<
setAutoFitExtraRecords : function (extraRecords) {
    this.autoFitExtraRecords = extraRecords;
    if (this.body) {
        this.body.autoFitExtraRecords = extraRecords;
        this.body.adjustOverflow();
    }
},


//> @method listGrid.setAutoFitMaxRecords()
// Setter for +link{listGrid.autoFitMaxRecords}.
// @param maxRecords (int) Maximum number of rows we'll expand to accommodate if
// +link{listGrid.autoFitData,auto fit} is enabled vertically.
// @group autoFitData
// @visibility external
//<
setAutoFitMaxRecords : function (maxRecords) {
    this.autoFitMaxRecords = maxRecords;
    if (this.body) {
        this.body.autoFitMaxRecords = maxRecords;
        this.body.adjustOverflow();
        if (this.frozenBody) {
            this.frozenBody.autoFitMaxRecords = maxRecords;
            this.frozenBody.redraw();
        }
    }
},

//> @method listGrid.setAutoFitMaxHeight()
// Setter for +link{listGrid.autoFitMaxHeight}.
// @param height (Integer) Maximum height in px we'll expand to accommodate if
// +link{listGrid.autoFitData,auto fit} is enabled vertically.
// @group autoFitData
// @visibility external
//<
setAutoFitMaxHeight : function (height) {
    this.autoFitMaxHeight = height;
    if (this.body) {
        this.body.adjustOverflow();
        if (this.frozenBody) this.frozenBody.redraw();
    }
},
getAutoFitMaxBodyHeight : function () {
    if (this.autoFitMaxHeight == null) return null;
    var autoFitMaxHeight = +this.autoFitMaxHeight;
    if (!isc.isA.Number(autoFitMaxHeight)) {
        this.logWarn("Could not convert autoFitMaxHeight to a number");
        return null;
    }
    var offset = this.getVBorderPad();
    if (this.showHeader) offset += this.getHeaderHeight();
    if (this.showFilterEditor) offset += this.filterEditorHeight;
    if (this.showGridSummary) offset += this.summaryRowHeight;
    return autoFitMaxHeight - offset;
},

// When auto-fitting vertically, specified height for the grid acts as a minimum
getAutoFitMinBodyHeight : function () {

    var minHeight = this.getTotalMemberSpace(),
        offset = 0;
        
    
    var members = this.getGridMembers(true),
        body = this.bodyLayout || this.body;
        
    for (var i = 0; i < members.length; i++) {
        if (members[i] == body) continue;
        // skip explicitly hidden grid-components
        // (Checking visibility property rather than isVisible() to avoid confusion when
        // the grid as a whole is hidden, but drawn)
        if (members[i].visibility == isc.Canvas.HIDDEN) continue;
        offset += members[i].getVisibleHeight();
    }

    return (minHeight - offset);
},

//> @method listGrid.setAutoFitMaxColumns()
// Setter for +link{listGrid.autoFitMaxColumns}.
// @param maxColumns (int) Maximum number of fields we'll expand to accommodate if
// +link{listGrid.autoFitData,auto fit} is enabled horizontally.
// @group autoFitData
// @visibility external
//<
setAutoFitMaxColumns : function (maxColumns) {
    this.autoFitMaxColumns = maxColumns;
    if (this.body) {
        this.body.autoFitMaxColumns = maxColumns;
        this.body.adjustOverflow();
    }
},

//> @method listGrid.setAutoFitMaxWidth()
// Setter for +link{listGrid.autoFitMaxWidth}.
// @param width (Integer | String) Width we'll expand to accommodate if
// +link{listGrid.autoFitData,auto fit} is enabled horizontally.
// @group autoFitData
// @visibility external
//<
setAutoFitMaxWidth : function (width) {
    delete this._autoFitMaxPixelWidth;
    this.autoFitMaxWidth = width;
    if (this.body) {
        this.body.autoFitMaxWidth = width;
        this.body.adjustOverflow();
    }
},

// --------------------------------
// AutoFitFields

//> @method listGrid.autoFitField()
// Programmatically cause a field to auto-fit horizontally to it's contents or title.
// <P>
// Does not establish permanent auto-fitting - use +link{listGrid.setAutoFitWidth()} or
// +link{setAutoFitFieldWidths()} to do so.
// <P>
// Note that unlike the ongoing autoFit set up by +link{listGrid.autoFitFieldWidths} or
// +link{listGridField.autoFitWidth}, any specified +link{listGridField.width} will not be
// taken as a minimum width - the field may shrink below the current specified width when
// this method is run.  However, +link{listGridField.minWidth} will be respected.
// <P>
// As with +link{listGrid.autoFitFieldWidths}, the auto-fit sizing is determined via the
// +link{listGrid.autoFitWidthApproach}.
//
// @param fieldName (String)
// @return (int) new width in pixels
//
// @group autoFitFields
// @visibility external
//<
autoFitField : function (fieldName, scrollIntoView) {
    var field = this.getField(fieldName),
        fieldNum = this.getFieldNum(field);
    // avoid attempting to autofit hidden fields, or fields where
    // autoFitWidth is already set (should just happen dynamically!)
    if (field == null || fieldNum == -1) return;


    

    var widths = this.getFieldAutoFitWidths([field]);
    
    if (widths == null || widths[0] == null) return;
    
    // Set a flag noting that we're auto-fitting this field.
    // We'll use this to suppress normal reflow in reaction to the 'headerButtonResized' notification.
    // Treat this somewhat similarly to a drag-resize.
    this._autoFittingField = field;
    
    var width = widths[0];
    // resize the field (as if the user drag-resized to the auto-fit size)
    var dontStoreWidth = this.shouldAutoFitField(field);
    if (this._fieldWidths && width != this._fieldWidths[fieldNum]) {
        this._resizeField(fieldName, width, !dontStoreWidth);
    } else if (!dontStoreWidth) field.width = width;
    if (this._fieldWidths && dontStoreWidth) field._calculatedAutoFitWidth = this._fieldWidths[fieldNum];

    if (scrollIntoView) this.scrollToColumn(fieldNum, "left");

    // When a field is auto-fit, if the headerMenuButton is showing for the field, then we
    // will want to reposition the HMB if this is a touch device (on which the HMB is always
    // shown if the header is selected) or if the mouse is still within the the header button.
    // Otherwise, hide the HMB.
    if (this.headerMenuButton != null && this.headerMenuButton.masterIndex == fieldNum) {
        // getFieldHeader / getLocalFieldNum will account for frozen fields
        var header = this.getFieldHeader(fieldNum),
            headerButton = header.getMember(this.getLocalFieldNum(fieldNum));

        var EH = this.ns.EH;
        if (isc.Browser.isTouch ||
            headerButton.containsPoint(EH.getX(), EH.getY()))
        {
            // Refresh the cached scrollWidth of the header button. This is needed for the
            // case where the header button is marked for redraw, but getHeaderMenuButton()
            // needs the new scrollWidth of the just-resized header button.
            headerButton.getScrollWidth(true);

            this.getHeaderMenuButton(headerButton);

        } else {
            this.headerMenuButton.hide();
        }
    }
    
    delete this._autoFittingField;

    return width;
},

//> @method listGrid.autoFitFields()
// Perform a one-time horizontal auto-fit of the fields passed. Fields will be sized
// to match their contents or title (as specified in +link{listGrid.autoFitWidthApproach})
// Does not establish permanent auto-fitting - use +link{listGrid.setAutoFitWidth()} to do so.
// <P>
// Note that unlike the ongoing autoFit set up by +link{listGrid.autoFitFieldWidths} or
// +link{listGridField.autoFitWidth}, any specified +link{listGridField.width} will not be
// taken as a minimum width - the field(s) may shrink below the current specified width when
// this method is run.  However, +link{listGridField.minWidth} will be respected.
// <p>
// For information about auto-fitting specific fields, see +link{listGridField.autoFit}.
// @param [fields] (Array of ListGridField) Array of fields to auto fit. If this parameter
//  is not passed, autoFitting will occur on all visible fields.
//
// @group autoFitFields
// @visibility external
//<
autoFitFields : function (fields) {
    // We don't support one-time autofit while undrawn.
    if (!this.isDrawn()) {
        this.logWarn("autoFitFields() called on undrawn grid. This will have no effect. " +
                     "For one-time auto-fit to drawn sizes, call this method after draw. " +
                     "To establish permanent auto-fit, use listGrid.autoFitFieldWidths instead.");
        return;
    }
    

    var bodies = this.bodies;
    if (bodies) bodies.setProperty("_fieldWidthsDirty", true);

    this.autoSizeHeaderSpans = false;
    if (fields == null) fields = this.getAllCanAutoFitFields();
    this._autoFittingFields = true;
    var finalFields = [];
    for (var i = 0; i < fields.length; i++) {
        var field = this.getField(fields[i]);        
        if (field != null) {
            delete fields[i].width;
            delete fields[i]._calculatedAutoFitWidth;
            finalFields[finalFields.length] = field;
        }
    }
    // we've removed any hidden fields here.
    fields = finalFields;

    

        
    var widths = this.getFieldAutoFitWidths(fields, this.autoFitFieldsFillViewport);
    var fieldNums = [], resizeWidths = [], storeWidths = [];
    for (var i = 0; i < fields.length; i++) {

        if (widths[i] == null) continue;
        var width = widths[i],
            field = fields[i],
            fieldNum = this.getFieldNum(fields[i]);
        // resize the field (as if the user drag-resized to the auto-fit size)
        var dontStoreWidth = this.shouldAutoFitField(field);
        if (this._fieldWidths && width != this._fieldWidths[fieldNum]) {

            fieldNums[fieldNums.length] = fieldNum;
            resizeWidths[resizeWidths.length] = width;
            storeWidths[storeWidths.length] = !dontStoreWidth;

        } else if (!dontStoreWidth) field.width = width;
    }
    this._resizeFields(fieldNums, resizeWidths, storeWidths);
    for (var i = 0; i < fieldNums.length; i ++) {        
        if (!storeWidths[i]) {
            var fieldNum = fieldNums[i];
            this.getField(fieldNum)._calculatedAutoFitWidth = this._fieldWidths[fieldNum];
        }
    }

    this._autoFittingFields = false;

    // we suppressed placeEmbeddedComponents() during the field resizes, so
    // run it now to ensure any embedded components are correctly positioned and sized.
    if (this.frozenBody) this.frozenBody._placeEmbeddedComponents()
    if (this.body) this.body._placeEmbeddedComponents();
    // Normally we do this in resizeField() but we don't want a bunch of unnecessary
    // reflows so we delay until resize of fields is complete
    if (this.header && this.autoFitHeaderHeights) {
        this.dropCachedHeaderButtonHeights();
        this._updateHeaderHeight();
    }

    // adjust field widths, if needed, to account for the available space;
    // if drawn buttons got resized, then update the GridBody with new widths
    var fieldWidths = this.getFieldWidths("one-time horizontal auto-fit", true);
    if (fieldWidths) this.setBodyFieldWidths(fieldWidths);

    // This will adjust header heights if necessary to account for differently wrapped
    // content
    if (this.header) this.header._sizeSpans();

    // We always mark fieldWidths as dirty. If a redraw wasn't required
    // we can assume the size was unchanged. Clear this flag now or it'll have other
    // impacts such as suppressing scrolling
    if (!this.isDirty()) {
        for (var b = 0, numBodies = !bodies ? 0 : bodies.length; b < numBodies; ++b) {
            var body = bodies[b];
            if (body._fieldWidthsDirty && !body.isDirty()) {
                delete body._fieldWidthsDirty;
            }
        }
    }
},

// Helper to get all (visible) fields where canAutoFitWidth != false
// these are the fields which will be resized by a call to autoFitFields with no arguments
// (and by the auto-fit-all menu option)
getAllCanAutoFitFields : function () {
    var fields = this.fields;
    if (fields == null || fields.length == 0) {
        return fields;
    }
    
    var canAutoFitFieldArray = [];
    for (var i = 0; i < fields.length; i++) {
        if (fields[i].canAutoFitWidth == false) continue;
        canAutoFitFieldArray.add(fields[i]);
    }
    return canAutoFitFieldArray;
},


shouldAutoFitField : function (field) {
    // field.autoFit is the same as autoFitWidthApproach but also implies autoFitWidth: true
    if (field.autoFit != null) return true;
    if (field.autoFitWidth != null) return field.autoFitWidth;
    return this.autoFitFieldWidths;
},

// This method is called directly as part of resizeFields() and acts as a minimum, disallowing
// resizing below the min field width.

getMinFieldWidth : function (field, ignoreFieldWidth) {
    var minWidth = this.minFieldWidth || 1;
    if (!ignoreFieldWidth) {
        
        var fieldWidth = field.width;
        if (isc.isA.Number(fieldWidth)) {
            minWidth = Math.max(minWidth, field.width);
        }
    }
    // this is also enforced by Canvas.applyStretchResizePolicy() if any of the
    // fields are operating as stretch-sized members of the header Layout
    if (field.minWidth != null) {
        minWidth = Math.max(minWidth, field.minWidth);
    }
    var fieldName = field.name;
    // If we have embeddedComponents for the field we should treat that as a minimum
    if (this.showRecordComponents && !this.clipRecordComponents &&
            (this._columnComponentsMap && this._columnComponentsMap[fieldName]))
    {
        var componentMaxWidth = this._getFieldComponentMaxWidth(fieldName);
        if (componentMaxWidth > minWidth) {
            minWidth = componentMaxWidth;
        }
    }

    return minWidth;
},
clipRecordComponents: true,

_getFieldComponentMaxWidth : function (fieldName) {
    var field = this.getField(fieldName);
    if (field == null) return 0;

    if (field._maxComponentWidth != null) return field._maxComponentWidth;

    var components = this._columnComponentsMap[fieldName];
    var maxWidth = 0;
    for (var compID in components) {
        var component = window[compID];
//         this.logWarn("For field:" + fieldName + " contemplating:" + component +
//             " which has width:" + component.getVisibleWidth());
        // skip "expand" components - these are always sized to fit the field.
        if (component && (component.embeddedPosition == this._$within) &&
            (component.getVisibleWidth() > maxWidth) )
        {
            maxWidth = component.getVisibleWidth();
        }
    }
    field._maxComponentWidth = maxWidth;
    return maxWidth;
},

// This method fires when we have embedded components which may overflow the
// specified field width horizontally, so we need to expand to fit.
_fieldComponentWidthsChanged : function (fieldName, newWidth) {
    var field = this.getField(fieldName);
    if (field) {
        // If we happen to know we just increased the size, we can update
        // the max-width without having to query sizes of all drawn components.
        // Otherwise just clear the cached value and we'll lazily recalculate.
        if (newWidth) field._maxComponentWidth = newWidth;
        else delete field._maxComponentWidth;

        // Use "fireOnPause" to actually resize the field to fit the components on a delay
        
        if (this._staleComponentWidthFields == null) {
            this._staleComponentWidthFields = {};
        }
        this._staleComponentWidthFields[fieldName] = true;
        this.fireOnPause(
            "checkFieldComponentOverflow",
            {target:this,methodName:"_checkFieldComponentOverflow"}, 0
        );
    }

},
_checkFieldComponentOverflow : function () {
    if (this.fields == null) return;

    
     
    var currentWidths = this._fieldWidths || this.getFieldWidths(),
        overflowedFields = [],
        newWidths = [],
        storeWidths = [],
        overflowed = false;
    for (var i = 0; i < this.fields.length; i++) {
        var name = this.fields[i].name;
        if (!this._staleComponentWidthFields[name]) continue;
        this._staleComponentWidthFields[name] = null;

        var minWidth = this.getMinFieldWidth(this.fields[i]);
        if (minWidth > currentWidths[i]) {
            overflowedFields.add(i);
            newWidths.add(minWidth);
            // We don't want to store any of these widths. If autoFitFieldWidths
            // is true, if the component is hidden etc we want to be able to resize
            // smaller again if _updateFieldWidthsForAutoFitValue() gets re-run.
            storeWidths.add(false);
        }
    }
    // Embedded components in some cell overflowed the available width - resize
    // the field to accommodate it.
    
    if (overflowedFields.length > 0) {
        this._resizeFields(overflowedFields, newWidths, storeWidths);
    }
},

getFieldAutoFitWidths : function (fields, fillViewport) {
    if (this.body == null || fields == null) return;
    if (!isc.isA.Array(fields)) {
        fields = [fields]
    }
    var widths = [],
        colNums = [],
        minWidths = [];

    var headers = [],
        bodyFields = [];

    for (var i = 0; i < fields.length; i++) {
        var field = fields[i],
            colNum = this.getColNum(field),
            approach = this.getAutoFitWidthApproach(field, true),
            checkHeader = approach != "value",
            checkBody = approach != "title";
            
        // we'll use the colNums outside this loop when we pick up the body col widths
        colNums[i] = colNum;
        widths[i] = minWidths[i] = this.getMinFieldWidth(fields[i], /* ignoreFieldWidth */ true);

        if (checkHeader) {
            var header = this.getFieldHeaderButton(colNum);
            
            if (header != null) headers[i] = header;
        }

        if (checkBody) {
            bodyFields.add(field);
        }

    }
    
    if (headers.length > 0) {
        //var startTime = isc.timeStamp();
        var headerWidths = this.getAutoFitTitleWidths(headers);
        //this.logWarn("Time to get header title widths:" + (isc.timeStamp() - startTime));
        for (var i = 0; i < headerWidths.length; i++) {
        
            
            if (headerWidths[i] == null) continue;
            widths[i] = Math.max(widths[i],headerWidths[i]);
        }
    }
    // for efficiency, pass all the body fields to getAutoFitValueWidths() at once.
    
    if (bodyFields.length > 0) {
        var bodyColWidthArr = this.getAutoFitValueWidths(bodyFields);
        for (var i = 0; i < fields.length; i++) {
            if (colNums[i] != null) {
                var colNum = colNums[i],
                    bodyColWidth = bodyColWidthArr ? bodyColWidthArr[colNum] : null;
                if (bodyColWidth != null) {
                    if (widths[i] == null || bodyColWidth > widths[i]) {
                        widths[i] = bodyColWidth;
                    }
                }
            }
        }
    }
    // If passed the fillViewport flag, and there is extra space, expand the
    // appropriate field by the delta such that we do indeed fill the viewport.
    
    if (fillViewport) {
        var frozenSize = 0,
            unfrozenSize = 0,
            unfrozenSpace,
            expandField = this.getAutoFitExpandField(),
            expandFieldIndex = this.fields.indexOf(expandField),
            requiresExpansion = colNums.contains(expandFieldIndex)
        ;
        if (requiresExpansion) {

            for (var i = 0; i < this.fields.length; i++) {
                var colWidth,
                    index = colNums.indexOf(i);
                if (index >= 0) {
                    colWidth = widths[index];
                } else {
                    colWidth = this._fieldWidths[i];
                    if (colWidth == null) {
                        
                        requiresExpansion = false;
                        break;
                    }
                }
                if (this.fields[i].frozen) {
                    frozenSize += colWidth;
                } else {
                    unfrozenSize += colWidth;
                }
            }
            
            if (requiresExpansion) {
                unfrozenSpace = this.getAvailableFieldWidth(true) - frozenSize;
                requiresExpansion = unfrozenSize < unfrozenSpace;
            }
            if (requiresExpansion) {
                var index = colNums.indexOf(expandFieldIndex);
                
                widths[index] += unfrozenSpace - unfrozenSize;
            }
        }
    }
    // limit the returned widths by the maxWidth value of each field
    for (var i = 0; i < fields.length; i++) {
        var field = fields[i],
            maxWidth = field.maxWidth;
        if (maxWidth == null) continue;
        // don't ever lower the width below the minimum reported by getMinFieldWidth()
        if (widths[i] > maxWidth) widths[i] = Math.max(minWidths[i], maxWidth);
    }

    return widths;
},

getAutoFitTitleWidths : function (headers) {
    var testHTML = "",
        missingHeaders = {};
    for (var i = 0; i < headers.length; i ++) {
        
        if (headers[i] == null) {
            missingHeaders[i] = true;
            continue;
        }
        var header = headers[i],
            titleStyle = header.titleStyle;
        if (titleStyle == null) titleStyle = header.getStateName();
        
        
        testHTML += header._getSizeTestHTML(this.getHeaderButtonTitle(header, false));
    }
    
    if (this.logIsDebugEnabled("autoFitFieldWidths")) {
        this.logDebug("Auto Fit Title test HTML:\n" + testHTML, "autoFitFieldWidths");
    }

    if (isc.ListGrid.headerWidthsTester == null) {
        isc.ListGrid.headerWidthsTester = isc.Canvas.create({
            top:-100,
            
            width: 1,
            autoDraw:true,
            overflow:"hidden",
            contents:testHTML,
            
            ariaState: {
                hidden: true
            }
        });

    } else {
        isc.ListGrid.headerWidthsTester.setContents(testHTML);
    }
    
    
    if (!isc.ListGrid.headerWidthsTester.isDrawn()) {
        isc.ListGrid.headerWidthsTester.draw();
    }
    if (isc.ListGrid.headerWidthsTester.isDirty()) {
        isc.ListGrid.headerWidthsTester.redraw();
    }

    var handle = isc.ListGrid.headerWidthsTester.getHandle(),
        childNodes = handle.childNodes;
    var widths = [];
    for (var i = 0, j=0; i < headers.length; i ++) {
        if (missingHeaders[i]) {
            widths[i] = null;
            continue;
        }
        var titleDiv = childNodes[j];
           
        
        if (isc.Browser.isChrome || isc.Browser.isMoz || isc.Browser.isIE9) {
            var titleBCR = titleDiv.getBoundingClientRect();
            if (!isc.Browser.isIE || isc.Browser.isIE10) {
                widths[i] = Math.ceil(titleBCR.width);
            } else {
                widths[i] = (titleBCR.width + 1) << 0;
            }
        } else {
            widths[i] = Math.ceil(titleDiv.offsetWidth);
        }
        j++;
    }

    if (widths.length != headers.length) {
        this.logWarn("getAutoFitTitleWidths(): Mismatch between " +
            "headers passed in and calculated widths", "autoFitFieldWidths");
    }
    return widths;
},

//> @method listGrid.setAutoFitWidth()
// Setter for +link{listGridField.autoFitWidth}. Enables or disables dynamic autoFitWidth behavior
// on the specified field. Note if the field is currently autoFitWidth:true, and this method is
// disabling autoFit, the field will not be resized by default - if you wish to resize to an
// explicit width, use +link{listGrid.resizeField()}.
//
// @param fieldName (String) field to auto-fit
// @param autoFit (boolean) Should autoFitWidth be enabled or disabled?
// @group autoFitFields
// @visibility external
//<
setAutoFitWidth : function (fieldName, autoFit) {
    var field = this.getField(fieldName);
    if (field == null) return;
    if (field.autoFitWidth == autoFit) return;

    field.autoFitWidth = autoFit;

    if (autoFit) this.autoFitField(field);
    // If we're turning off auto-fit, don't bother to resize
},

//> @method listGrid.setAutoFitFieldWidths()
// Setter for +link{listGrid.autoFitFieldWidths}. Modifies the default auto-fit-width behavior
// for fields in this grid. Note that this may be overridden at the field level via
// +link{listGridField.autoFitWidth}.
// @param autoFit (boolean) New value for autoFitFieldWidths
// @param [dontResetWidths] (boolean) If autoFitFieldWidths was true, and is being set to false,
//  should fields be resized to their originally specified size?
//  Pass in this parameter to suppress this behavior.
// @visibility external
//<
setAutoFitFieldWidths : function (autoFit, dontResetWidths) {
    if (autoFit == this.autoFitFieldWidths) return;
    this.autoFitFieldWidths = autoFit
    if (autoFit) {
        this._updateFieldWidths("autoFitFieldWidths enabled");
    } else if (!dontResetWidths) {
        // If we're showing a header, we use it to handle converting specified
        // field widths into real sizes - running updateHeader will rebuild it and
        // perform this initial calculation for us.
        if (this.showHeader && this.headerHeight > 0) this.updateHeader();
        // Clear the flag indicating we've run through auto-fit logic and re-run
        // _updateFieldWidths() to revert the fields to specified sizes.
        this.fields._appliedInitialAutoFitWidth = false;
        this._updateFieldWidths("autoFitFieldWidths disabled");
    }
},

//> @method listGrid.setAutoFitWidthApproach()
// Setter for the +link{listGrid.autoFitWidthApproach}.
// @param approach (AutoFitWidthApproach) new AutoFitWidth approach
// @visibility external
//<
setAutoFitWidthApproach : function (approach) {
    if (this.autoFitWidthApproach == approach) return;
    this.autoFitWidthApproach = approach;

    // If we're showing a header, we use it to handle converting specified
    // field widths into real sizes - running updateHeader will rebuild it and
    // perform this initial calculation for us.
    
    if (this.showHeader && this.headerHeight > 0) this.updateHeader();
    // Clear the flag indicating we've run through auto-fit logic and re-run
    // _updateFieldWidths() to revert the fields to specified sizes.
    this.fields._appliedInitialAutoFitWidth = false;
    this._updateFieldWidths("'autoFitWidthApproach' changed");
},

// mark the body for redraw, or if the body doesn't exist, the widget as a whole
_markBodyForRedraw : function (reason) {
    if (this.bodies) {
        this.bodies.callMethod("markForRedraw", reason);
    } else if (this.body) {
        this.markForRedraw(reason);
    }
},

redraw : function (a, b, c, d) {
    if (this.body) {
        
        if (this.body._scrollbarChangeDuringAnimation) {
            this._updateFieldWidths("scrollbar change during animation");
            delete this.body._scrollbarChangeDuringAnimation;
        }
    }

    this.invokeSuper(isc.ListGrid, "redraw", a, b, c, d);
},

//> @method listGrid._observeData() (A)
//      observe methods on the data so we redraw automatically when data changes
//      called automatically by setData
//  @param  data    (Object)        new data to be observed
//<
_observeData : function (data) {
    this.Super("_observeData", arguments);
    // redraw if the data changed
    var isRS = isc.ResultSet && isc.isA.ResultSet(data);
    if (!this.isObserving(data, "dataChanged")) {
        if (isRS) {
            this.observe(data, "dataChanged", 
                         function (operationType, originalRecord, rowNum, updateData, 
                                   filterChanged, dataFromCache) 
                         {
                             this.dataChanged(operationType, originalRecord, rowNum, updateData,
                                              filterChanged, dataFromCache);
            });
        } else if (isc.ResultTree && isc.isA.ResultTree(data)) {
            this.observe(data, "dataChanged", function (operationType) {
                // data._lastOperation set from RT.loadChildrenReply()
                this.dataChanged(operationType || data._lastOperation);
            });
        } else {
            this.observe(data, "dataChanged", function () {
                this.dataChanged();
            });
        }
    }

    if (!this.isObserving(data, "dataArrived")) {
        if (isRS) {
            this.observe(data, "dataArrived", function (startRow, endRow, dataFromCache) {
                this._dataArrived(startRow, endRow, dataFromCache);
            });
        } else if (isc.ResultTree && isc.isA.ResultTree(data)) {
            this.observe(data, "dataArrived", function (parentNode) {
                this._dataArrived(parentNode);
            });
        }
    }

    if (!this.isObserving(data, "rowCountFetchComplete") && isRS) {
        //this.logWarn("setting up obs");        
        this.observe(data, "rowCountFetchComplete", function () {
            this.rowRangeDisplayValueChanged("Row Count Fetch Complete");
        });
    }
        
    // Note - we must check for data being a tree as if it is not defined, the inherited
    // ListGrid.init() code will set it to an empty array, in which case this observation will
    // fail.
    if (isc.isA.Tree(data)) {
        // update view in response to folders opening / closing
        this.observe(data, "changeDataVisibility", function (node, newState) {
            this._folderToggleObservation(node, newState);
        });
    }
    
    
    if (this.hiddenResultSet) this.hiddenResultSet.destroy();
    if (isc.isAn.Array(data) && this.filterLocalData &&
        this.dataSource && isc.isAn.DataSource(this.dataSource)) {
        this.hiddenResultSet = isc.ResultSet.create({
            dataSource : this.dataSource,
            allRows : data
        });
    }

},
//> @method listGrid.groupTreeDataChanged()
// Callback fired from group tree +link{listGrid.groupTree} dataChanged().
// <p>
// Handles remapping edit rows and forcing a redraw if necessary.
// @group grouping
//<
// The groupTree may be a ResultTree or a Tree object.
// When a listGrid is grouped we still observe dataChanged on the underlying data object and react
// to it by updating or rebuilding the groupTree as required, and marking for redraw etc.
// Therefore if this method is fired from standard dataChanged() we typically need to take no
// action.
// Note that we explicitly disable databound cache-sync for the ResultTree and instead manage
// updating the ResultTree cache directly as part of ListGrid.dataChanged. This is appropriate since
// The ResultTree code for cache sync is organized around node ids and parent ids whereas the
// groupTree is a dynamic grouping based on records have the same values for a field.
//
// This will actually fire in response to listGrid sort or direct manipulation of the groupTree
//
// Note that this method is only fired when an existing groupTree changes - not when regroup()
// is run, creating a new groupTree.
groupTreeDataChanged : function () {
    // If the groupTree was updated from underlying data change, no need to
    // redraw etc (already handled in dataChanged())
    if (this._handlingDataChanged) return;

    if (!this._savingEdits && !this.suppressEditRowRemap) this._remapEditRows();
    var lastRow = this.getTotalRows()-1;
    if (this.body) {
        
        if (this.body.lastOverRow > lastRow) delete this.body.lastOverRow;
        if (this.body.lastMouseOverRow > lastRow) delete this.body.lastMouseOverRow;
        if (this.body._lastHiliteRow > lastRow) {
             delete this.body._lastHiliteRow;
             delete this.body._lastHiliteCol;
        }
    }
    if (this._lastRecordClicked > lastRow) delete this._lastRecordClicked;

    if (this.hilites) this.applyHilites(true);
    if (!this._suppressRedrawOnDataChanged) this.markForRedrawDataChanged();

},

//> @method listGrid._observeGroupData() (A)
//      observe methods on the group tree object, so that changes to the group layout
//      can be detected
//  @param  data    (Object)        new group tree to be observed
//  @visibility internal
//<
_observeGroupData : function (data) {
    // redraw if the data changed
    this.observe(data, "dataChanged", function (type) {
        // If dataChanged() was fired by the field generation subsystem, then we don't have to
        // do anything here because the field gen. subsystem will also call _pseudoFieldGenerated()/
        // _asyncFieldGenerationPartialResult()/_fieldsGenerated(). Those are our opportunities
        // to redraw and/or update the drawn cells in place.
        if (type != "fieldGeneration") this.groupTreeDataChanged();
    });
    this.observe(data, "changeDataVisibility", function (node, newState) {
        this._folderToggleObservation(node, newState);
    });
},

// METHODS MOVED FROM TREEGRID
// The following methods were moved from treegrid to allow the listgrid to support the tree
// as a data model for grouping. They will continue to be doc'd on treegrid for now

// Helper method - fired when folders open/close within the tree
_folderToggleObservation : function (node, newState) {
    // If we're loaded, reapply hilites, but pass in the flag to suppress marking for redraw
    // We need to do this since we won't get a dataChanged notification from the
    // children loading.
    // No need to redraw here since we will redraw (below) in response to the folder toggling.
    if (node != null && this.hilites && newState) {
        var loadState = this.data.getLoadState(node);
        if (loadState == isc.Tree.LOADED || loadState == isc.Tree.LOADED_PARTIAL_CHILDREN) {
            if (this.data._batchFolderToggleObs) {
                this._deferredApplyHilites = true;
            }
            else this.applyHilites(true);
        }
    }
    //>Animation
    // During animated folder open/close we suppress redraw in response to the folder toggling
    
    if (this._suppressFolderToggleRedraw) {
        // Re run auto fit logic expand our cols to fit the revealed content
        
        this.__folderToggleObservation();
        return;
    }

    // Cut short any currently running animated folder open / close
    // Just call finishAnimation - this will no op if no animation is running
    
    if (this.body) this.body.finishRowAnimation();
    //<Animation

    this.__folderToggleObservation();

    // redraw to display the updated folder
    this._markBodyForRedraw('folderToggled');
},

__folderToggleObservation : function () {
    if (this.data && this.data._batchFolderToggleObs) {
        this._folderToggleObsRan = true;
        return;
    }
    // Length changes so we need to remap edit rows.
    this._remapEditRows();

    // Re run auto fit logic expand our cols to fit the revealed content
    this.updateFieldWidthsForAutoFitValue("Folder Toggled");
},


_applyBatchedFolderOperations : function () {
    if (this._deferredApplyHilites) {
        delete this._deferredApplyHilites;
        this.applyHilites(true);
    }
    if (this._folderToggleObsRan) {
        delete this._folderToggleObsRan;
        this.__folderToggleObservation();
    }
},

//> @method treeGrid.toggleFolder()   ([])
// Opens the folder specified by node if it's closed, and closes it if it's open.
// TreeGrid will redraw if there's a change in the folder's open/closed state.
//
// @visibility external
// @param	node	(TreeNode | String | Integer | NodeLocator)	the node in question, or the 
//                                                              the node's ID, or a NodeLocator
//                                                              object               
//<
toggleFolder : function (node) {
    var nodeLocator;
    if (this.data.isANodeLocator(node)) {
        nodeLocator = node;
        node = node.node;
    }
    if (this.data.isOpen(nodeLocator || node)) {
        this.closeFolder(nodeLocator || node);
    } else {
        this.openFolder(nodeLocator || node);

        
        var loadState = this.data.getLoadState(node);
        if (loadState == isc.Tree.LOADING) {
            var nodeIndex = this.getRecordIndex(node);
            if (nodeIndex >= 0) this.refreshCell(nodeIndex, this._treeFieldNum);
        }

        
        if (this.frozenBody) this.frozenBody.markForRedraw();
    }
},

//> @method treeGrid.openFolder() ([A])
// Opens a folder.
// <p>
// Executed when a folder node receives a 'doubleClick' event.
// <smartclient>If you override this method, the single parameter passed will be
// a reference to the relevant folder node in the tree's data.</smartclient>
// <p>
// See the ListGrid Widget Class for inherited recordClick and recordDoubleClick events.
//
// @param   node        (TreeNode)      node to open
// @param   [path]      (String)        optional parameter containing the full path to the node.
//                                      This is essential context for a
//                                      +link{tree.multiLinkTree,multi-link tree}, but is not 
//                                      required in ordinary trees
// @see closeFolder()
// @see folderOpened()
// @see class:ListGrid
// @visibility external
//<

openFolder : function (node, path) {
    var nodeLocator;
    if (this.data.isMultiLinkTree()) {
        if (this.data.isANodeLocator(node)) {
            nodeLocator = node;
            node = nodeLocator.node;
        } else {
            nodeLocator = this.data.createNodeLocator(node, null, null, path);
        }
    }
    // CALLBACK API:  available variables:  "node"
    // Convert a string callback to a function
    if (this.folderOpened != null) {
        this.convertToMethod("folderOpened");
        if (this.folderOpened(nodeLocator || node) == false) return false;
    }

    
    if (this.animateFolders) {
        this.animateOpen(nodeLocator || node);
    } else {
        this.data.openFolder(nodeLocator || node);
    }

},

//> @method treeGrid.animateOpen()
// Animates a folder opening to display its children (which grow into view).
// Automatically triggered from <code>treeGrid.folderOpen()</code> if
// <code>this.animateFolders</code> is true.
// @group animation
// @param folder (Node) node to open
// @visibility animation_advanced
//<
animateOpen : function (folder) {

    var nodeLocator;
    if (this.data.isANodeLocator(folder)) {
        nodeLocator = folder;
        folder = folder.node;
    }

    var data = this.data;
    if (data.isOpen(nodeLocator || folder)) return;

    // Open the data, but don't redraw with the new data visible (we'll handle redrawing
    // when the animation completes).
    this._suppressFolderToggleRedraw = true;
    data.openFolder(nodeLocator || folder);
    delete this._suppressFolderToggleRedraw;

    // parent may be null if we're looking at the root node
    if (data.isMultiLinkTree()) {
        if (!nodeLocator) {
            this.logWarn("In LG.animateOpen(), we have a multiLinkTree but we were not passed a " +
                            "nodeLocator.  Assuming parent is open.")
        } else {
            var parentNodeLocator = data._getParentNodeLocator(nodeLocator);
            if (!data.isOpen(parentNodeLocator)) return;
        }
    } else {
        var parent = data.getParent(nodeLocator || folder);
        if (parent && !data.isOpen(parent)) return;
    }

    var loadState = data.getLoadState(folder);
    if (loadState != isc.Tree.LOADED && loadState != isc.Tree.LOADED_PARTIAL_CHILDREN) {
        //this.logWarn("animation for LOD folder");
        // wait for dataChanged() to fire
        this._pendingFolderAnim = nodeLocator || folder;
        return;
    }

    this._startFolderAnimation(nodeLocator || folder);
},

//> @method treeGrid.closeFolder()
// Closes a folder.
//
// @param   node        (TreeNode)      node to close
// @see openFolder()
// @see folderClosed()
// @visibility external
//<

closeFolder : function (node) {
    var nodeLocator;
    if (this.data.isANodeLocator(node)) {
        nodeLocator = node;
        node = node.node;
    }
    // CALLBACK API:  available variables:  "node"
    // Convert a string callback to a function
    if (this.folderClosed != null) {
        this.convertToMethod("folderClosed");
        if (this.folderClosed(node) == false) return false;
    }

    // cancel editing of any nodes under this one
    if (this.getEditRow() != null) {
        var editRecord = this.getRecord(this.getEditRow());
        if (this.data.isDescendantOf(editRecord, node)) this.endEditing();
    }
    // now tell the data to close the folder
    if (this.shouldAnimateFolder(nodeLocator || node))
        this.animateClose(nodeLocator || node);
    else
        this.data.closeFolder(nodeLocator || node);
},

//> @method treeGrid.animateClose()
// Animates a folder closing to hide its children (which shrink out of view).
// Automatically triggered from <code>treeGrid.folderOpen()</code> if
// <code>this.animateFolders</code> is true.
// @param folder (Node) node to open
// @group animation
// @visibility animation_advanced
//<
animateClose : function (folder) {
    var nodeLocator,
        data = this.data;
    if (this.data.isANodeLocator(folder)) {
        nodeLocator = folder;
        folder = folder.node;
    }
    if (!data.isOpen(nodeLocator || folder)) return;

    if (data.isMultiLinkTree()) {
        if (!nodeLocator) {
            this.logWarn("In LG.animateOpen(), we have a multiLinkTree but we were not passed a " +
                            "nodeLocator.  Assuming parent is open.")
        } else {
            var parentNodeLocator = data._getParentNodeLocator(nodeLocator);
            if (!data.isOpen(parentNodeLocator)) {
                return this.closeFolder(nodeLocator);
            }
        }
    } else {
        var parent = data.getParent(nodeLocator || folder);
        if (parent && !data.isOpen(parent)) {
            return this.closeFolder(folder);
        }
    }

    var data = this.data,
        folderIndex = data.indexOf(nodeLocator || folder),
        numChildren = data.getOpenList(nodeLocator || folder).getLength()-1;


    
    this.startRowAnimation( false,
                            folderIndex+1,
                            folderIndex + numChildren + 1,
                            {target:this, methodName:"redraw", args:["close folder animation complete"]},
                            this.animateFolderSpeed,
                            this.animateFolderTime,
                            this.animateFolderEffect,
                            true
                          );
    var wasSuppressed = this._suppressFolderToggleRedraw;
    this._suppressFolderToggleRedraw = true;
    this.data.closeFolder(nodeLocator || folder);
    this._suppressFolderToggleRedraw = wasSuppressed;

    if (this.body && this.body._delayedRowAnimation != null) {
        if (this.data.isMultiLinkTree() && nodeLocator) {
            this.body._openFolder = nodeLocator;
        } else {
            this.body._openFolder = folder;
        }
    }
    if (this.frozenBody && this.frozenBody._delayedRowAnimation != null) {
        if (this.data.isMultiLinkTree() && nodeLocator) {
            this.frozenBody._openFolder = nodeLocator;
        } else {
            this.frozenBody._openFolder = folder;
        }
    }

},

_startFolderAnimation : function (folder) {

    var nodeLocator;
    if (this.data.isANodeLocator(folder)) {
        nodeLocator = folder;
        folder = folder.node;
    }

    // At this point we know we have all the children for the folder loaded - verify
    // that we actually should animate the folder into view - if we have too many children
    // we may not want to -- in this case just redraw.
    if (!this.shouldAnimateFolder(nodeLocator || folder)) {
        this.markForRedraw();
        return;
    }
    var data = this.data,
        folderIndex = data.indexOf(nodeLocator || folder),
        numChildren = data.getOpenList(nodeLocator || folder).getLength()-1;

    // don't try to animate empty folders
    if (folderIndex < 0 || numChildren <= 0) return;

    this.startRowAnimation( true,
                            folderIndex+1,
                            (folderIndex + numChildren+1),
                            {target:(this.bodyLayout || this.body), methodName:"redraw", args:["open folder animation complete"]},
                            this.animateFolderSpeed,
                            this.animateFolderTime,
                            this.animateFolderEffect,
                            true
                          );
},

// Used to store open folder state in the groupTree
// (Also used by TreeGrid.getOpenState())

_addNodeToOpenState : function (tree, node, openState, isGroupTree) {
    if (!tree.isOpen(node) || !tree.isLoaded(node)) return false;
    var children = tree.getFolders(node),
        hasOpenChildren = false;
    if (children != null) {
        for (var i = 0; i < children.length; i++) {
            hasOpenChildren = this._addNodeToOpenState(tree, children[i], openState, isGroupTree)
                              || hasOpenChildren;
        }
    }
    if (isGroupTree) {
        var folderInfo = {};
        folderInfo[node.groupName] = node.groupValue;
        openState.add(folderInfo);
    } else {
        openState[openState.length] = tree.getPath(node);
    }
    return true;
},

// END METHODS MOVED FROM TREEGRID

// These parameters essentially match the 
// type, originalRecord and rowNum from ResultSet.dataChanged [not publicly exposed].

_getDataChangedRecord : function (originalRecord, rowNum, type) {
    // Sanity check - obviously this would imply we have no information at all.
    if (originalRecord == null && rowNum == null) return;
    if (type == "remove") return null;
    var currData = this.data;
    if (this.data.isGroupedOutput && this.originalData) currData = this.originalData;

    // updatedRecord does not exist (was deleted)
    var newRecord =  currData.get(rowNum);
    if (newRecord == null && originalRecord == null) return null;
    if (originalRecord != null) {
        var pks = this.dataSource != null ? this.getDataSource().getPrimaryKeyFieldNames() : [];
        var pkMismatch = newRecord == null;
        if (!pkMismatch) {
            for (var i = 0; i < pks.length; ++i) {

                if (originalRecord[pks[i]] != newRecord[pks[i]]) {
                    pkMismatch = true;
                    break;
                }
            }
        }
        
        // if primary keys differ, the record was deleted via filtering, *or*
        // the data set is sorted, such that the rowNum refers to the
        // old, not the new position.
        // See if we can find the record by PKs
        if (pkMismatch) {
            newRecord = null;
            if (type == "update") {
                rowNum = currData.indexOf(originalRecord);
                if (rowNum != -1) {
                    // Assertion - this shouldn't cause a fetch since indexOf only
                    // queries loaded rows.
                    newRecord = currData.get(rowNum);
                }
            }
        }
    }
    return newRecord;
},

// dataChanged is documented in registerStringMethods block
dataChanged : function (type, originalRecord, rowNum, updateData, filterChanged, dataFromCache) {

    this._dataChanged(type, originalRecord, rowNum, updateData, filterChanged, dataFromCache);
    // Pure notification method
    if (this.dataChangedComplete != null) this.dataChangedComplete(type);
},

// Method to actually update the UI on data change.

_dataChanged : function (type, originalRecord, rowNum, updateData, filterChanged, dataFromCache) {

    if (isc._traceMarkers) arguments.__this = this;

    // This may be a recursive call to dataChanged() from us performing a local filter on
    // our underlying ResultSet object used for filtering. This can be ignored.
    if (this._filteringLocalDataFromDataChanged) return;
    
    // set a flag so we know we're handling dataChanged
    // This prevents us from causing unnecessary additional redraws from dataChanged on the
    // groupTree if we're currently grouped by any field(s)
    this._handlingDataChanged = true;

    // operations other than fetch may mean a new summary row is required, so re-fetch
    
    if (this.summaryRow && this.getSummaryRowDataSource() != null && type != "fetch") {
        var RPCManager = this.ns.RPCManager,
            summaryRow = this.summaryRow,
            txID = RPCManager && RPCManager._currentReplyTXNum;
        if (txID == null || txID != summaryRow._masterGridDataChangedTXID) {
            summaryRow.invalidateCache();
            summaryRow._masterGridDataChangedTXID = txID;
            
            summaryRow.setCriteria(this.getSummaryRowCriteria());
        }
    }
    
    var debugLogRC = this.logIsDebugEnabled("recordComponents");

    // DataChanged fires in some cases where we don't want to reset autoFieldWidths
    // For example, scrolling through a paged resultset where the columns resizing on scroll
    // would be ugly.
    // Use ResultSet parameters to test for cases to react to:
    // - crud operations which will affect the data displayed
    // - filter changing (including invalidateCache calls)
    // Note that we have equivalent logic inline in removeData, cellChanged to handle
    // non-databound grids' data being changed through standard grid APIs
    var resetAutoFitWidths = isc.isAn.Array(this.getOriginalData()) || 
                    (filterChanged || type == "add" || type == "remove");
    if (!resetAutoFitWidths && type == "replace") {
        if (originalRecord == null || rowNum == null) resetAutoFitWidths = true;
        else {
            var updatedRecord = this.getOriginalData().get(rowNum);
            if (updatedRecord == null) resetAutoFitWidths = true;
            else {
                for (var i = 0; i < this.fields.length; i++) {
                    if (this.shouldAutoFitField(this.fields[i])) {
                        var fieldName = this.getFieldName(this.fields[i]);
                        if (updatedRecord[fieldName] != updateData[fieldName]) {
                            resetAutoFitWidths = true;
                            break;
                        }
                    }
                }
            }
        }
    }

    var updatedGroupSummaries = false;

    // if a change was made to the groupBy field of a record, regroup
    var groupByFields = (this._groupByFields || this.getGroupByFields());
    if (groupByFields != null && !this._markForRegroup) {
        var markForRegroup = false;

        // fully regroup for add/remove, or for an update where dataChanged is not passed the
        // originalRecord to figure out if the groupField was changed
        var isAdd = type == "add",
            isRemove = !isAdd && (type == "remove"),
            isUpdate = !isAdd && !isRemove && (type == "update");
        var updatedRecord;
        
        // "remove" type operation but we don't know what was removed - full regroup
        
        if (isRemove) {    
            if (originalRecord == null) markForRegroup = true;
            
        } else if (isAdd || isUpdate) {
            // "update" operation with no previous record - implies 
            // an update record now matches our criteria and previously didn't.
            // Treat as an add.
            if (originalRecord == null) isAdd = true;
            updatedRecord = this._getDataChangedRecord(originalRecord, rowNum, type);

            if (updatedRecord == null) {
                // "update" operation and we don't have the record in our
                // originalData ResultSet. Implies it was lost from cache, probably
                // due to a change which made it no longer match criteria.
                // Treat as a remove.
                if (!isAdd) {
                    isRemove = true;
                } else {
                    
                    markForRegroup = true;
                }
            } 

        // Full regroup on filterChanged
        
        } else if (type == "replace" || filterChanged || !this.groupTree) {
            markForRegroup = true;
        }

        // If we're not doing a full regroup, update the group-tree directly
        if ((isAdd || isRemove || isUpdate) && !markForRegroup) {
            var reapplyHilites = false;
            this.calculateRecordSummaries(updatedRecord, /* fields */ null,
                                          /* recalculateSummaries */ false);

            var pks = this.getDataSource().getPrimaryKeyFieldNames(),
                keyCriteria = {};
            if (this.logIsInfoEnabled("grouping")) {
                this.logInfo("dataChanged(): Attempting incremental regroup for operation type:"
                         + type + " will be treated as a[n] " + 
                            (isAdd ? "add" : isRemove ? "remove" : "update"), "grouping");
            }

            if (isAdd) {
                // Add - no existing node, so just add a node to the groupTree
                this._incrementalRegroup(updatedRecord, null);
                
            } else {
                // Remove or update
                // Find the node within our tree which was affected.

                // The "originalRecord" should have primary keys on it.
                // find the equivalent node in our groupTree
                for (var i = 0; i < pks.length; i++) {
                    keyCriteria[pks[i]] = (isRemove ? originalRecord[pks[i]] : updatedRecord[pks[i]]);
                }
                // NOTE: In general, we explicitly do not support composite primaryKeys with
                // Trees and TreeGrids.  However, ListGrid grouping is implemented by use of
                // a Tree - "this.data" in the below call is a Tree, not the List or ResultSet
                // holding the grid's real data.  Fortunately, Tree supports a criteria search
                // of its nodes, so we make use of that with a criteria object that happens to
                // contain only primary keys
                var nodes = this.data.findAll(keyCriteria);
                
                if (nodes != null) {
                    nodes.removeWhere("_isGroup", true);
                }

                
                if (!nodes || nodes.length != 1) {
                    
                    markForRegroup = true;
                    
                } else {

                    var node = nodes[0];

                    // remove: "incrementalRegroup" will remove the node from the group-tree
                    if (isRemove) {
                        this._incrementalRegroup(null, node);
                    } else {

                        // Update - potentially change the category of the edited record,
                        // (_incrementalRegroup) - otherwise just update it in situ.
                        var fieldNames = this._getFieldNamesToUpdateForGrouped();

                        var node = nodes[0];
                        for (var i = 0; i < groupByFields.length; i++) {
                            var undef, fieldName = groupByFields[i];

                            var field = this.getUnderlyingField(fieldName),
                                newValue = this._getGroupValue(updatedRecord[fieldName],
                                                               updatedRecord, field, fieldName),
                                oldValue = this._getGroupValue(originalRecord[fieldName],
                                                               originalRecord, field, fieldName)
                            ;
                            if (newValue != oldValue) {
                                this._remapEditRows();
                                
                                this._incrementalRegroup(updatedRecord, node, updateData);
                                updatedGroupSummaries = true;
                                this._ignoreRegroup = true;
                                break;
                            }
                        }

                        // apply all modified fields to the node.
                        
                        if (node !== updatedRecord) {
                            isc.FieldGeneratorUtil._copyRecordInto(node, updatedRecord, this);

                            
                            var ds = this.getDataSource();
                            if (ds && !this.canPickOmittedFields &&
                                this.updateGroupedDSFields != false)
                            {
                                var fieldNames = this.groupedDSFieldsToUpdate || ds.getFieldNames(),
                                    fieldMap = this._completeFieldNamesMap;
                                for (var i = 0; i < fieldNames.length; i++) {
                                    var name = fieldNames[i];
                                    if (name in fieldMap) continue;
                                    // if the field is not available to the grid, copy it now
                                    if (name in updatedRecord) node[name] = updatedRecord[name];
                                    else                       delete node[name];
                                }
                            }
                        }
                        // Clear any record components on this record so they will
                        // be recreated during redraw
                        node[this._$recordComponentsPrefix + this.ID] = null;
                        // Hilites need to be re-applied as well
                        reapplyHilites = true;
                        // refresh the group(s) that contain the updated record
                        if (!updatedGroupSummaries) {
                            updatedGroupSummaries = true;
                            this.refreshGroupSummary(node);
                        }
                        
                        // Refresh the sort on the groupTree if we have one.
                        // This ensures a change to the sort field will cause the
                        // record to jump into its new position.
                        var currentSort = this.data.getSort();
                        if (currentSort != null) {
                            this.data.setSort(currentSort);
                        }
                    }
                }
            }
            if (reapplyHilites && this.hilites) this.applyHilites(true);
        }
        if (markForRegroup) {
            this._setMarkForRegroup(true, false, false, false, true, groupByFields);
        }
    }
    
    var sortSpecifiers = this._sortSpecifiers;
    if (sortSpecifiers != null && sortSpecifiers.length > 0) {
        var origData = this.getOriginalData();
        if (isc.isA.ResultSet(origData) &&
            ((origData.shouldUpdatePartialCache() && !origData.allMatchingRowsCached()) ||
             !origData.canSortOnClient()) &&
            (type == "replace" || type == "update" || type == "add"))
        {
            if (originalRecord == null || rowNum == null) {
                // when adding a new record, we want to unsort() but not re-fetch - to do that,
                // pass the undocumented keepLocalData param to unsort(), so it drops the 
                // row-order, but not the cache - the next time rows are requested, it will 
                // drop the cache and refetch - when editing a record, this same flow happens
                // as a result of the call to _unsortOnChange() below
                this.unsort(true);
            } else {
                var updatedRecord = this._getDataChangedRecord(originalRecord, rowNum, type);
                if (updatedRecord == null) {
                    this.unsort();
                } else {
                    this._unsortOnChange(updatedRecord, originalRecord);
                }
            }

        } else {
            if (this.filterLocalData && !this.data._resorting && this.data.resort) {
                this.data.resort();
            }
        }
    }

    if (this.filterLocalData) {
        var baseData = this.getOriginalData();
        if (baseData.filterLocalData) {
            this._filteringLocalDataFromDataChanged = true;
            baseData.filterLocalData();
            delete this._filteringLocalDataFromDataChanged;
        }
    }

    
    if (this._markForRegroup && (!this.isGrouped || !this._savingEdits) &&
        // Skip attempting to regroup / reset selection if our resultSet is in mid-fetch
        (!isc.isA.ResultSet(this.data) || this.data.lengthIsKnown()))
    {
        this._lastStoredSelectedState = this.getSelectedState(true);
        this.regroup();
    
    
    } else if (this._asyncRegroupInProgress && !this._groupByDataChanged) {
        var baton = this._asyncRegroupBaton,
            fields;
        if (baton) {
            fields = baton.groupByFields || baton.groupByField;
        } else {
            fields = this.groupByFields || this._groupByFields;
        }
        
        if (this.logIsInfoEnabled("grouping")) {
            this.logInfo("dataChanged() occurred while asynchronous regrouping in progress. " +
                         "Restarting grouping with fields:" + fields, "grouping");
        }
        // no need to clear the timer for the asynch-regroup that's currently in progress - that's
        // already handled by 'groupBy'
        this.groupBy(fields);
    }

    //>Animation
    // Call finishRowAnimation - will kill any show/hide row animations.
    // These animations assume the data remains constant for the duration
    // of the animation.
    // (No-ops if appropriate)
    if (this.body) this.body.finishRowAnimation();
    //<Animation

    // Call _remapEditRows() to ensure that editValues are associated with the (possibly
    // modified) rowNumbers using pointers between record primary key and edit values
    
    if (!this._savingEdits) {
        if (!this.suppressEditRowRemap) this._remapEditRows();
        // If we're actually showing the editor and the current edit-row has changed
        // roll the new values into the edit form for any unedited fields
        if (this._editorShowing) {
            var editForm = this.getEditForm(),
                editRowNum = this.getEditRow(),
                record = this.getRecord(editRowNum),
                showInEditor = {};
            
            // Clean off any tree metadata, etc
            if (isc.isA.Tree(this.data)) {
                record = this.data.getCleanNodeData(record, false);
            }            

            if (editForm && record != null) {
                for (var fieldName in record) {
                    // If we have an edit value, don't allow the new
                    // record value to override it
                    if (this._getEditValue(editRowNum, fieldName, true) != null) continue;
                    // If we have a live edit item, and it has a modified value
                    // (IE the user has changed it, or app code has called setValue()
                    // diretly on the form), skip that too.
                    
                    var item = editForm.getItem(fieldName),
                        currentVal = item ? item.getValue() : null;
                    if (item && 
                        !item.compareValues(currentVal, record[fieldName]) &&
                        !item.compareValues(item._getOldValue(), currentVal)) 
                    {
                        continue;
                    }

                    showInEditor[fieldName] = record[fieldName];
                }
                // no need to call 'setEditValue()' - displaynewEditValues already
                // handles picking up the display value from the record value.
                
                this._displayNewEditValues(editRowNum, this.getEditCol(), showInEditor);
                var oldVals = editForm._oldValues;
                // We didn't use 'setValues()' but we need to remember these
                // particular field values so if this method runs again we don't
                // treat these values as user-edited.
                // use DBC._duplicateValues to ensure we duplicate dates, objects, handle 
                // GWT objects, etc (we used to use clone(), but it fails in the presence
                // of pointer loops, which can happen with the records in grouped lists)
                var dup = {};
                isc.DynamicForm._duplicateValues(editForm, showInEditor, dup);
                for (var fieldName in showInEditor) {
                    oldVals[fieldName] = dup[fieldName];
                }
                
            }
        }
    }

    // if the originalRecord has components, we want to refresh the record's components later
    var originalRecordHasComponents = this._hasRecordComponents(originalRecord);
    
    // re-associate embeddedComponents with records which were not previously present in the
    // cache but are now - set grid._shouldRetainEmbeddedComponents to false to have components
    // removed when their associated records are no longer in the cache.
    if (!isc.isA.ResultSet(this.data) || this.data.lengthIsKnown()) {
        // remap embedded components
        this._remapEmbeddedComponents();
    }

    // if this.alwaysShowEditors is set, and we have data, and we're not currently showing
    // editors, show them now.
    // This handles us getting new data (from a fetch for example)
    if (this._alwaysShowEditors() && !this._editorShowing) {
        this.startEditing(null,null,true,null,true);
    }

    
    var lastRow = this.getTotalRows()-1;
    if (this.body) {
        if (this.body.lastOverRow > lastRow) delete this.body.lastOverRow;
        if (this.body.lastMouseOverRow > lastRow) delete this.body.lastMouseOverRow;
        if (this.body._lastHiliteRow > lastRow) {
            delete this.body._lastHiliteRow;
            delete this.body._lastHiliteCol;
        }
    }
    if (this._lastRecordClicked > lastRow) delete this._lastRecordClicked;

    
    var changedRecords = null;
    if (type == "update") {
        changedRecords = updateData;
    } else if (type != "update" && type != "remove") {
        changedRecords = this._getDataChangedRecord(originalRecord, rowNum, type);
    }

    if (updatedGroupSummaries) {
        
        if (this.summaryRow && this.showGridSummary) this.summaryRow._recalculateSummaries();
    } else {
        
        this.calculateRecordSummaries(changedRecords, /* fields */ null,
                /* recalculateSummaries */ true,
                /* suppressDisplay */ true,
                // Suppress field generation if we're in dataChanged because of field generation,
                // to prevent an infinite loop, where we continually re-try generating
                // non-successfully-generated values whose non-successful results are re-triable
                // (e.g. canceled results).
                /* suppressFieldGeneration */ type == "remove" || type == "fieldGeneration",
                /* keepUserCache */ type != null && type != "fetch" && type != "update",
                /* skipAsync */ false,
                /* userCacheMode */ this._$dataChanged);
    }

    if (this.hilites) this.applyHilites(true);
    
    //this.logWarn("_suppressRedrawOnDataChanged is " + this._suppressRedrawOnDataChanged);
    if (!this._suppressRedrawOnDataChanged) {
        // recalculate autoFitWidth field widths to fit the new data
        if (resetAutoFitWidths) this.updateFieldWidthsForAutoFitValue(this._$dataChanged);

        
        var mustRedraw = true;
        if (!this.forceRedrawOnDataChanged &&
            type == "update" && originalRecord != null) {
            var currentRowNum = this.data.indexOf(originalRecord);
            
            
            if (currentRowNum != null && currentRowNum != -1 && currentRowNum == rowNum) {
                if (debugLogRC) {
                    this.logDebug("dataChanged running refreshRow(" + currentRowNum + ")", 
                        "recordComponents");
                }
                this.refreshRow(currentRowNum, originalRecordHasComponents);
                mustRedraw = false;
            }
        }
        if (mustRedraw) this.markForRedrawDataChanged();
    } else {
        if (originalRecordHasComponents) this.updateRecordComponents();
    }

    this.rowRangeDisplayValueChanged("source grid dataChanged");

    // In screenreader mode allow our aria-state to update to reflect the new data length if necessary
    if (isc.Canvas.ariaEnabled() && this.updateAriaForDataChanged) {
        this.updateAriaForDataChanged();
    }

    // Note - a regroup may require a re-selection of the prior-to-regroup selection
    // range.
    // We rely on code in the _regroupFinish flow to handle resetting selection

    // In case there are any outstanding asynchronous operations to compute values of one or
    // more fields, we'll wipe our _async_ object, so that when the asynchronous operations
    // complete, the response handlers will ignore this record.
    if (originalRecord && type == "remove") {
        delete originalRecord["_async_" + this.ID];
    }

    // clear the _handlingDataChanged flag
    delete this._handlingDataChanged;

    this.updateBodyCanFocusForData();
    
    this._updateRowCountsInRuleScope();
    if (filterChanged) this._provideCriteriaToRuleContext();


},

// forceRedrawOnDataChanged - flag to disable targetted row refresh if we got 
// "dataChanged" for a single updated record. 

forceRedrawOnDataChanged:false,


_setMarkForRegroup : function (
        markForRegroup,
        calledFromGroupBy, calledFromRegroup, calledFromClearGroupBy, calledFromDataChanged,
        fields, groupByFields)
{
    
    var markForRegroup0 = this._markForRegroup;
    if (calledFromGroupBy) {
        
        this._groupByCompleteFieldsBeforeRegroup = fields;
        this._isGrouped = true;
        this._groupByFields = groupByFields;
    } else if (calledFromRegroup) {
        if (markForRegroup0 && !markForRegroup) {
            
            this._groupByCompleteFieldsAfterRegroup = this._groupByCompleteFieldsBeforeRegroup;
            delete this._groupByCompleteFieldsBeforeRegroup;
            delete this._isGrouped;
            delete this._groupByFields;
        }
    } else if (calledFromClearGroupBy) {
        

        // clean up temporary grouping state
        
        delete this._isGrouped;
        delete this._groupByFields;

        delete this._groupByCompleteFieldsBeforeRegroup;
        delete this._groupByCompleteFieldsAfterRegroup;
    }
    

    
    this._markForRegroup = markForRegroup;
},

markForRedrawDataChanged : function () {
    if (this.frozenBody) this.frozenBody._suppressRecordComponentsUpdate = true;
    this._markBodyForRedraw(this._$dataChanged);
},


// Ensure that when body redraw runs, we do a full field-widths refresh, including
// calculating auto-fit size
_forceUpdateFieldWidths : function (reason) {
    if (this.fields) {
        // Ensure we actually calculate new field widths based on data values.
        delete this.fields._appliedInitialAutoFitWidth;
    }
    var bodies = this.bodies;
    if (bodies) {
        var fwReason = "Force update field widths" + (reason ? ": " + reason : ".");
        for (var b = 0; b < bodies.length; ++b) {
            var body = bodies[b];
            body.markForRedraw(body._fieldWidthsDirty = fwReason);
        }
    }
},

// wrap the call out to the dataArrived override point and handle sorter according to
// canSortClientOnly value and current data-state
_$new_data: "New dataset loaded",
_dataArrived : function (startRow, endRow) {
    var sortField = this._getSortFieldNum();
    
    
    if (this._updateFieldWidthsOnDataArrived || startRow == 0) {
        this._updateFieldWidthsOnDataArrived = false;
        if (this.body && this.body.isDrawn()) this._forceUpdateFieldWidths(this._$new_data);
    }
    if (sortField != null && sortField != -1) {
        var fieldNum = this.getFieldNum(sortField),
            field = this.getField(fieldNum)
        ;

        if (field && field.canSortClientOnly && !this._canSortData(field)) {
            this._setSortFieldNum(null);

            // tell that toolbar button to unselect / get rid of sort arrow
            if (sortField != null && this.header && isc.isA.Toolbar(this.header)) {
                this.header.deselectButton(sortField);
                var button = this.header.getButton(sortField);
                if (button) button.setTitle(this.getHeaderButtonTitle(button));
            }

            // Get rid of the sort arrow in the sorter
            if (this.sorter && this.sorter.setTitle) this.sorter.setTitle(this.sorter.getTitle());
        }
    }

    if (!(this.canSelectAll == false) && this.getCurrentCheckboxField()) {
        var cbPos = this.getCheckboxFieldPosition(),
            field = this.getField(cbPos);
        // if we are showing a checkbox select-all header, and we don't have
        // a full cache, disable the checkbox header and show a hover prompt
        if (isc.ResultSet && isc.isA.ResultSet(this.data)
            && !this.data.allMatchingRowsCached())
        {
            var props = {
                disabled: true,
                showHover: true,
                prompt: this.selectionManager.selectionRangeNotLoadedMessage,
                title: (this.selectionType == "single") ? isc.nbsp :
                        this._getCheckboxValueIconHTML(false, false, true, true, field)
            }
        // if we now have a full cache, enable the checkbox selectAll header
        } else {
            var props = {
                disabled: false,
                showHover: false,
                prompt: null,
                title: (this.selectionType == "single") ? isc.nbsp :
                        this._getCheckboxValueIconHTML(false, false, true, false, field)
            }
        }
        // if checkbox was disabled but is now being enabled, update it
        var updateCheckbox = field && field.disabled && !props.disabled;
        this.setFieldProperties(cbPos, props);
        if (updateCheckbox) this.updateCheckboxHeaderState();
    }

    
    if (isc.screenReader && this.body != null) {
        if (isc.isA.Tree(this.data)) {
            // in this case we're passed a single param, the parent node.
            var node = startRow;
            if (this.data.isOpen(node) && this.data.hasChildren(node)) {
                var children = this.data.getChildren(node);
                if (children && !children.isEmpty()) node = children.first();
            }
            var rowNum = this.data.indexOf(node);
            // If we don't currently have focus, just remember the native focus row - this means
            // if we're showing a modal prompt / redrawing we should refocus on the right native
            // element...
            var colNum = this._getKeyboardClickNum(),
                body = this.getFieldBody(colNum),
                localCol = this.getLocalFieldNum(colNum);
            body._putNativeFocusInRow(rowNum, localCol, !this.hasFocus);
        }
    }

    // we only want to run auto-sizing code if the data has already arrived
    if (this._autoSizeOnDataArrived) {
        this._headerDoubleClick(this._autoSizeHeaderFieldNum, this._autoSizeHeader);
        this._autoSizeHeaderFieldNum = null;
        this._autoSizeHeader = null;
        this._autoSizeOnDataArrived = false;
    }

    this._restoreBodyOverflow();
    
    
    if (!this._handlingDataChanged) {
        this._markBodyForRedraw();
    }
    
    this._fromDataArrived = true;
    this.dataArrived(startRow, endRow);
    delete this._fromDataArrived;
    
    this.updateBodyCanFocusForData();
    
    if (this.data) {
        if (isc.isA.ResultSet(this.data)) {
            if (this.data._initialDataLoading) {
                if (this._provideDataLoadingToRuleContext) {
                    this._provideDataLoadingToRuleContext();
                }
                delete this.data._initialDataLoading;
            }
        } else if (isc.isA.ResultTree(this.data)) {
            this._provideDataLoadingToRuleContext();
        }
    }

},
    
updateBodyCanFocusForData : function () {
    if (this.body && !this.canFocusInEmptyGrid) {
        var isEmpty = this.isEmpty();
        if (isEmpty != this._wasEmptyForCanFocus) {
            this.body._updateCanFocus();
            if (this.frozenBody != null) this.frozenBody._updateCanFocus();
            // Call updateCanFocus on the grid too, in case any callers call
            // 'getTabIndex' or 'canFocus' on the grid directly
            this._updateCanFocus();
            this._wasEmptyForCanFocus = isEmpty;
        }
    }
},


// doc'd in registerStringMethods block
dataArrived : isc.Class.NO_OP,

//> @method listGrid._ignoreData() (A)
//      stop observing methods on data when it goes out of scope
//      called automatically by setData
//  @param  data    (Object)        old data to be ignored
//<
_ignoreData : function (data, destroying) {
    //>Animation
    // Call finishRowAnimation - will kill any show/hide row animations
    // These animations assume the data remains constant for the duration
    // of the animation.
    // (No-ops if appropriate)
    if (this.body) this.body.finishRowAnimation();
    //<Animation

    if (isc.isA.Tree(data)) this.ignore(data, "changeDataVisibility");

    this.ignore(data, "dataChanged");

    if (this.isObserving(data, "dataArrived")) {
        this.ignore(data, "dataArrived");
    }


    // If we're destroying, no need to call deslectAll, as we'll continue to
    // destroySelectionModel() anyway, and calling deselectAll can cause
    // selectionChanged notifications to fire which is likely to lead to 
    // application level crashes since the grid is in an invalid state
    if (!destroying && this.selectionManager) {
        var currentSelection = this.selectionManager.getSelection();
        this.selectionManager.deselectAll();
        if (currentSelection && currentSelection.length > 0) {
            this.fireSelectionUpdated();
        }
    }
    // NOTE: we don't ignore this.selectionManager.setSelected because
    //          we're re-using the same selection object

    this.Super("_ignoreData", arguments);
},

// Helper called from setFields() before deriveVisibleFields to apply default 
// "showIf" function if appropriate.
applyDefaultShowIf : function (completeFields) {
    if (completeFields == null) return;
    for (var i = 0; i < completeFields.length; i++) {

        var field = completeFields[i];

        // If field is marked as initially hidden, use showIf:"false"
        
        if (field.hidden && field.showIf == null) field.showIf = "false";

        // if field.showIf is set at this stage, it takes precedence over 
        // hideOnTablet / hideOnPhone - otherwise set up a showIf to read those properties
        // if necessary.
        if (field.showIf == null && 
            ((isc.Browser.isTablet && field.hideOnTablet != null) || 
                (isc.Browser.isHandset && field.hideOnPhone != null)))
        {
            field.showIf = this._getFieldShowOnMobileFunction();
        }
    }
},
    

//> @method listGrid.applyFieldDefaults()
//      @group  data
//         Derive default field sizes and formatters where possible, based on schema information.
//<
_generatedFieldNameCount:0,
applyFieldDefaults : function (fields) {
    if (fields == null) return;
    
    var thisID = this.getID();

    // apply ListGrid-specific defaults, like using toShortDate() for Date fields
    for (var i = 0; i < fields.length; i++) {
        var field = fields[i];

        if (field == null) continue;

        // the default title rotation from the grid can be overridden on a per-field basis
        var rotateTitle = field.rotateTitle = field.rotateTitle || 
                this.rotateHeaderTitles && field.rotateTitle != false;

        
        if (field.componentID == null) field.componentID = thisID;

        // In general we can support un-named fields in dataBoundComponents if there is a dataPath
        if (!this.allowNamelessFields && field.name == null) {
            if (field.dataPath == null) {
                this.logWarn("unable to process field with no name / dataPath:" +
                             this.echo(field));
                continue;
            }
            // apply an arbitrary name - this gives us a straightforward way to map the
            // field object any generated editor item, etc.
            
            field.name = "field" + this._generatedFieldNameCount++;
        }
        // default the alignment of each field to left if not specified
        // In RTL mode default to right alignment (so text flows from start of value
        // outward as you'd expect). This means setting the property to "left" if
        // reverseRTLAlign is set, otherwise to "right".
        var defaultAlign = (this.isRTL() && !this.reverseRTLAlign) ? isc.Canvas.RIGHT
                                                                   : isc.Canvas.LEFT;

        // "type" is used for align and default formatting. If we have a display field
        // we're pulling display-values from, use the type specified there rather than
        // on the underlying data values the display values represent.
        var type = this.getFieldDisplayType(field),
            baseType = (type != null ? isc.SimpleType.getBaseType(type) : null);
        if (field.userFormula || field.userSummary) {
            for (var attr in this.formulaFieldDefaultAttributes) {
                if (field[attr] == null) {
                    field[attr] = this.formulaFieldDefaultAttributes[attr];
                }
            }
        }

        // Override canEdit for binary fields where we don't support grid editing
        if (isc.SimpleType.inheritsFrom(type, "binary")) {
            if (field.canEdit) {
                this.logWarn("Binary Field " + field.name + " is specified as canEdit:true. " +
                    "Inline grid editing is not supported for binary fields. Marking this field as canEdit:false.");
            }
            field.canEdit = false;
        }

        

        // note: needs to be first, as "image" type technically inherits from text
        if (isc.SimpleType.inheritsFrom(type, "image")) {
            field._typeFormatter = this._formatImageCellValue;

        // Attempt to size columns to fit their content
        } else if (baseType == this._$text) {

            // use minimal space for small text fields with no value map
            
            if (field.width == null && field.length != null) {
                if (field.length < 15 && !field.valueMap) {
                    // set default width, taking into account grid and field minimums
                    field.width = Math.max(field.length * 7, this.minFieldWidth || 1,
                                           field.minWidth || 1);
                }
            }

        } else if (baseType == "integer" || baseType == "float") {
            // align numbers right by default to line up decimal places
            // Exception: If there's a valueMap attached we don't want to right-align
            // (Example - mapping error codes to display strings).
            
            var hasObjValueMap = field.valueMap != null && !isc.isAn.Array(field.valueMap),
                reverseAlign = (this.isRTL() && !this.reverseRTLAlign);
            defaultAlign = hasObjValueMap ?
                            (reverseAlign ? isc.Canvas.RIGHT : isc.Canvas.LEFT) :
                            (reverseAlign ? isc.Canvas.LEFT : isc.Canvas.RIGHT);
            field._typeFormatter = this._formatNumberCellValue;

        // by default size date columns fields to match the default shortDate format applied
        // to date fields
        
        } else if (baseType == "date" || baseType == "datetime") {
            if (field.width == null && field.autoFitWidth == null && 
                this.autoFitDateFields != "none") 
            {
                field.autoFitWidth = true;
                field.autoFitWidthApproach = this.autoFitDateFields;
            }
            // right alignment lines up years if day/month values are numeric and not padded
            defaultAlign = (this.isRTL() && !this.reverseRTLAlign)  ? isc.Canvas.LEFT
                                                                    : isc.Canvas.RIGHT;
            field._typeFormatter = this._formatDateCellValue;

        // by default size time columns fields to match the default format applied to time
        // fields
        } else if (baseType == "time") {
            if (field.width == null && field.autoFitWidth == null &&
                this.autoFitTimeFields != "none") 
            {
                field.autoFitWidth = true;
                field.autoFitWidthApproach = this.autoFitTimeFields;
            }
            field._typeFormatter = this._formatTimeCellValue;
            defaultAlign = (this.isRTL() && !this.reverseRTLAlign)  ? isc.Canvas.LEFT
                                                                    : isc.Canvas.RIGHT;

        } else if (type == "binary" || type == "blob" || type == "upload" || type == "imageFile") {
            field._typeFormatter = this._formatBinaryCellValue;
        } else if (type == "link") {
            field._typeFormatter = this._formatLinkCellValue;
        } else if (type == "icon") {
            // check autoFitIconFields -- if set, set min width to accommodate the
            // icons and set autoFitWidth:true / autoFitWidthApproach such that
            // it'll expand to accommodate the title if appropriate
            if (field.width == null && field.autoFitWidth == null) {
                if (this.autoFitIconFields != "none") {
                    field.autoFitWidth = true;
                    field.autoFitWidthApproach =
                        (this.autoFitIconFields == "title" && !rotateTitle) ? "both" : "value";
                }
            }
            field.align = field.align || "center";

            // install a formatter that will put button.icon into the cell
            field._typeFormatter = this._formatIconCellValue;

            // default title so that icon appears alone (otherwise would default to field name
            // if title was unset)
            field.title = field.title || isc.nbsp;

        // turn on 'canToggle' for all boolean fields.
        // If 'canEdit' is also set to true these fields will be editable via a single
        // click
        } else if (type == "boolean" || type== "checkbox") {
            if (field.canToggle == null) field.canToggle = true;
        }

        // For boolean fields we show checkbox images by default
        // this is handled via the valueIcon system - see getValueIcon(), getValueIconWidth() and
        // showValueIconOnly()
        

        // If formatCellValue was passed to us as a string, convert it to a method
        if (field.formatCellValue != null && !isc.isA.Function(field.formatCellValue))
            isc.Func.replaceWithMethod(field, "formatCellValue", "value,record,rowNum,colNum,grid");

        if (this.showValueIconOnly(field)) {
            defaultAlign = isc.Canvas.CENTER;

            
            field.iconSpacing = 0;

            // apply the "icon" field logic to fields that show valueIcons -
            // respect autoFitIconFields here too
            if (field.width == null && field.autoFitWidth == null) {
                if (this.autoFitIconFields != "none") {
                    field.autoFitWidth = true;
                    field.autoFitWidthApproach =
                        (this.autoFitIconFields == "title" && !rotateTitle) ? "both" : "value";
                }
            }
        } else if (field.icon != null && field.showTitle == false) {
            
            field.iconSpacing = 0;
        }

        // configure alignment for rotated header button titles
        if (rotateTitle) {
            
            if (!field.align) {
                field.align = isc.Canvas.CENTER;
                // pass through the default field alignment to the cells
                if (!field.cellAlign) field.cellAlign = defaultAlign;
            }
        }

        // default the vertical alignment of fields to headerTitleVAlign - see jsdoc on
        // ListGrid.headerTitleVAlign for behavior
        if (!field.valign) {
            if (this.headerTitleVAlign != null) field.valign = this.headerTitleVAlign;
            else if (rotateTitle) field.valign = "bottom";
        }

        // TODO: numeric quantities with range validators could be given specific sizes
        if (!field.align) field.align = defaultAlign;

        // For fields marked as multiple:true, set the "validateEachItem" flag.
        // This ensures that when validators run in an editable grid we will
        // validate each selected value
        if (field.multiple && field.validateEachItem == null) field.validateEachItem = true;

        //>EditMode
        
        if (field.recordClick) {
            // CALLBACK API:  available variables:  "viewer,record,recordNum,field,fieldNum,value,rawValue"
            // Convert a string callback to a function
            isc.Func.replaceWithMethod(field, "recordClick",
                                             "viewer,record,recordNum,field,fieldNum,value,rawValue");
        }
        //<EditMode
    }
},

// If this field has a specified display field, pick up the underlying display field object
// (from the optionDataSource if appropriate, otherwise from the grid itself, or the
// underlying DS the grid is bound to).
getDisplayField : function (field) {
    var displayField = field.displayField;
    if (displayField != null) {
        var ods = field.optionDataSource ? isc.DataSource.get(field.optionDataSource) : null;
        if (ods != null) displayField = ods.getField(displayField);
        else {
            displayField = this.getField(displayField);
            if (displayField == null && this.dataSource != null) {
                displayField = this.getDataSource().getField(field.displayField);
            }
        }
    }
    return displayField;
},

// Returns the specified type of the field's displayField, if there is one, otherwise of the
// field itself.
getFieldDisplayType : function (field) {
    var displayField = this.getDisplayField(field),
        type;
    if (displayField != null) type = displayField.type;
    if (type == null) type = field.type;
    return type;
},

// Helper method called on boolean fields to determine whether we should use the
// booleanTrueImage/booleanFalseImage and related settings, or fall back to the general
// valueIcons system, which may show a combination of text and icons
_$boolean:"boolean",
_formatBooleanFieldAsImages : function (field) {
    // If booleanTrue/FalseImage have been set null, always back off to showing text / valueIcons
    if (this.booleanTrueImage == null && this.booleanFalseImage == null) return false;

    var type = this.getFieldDisplayType(field),
        baseType = (type != null ? isc.SimpleType.getBaseType(type) : null);
    if (baseType != this._$boolean) return false;

    // read as: user has not tried to set valueIcon-specific flags.
    // Also note: it's commonly necessary to set a valueMap with a boolean field in order to
    // allow stored values like YES/NO/null to be mapped to boolean true/false, so a valueMap
    // doesn't indicate an intent to use valueIcons.  If you have a valueMap and there are more
    // values than true/false/unset, you shouldn't declare the field boolean, it should be
    // enum.
    return (!field.suppressValueIcon && field.showValueIconOnly == null &&
             field.valueIcons == null && field.formatCellValue == null);
},


//> @method listGrid.setFieldProperties()
// Dynamically set properties for a particular field. This method will update the fields
// header-button without having to explicitly reset the fields in the grid.  <smartgwt>
// The passed-in +link{ListGridField} should contain just the minimal properties you want to
// change; do not take the original ListGridField, modify it, and just pass that to this
// function.</smartgwt>
// <P> 
// NOTE: Where explicit setters exist for field properties (such as
// +link{resizeField()}, +link{setFieldTitle()}, +link{setFieldIcon()}, etc.) these should be
// used instead.
//
// @param   fieldNum (number | String) name of the field, or index.
// @param   properties (ListGridField Properties) properties to apply to the header
// @visibility external
//<
// NOTE: little testing has been done on which properties can actually be set this way
setFieldProperties : function (fieldNum, properties) {
    var field, allFields = this.getAllFields();
    var origField = fieldNum;
    if (isc.isA.Number(fieldNum)) {
        // if an index was passed, use the visible fields
        field = this.getField(fieldNum);
    } else {
        // if a key was passed, use the complete fields to handle hidden columns
        var globalFieldNum = isc.Class.getArrayItemIndex(
                                fieldNum, allFields, "name");
        field = allFields[globalFieldNum];
        // map back to the fieldNum within this.fields (not within this.completeFields)
        fieldNum = this.getFieldNum(field);
    }
    if (!field) return;
    
    // If we find "operator" among the properties, consider it a special case and handle it
    // with setFieldProperty()
    for (var propName in properties) {
        if (!Object.hasOwn(properties, propName)) continue;
        if (propName == "operator") {
            this.setFieldProperty(field, propName, properties[propName]);
            // Remove "operator" from the properties list, so it is not handled twice
            delete properties[propName];
        }
    }

    isc.FieldGeneratorUtil._beforeSetFieldProperties(this, field, properties);

    if (Object.hasOwn(properties, "minWidth") && field.minWidth != properties.minWidth) {
        var body = this.getFieldBody(field),
            fwReason = "'minWidth' for " + (isc.isA.nonemptyString(field.name)
                                            ? "the '" + field.name + "'"
                                            : "an unnamed") + " field changed.";
        if (body) body.markForRedraw(body._fieldWidthsDirty = fwReason);
    }
    if (Object.hasOwn(properties, "maxWidth") && field.maxWidth != properties.maxWidth) {
        var body = this.getFieldBody(field),
            fwReason = "'maxWidth' for " + (isc.isA.nonemptyString(field.name)
                                            ? "the '" + field.name + "'"
                                            : "an unnamed") + " field changed.";
        if (body) body.markForRedraw(body._fieldWidthsDirty = fwReason);
    }

    isc.addPropertiesWithAssign(field, properties);

    if (this.header != null && this.header.isDrawn()) {
        // getFieldHeader / getLocalFieldNum will account for frozen fields
        var header = this.getFieldHeader(fieldNum),
            headerButton = header.getMember(this.getLocalFieldNum(fieldNum));
        if (headerButton) headerButton.setProperties(properties);
    }
},

//> @method listGrid.setFieldMinWidth()
// Updates +link{listGridField.minWidth} for the specified field and redraws the associated
// column if required.
//
// @param fieldNum (int | String) name of the field, or index.
// @param width (Number)
// @see listGridField.minWidth
// @visibility external
//<
setFieldMinWidth : function (fieldNum, width) {
    this.setFieldProperties(fieldNum, {minWidth: width});
},

//> @method listGrid.setFieldMaxWidth()
// Updates +link{listGridField.maxWidth} for the specified field and redraws the associated
// column if required.
//
// @param fieldNum (int | String) name of the field, or index.
// @param width (Number)
// @see listGridField.maxWidth
// @visibility external
//<
setFieldMaxWidth : function (fieldNum, width) {
    this.setFieldProperties(fieldNum, {maxWidth: width});
},

//> @method listGrid.setMinFieldWidth()
// Updates +link{listGrid.minFieldWidth} and redraws any columns as needed.
//
// @param width (int)
// @see listGrid.minFieldWidth
// @visibility external
//<
setMinFieldWidth : function (width) {
    if (this.minFieldWidth == width) return;
    var bodies = this.bodies;
    if (bodies) {
        var fwReason = "'minFieldWidth' on " + this.getID() + " was changed.";
        for (var b = 0; b < bodies.length; ++b) {
            var body = bodies[b];
            body.markForRedraw(body._fieldWidthsDirty = fwReason);
        }
    }
    this.minFieldWidth = width;
},

//> @method listGrid.setFieldTitle()
// Change the title of a field after the grid is created.
//
// @param fieldNum (int | String) name of the field, or index.
// @param title (String) new title
// @visibility external
//<
setFieldTitle : function (fieldNum, title) {
    this.setFieldProperties(fieldNum, {title:title});
},

//> @method listGrid.setFieldHeaderBaseStyle()
// Update the +link{listGridField.headerBaseStyle} for a field within the grid at runtime.
// @param name (String) name of the field.
// @param newStyle (CSSStyleName) new baseStyle for the field header
// @visibility external
//<
setFieldHeaderBaseStyle : function (name, baseStyle) {
    var field = this.getField(name);
    if (field == null) {
        this.logWarn("setFieldHeaderBaseStyle() unable to find field:" + name);
        return;
    }
    field.headerBaseStyle = baseStyle;
    var button = this.getFieldHeaderButton(this.getFieldNum(field));
    if (button != null) {

        // Treat being passed null as an attempt to revert to default base style.
        if (baseStyle == null) {
            var buttonProperties = this.getHeaderButtonProperties();
            if (field.frozen && buttonProperties.frozenBaseStyle) {
                baseStyle = buttonProperties.frozenBaseStyle;
            } else if (buttonProperties.baseStyle) {
                baseStyle = buttonProperties.baseStyle;
            }
        }
        if (baseStyle == null) {
            baseStyle = button.getClass().getPrototype().baseStyle;
        }
        button.setBaseStyle(baseStyle);
    }
},

//> @method listGrid.setFieldHeaderTitleStyle()
// Update the +link{listGridField.headerTitleStyle} for a field within the grid at runtime.
// @param name (String) name of the field.
// @param newStyle (CSSStyleName) new titleTyle for the field header
// @visibility external
//<
setFieldHeaderTitleStyle : function (name, titleStyle) {
    var field = this.getField(name);
    if (field == null) {
        this.logWarn("setFieldHeaderTitleStyle() unable to find field:" + name);
        return;
    }
    field.headerTitleStyle = titleStyle;
    var button = this.getFieldHeaderButton(this.getFieldNum(field));
    if (button != null) {
        if (titleStyle == null) {

            var buttonProperties = this.getHeaderButtonProperties();
            if (field.frozen && buttonProperties.frozenTitleStyle) {
                titleStyle = buttonProperties.frozenTitleStyle;
            } else if (buttonProperties.titleStyle) {
                titleStyle = buttonProperties.titleStyle;
            }
        }
        if (titleStyle == null) {
            titleStyle = button.getClass().getPrototype().titleStyle;
        }
        button.setTitleStyle(titleStyle);
    }
},

//> @method listGrid.setFieldIcon()
// Change the +link{listGridField.icon} for a field after the grid is created
// @param fieldName (String) field to update
// @param icon (SCImgURL) icon for the field
// @visibility external
//<
setFieldIcon : function (fieldName, icon) {
    var field = this.getField(fieldName);
    this.setFieldProperties(fieldName, {icon:icon});
    if (field && field.type == "icon" && field.cellIcon == null) {
        delete field._iconHTML
        this.body.markForRedraw("Field icon changed");
    }
},

//> @method listGrid.setFieldCellIcon()
// Change the +link{listGridField.cellIcon} for a field after the grid is created
// @param fieldName (String) field to update
// @param cellIcon (SCImgURL) new cellIcon for the field
// @visibility external
//<
setFieldCellIcon : function (fieldName, icon) {
    this.setFieldProperties(fieldName, {cellIcon:icon});
    var field = this.getField(fieldName);
    if (field && field.type == "icon") {
        delete field._iconHTML
        this.body.markForRedraw("Field cell icon changed");
    }
},


// AutoComplete
// --------------------------------------------------------------------------------------------

//> @method listGrid.setAutoComplete()
// Change the autoCompletion mode for the grid as a whole.
//
// @param   newSetting (AutoComplete)  new setting
// @group autoComplete
// @visibility autoComplete
//<

setAutoComplete : function (newSetting) {
    this.autoComplete = newSetting;
},

//> @method listGrid.setFieldAutoComplete()
// Change the autoCompletion mode for an individual field.
//
// @param   newSetting (AutoComplete)  new setting
// @group autoComplete
// @visibility autoComplete
//<

setFieldAutoComplete : function (field, newSetting) {
    field = this.getField(field);
    if (field) field.autoComplete = newSetting;
},

// --------------------------------------------------------------------------------------------

//> @method listGrid.showFields()
// Force an array of fields to be shown. This method does not add new fields to the grid,
// it simply changes field visibility. If a field.showIf expression exists, it will be
// destroyed.
// <P>
// Note: for showing multiple fields it is more efficient to call this method than to call
// +link{showField()} repeatedly.
//
// @param   field           (Array of String | Array of ListGridField)  Fields to show.
// @param   [suppressRelayout] (boolean) If passed, don't resize non-explicitly sized columns
//                                       to fill the available space.
// @visibility external
// @example columnOrder
//<
// Actually this is a synonym for showField() - separated for ease of documentation
showFields : function (fields, suppressRelayout) {
    return this.showField(fields,suppressRelayout);
},

//> @method listGrid.showField()
// Force a field to be shown. This method does not add new fields to the grid,
// it simply changes field visibility. If a field.showIf expression exists, it will be
// destroyed.
// <P>
// Note: for showing multiple fields it is more efficient to call +link{showFields()} than
// to call this method repeatedly.
//
// @param field (String | ListGridField) field to show
// @param [suppressRelayout] (boolean) If passed, don't resize non-explicitly sized columns
//                                       to fill the available space.
// @visibility external
// @example columnOrder
//<
showField : function (fields, suppressRelayout) {

    arguments.__this = this;

    // if setFields() hasn't been run, run it now, then call ourselves again
    if (this.completeFields == null) {
        this.setFields(this.completeFields || this.fields);
        return this.showField(fields, suppressRelayout);
    }

    if (!isc.isAn.Array(fields)) {
        fields = [fields];
    } else {
        
        fields = fields.duplicate();
    }

    var noFields = true,
        allVisible = true;

    var mustSetFields = this.frozenFields || this._suppressedFrozenFields;

    for (var i = 0; i < fields.length; i++) {
        
        var field = fields[i],
            fieldObj = field;
        if (!this._processingVisibilityRule) {
            this._removeFieldVisibleWhen(field);
        }

        // Use getSpecifiedField() to retrieve the fieldObject from the fields / completeFields
        // array.
        // Note that this returns null for an invalid field object / ID
        fieldObj = this.getSpecifiedField(fieldObj);

        if (fieldObj == null) {
            fields[i] = null;
            this.logWarn("showField(): unable to find field object for field: " + field
                         + ". Taking no action. Call setFields() to add new fields.")
            continue;
        }

        noFields = false;

        // Update initialization property to match new field state
        fieldObj.hidden = false;

        // Set hideOnPhone/hideOnTablet to null - we're explicitly overriding these
        fieldObj.hideOnPhone = fieldObj.hideOnTablet = null;

        // -- We always want to clear out any showIf property on the field, as even if the field is
        //    currently being shown, we want the field to continue to be shown from this point on
        //    regardless of any conditions in a showIf property
        
        if (fieldObj.detail) {
            fieldObj.showIf = "true";
        } else {
            if (fieldObj.showIf != null) fieldObj.showIf = null;
        }

        // need to call setFields if the field is frozen or if it was already visible at a 
        // different masterIndex
        if (fieldObj.frozen) mustSetFields = true;

        // if this field is in a headerSpan, we need to call setFields() to rebuild it
        if (this.spanMap && this.spanMap[fieldObj.name] != null) mustSetFields = true;

        if (mustSetFields) continue;

        // If this.fields contains the object, we can assume it's already visible if we're drawn
        // and will show up when we get drawn otherwise.
        if (this.fields.contains(fieldObj)) {
            fields[i] = null;
            continue;
        }

        // At this point we know we have at least one field that needs to be added
        // to the fields array (was previously hidden)
        allVisible = false;
        // hang onto the "live" fieldObj in the array
        fields[i] = fieldObj;
    }

    
    if (mustSetFields) {
        // don't call bindToDataSource() since that will disturb any manual field ordering
        this._suppressBindToDS = true;
        this.setFields(this.completeFields);
        delete this._suppressBindToDS;

        if (this.selectHeaderOnSort && this._sortSpecifiers) this.selectSortFieldHeaderButton();
        this.handleFieldStateChanged();
        return;
    }

    if (noFields || allVisible) return;

    // update this.fields
    this.deriveVisibleFields();

    // Empty slots may be present due to already visible fields
    fields.removeEmpty();

    var shownFieldNums = [],
        foundFields = 0;

    // Determine the position of the newly shown fields in our fields array.
    for (var i = 0; i < this.fields.length; i++) {
        var index = fields.indexOf(this.fields[i]);
        if (index != -1) {
            shownFieldNums[index] = i;

            foundFields++;
            // stop when we've figured out the position of all fields passed in.
            if (foundFields == fields.length) break;
        }
    }

    var header = this.header;
    // Update any UI to display the new field, if necessary
    

    // create the header button for the new column
    if (header != null) {
        if (!suppressRelayout) this.header.hPolicy = "fill";
        // undocumented feature - addButtons handles being passed an array of field indices
        // as well as an array of buttons
        
        this._suppressAutoFitToTitle = true;
        this.header.addButtons(fields.duplicate(), shownFieldNums);
        delete this._suppressAutoFitToTitle;
    }

    // tell the body about the new field
    if (this.body) {

        // If we're showing an editor in the new field we need to
        // - create the form items for it and slot it into the edit form
        // - shift the colNum on other items, and the _editColNum of the grid as a whole.
        if (this._editorShowing) {

            var editRowNum = this.getEditRow(),
                record = this.getRecord(editRowNum),

                
                editedRecord = this.getEditedRecord(editRowNum),

                adjustedEditColNum = false,
                items = this.getEditForm().items,
                liveItemIndex = items.length-1,
                liveItem = items[liveItemIndex],
                itemColNum = liveItem.colNum;

            // sort the shownFieldNums
            // this allows us to update the live edit item colNum values easily.
            // Note that it means the shownFieldNums will no longer match up to the fields
            // entries in the shown fields array.
            shownFieldNums.sort();

            for (var i = shownFieldNums.length-1; i >= 0; i--) {
                var offset = i+1,
                    fieldNum = shownFieldNums[i],
                    threshold = (fieldNum - i);

                if (!adjustedEditColNum && this._editColNum >= fieldNum) {
                    this._editColNum += offset;
                }

                // Update the edit form
                var fieldObj = this.fields[fieldNum],
                    width = this.getEditFormItemFieldWidths(record)[fieldNum],
                    item;

                while (liveItem != null && itemColNum >= threshold) {
                    liveItem.colNum += offset;

                    liveItemIndex --;
                    liveItem = (liveItemIndex >= 0) ? items[liveItemIndex] : null;
                    itemColNum = (liveItem != null) ? liveItem.colNum : null;
                }

                // at this point we've updated any items with a colNum >= ours
                // Create an item for the newly shown field and slot it into the edit form
                //
                // liveItemIndex will now be set to the slot before the one we're interested in
                // (index of the item that previously matched our colNum, minus 1)
                //
                // Note if we're editing by cell this won't apply since if we're showing an editor
                // the field its showing on must already be visible.
                var drawnRange = this.body.getDrawArea();
                if (!this.editByCell && fieldNum >= drawnRange[2] && fieldNum <= drawnRange[3]) {
                    item = this.getEditItem(fieldObj, record, editedRecord, editRowNum, fieldNum, width);
                }
                if (item != null) {
                    this._editRowForm.addItems([item], liveItemIndex+1);
                }
            }
        }

        this.body.fields = this.normalFields || this.fields;
        this.setBodyFieldWidths(this.getFieldWidths());

        this._remapEmbeddedComponentColumns(this.body);
    }

    // If we're auto-fitting vertically, allow the header to shrink or grow vertically
    // as appropriate
    
    if (this.header && this.autoFitHeaderHeights) {
        this.dropCachedHeaderButtonHeights();
        this._updateHeaderHeight();
    }


    // reset the sortFieldNum - we may have added or repositioned the primary sort field
    if (this.sortField != null) {
        this.sortFieldNum = null;
        this.sortFieldNum = this._getSortFieldNum();
        if (this.selectHeaderOnSort) this.selectSortFieldHeaderButton();
    }

    // If we have a filterEditor showing, update its fields too
    if (this.filterEditor != null) {
        this.filterEditor.showField(fields, suppressRelayout);
        if (this.allowFilterOperators) {
            for (var i = 0; i < fields.length; i++) {
                var filterForm = this.filterEditor.getEditForm(),
                    filterFormItem = filterForm && filterForm.getItem(fields[i].name)
                ;
                if (filterFormItem) {
                    var operator = this.getFieldSearchOperator(fields[i]);
                    this.updateOperatorIcon(fields[i], filterFormItem, operator);
                }
            }
        }
    }

    // update recordSummaries as well as grid/group ones
    this.recalculateSummaries(null, fields);
    if (this.summaryRow != null && this.showGridSummary) {
        this.summaryRow.showField(fields, suppressRelayout);
    }

    // reapply hilites - we don't store hilite information on hidden fields so if
    // hidden fields are displayed we'll need to reapply.
    if (this.hilites) this.applyHilites(true);

    // do an instant redraw rather than markForRedraw() because we have to avoid dropping values
    var gridBody = this.body;
    if (gridBody && gridBody.isDrawn()) gridBody.redraw("show field");
    this.markForRedraw("showField");

    this.handleFieldStateChanged();
    this._clearFieldDependencyTable();
    
},

// field.showIf function to return hideOnTablet etc if appropriate
_getFieldShowOnMobileFunction : function () {

    if (this._showOnMobileFunction == null) {
        this._showOnMobileFunction = function (list, field, fieldNum) {
            if (isc.Browser.isTablet && field.hideOnTablet != null) {
                return !field.hideOnTablet;
            }
            if (isc.Browser.isHandset && field.hideOnPhone != null) {
                return !field.hideOnPhone;
            }
        };
        this._showOnMobileFunction._isShowOnMobileFunction = true;
    }    
    return this._showOnMobileFunction;
},

//> @attr listGridField.hideOnPhone (Boolean : null : IRW)
// Set this property to true to suppress showing this field on mobile phones 
// (handset-sized devices). To update this property at runtime use 
// +link{listGrid.setHideOnPhone()}
// <P>
// Note that if +link{listGridField.hidden} is set, or an explicit +link{listGridField.showIf} 
// function exists that will take precedence over this setting. 
// Similarly, an explicit call to +link{listGrid.showField()} or
// +link{listGrid.hideField()} will clear this setting.
// <P>
// See also the related property +link{listGridField.hideOnTablet}.
//
// @group appearance
// @visibility external
//<

//> @method listGrid.setHideOnPhone()
// Updates the +link{listGridField.hideOnPhone} attribute at runtime.
// @param field (ListGridField | String) field or field name to update
// @param hideOnPhone (Boolean) new setting for hideOnPhone property
// @visibility external
//<
setHideOnPhone : function (field, hideOnPhone) {
    var field = this.getFieldByName(field); // resolve number/name to a field object
    if (field == null) return;
    if (field.hideOnPhone === hideOnPhone) {
        return;
    }
    field.hideOnPhone = hideOnPhone;

    // Don't override explicit showIf function
    if (field.showIf == null) {
        field.showIf = this._getFieldShowOnMobileFunction();
    }
    this.refreshFields();

},

//> @attr listGridField.hideOnTablet (Boolean : null : IRW)
// Set this property to true to suppress showing this field on tablets 
// (tablet-sized devices). To update this property at runtime use 
// +link{listGrid.setHideOnTablet()}
// <P>
// Note that if +link{listGridField.hidden} is set, or an explicit +link{listGridField.showIf} 
// function exists that will take precedence over this setting. 
// Similarly, an explicit call to +link{listGrid.showField()} or
// +link{listGrid.hideField()} will clear this setting.
// <P>
// See also the related property +link{listGridField.hideOnPhone}.
//
// @group appearance
// @visibility external
//<

//> @method listGrid.setHideOnTablet()
// Updates the +link{listGridField.hideOnTablet} attribute at runtime.
// @param field (ListGridField | String) field or field name to update
// @param hideOnTablet (Boolean) new setting for hideOnTablet property
// @visibility external
//<
setHideOnTablet : function (field, hideOnTablet) {
    var field = this.getFieldByName(field); // resolve number/name to a field object
    if (field == null) return;
    if (field.hideOnTablet === hideOnTablet) {
        return;
    }
    field.hideOnTablet = hideOnTablet;

    // Don't override explicit showIf function
    if (field.showIf == null) {
        field.showIf = this._getFieldShowOnMobileFunction();
    }
    this.refreshFields();
},

selectSortFieldHeaderButton : function () {
    // reselect the sortField
    var sort = this.getSort();
    if (sort && sort.length > 0) {
        var fieldNum = this.getFieldNum(sort[0].property);
        if (fieldNum>=0) {
            // select the appropriate button
            var sortHeader = this.getFieldHeader(fieldNum),
                sortButton = this.getFieldHeaderButton(fieldNum)
            ;

            if (sortButton) {
                sortHeader.selectButton(sortButton);
                if (isc.Browser.isTouch && this.shouldShowHeaderMenuButton(sortButton, true)) {
                    this._showHeaderMenuButton(sortButton);
                }
            }
        }
    }
},

//> @method listGrid.hideFields()
// Force an array of fields to be hidden.
// <P>
// NOTE: If a field.showIf expression exists, it will be destroyed.
// <P>
// When hiding multiple fields, this method should be called rather than
// calling +link{listGrid.hideField()} repeatedly for each field to hide.
//
// @param fields (Array of String | Array of ListGridField) fields to hide
// @param [suppressRelayout] (boolean) if passed, don't relayout non-explicit sized fields
//                                      to fit the available space
// @visibility external
//<
hideFields : function (fields, suppressRelayout) {
    return this.hideField(fields, suppressRelayout);
},

//> @attr listGrid.discardEditsOnHideField (boolean : true : IRW)
// If a user is editing a +link{listGrid.canEdit,canEdit:true} listGrid, and they hide
// a field while the editor is showing, should we discard any edits in the edit row for
// the field being hidden?
// <P>
// Default behavior is to discard the edits - set this flag to false to preserve edits
// @visibility external
//<
// The intention here is to avoid confusion. If the user is editing a field in an
// auto-save-edits:true grid, it is rare for there to be pending editor values outside the
// edit-form. Most commonly this will occur only for validation failure.
// In this case, if the edits a field and hides it and then a save fails due to a validation
// failure on the hidden field, there's no user-visible feedback indicating what happened.
// Developers who choose to do so can set this flag to false and handle this case via 
// validation failure handling code at the grid level of course.
// We also disable this for the filterEditor where we want to retain filter criteria which
// are not reflected in the visible set of fields.
discardEditsOnHideField:true,

//> @method listGrid.hideField()
// Force a field to be hidden.<br><br>
//
// NOTE: If a field.showIf expression exists, it will be destroyed.
// <P>
// Note also that if multiple fields are to be hidden it is more efficient to call
// +link{hideFields()} passing in the array of fields to hide rather than to call this method
// repeatedly.  In particular, this will ensure +link{recalculateSummaries()} is only run once.
//
// @param field (String | ListGridField) field to hide
// @param [suppressRelayout] (boolean) if passed, don't relayout non-explicit sized fields
//                                      to fit the available space
// @visibility external
// @example columnOrder
//<
hideField : function (fields, suppressRelayout) {
    arguments.__this = this;

    // if setFields() hasn't been run, run it now, then call ourselves again
    if (this.completeFields == null) {
        this.setFields(this.completeFields || this.fields);
        return this.hideField(fields, suppressRelayout);
    }

    var noFields = true,
        allHidden = true;

    if (!isc.isAn.Array(fields)) {
        fields = [fields];
    }
    // we shuffle some stored colNums around on edit items - store out the index of each field
    // being hidden in an array to make this easier.
    var hiddenFieldNums = [];

    if (fields.length == this.getFields().length) {
        // can't hide the last bunch of fields
        this.logWarn("Attempt to hide all fields in one call - disallowed.");
        return;
    }

    

    var mustSetFields = this.frozenFields;
    // If we're showing an editor we need to make certain changes to get rid of the
    // form item, etc.
    var editorShowing = this._editorShowing,
        editRow = editorShowing ? this.getEditRow() : null,
        editCol = editorShowing ? this.getEditCol() : null,
        hidEditCell = false;
    for (var i = 0; i < fields.length; i++) {
        var field = fields[i],
            fieldObj = field;

        // Use getSpecifiedField() to pick up the field object from the completeFields array
        // (or if setFields has never been called, from the fields array).
        // Note - if we're passed an invalid field object, this method returns null.
        fieldObj = this.getSpecifiedField(fieldObj);
        if (fieldObj == null) {
            this.logWarn("hideField(): unable to find field object for field: " + field
                         + ". Taking no action. To add this field use the setFields() method.");
            fields[i] = null;
            continue;
        }

        noFields = false;
        if (!this._processingVisibilityRule) {
            this._removeFieldVisibleWhen(field);
        }

        // Set hideOnPhone/hideOnTablet to null - we're explicitly overriding these
        
        fieldObj.hideOnPhone = fieldObj.hideOnTablet = null;

        // -- Set showIf to always evaluate to false.
        fieldObj.showIf = this._$false;
        // If the field is not currently present in this.fields, we can safely assume it's already
        // hidden. No need to proceed in this case
        if (!this.fields.contains(fieldObj)) {
            fields[i] = null;
            continue;
        }
        allHidden = false;

        // Update initialization property to match new field state
        fieldObj.hidden = true;

        // If we're going to call setFields, we're done - we'll just call that
        // method outside this for-loop to update the completeFields array, edit values, etc.
        if (mustSetFields) continue;

        var fieldNum = this.fields.indexOf(fieldObj),
            fieldName = this.getFieldName(fieldNum);

        hiddenFieldNums.add(fieldNum);

        if (editorShowing) {
            if (editCol == fieldNum) hidEditCell = true;

            // If the user has modified the edit value and not yet stored the change
            // (IE it isn't yet part of our 'pending edit values' for the row), discard
            // the unsaved edits.
            
            // By default we're going to clear the edit value from the cell being hidden
            // pass the additional 3rd parameter to avoid re-displaying the record's value
            // in the (about to be cleared) cell.
            var focusItem = this.getEditFormItem(fieldName);
            // (Item may not exist due to incremental rendering, non editable fields, editByCell)
            if (focusItem && focusItem.hasFocus) focusItem.blurItem();
            
            if (this.discardEditsOnHideField) {
                this.clearEditValue(editRow, fieldNum, true);
            }
        }
    }
    // If we were passed an empty array, or an array containing already hidden fields
    // we can bail here.
    if (noFields || allHidden) return;

    
    if (mustSetFields) {

        // don't call bindToDataSource() since that will disturb any manual field ordering
        this._suppressBindToDS = true;
        this.setFields(this.completeFields);
        delete this._suppressBindToDS;

        if (this.selectHeaderOnSort && this._sortSpecifiers) this.selectSortFieldHeaderButton();
        this.handleFieldStateChanged();
        return;
    }

    fields.removeEmpty();
    if (editorShowing) {
        if (hidEditCell) {
            // If we're editing by cell, and hiding the current edit cell just kill the edit.
            if (this.editByCell) {
                this.cancelEditing(isc.ListGrid.PROGRAMMATIC);
                editorShowing = false;
            } else {
                // If possible we want to shift edit focus to an adjacent field
                // findNextEditCell() is unaware of the cells we've just hidden so
                // reimplement the relevant part of this method to find the next editable and
                // still visible field. Check for closest field to the left first, then to the right
                var newEditCol = editCol-1,
                    foundEditCol = false;
                while (newEditCol >= 0) {
                    if (!hiddenFieldNums.contains(newEditCol) &&
                        this.canEditCell(editRow, newEditCol) &&
                        this._canFocusInEditor(editRow, newEditCol))
                    {
                        foundEditCol = true;
                        break;
                    }
                    newEditCol--;
                }
                if (!foundEditCol) {
                    newEditCol = editCol +1;
                    while (newEditCol < this.fields.length) {
                        if (!hiddenFieldNums.contains(newEditCol) &&
                            this.canEditCell(editRow, newEditCol) &&
                            this._canFocusInEditor(editRow, newEditCol))
                        {
                            foundEditCol = true;
                            break;
                        }
                        newEditCol++;
                    }
                }

                // If we don't have any other editable cells in the row, just cancel the edit
                if (!foundEditCol) {
                    this.cancelEditing(isc.ListGrid.PROGRAMMATIC);
                    editorShowing = false;
                } else {
                    // focus in the adjacent field.
                    
                    this._startEditing(editRow, newEditCol,
                                            !this.getEditForm().hasFocus);
                }
            }
        }
    }
    // update this.fields
    this.deriveVisibleFields();
    // destroy the header button
    var header = this.header;
    if (header != null) {
        // Setting the hPolicy to "fill" will cause the header to relay it's buttons out to
        // fill the available space.
        if (!suppressRelayout) this.header.hPolicy = "fill";
        var buttons = [];
        for (var i = 0; i < hiddenFieldNums.length; i++) {
            var fieldNum = hiddenFieldNums[i];

            var button = this.header.getButton(fieldNum);
            buttons[buttons.length] = button;
            if (this.headerMenuButton && this.headerMenuButton.masterElement == button) {
                this.headerMenuButton.depeer();
            }
        }
        // removeButtons actually effects the display passed in, so duplicate it
        this.header.removeButtons(buttons.duplicate());
        buttons.callMethod("destroy");

        // If we're auto-fitting vertically, allow the header to shrink or grow vertically
        // as appropriate
        if (this.autoFitHeaderHeights) {
            this.dropCachedHeaderButtonHeights();
            this._updateHeaderHeight();
        }
    }
    // If we're currently showing any edit form items for subsequent columns,
    // we must decrement their 'colNum' properties.
    // do this *before* we redraw the body, as the body redraw relies on these values being
    // accurate to create new items for fields that get shifted into view.
    // Also update the _editColNum if necessary.

    
    var itemsToClear = [];
    if (editorShowing) {
        hiddenFieldNums.sort();

        var form = this._editRowForm,
            items = form.getItems(),

            itemIndex = items.length-1,
            item = items[itemIndex],
            itemColNum = item.colNum,

            adjustedEditColNum = false;

        for (var i = hiddenFieldNums.length-1; i >= 0; i--) {

            var offset = i+1,
                threshold = hiddenFieldNums[i];

            if (!adjustedEditColNum && this._editColNum > threshold) {
                this._editColNum -= offset;
                adjustedEditColNum = true;
            }

            while (item != null && itemColNum >= threshold) {
                if (itemColNum == threshold) itemsToClear.add(item);
                else item.colNum -= offset;

                itemIndex --;
                item = (itemIndex >= 0) ? items[itemIndex] : null;
                itemColNum = (item != null) ? item.colNum : null;
            }
        }
    }
    // tell the body about the removed fields
    if (this.body) {
        this.body.fields = this.normalFields || this.fields;
        this.setBodyFieldWidths(this.getFieldWidths());

        this._remapEmbeddedComponentColumns(this.body);
    }

    if (editorShowing && itemsToClear.length > 0) {
        // If we're currently showing an edit form item for this field, remove it now (already
        // been cleared from the DOM), and had the edit values cleared.
        for (var i = 0; i < itemsToClear.length; i++) {
            // Hide the actual item if there is one.
            var item = itemsToClear[i];
            // Note that we may already have updated the items as part of redraw so
            // don't attempt to remove an already destroyed item from the form
            if (item.destroyed) continue;
            this._editRowForm.removeItems([item]);
        }
    }
    // reset the sortFieldNum - we may have removed or repositioned the primary sort field
    if (this.sortField != null) {
        this.sortFieldNum = null;
        this.sortFieldNum = this._getSortFieldNum();
        if (this.selectHeaderOnSort && this.header) this.selectSortFieldHeaderButton();
    }

    // If we have a filterEditor showing, update its fields too
    if (this.filterEditor != null) this.filterEditor.hideField(fields, suppressRelayout);

    // update recordSummaries as well as grid/group ones
    this.recalculateSummaries();
    if (this.summaryRow && this.showGridSummary) {
        this.summaryRow.hideField(fields, suppressRelayout);
    }

    // do an instant redraw rather than markForRedraw() because we have to avoid dropping values