/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Config;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLTable;
import com.isomorphic.util.ISCSystem;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PostgresDriver
extends SQLDriver {
    private static Logger log = new Logger(PostgresDriver.class.getName());
    Boolean standard_conforming_strings = null;
    private static final Map<String, String> formulaReplacements;
    private static final SQLDriver.FormulaConfig formulaConfig;

    public PostgresDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
        if (this.metaData.getString((Object)"standard_conforming_strings") != null) {
            this.standard_conforming_strings = "on".equals(this.metaData.getString((Object)"standard_conforming_strings")) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    @Override
    public boolean supportsNativeReplace() {
        return false;
    }

    @Override
    public boolean supportsRegexp() throws Exception {
        return this.getDatabaseMajorVersion() > 9 || this.getDatabaseMajorVersion() == 9 && this.getDatabaseMinorVersion() >= 3;
    }

    @Override
    public String getExpressionForRegexp(String escapedColumnOrExpression, String operator, String regexp) throws Exception {
        return escapedColumnOrExpression + " ~" + ("iregexp".equals(operator) ? "*" : "") + " " + this.escapeRegexp(regexp);
    }

    @Override
    public int caseSensitiveStrategyForRelativeComparisons() {
        return -1;
    }

    @Override
    public String caseSensitiveFieldPrefixForRelativeComparisons() {
        return "CAST(";
    }

    @Override
    public String caseSensitiveFieldSuffixForRelativeComparisons() {
        return " AS bytea)";
    }

    @Override
    public boolean supportsSQLLimit() {
        return true;
    }

    @Override
    public String limitQuery(String query, long startRow, long batchSize, List outputColumns, String baseOrderClause, String computedOrderClause, DSRequest req, List dataSources, Map context) {
        Object q = query;
        if (computedOrderClause != null && computedOrderClause.trim().length() > 0) {
            q = baseOrderClause == null || baseOrderClause.trim().length() == 0 || "$defaultOrderClause".equals(baseOrderClause) && (context.get("defaultOrderClause") == null || ((String)context.get("defaultOrderClause")).trim().length() == 0) ? (String)q + " ORDER BY " : (String)q + ", ";
            q = (String)q + computedOrderClause;
        }
        return (String)q + " OFFSET " + startRow + " LIMIT " + batchSize;
    }

    @Override
    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        if (this.dbConnection == null && req == null) {
            throw new Exception("no existing db connection exists for last row fetch");
        }
        Object sqlStatement = null;
        Map primaryKeys = primaryKeysPresent;
        for (String sequenceName : sequencesNotPresent) {
            Object obj;
            String sequence = this.getCurrentSequenceValue((String)ds.getCorrectDs2NativeFieldMap().get(sequenceName), ds);
            if (sequence == null || (obj = PostgresDriver.getScalarResult("SELECT " + sequence, this.dbConnection, this.dbName, this, req)) == null) continue;
            Object transformed = this.getTransformedSequenceValue(obj, sequenceName, ds, req);
            if (transformed != null) {
                primaryKeys.put(sequenceName, transformed);
                continue;
            }
            Long sequenceValue = Long.valueOf(obj.toString());
            primaryKeys.put(sequenceName, sequenceValue);
        }
        return primaryKeys;
    }

    @Override
    public String formatValue(Object value) {
        return value.toString();
    }

    @Override
    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        return this.sqlOutTransform(columnName, remapName, tableName, null, null, null);
    }

    @Override
    public String sqlOutTransform(String columnName, String remapName, String tableName, String functionName, Map functionParams, String unionDSFType) throws Exception {
        Object output = null;
        if (columnName == null && unionDSFType != null) {
            output = this.escapeAndCastColumnName(columnName, unionDSFType, remapName);
        }
        if (output == null) {
            output = this.escapeColumnName(columnName);
        }
        if (tableName != null) {
            output = tableName + "." + (String)output;
        }
        if (functionName != null && !"".equals(functionName)) {
            output = this.sqlOutTransformFunction((String)output, functionName, functionParams);
            if (remapName != null) {
                output = (String)output + " AS " + this.escapeColumnName(remapName);
            }
        } else if (remapName != null && !remapName.equals(columnName)) {
            output = (String)output + " AS " + this.escapeColumnName(remapName);
        }
        return output;
    }

    @Override
    protected SQLDriver.FormulaConfig getFormulaConfig() {
        return formulaConfig;
    }

    @Override
    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeValueUnquoted(value.toString(), false) + "'";
    }

    @Override
    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = this.matcher.reset(value.toString()).usePattern(SINGLE_QUOTE_PATTERN).replaceAll(SINGLE_QUOTE_ESCAPE);
        if (escapeForFilter) {
            String BACKSLASH_ESCAPE_PATTERN = this.standard_conforming_strings == Boolean.TRUE ? BACKSLASH_ESCAPE : BACKSLASH_ESCAPE_DOUBLE;
            escaped = this.matcher.reset(escaped).usePattern(BACKSLASH_PATTERN).replaceAll(BACKSLASH_ESCAPE_PATTERN);
            escaped = this.matcher.reset(escaped).usePattern(PERCENT_PATTERN).replaceAll(PERCENT_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(UNDERSCORE_PATTERN).replaceAll(UNDERSCORE_ESCAPE);
        } else if (this.standard_conforming_strings != Boolean.TRUE) {
            escaped = this.matcher.reset(escaped).usePattern(BACKSLASH_PATTERN).replaceAll(BACKSLASH_ESCAPE);
        }
        return escaped;
    }

    public String escapeAndCastColumnName(Object columnName, String type, String remapName) {
        Object escaped = this.escapeColumnName(columnName, false);
        escaped = "integer".equals(type) ? "CAST ( " + (String)escaped + " AS bigint )" : ("float".equals(type) ? "CAST ( " + (String)escaped + " AS double precision )" : ("date".equals(type) ? "CAST ( " + (String)escaped + " AS date )" : ("datetime".equals(type) ? "CAST ( " + (String)escaped + " AS timestamp )" : ("time".equals(type) ? "CAST ( " + (String)escaped + " AS time )" : (String)escaped))));
        return escaped;
    }

    @Override
    public boolean useActualSequenceObjects(SQLDataSource ds) {
        return true;
    }

    @Override
    public String getNextSequenceValue(String columnName, SQLDataSource ds) throws Exception {
        String sequenceName = this.getSequenceName(columnName, ds);
        if (sequenceName == null) {
            return null;
        }
        Object schema = "";
        if (ds != null) {
            schema = ds.getSchemaName();
            schema = schema == null ? "" : (String)schema + ".";
        }
        return "nextval('" + (String)schema + sequenceName + "')";
    }

    public String getCurrentSequenceValue(String columnName, SQLDataSource ds) throws Exception {
        String sequenceName = this.getSequenceName(columnName);
        if (sequenceName == null) {
            return null;
        }
        Object schema = "";
        if (ds != null) {
            schema = ds.getSchemaName();
            schema = schema == null ? "" : (String)schema + ".";
        }
        return "currval('" + (String)schema + sequenceName + "')";
    }

    @Override
    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        String expr = "CASE " + column;
        for (String rawValue : valueMap.keySet()) {
            String actualValue = this.transformActualValueForSort(rawValue, column, request);
            String displayValue = this.getLocalizedDisplayValue(valueMap.get(rawValue), request);
            displayValue = this.escapeValue(displayValue);
            expr = expr + " WHEN " + actualValue + " THEN " + displayValue;
        }
        expr = expr + " ELSE CAST (" + column + " AS TEXT) END";
        return expr;
    }

    @Override
    public String sqlCast(String result, DSField field) {
        String type = field.getType();
        if (type != null) {
            if (DataSource.simpleTypeInheritsFromBuiltInType((String)type, (String)"datetime")) {
                return "CAST(" + result + " AS TIMESTAMP)";
            }
            if (DataSource.simpleTypeInheritsFromBuiltInType((String)type, (String)"float")) {
                return "CAST(" + result + " AS REAL)";
            }
        }
        return super.sqlCast(result, field);
    }

    @Override
    public boolean canSetFetchSize() {
        try {
            return this.getDatabaseMajorVersion() > 7 || this.getDatabaseMajorVersion() == 7 && this.getDatabaseMinorVersion() >= 4;
        }
        catch (Exception e) {
            log.warn((Object)"Caught Exception attempting to determine Postgres version", (Throwable)e);
            return true;
        }
    }

    @Override
    public boolean castNumbersBeforeLikeCompare() {
        return true;
    }

    @Override
    public String getNaturalDatabaseObjectName(String objectName) {
        return objectName == null ? null : objectName.toLowerCase();
    }

    @Override
    public boolean aliasRequiredForSubselect() {
        return true;
    }

    @Override
    public boolean shouldParameterizeNullValues(boolean isMultiInserting) {
        return false;
    }

    @Override
    public String getDummyQuery() {
        return "SELECT 1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSnapshot(File snapshotFile) throws Exception {
        snapshotFile.deleteOnExit();
        String snapshotFileName = snapshotFile.getCanonicalPath();
        String cmd = "db --name=" + this.dbName + " snapshot " + this.defaultSchemaName + " " + snapshotFileName;
        Class<PostgresDriver> clazz = PostgresDriver.class;
        synchronized (PostgresDriver.class) {
            ISCSystem iscSystem = ISCSystem.execute((String)cmd).waitFor();
            int exitValue = iscSystem.exitValue();
            if (exitValue != 0) {
                throw new Exception(iscSystem.getFormattedErrorString());
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreFromSnapshot(File snapshotFile) throws Exception {
        String snapshotFileName = snapshotFile.getCanonicalPath();
        String cmd = "db --name=" + this.dbName + " restore " + this.defaultSchemaName + " " + snapshotFileName;
        Class<PostgresDriver> clazz = PostgresDriver.class;
        synchronized (PostgresDriver.class) {
            ISCSystem iscSystem = ISCSystem.execute((String)cmd).waitFor();
            int exitValue = iscSystem.exitValue();
            if (exitValue != 0) {
                throw new Exception(iscSystem.getFormattedErrorString());
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected boolean defaultLikeIsCaseSensitive() {
        if (Config.getGlobal().getBoolean((Object)"sql.postgresql.useILike", false)) {
            return false;
        }
        return super.defaultLikeIsCaseSensitive();
    }

    @Override
    public String caseInsensitiveLikePredicate() {
        if (Config.getGlobal().getBoolean((Object)"sql.postgresql.useILike", false)) {
            return "ILIKE";
        }
        return super.caseInsensitiveLikePredicate();
    }

    @Override
    public String caseInsensitiveEqualsPredicate() {
        if (Config.getGlobal().getBoolean((Object)"sql.postgresql.useILike", false)) {
            return " ILIKE ";
        }
        return super.caseInsensitiveEqualsPredicate();
    }

    @Override
    protected int defaultAliasLengthLimit() {
        return 63;
    }

    @Override
    public String getDriverSpecificSQLType(String jdbcTypeName, String rsmdTypeName) {
        if ("other".equals(jdbcTypeName) && "uuid".equals(rsmdTypeName)) {
            return rsmdTypeName;
        }
        return jdbcTypeName;
    }

    @Override
    public String getTextColumnDefinitionForLength(long length) throws Exception {
        if (length <= 4000L) {
            return "varchar(" + length + ")";
        }
        if (length <= 0x3FFFFFFFL) {
            return "text";
        }
        throw new Exception("Column length > 1GB is not supported by Postgres");
    }

    @Override
    public String getFloatType() {
        return "real";
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("ceil", "ceiling");
        m.put("max", "greatest");
        m.put("min", "least");
        m.put("pow", "power");
        m.put("rand", "random");
        m.put("substring", "substr");
        m.put("len", "length");
        m.put("currentDateTime", "now");
        m.put("year(", "extract(year from");
        m.put("month(", "extract(month from");
        m.put("day(", "extract(day from");
        m.put("hour(", "extract(hour from");
        m.put("minute(", "extract(minute from");
        m.put("second(", "extract(second from");
        formulaReplacements = Collections.synchronizedMap(m);
        formulaConfig = new SQLDriver.FormulaConfig(formulaReplacements);
    }
}

