/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.io.ByteCountingOutputStream;
import com.isomorphic.io.IByteCounter;
import com.isomorphic.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileItemHeaders;

public class ISCFileItem
implements FileItem<ISCFileItem> {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;
    String fieldName;
    String contentType;
    boolean isFormField;
    String fileName;
    private FileItemHeaders headers;
    OutputStream os;
    ByteArrayOutputStream data;
    IByteCounter byteCounter;
    long expectedSize = -1L;
    String shortFileName;

    public static Builder builder() {
        return new Builder();
    }

    public ISCFileItem(String fieldName) {
        this.fieldName = fieldName;
    }

    public ISCFileItem(String fieldName, String contentType, boolean isFormField, String fileName, IByteCounter byteCounter) {
        this(fieldName);
        this.contentType = contentType;
        this.isFormField = isFormField;
        this.fileName = fileName;
        this.byteCounter = byteCounter;
    }

    public ISCFileItem delete() {
        return this;
    }

    public byte[] get() {
        return this.data.toByteArray();
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public ISCFileItem setFieldName(String name) {
        this.fieldName = name;
        return this;
    }

    public String getName() {
        return this.fileName;
    }

    public InputStream getInputStream() {
        byte[] dataArray = this.get();
        if (dataArray != null && dataArray.length > 0) {
            return new ByteArrayInputStream(this.get());
        }
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.os == null) {
            this.data = new ByteArrayOutputStream();
            this.os = this.data;
            if (this.byteCounter != null) {
                this.os = new ByteCountingOutputStream(this.data, this.byteCounter);
            }
        }
        return this.os;
    }

    public long getSize() {
        return this.data.size();
    }

    public String getString() {
        return new String(this.get());
    }

    public String getString(String encoding) throws UnsupportedEncodingException {
        return new String(this.get(), encoding);
    }

    public String getString(Charset encoding) throws UnsupportedEncodingException {
        return this.getString(encoding.name());
    }

    public boolean isFormField() {
        return this.isFormField;
    }

    public ISCFileItem setFormField(boolean state) {
        this.isFormField = state;
        return this;
    }

    public boolean isInMemory() {
        return true;
    }

    public ISCFileItem write(File file) throws IOException {
        IOUtil.atomicWrite(this.getInputStream(), file);
        return this;
    }

    public ISCFileItem write(Path file) throws IOException {
        this.write(file.toFile());
        return this;
    }

    public void setTotalSize(long size) {
        this.expectedSize = size;
    }

    public long getTotalSize() {
        if (this.expectedSize == -1L && this.byteCounter != null) {
            this.setTotalSize(this.byteCounter.getTotalBytes());
        }
        return this.expectedSize;
    }

    public String getFileName() {
        return this.getName();
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String getShortFileName() {
        return this.shortFileName;
    }

    public void setShortFileName(String name) {
        this.shortFileName = name;
    }

    public void setErrors(List<?> errors) {
        this.byteCounter.setErrors(errors);
    }

    public List<?> getErrors() {
        return this.byteCounter.getErrors();
    }

    public FileItemHeaders getHeaders() {
        return this.headers;
    }

    public ISCFileItem setHeaders(FileItemHeaders headers) {
        this.headers = headers;
        return this;
    }

    public static class Builder
    extends FileItemFactory.AbstractFileItemBuilder<ISCFileItem, Builder> {
        IByteCounter byteCounter;

        public Builder() {
            this.setCharset(StandardCharsets.ISO_8859_1);
            this.setCharsetDefault(DEFAULT_CHARSET);
        }

        public ISCFileItem get() {
            ISCFileItem iscFileItem = new ISCFileItem(this.getFieldName(), this.getContentType(), this.isFormField(), this.getFileName(), this.getByteCounter());
            FileItemHeaders headers = this.getFileItemHeaders();
            if (headers != null) {
                iscFileItem.setHeaders(headers);
            }
            return iscFileItem;
        }

        public IByteCounter getByteCounter() {
            return this.byteCounter;
        }

        public Builder setByteCounter(IByteCounter byteCounter) {
            this.byteCounter = byteCounter;
            return this;
        }
    }
}

