/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.util.workflow;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * A Task is an abstract superclass for all Task types that can be involved in a Process, such as a {@link
 * com.smartgwt.client.util.workflow.DSRequestTask}.
 */
@BeanFactory.FrameworkClass
@BeanFactory.ScClassName("Task")
public class Task extends ProcessElement {

    public static Task getOrCreateRef(JavaScriptObject jsObj) {
        if(jsObj == null) return null;
        BaseClass obj = BaseClass.getRef(jsObj);
        if(obj != null) {
            return (Task) obj;
        } else {
            return new Task(jsObj);
        }
    }
        


    public Task(){
        scClassName = "Task";
    }

    public Task(JavaScriptObject jsObj){
        scClassName = "Task";
        setJavaScriptObject(jsObj);
    }

    public native JavaScriptObject create()/*-{
        var config = this.@com.smartgwt.client.core.BaseClass::getConfig()();
        var scClassName = this.@com.smartgwt.client.core.BaseClass::scClassName;
        return $wnd.isc[scClassName].create(config);
    }-*/;


    // ********************* Properties / Attributes ***********************

    /**
     * List of multiple fields from the {@link com.smartgwt.client.util.workflow.Process#getState process state} which are
     * provided as input data to this task. See {@link com.smartgwt.client.docs.TaskIO}.
     *
     * @param inputFieldList New inputFieldList value. Default value is null
     * @return {@link com.smartgwt.client.util.workflow.Task Task} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.TaskIO Task Input / Output
     * @deprecated In favor of {@link com.smartgwt.client.util.workflow.Task#getInputs inputs} as of  SmartGWT release 13.1
     */
    public Task setInputFieldList(String... inputFieldList)  throws IllegalStateException {
        return (Task)setAttribute("inputFieldList", inputFieldList, false);
    }

    /**
     * List of multiple fields from the {@link com.smartgwt.client.util.workflow.Process#getState process state} which are
     * provided as input data to this task. See {@link com.smartgwt.client.docs.TaskIO}.
     *
     * @return Current inputFieldList value. Default value is null
     * @see com.smartgwt.client.docs.TaskIO Task Input / Output
     * @deprecated In favor of {@link com.smartgwt.client.util.workflow.Task#getInputs inputs} as of  SmartGWT release 13.1
     */
    public String[] getInputFieldList()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("inputFieldList"));
    }
    

    /**
     * Defines how fields in the {@link com.smartgwt.client.util.workflow.Process#getState process state} are extracted for the
     * input record to this task. <p> When <code>inputs</code> is an object, the keys are the {@link
     * com.smartgwt.client.docs.SetterPath setter paths} of the fields to be set in the input record, and the values are
     * literals or {@link com.smartgwt.client.docs.TaskInputExpression taskInputExpressions}. See {@link
     * com.smartgwt.client.docs.TaskIO}.
     *
     * @param inputs New inputs value. Default value is null
     * @return {@link com.smartgwt.client.util.workflow.Task Task} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.TaskIO Task Input / Output
     */
    public Task setInputs(Map inputs)  throws IllegalStateException {
        return (Task)setAttribute("inputs", inputs, false);
    }

    /**
     * Defines how fields in the {@link com.smartgwt.client.util.workflow.Process#getState process state} are extracted for the
     * input record to this task. <p> When <code>inputs</code> is an object, the keys are the {@link
     * com.smartgwt.client.docs.SetterPath setter paths} of the fields to be set in the input record, and the values are
     * literals or {@link com.smartgwt.client.docs.TaskInputExpression taskInputExpressions}. See {@link
     * com.smartgwt.client.docs.TaskIO}.
     *
     * @return Current inputs value. Default value is null
     * @see com.smartgwt.client.docs.TaskIO Task Input / Output
     */
    public Map getInputs()  {
        return getAttributeAsMap("inputs");
    }

    /**
     * Defines how fields in the {@link com.smartgwt.client.util.workflow.Process#getState process state} are extracted for the
     * input record to this task. <p> When <code>inputs</code> is an object, the keys are the {@link
     * com.smartgwt.client.docs.SetterPath setter paths} of the fields to be set in the input record, and the values are
     * literals or {@link com.smartgwt.client.docs.TaskInputExpression taskInputExpressions}. See {@link
     * com.smartgwt.client.docs.TaskIO}.
     *
     * @param inputs New inputs value. Default value is null
     * @return {@link com.smartgwt.client.util.workflow.Task Task} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.StatePath StatePath 
     * @see com.smartgwt.client.docs.TaskIO Task Input / Output
     */
    public Task setInputs(String... inputs)  throws IllegalStateException {
        return (Task)setAttribute("inputs", inputs, false);
    }

    /**
     * Defines how fields in the {@link com.smartgwt.client.util.workflow.Process#getState process state} are extracted for the
     * input record to this task. <p> When <code>inputs</code> is an object, the keys are the {@link
     * com.smartgwt.client.docs.SetterPath setter paths} of the fields to be set in the input record, and the values are
     * literals or {@link com.smartgwt.client.docs.TaskInputExpression taskInputExpressions}. See {@link
     * com.smartgwt.client.docs.TaskIO}.
     *
     * @return Current inputs value. Default value is null
     * @see com.smartgwt.client.docs.StatePath StatePath 
     * @see com.smartgwt.client.docs.TaskIO Task Input / Output
     */
    public String[] getInputsAsStringArray()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("inputs"));
    }

    /**
     * Defines how fields in the {@link com.smartgwt.client.util.workflow.Process#getState process state} are extracted for the
     * input record to this task. <p> When <code>inputs</code> is an object, the keys are the {@link
     * com.smartgwt.client.docs.SetterPath setter paths} of the fields to be set in the input record, and the values are
     * literals or {@link com.smartgwt.client.docs.TaskInputExpression taskInputExpressions}. See {@link
     * com.smartgwt.client.docs.TaskIO}.
     *
     * @param inputs New inputs value. Default value is null
     * @return {@link com.smartgwt.client.util.workflow.Task Task} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.StatePath StatePath 
     * @see com.smartgwt.client.docs.StatePath StatePath 
     * @see com.smartgwt.client.docs.TaskIO Task Input / Output
     */
    public Task setInputs(String inputs)  throws IllegalStateException {
        return (Task)setAttribute("inputs", inputs, false);
    }

    /**
     * Defines how fields in the {@link com.smartgwt.client.util.workflow.Process#getState process state} are extracted for the
     * input record to this task. <p> When <code>inputs</code> is an object, the keys are the {@link
     * com.smartgwt.client.docs.SetterPath setter paths} of the fields to be set in the input record, and the values are
     * literals or {@link com.smartgwt.client.docs.TaskInputExpression taskInputExpressions}. See {@link
     * com.smartgwt.client.docs.TaskIO}.
     *
     * @return Current inputs value. Default value is null
     * @see com.smartgwt.client.docs.StatePath StatePath 
     * @see com.smartgwt.client.docs.StatePath StatePath 
     * @see com.smartgwt.client.docs.TaskIO Task Input / Output
     */
    public String getInputsAsString()  {
        return getAttributeAsString("inputs");
    }
    

    /**
     * Special expression to write task output directly into a {@link com.smartgwt.client.widgets.DataBoundComponent}. See
     * {@link com.smartgwt.client.docs.TaskIO}.
     *
     * @param outputExpression New outputExpression value. Default value is null
     * @return {@link com.smartgwt.client.util.workflow.Task Task} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.TaskIO Task Input / Output
     */
    public Task setOutputExpression(String outputExpression)  throws IllegalStateException {
        return (Task)setAttribute("outputExpression", outputExpression, false);
    }

    /**
     * Special expression to write task output directly into a {@link com.smartgwt.client.widgets.DataBoundComponent}. See
     * {@link com.smartgwt.client.docs.TaskIO}.
     *
     * @return Current outputExpression value. Default value is null
     * @see com.smartgwt.client.docs.TaskIO Task Input / Output
     */
    public String getOutputExpression()  {
        return getAttributeAsString("outputExpression");
    }
    

    /**
     * Field in the {@link com.smartgwt.client.util.workflow.Process#getState process state} where this task writes outputs.
     * See {@link com.smartgwt.client.docs.TaskIO}.
     *
     * @param outputField New outputField value. Default value is null
     * @return {@link com.smartgwt.client.util.workflow.Task Task} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.TaskIO Task Input / Output
     */
    public Task setOutputField(String outputField)  throws IllegalStateException {
        return (Task)setAttribute("outputField", outputField, false);
    }

    /**
     * Field in the {@link com.smartgwt.client.util.workflow.Process#getState process state} where this task writes outputs.
     * See {@link com.smartgwt.client.docs.TaskIO}.
     *
     * @return Current outputField value. Default value is null
     * @see com.smartgwt.client.docs.TaskIO Task Input / Output
     */
    public String getOutputField()  {
        return getAttributeAsString("outputField");
    }
    

    /**
     * List of multiple fields in the {@link com.smartgwt.client.util.workflow.Process#getState process state} where this task
     * will write outputs. See {@link com.smartgwt.client.docs.TaskIO}.   <P> If {@link
     * com.smartgwt.client.util.workflow.Task#getOutputField outputField} is also specified, it will be implicitly added to the
     * <code>outputFieldList</code> if it is not already present.
     *
     * @param outputFieldList New outputFieldList value. Default value is null
     * @return {@link com.smartgwt.client.util.workflow.Task Task} instance, for chaining setter calls
     * @throws IllegalStateException this property cannot be changed after the underlying component has been created
     * @see com.smartgwt.client.docs.TaskIO Task Input / Output
     */
    public Task setOutputFieldList(String... outputFieldList)  throws IllegalStateException {
        return (Task)setAttribute("outputFieldList", outputFieldList, false);
    }

    /**
     * List of multiple fields in the {@link com.smartgwt.client.util.workflow.Process#getState process state} where this task
     * will write outputs. See {@link com.smartgwt.client.docs.TaskIO}.   <P> If {@link
     * com.smartgwt.client.util.workflow.Task#getOutputField outputField} is also specified, it will be implicitly added to the
     * <code>outputFieldList</code> if it is not already present.
     *
     * @return Current outputFieldList value. Default value is null
     * @see com.smartgwt.client.docs.TaskIO Task Input / Output
     */
    public String[] getOutputFieldList()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfString(getAttributeAsJavaScriptObject("outputFieldList"));
    }
    

    /**
     * If set to true, the task will not allow any intermediate state to be set via {@link
     * com.smartgwt.client.util.workflow.Task#setState setState()} that is not explicitly defined first. This requirement can
     * be overridden by an optional value in the {@link com.smartgwt.client.util.workflow.Task#setState setState()} call. <p>
     * This setting can be applied to the entire process with {@link com.smartgwt.client.util.workflow.Process#getStrictPaths
     * Process.strictPaths}.
     *
     * @param strictPaths New strictPaths value. Default value is null
     * @return {@link com.smartgwt.client.util.workflow.Task Task} instance, for chaining setter calls
     */
    public Task setStrictPaths(Boolean strictPaths) {
        return (Task)setAttribute("strictPaths", strictPaths, true);
    }

    /**
     * If set to true, the task will not allow any intermediate state to be set via {@link
     * com.smartgwt.client.util.workflow.Task#setState setState()} that is not explicitly defined first. This requirement can
     * be overridden by an optional value in the {@link com.smartgwt.client.util.workflow.Task#setState setState()} call. <p>
     * This setting can be applied to the entire process with {@link com.smartgwt.client.util.workflow.Process#getStrictPaths
     * Process.strictPaths}.
     *
     * @return Current strictPaths value. Default value is null
     */
    public Boolean getStrictPaths()  {
        return getAttributeAsBoolean("strictPaths");
    }
    

    // ********************* Methods ***********************
	/**
     * Get the value of a {@link com.smartgwt.client.docs.TaskInputExpression inputExpression}.
     * @param value expression to evaluate
     *
     * @return value of expression
     * @see com.smartgwt.client.docs.TaskIO Task Input / Output
     */
    public native Object getExpressionValue(String value) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getExpressionValue", "String");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getExpressionValue(value);
        return $wnd.SmartGWT.convertToJavaType(ret);
    }-*/;

	/**
     * Get all inputs to the task as specified by the {@link com.smartgwt.client.util.workflow.Task#getInputs inputs}, as a
     * Record.
     *
     * @return input record
     * @see com.smartgwt.client.docs.TaskIO Task Input / Output
     */
    public native Record getInputRecord() /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getInputRecord", "");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getInputRecord();
        if(ret == null) return null;
        return @com.smartgwt.client.data.Record::getOrCreateRef(Lcom/google/gwt/core/client/JavaScriptObject;)(ret);
    }-*/;

	/**
     * Returns a value from the {@link com.smartgwt.client.util.workflow.Process#getState process state}. Values can be written
     * into the process state by {@link com.smartgwt.client.util.workflow.Task#setState setState()}, setting {@link
     * com.smartgwt.client.util.workflow.ProcessElement#getBindOutput ProcessElement.bindOutput}, or various task output
     * settings (See {@link com.smartgwt.client.docs.TaskIO}.)
     * @param statePath path to the value in the process state to set.                           Segments are separated by a decimal point (.)
     *
     * @return the value found at the path
     */
    public native Object getState(String statePath) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "getState", "String");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        var ret = self.getState(statePath);
        return $wnd.SmartGWT.convertToJavaType(ret);
    }-*/;

	/**
     * Sets the task output available to the next task via {@link com.smartgwt.client.util.workflow.Process#getLastTaskOutput
     * Process.getLastTaskOutput()} or more commonly, with a {@link com.smartgwt.client.docs.TaskInputExpression} property. If
     * {@link com.smartgwt.client.util.workflow.Task#getOutputFieldList outputFieldList} is specified, the output will also be
     * written to the specified fields in the process state (See {@link com.smartgwt.client.docs.TaskIO}). <p> To have the
     * output written as-is to the process state, see {@link com.smartgwt.client.util.workflow.ProcessElement#getBindOutput
     * bindOutput}.
     * @param output output record to provide to next task
     */
    public native void setOutput(Object output) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "setOutput", "Object");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.setOutput(output);
    }-*/;

	/**
     * Sets a {@link com.smartgwt.client.util.workflow.Process#getState process state} value for later reference with {@link
     * com.smartgwt.client.util.workflow.Process#getStateVariable Process.getStateVariable()} or more commonly with a {@link
     * com.smartgwt.client.docs.TaskInputExpression} property. <P> The path, which is one or more valid identifiers separated
     * by periods, is used to identify the variable. By appending an empty pair of brackets ([]) the value will be placed into
     * an existing or new array at the specified path.
     * @param stateVariablePath path to the variable in the process state to set.                                   segments are separated by a decimal
     * point (.)
     * @param value the value to save.
     * See {@link com.smartgwt.client.docs.TaskInputExpression TaskInputExpression}
     * @param strict if true, the path must exist in the state to be set. If false,                         the path will be created if it
     * does not exist. Defaults to                         <code>process.strictPaths</code> when null.
     */
    public native void setState(String stateVariablePath, String value, Boolean strict) /*-{
        if (this.@com.smartgwt.client.core.BaseClass::isConfigOnly()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPostConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(this.@java.lang.Object::getClass()(), "setState", "String,String,Boolean");
        }
        var self = this.@com.smartgwt.client.core.BaseClass::getOrCreateJsObj()();
        self.setState(stateVariablePath, value, strict == null ? null : strict.@java.lang.Boolean::booleanValue()());
    }-*/;


    // ********************* Static Methods ***********************

    // ***********************************************************

}
