/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.parserapplications.filterbuilder.wrappers;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.filters.StringFilter;
import org.htmlparser.parserapplications.filterbuilder.Filter;

public class StringFilterWrapper
extends Filter
implements ActionListener,
DocumentListener,
Runnable {
    protected StringFilter mFilter = new StringFilter();
    protected JTextArea mPattern;
    protected JCheckBox mCaseSensitivity;
    protected JComboBox mLocale;
    protected static Locale[] mLocales = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringFilterWrapper() {
        this.mFilter.setCaseSensitive(true);
        this.mPattern = new JTextArea(2, 20);
        this.mPattern.setBorder(new BevelBorder(1));
        this.add(this.mPattern);
        this.mPattern.getDocument().addDocumentListener(this);
        this.mPattern.setText(this.mFilter.getPattern());
        this.mCaseSensitivity = new JCheckBox("Case Sensitive");
        this.add(this.mCaseSensitivity);
        this.mCaseSensitivity.addActionListener(this);
        this.mCaseSensitivity.setSelected(this.mFilter.getCaseSensitive());
        this.mLocale = new JComboBox();
        JComboBox jComboBox = this.mLocale;
        synchronized (jComboBox) {
            this.mLocale.addItem(this.mFilter.getLocale().getDisplayName());
            Thread thread = new Thread(this);
            thread.setName("locale_getter");
            thread.setPriority(1);
            thread.run();
        }
        this.add(this.mLocale);
        this.mLocale.addActionListener(this);
        this.mLocale.setSelectedIndex(0);
        this.mLocale.setVisible(!this.mFilter.getCaseSensitive());
    }

    public String getDescription() {
        return "Nodes containing string";
    }

    public String getIconSpec() {
        return "images/StringFilter.gif";
    }

    public NodeFilter getNodeFilter() {
        StringFilter ret = new StringFilter();
        ret.setCaseSensitive(this.mFilter.getCaseSensitive());
        ret.setLocale(this.mFilter.getLocale());
        ret.setPattern(this.mFilter.getPattern());
        return ret;
    }

    public void setNodeFilter(NodeFilter filter, Parser context) {
        this.mFilter = (StringFilter)filter;
        this.mPattern.setText(this.mFilter.getPattern());
        this.mCaseSensitivity.setSelected(this.mFilter.getCaseSensitive());
        this.mLocale.setVisible(!this.mFilter.getCaseSensitive());
        this.mLocale.setSelectedItem(this.mFilter.getLocale().getDisplayName());
    }

    public NodeFilter[] getSubNodeFilters() {
        return new NodeFilter[0];
    }

    public void setSubNodeFilters(NodeFilter[] filters) {
    }

    public String toJavaCode(StringBuffer out, int[] context) {
        int n = context[1];
        context[1] = n + 1;
        String ret = "filter" + n;
        StringFilterWrapper.spaces(out, context[0]);
        out.append("StringFilter ");
        out.append(ret);
        out.append(" = new StringFilter ();");
        StringFilterWrapper.newline(out);
        StringFilterWrapper.spaces(out, context[0]);
        out.append(ret);
        out.append(".setCaseSensitive (");
        out.append(this.mFilter.getCaseSensitive() ? "true" : "false");
        out.append(");");
        StringFilterWrapper.newline(out);
        StringFilterWrapper.spaces(out, context[0]);
        out.append(ret);
        out.append(".setLocale (new java.util.Locale (\"");
        out.append(this.mFilter.getLocale().getLanguage());
        out.append("\", \"");
        out.append(this.mFilter.getLocale().getCountry());
        out.append("\", \"");
        out.append(this.mFilter.getLocale().getVariant());
        out.append("\"));");
        StringFilterWrapper.newline(out);
        StringFilterWrapper.spaces(out, context[0]);
        out.append(ret);
        out.append(".setPattern (\"");
        out.append(this.mFilter.getPattern());
        out.append("\");");
        StringFilterWrapper.newline(out);
        return ret;
    }

    public boolean accept(Node node) {
        return this.mFilter.accept(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.mCaseSensitivity) {
            boolean sensitive = this.mCaseSensitivity.isSelected();
            this.mFilter.setCaseSensitive(sensitive);
            this.mLocale.setVisible(!sensitive);
            this.mLocale.setSelectedItem(this.mFilter.getLocale().getDisplayName());
        } else if (source == this.mLocale) {
            JComboBox jComboBox = this.mLocale;
            synchronized (jComboBox) {
                Object[] selection = this.mLocale.getSelectedObjects();
                if (null != selection && 0 != selection.length) {
                    String locale = (String)selection[0];
                    for (int i = 0; i < mLocales.length; ++i) {
                        if (!locale.equals(mLocales[i].getDisplayName())) continue;
                        this.mFilter.setLocale(mLocales[i]);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        JComboBox jComboBox = this.mLocale;
        synchronized (jComboBox) {
            mLocales = Locale.getAvailableLocales();
            String locale = this.mFilter.getLocale().getDisplayName();
            for (int i = 0; i < mLocales.length; ++i) {
                if (locale.equals(mLocales[i].getDisplayName())) continue;
                this.mLocale.addItem(mLocales[i].getDisplayName());
            }
            this.mLocale.invalidate();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        Document doc = e.getDocument();
        try {
            this.mFilter.setPattern(doc.getText(0, doc.getLength()));
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    public void removeUpdate(DocumentEvent e) {
        Document doc = e.getDocument();
        try {
            this.mFilter.setPattern(doc.getText(0, doc.getLength()));
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }
}

