/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */

package com.smartgwt.sample.showcase.client.shuttles;

import java.util.ArrayList;
import java.util.List;

import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.data.DataSourceField;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.FieldType;
import com.smartgwt.client.types.MultiPickerSelectionStyle;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.form.SearchForm;
import com.smartgwt.client.widgets.form.fields.ButtonItem;
import com.smartgwt.client.widgets.form.fields.MultiPickerItem;
import com.smartgwt.client.widgets.form.fields.events.ClickEvent;
import com.smartgwt.client.widgets.form.fields.events.ClickHandler;
import com.smartgwt.client.widgets.grid.ListGridRecord;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class TreeMultiPickerSample extends ShowcasePanel {
    private static final String DESCRIPTION = 
        "The MultiPickerItem can be used to select values from a tree."+
        "<p>"+
        "This sample demonstrates using a MultiPickerItem to select employees from a "+
        "simple org-chart, with employees and organizational units (regions and offices) "+
        "represented in a hierarchical dataSource."+
        "<p>"+
        "Note that cascading selection is enabled, allowing the user to easily select all "+
        "the members of a specific office or region.";
        
    public static class Factory implements PanelFactory {

        private String id;

        public ShowcasePanel create() {
            TreeMultiPickerSample panel = new TreeMultiPickerSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }
    
    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {
        DataSource orgDS = new DataSource();
        orgDS.setClientOnly(true);
    	
        DataSourceField id = new DataSourceField();
        id.setHidden(true);
        id.setPrimaryKey(true);
        id.setName("id");
        DataSourceField name = new DataSourceField();
        name.setName("name");
        name.setTitle("Name");
        DataSourceField email = new DataSourceField();
        email.setName("email");
        DataSourceField parentId = new DataSourceField();
        parentId.setHidden(true);
        parentId.setForeignKey("id");
        parentId.setName("parentId");
        DataSourceField isFolder = new DataSourceField();
        isFolder.setName("isFolder");
        isFolder.setHidden(true);
        isFolder.setType(FieldType.BOOLEAN);
    	
        orgDS.setFields(id,name,email,parentId,isFolder);
        orgDS.setCacheData(getRecords());
    	
        SearchForm searchForm = new SearchForm();
        searchForm.setDataSource(orgDS);
        searchForm.setLayoutAlign(Alignment.CENTER);
        searchForm.setWidth100();
        searchForm.setHeight100();
    	
        MultiPickerItem nameItem = new MultiPickerItem();
        nameItem.setName("name");
        nameItem.setShowTitle(false);
        nameItem.setSelectionStyle(MultiPickerSelectionStyle.PICKTREE);
        nameItem.setIncludeSelectedParents(false);
        nameItem.setEmptyDisplayValue("Select Team Members");
    	
        ButtonItem buttonItem = new ButtonItem();
        buttonItem.setTitle("Show Current Team Members");
        buttonItem.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                Object obj = ((MultiPickerItem)searchForm.getField("name")).getValue();
                ArrayList team = new ArrayList<>((List<String>) obj);
                if (team == null || team.size() == 0) {
                    SC.say("Team is empty");
                } else {
                    String notificationString = "Current team members:<ul>";
                    for (int i=0; i<team.size(); i++) {
                        notificationString += "<li>" + (String)team.get(i) + "</li>";
                    }
                    notificationString += "</ul>";
                    SC.say(notificationString);
                }
            }
        });
    	
        searchForm.setFields(nameItem, buttonItem);
        
        return searchForm;
    }
    
    private Record[] getRecords() {
        return new ListGridRecord[]{  
            createRecord(84425, "Europe", null, 0, true),    
            createRecord(31655, "North America", null, 0, true),
            createRecord(64545, "Asia", null, 0, true),
            createRecord(10936, "London Office", null, 84425, true),
            createRecord(35586, "Berlin Office", null, 84425, true),
            createRecord(74957, "New York Office", null, 31655, true),
            createRecord(34331, "San Francisco Office", null, 31655, true),
            createRecord(70618, "Tokyo Office", null, 64545, true),
            createRecord(69651, "Singapore Office", null, 64545, true),
            createRecord(65782, "Edward Price", "edward.price@server.com", 10936, false),
            createRecord(15636, "Alice Carter", "alice.carter@server.com", 10936, false),
            createRecord(27212, "Hannah Wagner", "hannah.wagner@server.com", 35586, false),
            createRecord(19734, "Sophia Schmidt", "sophia.schmidt@server.com", 35586, false),
            createRecord(77608, "John Denault", "john.denault@server.com", 74957, false),
            createRecord(43802, "Emily Davis", "emily.davis@server.com", 74957, false),    
            createRecord(24594, "Michael Brown", "michael.brown@server.com", 34331, false),    
            createRecord(63423, "Sarah Johnson", "sarah.johnson@server.com", 34331, false),    
            createRecord(80834, "Hiroshi Tanaka", "hiroshi.tanaka@server.com", 70618, false),    
            createRecord(67917, "Yuki Yamamoto", "yuki.yamamoto@server.com", 70618, false),    
            createRecord(54462, "Wei Zhang", "wei.zhang@server.com", 69651, false),    
            createRecord(42164, "Amara Patel", "amara.patel@server.com", 69651, false)
        };  
    }
    
    private ListGridRecord createRecord(int id, String name, String email, int parentId, boolean isFolder) {
        ListGridRecord record = new ListGridRecord();  
        record.setAttribute("id", id);  
        record.setAttribute("name", name);  
        record.setAttribute("email", email);  
        record.setAttribute("parentId", parentId);  
        record.setAttribute("isFolder", isFolder);  
        return record;
    }

    public String getIntro() {
        return DESCRIPTION;
    }

}
