/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.webdriver;

import com.isomorphic.webdriver.SeleneseTestCaseParser;
import com.isomorphic.webdriver.SmartClientChromeDriver;
import com.isomorphic.webdriver.SmartClientFirefoxDriver;
import com.isomorphic.webdriver.SmartClientIEDriver;
import com.isomorphic.webdriver.SmartClientWebDriver;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedList;
import org.htmlparser.Parser;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;

public class SeleneseRunner {
    private static String browserDriver = "firefox";

    public static void main(String[] args) throws ParserException, IOException {
        boolean allPassed = true;
        boolean quiet = false;
        boolean debug = false;
        String baseUrl = null;
        LinkedList<String> testFiles = new LinkedList<String>();
        PrintStream sourceOut = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-ff".equals(arg) || "-firefox".equals(arg)) {
                browserDriver = "firefox";
                continue;
            }
            if ("-ie".equals(arg) || "-internetexplorer".equals(arg)) {
                browserDriver = "ie";
                continue;
            }
            if ("-ch".equals(arg) || "-chrome".equals(arg)) {
                browserDriver = "chrome";
                continue;
            }
            if ("-d".equals(arg) || "-debug".equals(arg)) {
                debug = true;
                continue;
            }
            if ("-q".equals(arg) || "-quiet".equals(arg)) {
                quiet = true;
                continue;
            }
            if ("-s".equals(arg)) {
                arg = args[++i];
                if (i >= args.length) {
                    SeleneseRunner.usageError();
                    continue;
                }
                if ("-".equals(arg)) {
                    sourceOut = System.out;
                    continue;
                }
                sourceOut = new PrintStream(arg);
                continue;
            }
            testFiles.add(arg);
        }
        if (testFiles.size() < 2) {
            SeleneseRunner.usageError();
        } else {
            baseUrl = (String)testFiles.remove(0);
            if (!quiet) {
                System.out.println("baseUrl: " + baseUrl);
            }
        }
        for (String fileName : testFiles) {
            String line;
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(fileName));
            }
            catch (FileNotFoundException e) {
                System.err.println("File not found: " + fileName + "\n");
                SeleneseRunner.usageError();
            }
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            reader.close();
            if (sourceOut != null) {
                sourceOut.println("@Test\npublic void " + SeleneseRunner.getTestName(fileName) + "() {");
            }
            boolean passed = SeleneseRunner.parseEntry(baseUrl, builder.toString(), sourceOut, debug);
            if (!quiet) {
                System.out.println(fileName + ": " + (passed ? "Pass" : "Fail"));
            }
            if (sourceOut != null) {
                sourceOut.println("}\n");
            }
            allPassed &= passed;
        }
        System.exit(allPassed ? 0 : -1);
    }

    private static String getTestName(String fileName) {
        int indexOf = fileName.indexOf(".rctest.html");
        if (indexOf < 0) {
            SeleneseRunner.usageError();
        }
        String baseName = fileName.substring(0, indexOf);
        return baseName.replace("-", "_");
    }

    private static void usageError() {
        System.err.println("Usage: [-ff|-ie|-ch] [-d | -debug] [-q | -quiet] [-s <sourceFile>] <baseUrl> <testFile>...");
        System.err.println(" -ff | -ie | -ch to specify the browser to be used. Default is FireFox");
        System.err.println(" -d | -debug outputs actions being executed and inserts a 5 second delay between each");
        System.err.println(" -q | -quiet means that results are not reported. Exit status of 0 implies all successful");
        System.err.println(" -s <sourceFile> : approximate java code for JUnit type testing is produced");
        System.err.println(" test files must adhere to the standard naming pattern [Test Name].rctest.html");
        System.exit(1);
    }

    private static boolean parseEntry(String baseUrl, String content, PrintStream sourceOut, boolean debug) throws ParserException {
        SmartClientWebDriver driver = null;
        driver = browserDriver.equals("ie") ? new SmartClientIEDriver() : (browserDriver.equals("chrome") ? new SmartClientChromeDriver() : new SmartClientFirefoxDriver());
        driver.setBaseUrl(baseUrl);
        SeleneseTestCaseParser visitor = new SeleneseTestCaseParser(driver, sourceOut, debug);
        Parser parser = new Parser(new Lexer(new Page(content, "UTF-8")));
        parser.visitAllNodesWith((NodeVisitor)visitor);
        boolean result = visitor.getResult();
        driver.close();
        driver.quit();
        return result;
    }

    public static boolean executeSelenese(String baseUrl, String content) throws ParserException {
        return SeleneseRunner.parseEntry(baseUrl, content, null, false);
    }

    public static final class Entry {
        protected String description;
        protected int count;
        protected String title;
    }
}

