/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VirtualDataSource
extends DataSource {
    private static Logger log = new Logger(VirtualDataSource.class.getName());
    protected DataSource primaryDataSource = null;
    protected Map primaryConfig = null;
    protected Map dataSources = null;
    protected Map dsConfigs = null;
    protected Map joinDepends = null;
    protected Map fieldToDSMap = null;
    protected Map virtual2MemberMap = null;
    protected DataSource lastAccessedDS = null;

    public void init(Map config) throws Exception {
        super.init(config, null);
        this.dataSources = new HashMap();
        this.dsConfigs = new HashMap();
        this.fieldToDSMap = new HashMap();
        this.joinDepends = new HashMap();
        this.virtual2MemberMap = new HashMap();
        this.initialize();
    }

    protected void initialize() throws Exception {
        Map memberDSConfigs = (Map)this.dsConfig.get("sources");
        for (String memberDSName : memberDSConfigs.keySet()) {
            Map virtualFields;
            Map joinOn;
            Map memberDSConfig = (Map)memberDSConfigs.get(memberDSName);
            DataSource memberDS = (DataSource)this.dataSources.get(memberDSName);
            if (memberDS == null) {
                memberDS = DataSourceManager.getUnpooledDataSource(memberDSName);
            }
            this.dataSources.put(memberDSName, memberDS);
            this.dsConfigs.put(memberDSName, memberDSConfig);
            if (memberDSConfig.get("isPrimary") != null && memberDSConfig.get("isPrimary").equals("true")) {
                if (this.primaryConfig != null) {
                    throw new Exception("Multiple primary Datasources declared for virtual dataSource " + memberDSName);
                }
                this.primaryConfig = memberDSConfig;
                this.primaryDataSource = memberDS;
            }
            if ((joinOn = (Map)memberDSConfig.get("joinOn")) != null) {
                Perl5Util regex = new Perl5Util();
                for (String foreignColName : joinOn.keySet()) {
                    HashMap joinCols;
                    String depColName = (String)joinOn.get(foreignColName);
                    regex.match("m/(\\S+)\\.(.+)/", foreignColName);
                    String foreignDSName = regex.group(1);
                    foreignColName = regex.group(2);
                    DataSource foreignDS = (DataSource)this.dataSources.get(foreignDSName);
                    if (foreignDS == null) {
                        foreignDS = DataSourceManager.getUnpooledDataSource(foreignDSName);
                    }
                    this.dataSources.put(foreignDSName, foreignDS);
                    HashMap joinMap = (HashMap)this.joinDepends.get(foreignDS);
                    if (joinMap == null) {
                        joinMap = new HashMap();
                        this.joinDepends.put(foreignDS, joinMap);
                    }
                    if ((joinCols = (HashMap)joinMap.get(foreignColName)) == null) {
                        joinCols = new HashMap();
                        joinMap.put(foreignColName, joinCols);
                    }
                    HashMap<String, String> fieldMapping = new HashMap<String, String>();
                    fieldMapping.put(foreignColName, depColName);
                    joinCols.put(memberDS, fieldMapping);
                }
            }
            if ((virtualFields = (Map)memberDSConfig.get("fields")) == null) {
                throw new Exception("In virtual DS config, no field list defined for member dataSource '" + memberDSName + "'");
            }
            for (String virtualFieldName : virtualFields.keySet()) {
                DSField memberFieldDef;
                this.fieldList.add(virtualFieldName);
                this.fieldToDSMap.put(virtualFieldName, memberDS);
                String memberFieldName = (String)virtualFields.get(virtualFieldName);
                if (memberFieldName.equals("*")) {
                    memberFieldName = virtualFieldName;
                }
                if ((memberFieldDef = memberDS.getField(memberFieldName)) == null) {
                    throw new Exception("In virtual dataSource '" + this.getName() + "', virtual field '" + virtualFieldName + "' maps to member field '" + memberFieldName + "' from member dataSource '" + memberDSName + "', but no such field exists in the member datasource");
                }
                this.virtual2MemberMap.put(virtualFieldName, memberFieldName);
            }
        }
    }

    public BasicDataSource getDataSource(String name) {
        return (BasicDataSource)this.dataSources.get("name");
    }

    public BasicDataSource getPrimaryDataSource() {
        return (BasicDataSource)this.primaryDataSource;
    }

    public List getPrimaryKeys() {
        return new ArrayList();
    }

    protected Map splitQueryHash(Map toSplit) throws Exception {
        HashMap result = new HashMap();
        Map subsetFields = DataTools.mapIntersection(toSplit, this.virtual2MemberMap);
        for (String fieldName : subsetFields.keySet()) {
            DataSource targetDS = (DataSource)this.fieldToDSMap.get(fieldName);
            Map dsFields = (HashMap)result.get(targetDS);
            if (dsFields == null) {
                dsFields = new HashMap();
                result.put(targetDS, dsFields);
            }
            dsFields.put(fieldName, subsetFields.get(fieldName));
            Map joinMap = (Map)this.joinDepends.get(targetDS);
            if (joinMap == null) continue;
            log.debug("datasource " + targetDS.getName() + " has join dependencies ");
            Map joinCols = (Map)joinMap.get(fieldName);
            if (joinCols == null) continue;
            log.debug("processing joinCols for datasource: " + targetDS.getName());
            for (DataSource depDataSource : joinCols.keySet()) {
                Map fieldMapping = (Map)joinCols.get(depDataSource);
                String depColName = (String)fieldMapping.get(fieldName);
                dsFields = (Map)result.get(depDataSource);
                if (dsFields == null) {
                    dsFields = new HashMap();
                    result.put(depDataSource, dsFields);
                }
                dsFields.put(depColName, subsetFields.get(fieldName));
            }
        }
        return result;
    }

    protected void mergeQueryResult(Map result, Map split) {
        for (DataSource ds : split.keySet()) {
            Object dsValue = split.get(ds);
            if (result.get(ds) == null) {
                result.put(ds, dsValue);
                continue;
            }
            Object myValue = result.get(ds);
            if (myValue instanceof List) {
                ((List)myValue).add(dsValue);
                continue;
            }
            ArrayList myNewValue = new ArrayList();
            myNewValue.add(myValue);
            myNewValue.add(dsValue);
            result.put(ds, myNewValue);
        }
    }

    protected Map splitQuery(Object data) throws Exception {
        if (data == null) {
            return null;
        }
        HashMap<DataSource, Object> result = new HashMap<DataSource, Object>();
        if (data instanceof String) {
            result.put(this.primaryDataSource, data);
        } else if (data instanceof Map) {
            Map filteredData = this.splitQueryHash((Map)data);
            for (Object key : filteredData.keySet()) {
                result.put((DataSource)key, filteredData.get(key));
            }
        } else if (data instanceof List) {
            Iterator e = ((List)data).iterator();
            while (e.hasNext()) {
                Map mySplit = this.splitQuery(e.next());
                this.mergeQueryResult(result, mySplit);
            }
        } else {
            throw new Exception("type " + data.getClass().getName() + " not supported");
        }
        return result;
    }

    public DSResponse executeFetch(DSRequest req) throws Exception {
        DSResponse result = new DSResponse(this);
        Map selectTargets = this.splitQuery(req.getRawCriteria());
        if (selectTargets.size() == 1) {
            DataSource target = (DataSource)DataTools.getSingle(selectTargets);
            result.setData(target.select(selectTargets.get(target)));
            return result;
        }
        throw new Exception("this request requires a join - joins are not yet supported.");
    }

    public DSResponse executeRemove(DSRequest req) throws Exception {
        DSResponse result = new DSResponse(this);
        Map targets = this.splitQuery(req.getRawCriteria());
        if (targets == null) {
            throw new Exception("no constraints on virtual delete - ignoring");
        }
        if (targets.size() == 1) {
            DataSource target;
            this.lastAccessedDS = target = (DataSource)DataTools.getSingle(targets);
            result.setAffectedRows(target.delete(targets.get(target)));
            return result;
        }
        throw new Exception("virtual delete spans multiple dataSources - ignoring");
    }

    public DSResponse executeAdd(DSRequest req) throws Exception {
        DSResponse result = new DSResponse(this);
        long total = 0L;
        Map targets = this.splitQuery(req.getRawValues());
        if (targets == null) {
            throw new Exception("No data passed in on virtual insert");
        }
        for (DataSource targetDS : targets.keySet()) {
            log.debug("calling insert on dataSource: " + targetDS.getName() + " with args: " + targets.get(targetDS).toString());
            total = targetDS.insert(targets.get(targetDS));
            this.lastAccessedDS = targetDS;
        }
        result.setAffectedRows(total);
        return result;
    }

    public DSResponse executeReplace(DSRequest req) throws Exception {
        throw new Exception("Operation 'replace' is not supported on virtual dataSources.");
    }

    public DSResponse executeUpdate(DSRequest req) throws Exception {
        throw new Exception("Operation 'update' is not supported on virtual dataSources.");
    }

    public void clearState() {
        this.lastAccessedDS = null;
    }

    public Object getLastRow() throws Exception {
        if (this.lastAccessedDS == null) {
            log.error("getLastRow() called before any update/replace/insert operations have been performed");
            return null;
        }
        return this.lastAccessedDS.getLastRow();
    }

    public Map getLastPrimaryKeys() throws Exception {
        if (this.lastAccessedDS == null) {
            log.error("getLastPrimaryKeys() called before any update/replace/insert operations have been performed");
            return null;
        }
        return this.lastAccessedDS.getLastPrimaryKeys();
    }

    protected boolean isValidSubclass() {
        return true;
    }
}

