/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.naming;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.naming.JNDISearchResult;
import com.isomorphic.util.DataTools;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class JNDI
extends Base {
    private static Logger log = new Logger(JNDI.class.getName());
    private static int defaultMaxDepth = config.getInteger((Object)"JNDI.searchTreeForClass.maxDepth", 50);

    public static Context bindConfiguredContext(String contextId) throws Exception {
        Context ctx;
        if (contextId == null) {
            return null;
        }
        Config env = null;
        if (!contextId.equals("none")) {
            env = config.getSubtree("jndi." + contextId);
        }
        if (env == null || env.size() == 0) {
            log.debug("No configuration for JNDI context '" + contextId + "' - assuming default initialContext");
        } else {
            log.debug("passing the following environment to JNDI: " + DataTools.prettyPrint((Object)env));
        }
        if (env == null) {
            env = new Config();
        }
        if (contextId.equals("_container_")) {
            log.debug("Detected container context, using new InitialContext(env) lookup method");
            ctx = new InitialContext(new Hashtable(env));
            try {
                ctx = (Context)ctx.lookup("java:comp/env");
            }
            catch (Exception e) {
                ctx = new InitialContext();
            }
        } else {
            ctx = new InitialContext(new Hashtable(env));
        }
        return ctx;
    }

    public static List searchTreeForClass(String contextRoot, Class clazz) throws NamingException {
        return JNDI.searchTreeForClass(contextRoot, clazz, defaultMaxDepth);
    }

    public static List searchTreeForClass(String contextRoot, Class clazz, int maxDepth) throws NamingException {
        InitialContext ic = new InitialContext();
        Context ctx = null;
        try {
            ctx = (Context)ic.lookup(contextRoot);
        }
        catch (NullPointerException npe) {
            log.warn("Unable to lookup context: " + contextRoot + " container threw a NullPointerException");
            return new ArrayList();
        }
        List results = JNDI.searchTreeForClass(ctx, contextRoot, clazz);
        try {
            if (ctx != null) {
                ctx.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (ic != null) {
                ic.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return results;
    }

    public static List searchTreeForClass(Context context, String accumulatedPath, Class clazz) throws NamingException {
        return JNDI.searchTreeForClass(context, accumulatedPath, clazz, defaultMaxDepth);
    }

    public static List searchTreeForClass(Context context, String accumulatedPath, Class clazz, int maxDepth) throws NamingException {
        return JNDI._searchTreeForClass(context, accumulatedPath, clazz, maxDepth, 0);
    }

    private static List _searchTreeForClass(Context context, String accumulatedPath, Class clazz, int maxDepth, int depth) throws NamingException {
        ArrayList<JNDISearchResult> results = new ArrayList<JNDISearchResult>();
        log.info("searchTreeForClass - accumulatedPath: -->" + accumulatedPath + "<--");
        if (depth > maxDepth - 1) {
            if (log.isDebugEnabled()) {
                log.debug("Searching reached maxDepth: " + maxDepth + ". Aborting searching this subtree. " + "You can change maxDepth parameter by JNDI API or by editing framework setting " + "'JNDI.searchTreeForClass.maxDepth' in server.properties file.");
            }
            return results;
        }
        NamingEnumeration<NameClassPair> ne = null;
        try {
            log.info("Listing: " + accumulatedPath);
            ne = context.list("");
        }
        catch (NamingException nex) {
            log.warn("Unable to list context: " + accumulatedPath + " - exception: " + nex.getMessage());
            return results;
        }
        catch (NullPointerException npe) {
            log.warn("Unable to list context: " + accumulatedPath + " container threw a NullPointerException");
            return results;
        }
        while (ne.hasMore()) {
            NameClassPair o = ne.next();
            if (!(o instanceof NameClassPair)) continue;
            NameClassPair ncp = o;
            String name = ncp.getName();
            String className = ncp.getClassName();
            log.debug("got NameClassPair with name: " + ncp.getName() + ", class: '" + ncp.getClassName() + "'");
            Object obj = null;
            try {
                obj = context.lookup(name);
            }
            catch (NamingException nex) {
                log.debug("NamingException looking up name: " + name + ", ignoring");
                continue;
            }
            if (obj == null) {
                log.debug("Null value for name: " + name + ", ignoring");
                continue;
            }
            if (clazz.isAssignableFrom(obj.getClass())) {
                results.add(new JNDISearchResult(accumulatedPath, name, context.composeName(name, accumulatedPath), className, obj));
            }
            if (!Context.class.isAssignableFrom(obj.getClass()) || name == null || "".equals(name)) continue;
            log.debug("recursing into: " + accumulatedPath + " -> " + name);
            DataTools.addAll(results, JNDI._searchTreeForClass((Context)obj, context.composeName(name, accumulatedPath), clazz, maxDepth, depth + 1));
            ((Context)obj).close();
        }
        return results;
    }

    public static synchronized Context createSubcontextPath(String path, boolean omitLast) throws NamingException {
        return JNDI.createSubcontextPath(new InitialContext(), path, omitLast);
    }

    public static synchronized Context createSubcontextPath(Context ctx, String path, boolean omitLast) throws NamingException {
        if (path == null || "".equals(path)) {
            return ctx;
        }
        if ((path = ISCFile.canonicalizePath(path)).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        List pathComponents = DataTools.simpleSplit(path, "/");
        String pathAccumulator = "";
        while (pathComponents.size() > (omitLast ? 1 : 0)) {
            String nextPathComponent = (String)pathComponents.get(0);
            pathComponents.remove(0);
            if ("".equals(nextPathComponent) || nextPathComponent == null) continue;
            pathAccumulator = pathAccumulator + ("".equals(pathAccumulator) ? "" : "/") + nextPathComponent;
            boolean havePath = false;
            try {
                havePath = ctx.lookup(pathAccumulator) != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (havePath) continue;
            ctx.createSubcontext(pathAccumulator);
        }
        return ctx;
    }
}

