/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.UpdateWithoutPKException;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.rpc.ClientMustResubmitException;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.RPCRequest;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.RequestTimer;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.util.DataTools;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;

public class IDACall
extends BaseServlet {
    protected static final String STACKTRACE_ON_FAILURE = "stacktraceOnFailure";

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this._processRequest(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this._processRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestTimer requestTimer = new RequestTimer(request);
        String encoding = this.getServletConfig().getInitParameter("encoding");
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if (!encoding.toLowerCase().equals("none")) {
            request.setCharacterEncoding(encoding);
        }
        if (this.log.isDebugEnabled()) {
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                String headerValue = request.getHeader(headerName);
                this.log.debug("Header Name:Value pair: " + headerName + ":" + headerValue);
                if (!"authorization".equals(headerName)) continue;
                String encodedValue = headerValue.split(" ")[1];
                String decodedValue = new String(Base64.decodeBase64((byte[])encodedValue.getBytes()));
                this.log.debug("Base64-decoded Authorization Value: " + decodedValue);
            }
            HttpSession ses = request.getSession(false);
            this.log.debug("session exists: " + (ses == null ? "null" : ses.getId()));
            this.log.debug("remote user: " + request.getRemoteUser());
        }
        try {
            this.processRequest(request, response);
            Object var11_10 = null;
            requestTimer.stop();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            requestTimer.stop();
            try {
                response.flushBuffer();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            response.flushBuffer();
        }
        catch (IOException iOException) {}
    }

    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RPCManager rpc = null;
        try {
            RequestContext context = RequestContext.instance((Servlet)this, request, response);
            try {
                rpc = new RPCManager((Servlet)this, request, response);
            }
            catch (ClientMustResubmitException cmre) {
                return;
            }
            this.processRPCTransaction(rpc, context);
        }
        catch (Throwable e) {
            this.handleError(response, e);
        }
    }

    public void processRPCTransaction(RPCManager rpc, RequestContext context) throws Exception {
        this.log.info("Performing " + rpc.requestCount() + " operation(s) [UA: " + context.request.getHeader("User-Agent") + "]");
        for (Object r : rpc.getRequests()) {
            if (r instanceof RPCRequest) {
                RPCRequest rpcRequest = (RPCRequest)r;
                rpc.send(rpcRequest, this.handleRPCRequest(rpcRequest, rpc, context));
                continue;
            }
            DSRequest dsRequest = (DSRequest)r;
            rpc.send(dsRequest, this.handleDSRequest(dsRequest, rpc, context));
        }
    }

    public DSResponse handleDSRequest(DSRequest dsRequest, RPCManager rpc, RequestContext context) throws Exception {
        try {
            DataSource dataSource = dsRequest.getDataSource();
            if (dataSource != null && dataSource.isServerOnly()) {
                return new DSResponse(dataSource, DSResponse.STATUS_FAILURE);
            }
            return dsRequest.execute();
        }
        catch (Throwable t) {
            return this.handleDSRequestError(dsRequest, rpc, context, t);
        }
    }

    public DSResponse handleDSRequestError(DSRequest dsRequest, RPCManager rpc, RequestContext context, Throwable t) {
        return IDACall._handleDSRequestError(dsRequest, rpc, context, t);
    }

    public static DSResponse _handleDSRequestError(DSRequest dsRequest, RPCManager rpc, RequestContext context, Throwable t) {
        boolean trace;
        Throwable t1 = t;
        String errorToString = t1.toString();
        StackTraceElement[] stack = t1.getStackTrace();
        Throwable t2 = t1.fillInStackTrace();
        t1.setStackTrace(stack);
        if (errorToString != null && !errorToString.equals("") && t2 != null) {
            RequestContext.staticLog.warn((Object)"dsRequest.execute() failed: ", t1);
        } else {
            t1.setStackTrace(stack);
            RequestContext.staticLog.warn((Object)("dsRequest.execute() failed: " + t1.getClass().getName() + ": " + t1.getMessage() + " (The original exception may be missing information)"), t1);
        }
        DSResponse dsResponse = null;
        try {
            dsResponse = new DSResponse(dsRequest == null ? (DataSource)null : dsRequest.getDataSource());
        }
        catch (Exception e) {
            RequestContext.staticLog.warn((Object)"Got Exception trying to instantiate error DSResponse - going to try without the DataSource reference", e);
            dsResponse = new DSResponse();
        }
        if (t1 instanceof UpdateWithoutPKException) {
            dsResponse.setStatus(-9);
        } else {
            dsResponse.setStatus(DSResponse.STATUS_FAILURE);
        }
        dsResponse.setData(t1.getLocalizedMessage());
        if (t instanceof NoClassDefFoundError && t.getMessage().indexOf("org/hibernate") != -1) {
            dsResponse.setData("Hibernate .jars do not appear to be installed. Please see the Setup Guide and Deployment Instructions");
        }
        if (trace = IDACall.shouldReturnStacktrace(context)) {
            dsResponse.setParameter("stacktrace", DataTools.getStackTrace(t1));
        }
        return dsResponse;
    }

    public RPCResponse handleRPCRequest(RPCRequest rpcRequest, RPCManager rpc, RequestContext context) throws Exception {
        try {
            return rpcRequest.execute();
        }
        catch (Throwable t) {
            return this.handleRPCRequestError(rpcRequest, rpc, context, t);
        }
    }

    public RPCResponse handleRPCRequestError(RPCRequest rpcRequest, RPCManager rpc, RequestContext context, Throwable t) {
        RequestContext.staticLog.warn((Object)"rpcRequest.execute() failed: ", t);
        RPCResponse rpcResponse = new RPCResponse();
        rpcResponse.setStatus(RPCResponse.STATUS_FAILURE);
        rpcResponse.setData(t.getLocalizedMessage());
        if (IDACall.shouldReturnStacktrace(context)) {
            rpcResponse.setStacktrace(DataTools.getStackTrace(t));
        }
        return rpcResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean shouldReturnStacktrace(RequestContext context) {
        boolean trace = false;
        try {
            Map queryParamsMap = ServletTools.parseQueryString(context.request.getQueryString());
            Boolean urlTrace = DataTools.asBooleanObject(queryParamsMap.get(STACKTRACE_ON_FAILURE));
            if (urlTrace == null) {
                urlTrace = DataTools.asBooleanObject(context.request.getParameter(STACKTRACE_ON_FAILURE));
            }
            if (config.getBoolean((Object)"allow.return.stacktrace", false)) {
                trace = urlTrace != null ? urlTrace.booleanValue() : config.getBoolean((Object)"exception.returns.stacktrace", false);
            }
            boolean bl = trace;
            Object var6_6 = null;
            return trace;
        }
        catch (Exception e) {
            try {
                RequestContext.staticLog.warn((Object)"Exception when trying to determine whether to return a stacktrace", e);
                Object var6_7 = null;
                return trace;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                return trace;
            }
        }
    }
}

