/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.base.ReflectionArgument;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.datasource.Validator;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.Scripting;
import com.isomorphic.rpc.ServerObject;
import com.isomorphic.scripting.IScript;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ErrorMessage;
import com.isomorphic.util.ErrorReport;
import com.isomorphic.util.LocaleMessage;
import com.isomorphic.util.ValidatorException;
import com.isomorphic.velocity.Velocity;
import com.isomorphic.xml.XML;
import isc.org.apache.oro.text.perl.Perl5Util;
import isc.org.apache.oro.text.regex.MalformedPatternException;
import isc.org.apache.oro.text.regex.Perl5Compiler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class DefaultValidators
extends Base {
    private static Logger log = new Logger(DefaultValidators.class.getName());
    private Map validators;
    private static final Map validatorFunctions = Collections.synchronizedMap(new HashMap());
    private static final List clientOnlyValidators = DataTools.makeList("requiredIf");
    static final Map defaultValidators = new HashMap();

    public DefaultValidators(Map theValidators) {
        this.validators = theValidators;
    }

    public static void addValidator(String type, Method method) {
        validatorFunctions.put(type, method);
    }

    public List validateRecords(List records) throws ValidatorException {
        ArrayList<ErrorReport> results = new ArrayList<ErrorReport>();
        Iterator e = records.iterator();
        while (e.hasNext()) {
            ErrorReport errors = this.validateRecord((Map)e.next());
            if (errors == null) continue;
            results.add(errors);
        }
        return results.isEmpty() ? null : results;
    }

    public ErrorReport validateRecord(Map record) throws ValidatorException {
        ErrorReport report = new ErrorReport();
        for (String fieldName : this.validators.keySet()) {
            Object rawFieldValidators = this.validators.get(fieldName);
            if (rawFieldValidators == null) continue;
            List fieldValidators = DataTools.makeListIfSingle(rawFieldValidators);
            DefaultValidators.validateField(record, fieldName, fieldValidators, null, report);
        }
        return report.isEmpty() ? null : report;
    }

    public static ErrorReport validateField(Map record, String fieldName, List fieldValidators) throws ValidatorException {
        return DefaultValidators.validateField(record, fieldName, fieldValidators, null);
    }

    public static ErrorReport validateField(Map record, String fieldName, List fieldValidators, ValidationContext context) throws ValidatorException {
        return DefaultValidators.validateField(record, fieldName, fieldValidators, context, null);
    }

    public static ErrorReport validateField(Map record, String fieldName, List fieldValidators, ValidationContext context, ErrorReport report) throws ValidatorException {
        Object value = record.get(fieldName);
        return DefaultValidators.validateField(record, fieldName, fieldValidators, context, report, value);
    }

    public static ErrorReport validateField(Map record, String fieldName, List fieldValidators, ValidationContext context, ErrorReport report, Object value) throws ValidatorException {
        boolean contextWasNull = false;
        if (context == null) {
            context = new ValidationContext();
            contextWasNull = true;
        }
        context.clearResultingValue();
        DataSource dataSource = context.getCurrentDataSource();
        context.setResultingValue(value);
        for (Object fieldValidator : fieldValidators) {
            ErrorMessage error;
            String type;
            Validator valParams = null;
            boolean stopIfFalse = false;
            if (fieldValidator instanceof String) {
                type = (String)fieldValidator;
                valParams = new Validator();
            } else {
                Map valParamsMap = (Map)fieldValidator;
                valParams = new Validator(valParamsMap);
                type = valParams.getType();
                stopIfFalse = valParams.isStopIfFalse();
            }
            Object rawCondition = valParams.get("applyWhen");
            if (rawCondition != null) {
                if (!(rawCondition instanceof Map)) {
                    log.warn("on field: '" + fieldName + "' for validator type '" + type + "', bad 'applyWhen' ignored: " + DataTools.prettyPrint(rawCondition));
                    continue;
                }
                Map condition = (Map)rawCondition;
                if (log.isDebugEnabled()) {
                    log.debug("on field: '" + fieldName + "' for validator type '" + type + "', 'applyWhen' is:\n" + DataTools.prettyPrint(condition) + "\nrecord is:\n" + DataTools.prettyPrint(record));
                }
                boolean result = false;
                try {
                    result = context.getCurrentDataSource().matchesCriteria(record, condition);
                }
                catch (Exception e) {
                    log.warn("on field: '" + fieldName + "' for validate type '" + type + "' evaluation of 'applyWhen' " + "threw exception, ignoring validator.\n" + DataTools.getStackTrace(e));
                    continue;
                }
                if (log.isInfoEnabled()) {
                    log.info("on field: '" + fieldName + "' conditional validator of type '" + type + "' is: " + (result ? "active" : "inactive"));
                }
                if (!result) continue;
            }
            if (context != null) {
                context.addToTemplateContext("validator", new Validator((Map)valParams));
                context.addToTemplateContext("record", record);
                context.addToTemplateContext("value", value);
                context.addToTemplateContext("dataSource", dataSource);
                context.addToTemplateContext(Velocity.getServletContextMap(context.getRPCManager()));
            }
            if ((error = DefaultValidators.processValidator(type, value, fieldName, record, valParams, context)) != null) {
                if (report == null) {
                    report = new ErrorReport();
                }
                report.addError(fieldName, error);
                if (!stopIfFalse) continue;
                break;
            }
            value = context.getResultingValue();
        }
        if (contextWasNull) {
            context.freeResources();
        }
        return report;
    }

    private static ErrorMessage processValidator(String validatorName, Object value, String fieldName, Map record, Validator validator, ValidationContext context) throws ValidatorException {
        if (validator != null && validator.isClientOnly()) {
            return null;
        }
        if (validatorName == null) {
            return new ErrorMessage("Validator missing type property: " + validator + "\nIf this is a custom validator, set the clientOnly property to true.");
        }
        if (clientOnlyValidators.contains(validatorName)) {
            return null;
        }
        ValidatorFunc vfunc = DefaultValidators.getBuiltinValidator(validatorName);
        if (vfunc != null) {
            ErrorMessage error = vfunc.validate(validator, value, fieldName, record, context);
            if (error != null) {
                try {
                    validator.evaluateErrorMessage(error);
                }
                catch (Exception e) {
                    throw new ValidatorException(e.getMessage());
                }
            }
            return error;
        }
        Method valFunc = (Method)validatorFunctions.get(validatorName);
        if (valFunc == null) {
            String valFuncName = (String)validator.get("serverValidationFunction");
            if (valFuncName == null) {
                return new ErrorMessage("No built-in validator named '" + validatorName + "' was found." + " Set the clientOnly property to true if this is a custom validator.");
            }
            try {
                valFunc = Reflection.findMethod(valFuncName);
                DefaultValidators.addValidator(validatorName, valFunc);
            }
            catch (Throwable t) {
                log.error((Object)("No implementer for validator: " + validatorName), t);
                return new ErrorMessage("No implementer found for validator named '" + validatorName + "'\n" + "If you want a validator to be client-side only, set its clientOnly " + "property to true.");
            }
        }
        ErrorMessage error = null;
        try {
            Object[] args = new Object[]{validator, value, record};
            error = (ErrorMessage)valFunc.invoke(null, args);
            if (error != null) {
                validator.evaluateErrorMessage(error);
            }
            return error;
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                t = Reflection.getRealTargetException(t);
            }
            return new ErrorMessage(DataTools.getStackTrace(t));
        }
    }

    static ValidatorFunc getBuiltinValidator(String validatorName) {
        return (ValidatorFunc)defaultValidators.get(validatorName);
    }

    public static LocaleMessage processI18nString(String input, ValidationContext context) throws Exception {
        if (input.startsWith("<fmt:message")) {
            String encoding;
            input = "<elem xmlns:fmt=\"dummy\">" + input + "</elem>";
            Map xml = XML.parseXMLToMap(input);
            Map msgProps = (Map)xml.get("fmt:message");
            String key = (String)msgProps.get("key");
            String bundleName = (String)msgProps.get("bundle");
            if (bundleName == null) {
                bundleName = context.getBundleName();
            }
            if ((encoding = (String)msgProps.get("encoding")) == null) {
                encoding = context.getBundleEncoding();
            }
            return new LocaleMessage(key, bundleName, encoding);
        }
        return null;
    }

    private static Long getParamAsLong(Map params, Object key) {
        Long param = null;
        if (!params.containsKey(key)) {
            return null;
        }
        try {
            String stringParam = params.get(key).toString();
            stringParam = stringParam.trim();
            int decimalIndex = stringParam.indexOf(".");
            if (decimalIndex != -1 && Integer.parseInt(stringParam.substring(decimalIndex + 1)) == 0) {
                stringParam = stringParam.substring(0, decimalIndex);
            }
            param = new Long(stringParam);
        }
        catch (NumberFormatException e) {
            param = null;
        }
        return param;
    }

    private static Double getParamAsDouble(Map params, Object key) {
        Double value = null;
        if (!params.containsKey(key)) {
            return null;
        }
        try {
            value = new Double(params.get(key).toString());
        }
        catch (NumberFormatException e) {
            value = null;
        }
        return value;
    }

    private static Date getParamAsDate(Map params, Object key) {
        if (!params.containsKey(key)) {
            return null;
        }
        return DefaultValidators.getValueAsDate(params.get(key));
    }

    private static Date getValueAsDate(Object param) {
        Date date;
        SimpleDateFormat dateFormat;
        if (param == null) {
            return null;
        }
        if (param instanceof Date) {
            return (Date)param;
        }
        String dateString = param.toString();
        if (dateString.length() == 19) {
            dateFormat = dateString.charAt(10) == 'T' ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss Z") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
            dateString = dateString + " -0000";
        } else {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        }
        try {
            date = dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            log.warn("Parse Exception: \n\n" + e.getStackTrace());
            date = null;
        }
        return date;
    }

    private static String getErrorString(Map params, ValidationContext context) {
        return DefaultValidators.getErrorString(params, "Validation failed", context);
    }

    private static String getErrorString(Map params, String defaultMessage, ValidationContext context) {
        String errorMessage;
        Object errMsgObj = params.get("errorMessage");
        if (errMsgObj instanceof LocaleMessage) {
            Locale locale = context == null || context.getDSRequest() == null || context.getDSRequest().context == null ? null : context.getDSRequest().context.getLocale();
            errorMessage = ((LocaleMessage)errMsgObj).getMessage(locale);
        } else {
            errorMessage = errMsgObj == null ? defaultMessage : errMsgObj.toString();
        }
        return errorMessage;
    }

    static {
        defaultValidators.put("required", new required());
        defaultValidators.put("isBoolean", new isBoolean());
        defaultValidators.put("isInteger", new isInteger());
        defaultValidators.put("isDate", new isDate());
        defaultValidators.put("dateRange", new dateRange());
        defaultValidators.put("isTime", new isTime());
        defaultValidators.put("timeRange", new timeRange());
        defaultValidators.put("integerRange", new integerRange());
        defaultValidators.put("regexp", new regexp());
        defaultValidators.put("regex", new regexp());
        defaultValidators.put("lengthRange", new lengthRange());
        defaultValidators.put("matchesField", new matchesField());
        defaultValidators.put("isOneOf", new isOneOf());
        defaultValidators.put("contains", new contains());
        defaultValidators.put("doesntContain", new doesntContain());
        defaultValidators.put("substringCount", new substringCount());
        defaultValidators.put("mask", new mask());
        defaultValidators.put("floatLimit", new floatLimit());
        defaultValidators.put("floatPrecision", new floatPrecision());
        defaultValidators.put("floatRange", new floatRange());
        defaultValidators.put("isFloat", new isFloat());
        defaultValidators.put("isIdentifier", new isIdentifier());
        defaultValidators.put("isURL", new isURL());
        defaultValidators.put("isString", new isString());
        defaultValidators.put("inValueMap", new inValueMap());
        defaultValidators.put("isRegexp", new isRegexp());
        defaultValidators.put("integerOrAuto", new integerOrAuto());
        defaultValidators.put("integerOrIdentifier", new integerOrIdentifier());
        defaultValidators.put("isMeasure", new isMeasure());
        defaultValidators.put("serverCustom", new serverCustom());
        defaultValidators.put("isUnique", new isUnique());
        defaultValidators.put("hasRelatedRecord", new hasRelatedRecord());
    }

    static class hasRelatedRecord
    implements ValidatorFunc {
        hasRelatedRecord() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            DSField thisField;
            String fk;
            Map params = context.getTemplateContext();
            String relatedDS = (String)validatorParams.get("relatedDataSource");
            String relatedField = (String)validatorParams.get("relatedField");
            if ((relatedDS == null || relatedField == null) && (fk = (thisField = (DSField)params.get("field")).getForeignKey()) != null) {
                String[] tokens = fk.split("[.]");
                if (tokens.length == 1) {
                    if (relatedDS == null) {
                        relatedDS = ((DataSource)params.get("dataSource")).getName();
                    }
                    if (relatedField == null) {
                        relatedField = tokens[0];
                    }
                } else {
                    if (relatedDS == null) {
                        relatedDS = tokens[0];
                    }
                    if (relatedField == null) {
                        relatedField = tokens[1];
                    }
                }
            }
            if (relatedDS == null || relatedField == null) {
                String error = "Field " + fieldName + " - 'hasRelatedRecord' validation could not derive " + "a relation to test - specify 'relatedDataSource' and 'relatedField' on " + "the validator, or a foreignKey property in this field's DataSource " + "definition.  Cannot proceed, assuming false.";
                log.warn(error);
                return new ErrorMessage(error);
            }
            try {
                DataSource ds = DataSourceManager.get(relatedDS, context.getDSRequest());
                if (ds == null) {
                    String error = "Field " + fieldName + " - 'hasRelatedRecord' validation encountered a " + "'relatedDataSource' that was not a real DataSource.  Please check " + "your validator code.  Unable to proceed, assuming false.";
                    log.warn(error);
                    return new ErrorMessage(error);
                }
                DSRequest req = new DSRequest(relatedDS, "fetch");
                req.setCriteria(relatedField, value);
                DSRequest originalReq = context.getDSRequest();
                if (originalReq != null) {
                    req.setRPCManager(originalReq.getRPCManager());
                }
                if (req.execute().getRowCount() == 0L) {
                    return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Related record does not exist", context));
                }
            }
            catch (Exception e) {
                log.warn((Object)("Field " + fieldName + " - 'hasRelatedRecord' validation encountered unexpected exception."), e);
                return new ErrorMessage(e.getMessage());
            }
            return null;
        }
    }

    static class isUnique
    implements ValidatorFunc {
        isUnique() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            Map params = context.getTemplateContext();
            boolean isAdd = false;
            boolean isUpdate = false;
            DSRequest req = context.getDSRequest();
            if (req != null) {
                isAdd = DataSource.isAdd(req.getOperationType()) || DataSource.isValidate(req.getOperationType()) && req.getPendingAddFlag();
                isUpdate = DataSource.isUpdate(req.getOperationType());
            }
            DataSource ds = (DataSource)params.get("dataSource");
            DSField field = (DSField)params.get("field");
            if (field == null) {
                log.warn("Field " + fieldName + " - 'isUnique' validation encountered a " + "template context where the field was not set.  Unable to  " + "proceed, assuming false");
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Value must be unique", context));
            }
            String realFieldName = field.getName();
            if (ds == null) {
                log.warn("Field " + fieldName + " - 'isUnique' validation encountered a " + "template context where the dataSource was not set.  Unable to  " + "proceed, assuming false");
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Value must be unique", context));
            }
            try {
                DSRequest request = new DSRequest(ds.getName(), "fetch");
                HashMap<String, Object> criteria = new HashMap<String, Object>();
                criteria.put(realFieldName, value);
                String criteriaFieldsString = (String)validatorParams.get("criteriaFields");
                String[] criteriaFields = criteriaFieldsString != null ? criteriaFieldsString.split(",") : new String[]{};
                for (int i = 0; i < criteriaFields.length; ++i) {
                    criteriaFields[i] = criteriaFields[i].trim();
                }
                if (isUpdate) {
                    if (ds.getPrimaryKeys().isEmpty()) {
                        log.warn("unique check cannot be performed for update operation: some criteriaFields are missing and data source has no primary keys - skipping unique check.");
                        return null;
                    }
                    Map existingRecord = null;
                    boolean recordHasPK = true;
                    for (String pk : ds.getPrimaryKeys()) {
                        if (record.get(pk) != null) continue;
                        recordHasPK = false;
                        break;
                    }
                    boolean existingRecordNeeded = true;
                    if (recordHasPK && !DataTools.containsAllKeys(record, criteriaFields)) {
                        existingRecord = ds.fetchById(record);
                    } else if (!recordHasPK) {
                        Map requestCriteria = req.getCriteria();
                        ArrayList<Object> passedKeys = null;
                        if (AdvancedCriteria.isAdvancedCriteria(requestCriteria)) {
                            AdvancedCriteria ac = AdvancedCriteria.fromCollections(requestCriteria);
                            passedKeys = new ArrayList();
                            for (String key : ds.getPrimaryKeys()) {
                                if (ac.getFieldValue(key) == null) continue;
                                passedKeys.add(key);
                            }
                        } else {
                            passedKeys = new ArrayList(requestCriteria.keySet());
                        }
                        List<String> keysPresent = DataTools.setIntersection(ds.getPrimaryKeys(), passedKeys);
                        List keysMissing = DataTools.setDisjunction(ds.getPrimaryKeys(), keysPresent);
                        if (keysMissing != null && !keysMissing.isEmpty()) {
                            log.warn("unique check cannot be performed for update operation: some criteriaFields are missing and primary key is missing in record or criteria - skipping unique check.");
                            return null;
                        }
                        DSRequest _request = new DSRequest(ds.getName(), "fetch");
                        _request.setCriteria(requestCriteria);
                        List existingList = _request.execute().getRecords();
                        if (existingList != null && !existingList.isEmpty()) {
                            if (existingList.size() > 1) {
                                log.warn("unique check cannot be performed for update operation: update criteria filters multiple rows, which is not supported by isUnique validator - skipping unique check.");
                                return null;
                            }
                            existingRecord = (Map)existingList.get(0);
                        }
                    } else {
                        existingRecordNeeded = false;
                    }
                    if (existingRecord == null && existingRecordNeeded) {
                        log.warn("unique check cannot be performed for update operation: existing record could not be found - skipping unique check.");
                        return null;
                    }
                    if (!DataTools.containsAllKeys(record, criteriaFields)) {
                        for (String criteriaName : criteriaFields) {
                            String key;
                            if (!existingRecord.containsKey(criteriaName)) continue;
                            key = criteriaName;
                            criteria.put(key, existingRecord.get(key));
                        }
                    }
                }
                for (String criteriaName : criteriaFields) {
                    if (!record.containsKey(criteriaName)) continue;
                    String key = criteriaName;
                    criteria.put(key, record.get(key));
                }
                request.setCriteria(criteria);
                if (isUpdate) {
                    for (String primaryKey : ds.getPrimaryKeys()) {
                        request.addToCriteria(primaryKey, "notEqual", record.get(primaryKey));
                    }
                }
                if (req != null) {
                    request.setRPCManager(req.getRPCManager());
                }
                HashSet<String> outputs = new HashSet<String>(ds.getPrimaryKeys());
                outputs.add(realFieldName);
                request.setOutputs(new ArrayList<String>(outputs));
                Map<String, Object> oldRecord = request.execute().getRecord();
                if (oldRecord == null) {
                    return null;
                }
                if (isAdd) {
                    return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Value must be unique", context));
                }
                Object newRecordFieldValue = record.get(realFieldName);
                boolean keyMatches = true;
                for (String pkField : ds.getPrimaryKeys()) {
                    Object newRecordPKValue = record.get(pkField);
                    log.debug("unique check: pkField: " + pkField + ", old PK: " + oldRecord.get(pkField) + ", new PK: " + record.get(pkField));
                    if (newRecordPKValue != null && newRecordPKValue.toString().equals(oldRecord.get(pkField).toString())) continue;
                    keyMatches = false;
                    break;
                }
                if (!keyMatches) {
                    log.debug("unique check: key fields do not match, fails unique check");
                } else {
                    log.debug("unique check: unique field: " + realFieldName + ", old unique value: " + oldRecord.get(realFieldName) + ", new unique value: " + record.get(realFieldName));
                    if (newRecordFieldValue != null && newRecordFieldValue.toString().equals(oldRecord.get(realFieldName).toString())) {
                        log.debug("unique check: key fields and unique field match, passes unique check");
                        return null;
                    }
                }
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Value must be unique", context));
            }
            catch (Exception e) {
                log.warn((Object)("Field " + fieldName + " - 'isUnique' validation encountered unexpected exception."), e);
                return new ErrorMessage(e.getMessage());
            }
        }
    }

    static class serverCustom
    implements ValidatorFunc {
        serverCustom() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            Object rawResult;
            Validator validator = validatorParams instanceof Validator ? (Validator)validatorParams : new Validator(validatorParams);
            String expression = validator.getServerCondition();
            if (expression != null) {
                try {
                    String language = validator.getLanguage();
                    if (language == null || "".equals(language.trim())) {
                        language = (String)Config.getProperty("script.validator.defaultLanguage");
                    }
                    if ("velocity".equals(language)) {
                        rawResult = this.evaluateVelocityExpression(validator, value, fieldName, record, context);
                    }
                    rawResult = this.evaluateServerScript(validator, value, fieldName, record, context);
                }
                catch (Exception e) {
                    throw new ValidatorException(e.getMessage());
                }
            } else {
                Map serverObjectConfig = (Map)validator.get("serverObject");
                if (serverObjectConfig == null) {
                    throw new ValidatorException("'serverCustom' validator has neither serverCondition nor serverObject declaration");
                }
                rawResult = this.callServerObject(validator, value, fieldName, record, context);
            }
            Boolean rtnValue = null;
            if (rawResult instanceof Boolean) {
                rtnValue = (Boolean)rawResult;
            } else {
                if (rawResult.toString().toLowerCase().trim().equals("true")) {
                    rtnValue = new Boolean(true);
                }
                if (rawResult.toString().toLowerCase().trim().equals("false")) {
                    rtnValue = new Boolean(false);
                }
            }
            if (rtnValue == null) {
                log.warn("Field " + fieldName + " - 'serverCustom' validation returned null or non boolean value " + "instead of boolean value. Assuming false (validation not passed)");
            }
            if (Boolean.TRUE.equals(rtnValue)) {
                return null;
            }
            return new ErrorMessage(DefaultValidators.getErrorString(validator, "Failed custom validation", context));
        }

        public Object callServerObject(Validator validator, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            ServerObject serverObject;
            Map serverObjectConfig = (Map)validator.get("serverObject");
            RequestContext requestContext = context.getRequestContext();
            DataSource dataSource = context.getCurrentDataSource();
            String contextString = "'serverCustom' validator for field " + fieldName + " on DataSource " + dataSource.getID();
            try {
                serverObject = new ServerObject(serverObjectConfig, requestContext, contextString);
            }
            catch (Exception e) {
                throw new ValidatorException("Bad serverObject declaration:\n" + DataTools.prettyPrint(serverObjectConfig) + "\n..led to exception:\n" + DataTools.getStackTrace(e));
            }
            ReflectionArgument[] requiredArgs = new ReflectionArgument[]{new ReflectionArgument(Object.class, value, false, false), new ReflectionArgument(Validator.class, validator, false, false), new ReflectionArgument(String.class, fieldName, false, false), new ReflectionArgument(Map.class, record, false, false)};
            ArrayList<ReflectionArgument> optionalArgsList = new ArrayList<ReflectionArgument>();
            optionalArgsList.add(new ReflectionArgument(DataSource.class, dataSource, false, false));
            optionalArgsList.add(new ReflectionArgument(RequestContext.class, requestContext, false, false));
            if (requestContext != null) {
                optionalArgsList.add(new ReflectionArgument(DSRequest.class, context.getDSRequest(), false, false));
                optionalArgsList.add(new ReflectionArgument(HttpServletRequest.class, (Object)requestContext.request, false, false));
                optionalArgsList.add(new ReflectionArgument(HttpServletResponse.class, requestContext.response, false, false));
                optionalArgsList.add(new ReflectionArgument(ServletContext.class, requestContext.servletContext, false, false));
                if (requestContext.request != null) {
                    optionalArgsList.add(new ReflectionArgument(HttpSession.class, requestContext.request.getSession(true), false, false));
                }
            }
            if (context != null) {
                optionalArgsList.add(new ReflectionArgument(RPCManager.class, context.getRPCManager(), false, false));
            }
            ReflectionArgument[] optionalArgs = optionalArgsList.toArray(new ReflectionArgument[0]);
            Object returnValue = null;
            try {
                String methodName = (String)serverObjectConfig.get("methodName");
                if (methodName == null) {
                    methodName = "condition";
                }
                Method method = serverObject.getMethod(methodName);
                Object serverObjectInstance = serverObject.getInstance(method);
                returnValue = Reflection.adaptArgsAndInvoke(serverObjectInstance, method, requiredArgs, optionalArgs);
            }
            catch (Exception e) {
                Throwable t = Reflection.getRealTargetException(e);
                String message = "Validator DMI invocation threw exception: ";
                log.warn(message + DataTools.getStackTrace(t));
                throw new ValidatorException(message + t.getClass().getName() + " with error: " + t.getMessage());
            }
            return returnValue;
        }

        public Object evaluateServerScript(Validator validator, Object value, String fieldName, Map record, ValidationContext context) {
            String expression = validator.getServerCondition();
            String language = validator.getLanguage();
            Object imports = validator.getScriptImports();
            Map bindings = new HashMap();
            Map bindingsClassName = new HashMap();
            if (context != null) {
                bindings = context.getTemplateContext();
                bindingsClassName = context.getTemplateContextClassNames();
            }
            DataTypeMap params = new DataTypeMap();
            params.put("engineName", language);
            params.put("imports", imports);
            params.put("script", expression);
            params.put("bindings", bindings);
            params.put("bindingsClassName", bindingsClassName);
            Map result = null;
            try {
                IScript script = Scripting.getScript(language);
                result = script.eval(params);
                if (result != null && result instanceof Map) {
                    return result.get("evalResult");
                }
            }
            catch (Exception ex) {
                log.error((Object)"Failed to evaluate script.", ex);
            }
            return null;
        }

        public Object evaluateVelocityExpression(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws Exception {
            String expression = (String)validatorParams.get("serverCondition");
            Map params = context.getTemplateContext();
            return Velocity.evaluateBooleanExpression(expression, params, "CustomValidator", context.getCurrentDataSource());
        }
    }

    static class isColor
    implements ValidatorFunc {
        isColor() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            String str = value.toString();
            int index = 0;
            int length = str.length();
            if (str.charAt(0) == '#') {
                index = 1;
            }
            while (index < length) {
                char ch = str.charAt(index);
                if (!(ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F')) {
                    return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Not a valid color", context));
                }
                ++index;
            }
            return null;
        }
    }

    static class isMeasure
    implements ValidatorFunc {
        isMeasure() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("") || value.equals("*")) {
                return null;
            }
            String str = value.toString();
            if (validatorParams.get("errorMessage") == null) {
                validatorParams.put("errorMessage", "Must be a whole number, percentage, \"*\" or \"auto\"");
            }
            if (str.endsWith("%")) {
                try {
                    Long.parseLong(str.substring(0, str.length() - 1));
                }
                catch (NumberFormatException e) {
                    return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Not a valid percentage", context));
                }
                return null;
            }
            return DefaultValidators.getBuiltinValidator("integerOrAuto").validate(validatorParams, value, fieldName, record, context);
        }
    }

    static class integerOrIdentifier
    implements ValidatorFunc {
        integerOrIdentifier() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            if (DataTools.isIdentifier((String)value)) {
                return null;
            }
            if (validatorParams.get("errorMessage") == null) {
                validatorParams.put("errorMessage", "Must be a whole number or an identifier");
            }
            return DefaultValidators.getBuiltinValidator("isInteger").validate(validatorParams, value, fieldName, record, context);
        }
    }

    static class integerOrAuto
    implements ValidatorFunc {
        integerOrAuto() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            if ("auto".equalsIgnoreCase(value.toString())) {
                return null;
            }
            if (validatorParams.get("errorMessage") == null) {
                validatorParams.put("errorMessage", "Must be a whole number or \"auto\"");
            }
            return DefaultValidators.getBuiltinValidator("isInteger").validate(validatorParams, value, fieldName, record, context);
        }
    }

    static class isRegexp
    implements ValidatorFunc {
        isRegexp() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            try {
                new Perl5Compiler().compile(value.toString());
            }
            catch (MalformedPatternException e) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, e.getMessage(), context));
            }
            return null;
        }
    }

    static class inValueMap
    implements ValidatorFunc {
        inValueMap() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            Object valueMap = validatorParams.get("valueMap");
            if (valueMap == null) {
                throw new ValidatorException("inValueMap validator called without a valueMap");
            }
            if (valueMap instanceof Collection) {
                validatorParams.put("list", new ArrayList((Collection)valueMap));
            } else if (valueMap instanceof Map) {
                validatorParams.put("list", DataTools.enumToList(((Map)valueMap).keySet().iterator()));
            } else {
                throw new ValidatorException("The value map must be either a collection or a map");
            }
            return DefaultValidators.getBuiltinValidator("isOneOf").validate(validatorParams, value, fieldName, record, context);
        }
    }

    static class isString
    implements ValidatorFunc {
        isString() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            String valueString = value.toString();
            try {
                LocaleMessage lm = DefaultValidators.processI18nString(valueString, context);
                if (lm != null) {
                    context.setResultingValue(lm);
                    return null;
                }
            }
            catch (Exception e) {
                log.warn((Object)("Unable to parse value: " + value), e);
            }
            context.setResultingValue(value.toString());
            return null;
        }
    }

    static class isURL
    implements ValidatorFunc {
        isURL() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            try {
                new URL(value.toString());
            }
            catch (MalformedURLException e) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, e.getMessage(), context));
            }
            return null;
        }
    }

    static class isIdentifier
    implements ValidatorFunc {
        isIdentifier() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            if (DataTools.isIdentifier((String)value)) {
                return null;
            }
            return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Not a valid identifier", context));
        }
    }

    static class isFloat
    implements ValidatorFunc {
        isFloat() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            try {
                BasicDataSource ds = (BasicDataSource)context.getDSRequest().getDataSource();
                Class clazz = ds.getFieldJavaType(fieldName);
                if (BigDecimal.class.equals((Object)clazz)) {
                    context.setResultingValue(new BigDecimal(value.toString()));
                    return null;
                }
            }
            catch (Exception ds) {
                // empty catch block
            }
            double num = DataTools.asDouble(value);
            if (Double.isNaN(num)) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be a valid decimal.", context));
            }
            context.setResultingValue(new Double(num));
            return null;
        }
    }

    static class floatRange
    implements ValidatorFunc {
        floatRange() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            double num;
            if (value == null || value.equals("")) {
                return null;
            }
            try {
                num = Double.valueOf(value.toString());
            }
            catch (NumberFormatException e) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be a valid decimal.", context));
            }
            Double min = DefaultValidators.getParamAsDouble(validatorParams, "min");
            Double max = DefaultValidators.getParamAsDouble(validatorParams, "max");
            if (max != null && num > max) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, context), max);
            }
            if (min != null && num < min) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, context), min);
            }
            return null;
        }
    }

    static class floatPrecision
    implements ValidatorFunc {
        floatPrecision() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            double num;
            if (value == null || value.equals("")) {
                return null;
            }
            try {
                num = Double.valueOf(value.toString());
            }
            catch (NumberFormatException e) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be a valid decimal.", context));
            }
            Double precision = DefaultValidators.getParamAsDouble(validatorParams, "precision");
            if (precision != null) {
                double multiplier = Math.pow(10.0, precision);
                double suggestedValue = new Long(Math.round(num * multiplier)).doubleValue() / multiplier;
                if (suggestedValue == num) {
                    return null;
                }
                String message = "No more than " + precision.intValue() + " digits after the decimal point.";
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, message, context), new Double(suggestedValue));
            }
            return null;
        }
    }

    static class floatLimit
    implements ValidatorFunc {
        floatLimit() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            double num;
            if (value == null || value.equals("")) {
                return null;
            }
            try {
                num = Double.valueOf(value.toString());
            }
            catch (NumberFormatException e) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be a valid decimal.", context));
            }
            Double min = DefaultValidators.getParamAsDouble(validatorParams, "min");
            Double max = DefaultValidators.getParamAsDouble(validatorParams, "max");
            if (max != null && num > max) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, context), max);
            }
            if (min != null && num < min) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, context), min);
            }
            Double precision = DefaultValidators.getParamAsDouble(validatorParams, "precision");
            if (precision != null) {
                double multiplier = Math.pow(10.0, precision);
                double suggestedValue = new Long(Math.round(num * multiplier)).doubleValue() / multiplier;
                if (suggestedValue == num) {
                    return null;
                }
                String message = "No more than " + precision.intValue() + " digits after the decimal point.";
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, message, context), new Double(suggestedValue));
            }
            return null;
        }
    }

    static class mask
    implements ValidatorFunc {
        mask() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            String mask2 = (String)validatorParams.get("mask");
            if (mask2 == null) {
                throw new ValidatorException("mask validator called without valid mask");
            }
            Perl5Util util = new Perl5Util();
            mask2 = "/" + mask2 + "/";
            if (!util.match(mask2, value.toString())) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, context));
            }
            return null;
        }
    }

    static class substringCount
    implements ValidatorFunc {
        substringCount() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            String substring = (String)validatorParams.get("substring");
            String val = value.toString();
            if (substring == null) {
                throw new ValidatorException("substringCount validator called without valid substring");
            }
            long matchCount = 0L;
            for (int i = 0; i < val.length() && (i = val.indexOf(substring, i)) > -1; ++i) {
                ++matchCount;
            }
            String operator = (String)validatorParams.get("operator");
            Long countObj = DefaultValidators.getParamAsLong(validatorParams, "count");
            if (operator == null) {
                operator = "==";
            }
            long count = countObj == null ? 0L : countObj;
            if (operator.equals("==")) {
                if (matchCount == count) {
                    return null;
                }
            } else if (operator.equals("!=")) {
                if (matchCount != count) {
                    return null;
                }
            } else if (operator.equals(">")) {
                if (matchCount > count) {
                    return null;
                }
            } else if (operator.equals("<")) {
                if (matchCount < count) {
                    return null;
                }
            } else if (operator.equals(">=")) {
                if (matchCount >= count) {
                    return null;
                }
            } else if (operator.equals("<=")) {
                if (matchCount <= count) {
                    return null;
                }
            } else {
                throw new ValidatorException("in substringCount validator, operator was " + operator + ", must be one of ==, !=, >, <, >= or <=");
            }
            return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must contain " + operator + " " + count + " instances of '" + substring + "'", context));
        }
    }

    static class doesntContain
    implements ValidatorFunc {
        doesntContain() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            String substring = (String)validatorParams.get("substring");
            if (substring == null) {
                throw new ValidatorException("doesntContain validator called without valid substring");
            }
            if (value.toString().indexOf(substring) > -1) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must not contain '" + substring + "'", context));
            }
            return null;
        }
    }

    static class contains
    implements ValidatorFunc {
        contains() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            String substring = (String)validatorParams.get("substring");
            if (substring == null) {
                throw new ValidatorException("contains validator called without valid substring");
            }
            if (value.toString().indexOf(substring) == -1) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must contain '" + substring + "'", context));
            }
            return null;
        }
    }

    static class isOneOf
    implements ValidatorFunc {
        isOneOf() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            Collection list = (Collection)validatorParams.get("list");
            if (list == null) {
                throw new ValidatorException("isOneOf validator called without valid list for field: " + fieldName);
            }
            Iterator e = list.iterator();
            while (e.hasNext()) {
                if (!value.toString().equals(e.next().toString())) continue;
                return null;
            }
            return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be one of " + list.toString() + ".", context));
        }
    }

    static class matchesField
    implements ValidatorFunc {
        matchesField() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            Object otherField = validatorParams.get("otherField");
            if (otherField == null) {
                throw new ValidatorException("matchesField validator called without valid otherField");
            }
            Object otherFieldValue = record.get(otherField);
            if (value == null && otherFieldValue == null || value.equals(otherFieldValue)) {
                return null;
            }
            return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Does not match value in field '" + otherField + "'", context));
        }
    }

    static class lengthRange
    implements ValidatorFunc {
        lengthRange() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("") || value instanceof Boolean) {
                return null;
            }
            Long min = DefaultValidators.getParamAsLong(validatorParams, "min");
            Long max = DefaultValidators.getParamAsLong(validatorParams, "max");
            if (min == null && max == null) {
                throw new ValidatorException("lengthRange validator called without valid min or max");
            }
            String s = value.toString();
            if (max != null && (long)s.length() > max || min != null && (long)s.length() < min) {
                String errorMessage = min == null ? DefaultValidators.getErrorString(validatorParams, "Must be no more than " + max + " characters long", context) : (max == null ? DefaultValidators.getErrorString(validatorParams, "Must be at least " + min + " characters long", context) : DefaultValidators.getErrorString(validatorParams, "Must be between " + min + "-" + max + " characters long", context));
                return new ErrorMessage(errorMessage);
            }
            return null;
        }
    }

    static class regexp
    implements ValidatorFunc {
        regexp() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            String expression = (String)validatorParams.get("expression");
            if (expression == null) {
                throw new ValidatorException("regexp validator called without expression");
            }
            Perl5Util util = new Perl5Util();
            expression = "/" + expression + "/";
            if (!util.match(expression, value.toString())) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, context));
            }
            return null;
        }
    }

    static class integerRange
    implements ValidatorFunc {
        integerRange() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            long num;
            if (value == null || value.equals("")) {
                return null;
            }
            try {
                num = Long.parseLong(value.toString().trim());
            }
            catch (NumberFormatException e) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be a whole number", context));
            }
            Long min = DefaultValidators.getParamAsLong(validatorParams, "min");
            Long max = DefaultValidators.getParamAsLong(validatorParams, "max");
            if (min == null && max == null) {
                throw new ValidatorException("integerRange validator called without valid min or max");
            }
            if (max != null && num > max) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be less than " + max, context), max);
            }
            if (min != null && num < min) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be greater than " + min, context), min);
            }
            return null;
        }
    }

    static class timeRange
    implements ValidatorFunc {
        timeRange() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return null;
            }
            Date val = DefaultValidators.getValueAsDate(value);
            if (val == null) {
                throw new ValidatorException("timeRange validator called without a valid date-value");
            }
            String min = validatorParams.get("min").toString();
            String max = validatorParams.get("max").toString();
            if ((min == null || min.equals("")) && (max == null || max.equals(""))) {
                throw new ValidatorException("timeRange validator called without valid min or max");
            }
            SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
            Date valDate = null;
            Date minTime = null;
            Date maxTime = null;
            try {
                String rawTime = val.getHours() + ":" + val.getMinutes() + ":" + val.getSeconds();
                valDate = timeFormat.parse(rawTime);
            }
            catch (ParseException e) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Invalid time value", context));
            }
            try {
                minTime = timeFormat.parse(min);
            }
            catch (ParseException e) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "min must be a time-string.", context));
            }
            try {
                maxTime = timeFormat.parse(max);
            }
            catch (ParseException e) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "max must be a time-string.", context));
            }
            if (maxTime != null && valDate.getTime() > maxTime.getTime()) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be less than " + timeFormat.format(maxTime) + " - time is " + timeFormat.format(valDate), context), max);
            }
            if (minTime != null && valDate.getTime() < minTime.getTime()) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be greater than " + timeFormat.format(minTime) + " - time is " + timeFormat.format(valDate), context), min);
            }
            return null;
        }
    }

    static class isTime
    implements ValidatorFunc {
        isTime() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value instanceof Date) {
                return null;
            }
            if (value.equals("")) {
                context.setResultingValue(null);
                return null;
            }
            SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
            try {
                Date time = timeFormat.parse(value.toString());
                context.setResultingValue(time);
                return null;
            }
            catch (ParseException e) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be a time.", context));
            }
        }
    }

    static class dateRange
    implements ValidatorFunc {
        dateRange() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            String max;
            if (value == null || value.equals("")) {
                return null;
            }
            Date val = DefaultValidators.getValueAsDate(value);
            if (val == null) {
                throw new ValidatorException("dateRange validator called without a valid date-value");
            }
            String min = validatorParams.get("min") != null ? validatorParams.get("min").toString() : null;
            String string = max = validatorParams.get("max") != null ? validatorParams.get("max").toString() : null;
            if ((min == null || min.equals("")) && (max == null || max.equals(""))) {
                throw new ValidatorException("dateRange validator called without valid min or max");
            }
            Date minDate = DefaultValidators.getParamAsDate(validatorParams, "min");
            Date maxDate = DefaultValidators.getParamAsDate(validatorParams, "max");
            Boolean inclusive = false;
            Object testVal = validatorParams.get("inclusive");
            if (testVal instanceof Boolean) {
                inclusive = (Boolean)testVal;
            }
            if (maxDate != null && !inclusive.booleanValue() && val.getTime() > maxDate.getTime() || inclusive.booleanValue() && val.getTime() >= maxDate.getTime()) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be earlier than " + max, context), max);
            }
            if (minDate != null && !inclusive.booleanValue() && val.getTime() < minDate.getTime() || inclusive.booleanValue() && val.getTime() <= minDate.getTime()) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be later than " + min, context), min);
            }
            return null;
        }
    }

    static class isDate
    implements ValidatorFunc {
        isDate() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            SimpleDateFormat dateFormat;
            if (value == null || value instanceof Date) {
                return null;
            }
            if (value.equals("")) {
                context.setResultingValue(null);
                return null;
            }
            String dateString = ((String)value).toString();
            if (dateString.length() == 19 || dateString.length() == 23) {
                dateString = dateString + "-0000";
            }
            if (dateString.length() == 24 || dateString.length() == 28) {
                String t = dateString.charAt(10) == 'T' ? "'T'" : " ";
                String dfString = "yyyy-MM-dd" + t + "HH:mm:ss";
                if (dateString.length() == 28) {
                    dfString = dfString + ".SSS";
                }
                dfString = dfString + "Z";
                dateFormat = new SimpleDateFormat(dfString);
            } else {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            }
            try {
                Date date = dateFormat.parse(dateString);
                context.setResultingValue(date);
                return null;
            }
            catch (ParseException e) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be a date.", context));
            }
        }
    }

    static class isInteger
    implements ValidatorFunc {
        isInteger() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            long longValue;
            if (value == null || value.equals("") || value instanceof Integer) {
                return null;
            }
            try {
                BasicDataSource ds = (BasicDataSource)context.getDSRequest().getDataSource();
                Class clazz = ds.getFieldJavaType(fieldName);
                if (BigInteger.class.equals((Object)clazz)) {
                    context.setResultingValue(new BigInteger(value.toString()));
                    return null;
                }
            }
            catch (Exception ds) {
                // empty catch block
            }
            try {
                longValue = Long.parseLong(value.toString().trim());
            }
            catch (NumberFormatException e) {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be a whole number.", context));
            }
            context.setResultingValue(new Long(longValue));
            return null;
        }
    }

    static class isBoolean
    implements ValidatorFunc {
        isBoolean() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("") || value instanceof Boolean) {
                return null;
            }
            if (value instanceof Number) {
                double number = ((Number)value).doubleValue();
                context.setResultingValue(new Boolean(number != 0.0));
            } else if (value instanceof String) {
                context.setResultingValue(new Boolean((String)value));
            } else {
                return new ErrorMessage(DefaultValidators.getErrorString(validatorParams, "Must be a true/false value", context));
            }
            return null;
        }
    }

    static class required
    implements ValidatorFunc {
        required() {
        }

        public ErrorMessage validate(Map validatorParams, Object value, String fieldName, Map record, ValidationContext context) throws ValidatorException {
            if (value == null || value.equals("")) {
                return new ErrorMessage("Field is required");
            }
            return null;
        }
    }

    static interface ValidatorFunc {
        public ErrorMessage validate(Map var1, Object var2, String var3, Map var4, ValidationContext var5) throws ValidatorException;
    }
}

