/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.collections;

import com.isomorphic.util.DataTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections.map.AbstractMapDecorator;

public class DataTypeMap
extends AbstractMapDecorator {
    public DataTypeMap() {
        super(new HashMap());
    }

    public DataTypeMap(Map map) {
        super(map);
    }

    public String getString(Object key) {
        return this.getString(key, null);
    }

    public String getString(Object key, String defaultValue) {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    public String[] getStringArray(Object key, String[] defaultValue) {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (String[])DataTools.listToArray(this.getList(key));
    }

    public DataTypeMap getMap(Object key) {
        return this.getMap(key, null);
    }

    public DataTypeMap getMap(Object key, Map defaultValue) {
        Object value = this.get(key);
        if (value instanceof DataTypeMap) {
            return (DataTypeMap)((Object)value);
        }
        if (value instanceof Map) {
            return new DataTypeMap((Map)value);
        }
        if (value == null) {
            if (defaultValue != null) {
                if (defaultValue instanceof DataTypeMap) {
                    return (DataTypeMap)((Object)defaultValue);
                }
                return new DataTypeMap(defaultValue);
            }
            return null;
        }
        return new DataTypeMap((Map)value);
    }

    public List getList(Object key) {
        return this.getList(key, null);
    }

    public List getList(Object key, List defaultValue) {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof List) {
            return (List)value;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value.toString().trim(), " \r\t\n,");
        while (st.hasMoreTokens()) {
            result.add(st.nextToken().toString().trim());
        }
        return result;
    }

    public List getCommaSeparatedList(Object key) {
        return this.getCommaSeparatedList(key, null);
    }

    public List getCommaSeparatedList(Object key, List defaultValue) {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof List) {
            return (List)value;
        }
        return DataTools.commaSeparatedStringToList(value.toString().trim());
    }

    public boolean getBoolean(Object key, boolean defaultValue) {
        return this.getBoolean(key, new Boolean(defaultValue));
    }

    public Boolean getBoolean(Object key) {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(Object key, Boolean defaultValue) {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String s = value.toString().toLowerCase().trim();
        if (s.equals("true") || s.equals("yes")) {
            return new Boolean(true);
        }
        if (s.equals("false") || s.equals("no")) {
            return new Boolean(false);
        }
        return defaultValue;
    }

    public Byte getByte(Object key) {
        return this.getByte(key, null);
    }

    public byte getByte(Object key, byte defaultValue) {
        return this.getByte(key, new Byte(defaultValue));
    }

    public Byte getByte(Object key, Byte defaultValue) {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        return new Byte(value.toString().trim());
    }

    public short getShort(Object key, short defaultValue) {
        return this.getShort(key, new Short(defaultValue));
    }

    public Short getShort(Object key) {
        return this.getShort(key, null);
    }

    public Short getShort(Object key, Short defaultValue) {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        return new Short(value.toString().trim());
    }

    public Integer getInt(Object key) {
        return this.getInteger(key, null);
    }

    public Integer getInteger(Object key) {
        return this.getInteger(key, null);
    }

    public int getInt(Object key, int defaultValue) {
        return this.getInteger(key, new Integer(defaultValue));
    }

    public int getInteger(Object key, int defaultValue) {
        return this.getInteger(key, new Integer(defaultValue));
    }

    public Integer getInteger(Object key, Integer defaultValue) {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return new Integer(value.toString().trim());
    }

    public Long getLong(Object key) {
        return this.getLong(key, null);
    }

    public long getLong(Object key, long defaultValue) {
        return this.getLong(key, new Long(defaultValue));
    }

    public Long getLong(Object key, Long defaultValue) {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return new Long(value.toString().trim());
    }

    public Float getFloat(Object key) {
        return this.getFloat(key, null);
    }

    public float getFloat(Object key, float defaultValue) {
        return this.getFloat(key, new Float(defaultValue)).floatValue();
    }

    public Float getFloat(Object key, Float defaultValue) {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        return new Float(value.toString().trim());
    }

    public Double getDouble(Object key) {
        return this.getDouble(key, null);
    }

    public double getDouble(Object key, double defaultValue) {
        return this.getDouble(key, new Double(defaultValue));
    }

    public Double getDouble(Object key, Double defaultValue) {
        Object value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        return new Double(value.toString().trim());
    }
}

