/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import isc.org.apache.oro.text.perl.Perl5Util;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class TabImport
extends Base {
    private static Logger log = new Logger(TabImport.class.getName());
    static PrintStream out = System.out;
    static PrintStream err = System.err;
    static Perl5Util perl = new Perl5Util();
    static final String DATE_FORMAT = "yyyy-MM-dd";
    static final String DATETIME_FORMAT = "yyyy-MM-dd kk:mm:ss";

    public static void main(String[] args) {
        try {
            if (args.length < 2) {
                err.println("Usage: tabDataFile dataSourceName");
                System.exit(1);
            }
            String fileName = args[0];
            String dataSourceName = args[1];
            DataSource ds = DataSource.forName(dataSourceName, null);
            Reader importFile = new ISCFile(fileName).getReader();
            List rows = TabImport.rowsFromFile(importFile, ds);
            PrintWriter outWriter = new PrintWriter(out);
            JSTranslater.instance().toJSVariable(rows, dataSourceName + "TestData", outWriter);
            outWriter.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List rowsFromFile(Reader importFile, DataSource ds) throws Exception {
        return TabImport.rowsFromFile(importFile, ds, "\t");
    }

    public static List rowsFromFile(Reader importFile, DataSource ds, String delimiter) throws Exception {
        return TabImport.rowsFromFile(importFile, ds, delimiter, null);
    }

    public static List rowsFromFile(Reader importFile, DataSource ds, String delimiter, Map columnRemap) throws Exception {
        return TabImport.rowsFromFile(importFile, ds, delimiter, null, true);
    }

    public static List rowsFromFile(Reader input, DataSource ds, String delimiter, Map columnRemap, boolean trimExtraFields) throws Exception {
        BufferedReader importFile = new BufferedReader(input);
        ArrayList<Map> rows = new ArrayList<Map>();
        String columnsLine = importFile.readLine();
        ArrayList<String> columns = new ArrayList<String>();
        perl.split(columns, "/" + delimiter + "/", columnsLine);
        String lastColumn = (String)columns.get(columns.size() - 1);
        if (lastColumn.equals("")) {
            columns.remove(lastColumn);
        }
        log.debug((Object)"Columns in import data", columns);
        if (columnRemap != null) {
            ArrayList<String> oldColumns = columns;
            columns = new ArrayList();
            for (String origColumnName : oldColumns) {
                String columnName = (String)columnRemap.get(origColumnName);
                if (columnName == null) {
                    columnName = origColumnName;
                }
                columns.add(columnName);
            }
        }
        if (trimExtraFields) {
            for (int i = 0; i < columns.size(); ++i) {
                String columnName = (String)columns.get(i);
                if (ds.getField(columnName).getType() != null) continue;
                log.warning("Column \"" + columnName + "\" present in import data but " + "not in datasource \"" + ds.getName() + "\", ignoring");
                columns.set(i, "");
            }
        }
        log.debug((Object)"Columns after remap", columns);
        int lineNo = 0;
        String line = null;
        while ((line = importFile.readLine()) != null) {
            ++lineNo;
            if (line.trim().length() == 0) continue;
            List rawFieldValues = DataTools.simpleSplit(line, "\t");
            if (rawFieldValues.size() < columns.size()) {
                for (int i = rawFieldValues.size(); i < columns.size(); ++i) {
                    rawFieldValues.add("");
                }
            }
            List fieldValues = null;
            try {
                fieldValues = TabImport.parseFields(columns, rawFieldValues, ds);
            }
            catch (Exception e) {
                log.warning((Object)("Exception parsing line " + lineNo + " (datasource '" + ds.getName() + "')"), e);
                continue;
            }
            Map row = DataTools.mapFromLists(columns, fieldValues);
            rows.add(row);
        }
        return rows;
    }

    public static List parseFields(List columnNames, List fields, DataSource ds) throws Exception {
        ArrayList<String> outputFields = new ArrayList<String>();
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = (String)columnNames.get(i);
            if (columnName.equals("")) {
                outputFields.add(null);
                continue;
            }
            String field = (String)fields.get(i);
            if (field.startsWith("\"")) {
                field = field.substring(1);
            }
            if (field.endsWith("\"")) {
                field = field.substring(0, field.length() - 1);
            }
            field = TabImport.parseField(field, columnName, ds);
            outputFields.add(field);
        }
        return outputFields;
    }

    public static String parseField(String field, String columnName, DataSource ds) throws Exception {
        String columnType = ds.getField(columnName).getType();
        if (columnType == null) {
            columnType = "text";
        }
        if (columnType.equals("date") || columnType.equals("datetime")) {
            field = TabImport.parseDate(field, columnName, columnType, ds);
        } else if (columnName.equals("notes")) {
            field = perl.substitute("s'Entry made by'\\r\\rEntry made by'g", field);
            field = perl.substitute("s'\\\\r\\\\rEntry made by'Entry made by'", field);
        }
        return field;
    }

    public static String parseDate(String field, String columnName, String columnType, DataSource ds) throws Exception {
        if (field.equals("")) {
            return field;
        }
        SimpleDateFormat format = columnType.equals("date") ? new SimpleDateFormat("MM/dd/yyyy") : new SimpleDateFormat("MM/dd/yyyy kk:mm");
        format.setLenient(true);
        Date date = format.parse(field);
        format = columnType.equals("date") ? new SimpleDateFormat(DATE_FORMAT) : new SimpleDateFormat(DATETIME_FORMAT);
        field = format.format(date);
        int pos24 = field.indexOf("24:");
        if (pos24 != -1) {
            field = field.substring(0, pos24) + "00:" + field.substring(pos24 + 3);
        }
        return "$$DATE$$:" + field;
    }
}

