/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.log;

import com.isomorphic.collections.RingBuffer;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public class TransientAsyncAppender
extends AsyncAppender {
    protected int transientBufferSize = 50;
    protected RingBuffer transientBuffer;
    protected Level transientBufferDumpThreshold = Level.FATAL;
    protected Level passthroughThreshold = Level.INFO;

    public TransientAsyncAppender() {
        this.transientBuffer = new RingBuffer(this.transientBufferSize);
    }

    public void setTransientBufferSize(int size) {
        this.transientBufferSize = size;
    }

    public void setTransientBufferDumpThreshold(String level) {
        this.transientBufferDumpThreshold = Level.toLevel((String)level);
    }

    public void setPassthroughThreshold(String level) {
        this.passthroughThreshold = Level.toLevel((String)level);
    }

    private void dumpBuffer() {
        super.append(new LoggingEvent("", (Category)Logger.getLogger((String)((Object)((Object)this)).getClass().getName()), (Priority)this.transientBufferDumpThreshold, (Object)"------TRANSIENT BUFFER DUMP FOLLOWS------", null));
        List bufferContents = this.transientBuffer.toList();
        Iterator e = bufferContents.iterator();
        while (e.hasNext()) {
            super.append((LoggingEvent)e.next());
        }
        super.append(new LoggingEvent("", (Category)Logger.getLogger((String)((Object)((Object)this)).getClass().getName()), (Priority)this.transientBufferDumpThreshold, (Object)"------END TRANSIENT BUFFER DUMP------", null));
    }

    public void append(LoggingEvent event) {
        Level eventLevel = event.getLevel();
        if (eventLevel.isGreaterOrEqual((Priority)this.passthroughThreshold)) {
            super.append(event);
        }
        if (eventLevel.isGreaterOrEqual((Priority)this.transientBufferDumpThreshold)) {
            this.dumpBuffer();
        } else {
            this.transientBuffer.append(event);
        }
    }
}

