/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.datasource.DSField;
import com.isomorphic.sql.DB2Driver;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLTable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DB2iSeriesDriver
extends DB2Driver {
    SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public DB2iSeriesDriver(String dbName) throws Exception {
        super(dbName, null);
        this.init(dbName);
    }

    public DB2iSeriesDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
        this.init(dbName);
    }

    public String getQualifiedSchemaSeparator() {
        if ("system".equals(config.getString((Object)("sql." + this.dbName + ".naming"), "sql"))) {
            return "/";
        }
        return ".";
    }

    public Object transformFieldValue(DSField field, Object obj) {
        if ((obj instanceof String || field != null && "text".equals(field.getType())) && (config.getBoolean((Object)("sql." + this.dbName + ".trimTextFields"), false) || field.getBoolean("trim"))) {
            int c;
            String text = obj.toString();
            if (text.length() == 0 || text.charAt(text.length() - 1) != ' ') {
                return text;
            }
            for (c = text.length(); c > 0 && text.charAt(c - 1) == ' '; --c) {
            }
            return text.substring(0, c);
        }
        return obj;
    }

    public String sqlInTransform(Object value, DSField field, SQLDataSource ds) {
        if ((field != null && "date".equals(field.getType()) || field == null && value instanceof Date) && this.shouldUseSQLDateType(field)) {
            return this.escapeValue(this.isoDateFormat.format((Date)value));
        }
        return super.sqlInTransform(value, field, ds);
    }

    public String getLastSequenceQuery() {
        return "SELECT IDENTITY_VAL_LOCAL() FROM SYSIBM" + this.getQualifiedSchemaSeparator() + "SYSDUMMY1";
    }
}

