/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.sql.SQLConnectionManager;
import com.isomorphic.util.DataTools;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBDataSource
extends Base
implements DataSource {
    protected int loginTimeout = 0;
    protected PrintWriter logWriter = null;
    public String dbName;

    public DBDataSource() {
    }

    public DBDataSource(Map props) {
        this();
        try {
            DataTools.setProperties((Map)props, (Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDbName(String value) {
        this.dbName = value;
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            if (this.dbName.startsWith("config:")) {
                this.dbName = config.getString((Object)this.dbName.substring("config:".length()));
            }
            Connection conn = SQLConnectionManager.getConnection(this.dbName);
            return conn;
        }
        catch (Exception e) {
            this.log.error((Object)"Failure to get connection, rethrowing as SQLException", (Throwable)e);
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger is not supported");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw new SQLException("Failed to unwrap - can't cast " + this.getClass().getName() + " to " + iface.getClass().getName());
        }
    }
}

