/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.messaging;

import com.isomorphic.log.Logger;
import com.isomorphic.messaging.ISCMessage;
import com.isomorphic.messaging.ISCMessageDispatcher;
import com.isomorphic.messaging.ISubscriber;
import com.isomorphic.naming.JNDI;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.ResourceAllocationException;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.rmi.PortableRemoteObject;

public class JMSMessageDispatcher
extends ISCMessageDispatcher
implements ExceptionListener {
    private static Logger log = new Logger(JMSMessageDispatcher.class.getName());
    private static Map<String, TopicSubscriber> topicSubscriberForChannel = Collections.synchronizedMap(new HashMap());
    private static Map<String, QueueReceiver> queueReceiverForChannel = Collections.synchronizedMap(new HashMap());
    private static Map<String, Topic> temporaryTopicForChannel = Collections.synchronizedMap(new HashMap());
    private static Map<String, Queue> temporaryQueueForChannel = Collections.synchronizedMap(new HashMap());
    Context jndiContext;
    TopicConnectionFactory topicConnectionFactory;
    TopicConnection topicConnection;
    TopicSession topicSession;
    QueueConnectionFactory queueConnectionFactory;
    QueueConnection queueConnection;
    QueueSession queueSession;
    boolean existTopicConnection = false;
    boolean existQueueConnection = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect() throws Exception {
        List<String> channels = ISCMessageDispatcher.getAllChannels();
        Map<String, String> selectors = ISCMessageDispatcher.getAllSelectorsForChannels();
        JMSMessageDispatcher jMSMessageDispatcher = this;
        synchronized (jMSMessageDispatcher) {
            block27: {
                if (this.topicSession != null) {
                    try {
                        this.topicSession.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (this.topicConnection != null) {
                    try {
                        this.topicConnection.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (this.queueSession != null) {
                    try {
                        this.queueSession.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (this.queueConnection != null) {
                    try {
                        this.queueConnection.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                String jmsContext = config.getString((Object)"messaging.jms.context", "_container_");
                String jndiPrefix = config.getString((Object)"messaging.jms.jndiPrefix", null);
                String topicConnectionFactoryName = config.getString((Object)"messaging.jms.topicConnectionFactory", "TopicConnectionFactory");
                String queueConnectionFactoryName = config.getString((Object)"messaging.jms.queueConnectionFactory", "QueueConnectionFactory");
                this.jndiContext = JNDI.bindConfiguredContext((String)jmsContext);
                if (jndiPrefix != null && !jndiPrefix.equals("")) {
                    try {
                        this.jndiContext = (Context)this.jndiContext.lookup(jndiPrefix);
                    }
                    catch (Exception e) {
                        log.debug((Object)("Unable to find the context defined in 'jndiPrefix': " + e.getMessage()));
                    }
                }
                try {
                    this.queueConnectionFactory = (QueueConnectionFactory)this.jndiContext.lookup(queueConnectionFactoryName);
                    this.queueConnection = this.queueConnectionFactory.createQueueConnection();
                    this.queueSession = this.queueConnection.createQueueSession(false, 1);
                    try {
                        this.queueConnection.setExceptionListener((ExceptionListener)this);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.queueConnection.start();
                    this.existQueueConnection = true;
                    temporaryQueueForChannel.clear();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.topicConnectionFactory = (TopicConnectionFactory)this.jndiContext.lookup(topicConnectionFactoryName);
                    this.topicConnection = this.topicConnectionFactory.createTopicConnection();
                    this.topicSession = this.topicConnection.createTopicSession(false, 1);
                    try {
                        this.topicConnection.setExceptionListener((ExceptionListener)this);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.topicConnection.start();
                    this.existTopicConnection = true;
                    temporaryTopicForChannel.clear();
                }
                catch (Exception e) {
                    if (this.existQueueConnection) break block27;
                    log.debug((Object)("TopicConnectionFactory and QueueConnectionFactory are unavailable. " + e.getMessage()));
                }
            }
            for (String channel : channels) {
                String selector = selectors.get(channel);
                this.bindToChannel(channel, selector);
            }
        }
    }

    private synchronized void ensureConnected() throws Exception {
        if (this.topicConnection == null && this.queueConnection == null) {
            this.reconnect();
        }
    }

    public synchronized void closeConnection() {
        try {
            if (this.topicConnection != null) {
                this.topicConnection.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            if (this.topicSession != null) {
                this.topicSession.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            if (this.queueConnection != null) {
                this.queueConnection.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            if (this.queueSession != null) {
                this.queueSession.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    private void bindToChannel(final String channel, String selector) throws Exception {
        boolean existQueues;
        block20: {
            existQueues = false;
            if (this.existQueueConnection) {
                try {
                    QueueReceiver queueReceiver;
                    block21: {
                        Queue queue;
                        boolean isTemporaryQueue;
                        block19: {
                            isTemporaryQueue = false;
                            queue = null;
                            try {
                                queue = (Queue)PortableRemoteObject.narrow((Object)this.jndiContext.lookup(channel), Queue.class);
                            }
                            catch (Exception e) {
                                if (this.existTopicConnection) break block19;
                                if (temporaryQueueForChannel.get(channel) == null) {
                                    queue = this.queueSession.createTemporaryQueue();
                                    temporaryQueueForChannel.put(channel, queue);
                                } else {
                                    queue = temporaryQueueForChannel.get(channel);
                                }
                                log.debug((Object)("A 'Temporary Queue' is being used by the channel: " + channel));
                                isTemporaryQueue = true;
                            }
                        }
                        if (queue == null) break block20;
                        queueReceiver = null;
                        try {
                            queueReceiver = selector != null && selector.trim().length() > 0 ? this.queueSession.createReceiver(queue, selector) : this.queueSession.createReceiver(queue);
                        }
                        catch (Exception e) {
                            if (!isTemporaryQueue) break block21;
                            queue = this.queueSession.createTemporaryQueue();
                            temporaryQueueForChannel.put(channel, queue);
                            queueReceiver = selector != null && selector.trim().length() > 0 ? this.queueSession.createReceiver(queue, selector) : this.queueSession.createReceiver(queue);
                        }
                    }
                    queueReceiver.setMessageListener(new MessageListener(){

                        public void onMessage(Message arg0) {
                            log.debug((Object)"Received message from JMS (Queue)");
                            try {
                                ISCMessage iscMessage = JMSMessageDispatcher.this.iscMessage(arg0, channel);
                                JMSMessageDispatcher.this.deliverToLocalSubscribers(iscMessage);
                            }
                            catch (Exception e) {
                                log.error((Object)"Unable to deliver jms message", (Throwable)e);
                            }
                        }
                    });
                    queueReceiverForChannel.put(channel, queueReceiver);
                    existQueues = true;
                }
                catch (Exception isTemporaryQueue) {
                    // empty catch block
                }
            }
        }
        if (this.existTopicConnection && !existQueues) {
            try {
                Topic topic = null;
                try {
                    topic = (Topic)PortableRemoteObject.narrow((Object)this.jndiContext.lookup(channel), Topic.class);
                }
                catch (Exception queue) {
                    // empty catch block
                }
                if (topic == null) {
                    if (temporaryTopicForChannel.get(channel) == null) {
                        topic = this.topicSession.createTemporaryTopic();
                        temporaryTopicForChannel.put(channel, topic);
                    } else {
                        topic = temporaryTopicForChannel.get(channel);
                    }
                    log.debug((Object)("A 'Temporary Topic' is being used by the channel: " + channel));
                }
                TopicSubscriber topicSubscriber = null;
                try {
                    topicSubscriber = this.topicSession.createSubscriber(topic);
                }
                catch (Exception e) {
                    topic = this.topicSession.createTemporaryTopic();
                    temporaryTopicForChannel.put(channel, topic);
                    topicSubscriber = this.topicSession.createSubscriber(topic);
                }
                topicSubscriber.setMessageListener(new MessageListener(){

                    public void onMessage(Message arg0) {
                        log.debug((Object)"Received message from JMS (Topic)");
                        try {
                            ISCMessage iscMessage = JMSMessageDispatcher.this.iscMessage(arg0, channel);
                            JMSMessageDispatcher.this.deliverToLocalSubscribers(iscMessage);
                        }
                        catch (Exception e) {
                            log.error((Object)"Unable to deliver jms message", (Throwable)e);
                        }
                    }
                });
                topicSubscriberForChannel.put(channel, topicSubscriber);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onException(JMSException e) {
        if (e instanceof IllegalStateException || e instanceof InvalidDestinationException || e instanceof MessageEOFException || e instanceof ResourceAllocationException) {
            log.warn((Object)"caught exception", (Throwable)e);
            try {
                this.reconnect();
            }
            catch (Exception ee) {
                log.warn((Object)"Unable to reconnect to JMS", (Throwable)ee);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(ISubscriber s, String channel, String selector) throws Exception {
        super.subscribe(s, channel, selector);
        JMSMessageDispatcher jMSMessageDispatcher = this;
        synchronized (jMSMessageDispatcher) {
            this.ensureConnected();
            if (queueReceiverForChannel.get(channel) != null) {
                return;
            }
            if (topicSubscriberForChannel.get(channel) != null) {
                return;
            }
            this.bindToChannel(channel, selector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(ISubscriber s, String channel) throws Exception {
        super.unsubscribe(s, channel);
        List<ISubscriber> channels = ISCMessageDispatcher.getSubscribersOfChannel(channel);
        if (channels != null && channels.size() > 0) {
            return;
        }
        JMSMessageDispatcher jMSMessageDispatcher = this;
        synchronized (jMSMessageDispatcher) {
            this.ensureConnected();
            if (topicSubscriberForChannel.get(channel) != null) {
                TopicSubscriber topicSubscriber = topicSubscriberForChannel.get(channel);
                topicSubscriber.close();
                this.topicSession.unsubscribe(channel);
                topicSubscriberForChannel.remove(channel);
                temporaryTopicForChannel.remove(channel);
            } else if (queueReceiverForChannel.get(channel) != null) {
                QueueReceiver queueReceiver = queueReceiverForChannel.get(channel);
                queueReceiver.close();
                queueReceiverForChannel.remove(channel);
                temporaryQueueForChannel.remove(channel);
            }
        }
    }

    public void unregister(ISubscriber s) throws Exception {
        List<String> channels = JMSMessageDispatcher.getChannelsOfSubscriber(s);
        if (channels != null) {
            for (String channel : channels) {
                this.unsubscribe(s, channel);
            }
        }
        super.unregister(s);
    }

    public synchronized void deliver(ISCMessage iscMessage) throws Exception {
        this.ensureConnected();
        for (String channel : iscMessage.getTargetChannels()) {
            boolean existQueues = false;
            if (this.existQueueConnection) {
                try {
                    Queue queue = null;
                    boolean queueIsPresent = false;
                    try {
                        queue = (Queue)PortableRemoteObject.narrow((Object)this.jndiContext.lookup(channel), Queue.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (queue != null) {
                        queueIsPresent = true;
                    } else if (!this.existTopicConnection) {
                        this.bindToChannel(channel, null);
                        queue = temporaryQueueForChannel.get(channel);
                        queueIsPresent = true;
                    }
                    if (queueIsPresent) {
                        QueueSender queueSender = this.queueSession.createSender(queue);
                        Message jmsMessage = this.jmsMessage((Serializable)iscMessage.getData(), true);
                        queueSender.send(jmsMessage);
                        queueSender.close();
                        existQueues = true;
                        log.debug((Object)"Delivered message to JMS (Queue)");
                    }
                }
                catch (Exception queue) {
                    // empty catch block
                }
            }
            if (!this.existTopicConnection || existQueues) continue;
            Topic topic = null;
            try {
                topic = (Topic)PortableRemoteObject.narrow((Object)this.jndiContext.lookup(channel), Topic.class);
            }
            catch (Exception queueIsPresent) {
                // empty catch block
            }
            if (topic == null) {
                this.bindToChannel(channel, null);
                topic = temporaryTopicForChannel.get(channel);
            }
            TopicPublisher topicPublisher = this.topicSession.createPublisher(topic);
            Message jmsMessage = this.jmsMessage((Serializable)iscMessage.getData(), false);
            topicPublisher.publish(jmsMessage);
            topicPublisher.close();
            log.debug((Object)"Delivered message to JMS (Topic)");
        }
    }

    public ISCMessage iscMessage(Message jmsMessage) throws Exception {
        String channel = null;
        channel = jmsMessage.getJMSDestination() instanceof Topic ? ((Topic)jmsMessage.getJMSDestination()).getTopicName() : ((Queue)jmsMessage.getJMSDestination()).getQueueName();
        Object data = null;
        if (jmsMessage instanceof BytesMessage) {
            data = "Not Yet Implemented";
        } else if (jmsMessage instanceof MapMessage) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Enumeration e = ((MapMessage)jmsMessage).getMapNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                map.put(key, ((MapMessage)jmsMessage).getObject(key));
            }
            data = map;
        } else if (jmsMessage instanceof ObjectMessage) {
            data = ((ObjectMessage)jmsMessage).getObject();
        } else if (jmsMessage instanceof StreamMessage) {
            data = "Not Yet Implemented";
        } else if (jmsMessage instanceof TextMessage) {
            data = ((TextMessage)jmsMessage).getText();
        }
        log.debug((Object)("Decoded jmsMessage for channel: " + channel + " data"), data);
        return new ISCMessage(channel, data, jmsMessage.getJMSMessageID());
    }

    public ISCMessage iscMessage(Message jmsMessage, String channel) throws Exception {
        Object data = null;
        if (jmsMessage instanceof BytesMessage) {
            data = "Not Yet Implemented";
        } else if (jmsMessage instanceof MapMessage) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Enumeration e = ((MapMessage)jmsMessage).getMapNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                map.put(key, ((MapMessage)jmsMessage).getObject(key));
            }
            data = map;
        } else if (jmsMessage instanceof ObjectMessage) {
            data = ((ObjectMessage)jmsMessage).getObject();
        } else if (jmsMessage instanceof StreamMessage) {
            data = "Not Yet Implemented";
        } else if (jmsMessage instanceof TextMessage) {
            data = ((TextMessage)jmsMessage).getText();
        }
        log.debug((Object)("Decoded jmsMessage for channel: " + channel + " data"), data);
        return new ISCMessage(channel, data, jmsMessage.getJMSMessageID());
    }

    public Message jmsMessage(Serializable payload) throws Exception {
        return this.topicSession.createObjectMessage(payload);
    }

    public Message jmsMessage(Serializable payload, boolean isQueue) throws Exception {
        if (isQueue) {
            return this.queueSession.createObjectMessage(payload);
        }
        return this.topicSession.createObjectMessage(payload);
    }
}

