/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.hibernate;

import com.isomorphic.log.Logger;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.ObjectUtils;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlobUserType
implements UserType {
    private static Logger log = new Logger(BlobUserType.class.getName());

    public Class<InputStream> returnedClass() {
        return InputStream.class;
    }

    public int[] sqlTypes() {
        return new int[]{2004};
    }

    public Object nullSafeGet(ResultSet resultSet, String[] names, Object owner) throws HibernateException, SQLException {
        Object o = Hibernate.BLOB.nullSafeGet(resultSet, names[0]);
        if (o != null) {
            try {
                return ((Blob)o).getBinaryStream();
            }
            catch (Exception e) {
                throw new HibernateException("Failed to get InputStream value from field of type BlobUserType. Actual error: " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object value, int index) throws HibernateException, SQLException {
        Blob b = null;
        try {
            b = Hibernate.createBlob((InputStream)((InputStream)value));
        }
        catch (Exception e) {
            throw new HibernateException("Failed to set InputStream value to field of type BlobUserType. Actual error: " + e.getMessage(), (Throwable)e);
        }
        Hibernate.BLOB.nullSafeSet(preparedStatement, (Object)b, index, null);
    }

    public boolean isMutable() {
        return false;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return ObjectUtils.equals((Object)x, (Object)y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }
}

