/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.util.WebUtils;

public class InternalResourceView
extends AbstractUrlBasedView {
    private boolean alwaysInclude = false;

    public InternalResourceView() {
    }

    public InternalResourceView(String url) {
        super(url);
    }

    public InternalResourceView(String url, boolean alwaysInclude) {
        super(url);
        this.alwaysInclude = alwaysInclude;
    }

    public void setAlwaysInclude(boolean alwaysInclude) {
        this.alwaysInclude = alwaysInclude;
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.exposeModelAsRequestAttributes(model, request);
        this.exposeHelpers(request);
        String dispatcherPath = this.prepareForRendering(request, response);
        RequestDispatcher rd = request.getRequestDispatcher(dispatcherPath);
        if (rd == null) {
            throw new ServletException("Could not get RequestDispatcher for [" + this.getUrl() + "]: check that this file exists within your WAR");
        }
        if (this.useInclude(request, response)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Including resource [" + this.getUrl() + "] in InternalResourceView '" + this.getBeanName() + "'"));
            }
            rd.include((ServletRequest)request, (ServletResponse)response);
        } else {
            this.exposeForwardRequestAttributes(request);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Forwarding to resource [" + this.getUrl() + "] in InternalResourceView '" + this.getBeanName() + "'"));
            }
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected void exposeHelpers(HttpServletRequest request) throws Exception {
    }

    protected String prepareForRendering(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.getUrl();
    }

    protected boolean useInclude(HttpServletRequest request, HttpServletResponse response) {
        return this.alwaysInclude || WebUtils.isIncludeRequest((ServletRequest)request) || response.isCommitted();
    }

    protected void exposeForwardRequestAttributes(HttpServletRequest request) {
        WebUtils.exposeForwardRequestAttributes(request);
    }
}

