/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal;

import com.google.common.base.Throwables;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.openqa.grid.common.SeleniumProtocol;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.DefaultTimeSource;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.internal.listeners.TestSessionListener;
import org.openqa.grid.internal.utils.CapabilityMatcher;

public class TestSlot {
    private static final Logger log = Logger.getLogger(TestSlot.class.getName());
    private final Map<String, Object> capabilities;
    private final RemoteProxy proxy;
    private final SeleniumProtocol protocol;
    private final String path;
    private final CapabilityMatcher matcher;
    private final Lock lock = new ReentrantLock();
    private volatile TestSession currentSession;
    volatile boolean beingReleased = false;
    private boolean showWarning = false;

    public TestSlot(RemoteProxy proxy, SeleniumProtocol protocol, String path, Map<String, Object> capabilities) {
        this.proxy = proxy;
        this.protocol = protocol;
        this.path = path;
        CapabilityMatcher c = proxy.getCapabilityHelper();
        if (c == null) {
            throw new InvalidParameterException("the proxy needs to have a valid capabilityMatcher to support have some test slots attached to it");
        }
        this.matcher = proxy.getCapabilityHelper();
        this.capabilities = capabilities;
    }

    public Map<String, Object> getCapabilities() {
        return Collections.unmodifiableMap(this.capabilities);
    }

    public RemoteProxy getProxy() {
        return this.proxy;
    }

    public TestSession getNewSession(Map<String, Object> desiredCapabilities) {
        try {
            this.lock.lock();
            if (this.currentSession != null) {
                return null;
            }
            if (this.matches(desiredCapabilities)) {
                TestSession session;
                log.info("Trying to create a new session on test slot " + this.capabilities);
                this.currentSession = session = new TestSession(this, desiredCapabilities, new DefaultTimeSource());
                TestSession testSession = session;
                return testSession;
            }
            return null;
        }
        finally {
            this.lock.unlock();
        }
    }

    public SeleniumProtocol getProtocol() {
        return this.protocol;
    }

    public String getPath() {
        return this.path;
    }

    boolean matches(Map<String, Object> desiredCapabilities) {
        return this.matcher.matches(this.capabilities, desiredCapabilities);
    }

    public TestSession getSession() {
        return this.currentSession;
    }

    boolean startReleaseProcess() {
        if (this.currentSession == null) {
            return false;
        }
        try {
            this.lock.lock();
            if (this.beingReleased) {
                return false;
            }
            this.beingReleased = true;
            return true;
        }
        finally {
            this.lock.unlock();
        }
    }

    void finishReleaseProcess() {
        try {
            this.lock.lock();
            this.doFinishRelease();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void doFinishRelease() {
        this.currentSession = null;
        this.beingReleased = false;
    }

    String getInternalKey() {
        return this.currentSession == null ? null : this.currentSession.getInternalKey();
    }

    boolean performAfterSessionEvent() {
        try {
            if (this.proxy instanceof TestSessionListener) {
                if (this.showWarning && this.proxy.getMaxNumberOfConcurrentTestSessions() != 1) {
                    log.warning("WARNING : using a afterSession on a proxy that can support multiple tests is risky.");
                    this.showWarning = false;
                }
                ((TestSessionListener)((Object)this.proxy)).afterSession(this.currentSession);
            }
        }
        catch (Throwable t) {
            log.severe(String.format("Error running afterSession for %s, the test slot is now dead: %s\n%s", this.currentSession, t.getMessage(), Throwables.getStackTraceAsString((Throwable)t)));
            return false;
        }
        return true;
    }

    public String toString() {
        return this.currentSession == null ? "no session" : this.currentSession.toString();
    }

    public URL getRemoteURL() {
        String u = this.getProxy().getRemoteHost() + this.getPath();
        try {
            return new URL(u);
        }
        catch (MalformedURLException malformedURLException) {
            throw new GridException("Configuration error for the node." + u + " isn't a valid URL");
        }
    }
}

