/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.logging.LocalLogs;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.NeedsLocalLogs;
import org.openqa.selenium.logging.profiler.HttpProfilerLogEntry;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionNotFoundException;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.JsonHttpCommandCodec;
import org.openqa.selenium.remote.http.JsonHttpResponseCodec;
import org.openqa.selenium.remote.internal.ApacheHttpClient;

public class HttpCommandExecutor
implements CommandExecutor,
NeedsLocalLogs {
    private static HttpClient.Factory defaultClientFactory;
    private final URL remoteServer;
    private final HttpClient client;
    private final JsonHttpCommandCodec commandCodec;
    private final JsonHttpResponseCodec responseCodec;
    private LocalLogs logs = LocalLogs.getNullLogger();

    public HttpCommandExecutor(URL addressOfRemoteServer) {
        this((Map<String, CommandInfo>)ImmutableMap.of(), addressOfRemoteServer);
    }

    public HttpCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer) {
        this(additionalCommands, addressOfRemoteServer, HttpCommandExecutor.getDefaultClientFactory());
    }

    public HttpCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer, HttpClient.Factory httpClientFactory) {
        try {
            this.remoteServer = addressOfRemoteServer == null ? new URL(System.getProperty("webdriver.remote.server", "http://localhost:4444/wd/hub")) : addressOfRemoteServer;
        }
        catch (MalformedURLException e) {
            throw new WebDriverException(e);
        }
        this.commandCodec = new JsonHttpCommandCodec();
        this.responseCodec = new JsonHttpResponseCodec();
        this.client = httpClientFactory.createClient(this.remoteServer);
        for (Map.Entry<String, CommandInfo> entry : additionalCommands.entrySet()) {
            this.defineCommand(entry.getKey(), entry.getValue());
        }
    }

    private static synchronized HttpClient.Factory getDefaultClientFactory() {
        if (defaultClientFactory == null) {
            defaultClientFactory = new ApacheHttpClient.Factory();
        }
        return defaultClientFactory;
    }

    protected void defineCommand(String commandName, CommandInfo info) {
        Preconditions.checkNotNull((Object)commandName);
        Preconditions.checkNotNull((Object)info);
        this.commandCodec.defineCommand(commandName, info.getMethod(), info.getUrl());
    }

    @Override
    public void setLocalLogs(LocalLogs logs) {
        this.logs = logs;
    }

    private void log(String logType, LogEntry entry) {
        this.logs.addEntry(logType, entry);
    }

    public URL getAddressOfRemoteServer() {
        return this.remoteServer;
    }

    @Override
    public Response execute(Command command) throws IOException {
        if (command.getSessionId() == null) {
            if ("quit".equals(command.getName())) {
                return new Response();
            }
            if (!"getAllSessions".equals(command.getName()) && !"newSession".equals(command.getName())) {
                throw new SessionNotFoundException("Session ID is null. Using WebDriver after calling quit()?");
            }
        }
        HttpRequest httpRequest = this.commandCodec.encode(command);
        try {
            this.log("profiler", new HttpProfilerLogEntry(command.getName(), true));
            HttpResponse httpResponse = this.client.execute(httpRequest, true);
            this.log("profiler", new HttpProfilerLogEntry(command.getName(), false));
            Response response = this.responseCodec.decode(httpResponse);
            if (response.getSessionId() == null && httpResponse.getTargetHost() != null) {
                String sessionId = HttpSessionId.getSessionId(httpResponse.getTargetHost());
                response.setSessionId(sessionId);
            }
            return response;
        }
        catch (UnsupportedCommandException e) {
            if (e.getMessage() == null || "".equals(e.getMessage())) {
                throw new UnsupportedOperationException("No information from server. Command name was: " + command.getName(), e.getCause());
            }
            throw e;
        }
    }
}

